% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{get_taxID}
\alias{get_taxID}
\title{Get taxon ID from a species name or lineage string.}
\usage{
get_taxID(lineage, db, multimatch = "NA")
}
\arguments{
\item{lineage}{A semicolon-delimited lineage string or lineage name.}

\item{db}{a valid taxonomy database (as a data.frame object).
See \code{\link{taxonomy}} for details.}

\item{multimatch}{character, the value to return if the query matches multiple
entries in the database. Accepted values are "NA" (default), and "first"
(the first match).}
}
\value{
The unique taxon database ID (integer).
}
\description{
This function returns the unique taxonomic ID associated with a given
  semicolon-delimited lineage string or taxon,
  by looking up a given taxonomy database.
}
\details{
This function will return NA if the lineage is not found in the
  database or it matches multiple entries.
}
\examples{
data(whale_taxonomy)
get_taxID("Odontoceti", db = whale_taxonomy)
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
