% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ino.R
\name{new_ino}
\alias{new_ino}
\title{Constructor}
\format{
An \code{ino} object is a list of three elements:
\itemize{
\item The \code{prob} element is an object of class \code{prob}.
It defines the optimization problem and is documented in
\code{\link{new_prob}}.
\item The \code{opts} element is an object of class \code{opts}.
It defines the optimizer(s) and is documented in \code{\link{new_opts}}.
\item The \code{runs} element is an object of class \code{runs}.
It is the storage space for the optimization results and documented in
\code{\link{new_runs}}.
}
}
\usage{
new_ino(
  x = list(),
  f = function() {
 },
  npar = integer(),
  global = NULL,
  add = list(),
  mpvs = character(),
  f_name = character(),
  f_target = character(),
  opt = list()
)
}
\arguments{
\item{x}{A list.}

\item{f}{An object of class \code{function}, the function to be optimized.}

\item{npar}{The length of the first argument of \code{f}, i.e. the argument over which
\code{f} is optimized.}

\item{global}{Either \code{NULL} (default) or the point where \code{f} obtains its global
optimum (i.e., a numeric vector of length \code{npar}).}

\item{add}{A list of additional and named arguments to be passed to \code{f}.}

\item{mpvs}{A character vector of the argument names with multiple parameter values.
None per default.}

\item{f_name}{A character, the name of \code{f}.}

\item{f_target}{A character, the name of the first argument of \code{f}.}

\item{opt}{The output of \code{\link{set_optimizer}}, which is an object of class
\code{optimizer}.
Per default, \code{opt = set_optimizer_nlm()}, which specifies the
\code{\link[stats]{nlm}} optimizer.
Can also be a (named) list of multiple \code{optimizer} objects.}
}
\value{
An object of class \code{ino}.
}
\description{
This function constructs an \code{ino} object.
}
\keyword{internal}
