% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Converter.R
\name{ConvertedModel}
\alias{ConvertedModel}
\title{Converted torch-based model}
\usage{
ConvertedModel(modules_list, dtype = "float")
}
\arguments{
\item{modules_list}{A list of all accepted layers created by the 'Converter'
class during initialization.}

\item{dtype}{The data type for all the calculations and defined tensors. Use
either \code{'float'} for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for
\link[torch:torch_dtype]{torch::torch_double}.}
}
\description{
This class stores all layers converted to torch in a module which can be
used like the original model (but torch-based). In addition, it provides
other functions that are useful for interpreting individual predictions or
explaining the entire model. This model is part of the class \link{Converter}
and is the core for all the necessary calculations in the methods provided
in this package.
}
\section{Public fields}{

\describe{
\item{\code{modules_list}}{A list of all accepted layers created by the
'Converter' class during initialization.}
\item{\code{dtype}}{The datatype for all the calculations and defined
tensors. Either \code{'float'} for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for
\link[torch:torch_dtype]{torch::torch_double}}.
}
}

\section{Method \code{forward()}}{


The forward method of the whole model, i.e. it calculates the output
\eqn{y=f(x)} of a given input \eqn{x}. In doing so, all intermediate
values are stored in the individual torch modules from \code{modules_list}.
\subsection{Usage}{

\code{self(x, channels_first = TRUE)}
}

\subsection{Arguments}{

\describe{
\item{\code{x}}{The input torch tensor of dimensions
\emph{(batch_size, dim_in)}.}
\item{\code{channels_first}}{If the input tensor \code{x} is given in the format
'channels first' use \code{TRUE}. Otherwise, if the channels are last,
use \code{FALSE} and the input will be transformed into the format 'channels
first'. Default: \code{TRUE}.}
}
}

\subsection{Return}{

Returns the output of the model with respect to the given inputs with
dimensions \emph{(batch_size, dim_out)}.
}
}

\section{Method \code{update_ref()}}{


This method updates the stored intermediate values in each module from the
list \code{modules_list} when the reference input \code{x_ref} has changed.
\subsection{Usage}{

\code{self$update_ref(x_ref, channels_first = TRUE)}
}

\subsection{Arguments}{

\describe{
\item{\code{x_ref}}{Reference input of the model of dimensions
\emph{(1, dim_in)}.}
\item{\code{channels_first}}{If the reference input tensor \code{x} is given in
the format 'channels first' use \code{TRUE}. Otherwise, if the channels are
last, use \code{FALSE} and the input will be transformed into the format
'channels first'. Default: \code{TRUE}.}
}
}

\subsection{Return}{

Returns the output of the reference input with dimension
\emph{(1, dim_out)} after passing through the model.
}
}

\section{Method \code{set_dtype()}}{


This method changes the data type for all the layers in \code{modules_list}.
Use either \code{'float'} for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for
\link[torch:torch_dtype]{torch::torch_double}.
\subsection{Usage}{

\code{self$set_dtype(dtype)}
}

\subsection{Arguments}{

\describe{
\item{\code{dtype}}{The data type for all the calculations and defined
tensors.}
}
}
}

