% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCrossSection.R
\name{PlotCrossSection}
\alias{PlotCrossSection}
\title{Plot Method for Cross Sections}
\usage{
PlotCrossSection(transect, rs, geo.lays = names(rs), val.lays = NULL,
  wt.lay = NULL, asp = 1, ylim = NULL, max.dev.dim = c(43, 56),
  n = NULL, breaks = NULL, pal = NULL, col = NULL, ylab = NULL,
  unit = NULL, id = c("A", "A'"), labels = NULL,
  explanation = NULL, features = NULL, max.feature.dist = Inf,
  draw.key = TRUE, draw.sep = TRUE, is.categorical = FALSE,
  contour.lines = NULL, bg.col = "#E1E1E1", wt.col = "#FFFFFFD8",
  scale.loc = "bottom", file = NULL)
}
\arguments{
\item{transect}{'SpatialLines'.
Piecewise linear transect line.}

\item{rs}{'RasterStack'.
Collection of \code{RasterLayer} objects with the same extent and resolution.}

\item{geo.lays}{'character'.
Vector of names in \code{rs} that specify the geometry raster layers;
these must be given in decreasing order, that is,
from the upper most (such as land surface) to the lowest (such as a bedrock surface).}

\item{val.lays}{'character'.
Vector of names in \code{rs} that specify the value raster layers (optional).
Values from the first layer are mapped as colors to the area between the first and second geometry layers;
the second layer mapped between the second and third geometry layers, and so on.}

\item{wt.lay}{'character'.
The name in \code{rs} that specifies the water-table raster layer (optional).}

\item{asp}{'numeric'.
\emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,
otherwise, a calculated value based on axes limits is used.}

\item{ylim}{'numeric'.
Vector of length 2 giving the minimum and maximum values for the \emph{y}-axis.}

\item{max.dev.dim}{'numeric'.
Vector of length 2 giving the maximum width and height for the graphics device in picas, respectively.
Where 1 pica is equal to 1/6 of an inch, 4.2333 of a millimetre, or 12 points.
Suggested dimensions for single-column, double-column, and sidetitle figures are
\code{c(21, 56)}, \code{c(43, 56)}, and \code{c(56, 43)}, respectively.
This argument is only applicable when the \code{file} argument is specified.}

\item{n}{'integer'.
Desired number of intervals to partition the range of raster values (optional).}

\item{breaks}{'numeric'.
Vector of break points used to partition the colors representing numeric raster values (optional).}

\item{pal}{'function'.
Color palette to be used to assign colors in the plot.}

\item{col}{'character'.
Vector of colors to be used in the plot.
This argument requires \code{breaks} specification for numeric raster values and overrides any palette function specification.
For numeric values there should be one less color than breaks.
Categorical data require a color for each category.}

\item{ylab}{'character'.
Label for the \emph{y} axis.}

\item{unit}{'character'.
Label for the measurement unit of the \emph{x}- and \emph{y}-axes.}

\item{id}{'character'.
Vector of length 2 giving the labels for the end points of the transect line,
defaults to \emph{A--A'}.}

\item{labels}{'list'.
Describes the location and values of labels in the color key.
This list may include components \code{at} and \code{labels}.}

\item{explanation}{'character'.
Label explaining the raster cell value.}

\item{features}{'SpatialGridDataFrame'.
Point features adjacent to the transect line that are used as reference labels for the upper geometry layer.}

\item{max.feature.dist}{'numeric'.
Maximum distance from a point feature to the transect line,
specified in the units of the \code{rs} projection.}

\item{draw.key}{'logical'.
If true, a color key should be drawn.}

\item{draw.sep}{'logical'.
If true, lines separating geometry layers are drawn.}

\item{is.categorical}{'logical'.
If true, cell values in \code{val.lays} represent categorical data;
otherwise, these data values are assumed continuous.}

\item{contour.lines}{'list'.
If specified, contour lines are drawn.
The contours are described using a list of arguments supplied to the \code{\link[raster]{contour}} function.
Passed arguments include \code{drawlables}, \code{method}, and \code{col}.}

\item{bg.col}{'character'.
Color used for the background of the area below the upper geometry raster layer.}

\item{wt.col}{'character'.
Color used for the water-table line.}

\item{scale.loc}{'character'.
Position of the scale bar in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{file}{'character'.
Name of the output file.
Specifying this argument will start a graphics device driver for producing a
PDF or PNG file format---the file extension determines the format type.
The width and height of the graphics region will be automagically determined and
included with the function's returned values, see "Value" section for details;
these device dimensions can be useful when creating similar map layouts in dynamic reports.}
}
\value{
Used for the side-effect of a new plot generated.
  Returns a 'list' object with the following graphical parameters:
  \describe{
    \item{din}{device dimensions \code{(width, height)}, in inches.}
    \item{usr}{extremes of the coordinates of the plotting region \code{(x1, x2, y1, y2)}.}
    \item{heights}{relative heights on the device \code{(upper, lower)} for the map and color-key plots.}
  }
}
\description{
This function creates a cross-section view of raster data.
A key showing how the colors map to raster values is shown below the map.
The width and height of the graphics region will be automagically determined in some cases.
}
\examples{
m <- datasets::volcano
m <- m[nrow(m):1, ncol(m):1]
x <- seq(from = 2667405, length.out = ncol(m), by = 10)
y <- seq(from = 6478705, length.out = nrow(m), by = 10)
r1 <- raster::raster(m, xmn = min(x), xmx = max(x), ymn = min(y), ymx = max(y),
                     crs = "+init=epsg:27200")
r2 <- min(r1[]) - r1 / 10
r3 <- r1 - r2
rs <- raster::stack(r1, r2, r3)
names(rs) <- c("r1", "r2", "r3")
xy <- rbind(c(2667508, 6479501), c(2667803, 6479214), c(2667508, 6478749))
transect <- sp::SpatialLines(list(sp::Lines(list(sp::Line(xy)), ID = "Transect")),
                             proj4string = raster::crs(rs))
PlotMap(r1, pal = terrain.colors, scale.loc = "top", arrow.loc = "topright",
        shade = list(alpha = 0.3), contour.lines = list(col = "#1F1F1FA6"))
lines(transect)
raster::text(as(transect, "SpatialPoints"), labels = c("A", "BEND", "A'"),
             cex = 0.7, pos = c(3, 4, 1), offset = 0.1, font = 4)

dev.new()
explanation <- "Vertical thickness between layers, in meters."
PlotCrossSection(transect, rs, geo.lays = c("r1", "r2"), val.lays = "r3",
                 ylab = "Elevation", asp = 5, unit = "METERS",
                 explanation = explanation, scale.loc = "bottomright")

val <- PlotCrossSection(transect, rs, geo.lays = c("r1", "r2"), val.lays = "r3",
                        ylab = "Elevation", asp = 5, unit = "METERS",
                        explanation = explanation, file = "Rplots.png")
print(val)

file.remove("Rplots.png")
graphics.off()

}
\seealso{
\code{\link{AddScaleBar}}, \code{\link{AddColorKey}}, \code{\link{ExtractAlongTransect}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
