% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddCertificate.R
\name{AddCertificate}
\alias{AddCertificate}
\title{Add X.509 Certificate}
\usage{
AddCertificate(file, header = NULL)
}
\arguments{
\item{file}{'character'.
Path (or a complete URL) to the file containing the X.509 certificate.}

\item{header}{'character'.
Header line to identify the certificate (optional).}
}
\description{
This function adds a \href{https://en.wikipedia.org/wiki/X.509}{X.509} certificate
to your bundle of certificate authority root certificates (CA bundle).
The X.509 certificate is used to authenticate clients and servers.
And the CA bundle is a file that contains root and intermediate certificates.
}
\note{
This function must be used on Windows and requires access to the \pkg{httr} package.
}
\examples{
# Install the U.S. Department of Interior (DOI) certificate (employees only):
\dontrun{
AddCertificate(file = "http://sslhelp.doi.net/docs/DOIRootCA2.cer",
               header = "DOI Root CA 2")
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
