% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMap.R
\name{PlotMap}
\alias{PlotMap}
\title{Plot Method for Maps}
\usage{
PlotMap(r, p = NULL, ..., layer = 1, att = NULL, n = NULL,
  breaks = NULL, xlim = NULL, ylim = NULL, zlim = NULL, asp = NULL,
  extend.xy = FALSE, extend.z = FALSE, reg.axs = TRUE, dms.tick = FALSE,
  bg.lines = FALSE, bg.image = NULL, bg.image.alpha = 1, pal = NULL,
  col = NULL, max.dev.dim = c(43, 56), labels = NULL, scale.loc = NULL,
  arrow.loc = NULL, explanation = NULL, credit = NULL, shade = NULL,
  contour.lines = NULL, rivers = NULL, lakes = NULL, roads = NULL,
  draw.key = NULL, draw.raster = TRUE, file = NULL, close.file = TRUE,
  useRaster)
}
\arguments{
\item{r}{Raster*, SpatialGridDataFrame, or CRS.
An object that can be converted to a raster layer, or a coordinate reference system (CRS).}

\item{p}{SpatialPointsDataFrame.
Spatial point data to be plotted.}

\item{...}{Graphics parameters to be passed to \code{\link{AddPoints}}.
Unused if \code{p = NULL}.}

\item{layer}{integer.
Layer to extract from if \code{r} is of class RasterStack/Brick or SpatialGridDataFrame.}

\item{att}{integer or character.
The levels attribute to use in the Raster Attribute Table (RAT);
requires \code{r} values of class factor.}

\item{n}{integer.
Desired number of intervals to partition the range of raster values (or \code{zlim} if specified) (optional).}

\item{breaks}{numeric.
Vector of break points used to partition the colors representing numeric raster values (optional).}

\item{xlim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{x}-axis.}

\item{ylim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{y}-axis.}

\item{zlim}{numeric.
Vector of length 2 giving the minimum and maximum raster values for which colors should be plotted.}

\item{asp}{numeric.
The \emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,
otherwise, a calculated value based on axes limits is used.}

\item{extend.xy}{logical.
If true, the spatial limits will be extended to the next tick mark on the axes beyond the grid extent.}

\item{extend.z}{logical.
If true, the raster value limits will be extended to the next tick mark on the color key beyond the measured range.}

\item{reg.axs}{logical.
If true, the spatial data range is extended.}

\item{dms.tick}{logical.
If true and \code{r} is projected, the axes tickmarks are specified in degrees, minutes, and decimal seconds (DMS).}

\item{bg.lines}{logical.
If true, grids or graticules are drawn in back of the raster layer using white lines and a grey background.}

\item{bg.image}{RasterLayer.
An image to drawn in back of the main raster layer \code{r}, image colors derived from vector of gray levels.}

\item{bg.image.alpha}{numeric.
Opacity of the background image from 0 to 1.}

\item{pal}{function.
Color palette to be used to assign colors in the plot, rainbow by default.}

\item{col}{character.
Vector of colors to be used in the plot.
This argument requires \code{breaks} specification for numeric values of \code{r} and
overrides any palette function specification.
For numeric values there should be one less color than breaks.
Factors require a color for each level.}

\item{max.dev.dim}{numeric.
Vector of length 2 giving the maximum width and height for the graphics device in picas, respectively.
Suggested dimensions for single-column, double-column, and sidetitle figures are
\code{c(21, 56)}, \code{c(43, 56)}, and \code{c(56, 43)}, respectively.
This argument is only applicable when the \code{file} argument is specified.}

\item{labels}{list.
Describes the location and values of labels in the color key.
This list may include components \code{at} and \code{labels}.}

\item{scale.loc}{character.
Position of the scale bar:
"bottomleft", "topleft", "topright", or "bottomright" to denote scale location.}

\item{arrow.loc}{character.
Position of the north arrow:
"bottomleft", "topleft", "topright", or "bottomright" to denote arrow location.}

\item{explanation}{character.
Label explaining the raster cell value.}

\item{credit}{character.
Label crediting the base map.}

\item{shade}{list.
If specified, a semi-transparent shade layer is drawn on top of the raster layer.
This layer is described using a list of arguments supplied to \code{raster::hillShade} function.
Passed arguments include \code{"angle"} and \code{"direction"}.
Additional arguments also may be passed that control the vertical aspect ratio
(\code{"z.factor"}) and color opacity (\code{"alpha"}).}

\item{contour.lines}{list.
If specified, contour lines are drawn.
The contours are described using a list of arguments supplied to \code{contour}.
Passed arguments include \code{"drawlables"}, \code{"method"}, and \code{"col"}.}

\item{rivers}{list.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for SpatialLines.
Passed arguments include \code{"x"}, \code{"col"}, and \code{"lwd"}.}

\item{lakes}{list.
If specified, polygons are drawn.
The polygons are described using a list of arguments supplied to the plot method for SpatialPolygons.
Passed arguments include \code{"x"}, \code{"col"}, \code{"border"}, and \code{"lwd"}.
Bitmap images require a regular grid.}

\item{roads}{list.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for SpatialLines.
Passed arguments include \code{"x"}, \code{"col"}, and \code{"lwd"}.}

\item{draw.key}{logical.
If true, a color key should be drawn.}

\item{draw.raster}{logical.
If true, the raster image is drawn.}

\item{file}{character.
Name of the output file.
Specifying this argument will start a graphics device driver for producing a
PDF or PNG file format---the file extension determines the format type.
The width and height of the graphics region will be automagically determined and
included with the function's returned values, see "Value" section for details;
these device dimensions can be useful when creating similar map layouts in dynamic reports.}

\item{close.file}{logical.
If true, the graphics device driver is shut down when the function exits.
Unused if \code{file = NULL}}

\item{useRaster}{logical.
If true, a bitmap raster is used to plot \code{r} instead of using polygons.
If \code{UseRaster} is not specified, raster images are used when the \code{getOption("preferRaster")} is true.}
}
\value{
Used for the side-effect of a new plot generated.
  Returns a \code{list} object with the following graphical parameters:
  \describe{
    \item{din}{device dimensions \code{(width, height)}, in inches.}
    \item{usr}{extremes of the coordinates of the plotting region \code{(x1, x2, y1, y2)}.}
    \item{heights}{relative heights on the device \code{(upper, lower)} for the map and color-key plots.}
  }
}
\description{
This function maps raster and point data.
A key showing how the colors map to raster values is shown below the map.
The width and height of the graphics region will be automagically determined in some cases.
}
\examples{
r <- raster::raster(nrow = 10, ncol = 10, crs = NA)
r[] <- 1L
r[51:100] <- 2L
r[3:6, 1:5] <- 8L
r <- raster::ratify(r)
rat <- raster::levels(r)[[1]]
rat$land.cover <- c("Pine", "Oak", "Meadow")
rat$code <- c(12, 25, 30)
levels(r) <- rat
PlotMap(r, att = "land.cover", col = c("grey", "orange", "purple"))
PlotMap(r, att = "code")

r <- raster::raster(system.file("external/test.grd", package="raster"))
credit <- "Label crediting the map."
explanation <- "Label explaining the raster cell value."
PlotMap(r, scale.loc = "bottomright", dms.tick = TRUE, credit = credit,
        explanation = explanation)
data(meuse, package = "sp")
sp::coordinates(meuse) = ~ x + y
points(meuse)

val <- PlotMap(r, scale.loc = "topleft", dms.tick = TRUE, credit = credit,
               explanation = explanation, file = "Rplots1.pdf")
print(val)

pdf(file = "Rplots2.pdf", width = val$din[1], height = val$din[2])
PlotMap(r, scale.loc = "topleft", dms.tick = TRUE, credit = credit,
        explanation = explanation)
points(meuse)
dev.off()

file.remove(c("Rplots1.pdf", "Rplots2.pdf"))
graphics.off()

}
\seealso{
\code{\link{AddScaleBar}}, \code{\link{AddColorKey}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
