% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_datasets.R
\name{write_datasets}
\alias{write_datasets}
\title{Write Package Datasets}
\usage{
write_datasets(
  package,
  destdir = getwd(),
  formats = NULL,
  gzip = NULL,
  overwrite = TRUE,
  include = NULL,
  exclude = NULL,
  pretty = TRUE,
  full_names = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{package}{'character' string.
Name of a package.}

\item{destdir}{'character' string.
Destination directory to write files, with tilde-expansion performed.}

\item{formats}{'character' vector.
Formats for saving datasets.
Choose from one or more of the following formats:
\code{txt}, \code{json}, \code{csv}, \code{xlsx}, \code{parquet}, \code{geojson}, \code{shp}, and \code{tiff}.
Please refer to the \emph{Details} section for a description of each format.
All file formats are saved to the disk by default.}

\item{gzip}{'character' vector.
File \code{formats} that are eligible for Gzip compression.
At present, it accommodates \code{txt}, \code{json}, and \code{geojson} formats exclusively.}

\item{overwrite}{'logical' flag.
Whether to overwrite an existing file.}

\item{include}{'character' vector.
Names(s) of datasets to include.
By default, a file is created for each package dataset.}

\item{exclude}{'character' vector.
Name(s) of datasets to exclude.
By default, none are excluded.}

\item{pretty}{'logical' flag.
Whether to add indentation, whitespace, and newlines to JSON output (default is \code{TRUE}).
See \code{\link[jsonlite:prettify]{prettify}} function for details.
The tradeoff for human-readable output is a much larger file size.}

\item{full_names}{'logical' flag.
Whether the full paths of the files are returned (default).}

\item{quiet}{'logical' flag.
Whether to suppress printing of debugging information.}
}
\value{
Invisibly returns the output file path(s).
}
\description{
Exports the content of package datasets into non-proprietary, open,
and well-documented standard file formats, enhancing their accessibility for future use.
It supports multiple formats:
CSV,
JSON (requires \code{jsonlite} package),
Arrow Parquet (requires \code{arrow} package),
Excel XLMS (requires \code{writexl} package),
GeoJSON,
Shapefile, and
GeoTIFF.
}
\details{
Different types of datasets are written to various file formats.
For instance, a dataset in the form of a data table (\code{data.frame} class) is exported to
a CSV (\code{csv}), JSON (\code{json}), Parquet (\code{parquet}), and Spreadsheet (\code{xlsx}) file.
A dataset representing simple features (\code{sf} or \code{sfc} class) is exported to
a GeoJSON (\code{geojson}) and Shapefile (\code{shp}) file.
A spatial-raster dataset (\code{SpatRaster} or \code{PackedSpatRaster} class) is exported to
a GeoTIFF (\code{tiff}) file.
Lastly, a coordinate reference system (\code{crs} class) is exported to a text (\code{txt}) file.
}
\examples{
dir <- tempfile("")
write_datasets(
  package = "inldata",
  destdir = dir,
  formats = c("txt", "csv", "json", "geojson"),
  include = c("crs", "dl", "inl"),
  pretty = FALSE,
  quiet = TRUE
)

unlink(dir, recursive = TRUE)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
