% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inl.R
\docType{data}
\name{inl}
\alias{inl}
\title{Idaho National Laboratory Boundary}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{geometry}}{Polygon geometry with a positive area (two-dimensional);
sequence of points that form a closed, non-self-intersecting ring; the first ring denotes the exterior ring,
zero or more subsequent rings denote holes in this exterior ring.}
}
}
\source{
The INL boundary was digitized from 7.5' quads within and in the vicinity of the Idaho
National Laboratory by the U.S. Geological Survey
\href{https://www.usgs.gov/centers/idaho-water-science-center/science/idaho-national-laboratory-project-office}{Idaho National Laboratory Project Office}
The digitized polygons were made into shapefiles and converted into GeoJSON files.
}
\usage{
inl
}
\description{
Geographic limits of the Idaho National Laboratory (\href{https://inl.gov/}{INL}).
The INL is located on the west-central part of the eastern Snake River Plain
and covers an area of approximately 890 square miles.
It was established in 1949 to develop atomic energy, nuclear safety, defense programs,
environmental research, and advanced energy concepts.
}
\examples{
print(inl)

plot(inl, col = "grey")
}
\keyword{datasets}
