% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_site_data.R
\name{tabulate_site_data}
\alias{tabulate_site_data}
\title{Tabulate Site Data}
\usage{
tabulate_site_data(sites, samples, gwl, swm)
}
\arguments{
\item{sites}{'sf' objects.
Descriptive site information, see \code{\link{sites}} dataset for details.}

\item{samples}{'data.frame' table.
Water-quality data records, see \code{\link{samples}} dataset for details.}

\item{gwl}{'data.frame' table.
Groundwater levels, see \code{\link{gwl}} dataset for details.}

\item{swm}{'data.frame' table.
Surface-water measurements, see \code{\link{swm}} dataset for details.}
}
\value{
Summary table with the following columns:
\describe{
\item{\code{network_cd}}{Local monitoring network identifier where
'A' is the aquifer monitoring netowrk,
'P' is the perched-groundwater monitoring network, and
'S' is the surface-water monitoring network.}
\item{\code{site_nm}}{Local monitoring site name.}
\item{\code{site_no}}{Site identifier assigned by the USGS.}
\item{\code{well_depth_va}}{Well depth in feet below land surface,
or the sampling-port depth in feet below land surface for
wells instrumented with a Multilevel Monitoring System.
For surface-water sites, depth is not applicable.}
\item{\code{min_dt}}{Date of first record.}
\item{\code{max_dt}}{Date of last record.}
\item{\code{nmeas}}{Number of measurments recorded at a site.}
\item{\code{nsamples}}{Number of water-quality samples collected from the site.}
\item{\code{nreps}}{Number of replicate samples collected from the site.}
}
}
\description{
Tabulate data collected from sites in the U.S. Geological Survey
monitoring networks at the Idaho National Laboratory and surrounding areas, Idaho.
}
\examples{
d <- tabulate_site_data(sites, samples, gwl, swm)
str(d)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
