% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.from.adjacency.R
\name{incidence.from.adjacency}
\alias{incidence.from.adjacency}
\title{Generates an incidence matrix from an adjacency matrix}
\usage{
incidence.from.adjacency(
  G,
  k = 1,
  p = 1,
  blau.param = c(2, 1, 10),
  maximal = TRUE,
  model = "team",
  class = NULL,
  narrative = TRUE
)
}
\arguments{
\item{G}{A symmetric, binary adjacency matrix of class \code{matrix} or \code{Matrix},
or an undirected, unweighted unipartite graph of class {\link{igraph}}.}

\item{k}{integer: Number of artifacts to generate}

\item{p}{numeric: Tuning parameter for artifacts, 0 <= p <= 1}

\item{blau.param}{vector: Vector of parameters that control blau space (see details)}

\item{maximal}{boolean: Should teams/groups models be seeded with \emph{maximal} cliques?}

\item{model}{string: Generative model, one of c("team", "group", "blau") (see details)}

\item{class}{string: Return object as \code{matrix}, \code{Matrix}, or \code{igraph}. If \code{NULL}, object is returned in the same class as \code{G}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An incidence matrix of class \code{matrix} or \code{Matrix}, or a bipartite graph of class {\link{igraph}}.
}
\description{
\code{incidence.from.adjacency} generates an incidence matrix from an adjacency matrix or network using
a given generative model
}
\details{
Given a unipartite network composed of \emph{i agents} (i.e. nodes) that can be represented by an \emph{i x i} adjacency
matrix, \code{incidence.from.adjacency} generates a random \emph{i x k} incidence matrix that indicates whether agent
\emph{i} is associated with \emph{artifact k}. Generative models differ in how they conceptualize artifacts and how
they associate agents with these artifacts.

The \strong{Team Model} (\code{model == "team"}) mirrors a team formation process, where each artifact represents a new team
formed from the incumbants of a prior team (with probability \code{p}) and newcomers (with probability 1-\code{p}).

The \strong{Group Model} (\code{model == "group"}) mirrors a social group formation process, where each artifact represents
a social group. Group members attempt to recruit non-member friends, who join the group if it would have a
density of at least \code{p}.

The \strong{Blau Space Model} (\code{model == "blau"}) mirrors an organization (the artifact) recruiting members from social
space, where those within the organization's niche join with probability \code{p}, and those outside the niche join
with probability 1-\code{p}. \code{blau.param} is a vector containing three values that control the characteristics of the
blau space. The first value is the space's dimensionality. The second two values are shape parameters of a Beta
distribution that describes niche sizes. The default is a two-dimensional blau space, with organization niche
sizes that are strongly positively skewed (i.e., many specialist organizations, few generalists).
}
\examples{
G <- igraph::erdos.renyi.game(10, .4)
I <- incidence.from.adjacency(G, k = 1000, p = .95,
                              model = "team", narrative = TRUE)
}
\references{
{Neal, Z. P. 2022. The Duality of Networks and Foci: Generative Models of Two-Mode Networks from One-Mode Networks. \emph{arXiv:2204.13670} [cs.SI]. \doi{10.48550/arXiv.2204.13670}}

{Neal, Z. P. 2022. incidentally: An R package to generate incidence matrices and bipartite graphs. \emph{OSF Preprints} \doi{10.31219/osf.io/ectms}}
}
