% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRprep.R
\name{incRprep}
\alias{incRprep}
\title{Data preparation for incubation analysis in incR}
\usage{
incRprep(data, date.name, date.format, timezone, temperature.name)
}
\arguments{
\item{data}{raw data from incubation time series. It must contain a column 
with date and time information for each observation (e.g. "2017-05-01 21:01"). 
The function is written to
handle date and time concatenated in one unique column (see example below).}

\item{date.name}{name of the date and time column}

\item{date.format}{format for date and time column. 
It must be a character object as specified in the function \code{\link{strptime}}.   
\code{\link{incRprep}} assumes that the date and time column contains date and time, 
If date and time are in different columns, please, concatenate them in one
column before running the function.}

\item{timezone}{time zone for time calculations. See \code{\link{strptime}}.
documentation for more details.}

\item{temperature.name}{name of the column storing temperature information.}
}
\value{
The original data frame with additional columns for:
\enumerate{
\item index: a running number identifying every row in the data set.
\item dec_time: time in decimal hours (e.g. "22:30" becomes 22.5). 
\item time: in  'H:M' format.
\item hour: in 'H' format.
\item minute: in 'M' format.
\item date: in  'Y-m-d' format.
\item temp1: difference between the \emph{i}th temperature value and the \emph{i-1} one.
}
}
\description{
Preparing incubation time series for further analysis.
This function takes a data file containing a temporal series of temperature recordings
and adds some the extra variables needed to use
further functions embedded in the incR package. 
It simply accommodates a raw data frame, reformatting date and time columns
automatically.
}
\examples{
# loading example data
data(incubation_rawdata)
new.data <- incRprep (data=incR_rawdata,
                       date.name= "DATE",
                       date.format= "\%d/\%m/\%Y \%H:\%M",
                       timezone="GMT",
                       temperature.name="temperature")
head (new.data, 3)
}
\author{
Pablo Capilla-Lasheras
}
