% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/na.mean.R
\name{na.mean}
\alias{na.mean}
\title{Missing Value Imputation by Mean Value}
\usage{
na.mean(data, option = "mean", na.identifier = NA)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"mean" - take the mean for imputation}
   \item{"median" - take the median for imputation}
   \item{"mode" - take the mode for imputation}
   }}

\item{na.identifier}{Missing Value Identifier.
If another value than NA indicates missing values this can be specified here.
Identifier can be a character string as well as a numeric value. No support for lists or vectors.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Missing value replacement by mean values. Different means like median, mean, mode possible.
}
\details{
Missing values get replaced by overall mean values. The function calculates the mean, median or mode
over all the non-NA values and replaces all NAs with this value. Option 'mode' replaces NAs with the
most frequent value in the time series. If two or more values occur equally frequent, the funtion imputes
with the lower value. That's why 'mode' is not the best option for decimal values.
}
\examples{
#Create Time series with missing values
x <- ts(c(2,3,4,5,6,NA,7,8))

#Perform imputation with the overall mean
na.mean(x)

#Perform imputation with overall median
na.mean(x, option ="median")
}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

