% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imptreeIndex.R
\name{node_imptree}
\alias{node_imptree}
\alias{print.node_imptree}
\title{Classification with Imprecise Probabilities}
\usage{
node_imptree(x, idx = NULL)

\method{print}{node_imptree}(x, ...)
}
\arguments{
\item{x}{An object of class \code{imptree} or \code{node_imptree},
respectively. See details.}

\item{idx}{numeric or integer vector of indices specifying
the sequential node access from the root node.
Numeric values are coerced to integer as
by \code{\link[base]{as.integer}}
(and hence truncated towards zero). \cr
If \code{NULL} the probability information of 
the root node are accessed.}

\item{...}{Further arguments passed to \code{print} methods}
}
\value{
An object of class \code{node_imptree} containing 
information on the properties of the node as a list:
\item{probint}{matrix containing the bounds of the imprecise
probability distribution and the absolute observed frequencies
of the classification variable within the node.}
\item{depth}{The depth of the node with the tree.}
\item{splitter}{The name of the variable used for splitting
as character; \code{NA} if node is a leaf.}
\item{children}{The number of children of the node.}
\item{traindataIdx}{Vector giving the indexes of the 
training data contained within the node}
\item{ipmodel}{List giving details about the used 
imprecise probability model to obatin the credal set:
\describe{
\item{iptype}{used IP model:
\code{"IDM"}, \code{"NPI"} or \code{"NPIapprox"}}
\item{s}{If \code{iptpye == "IDM"} the IDM's parameter 's',
otherwise this list entry is missing}
}}

The printing function returns the
\code{node_imptree} object invisibly.
}
\description{
Access probability information of nodes
}
\details{
This function acceses the properties of a specific node 
of an imprecise tree. 
An existence check on the stored C++ object reference is 
carried out at first. If the reference is not valid the 
original call for \code{"x"} is printed as error.
}
\examples{
data("carEvaluation")

## create a tree with IDM (s=1) to full size
## carEvaluation, leaving the first 10 observations out
ip <- imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  control = list(depth = NULL, minbucket = 1))

## obtain information on the root node
node_imptree(x = ip, idx = NULL)

## obtain information on the 2nd note in the 1st level
node_imptree(x = ip, idx = c(1, 2))

## reference to an invalid index and/or level generates error
\dontrun{
node_imptree(x = ip, idx = c(1,10))  # no 10th node on 1st level
}

}
\seealso{
\code{\link{imptree}}, for global information on 
the generated tree \code{\link{summary.imptree}}
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de}
}
\keyword{tree}
