% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{gridPanel}
\alias{gridPanel}
\title{Create a css grid based HTML tag}
\usage{
gridPanel(
  ...,
  template = NULL,
  areas = NULL,
  rows = NULL,
  columns = NULL,
  gap = NULL,
  align_items = "stretch",
  justify_items = "stretch",
  auto_fill = TRUE,
  breakpoint_system = getBreakpointSystem(),
  id = generateID()
)
}
\arguments{
\item{...}{Tag attributes (named arguments) and child elements (unnamed
arguments or with names used in areas).

Named arguments are treated as additional html attribute
values to the parent tag, unless that name is used in the areas attribute
as a grid area name.

Child elements may include any combination of other tags objects, \link{HTML}
strings, and \link{htmlDependency}s.}

\item{template}{The name of a registered template to use as a base for the
grid, or a template object from \link{gridTemplate}.}

\item{areas}{A list of vectors with area names, or a vector or strings
representing each row of the grid. Each element should contain
the names, per row, of each area of the grid.

Expected values follow the
convention for the \code{grid-template-areas} css attribute.

for example \code{c("area-1 area-1", "area-2 area-3")} and
\verb{list(c("area-1", "area-1"), c(area-2", "area-3"))} are both valid
representations of a 2x2 grid with 3 named areas.

Supports breakpoints.}

\item{rows}{A string of css valid sizes separated by a space. or a vector of
sizes. For example both \code{"1fr 2fr"} or \code{c("1fr", "2fr")} are valid
representations of the same 2 rows grid sizes.

Follows the convention for the \code{grid-template-rows} css attribute.

If not provided the existing space will be split equally accordingly to the
areas defined in areas.

Supports breakpoints.}

\item{columns}{A string of css valid sizes separated by a space. or a vector
of sizes. For example both \code{"1fr 2fr"} or \code{c("1fr", "2fr") }are valid
representations of the same 2 columns grid sizes.

Follows the convention for the \code{grid-template-columns} css attribute.

If not provided the existing space will be split equally accordingly to the
areas defined in areas.

Supports breakpoints.}

\item{gap}{The space between elements in the panel. Controls both the
space between rows and columns.

Accepts a css valid value, or 2 values separated by a space (if using
different values for row and column spacing).

Supports breakpoints.}

\item{align_items}{The cell behavior according to the \code{align-items} css
property. Aligns grid items along the block (column) axis.

Accepts a valid css \code{align-items} value
(\code{start} | \code{end} | \code{center} | \code{stretch}).

Supports breakpoints.}

\item{justify_items}{The cell behavior according to the \code{justify-items} css
property. Aligns grid items along the inline (row) axis.

Accepts a valid css \code{justify-items} value
(\code{start} | \code{end} | \code{center} | \code{stretch}).

Supports breakpoints.}

\item{auto_fill}{Should the panel stretch to fit its parent size (TRUE), or
should its size be based on its children element sizes (FALSE).

Supports breakpoints.}

\item{breakpoint_system}{Breakpoint system to use.}

\item{id}{The parent element id.}
}
\value{
An HTML \link{tagList}.
}
\description{
Creates a HTML tag and automatically generates css style rules based on css
grid, depending on the given arguments. Functionality acts as a way to
generate css grid based HTML containers directly from R without the need
to write any additional css rules directly.
}
\details{
Behaves similar to a normal HTML tag, but provides helping
arguments that simplify the way grid css can be created from shiny.
}
\note{
When creating responsive layouts based on css media rules, some
arguments allow a named list can be passed instead of a single value.

The names in that list can be any of the breakpoints available in
the \code{breakpoint_system} argument.

It is recommended to define the breakpoint system for the application
globally before UI definitions, but the \code{breakpoint_system} in panel
functions allows for more flexibility when reusing components
from other projects.

See \url{https://css-tricks.com/snippets/css/complete-guide-grid/}
for additional details on using css grids.

For a full list of valid HTML attributes check visit
\url{https://www.w3schools.com/tags/ref_attributes.asp}.
}
\seealso{
\link{gridPage}
}
\concept{grid}
\keyword{grid}
\keyword{panel}
