% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_optimal_resolution}
\alias{find_optimal_resolution}
\title{Find Optimal Resolution for Louvain Clustering}
\usage{
find_optimal_resolution(
  graph,
  start_resolution = 0.1,
  end_resolution = 10,
  min_modularity = 0.3,
  target_clusters_range = c(3, 6)
)
}
\arguments{
\item{graph}{An igraph object representing the graph to be clustered.}

\item{start_resolution}{Numeric. The starting resolution for the Louvain algorithm. Default is 0.1.}

\item{end_resolution}{Numeric. The maximum resolution to test. Default is 10.}

\item{min_modularity}{Numeric. The minimum acceptable modularity for valid clusterings. Default is 0.3.}

\item{target_clusters_range}{Numeric vector of length 2. The range of acceptable cluster numbers (inclusive). Default is c(3, 6).}
}
\value{
A list containing:
\item{optimal_resolution}{The resolution that balances modularity and number of clusters.}
\item{best_modularity}{The modularity at the optimal resolution.}
\item{best_clusters}{The number of clusters at the optimal resolution.}
}
\description{
This function finds the optimal resolution for Louvain clustering by iterating over a
range of resolution values, balancing modularity and the number of clusters. The function
aims to find a resolution that produces a reasonable number of clusters while maintaining
high modularity.
}
\details{
The function iterates through different resolutions, performing Louvain clustering at each step,
and records the number of clusters and modularity. It then selects the resolution that provides
a good balance between a reasonable number of clusters and high modularity.
The user can set the desired range for the number of clusters.
}
\examples{
\dontrun{
  # Example usage:
  g <- make_ring(10)  # igraph object representing the graph to be clustered
  result <- find_optimal_resolution(g, start_resolution = 0.1, 
                                   end_resolution = 2, 
                                   min_modularity = 0.4)
  print(result)
}

}
