% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_monthly.R
\name{hydro_monthly}
\alias{hydro_monthly}
\title{Monthly hydrological data}
\usage{
hydro_monthly(year, coords = FALSE, station = NULL,
  col_names = "short", ...)
}
\arguments{
\item{year}{vector of years (e.g., 1966:2000)}

\item{coords}{add coordinates of the stations (logical value TRUE or FALSE)}

\item{station}{name or ID of hydrological station(s).
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\description{
Downloading monthly hydrological data from the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
  monthly <- hydro_monthly(year = 2000)
  head(monthly)
}

}
