% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{watershed}
\alias{watershed}
\title{Compute watershed transform.}
\usage{
watershed(im, priority, fill_lines = TRUE)
}
\arguments{
\item{im}{an image}

\item{priority}{Priority map.}

\item{fill_lines}{Sets if watershed lines must be filled or not.}
}
\description{
The watershed transform is a label propagation algorithm. The value of non-zero pixels will get propagated to their zero-value neighbours. The propagation is controlled by a priority map. See examples.
}
\examples{
#In our initial image we'll place three seeds 
#(non-zero pixels) at various locations, with values 1, 2 and 3. 
#We'll use the watershed algorithm to propagate these values
imd <- function(x,y) imdirac(c(100,100,1,1),x,y)
im <- imd(20,20)+2*imd(40,40)+3*imd(80,80)
layout(t(1:3))
plot(im,main="Seed image")
#Now we build an priority map: neighbours of our seeds 
#should get high priority. 
#We'll use a distance map for that
p <- 1-distance_transform(sign(im),1) 
plot(p,main="Priority map")
watershed(im,p) \%>\% plot(main="Watershed transform")
}
