% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/drawing.R
\name{bucketfill}
\alias{bucketfill}
\title{Bucket fill}
\usage{
bucketfill(im, x, y, z = 1, color, opacity = 1, sigma = 0,
  high_connexity = FALSE)
}
\arguments{
\item{im}{an image}

\item{x}{X-coordinate of the starting point of the region to fill.}

\item{y}{Y-coordinate of the starting point of the region to fill.}

\item{z}{Z-coordinate of the starting point of the region to fill.}

\item{color}{Pointer to spectrum() consecutive values, defining the drawing color. If missing, use value at location (x,y,z)}

\item{opacity}{Opacity of the drawing.}

\item{sigma}{Tolerance concerning neighborhood values.}

\item{high_connexity}{Use 8-connexity (only for 2d images, default FALSE).}
}
\description{
Bucket fill
}
\examples{
#Change the colour of a sail
boats.new <- bucketfill(boats,x=169,y=179,color=c(125,0,125),sigma=20)
layout(t(1:2))
plot(boats,main="Original")
plot(boats.new,main="New sails")
}
\seealso{
bucket_select
}

