% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/imPois.R, R/ztrunc.R
\name{kcpm}
\alias{kcpm}
\alias{kcpm.ztrunc}
\alias{kcpm.ztrunc_t}
\alias{kcpm_m}
\title{Kernel of Imprecise Probability Measure Formulated By Bickis and Lee}
\usage{
kcpm(t, xi2, xi1, xi0, log = FALSE)

kcpm_m(m, xi2, xi1, xi0, log = FALSE)

kcpm.ztrunc(m, xi2, xi1, xi0, ny, log = FALSE)

kcpm.ztrunc_t(t, xi2, xi1, xi0, ny, log = TRUE)
}
\arguments{
\item{t}{random variable}

\item{xi2}{parameter associated with precision}

\item{xi1}{parameter associated with linear combination}

\item{xi0}{parameter associated with effective sample size}

\item{log}{logical; if TRUE (default), a returned value is given in logarithm scale.}

\item{m}{random variable}

\item{ny}{number of observations}
}
\description{
Imprecise probability density function proposed by Bickis and Lee (2014) is defined.  See \sQuote{Details}.
}
\details{
The formal definition of Bickis and Lee's conjugate formulation is
\deqn{e^(-\xi_2\theta^2 + \xi_1\theta - \xi_0\exp(\theta))}
\eqn{\theta} is ranged from \code{-Inf} to \code{Inf}.
}
\author{
Chel Hee Lee \email{chl948@mail.usask.ca}
}
\references{
Lee, C.H. (2014) Imprecise Prior for Imprecise Inference on Poisson Sampling Model, PhD Thesis, Biostatistics Program, University of Saskatchewan
}

