% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees.R
\name{to_prufer}
\alias{to_prufer}
\title{Convert a tree graph to its Prüfer sequence}
\usage{
to_prufer(graph)
}
\arguments{
\item{graph}{The graph to convert to a Prüfer sequence}
}
\value{
The Prüfer sequence of the graph, represented as a numeric vector of
vertex IDs in the sequence.
}
\description{
\code{to_prufer()} converts a tree graph into its Prüfer sequence.
}
\details{
The Prüfer sequence of a tree graph with n labeled vertices is a sequence of
n-2 numbers, constructed as follows. If the graph has more than two vertices,
find a vertex with degree one, remove it from the tree and add the label of
the vertex that it was connected to to the sequence. Repeat until there are
only two vertices in the remaining graph.
}
\examples{

g <- make_tree(13, 3)
to_prufer(g)

}
\seealso{
\code{\link[=make_from_prufer]{make_from_prufer()}} to construct a graph from its
Prüfer sequence

Other trees: 
\code{\link{is_tree}()},
\code{\link{make_from_prufer}()},
\code{\link{sample_spanning_tree}()}
}
\concept{trees}
\keyword{graphs}
