% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{PgivenFcont}
\alias{PgivenFcont}
\title{Present value given Future value [continuous] (Engineering Economics)}
\usage{
PgivenFcont(F, n, r)
}
\arguments{
\item{F}{numeric vector that contains the future value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
PgivenFcont numeric vector that contains the present value(s)
   rounded to 2 decimal places
}
\description{
Compute P given F with interest compounded continuously
}
\details{
P is expressed as

	\deqn{P = Fe^{-rn}}

\describe{
\item{\emph{P}}{the "present equivalent"}
\item{\emph{F}}{the "future equivalent"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{

library("iemisc")

PgivenFcont(1000, 9, 7) # the interest rate is 7\%



}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169.
}
\author{
Irucka Embry
}
