% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{atan2d}
\alias{atan2d}
\title{"Two-argument arc-tangent" (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
atan2d(y, x)
}
\arguments{
\item{y}{A numeric vector containing values in degrees}

\item{x}{A numeric vector containing values in degrees}
}
\value{
The "two-argument arc-tangent" of each element of (\code{y}, \code{x})
        in degrees. Note: "The arc-tangent of two arguments atan2(y, x)
        returns the angle between the x-axis and the vector from the origin
        to (x, y), i.e., for positive arguments atan2(y, x) == atan(y/x)."
        Source: \code{Trig} (base).
}
\description{
Calculates the value of the "two-argument arc-tangent" for each element of
(\code{y}, \code{x}) in degrees in a manner compatible with GNU Octave/MATLAB.
}
\examples{
library(iemisc)

# Examples from GNU Octave atan2d
atan2d (a <- seq(-1, 1, by = 0.1), b <- seq(1, -1, by = -0.1))




}
\references{
John W. Eaton, David Bateman, and Søren Hauberg (2009). \emph{GNU Octave version 3.0.1 manual: a high-level interactive language for numerical computations}. CreateSpace Independent Publishing Platform. ISBN 1441413006, URL \url{http://www.gnu.org/software/octave/doc/interpreter/}. Page 358.
}
\author{
Rik Wehbring (GNU Octave atan2d), Irucka Embry
}
