% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_analysis.R
\name{scenario_analysis}
\alias{scenario_analysis}
\title{A Function to Perform Scenario Analysis for a Generic Model Object.}
\usage{
scenario_analysis(
  parameter_df,
  variable_params = NULL,
  model = NULL,
  sim_fn = NULL,
  summary_fn = NULL,
  cores = 1,
  rerun = FALSE,
  verbose = FALSE,
  by_row = FALSE,
  test = FALSE,
  ...
)
}
\arguments{
\item{parameter_df}{A dataframe of parameter permutations as produced by \code{\link[idmodelr]{generate_parameter_permutations}}.
Using the default options it will save results when run for the first time, and afterwards load them in.}

\item{variable_params}{A character vector containing the names of the parameters that are varied in \code{parameter_df}.}

\item{model}{A model compatible with your \code{sim_fn}.}

\item{sim_fn}{A generic simulation function, with the first argument as the model object,
a \code{params} argument, and a \code{as.data.frame} argument.}

\item{summary_fn}{A function which accepts a single dataframe argument customised to fit with the standard
output of \code{scenario_analysis}  and your \code{simulate_model} function. Defaults to \code{NULL} for which
no summarisation takes place. Warning: If a previous analysis has been saved, changing this option will not
summarise the result. The analysis must be rerun.}

\item{cores}{The number of cores to use for the scenario analysis, defaults to 1.}

\item{rerun}{A logical indicating if the function should be rerun or saved results should be loaded.
Defaults to \code{FALSE}.}

\item{verbose}{Logical (defaults to \code{FALSE}) indicating if progress information should be printed to the console.}

\item{by_row}{Logical (defaults to \code{FALSE}) indicating if inputted parameters should be inputted as a block to \code{sim_fn}
or individually. If \code{TRUE} then function will always return a tibble. Does not currently work with sim_fn that produces
multiple simulations for a single parameter set - for this scenario a block based approach or post processing is required.}

\item{test}{A logical (defaults to \code{FALSE}) if \code{TRUE} function uses multicore functionality regardless
of the number of cores specified.}

\item{...}{Pass additional arguments to sim_fn. Only implemented when a single core is used.}
}
\value{
A tidy dataframe containing simulated model trajectories for each scenario
varied parameter combination. Use `tidyr::unnest`` to examine all simulation results.
}
\description{
This function uses parameter permutations produced by
\code{\link[idmodelr]{generate_parameter_permutations}} to simulate from a supplied model function.
It can be used to examine multiple scenarios, with any number of parameter variations, for multiple samples.
}
\examples{

scenarios <- data.frame(scenario = c("test_1", "test_2"), scenario_param = c(0, 1))
variable_params <-  data.frame(variable = c(0, 0.5, 1))
fixed_params <- c(fixed_1 = 2, fixed_2 = c(1, 3, 4))
sample_params <- c(sample_1 = 2, sample_2 = c(2, 1))

parameter_df <- generate_parameter_permutations(variable_params, fixed_params, sample_params,
                                                excluded_params = c("variable"), scenarios,
                                                parameter_samples = 10)

## set up dummy simulation function (returning an empty dataframe)
dummy_sim_fn <- function(object, inits, params, times, as.data.frame) {
 x <- tibble::tibble()
 return(x)
}

## Set up dummy summary function
dummy_sum_fn <- function(df){
df <- dplyr::mutate(df, summarised_simulations = simulations)

return(df)
}
dummy_model <- function(){}

## Run scenario analysis
scenario_analysis(parameter_df, variable_params = "variable", model = dummy_model,
                  sim_fn = dummy_sim_fn, cores = 1, summary_fn = dummy_sum_fn)
}
