% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_model.R
\name{aggregate_model}
\alias{aggregate_model}
\title{A Function to Apply Multiple Aggregations to Model Output}
\usage{
aggregate_model(
  df,
  aggregate_to = NULL,
  compartments = NULL,
  strat = NULL,
  hold_out_var = NULL,
  id_col = NULL,
  groups = NULL,
  new_var = "incidence",
  total_pop = TRUE,
  summary_var = FALSE,
  test = FALSE
)
}
\arguments{
\item{df}{A dataframe of Model Output.}

\item{aggregate_to}{A character vector or list specifying the aggregation operations to perform on the
model output. Operations are carried out in the order specified. Implemented options are; disease, demographic,
and incidence.}

\item{compartments}{A character vector or list specifying the unique compartments to aggregate. May either be
specified once for all aggregation functions or for each function separately.}

\item{strat}{The number of stratified groups in the model.}

\item{hold_out_var}{A character vector or list specifying the unique compartments that will not be aggregated. May either be
specified once for all aggregation functions or for each function separately. If compartments is set then this argument does
not need to be used.}

\item{id_col}{A character string containing the name of the new id column.}

\item{groups}{A character vector with length equal to the level of stratification.
Used to name the stratified levels.}

\item{new_var}{A character vector specifying the new variable to add when aggregating incidence.}

\item{total_pop}{A logical (defaults to \code{TRUE}) indicating if the total population should be
calculated when summarising the model demographics.}

\item{summary_var}{A logical (defaults to \code{FALSE}), specifying whether to add an additional summary variable across
all stratified levels.}

\item{test, }{Logical defaults to \code{FALSE}. For testing, returns the processed inputs rather than
performing the aggregation.}
}
\value{
An aggregated dataframe.
}
\description{
A Function to Apply Multiple Aggregations to Model Output
}
\examples{
df <- data.frame(A1 = 1, B1 = 1, A2 = 1, B2 = 1, A3 = 1, B3 = 1)
aggregate_model(df, aggregate_to = "incidence",
                compartments = c("A", "B"), strat = 3,
                summary_var = TRUE)
}
\seealso{
aggregate_model aggregate_model_internal combine_to_age_model combine_strat_model_output summarise_var_by_strat
}
