% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_algorithms.R
\name{SeqDB}
\alias{SeqDB}
\title{Sequential modified federov algorithm for MNL model.}
\usage{
SeqDB(des = NULL, cand.set, n.alts, par.draws, prior.covar,
  alt.cte = NULL, no.choice = NULL, weights = NULL,
  parallel = TRUE, reduce = TRUE)
}
\arguments{
\item{des}{A design matrix in which each row is a profile. If alternative
specific constants are present, those should be included as the first
column(s) of the design. Can be generated with \code{\link{Modfed}}}

\item{cand.set}{A numeric matrix in which each row is a possible profile. The
\code{\link{Profiles}} function can be used to generate this.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{par.draws}{A matrix or a list, dependend on \code{alt.cte}.}

\item{prior.covar}{Covariance matrix of the prior distribution.}

\item{alt.cte}{A binary vector indicating for each alternative whether an
alternative specific constant is desired. The default is \code{NULL}.}

\item{no.choice}{An integer indicating the no choice alternative. The default
is \code{NULL}.}

\item{weights}{A vector containing the weights of the draws. Default is
\code{NULL}, See also \code{\link{ImpsampMNL}}.}

\item{parallel}{Logical value indicating whether computations should be done
over multiple cores.}

\item{reduce}{Logical value indicating whether the candidate set should be
reduced or not.}
}
\value{
\item{set}{A matrix representing a DB efficient choice set.}
\item{error}{A numeric value indicating the DB-error of the whole
design.}
}
\description{
Selects the choice set that minimizes the DB-error when added to an initial
design, given (updated) parameter values.
}
\details{
This algorithm is ideally used in an adaptive context. The algorithm will
select the next DB-efficient choice set given parameter values and possible
previously generated choice sets. In an adaptive context these parameter
values are updated after each observed response.

Previously generated choice sets, which together form an initial design, can
be provided in \code{des}. When no design is provided, the algorithm will
select te most efficient choice set based on the fisher information of the
prior covariance matrix \code{prior.covar}.

If \code{alt.cte = NULL}, \code{par.draws} should be a matrix in which each
row is a sample from the multivariate parameter distribution. In case that
\code{alt.cte} is not \code{NULL}, a list containing two matrices should be
provided to \code{par.draws}. The first matrix containing the parameter draws
for the alternative specific parameters. The second matrix containing the
draws for the rest of the parameters.

The list of potential choice sets are created using
\code{\link[gtools]{combinations}}. If \code{reduce} is \code{TRUE},
\code{repeats.allowed = FALSE} and vice versa. Furthermore, the list of
potential choice sets will be screaned in order to select only those choice
sets with a unique information matrix. If no alternative specific constants are used,
\code{reduce} should always be \code{TRUE}. When alternative specific
constants are used \code{reduce} can be \code{TRUE} so that the algorithm
will be faster, but the combinations of constants and profiles will not be
evaluated exhaustively.

The \code{weights} argument can be used when the \code{par.draws} have
weights. This is for example the case when parameter values are updated using
\code{\link{ImpsampMNL}}.

When \code{parallel} is \code{TRUE}, \code{\link[parallel]{detectCores}} will
be used to decide upon the number of available cores. That number minus 1
cores will be used to search for the optimal choice set. For small problems
(6 parameters), \code{parallel = TRUE} can be slower. For larger problems the
computation time will decrease significantly.
}
\examples{
# DB efficient choice set, given a design and parameter draws. 
# Candidate profiles 
cs <- Profiles(lvls = c(3, 3, 3), coding = c("E", "E", "E"))
m <- c(0.3, 0.2, -0.3, -0.2, 1.1, 2.4) # mean (total = 6 parameters).
pc <- diag(length(m)) # covariance matrix
set.seed(123)
sample <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc)
# Initial design.
des <- example_design 
# Efficient choice set to add. 
SeqDB(des = des, cand.set = cs, n.alts = 2, par.draws = sample, 
           prior.covar = pc, parallel = FALSE)

# DB efficient choice set, given parameter draws. 
# with alternative specific constants 
des <- example_design2 
cs <- Profiles(lvls = c(3, 3, 3), coding = c("E", "E", "E"))
ac <- c(1, 1, 0) # Alternative specific constants. 
m <- c(0.3, 0.2, -0.3, -0.2, 1.1, 2.4, 1.8, 1.2) # mean 
pc <- diag(length(m)) # covariance matrix
pos <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc)
sample <- list(pos[ , 1:2], pos[ , 3:8])
# Efficient choice set. 
SeqDB(des = des, cand.set = cs, n.alts = 3, par.draws = sample, alt.cte = ac, 
           prior.covar = pc, parallel = FALSE)
}
\references{
\insertRef{ju}{idefix}
}
