% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{chullsphere}
\alias{chullsphere}
\title{Spherical convex hull}
\usage{
chullsphere(data, center = c(0, 0, 0), method = "centroidprojection",
  param = 200, inner = 10)
}
\arguments{
\item{data}{Numeric matrix, XYZ or longitude-latitude coordinates of the set of points.}

\item{center}{Numeric vector, The center of the sphere in XYZ coordinates (default is 0,0,0).}

\item{method}{Character value, indicating the method to create the spherical convex hulls.}

\item{param}{Single positive integer, indicates the number of divisions in the centroidprojection method. The higher the number, the closer the replacement points are to #'    the centroid.}

\item{inner}{Single positive integer, the number of points inserted between every two points of the spherical centroid. Heavilly impacts the performance.}
}
\value{
Either an XYZ or a long-lat numeric vector.
}
\description{
This function calculates a possible implementation of the spherical convex hull
}
\details{
With the method \code{centroidprojection} the function calls the surfacecentroid() 
function to get the a reference point from the shape. Then all the points are 'projected' 
close to this point using the great circles linking them to the reference point.
Each such great circle will be devided to an equal number of points and the closest
 will replace the original point coordinates in the convex hull algorithm implemented in \code{grDevices::chull()}.
}
\examples{
# generate some random points
allData <- rpsphere(1000)
# select only a subset
points<-allData[allData[,1]>3000,]
chullsphere(points)


}

