% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_support_msm.R
\name{estimate_support_msm}
\alias{estimate_support_msm}
\title{Estimate the support of a general Markov interval-censored Multi-state model without 
loops.}
\usage{
estimate_support_msm(gd, tmat)
}
\arguments{
\item{gd}{A \code{data.frame} with the following named columns
\describe{
  \item{\code{id}:}{Subject idenitifier;}
  \item{\code{state}:}{State at which the subject is observed at \code{time};}
  \item{\code{time}:}{Time at which the subject is observed;}
} The true transition time between states is then interval censored between the times.}

\item{tmat}{A transition matrix as created by \code{transMat}}
}
\value{
TODO
}
\description{
Given a realisation of a multi-state model, estimate the support 
of the different transitions possible in that MSM. The estimation is performed 
by viewing each possible state in a competing risks setting and applying the 
result of Hudgens (2001) to determine the support and left-truncation 
intervals and Hudgens (2005) to check whether a solution is possible.
}
\references{
Michael G. Hudgens, On Nonparametric Maximum Likelihood Estimation with 
Interval Censoring and Left Truncation, Journal of the Royal Statistical Society 
Series B: Statistical Methodology, Volume 67, Issue 4, September 2005, Pages 573-587,
 \doi{10.1111/j.1467-9868.2005.00516.x}

M. G. Hudgens, G. A. Satten, and I. M. Longini, 
Nonparametric Maximum Likelihood Estimation for Competing Risks Survival Data
 Subject to Interval Censoring and Truncation, Biometrics, vol. 57, no. 1, 
 Pages 74-80, March 2001, \doi{10.1111/j.0006-341x.2001.00074.x}
}
