% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{stratcombine}
\alias{stratcombine}
\title{Combine Ichimoku Strategies}
\usage{
stratcombine(s1, s2)
}
\arguments{
\item{s1}{an ichimoku object containing a strategy.}

\item{s2}{an ichimoku object containing a strategy.}
}
\value{
An ichimoku object augmented with the combined strategy.
}
\description{
Create more complex strategies with a rule condition of the form
    'c1 > c2 & c3 > c4' by combining existing strategies with rule conditions
    'c1 > c2' and 'c3 > c4' respectively.
}
\details{
The combined strategy 's1 & s2' means conditions in 's1' and 's2'
    have to be simulateneously met for a trade position to be taken.

    The boolean values showing whether these conditions are met are stored in
    the 'cond' column.

    The stategy summary may be accessed via the summary() function.
}
\section{Further Details}{

    Please refer to the strategies vignette by running:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
strat1 <- strat(cloud, c1 = "close", c2 = "kijun")
strat2 <- strat(cloud, c1 = "cloudBase", c2 = "tenkan")
cstrat <- stratcombine(strat1, strat2)
summary(cstrat)
plot(cstrat)

}
