% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{plot.ichimoku}
\alias{plot.ichimoku}
\title{plot.ichimoku}
\usage{
\method{plot}{ichimoku}(x, i = FALSE, from, to, ticker, theme = "default", gaps = FALSE, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{i}{interactive parametmer set to FALSE by default. Set to TRUE to plot
an interactive rather than a static chart.}

\item{from}{(optional) a starting date/time to subset the plot.}

\item{to}{(optional) an ending date/time to subset the plot.}

\item{ticker}{(optional) specify a ticker, or other text, to include
in the chart heading. If not set, the ticker saved within the ichimoku
object will be used.}

\item{theme}{with a default of 'default'. This can also be set to 'dark' or
'solarized' to select the desired colour scheme.}

\item{gaps}{set to FALSE by default to remove weekend and holiday gaps. Set
to TRUE for a continuous timescale axis, but with gaps for non-trading
days.}

\item{...}{other arguments to be passed along.}
}
\value{
Returns either a ggplot2 object with classes 'gg' and 'ggplot', or a
    plotly object with classes 'plotly' and 'htmlwidget' depending on the
    parameters set.
}
\description{
Plot static or interactive Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function plot() for
    class 'ichimoku'. It can be invoked by calling plot(x) on an object 'x'
    of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

plot(cloud)
plot(cloud, from = "2020-05-15", to = "2020-10-30", theme = "dark")
\donttest{
plot(cloud, i = TRUE, ticker = "TKR Co.", theme = "solarized", gaps = TRUE)
}

}
