% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodeDetail.R
\name{getCodeDetail}
\alias{getCodeDetail}
\title{Get Details}
\usage{
getCodeDetail(code_type, code)
}
\arguments{
\item{code_type}{the code type, e.g. SpecWoRMS.}

\item{code}{the code, e.g. 101170.}
}
\value{
A data frame.
}
\description{
Get details for a given code.
}
\examples{
\dontrun{
# Species code 101170 - Myxine glutinosa
getCodeDetail("SpecWoRMS", 101170)

# find details of Haddock using the aphia ID
findCode("species", "haddock", full = TRUE)

getCodeDetail("SpecWoRMS", 126437)

# get info for had-43
getCodeDetail("ICES_StockCode", "had-34")
}
}
\seealso{
\code{\link{getCodeTypeList}} and \code{\link{getCodeList}} get code types
and codes of a given type.

\code{\link{icesVocab-package}} gives an overview of the package.
}
