% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.data.script.R
\name{draft.data.script}
\alias{draft.data.script}
\title{Draft or create a bootstrap data script}
\usage{
draft.data.script(name, title, description, format, originator, year, period,
  access, content)
}
\arguments{
\item{name}{the name of the dataset and the file name that will be
created.}

\item{title}{description of the data, including survey names or the like.}

\item{description}{a more involved description if required.}

\item{format}{the format of the data produced, e.g. "csv"}

\item{originator}{who prepared the data, e.g. a working group acronym.}

\item{year}{year of the analysis when the data were used. The default is the
current year.}

\item{period}{a numeric vector of the form \code{c(1990, 2000)},
indicating the first and last year that the data cover.
Alternatively, a single number if the data cover only one year.}

\item{access}{data access code: \code{"OSPAR"}, \code{"Public"}, or
\code{"Restricted"}.}

\item{content}{the r code that fetches and saves the data}
}
\description{
Create an \file{R} file to fetch data including adding metadata
via roxygen2 fields to the top of the file.
}
