% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9DecimalToShort}
\alias{icd9DecimalToShort}
\title{convert between icd9 decimal and short formats}
\usage{
icd9DecimalToShort(icd9Decimal, leadingZeroes = TRUE,
  invalidAction = c("ignore", "silent", "warn", "stop"))
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{leadingZeroes}{logical whether to fill out major part with zeroes, or
just truncate to the left. If E code, there is no valid code since
E800-E999 is defined. V codes could be V0x or Vxx, and so could be zero
padded.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
character vector of converted ICD-9 codes
}
\description{
converted decimal ICD9 code, e.g. 123.45 to 'short' e.g. 12345
  non-decimal format
}
\seealso{
Other ICD-9 convert: \code{\link{icd9AddLeadingZeroesMajor}};
  \code{\link{icd9AddLeadingZeroesShort}};
  \code{\link{icd9DropZeroFromDecimal}};
  \code{\link{icd9PartsRecompose}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9PartsToShort}}
}
\keyword{manip}

