% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{combine}
\alias{combine}
\alias{c.icd9}
\alias{c.icd10}
\title{combine ICD codes}
\usage{
\method{c}{icd9}(..., warn = FALSE)

\method{c}{icd10}(..., warn = FALSE)
}
\arguments{
\item{...}{elements to combine}

\item{warn}{single logical value, if TRUE, will give warnings when
incompatible types are combined using \code{c}}
}
\description{
These function implement combination of lists or vectors of codes, while
preserving ICD classes. Base R \code{c} just drops all user defined classes
and casts down to lowest common denominator, e.g. if mixing numbers and
characters. No attempt here to catch all possible combinations of feeding in
mixed ICD types and other types. Let R do what it normally does, but just try
to keep classes of the first item in the list.
}
\examples{
# Care with the following:
c(as.icd9("E998"), as.icd10("A10"))
# which results in both codes sharing the 'icd9' class.
}
