% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{icd_is_valid}
\alias{icd_is_valid}
\alias{icd_is_valid.icd10}
\alias{icd_is_valid.icd9}
\alias{icd_is_valid.icd_comorbidity_map}
\title{Check whether ICD-9 codes are syntactically valid}
\usage{
icd_is_valid(x, ...)

\method{icd_is_valid}{icd10}(x, short_code = icd_guess_short(x),
  whitespace_ok = TRUE, ...)

\method{icd_is_valid}{icd9}(x, short_code = icd_guess_short(x),
  whitespace_ok = TRUE, ...)

\method{icd_is_valid}{icd_comorbidity_map}(x, short_code, ...)
}
\arguments{
\item{x}{An ICD-9 or 10 code. If the class is set to \code{'icd9'},
\code{'icd10'}, \code{'icd10cm'} etc then perform appropriate validation.}

\item{...}{arguments passed on to other functions}

\item{whitespace_ok}{Single logical, if \code{TRUE}, the default, matches for
ICD codes will accept leading and trailing white space.}

\item{major}{character vector of 'major' part of ICD-9 codes, i.e. that part
which falls before the decimal point, in decimal notation. (In five digit
notation, the 'major' part is be the first three characters (with leading
zeroes), and includes V or E prefix.}
}
\value{
logical vector with \code{TRUE} or \code{FALSE} for each ICD code
  provided according to its validity
}
\description{
This does not check whether the code corresponds to a real ICD-9-CM billing
code, or parent grouping. For that, see \code{\link{icd_is_defined}}.
}
\details{
Factors are accepted, and since the validation is done with \code{grepl}
these are handled correctly.

Currently, there is a limitation on NA values. Calling with \code{NA} (which
is a logical vector of length one by default) fails, because it is not a
string. This is rarely of significance in real life, since the NA will be
part of a character vector of codes, and will therefore be cast already to
\code{NA_character}

\code{NA} values result in a return value of \code{FALSE}.

Leading zeroes in the decimal form are not ambiguous. Although
  integer ICD-9 codes could be intended by the user, there is a difference
  between 100, 100.0, 100.00. Therefore a warning is given if a numeric value
  is provided.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd10}: Test whether generic ICD-10 code is valid

\item \code{icd9}: Test whether generic ICD-10 code is valid

\item \code{icd_comorbidity_map}: Validate a mapping of ICD codes to comorbidities.
}}
\section{Three-digit validation}{
 \code{icd9_is_valid_major} validates just
  the 'major' three-digit part of an ICD-9 code. This can in fact be provided
  as a numeric, since there is no ambiguity. Numeric-only codes should be one
  to three digits, V codes are followed by one or two digits, and E codes
  always by three digits between 800 and 999.
}

\section{Class}{
 S3 class of on object in R is just a vector. Attributes are
  lost with manipulation, with the exception of class: therefore, elements of
  the class vector are used to describe features of the data. If these are
  not present, the user may specify (e.g. decimal vs short_code type, ICD-9
  vs ICD-10 WHO), but if they are, the correct functions are called without
  any guess work. There is overlap between sets with combinations of
  \code{short_code} or \code{decimal_code}, and ICD-9 or ICD-10 codes, so
  guessing is never going to be perfect.
}
\examples{
  icd_is_valid(as.icd9(c("", "1", "22", "333", "4444", "123.45", "V",
                     "V2", "V34", "V567", "E", "E1", "E70", "E")))
  # internal function:
  \dontrun{
  icd:::icd_is_valid_major(c("", "1", "22", "333", "4444", "123.45", "V",
                     "V2", "V34", "V567", "E", "E1", "E70", "E"))
  }
}
\seealso{
\url{http://www.stata.com/users/wgould/icd9/icd9.hlp}
  \url{http://www.sascommunity.org/wiki/Validate_the_format_of_ICD-9_codes}
}
\keyword{internal}

