% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calmarFunctions.R
\name{marginStats}
\alias{marginStats}
\title{Stats for initial weights, calibrated weights, and margins.}
\usage{
marginStats(data, marginMatrix, pct = FALSE, popTotal = NULL, colWeights,
  colCalibratedWeights = NULL, calibThreshold = 1)
}
\arguments{
\item{data}{dataframe containing the survey data}

\item{marginMatrix}{matrix of margins}

\item{pct}{Set this to true if margins for categorical variables are written in percentages}

\item{popTotal}{total of population, useful if margins are entered in relative value}

\item{colWeights}{name of weights column in the dataframe}

\item{colCalibratedWeights}{name of calibrated weights column in the dataframe (if applicable)}

\item{calibThreshold}{If difference between calibration estimate and margin differ more than
this parameter, calibration is considered to have failed}
}
\value{
Dataframe containing stats on weights and margins
}
\description{
Just like \code{\link{calibrationMarginStats}}, gives stats about the calibration process: 
differences between totals after/before calibration and margins. Totals for categorical
variables are displayed in percentages. The last column, named "difference", shows
the difference (in percentage points) between initial estimates and margins (if colCalibratedWeights is NULL) 
or between calibrated estimates and margins (if colCalibratedWeights is not NULL).
Output is a dataframe, which might be more convenient to export than a list
(e.g. for integration into reports).
}
\seealso{
\code{\link{calibrationMarginStats}}
}
\keyword{description,}
\keyword{results}
\keyword{statistics,}
\keyword{stats,}

