% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetricsPCA.R
\name{getMetricsPCA}
\alias{getMetricsPCA}
\title{Performance Measures with PCA pre-processing}
\usage{
getMetricsPCA(yhat, y, classtype, model)
}
\arguments{
\item{yhat}{expression. The vector of predicted values.}

\item{y}{expression. The class variable.}

\item{classtype}{character or numeric. The number of levels in \code{y}.}

\item{model}{expression. The model object to which output of the model has been assigned.}
}
\value{
Outputs an object with performance measures calculated from the confusion matrix given by the \code{caret} package. A data frame is the resulting output with the first column giving the name of the performance measure, and the second column giving the corresponding value.
}
\description{
getMetricsPCA allows to obtain performance measures from Confusion Matrix for algorithms with PCA pre-processing,it returns a data frame containing performance measures from the confusion matrix given by the \code{caret} package when algorithms have been run with PCA pre-processing.
}
\details{
Works with target variables that have two, three, four, six or eight classes. Similar to \code{\link[icardaFIGSr]{getMetrics}} but used in the case where models have been run with PCA specified as an option for the \code{preProcess} argument in the \code{train} function of \code{caret}.
}
\examples{
if(interactive()){
 # Obtain predictions from several previously run models
 dataX <- subset(data, select = -y)
 pred.knn <- predict(model.knn, newdata = dataX)
 pred.rf <- predict(model.rf, newdata = dataX)

 # Get metrics for several algorithms
 metrics.knn <- getMetricsPCA(y = data$y, yhat = pred.knn,
                              classtype = 2, model = model.knn)
 metrics.rf <- getMetricsPCA(y = data$y, yhat = pred.rf,
                             classtype = 2, model = model.rf)

 # Indexing for 2-class models to remove extra column with
 # names of performance measures
 metrics.all <- cbind(metrics.knn, metrics.rf[ , 2])

 # No indexing needed for 3-, 4-, 6- or 8-class models
 metrics.all <- cbind(metrics.knn, metrics.rf)
 }
}
\seealso{
\code{\link[caret]{confusionMatrix}},
 \code{\link[caret]{predict.train}}
}
\author{
Khadija Aziz, Zainab Azough, Zakaria Kehel, Bancy Ngatia
}
