% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{process.custom.config.matrix}
\alias{process.custom.config.matrix}
\title{Process a custom configuration matrix.}
\usage{
process.custom.config.matrix(S, center = TRUE, mod.rv = TRUE)
}
\arguments{
\item{S}{A configuration matrix.}

\item{center}{Should the configuration matrix be centered using kernel centering?}

\item{mod.rv}{Should the configuration matrix be prepared for the modified RV coefficient?}
}
\value{
The processed configuration matrix.
}
\description{
This function can be used to process a custom-made configuration matrix (i.e. similarity matrix) for use with the RV coefficient.
The function can perform two tasks: centering and preparation for the modified RV coefficient, both of which we will briefly explain here.
}
\details{
The RV coefficient often results in values very close to one when both datasets are not centered around zero, even for orthogonal data.
For inner product similarity and Jaccard similarity, we recommend using centering. However, for some other similarity measures, centering
may not be beneficial (for example, because the measure itself is already centered, such as in the case of Pearson correlation). For more information on
centering of binary (and other non-continuous) data, for which we used kernel centering of the configuration matrix, we refer to our manuscript: Aben et al., 2018, doi.org/10.1101/293993.

The modified RV coefficient was proposed for high-dimensional data, as the regular RV coefficient would result in values close to one even for
orthogonal data. We recommend always using the modified RV coefficient.
}
\examples{
set.seed(2)
n = 100
p = 100
x = matrix(rnorm(n*p)+10, n, p)
S = x\%*\%t(x)
S_dash = process.custom.config.matrix(S, center=TRUE, mod.rv=TRUE)
}
