% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eSample.r
\name{eSample}
\alias{eSample}
\title{R function to perform environmental systematic sampling}
\usage{
eSample(envData,nExpect,plot=TRUE,saveShape=TRUE,nf,lowerLim,upperLim)
}
\arguments{
\item{envData}{Either a SpatilPixelsDataFrame or a SpatialGridDataFrame as defined in package sp or a RasterStack or RasterBrick as defined in package raster. Note that this object can contain a mixture of variables type (quantitative, factor and ordered)}

\item{nExpect}{Numeric number of desired sampling points. Note that sometime the exact expected number can not be reached because this function tries to find a grid that best matches the expected number}

\item{plot}{A logic indicating whether or not you would like to have a graphical representation of the environmental systematic sampling (default=TRUE)}

\item{saveShape}{A logic indcating whether or not you want to save the geographical coordinates of the pixels corresponding to this environmental systematic sampling as a shapefile format (default=TRUE). The generated shapefile will be saved in your working directory}

\item{nf}{A numeric value indicating the number of ordination axes retained in the analysis, this function manages currently only 2 or 3 dimentions}

\item{lowerLim}{Numeric value of probability in [0,1] that can be used to produce sample quantiles corresponding to the given lower limit probability. This may be used to reduce the effect of extremes observations}

\item{upperLim}{Numeric value of probability in [0,1] that can be used to produce sample quantiles corresponding to the given upper limit probability. This may be used to reduce the effect of extremes observations}
}
\value{
Returns a list containing 4 objects: GeoSamples (The geographical coordinates of the pixels corresponding to the environmental systematic sampling ); EnvSamples(The coordinates in the reduced environmental space of pixels corresponding to the environmental systematic sampling ); EnvGrid (The coordinates of the grid in the reduced environmental space)
}
\description{
R function to perform environmental systematic sampling
}
\details{
The environmental systematic sampling consists in reducing the environmental space into 2 or 3 dimensions using an ordination method (the dudi.mixt method in ade4 package) as a first step. Thereafter convex hull will be created around the reduced environmental space. Then, a multidimensional grid will be created inside the convex hull. The obtained grid represents the perfect configuration required to adequately survey the environmental space. The last step is subsequently to seek the closest pixel to this ideal configuration. This is achieved by searching the nearest neighbour between each grid point and each pixel in the environmental space based on Euclidean distances
}
\examples{
\dontrun{
library(raster)
envData<-getData('worldclim', var='bio', res=10)
envData<-crop(envData,extent(-10,45,20,75))
plot(envData)
par(mfrow=c(1,2))
Mysampling1<-eSample(envData,nExpect=50,plot=TRUE,
saveShape=TRUE,nf=2,lowerLim=0.00001,upperLim=0.99999)
plot(envData[[1]])
plot(Mysampling1[[1]],add=TRUE,col=2,pch=19)
par(mfrow=c(1,2))
Mysampling2<-eSample(envData,nExpect=50,plot=TRUE,
saveShape=TRUE,nf=2,lowerLim=0.1,upperLim=0.9)
plot(envData[[1]])
plot(Mysampling2[[1]],add=TRUE,col=2,pch=19)
Mysampling3<-eSample(envData,nExpect=50,plot=TRUE,
saveShape=TRUE,nf=3,lowerLim=0.001,upperLim=0.999)
plot(envData[[1]])
plot(Mysampling3[[1]],add=TRUE,col=2)
}
}
\references{
Tarek Hattab, Carol Ximena Garzon Lopez, Michael Ewald, Sandra Skowronek, Raf Aerts, Helene Horen, Boris Brasseur, Emilie Gallet-Moron, Fabien Spicher, Guillaume Decocq, Hannes Feilhauer, Olivier Honnay, Pieter Kempeneers, Sebastian Schmidtlein, Ben Somers, Ruben Van De Kerchove, Duccio Rocchini and Jonathan Lenoir (2017). A unified framework to model the potential and realized distributions of invasive species within the invaded range. Diversity and Distributions. DOI: 10.1111/ddi.12566
}
\seealso{
<http://diarsproject.github.io/DIARS/SamplingDesign.html>
}
