% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePD.R
\name{estimatePD}
\alias{estimatePD}
\title{Compute phylogenetic diversity with a particular of sample size/coverage}
\usage{
estimatePD(x, labels, phy, datatype = "abundance", base = "size",
  level = NULL, conf = 0.95, digits = 4)
}
\arguments{
\item{x}{a \code{data.frame} or \code{list} of species abundances or incidence frequencies.\cr 
If \code{datatype = "incidence"}, then the first entry of the input data must be total number of sampling units, followed 
by species incidence frequencies in each column or list.}

\item{labels}{species names for object x}

\item{phy}{a phylog objcet for input phylo-tree}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{base}{comparison base: sample-size-based (\code{base="size"}) or coverage-based \cr (\code{base="coverage"}).}

\item{level}{an integer specifying a particular sample size or a number (between 0 and 1) specifying a particular value of sample coverage. 
If \code{base="size"} and \code{level=NULL}, then this function computes the diversity estimates for the minimum sample size among all sites. 
If \code{base="coverage"} and \code{level=NULL}, then this function computes the diversity estimates for the minimum sample coverage among all sites.}

\item{conf}{a positive number < 1 specifying the level of confidence interval, default is 0.95. Remove C.I. by setting conf=NULL.}

\item{digits}{integer indicating the number of decimal places \code{round} to be used.}
}
\value{
a \code{data.frame} of phylogenetic diversity table including the sample size, sample coverage,
method (rarefaction or extrapolation), and diversity estimates with q = 0, 1, and 2 for the user-specified sample size or sample coverage.
}
\description{
\code{estimatePD}: computes phylogenetic diversity (Hill numbers with q = 0, 1 and 2) with a particular user-specified level of sample size or sample coverage.
}
\examples{
data(bird)
bird.abu <- bird$abun
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
estimatePD(bird.abu, bird.lab, bird.phy, "abundance", base="size", level=NULL, conf=NULL)
\dontrun{
estimatePD(bird.abu, bird.lab, bird.phy, "abundance", base="size", level=NULL)
}
}

