/*
 * Decompiled with CFR 0.152.
 */
package roemetz.core;

import java.io.IOException;
import java.util.Arrays;
import mrmc.core.CovMRMC;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.Matrix;
import mrmc.gui.SizePanel;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL1024;

public class SimRoeMetz {
    private DBRecord DBRecordStat;
    private InputFile InputFileStat;
    private SizePanel sizePanel1;
    private String[][] observerData;
    RandomStream RandomStreamI;
    RandomVariateGen gaussRV;
    private int Nnormal;
    private int Ndisease;
    private int Nreader;
    private double[] scoreMeans;
    private double[] scoreVariances;
    private double[][] tA0;
    private double[][] tB0;
    private double[][] tA1;
    private double[][] tB1;
    private int[][] dA0;
    private int[][] dB0;
    private int[][] dA1;
    private int[][] dB1;
    private double[] auc;
    private double[][] BDG;
    private double[][] BCK;
    private double[][] DBM;
    private double[][] OR;
    private double[][] MS;

    public SimRoeMetz(double[] tempScoreMeans, double[] tempScoreVar, RandomStream RandomStream0, SizePanel sizePanel1Temp) throws IOException {
        this.sizePanel1 = sizePanel1Temp;
        if (tempScoreMeans.length != 2) {
            System.out.println("input scoreMeans is of incorrect size");
            return;
        }
        if (tempScoreVar.length != 18) {
            System.out.println("input tempScoreVar is of incorrect size");
            return;
        }
        this.scoreMeans = tempScoreMeans;
        this.scoreVariances = tempScoreVar;
        this.Nreader = Integer.parseInt(sizePanel1Temp.NreaderJTextField.getText());
        this.Nnormal = Integer.parseInt(sizePanel1Temp.NnormalJTextField.getText());
        this.Ndisease = Integer.parseInt(sizePanel1Temp.NdiseaseJTextField.getText());
        CovMRMC covMRMC = new CovMRMC(this.sizePanel1);
        int nrows = this.Nnormal + this.Ndisease;
        this.dA0 = new int[this.Nreader][this.Nnormal];
        this.dB0 = new int[this.Nreader][this.Nnormal];
        this.dA1 = new int[this.Nreader][this.Ndisease];
        this.dB1 = new int[this.Nreader][this.Ndisease];
        int r = 0;
        while (r < this.Nreader) {
            int i = 0;
            while (i < this.Nnormal) {
                this.dA0[r][i] = covMRMC.d0_modAA[i][r][0];
                this.dB0[r][i] = covMRMC.d0_modBB[i][r][0];
                nrows += this.dA0[r][i] + this.dB0[r][i];
                ++i;
            }
            int j = 0;
            while (j < this.Ndisease) {
                this.dA1[r][j] = covMRMC.d1_modAA[j][r][0];
                this.dB1[r][j] = covMRMC.d1_modBB[j][r][0];
                nrows += this.dA1[r][j] + this.dB1[r][j];
                ++j;
            }
            ++r;
        }
        this.InputFileStat = new InputFile();
        this.InputFileStat.observerData = new String[nrows][4];
        this.RandomStreamI = RandomStream0;
        this.gaussRV = new NormalGen(this.RandomStreamI);
        System.out.print("ThreadName:" + Thread.currentThread().getName() + ":");
        int j = 0;
        while (j < 5) {
            System.out.print(String.valueOf(this.RandomStreamI.nextInt(1, 100)) + ",");
            ++j;
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        try {
            SizePanel sizePanel1 = new SizePanel();
            double[] u = new double[2];
            String[] us = args[0].substring(args[0].lastIndexOf("[") + 1, args[0].indexOf("]")).split(",");
            if (us.length != 2) {
                System.out.println("Expected input u to contain 2 elements");
                return;
            }
            u = new double[]{Double.parseDouble(us[0]), Double.parseDouble(us[1])};
            double[] var_t = new double[18];
            String[] var_ts = args[1].substring(args[1].indexOf("[") + 1, args[1].indexOf("]")).split(",");
            if (var_ts.length != 18) {
                System.out.println("Expected input var_t to contain 18 elements");
                return;
            }
            int i = 0;
            while (i < var_ts.length) {
                var_t[i] = Double.parseDouble(var_ts[i]);
                ++i;
            }
            String[] ns = args[2].substring(args[2].indexOf("[") + 1, args[2].indexOf("]")).split(",");
            if (ns.length != 3) {
                System.out.println("Expected input n to contain 3 elements");
                return;
            }
            int Nnormal = Integer.parseInt(ns[0]);
            int Ndisease = Integer.parseInt(ns[1]);
            int Nreader = Integer.parseInt(ns[2]);
            sizePanel1.NreaderJTextField.setText(String.valueOf(Nreader));
            sizePanel1.NnormalJTextField.setText(String.valueOf(Nnormal));
            sizePanel1.NdiseaseJTextField.setText(String.valueOf(Ndisease));
            int[] nArray = new int[32];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArray[9] = 9;
            nArray[10] = 10;
            nArray[11] = 11;
            nArray[12] = 12;
            nArray[13] = 13;
            nArray[14] = 14;
            nArray[15] = 15;
            nArray[16] = 16;
            nArray[17] = 17;
            nArray[18] = 18;
            nArray[19] = 19;
            nArray[20] = 20;
            nArray[21] = 21;
            nArray[22] = 22;
            nArray[23] = 23;
            nArray[24] = 24;
            nArray[25] = 25;
            nArray[26] = 26;
            nArray[27] = 27;
            nArray[28] = 28;
            nArray[29] = 29;
            nArray[30] = 30;
            nArray[31] = 31;
            int[] seedIntArr32 = nArray;
            WELL1024.setPackageSeed(seedIntArr32);
            WELL1024 RandomStreamI = new WELL1024();
            SimRoeMetz exp = new SimRoeMetz(u, var_t, RandomStreamI, sizePanel1);
            exp.printResults();
        }
        catch (NumberFormatException e) {
            System.out.println("Incorrectly Formatted Input");
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Missing Arguments");
            System.out.println("Format is: SimRoeMetz [u0,u1] [R00,C00,RC00,R10,C10,RC10,R01,C01,RC01,R11,C11,RC11,R0,C0,RC0,R1,C1,RC1] [Nnormal,Ndisease,Nreader] sNreaderd useMLE");
            e.printStackTrace();
        }
    }

    private void printResults() {
        System.out.println("BDG:");
        Matrix.printMatrix(this.BDG);
        System.out.println();
        System.out.println("AUCs:");
        Matrix.printVector(this.auc);
        System.out.println();
    }

    public void doSim(DBRecord tempDBRecord) throws IOException {
        this.DBRecordStat = tempDBRecord;
        this.observerData = this.InputFileStat.observerData;
        double[] RA0 = this.fillGaussian(Math.sqrt(this.scoreVariances[0]), this.Nreader);
        double[] CA0 = this.fillGaussian(Math.sqrt(this.scoreVariances[1]), this.Nnormal);
        double[][] RCA0 = this.fillGaussian(Math.sqrt(this.scoreVariances[2]), this.Nreader, this.Nnormal);
        double[] RA1 = this.fillGaussian(Math.sqrt(this.scoreVariances[3]), this.Nreader);
        double[] CA1 = this.fillGaussian(Math.sqrt(this.scoreVariances[4]), this.Ndisease);
        double[][] RCA1 = this.fillGaussian(Math.sqrt(this.scoreVariances[5]), this.Nreader, this.Ndisease);
        double[] RB0 = this.fillGaussian(Math.sqrt(this.scoreVariances[6]), this.Nreader);
        double[] CB0 = this.fillGaussian(Math.sqrt(this.scoreVariances[7]), this.Nnormal);
        double[][] RCB0 = this.fillGaussian(Math.sqrt(this.scoreVariances[8]), this.Nreader, this.Nnormal);
        double[] RB1 = this.fillGaussian(Math.sqrt(this.scoreVariances[9]), this.Nreader);
        double[] CB1 = this.fillGaussian(Math.sqrt(this.scoreVariances[10]), this.Ndisease);
        double[][] RCB1 = this.fillGaussian(Math.sqrt(this.scoreVariances[11]), this.Nreader, this.Ndisease);
        double[] R0 = this.fillGaussian(Math.sqrt(this.scoreVariances[12]), this.Nreader);
        double[] C0 = this.fillGaussian(Math.sqrt(this.scoreVariances[13]), this.Nnormal);
        double[][] RC0 = this.fillGaussian(Math.sqrt(this.scoreVariances[14]), this.Nreader, this.Nnormal);
        double[] R1 = this.fillGaussian(Math.sqrt(this.scoreVariances[15]), this.Nreader);
        double[] C1 = this.fillGaussian(Math.sqrt(this.scoreVariances[16]), this.Ndisease);
        double[][] RC1 = this.fillGaussian(Math.sqrt(this.scoreVariances[17]), this.Nreader, this.Ndisease);
        this.tA0 = new double[this.Nreader][this.Nnormal];
        this.tB0 = new double[this.Nreader][this.Nnormal];
        this.tA1 = new double[this.Nreader][this.Ndisease];
        this.tB1 = new double[this.Nreader][this.Ndisease];
        int i = 0;
        while (i < this.Nreader) {
            Arrays.fill(this.tA1[i], this.scoreMeans[0]);
            Arrays.fill(this.tB1[i], this.scoreMeans[1]);
            ++i;
        }
        int irow = 0;
        int normalID = 0;
        while (normalID < this.Nnormal) {
            this.observerData[irow][0] = "truth";
            this.observerData[irow][1] = "normal" + String.format("%06d", normalID);
            this.observerData[irow][2] = "truth";
            this.observerData[irow][3] = Integer.toString(0);
            ++irow;
            ++normalID;
        }
        int diseaseID = 0;
        while (diseaseID < this.Ndisease) {
            this.observerData[irow][0] = "truth";
            this.observerData[irow][1] = "disease" + String.format("%06d", diseaseID);
            this.observerData[irow][2] = "truth";
            this.observerData[irow][3] = Integer.toString(1);
            ++irow;
            ++diseaseID;
        }
        int readerID = 0;
        while (readerID < this.Nreader) {
            int normalID2 = 0;
            while (normalID2 < this.Nnormal) {
                if (this.dA0[readerID][normalID2] == 1) {
                    double[] dArray = this.tA0[readerID];
                    int n = normalID2;
                    dArray[n] = dArray[n] + (R0[readerID] + C0[normalID2] + RA0[readerID] + CA0[normalID2] + RC0[readerID][normalID2] + RCA0[readerID][normalID2]);
                    this.observerData[irow][0] = "reader" + String.format("%03d", readerID);
                    this.observerData[irow][1] = "normal" + String.format("%06d", normalID2);
                    this.observerData[irow][2] = this.DBRecordStat.modalityA;
                    this.observerData[irow][3] = Double.toString(this.tA0[readerID][normalID2]);
                    ++irow;
                }
                if (this.dB0[readerID][normalID2] == 1) {
                    double[] dArray = this.tB0[readerID];
                    int n = normalID2;
                    dArray[n] = dArray[n] + (R0[readerID] + C0[normalID2] + RB0[readerID] + CB0[normalID2] + RC0[readerID][normalID2] + RCB0[readerID][normalID2]);
                    this.observerData[irow][0] = "reader" + String.format("%03d", readerID);
                    this.observerData[irow][1] = "normal" + String.format("%06d", normalID2);
                    this.observerData[irow][2] = this.DBRecordStat.modalityB;
                    this.observerData[irow][3] = Double.toString(this.tB0[readerID][normalID2]);
                    ++irow;
                }
                ++normalID2;
            }
            int diseaseID2 = 0;
            while (diseaseID2 < this.Ndisease) {
                if (this.dA1[readerID][diseaseID2] == 1) {
                    double[] dArray = this.tA1[readerID];
                    int n = diseaseID2;
                    dArray[n] = dArray[n] + (R1[readerID] + C1[diseaseID2] + RA1[readerID] + CA1[diseaseID2] + RC1[readerID][diseaseID2] + RCA1[readerID][diseaseID2]);
                    this.observerData[irow][0] = "reader" + String.format("%03d", readerID);
                    this.observerData[irow][1] = "disease" + String.format("%06d", diseaseID2);
                    this.observerData[irow][2] = this.DBRecordStat.modalityA;
                    this.observerData[irow][3] = Double.toString(this.tA1[readerID][diseaseID2]);
                    ++irow;
                }
                if (this.dB1[readerID][diseaseID2] == 1) {
                    double[] dArray = this.tB1[readerID];
                    int n = diseaseID2;
                    dArray[n] = dArray[n] + (R1[readerID] + C1[diseaseID2] + RB1[readerID] + CB1[diseaseID2] + RC1[readerID][diseaseID2] + RCB1[readerID][diseaseID2]);
                    this.observerData[irow][0] = "reader" + String.format("%03d", readerID);
                    this.observerData[irow][1] = "disease" + String.format("%06d", diseaseID2);
                    this.observerData[irow][2] = this.DBRecordStat.modalityB;
                    this.observerData[irow][3] = Double.toString(this.tB1[readerID][diseaseID2]);
                    ++irow;
                }
                ++diseaseID2;
            }
            ++readerID;
        }
        boolean VerboseFalse = false;
        boolean DisplayWarning = false;
        this.InputFileStat.resetIDs();
        this.InputFileStat.verifySizesAndGetIDs(VerboseFalse, DisplayWarning);
        this.InputFileStat.processScoresAndTruth(VerboseFalse);
        this.DBRecordStat.DBRecordStatFill(this.InputFileStat, this.DBRecordStat);
    }

    public double[] fillGaussian(double scalar, long Nreader2) {
        double[] toReturn = new double[(int)Nreader2];
        int i = 0;
        while ((long)i < Nreader2) {
            toReturn[i] = scalar * this.gaussRV.nextDouble();
            if (Double.isInfinite(toReturn[i])) {
                toReturn[i] = scalar * this.gaussRV.nextDouble();
            }
            ++i;
        }
        return toReturn;
    }

    public double[][] fillGaussian(double scalar, long Nreader2, long Nnormal2) {
        double[][] toReturn = new double[(int)Nreader2][(int)Nnormal2];
        int i = 0;
        while ((long)i < Nreader2) {
            int j = 0;
            while ((long)j < Nnormal2) {
                toReturn[i][j] = scalar * this.gaussRV.nextDouble();
                if (Double.isInfinite(toReturn[i][j])) {
                    toReturn[i][j] = scalar * this.gaussRV.nextDouble();
                }
                ++j;
            }
            ++i;
        }
        return toReturn;
    }
}

