% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_gentime.R
\name{gentime}
\alias{gentime}
\title{Generating Irregularly spaced times}
\usage{
gentime(x, ...)
}
\arguments{
\item{x}{An object of class `utilities`.}

\item{...}{Additional arguments for generating time points: 
\describe{
   \item{n}{A positive integer. Length of observation times.}
   \item{distribution}{A character string specifying the distribution of the observation times. Default is `"expmixture"`.
Available options are:
- `"expmixture"`: A mixture of two exponential distributions.
- `"uniform"`: A uniform distribution.
- `"exponential"`: A single exponential distribution.
- `"gamma"`: A gamma distribution.}
   \item{lambda1}{Mean (1/rate) of the exponential distribution or the first exponential distribution in a mixture of exponential distributions. Default is `130`.}
   \item{lambda2}{Mean (1/rate) of the second exponential distribution in a mixture of exponential distributions. Default is `6.5`.}
   \item{p1}{Weight of the first exponential distribution in a mixture of exponential distributions. Default is `0.15`.}
   \item{p2}{Weight of the second exponential distribution in a mixture of exponential distributions. Default is `0.85`.}
   \item{a}{Shape parameter of a gamma distribution or lower limit of the uniform distribution. Default is `0`.}
   \item{b}{Scale parameter of a gamma distribution or upper limit of the uniform distribution. Default is `1`.}
}}
}
\value{
An updated `utilities` object with the generated observation times stored in the `times` slot.
}
\description{
A method for generating time points based on a statistical distribution.
The results are stored in the `times` slot of the `utilities` object.
}
\examples{
set.seed(12917)
o1=iAR::utilities()
o1<-gentime(o1, n=200, distribution = "expmixture", lambda1 = 130, 
lambda2 = 6.5,p1 = 0.15, p2 = 0.85)
st=o1@times
mean(diff(st))

o1=iAR::utilities()
o1<-gentime(o1, n=200, distribution = "expmixture", lambda1 = 15, 
lambda2 = 2.5,p1 = 0.15, p2 = 0.85)
st=o1@times
mean(diff(st))

}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
