% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARtsample.R
\name{IARt.sample}
\alias{IARt.sample}
\title{Simulate from an IAR-T Model}
\usage{
IARt.sample(n, phi, st, sigma2 = 1, nu = 3)
}
\arguments{
\item{n}{Length of the output time series. A strictly positive integer.}

\item{phi}{A coefficient of IAR-T model. A value between 0 and 1.}

\item{st}{Array with observational times.}

\item{sigma2}{Scale parameter of the IAR-T process. A positive value.}

\item{nu}{degrees of freedom.}
}
\value{
A list with the following components:
\itemize{
\item{y}{ Array with simulated IAR-t process.}
\item{st}{ Array with observation times.}
}
}
\description{
Simulates an IAR-T Time Series Model.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARt.sample(n,0.9,st,sigma2=1,nu=3)
plot(st,y$y,type='l')
hist(y$y,breaks=20)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}
}
