% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{ratio}
\alias{ratio}
\title{RATIO - Flow Ratio (Metric 5)}
\usage{
ratio(x, event_type)
}
\arguments{
\item{x}{Data frame (time series) from an event with equal flow trend. The
data frame must contain a date-time column (\code{Time}) and a flow rate
column (\code{Q}) and must be in a compatible format.
(see \code{\link[=flow]{flow()}}).}

\item{event_type}{Numeric value which specifies the event type. See
\code{\link[=get_events]{get_events()}} for an overview of the event types.}
}
\value{
Returns a numeric value which is the flow ratio computed by
    \code{max(x$Q)} divided by \code{min(x$Q)}. If a data frame containing
    \code{NA} flow rates (\code{Q}) is given, \code{NA} is returned.
}
\description{
The metric flow ratio (RATIO) is defined as the flow maximum
    divided by the flow minimum, \eqn{\frac{Q_{max}}{Q_{min}}}.
Given an event with equal flow trend, the flow ratio is computed and returned.
}
\examples{
data(Q)
Q <- flow(Q[3:4, ])
ratio(Q, event_type(Q))
}
