% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_cells}
\alias{merge_cells}
\title{Merge a range of cells}
\usage{
merge_cells(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}
}
\value{
The \code{ht} object.
}
\description{
\code{merge_cells()} merges a rectangle of cells into a single displayed cell,
by setting \code{\link[=colspan]{colspan()}} and \code{\link[=rowspan]{rowspan()}}.
}
\details{
\code{merge_cells(ht, c(min_row, max_row), c(min_col, max_col))} is equivalent to\preformatted{  colspan(ht)[min_row, min_col] <- max_col - min_col + 1
  rowspan(ht)[min_row, min_col] <- max_row - min_row + 1
}
}
\examples{

ht <- hux(a = 1:3, b = 1:3)
ht <- set_all_borders(ht, 1)
merge_cells(ht, 2:3, 1:2)

}
\seealso{
Other cell merging: 
\code{\link{merge_across}()},
\code{\link{merge_repeated_rows}()}
}
\concept{cell merging}
