% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf.R
\name{print_rtf}
\alias{print_rtf}
\alias{to_rtf}
\alias{to_rtf.huxtable}
\title{Create RTF representing a huxtable}
\usage{
print_rtf(ht, fc_tables = rtf_fc_tables(ht), ...)

to_rtf(ht, ...)

\method{to_rtf}{huxtable}(ht, fc_tables = rtf_fc_tables(ht), ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{fc_tables}{See \code{\link[=rtf_fc_tables]{rtf_fc_tables()}}.}

\item{...}{Arguments to pass to methods.}
}
\value{
\code{to_rtf} returns a string representing an RTF table. The \code{fc_tables} attribute of the
returned string will contain the \code{fc_tables} object that was passed in (or autocreated).
\code{print_rtf} prints the string and returns \code{NULL}.
}
\description{
These functions print or return an RTF character string.
}
\details{
RTF files use a single per-document table for colors, and one for fonts. If you are printing
multiple huxtables in a document, you need to make sure that the font and color table is
set up correctly and that the RTF tables refer back to them. See \code{\link[=rtf_fc_tables]{rtf_fc_tables()}}.
\enumerate{
\item Prepare all the huxtables;
\item Call \code{\link[=rtf_fc_tables]{rtf_fc_tables()}}, passing in all the huxtables;
\item Print the \code{rtfFCTables} object in the RTF document header;
\item Pass in the \code{rtfFCTables} object to each call to \code{print_rtf}.
}
}
\section{Limitations}{

\itemize{
\item rmarkdown"s \code{rtf_document} can"t yet print out customized color tables, so
custom fonts and colors won"t work in this context.
\item \code{\link[=col_width]{col_width()}} and \code{\link[=width]{width()}} can only be numeric or "pt".
\item \code{\link[=wrap]{wrap()}} has no effect: cell contents always wrap.
\item \code{\link[=rotation]{rotation()}} can only be 90 or 270, i.e. text going up or down.
}
}

\examples{

print_rtf(jams)
}
\seealso{
Other printing functions: 
\code{\link{print_html}()},
\code{\link{print_latex}()},
\code{\link{print_md}()},
\code{\link{print_screen}()}
}
\concept{printing functions}
