% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-functions.R
\name{quick-output}
\alias{quick-output}
\alias{quick_latex}
\alias{quick_pdf}
\alias{quick_html}
\alias{quick_docx}
\alias{quick_pptx}
\alias{quick_xlsx}
\alias{quick_rtf}
\title{Quickly print objects to a PDF, TeX, HTML, Microsoft Office or RTF document}
\usage{
quick_latex(
  ...,
  file = confirm("huxtable-output.tex"),
  borders = 0.4,
  open = interactive()
)

quick_pdf(
  ...,
  file = confirm("huxtable-output.pdf"),
  borders = 0.4,
  open = interactive(),
  width = NULL,
  height = NULL
)

quick_html(
  ...,
  file = confirm("huxtable-output.html"),
  borders = 0.4,
  open = interactive()
)

quick_docx(
  ...,
  file = confirm("huxtable-output.docx"),
  borders = 0.4,
  open = interactive()
)

quick_pptx(
  ...,
  file = confirm("huxtable-output.pptx"),
  borders = 0.4,
  open = interactive()
)

quick_xlsx(
  ...,
  file = confirm("huxtable-output.xlsx"),
  borders = 0.4,
  open = interactive()
)

quick_rtf(
  ...,
  file = confirm("huxtable-output.rtf"),
  borders = 0.4,
  open = interactive()
)
}
\arguments{
\item{...}{One or more huxtables or R objects with an \code{as_huxtable} method.}

\item{file}{File path for the output.}

\item{borders}{Border width for members of \code{...} that are not huxtables.}

\item{open}{Logical. Automatically open the resulting file?}

\item{width}{String passed to the LaTeX \code{geometry} package"s \code{paperwidth} option. Use \code{NULL} for
the default width.}

\item{height}{String passed to \code{geometry}"s \code{paperheight} option. Use \code{NULL} for the default
height.}
}
\value{
Invisible \code{NULL}.
}
\description{
These functions use huxtable to print objects to an output document. They are useful
as one-liners for data reporting.
}
\details{
Objects in \code{...} will be converted to huxtables, with borders added.

If \sQuote{file} is not specified, the command will fail in non-interactive sessions. In
interactive sessions, the default file path is "huxtable-output.xxx" in the working directory;
if this already exists, you will be asked to confirm manually before proceeding.
}
\examples{
\dontrun{
  m <- matrix(1:4, 2, 2)

  quick_pdf(m, jams)
  quick_latex(m, jams)
  quick_html(m, jams)
  quick_docx(m, jams)
  quick_xlsx(m, jams)
  quick_pptx(m, jams)
  quick_rtf(m, jams)
}
}
