% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical3s.R
\name{logical3s}
\alias{logical3s}
\alias{and3s}
\alias{or3s}
\title{Complex logical expressions}
\usage{
and3s(
  exprA,
  exprB,
  exprC,
  ...,
  .parent_nframes = 1L,
  nThread = getOption("hutilscpp.nThread", 1L)
)

or3s(
  exprA,
  exprB,
  exprC,
  ...,
  .parent_nframes = 1L,
  nThread = getOption("hutilscpp.nThread", 1L)
)
}
\arguments{
\item{exprA, exprB, exprC, ...}{Expressions of the form \code{x <op> y}.
with \code{<op>} one of the standard binary operators.

Only \code{exprA} is required, all following expressions are optional.}

\item{.parent_nframes}{\describe{
\item{\code{integer(1)}}{For internal use. Passed to \code{eval.parent}.}
}}

\item{nThread}{\describe{
\item{\code{integer(1)}}{Number of threads to use.}
}}
}
\value{
\code{and3s} and \code{or3s} return \code{exprA & exprB & exprC} and
\code{exprA | exprB | exprC} respectively. If any expression is missing
it is considered \code{TRUE} for \code{and3s} and \code{FALSE} for \code{or3s};
in other words only the results of the other expressions count towards the result.
}
\description{
Performant implementations of \code{&} et \code{or}.
Performance is high when the expressions are long (i.e. over 10M elements)
and in particular when they are of the form \code{lhs <op> rhs} for binary
\code{<op>}.
}
