test_that("is_lgl_sym works", {
  A <- 1L
  expect_false(is_lgl_sym(A))
  expect_false(is_lgl_sym(A == 1L))
  B <- A == 1L
  expect_true(B)
})

test_that("A in len>100 ", {
  A <-
    c(-945028649L, -705457251L, 807204080L, 1708708214L, -885957403L,
      1862209884L, 1740762002L, 1546012157L, -1233491410L, 1256036667L,
      1009745233L, -815497191L, 137228285L, 2012907335L, -314954938L,
      -1234120580L, 2138414482L, 2089828880L, -1494606089L, 1669541061L,
      -1635694586L, 913293496L, 657757461L)
  A <- rep_len(A, 101)
  B <- c(-705457251L, 1:1000)
  D <- rep(TRUE, length(B))
  E <- rep(TRUE, length(B))

  band3 <- function(x, y, z, ...) if (missing(..1)) ((x & y) & z) else band3(x & y, z, ...)
  expect_equal(and3s(B %in% A, D, E),
               band3(B %in% A, D, E))
  expect_equal(and3s(D, B %in% A, D, E),
               band3(D, B %in% A, D, E))
  expect_equal(and3s(D, E, B %in% A, D, E),
               band3(D, E, B %in% A, D, E))
  expect_equal(and3s(D, E, E, B %in% A, D, E),
               band3(D, E, E, B %in% A, D, E))

})


test_that("and3s works", {
  skip_if_not_installed("magrittr")
  skip_if_not_installed("hutils")
  skip_if_not_installed("data.table")
  library(data.table)
  library(hutils)
  band3 <- function(exprA, exprB, exprC) {
    if (missing(exprC) && missing(exprB)) {
      return(exprA)
    }
    if (missing(exprC)) {
      return(exprA & exprB)
    }
    if (missing(exprB)) {
      return(exprA & exprC)
    }
    (exprA & exprB) & exprC
  }


  library(magrittr)
  #
  gen_one_expr <- function(lhs = "", op = "", val = 1L, In_As_Between = FALSE) {
    if (op == "") {
      return(paste0("logi_", lhs))
    }
    if (op == "!") {
      return(paste0("!", paste0("logi_", lhs)))
    }
    switch(op,
           "%between%" = paste(lhs, "%between% c(-1L, 1L)"),
           "%in%" = paste(lhs, "%in%",
                          if (In_As_Between) {
                            "1:4"
                          } else {
                            "c(4L, -3L, 2L, 7L, 8L)"
                          }),
           paste(lhs, op, val))
  }


  DT <-
    CJ(Op1 = c("", "!", "!=", "==", ">=", "<=", ">", "<", "%in%", "%between%"),
       Op2 = c("", "!", "!=", "==", ">=", "<=", ">", "<", "%in%", "%between%"),
       Op3 = c("", "!", "!=", "==", ">=", "<=", ">", "<", "%in%", "%between%"),
       In_As_Between = c(FALSE, TRUE),
       e2 = c(FALSE, TRUE),
       e3 = c(FALSE, TRUE),
       val = c("0L", "1L", "9L")) %>%
    .[implies(In_As_Between, Op1 == "%in%" | Op2 == "%in%" | Op3 == "%in%")]

  i2letters <- function(I) {
    out <- character(length(I))

    M <- matrix(0L, byrow = FALSE, ncol = ceiling(log(length(I), 26L)), nrow = length(I))

    M[, 1] <- rep_len(1:26, length(I))
    for (j in 2:ncol(M)) {
      eachj <- 26 ^ (j - 1L)
      if (eachj > length(I)) {
        break
      }
      M[, j] <- rep_len(rep(0:25, each = eachj), length(I))
    }

    M2 <- matrix("", ncol = ncol(M), nrow = nrow(M))

    for (j in 1:ncol(M2)) {
      M2[, ncol(M2) - j + 1] <- hutils::if_else(M[, j] > 0L, c("", letters)[M[, j] + 1L], "")
    }

    for (i in seq_along(out)) {
      out[i] <- paste0(M2[i, ], collapse = "")
    }
    out

  }

  DT[, ii := .I]
  DT[, lhs1 := i2letters(ii)]
  DT[lhs1 %in% c("for", "if", "else", "repeat", "in", "next", "break"), lhs1 := toupper(lhs1)]
  DT[, lhs2 := samp(letters, size = .N)]
  DT[, lhs3 := samp(letters, size = .N)]
  #
  # DT[, ii := .I]
  DT[, expr_one   := gen_one_expr(lhs1, Op1, val = val, In_As_Between = In_As_Between), by = "ii"]
  DT[, expr_two   := gen_one_expr(lhs2, Op2, val = val, In_As_Between = In_As_Between), by = "ii"]
  DT[, expr_three := gen_one_expr(lhs3, Op3, val = val, In_As_Between = In_As_Between), by = "ii"]

  DT[, the_expr := paste0("exp_eq(",
                          paste0("and3s(",
                                 expr_one, ", ",
                                 if_else(e2, expr_two, ""), ", ",
                                 if_else(e3, expr_three, ""), ")"),
                          ",\n",
                          paste0("band3(",
                                 expr_one, ", ",
                                 if_else(e2, expr_two, ""), ", ",
                                 if_else(e3, expr_three, ""), ")"),
                          ")")]

  generate_int <- function() rep_len(samp(-15:101, size = 99), 231)
  generate_lgl <- function() rep_len(hutils::samp(c(TRUE, FALSE), size = 20, loud = FALSE), 231)

  for (tmp__0 in unique(c(DT[["lhs1"]], DT[["lhs2"]], DT[["lhs3"]], letters))) {
      assign(paste0("logi_", tmp__0), value = generate_lgl())
      assign(tmp__0, value = generate_int())
  }

  # cat(DT[["the_expr"]], sep = "\n", file = "temp.R")

  exp_eq <- testthat::expect_equal

  exp_eq(and3s(logi_a, , ),
         band3(logi_a, , ))
  exp_eq(and3s(logi_b, , ),
         band3(logi_b, , ))
  exp_eq(and3s(logi_c, , ),
         band3(logi_c, , ))
  exp_eq(and3s(logi_d, , logi_d),
         band3(logi_d, , logi_d))
  exp_eq(and3s(logi_e, , logi_p),
         band3(logi_e, , logi_p))
  exp_eq(and3s(logi_f, , logi_x),
         band3(logi_f, , logi_x))
  exp_eq(and3s(logi_g, logi_b, ),
         band3(logi_g, logi_b, ))
  exp_eq(and3s(logi_h, logi_g, ),
         band3(logi_h, logi_g, ))
  exp_eq(and3s(logi_i, logi_p, ),
         band3(logi_i, logi_p, ))
  exp_eq(and3s(logi_j, logi_s, logi_d),
         band3(logi_j, logi_s, logi_d))
  exp_eq(and3s(logi_k, logi_q, logi_x),
         band3(logi_k, logi_q, logi_x))
  exp_eq(and3s(logi_l, logi_a, logi_z),
         band3(logi_l, logi_a, logi_z))
  exp_eq(and3s(logi_m, , ),
         band3(logi_m, , ))
  exp_eq(and3s(logi_n, , ),
         band3(logi_n, , ))
  exp_eq(and3s(logi_o, , ),
         band3(logi_o, , ))
  exp_eq(and3s(logi_p, , !logi_g),
         band3(logi_p, , !logi_g))
  exp_eq(and3s(logi_q, , !logi_p),
         band3(logi_q, , !logi_p))
  exp_eq(and3s(logi_r, , !logi_m),
         band3(logi_r, , !logi_m))
  exp_eq(and3s(logi_s, logi_v, ),
         band3(logi_s, logi_v, ))
  exp_eq(and3s(logi_t, logi_z, ),
         band3(logi_t, logi_z, ))
  exp_eq(and3s(logi_u, logi_s, ),
         band3(logi_u, logi_s, ))
  exp_eq(and3s(logi_v, logi_y, !logi_v),
         band3(logi_v, logi_y, !logi_v))
  exp_eq(and3s(logi_w, logi_m, !logi_a),
         band3(logi_w, logi_m, !logi_a))
  exp_eq(and3s(logi_x, logi_f, !logi_w),
         band3(logi_x, logi_f, !logi_w))
  exp_eq(and3s(logi_y, , ),
         band3(logi_y, , ))
  exp_eq(and3s(logi_z, , ),
         band3(logi_z, , ))
  exp_eq(and3s(logi_aa, , ),
         band3(logi_aa, , ))
  exp_eq(and3s(logi_ab, , n != 0L),
         band3(logi_ab, , n != 0L))
  exp_eq(and3s(logi_ac, , f != 1L),
         band3(logi_ac, , f != 1L))
  exp_eq(and3s(logi_ad, , d != 9L),
         band3(logi_ad, , d != 9L))
  exp_eq(and3s(logi_ae, logi_x, ),
         band3(logi_ae, logi_x, ))
  exp_eq(and3s(logi_af, logi_x, ),
         band3(logi_af, logi_x, ))
  exp_eq(and3s(logi_ag, logi_v, ),
         band3(logi_ag, logi_v, ))
  exp_eq(and3s(logi_ah, logi_y, j != 0L),
         band3(logi_ah, logi_y, j != 0L))
  exp_eq(and3s(logi_ai, logi_i, j != 1L),
         band3(logi_ai, logi_i, j != 1L))
  exp_eq(and3s(logi_aj, logi_p, o != 9L),
         band3(logi_aj, logi_p, o != 9L))
  exp_eq(and3s(logi_ak, , ),
         band3(logi_ak, , ))
  exp_eq(and3s(logi_al, , ),
         band3(logi_al, , ))
  exp_eq(and3s(logi_am, , ),
         band3(logi_am, , ))
  exp_eq(and3s(logi_an, , j %between% c(-1L, 1L)),
         band3(logi_an, , j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ao, , d %between% c(-1L, 1L)),
         band3(logi_ao, , d %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ap, , n %between% c(-1L, 1L)),
         band3(logi_ap, , n %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aq, logi_t, ),
         band3(logi_aq, logi_t, ))
  exp_eq(and3s(logi_ar, logi_q, ),
         band3(logi_ar, logi_q, ))
  exp_eq(and3s(logi_as, logi_z, ),
         band3(logi_as, logi_z, ))
  exp_eq(and3s(logi_at, logi_h, l %between% c(-1L, 1L)),
         band3(logi_at, logi_h, l %between% c(-1L, 1L)))
  exp_eq(and3s(logi_au, logi_n, j %between% c(-1L, 1L)),
         band3(logi_au, logi_n, j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_av, logi_e, v %between% c(-1L, 1L)),
         band3(logi_av, logi_e, v %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aw, , ),
         band3(logi_aw, , ))
  exp_eq(and3s(logi_ax, , ),
         band3(logi_ax, , ))
  exp_eq(and3s(logi_ay, , ),
         band3(logi_ay, , ))
  exp_eq(and3s(logi_az, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_az, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ba, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ba, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bb, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bb, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bc, logi_t, ),
         band3(logi_bc, logi_t, ))
  exp_eq(and3s(logi_bd, logi_n, ),
         band3(logi_bd, logi_n, ))
  exp_eq(and3s(logi_be, logi_s, ),
         band3(logi_be, logi_s, ))
  exp_eq(and3s(logi_bf, logi_x, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bf, logi_x, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bg, logi_e, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bg, logi_e, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bh, logi_n, a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bh, logi_n, a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bi, , ),
         band3(logi_bi, , ))
  exp_eq(and3s(logi_bj, , ),
         band3(logi_bj, , ))
  exp_eq(and3s(logi_bk, , ),
         band3(logi_bk, , ))
  exp_eq(and3s(logi_bl, , q %in% 1:4),
         band3(logi_bl, , q %in% 1:4))
  exp_eq(and3s(logi_bm, , u %in% 1:4),
         band3(logi_bm, , u %in% 1:4))
  exp_eq(and3s(logi_bn, , r %in% 1:4),
         band3(logi_bn, , r %in% 1:4))
  exp_eq(and3s(logi_bo, logi_q, ),
         band3(logi_bo, logi_q, ))
  exp_eq(and3s(logi_bp, logi_i, ),
         band3(logi_bp, logi_i, ))
  exp_eq(and3s(logi_bq, logi_p, ),
         band3(logi_bq, logi_p, ))
  exp_eq(and3s(logi_br, logi_l, b %in% 1:4),
         band3(logi_br, logi_l, b %in% 1:4))
  exp_eq(and3s(logi_bs, logi_b, f %in% 1:4),
         band3(logi_bs, logi_b, f %in% 1:4))
  exp_eq(and3s(logi_bt, logi_l, j %in% 1:4),
         band3(logi_bt, logi_l, j %in% 1:4))
  exp_eq(and3s(logi_bu, , ),
         band3(logi_bu, , ))
  exp_eq(and3s(logi_bv, , ),
         band3(logi_bv, , ))
  exp_eq(and3s(logi_bw, , ),
         band3(logi_bw, , ))
  exp_eq(and3s(logi_bx, , i < 0L),
         band3(logi_bx, , i < 0L))
  exp_eq(and3s(logi_by, , n < 1L),
         band3(logi_by, , n < 1L))
  exp_eq(and3s(logi_bz, , k < 9L),
         band3(logi_bz, , k < 9L))
  exp_eq(and3s(logi_ca, logi_n, ),
         band3(logi_ca, logi_n, ))
  exp_eq(and3s(logi_cb, logi_e, ),
         band3(logi_cb, logi_e, ))
  exp_eq(and3s(logi_cc, logi_x, ),
         band3(logi_cc, logi_x, ))
  exp_eq(and3s(logi_cd, logi_s, f < 0L),
         band3(logi_cd, logi_s, f < 0L))
  exp_eq(and3s(logi_ce, logi_q, h < 1L),
         band3(logi_ce, logi_q, h < 1L))
  exp_eq(and3s(logi_cf, logi_r, p < 9L),
         band3(logi_cf, logi_r, p < 9L))
  exp_eq(and3s(logi_cg, , ),
         band3(logi_cg, , ))
  exp_eq(and3s(logi_ch, , ),
         band3(logi_ch, , ))
  exp_eq(and3s(logi_ci, , ),
         band3(logi_ci, , ))
  exp_eq(and3s(logi_cj, , k <= 0L),
         band3(logi_cj, , k <= 0L))
  exp_eq(and3s(logi_ck, , a <= 1L),
         band3(logi_ck, , a <= 1L))
  exp_eq(and3s(logi_cl, , r <= 9L),
         band3(logi_cl, , r <= 9L))
  exp_eq(and3s(logi_cm, logi_s, ),
         band3(logi_cm, logi_s, ))
  exp_eq(and3s(logi_cn, logi_j, ),
         band3(logi_cn, logi_j, ))
  exp_eq(and3s(logi_co, logi_t, ),
         band3(logi_co, logi_t, ))
  exp_eq(and3s(logi_cp, logi_x, t <= 0L),
         band3(logi_cp, logi_x, t <= 0L))
  exp_eq(and3s(logi_cq, logi_c, v <= 1L),
         band3(logi_cq, logi_c, v <= 1L))
  exp_eq(and3s(logi_cr, logi_v, q <= 9L),
         band3(logi_cr, logi_v, q <= 9L))
  exp_eq(and3s(logi_cs, , ),
         band3(logi_cs, , ))
  exp_eq(and3s(logi_ct, , ),
         band3(logi_ct, , ))
  exp_eq(and3s(logi_cu, , ),
         band3(logi_cu, , ))
  exp_eq(and3s(logi_cv, , g == 0L),
         band3(logi_cv, , g == 0L))
  exp_eq(and3s(logi_cw, , a == 1L),
         band3(logi_cw, , a == 1L))
  exp_eq(and3s(logi_cx, , d == 9L),
         band3(logi_cx, , d == 9L))
  exp_eq(and3s(logi_cy, logi_i, ),
         band3(logi_cy, logi_i, ))
  exp_eq(and3s(logi_cz, logi_g, ),
         band3(logi_cz, logi_g, ))
  exp_eq(and3s(logi_da, logi_k, ),
         band3(logi_da, logi_k, ))
  exp_eq(and3s(logi_db, logi_t, b == 0L),
         band3(logi_db, logi_t, b == 0L))
  exp_eq(and3s(logi_dc, logi_o, l == 1L),
         band3(logi_dc, logi_o, l == 1L))
  exp_eq(and3s(logi_dd, logi_m, w == 9L),
         band3(logi_dd, logi_m, w == 9L))
  exp_eq(and3s(logi_de, , ),
         band3(logi_de, , ))
  exp_eq(and3s(logi_df, , ),
         band3(logi_df, , ))
  exp_eq(and3s(logi_dg, , ),
         band3(logi_dg, , ))
  exp_eq(and3s(logi_dh, , u > 0L),
         band3(logi_dh, , u > 0L))
  exp_eq(and3s(logi_di, , p > 1L),
         band3(logi_di, , p > 1L))
  exp_eq(and3s(logi_dj, , y > 9L),
         band3(logi_dj, , y > 9L))
  exp_eq(and3s(logi_dk, logi_x, ),
         band3(logi_dk, logi_x, ))
  exp_eq(and3s(logi_dl, logi_q, ),
         band3(logi_dl, logi_q, ))
  exp_eq(and3s(logi_dm, logi_k, ),
         band3(logi_dm, logi_k, ))
  exp_eq(and3s(logi_dn, logi_b, o > 0L),
         band3(logi_dn, logi_b, o > 0L))
  exp_eq(and3s(logi_do, logi_y, g > 1L),
         band3(logi_do, logi_y, g > 1L))
  exp_eq(and3s(logi_dp, logi_t, k > 9L),
         band3(logi_dp, logi_t, k > 9L))
  exp_eq(and3s(logi_dq, , ),
         band3(logi_dq, , ))
  exp_eq(and3s(logi_dr, , ),
         band3(logi_dr, , ))
  exp_eq(and3s(logi_ds, , ),
         band3(logi_ds, , ))
  exp_eq(and3s(logi_dt, , d >= 0L),
         band3(logi_dt, , d >= 0L))
  exp_eq(and3s(logi_du, , k >= 1L),
         band3(logi_du, , k >= 1L))
  exp_eq(and3s(logi_dv, , k >= 9L),
         band3(logi_dv, , k >= 9L))
  exp_eq(and3s(logi_dw, logi_g, ),
         band3(logi_dw, logi_g, ))
  exp_eq(and3s(logi_dx, logi_r, ),
         band3(logi_dx, logi_r, ))
  exp_eq(and3s(logi_dy, logi_s, ),
         band3(logi_dy, logi_s, ))
  exp_eq(and3s(logi_dz, logi_z, x >= 0L),
         band3(logi_dz, logi_z, x >= 0L))
  exp_eq(and3s(logi_ea, logi_g, t >= 1L),
         band3(logi_ea, logi_g, t >= 1L))
  exp_eq(and3s(logi_eb, logi_c, p >= 9L),
         band3(logi_eb, logi_c, p >= 9L))
  exp_eq(and3s(logi_ec, , ),
         band3(logi_ec, , ))
  exp_eq(and3s(logi_ed, , ),
         band3(logi_ed, , ))
  exp_eq(and3s(logi_ee, , ),
         band3(logi_ee, , ))
  exp_eq(and3s(logi_ef, , logi_n),
         band3(logi_ef, , logi_n))
  exp_eq(and3s(logi_eg, , logi_e),
         band3(logi_eg, , logi_e))
  exp_eq(and3s(logi_eh, , logi_k),
         band3(logi_eh, , logi_k))
  exp_eq(and3s(logi_ei, !logi_s, ),
         band3(logi_ei, !logi_s, ))
  exp_eq(and3s(logi_ej, !logi_j, ),
         band3(logi_ej, !logi_j, ))
  exp_eq(and3s(logi_ek, !logi_m, ),
         band3(logi_ek, !logi_m, ))
  exp_eq(and3s(logi_el, !logi_p, logi_k),
         band3(logi_el, !logi_p, logi_k))
  exp_eq(and3s(logi_em, !logi_e, logi_o),
         band3(logi_em, !logi_e, logi_o))
  exp_eq(and3s(logi_en, !logi_x, logi_a),
         band3(logi_en, !logi_x, logi_a))
  exp_eq(and3s(logi_eo, , ),
         band3(logi_eo, , ))
  exp_eq(and3s(logi_ep, , ),
         band3(logi_ep, , ))
  exp_eq(and3s(logi_eq, , ),
         band3(logi_eq, , ))
  exp_eq(and3s(logi_er, , !logi_n),
         band3(logi_er, , !logi_n))
  exp_eq(and3s(logi_es, , !logi_d),
         band3(logi_es, , !logi_d))
  exp_eq(and3s(logi_et, , !logi_y),
         band3(logi_et, , !logi_y))
  exp_eq(and3s(logi_eu, !logi_f, ),
         band3(logi_eu, !logi_f, ))
  exp_eq(and3s(logi_ev, !logi_l, ),
         band3(logi_ev, !logi_l, ))
  exp_eq(and3s(logi_ew, !logi_r, ),
         band3(logi_ew, !logi_r, ))
  exp_eq(and3s(logi_ex, !logi_d, !logi_m),
         band3(logi_ex, !logi_d, !logi_m))
  exp_eq(and3s(logi_ey, !logi_o, !logi_m),
         band3(logi_ey, !logi_o, !logi_m))
  exp_eq(and3s(logi_ez, !logi_f, !logi_j),
         band3(logi_ez, !logi_f, !logi_j))
  exp_eq(and3s(logi_fa, , ),
         band3(logi_fa, , ))
  exp_eq(and3s(logi_fb, , ),
         band3(logi_fb, , ))
  exp_eq(and3s(logi_fc, , ),
         band3(logi_fc, , ))
  exp_eq(and3s(logi_fd, , y != 0L),
         band3(logi_fd, , y != 0L))
  exp_eq(and3s(logi_fe, , h != 1L),
         band3(logi_fe, , h != 1L))
  exp_eq(and3s(logi_ff, , t != 9L),
         band3(logi_ff, , t != 9L))
  exp_eq(and3s(logi_fg, !logi_m, ),
         band3(logi_fg, !logi_m, ))
  exp_eq(and3s(logi_fh, !logi_z, ),
         band3(logi_fh, !logi_z, ))
  exp_eq(and3s(logi_fi, !logi_s, ),
         band3(logi_fi, !logi_s, ))
  exp_eq(and3s(logi_fj, !logi_m, t != 0L),
         band3(logi_fj, !logi_m, t != 0L))
  exp_eq(and3s(logi_fk, !logi_t, l != 1L),
         band3(logi_fk, !logi_t, l != 1L))
  exp_eq(and3s(logi_fl, !logi_l, l != 9L),
         band3(logi_fl, !logi_l, l != 9L))
  exp_eq(and3s(logi_fm, , ),
         band3(logi_fm, , ))
  exp_eq(and3s(logi_fn, , ),
         band3(logi_fn, , ))
  exp_eq(and3s(logi_fo, , ),
         band3(logi_fo, , ))
  exp_eq(and3s(logi_fp, , n %between% c(-1L, 1L)),
         band3(logi_fp, , n %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fq, , x %between% c(-1L, 1L)),
         band3(logi_fq, , x %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fr, , r %between% c(-1L, 1L)),
         band3(logi_fr, , r %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fs, !logi_l, ),
         band3(logi_fs, !logi_l, ))
  exp_eq(and3s(logi_ft, !logi_n, ),
         band3(logi_ft, !logi_n, ))
  exp_eq(and3s(logi_fu, !logi_p, ),
         band3(logi_fu, !logi_p, ))
  exp_eq(and3s(logi_fv, !logi_f, s %between% c(-1L, 1L)),
         band3(logi_fv, !logi_f, s %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fw, !logi_c, t %between% c(-1L, 1L)),
         band3(logi_fw, !logi_c, t %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fx, !logi_x, a %between% c(-1L, 1L)),
         band3(logi_fx, !logi_x, a %between% c(-1L, 1L)))
  exp_eq(and3s(logi_fy, , ),
         band3(logi_fy, , ))
  exp_eq(and3s(logi_fz, , ),
         band3(logi_fz, , ))
  exp_eq(and3s(logi_ga, , ),
         band3(logi_ga, , ))
  exp_eq(and3s(logi_gb, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gb, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_gc, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gc, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_gd, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gd, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ge, !logi_z, ),
         band3(logi_ge, !logi_z, ))
  exp_eq(and3s(logi_gf, !logi_r, ),
         band3(logi_gf, !logi_r, ))
  exp_eq(and3s(logi_gg, !logi_b, ),
         band3(logi_gg, !logi_b, ))
  exp_eq(and3s(logi_gh, !logi_v, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gh, !logi_v, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_gi, !logi_r, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gi, !logi_r, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_gj, !logi_y, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_gj, !logi_y, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_gk, , ),
         band3(logi_gk, , ))
  exp_eq(and3s(logi_gl, , ),
         band3(logi_gl, , ))
  exp_eq(and3s(logi_gm, , ),
         band3(logi_gm, , ))
  exp_eq(and3s(logi_gn, , h %in% 1:4),
         band3(logi_gn, , h %in% 1:4))
  exp_eq(and3s(logi_go, , a %in% 1:4),
         band3(logi_go, , a %in% 1:4))
  exp_eq(and3s(logi_gp, , q %in% 1:4),
         band3(logi_gp, , q %in% 1:4))
  exp_eq(and3s(logi_gq, !logi_q, ),
         band3(logi_gq, !logi_q, ))
  exp_eq(and3s(logi_gr, !logi_x, ),
         band3(logi_gr, !logi_x, ))
  exp_eq(and3s(logi_gs, !logi_b, ),
         band3(logi_gs, !logi_b, ))
  exp_eq(and3s(logi_gt, !logi_z, a %in% 1:4),
         band3(logi_gt, !logi_z, a %in% 1:4))
  exp_eq(and3s(logi_gu, !logi_k, z %in% 1:4),
         band3(logi_gu, !logi_k, z %in% 1:4))
  exp_eq(and3s(logi_gv, !logi_e, w %in% 1:4),
         band3(logi_gv, !logi_e, w %in% 1:4))
  exp_eq(and3s(logi_gw, , ),
         band3(logi_gw, , ))
  exp_eq(and3s(logi_gx, , ),
         band3(logi_gx, , ))
  exp_eq(and3s(logi_gy, , ),
         band3(logi_gy, , ))
  exp_eq(and3s(logi_gz, , i < 0L),
         band3(logi_gz, , i < 0L))
  exp_eq(and3s(logi_ha, , x < 1L),
         band3(logi_ha, , x < 1L))
  exp_eq(and3s(logi_hb, , j < 9L),
         band3(logi_hb, , j < 9L))
  exp_eq(and3s(logi_hc, !logi_r, ),
         band3(logi_hc, !logi_r, ))
  exp_eq(and3s(logi_hd, !logi_v, ),
         band3(logi_hd, !logi_v, ))
  exp_eq(and3s(logi_he, !logi_w, ),
         band3(logi_he, !logi_w, ))
  exp_eq(and3s(logi_hf, !logi_t, t < 0L),
         band3(logi_hf, !logi_t, t < 0L))
  exp_eq(and3s(logi_hg, !logi_t, c < 1L),
         band3(logi_hg, !logi_t, c < 1L))
  exp_eq(and3s(logi_hh, !logi_f, u < 9L),
         band3(logi_hh, !logi_f, u < 9L))
  exp_eq(and3s(logi_hi, , ),
         band3(logi_hi, , ))
  exp_eq(and3s(logi_hj, , ),
         band3(logi_hj, , ))
  exp_eq(and3s(logi_hk, , ),
         band3(logi_hk, , ))
  exp_eq(and3s(logi_hl, , y <= 0L),
         band3(logi_hl, , y <= 0L))
  exp_eq(and3s(logi_hm, , m <= 1L),
         band3(logi_hm, , m <= 1L))
  exp_eq(and3s(logi_hn, , e <= 9L),
         band3(logi_hn, , e <= 9L))
  exp_eq(and3s(logi_ho, !logi_r, ),
         band3(logi_ho, !logi_r, ))
  exp_eq(and3s(logi_hp, !logi_g, ),
         band3(logi_hp, !logi_g, ))
  exp_eq(and3s(logi_hq, !logi_t, ),
         band3(logi_hq, !logi_t, ))
  exp_eq(and3s(logi_hr, !logi_e, d <= 0L),
         band3(logi_hr, !logi_e, d <= 0L))
  exp_eq(and3s(logi_hs, !logi_y, d <= 1L),
         band3(logi_hs, !logi_y, d <= 1L))
  exp_eq(and3s(logi_ht, !logi_p, m <= 9L),
         band3(logi_ht, !logi_p, m <= 9L))
  exp_eq(and3s(logi_hu, , ),
         band3(logi_hu, , ))
  exp_eq(and3s(logi_hv, , ),
         band3(logi_hv, , ))
  exp_eq(and3s(logi_hw, , ),
         band3(logi_hw, , ))
  exp_eq(and3s(logi_hx, , m == 0L),
         band3(logi_hx, , m == 0L))
  exp_eq(and3s(logi_hy, , x == 1L),
         band3(logi_hy, , x == 1L))
  exp_eq(and3s(logi_hz, , n == 9L),
         band3(logi_hz, , n == 9L))
  exp_eq(and3s(logi_ia, !logi_y, ),
         band3(logi_ia, !logi_y, ))
  exp_eq(and3s(logi_ib, !logi_h, ),
         band3(logi_ib, !logi_h, ))
  exp_eq(and3s(logi_ic, !logi_c, ),
         band3(logi_ic, !logi_c, ))
  exp_eq(and3s(logi_id, !logi_t, f == 0L),
         band3(logi_id, !logi_t, f == 0L))
  exp_eq(and3s(logi_ie, !logi_e, w == 1L),
         band3(logi_ie, !logi_e, w == 1L))
  exp_eq(and3s(logi_IF, !logi_y, p == 9L),
         band3(logi_IF, !logi_y, p == 9L))
  exp_eq(and3s(logi_ig, , ),
         band3(logi_ig, , ))
  exp_eq(and3s(logi_ih, , ),
         band3(logi_ih, , ))
  exp_eq(and3s(logi_ii, , ),
         band3(logi_ii, , ))
  exp_eq(and3s(logi_ij, , z > 0L),
         band3(logi_ij, , z > 0L))
  exp_eq(and3s(logi_ik, , r > 1L),
         band3(logi_ik, , r > 1L))
  exp_eq(and3s(logi_il, , e > 9L),
         band3(logi_il, , e > 9L))
  exp_eq(and3s(logi_im, !logi_d, ),
         band3(logi_im, !logi_d, ))
  exp_eq(and3s(logi_IN, !logi_o, ),
         band3(logi_IN, !logi_o, ))
  exp_eq(and3s(logi_io, !logi_o, ),
         band3(logi_io, !logi_o, ))
  exp_eq(and3s(logi_ip, !logi_f, m > 0L),
         band3(logi_ip, !logi_f, m > 0L))
  exp_eq(and3s(logi_iq, !logi_i, y > 1L),
         band3(logi_iq, !logi_i, y > 1L))
  exp_eq(and3s(logi_ir, !logi_w, s > 9L),
         band3(logi_ir, !logi_w, s > 9L))
  exp_eq(and3s(logi_is, , ),
         band3(logi_is, , ))
  exp_eq(and3s(logi_it, , ),
         band3(logi_it, , ))
  exp_eq(and3s(logi_iu, , ),
         band3(logi_iu, , ))
  exp_eq(and3s(logi_iv, , y >= 0L),
         band3(logi_iv, , y >= 0L))
  exp_eq(and3s(logi_iw, , d >= 1L),
         band3(logi_iw, , d >= 1L))
  exp_eq(and3s(logi_ix, , w >= 9L),
         band3(logi_ix, , w >= 9L))
  exp_eq(and3s(logi_iy, !logi_i, ),
         band3(logi_iy, !logi_i, ))
  exp_eq(and3s(logi_iz, !logi_f, ),
         band3(logi_iz, !logi_f, ))
  exp_eq(and3s(logi_ja, !logi_x, ),
         band3(logi_ja, !logi_x, ))
  exp_eq(and3s(logi_jb, !logi_j, e >= 0L),
         band3(logi_jb, !logi_j, e >= 0L))
  exp_eq(and3s(logi_jc, !logi_v, j >= 1L),
         band3(logi_jc, !logi_v, j >= 1L))
  exp_eq(and3s(logi_jd, !logi_q, x >= 9L),
         band3(logi_jd, !logi_q, x >= 9L))
  exp_eq(and3s(logi_je, , ),
         band3(logi_je, , ))
  exp_eq(and3s(logi_jf, , ),
         band3(logi_jf, , ))
  exp_eq(and3s(logi_jg, , ),
         band3(logi_jg, , ))
  exp_eq(and3s(logi_jh, , logi_q),
         band3(logi_jh, , logi_q))
  exp_eq(and3s(logi_ji, , logi_x),
         band3(logi_ji, , logi_x))
  exp_eq(and3s(logi_jj, , logi_z),
         band3(logi_jj, , logi_z))
  exp_eq(and3s(logi_jk, j != 0L, ),
         band3(logi_jk, j != 0L, ))
  exp_eq(and3s(logi_jl, m != 1L, ),
         band3(logi_jl, m != 1L, ))
  exp_eq(and3s(logi_jm, o != 9L, ),
         band3(logi_jm, o != 9L, ))
  exp_eq(and3s(logi_jn, f != 0L, logi_u),
         band3(logi_jn, f != 0L, logi_u))
  exp_eq(and3s(logi_jo, f != 1L, logi_q),
         band3(logi_jo, f != 1L, logi_q))
  exp_eq(and3s(logi_jp, w != 9L, logi_x),
         band3(logi_jp, w != 9L, logi_x))
  exp_eq(and3s(logi_jq, , ),
         band3(logi_jq, , ))
  exp_eq(and3s(logi_jr, , ),
         band3(logi_jr, , ))
  exp_eq(and3s(logi_js, , ),
         band3(logi_js, , ))
  exp_eq(and3s(logi_jt, , !logi_s),
         band3(logi_jt, , !logi_s))
  exp_eq(and3s(logi_ju, , !logi_n),
         band3(logi_ju, , !logi_n))
  exp_eq(and3s(logi_jv, , !logi_z),
         band3(logi_jv, , !logi_z))
  exp_eq(and3s(logi_jw, c != 0L, ),
         band3(logi_jw, c != 0L, ))
  exp_eq(and3s(logi_jx, h != 1L, ),
         band3(logi_jx, h != 1L, ))
  exp_eq(and3s(logi_jy, c != 9L, ),
         band3(logi_jy, c != 9L, ))
  exp_eq(and3s(logi_jz, d != 0L, !logi_a),
         band3(logi_jz, d != 0L, !logi_a))
  exp_eq(and3s(logi_ka, x != 1L, !logi_i),
         band3(logi_ka, x != 1L, !logi_i))
  exp_eq(and3s(logi_kb, s != 9L, !logi_r),
         band3(logi_kb, s != 9L, !logi_r))
  exp_eq(and3s(logi_kc, , ),
         band3(logi_kc, , ))
  exp_eq(and3s(logi_kd, , ),
         band3(logi_kd, , ))
  exp_eq(and3s(logi_ke, , ),
         band3(logi_ke, , ))
  exp_eq(and3s(logi_kf, , r != 0L),
         band3(logi_kf, , r != 0L))
  exp_eq(and3s(logi_kg, , z != 1L),
         band3(logi_kg, , z != 1L))
  exp_eq(and3s(logi_kh, , h != 9L),
         band3(logi_kh, , h != 9L))
  exp_eq(and3s(logi_ki, a != 0L, ),
         band3(logi_ki, a != 0L, ))
  exp_eq(and3s(logi_kj, u != 1L, ),
         band3(logi_kj, u != 1L, ))
  exp_eq(and3s(logi_kk, j != 9L, ),
         band3(logi_kk, j != 9L, ))
  exp_eq(and3s(logi_kl, m != 0L, g != 0L),
         band3(logi_kl, m != 0L, g != 0L))
  exp_eq(and3s(logi_km, m != 1L, l != 1L),
         band3(logi_km, m != 1L, l != 1L))
  exp_eq(and3s(logi_kn, b != 9L, u != 9L),
         band3(logi_kn, b != 9L, u != 9L))
  exp_eq(and3s(logi_ko, , ),
         band3(logi_ko, , ))
  exp_eq(and3s(logi_kp, , ),
         band3(logi_kp, , ))
  exp_eq(and3s(logi_kq, , ),
         band3(logi_kq, , ))
  exp_eq(and3s(logi_kr, , i %between% c(-1L, 1L)),
         band3(logi_kr, , i %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ks, , o %between% c(-1L, 1L)),
         band3(logi_ks, , o %between% c(-1L, 1L)))
  exp_eq(and3s(logi_kt, , j %between% c(-1L, 1L)),
         band3(logi_kt, , j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ku, g != 0L, ),
         band3(logi_ku, g != 0L, ))
  exp_eq(and3s(logi_kv, m != 1L, ),
         band3(logi_kv, m != 1L, ))
  exp_eq(and3s(logi_kw, b != 9L, ),
         band3(logi_kw, b != 9L, ))
  exp_eq(and3s(logi_kx, f != 0L, e %between% c(-1L, 1L)),
         band3(logi_kx, f != 0L, e %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ky, w != 1L, j %between% c(-1L, 1L)),
         band3(logi_ky, w != 1L, j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_kz, e != 9L, w %between% c(-1L, 1L)),
         band3(logi_kz, e != 9L, w %between% c(-1L, 1L)))
  exp_eq(and3s(logi_la, , ),
         band3(logi_la, , ))
  exp_eq(and3s(logi_lb, , ),
         band3(logi_lb, , ))
  exp_eq(and3s(logi_lc, , ),
         band3(logi_lc, , ))
  exp_eq(and3s(logi_ld, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ld, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_le, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_le, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_lf, , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_lf, , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_lg, m != 0L, ),
         band3(logi_lg, m != 0L, ))
  exp_eq(and3s(logi_lh, c != 1L, ),
         band3(logi_lh, c != 1L, ))
  exp_eq(and3s(logi_li, j != 9L, ),
         band3(logi_li, j != 9L, ))
  exp_eq(and3s(logi_lj, v != 0L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_lj, v != 0L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_lk, p != 1L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_lk, p != 1L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ll, a != 9L, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ll, a != 9L, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_lm, , ),
         band3(logi_lm, , ))
  exp_eq(and3s(logi_ln, , ),
         band3(logi_ln, , ))
  exp_eq(and3s(logi_lo, , ),
         band3(logi_lo, , ))
  exp_eq(and3s(logi_lp, , h %in% 1:4),
         band3(logi_lp, , h %in% 1:4))
  exp_eq(and3s(logi_lq, , n %in% 1:4),
         band3(logi_lq, , n %in% 1:4))
  exp_eq(and3s(logi_lr, , t %in% 1:4),
         band3(logi_lr, , t %in% 1:4))
  exp_eq(and3s(logi_ls, k != 0L, ),
         band3(logi_ls, k != 0L, ))
  exp_eq(and3s(logi_lt, w != 1L, ),
         band3(logi_lt, w != 1L, ))
  exp_eq(and3s(logi_lu, j != 9L, ),
         band3(logi_lu, j != 9L, ))
  exp_eq(and3s(logi_lv, s != 0L, o %in% 1:4),
         band3(logi_lv, s != 0L, o %in% 1:4))
  exp_eq(and3s(logi_lw, b != 1L, u %in% 1:4),
         band3(logi_lw, b != 1L, u %in% 1:4))
  exp_eq(and3s(logi_lx, n != 9L, x %in% 1:4),
         band3(logi_lx, n != 9L, x %in% 1:4))
  exp_eq(and3s(logi_ly, , ),
         band3(logi_ly, , ))
  exp_eq(and3s(logi_lz, , ),
         band3(logi_lz, , ))
  exp_eq(and3s(logi_ma, , ),
         band3(logi_ma, , ))
  exp_eq(and3s(logi_mb, , i < 0L),
         band3(logi_mb, , i < 0L))
  exp_eq(and3s(logi_mc, , d < 1L),
         band3(logi_mc, , d < 1L))
  exp_eq(and3s(logi_md, , r < 9L),
         band3(logi_md, , r < 9L))
  exp_eq(and3s(logi_me, e != 0L, ),
         band3(logi_me, e != 0L, ))
  exp_eq(and3s(logi_mf, d != 1L, ),
         band3(logi_mf, d != 1L, ))
  exp_eq(and3s(logi_mg, k != 9L, ),
         band3(logi_mg, k != 9L, ))
  exp_eq(and3s(logi_mh, n != 0L, c < 0L),
         band3(logi_mh, n != 0L, c < 0L))
  exp_eq(and3s(logi_mi, u != 1L, t < 1L),
         band3(logi_mi, u != 1L, t < 1L))
  exp_eq(and3s(logi_mj, x != 9L, r < 9L),
         band3(logi_mj, x != 9L, r < 9L))
  exp_eq(and3s(logi_mk, , ),
         band3(logi_mk, , ))
  exp_eq(and3s(logi_ml, , ),
         band3(logi_ml, , ))
  exp_eq(and3s(logi_mm, , ),
         band3(logi_mm, , ))
  exp_eq(and3s(logi_mn, , h <= 0L),
         band3(logi_mn, , h <= 0L))
  exp_eq(and3s(logi_mo, , i <= 1L),
         band3(logi_mo, , i <= 1L))
  exp_eq(and3s(logi_mp, , n <= 9L),
         band3(logi_mp, , n <= 9L))
  exp_eq(and3s(logi_mq, q != 0L, ),
         band3(logi_mq, q != 0L, ))
  exp_eq(and3s(logi_mr, l != 1L, ),
         band3(logi_mr, l != 1L, ))
  exp_eq(and3s(logi_ms, a != 9L, ),
         band3(logi_ms, a != 9L, ))
  exp_eq(and3s(logi_mt, o != 0L, a <= 0L),
         band3(logi_mt, o != 0L, a <= 0L))
  exp_eq(and3s(logi_mu, z != 1L, e <= 1L),
         band3(logi_mu, z != 1L, e <= 1L))
  exp_eq(and3s(logi_mv, k != 9L, l <= 9L),
         band3(logi_mv, k != 9L, l <= 9L))
  exp_eq(and3s(logi_mw, , ),
         band3(logi_mw, , ))
  exp_eq(and3s(logi_mx, , ),
         band3(logi_mx, , ))
  exp_eq(and3s(logi_my, , ),
         band3(logi_my, , ))
  exp_eq(and3s(logi_mz, , i == 0L),
         band3(logi_mz, , i == 0L))
  exp_eq(and3s(logi_na, , g == 1L),
         band3(logi_na, , g == 1L))
  exp_eq(and3s(logi_nb, , b == 9L),
         band3(logi_nb, , b == 9L))
  exp_eq(and3s(logi_nc, t != 0L, ),
         band3(logi_nc, t != 0L, ))
  exp_eq(and3s(logi_nd, l != 1L, ),
         band3(logi_nd, l != 1L, ))
  exp_eq(and3s(logi_ne, b != 9L, ),
         band3(logi_ne, b != 9L, ))
  exp_eq(and3s(logi_nf, j != 0L, s == 0L),
         band3(logi_nf, j != 0L, s == 0L))
  exp_eq(and3s(logi_ng, z != 1L, x == 1L),
         band3(logi_ng, z != 1L, x == 1L))
  exp_eq(and3s(logi_nh, f != 9L, k == 9L),
         band3(logi_nh, f != 9L, k == 9L))
  exp_eq(and3s(logi_ni, , ),
         band3(logi_ni, , ))
  exp_eq(and3s(logi_nj, , ),
         band3(logi_nj, , ))
  exp_eq(and3s(logi_nk, , ),
         band3(logi_nk, , ))
  exp_eq(and3s(logi_nl, , x > 0L),
         band3(logi_nl, , x > 0L))
  exp_eq(and3s(logi_nm, , b > 1L),
         band3(logi_nm, , b > 1L))
  exp_eq(and3s(logi_nn, , r > 9L),
         band3(logi_nn, , r > 9L))
  exp_eq(and3s(logi_no, f != 0L, ),
         band3(logi_no, f != 0L, ))
  exp_eq(and3s(logi_np, z != 1L, ),
         band3(logi_np, z != 1L, ))
  exp_eq(and3s(logi_nq, m != 9L, ),
         band3(logi_nq, m != 9L, ))
  exp_eq(and3s(logi_nr, b != 0L, o > 0L),
         band3(logi_nr, b != 0L, o > 0L))
  exp_eq(and3s(logi_ns, q != 1L, d > 1L),
         band3(logi_ns, q != 1L, d > 1L))
  exp_eq(and3s(logi_nt, k != 9L, z > 9L),
         band3(logi_nt, k != 9L, z > 9L))
  exp_eq(and3s(logi_nu, , ),
         band3(logi_nu, , ))
  exp_eq(and3s(logi_nv, , ),
         band3(logi_nv, , ))
  exp_eq(and3s(logi_nw, , ),
         band3(logi_nw, , ))
  exp_eq(and3s(logi_nx, , u >= 0L),
         band3(logi_nx, , u >= 0L))
  exp_eq(and3s(logi_ny, , j >= 1L),
         band3(logi_ny, , j >= 1L))
  exp_eq(and3s(logi_nz, , j >= 9L),
         band3(logi_nz, , j >= 9L))
  exp_eq(and3s(logi_oa, t != 0L, ),
         band3(logi_oa, t != 0L, ))
  exp_eq(and3s(logi_ob, n != 1L, ),
         band3(logi_ob, n != 1L, ))
  exp_eq(and3s(logi_oc, b != 9L, ),
         band3(logi_oc, b != 9L, ))
  exp_eq(and3s(logi_od, r != 0L, c >= 0L),
         band3(logi_od, r != 0L, c >= 0L))
  exp_eq(and3s(logi_oe, c != 1L, m >= 1L),
         band3(logi_oe, c != 1L, m >= 1L))
  exp_eq(and3s(logi_of, c != 9L, h >= 9L),
         band3(logi_of, c != 9L, h >= 9L))
  exp_eq(and3s(logi_og, , ),
         band3(logi_og, , ))
  exp_eq(and3s(logi_oh, , ),
         band3(logi_oh, , ))
  exp_eq(and3s(logi_oi, , ),
         band3(logi_oi, , ))
  exp_eq(and3s(logi_oj, , logi_q),
         band3(logi_oj, , logi_q))
  exp_eq(and3s(logi_ok, , logi_m),
         band3(logi_ok, , logi_m))
  exp_eq(and3s(logi_ol, , logi_p),
         band3(logi_ol, , logi_p))
  exp_eq(and3s(logi_om, w %between% c(-1L, 1L), ),
         band3(logi_om, w %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_on, k %between% c(-1L, 1L), ),
         band3(logi_on, k %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_oo, w %between% c(-1L, 1L), ),
         band3(logi_oo, w %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_op, g %between% c(-1L, 1L), logi_j),
         band3(logi_op, g %between% c(-1L, 1L), logi_j))
  exp_eq(and3s(logi_oq, z %between% c(-1L, 1L), logi_z),
         band3(logi_oq, z %between% c(-1L, 1L), logi_z))
  exp_eq(and3s(logi_or, x %between% c(-1L, 1L), logi_d),
         band3(logi_or, x %between% c(-1L, 1L), logi_d))
  exp_eq(and3s(logi_os, , ),
         band3(logi_os, , ))
  exp_eq(and3s(logi_ot, , ),
         band3(logi_ot, , ))
  exp_eq(and3s(logi_ou, , ),
         band3(logi_ou, , ))
  exp_eq(and3s(logi_ov, , !logi_i),
         band3(logi_ov, , !logi_i))
  exp_eq(and3s(logi_ow, , !logi_b),
         band3(logi_ow, , !logi_b))
  exp_eq(and3s(logi_ox, , !logi_b),
         band3(logi_ox, , !logi_b))
  exp_eq(and3s(logi_oy, r %between% c(-1L, 1L), ),
         band3(logi_oy, r %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_oz, f %between% c(-1L, 1L), ),
         band3(logi_oz, f %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pa, o %between% c(-1L, 1L), ),
         band3(logi_pa, o %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pb, l %between% c(-1L, 1L), !logi_s),
         band3(logi_pb, l %between% c(-1L, 1L), !logi_s))
  exp_eq(and3s(logi_pc, g %between% c(-1L, 1L), !logi_w),
         band3(logi_pc, g %between% c(-1L, 1L), !logi_w))
  exp_eq(and3s(logi_pd, s %between% c(-1L, 1L), !logi_y),
         band3(logi_pd, s %between% c(-1L, 1L), !logi_y))
  exp_eq(and3s(logi_pe, , ),
         band3(logi_pe, , ))
  exp_eq(and3s(logi_pf, , ),
         band3(logi_pf, , ))
  exp_eq(and3s(logi_pg, , ),
         band3(logi_pg, , ))
  exp_eq(and3s(logi_ph, , m != 0L),
         band3(logi_ph, , m != 0L))
  exp_eq(and3s(logi_pi, , u != 1L),
         band3(logi_pi, , u != 1L))
  exp_eq(and3s(logi_pj, , d != 9L),
         band3(logi_pj, , d != 9L))
  exp_eq(and3s(logi_pk, p %between% c(-1L, 1L), ),
         band3(logi_pk, p %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pl, n %between% c(-1L, 1L), ),
         band3(logi_pl, n %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pm, u %between% c(-1L, 1L), ),
         band3(logi_pm, u %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pn, h %between% c(-1L, 1L), v != 0L),
         band3(logi_pn, h %between% c(-1L, 1L), v != 0L))
  exp_eq(and3s(logi_po, y %between% c(-1L, 1L), y != 1L),
         band3(logi_po, y %between% c(-1L, 1L), y != 1L))
  exp_eq(and3s(logi_pp, t %between% c(-1L, 1L), e != 9L),
         band3(logi_pp, t %between% c(-1L, 1L), e != 9L))
  exp_eq(and3s(logi_pq, , ),
         band3(logi_pq, , ))
  exp_eq(and3s(logi_pr, , ),
         band3(logi_pr, , ))
  exp_eq(and3s(logi_ps, , ),
         band3(logi_ps, , ))
  exp_eq(and3s(logi_pt, , w %between% c(-1L, 1L)),
         band3(logi_pt, , w %between% c(-1L, 1L)))
  exp_eq(and3s(logi_pu, , o %between% c(-1L, 1L)),
         band3(logi_pu, , o %between% c(-1L, 1L)))
  exp_eq(and3s(logi_pv, , n %between% c(-1L, 1L)),
         band3(logi_pv, , n %between% c(-1L, 1L)))
  exp_eq(and3s(logi_pw, f %between% c(-1L, 1L), ),
         band3(logi_pw, f %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_px, t %between% c(-1L, 1L), ),
         band3(logi_px, t %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_py, z %between% c(-1L, 1L), ),
         band3(logi_py, z %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_pz, d %between% c(-1L, 1L), p %between% c(-1L, 1L)),
         band3(logi_pz, d %between% c(-1L, 1L), p %between% c(-1L, 1L)))
  exp_eq(and3s(logi_qa, t %between% c(-1L, 1L), j %between% c(-1L, 1L)),
         band3(logi_qa, t %between% c(-1L, 1L), j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_qb, i %between% c(-1L, 1L), n %between% c(-1L, 1L)),
         band3(logi_qb, i %between% c(-1L, 1L), n %between% c(-1L, 1L)))
  exp_eq(and3s(logi_qc, , ),
         band3(logi_qc, , ))
  exp_eq(and3s(logi_qd, , ),
         band3(logi_qd, , ))
  exp_eq(and3s(logi_qe, , ),
         band3(logi_qe, , ))
  exp_eq(and3s(logi_qf, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_qf, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qg, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_qg, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qh, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_qh, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qi, u %between% c(-1L, 1L), ),
         band3(logi_qi, u %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_qj, d %between% c(-1L, 1L), ),
         band3(logi_qj, d %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_qk, p %between% c(-1L, 1L), ),
         band3(logi_qk, p %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_ql, r %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ql, r %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qm, n %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_qm, n %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qn, m %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_qn, m %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_qo, , ),
         band3(logi_qo, , ))
  exp_eq(and3s(logi_qp, , ),
         band3(logi_qp, , ))
  exp_eq(and3s(logi_qq, , ),
         band3(logi_qq, , ))
  exp_eq(and3s(logi_qr, , f %in% 1:4),
         band3(logi_qr, , f %in% 1:4))
  exp_eq(and3s(logi_qs, , s %in% 1:4),
         band3(logi_qs, , s %in% 1:4))
  exp_eq(and3s(logi_qt, , d %in% 1:4),
         band3(logi_qt, , d %in% 1:4))
  exp_eq(and3s(logi_qu, c %between% c(-1L, 1L), ),
         band3(logi_qu, c %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_qv, l %between% c(-1L, 1L), ),
         band3(logi_qv, l %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_qw, d %between% c(-1L, 1L), ),
         band3(logi_qw, d %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_qx, b %between% c(-1L, 1L), y %in% 1:4),
         band3(logi_qx, b %between% c(-1L, 1L), y %in% 1:4))
  exp_eq(and3s(logi_qy, m %between% c(-1L, 1L), f %in% 1:4),
         band3(logi_qy, m %between% c(-1L, 1L), f %in% 1:4))
  exp_eq(and3s(logi_qz, z %between% c(-1L, 1L), a %in% 1:4),
         band3(logi_qz, z %between% c(-1L, 1L), a %in% 1:4))
  exp_eq(and3s(logi_ra, , ),
         band3(logi_ra, , ))
  exp_eq(and3s(logi_rb, , ),
         band3(logi_rb, , ))
  exp_eq(and3s(logi_rc, , ),
         band3(logi_rc, , ))
  exp_eq(and3s(logi_rd, , n < 0L),
         band3(logi_rd, , n < 0L))
  exp_eq(and3s(logi_re, , u < 1L),
         band3(logi_re, , u < 1L))
  exp_eq(and3s(logi_rf, , l < 9L),
         band3(logi_rf, , l < 9L))
  exp_eq(and3s(logi_rg, z %between% c(-1L, 1L), ),
         band3(logi_rg, z %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_rh, u %between% c(-1L, 1L), ),
         band3(logi_rh, u %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_ri, y %between% c(-1L, 1L), ),
         band3(logi_ri, y %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_rj, o %between% c(-1L, 1L), d < 0L),
         band3(logi_rj, o %between% c(-1L, 1L), d < 0L))
  exp_eq(and3s(logi_rk, a %between% c(-1L, 1L), j < 1L),
         band3(logi_rk, a %between% c(-1L, 1L), j < 1L))
  exp_eq(and3s(logi_rl, z %between% c(-1L, 1L), r < 9L),
         band3(logi_rl, z %between% c(-1L, 1L), r < 9L))
  exp_eq(and3s(logi_rm, , ),
         band3(logi_rm, , ))
  exp_eq(and3s(logi_rn, , ),
         band3(logi_rn, , ))
  exp_eq(and3s(logi_ro, , ),
         band3(logi_ro, , ))
  exp_eq(and3s(logi_rp, , s <= 0L),
         band3(logi_rp, , s <= 0L))
  exp_eq(and3s(logi_rq, , l <= 1L),
         band3(logi_rq, , l <= 1L))
  exp_eq(and3s(logi_rr, , n <= 9L),
         band3(logi_rr, , n <= 9L))
  exp_eq(and3s(logi_rs, b %between% c(-1L, 1L), ),
         band3(logi_rs, b %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_rt, n %between% c(-1L, 1L), ),
         band3(logi_rt, n %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_ru, g %between% c(-1L, 1L), ),
         band3(logi_ru, g %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_rv, n %between% c(-1L, 1L), o <= 0L),
         band3(logi_rv, n %between% c(-1L, 1L), o <= 0L))
  exp_eq(and3s(logi_rw, i %between% c(-1L, 1L), k <= 1L),
         band3(logi_rw, i %between% c(-1L, 1L), k <= 1L))
  exp_eq(and3s(logi_rx, z %between% c(-1L, 1L), q <= 9L),
         band3(logi_rx, z %between% c(-1L, 1L), q <= 9L))
  exp_eq(and3s(logi_ry, , ),
         band3(logi_ry, , ))
  exp_eq(and3s(logi_rz, , ),
         band3(logi_rz, , ))
  exp_eq(and3s(logi_sa, , ),
         band3(logi_sa, , ))
  exp_eq(and3s(logi_sb, , m == 0L),
         band3(logi_sb, , m == 0L))
  exp_eq(and3s(logi_sc, , u == 1L),
         band3(logi_sc, , u == 1L))
  exp_eq(and3s(logi_sd, , t == 9L),
         band3(logi_sd, , t == 9L))
  exp_eq(and3s(logi_se, n %between% c(-1L, 1L), ),
         band3(logi_se, n %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_sf, f %between% c(-1L, 1L), ),
         band3(logi_sf, f %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_sg, n %between% c(-1L, 1L), ),
         band3(logi_sg, n %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_sh, i %between% c(-1L, 1L), e == 0L),
         band3(logi_sh, i %between% c(-1L, 1L), e == 0L))
  exp_eq(and3s(logi_si, f %between% c(-1L, 1L), b == 1L),
         band3(logi_si, f %between% c(-1L, 1L), b == 1L))
  exp_eq(and3s(logi_sj, b %between% c(-1L, 1L), t == 9L),
         band3(logi_sj, b %between% c(-1L, 1L), t == 9L))
  exp_eq(and3s(logi_sk, , ),
         band3(logi_sk, , ))
  exp_eq(and3s(logi_sl, , ),
         band3(logi_sl, , ))
  exp_eq(and3s(logi_sm, , ),
         band3(logi_sm, , ))
  exp_eq(and3s(logi_sn, , g > 0L),
         band3(logi_sn, , g > 0L))
  exp_eq(and3s(logi_so, , w > 1L),
         band3(logi_so, , w > 1L))
  exp_eq(and3s(logi_sp, , n > 9L),
         band3(logi_sp, , n > 9L))
  exp_eq(and3s(logi_sq, q %between% c(-1L, 1L), ),
         band3(logi_sq, q %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_sr, v %between% c(-1L, 1L), ),
         band3(logi_sr, v %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_ss, j %between% c(-1L, 1L), ),
         band3(logi_ss, j %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_st, a %between% c(-1L, 1L), a > 0L),
         band3(logi_st, a %between% c(-1L, 1L), a > 0L))
  exp_eq(and3s(logi_su, y %between% c(-1L, 1L), i > 1L),
         band3(logi_su, y %between% c(-1L, 1L), i > 1L))
  exp_eq(and3s(logi_sv, p %between% c(-1L, 1L), c > 9L),
         band3(logi_sv, p %between% c(-1L, 1L), c > 9L))
  exp_eq(and3s(logi_sw, , ),
         band3(logi_sw, , ))
  exp_eq(and3s(logi_sx, , ),
         band3(logi_sx, , ))
  exp_eq(and3s(logi_sy, , ),
         band3(logi_sy, , ))
  exp_eq(and3s(logi_sz, , h >= 0L),
         band3(logi_sz, , h >= 0L))
  exp_eq(and3s(logi_ta, , d >= 1L),
         band3(logi_ta, , d >= 1L))
  exp_eq(and3s(logi_tb, , m >= 9L),
         band3(logi_tb, , m >= 9L))
  exp_eq(and3s(logi_tc, f %between% c(-1L, 1L), ),
         band3(logi_tc, f %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_td, z %between% c(-1L, 1L), ),
         band3(logi_td, z %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_te, e %between% c(-1L, 1L), ),
         band3(logi_te, e %between% c(-1L, 1L), ))
  exp_eq(and3s(logi_tf, s %between% c(-1L, 1L), c >= 0L),
         band3(logi_tf, s %between% c(-1L, 1L), c >= 0L))
  exp_eq(and3s(logi_tg, c %between% c(-1L, 1L), q >= 1L),
         band3(logi_tg, c %between% c(-1L, 1L), q >= 1L))
  exp_eq(and3s(logi_th, r %between% c(-1L, 1L), v >= 9L),
         band3(logi_th, r %between% c(-1L, 1L), v >= 9L))
  exp_eq(and3s(logi_ti, , ),
         band3(logi_ti, , ))
  exp_eq(and3s(logi_tj, , ),
         band3(logi_tj, , ))
  exp_eq(and3s(logi_tk, , ),
         band3(logi_tk, , ))
  exp_eq(and3s(logi_tl, , logi_n),
         band3(logi_tl, , logi_n))
  exp_eq(and3s(logi_tm, , logi_c),
         band3(logi_tm, , logi_c))
  exp_eq(and3s(logi_tn, , logi_a),
         band3(logi_tn, , logi_a))
  exp_eq(and3s(logi_to, b %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_to, b %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_tp, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_tp, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_tq, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_tq, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_tr, j %in% c(4L, -3L, 2L, 7L, 8L), logi_p),
         band3(logi_tr, j %in% c(4L, -3L, 2L, 7L, 8L), logi_p))
  exp_eq(and3s(logi_ts, v %in% c(4L, -3L, 2L, 7L, 8L), logi_u),
         band3(logi_ts, v %in% c(4L, -3L, 2L, 7L, 8L), logi_u))
  exp_eq(and3s(logi_tt, g %in% c(4L, -3L, 2L, 7L, 8L), logi_l),
         band3(logi_tt, g %in% c(4L, -3L, 2L, 7L, 8L), logi_l))
  exp_eq(and3s(logi_tu, , ),
         band3(logi_tu, , ))
  exp_eq(and3s(logi_tv, , ),
         band3(logi_tv, , ))
  exp_eq(and3s(logi_tw, , ),
         band3(logi_tw, , ))
  exp_eq(and3s(logi_tx, , logi_c),
         band3(logi_tx, , logi_c))
  exp_eq(and3s(logi_ty, , logi_y),
         band3(logi_ty, , logi_y))
  exp_eq(and3s(logi_tz, , logi_d),
         band3(logi_tz, , logi_d))
  exp_eq(and3s(logi_ua, m %in% 1:4, ),
         band3(logi_ua, m %in% 1:4, ))
  exp_eq(and3s(logi_ub, j %in% 1:4, ),
         band3(logi_ub, j %in% 1:4, ))
  exp_eq(and3s(logi_uc, n %in% 1:4, ),
         band3(logi_uc, n %in% 1:4, ))
  exp_eq(and3s(logi_ud, h %in% 1:4, logi_h),
         band3(logi_ud, h %in% 1:4, logi_h))
  exp_eq(and3s(logi_ue, b %in% 1:4, logi_k),
         band3(logi_ue, b %in% 1:4, logi_k))
  exp_eq(and3s(logi_uf, a %in% 1:4, logi_i),
         band3(logi_uf, a %in% 1:4, logi_i))
  exp_eq(and3s(logi_ug, , ),
         band3(logi_ug, , ))
  exp_eq(and3s(logi_uh, , ),
         band3(logi_uh, , ))
  exp_eq(and3s(logi_ui, , ),
         band3(logi_ui, , ))
  exp_eq(and3s(logi_uj, , !logi_f),
         band3(logi_uj, , !logi_f))
  exp_eq(and3s(logi_uk, , !logi_o),
         band3(logi_uk, , !logi_o))
  exp_eq(and3s(logi_ul, , !logi_n),
         band3(logi_ul, , !logi_n))
  exp_eq(and3s(logi_um, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_um, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_un, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_un, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_uo, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_uo, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_up, s %in% c(4L, -3L, 2L, 7L, 8L), !logi_b),
         band3(logi_up, s %in% c(4L, -3L, 2L, 7L, 8L), !logi_b))
  exp_eq(and3s(logi_uq, u %in% c(4L, -3L, 2L, 7L, 8L), !logi_z),
         band3(logi_uq, u %in% c(4L, -3L, 2L, 7L, 8L), !logi_z))
  exp_eq(and3s(logi_ur, l %in% c(4L, -3L, 2L, 7L, 8L), !logi_w),
         band3(logi_ur, l %in% c(4L, -3L, 2L, 7L, 8L), !logi_w))
  exp_eq(and3s(logi_us, , ),
         band3(logi_us, , ))
  exp_eq(and3s(logi_ut, , ),
         band3(logi_ut, , ))
  exp_eq(and3s(logi_uu, , ),
         band3(logi_uu, , ))
  exp_eq(and3s(logi_uv, , !logi_x),
         band3(logi_uv, , !logi_x))
  exp_eq(and3s(logi_uw, , !logi_g),
         band3(logi_uw, , !logi_g))
  exp_eq(and3s(logi_ux, , !logi_z),
         band3(logi_ux, , !logi_z))
  exp_eq(and3s(logi_uy, u %in% 1:4, ),
         band3(logi_uy, u %in% 1:4, ))
  exp_eq(and3s(logi_uz, f %in% 1:4, ),
         band3(logi_uz, f %in% 1:4, ))
  exp_eq(and3s(logi_va, r %in% 1:4, ),
         band3(logi_va, r %in% 1:4, ))
  exp_eq(and3s(logi_vb, b %in% 1:4, !logi_m),
         band3(logi_vb, b %in% 1:4, !logi_m))
  exp_eq(and3s(logi_vc, y %in% 1:4, !logi_h),
         band3(logi_vc, y %in% 1:4, !logi_h))
  exp_eq(and3s(logi_vd, w %in% 1:4, !logi_a),
         band3(logi_vd, w %in% 1:4, !logi_a))
  exp_eq(and3s(logi_ve, , ),
         band3(logi_ve, , ))
  exp_eq(and3s(logi_vf, , ),
         band3(logi_vf, , ))
  exp_eq(and3s(logi_vg, , ),
         band3(logi_vg, , ))
  exp_eq(and3s(logi_vh, , x != 0L),
         band3(logi_vh, , x != 0L))
  exp_eq(and3s(logi_vi, , i != 1L),
         band3(logi_vi, , i != 1L))
  exp_eq(and3s(logi_vj, , l != 9L),
         band3(logi_vj, , l != 9L))
  exp_eq(and3s(logi_vk, f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_vk, f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_vl, z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_vl, z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_vm, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_vm, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_vn, w %in% c(4L, -3L, 2L, 7L, 8L), o != 0L),
         band3(logi_vn, w %in% c(4L, -3L, 2L, 7L, 8L), o != 0L))
  exp_eq(and3s(logi_vo, o %in% c(4L, -3L, 2L, 7L, 8L), k != 1L),
         band3(logi_vo, o %in% c(4L, -3L, 2L, 7L, 8L), k != 1L))
  exp_eq(and3s(logi_vp, g %in% c(4L, -3L, 2L, 7L, 8L), m != 9L),
         band3(logi_vp, g %in% c(4L, -3L, 2L, 7L, 8L), m != 9L))
  exp_eq(and3s(logi_vq, , ),
         band3(logi_vq, , ))
  exp_eq(and3s(logi_vr, , ),
         band3(logi_vr, , ))
  exp_eq(and3s(logi_vs, , ),
         band3(logi_vs, , ))
  exp_eq(and3s(logi_vt, , x != 0L),
         band3(logi_vt, , x != 0L))
  exp_eq(and3s(logi_vu, , l != 1L),
         band3(logi_vu, , l != 1L))
  exp_eq(and3s(logi_vv, , m != 9L),
         band3(logi_vv, , m != 9L))
  exp_eq(and3s(logi_vw, z %in% 1:4, ),
         band3(logi_vw, z %in% 1:4, ))
  exp_eq(and3s(logi_vx, h %in% 1:4, ),
         band3(logi_vx, h %in% 1:4, ))
  exp_eq(and3s(logi_vy, i %in% 1:4, ),
         band3(logi_vy, i %in% 1:4, ))
  exp_eq(and3s(logi_vz, p %in% 1:4, v != 0L),
         band3(logi_vz, p %in% 1:4, v != 0L))
  exp_eq(and3s(logi_wa, s %in% 1:4, o != 1L),
         band3(logi_wa, s %in% 1:4, o != 1L))
  exp_eq(and3s(logi_wb, d %in% 1:4, a != 9L),
         band3(logi_wb, d %in% 1:4, a != 9L))
  exp_eq(and3s(logi_wc, , ),
         band3(logi_wc, , ))
  exp_eq(and3s(logi_wd, , ),
         band3(logi_wd, , ))
  exp_eq(and3s(logi_we, , ),
         band3(logi_we, , ))
  exp_eq(and3s(logi_wf, , n %between% c(-1L, 1L)),
         band3(logi_wf, , n %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wg, , i %between% c(-1L, 1L)),
         band3(logi_wg, , i %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wh, , b %between% c(-1L, 1L)),
         band3(logi_wh, , b %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wi, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_wi, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_wj, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_wj, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_wk, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_wk, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_wl, l %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L)),
         band3(logi_wl, l %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wm, x %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L)),
         band3(logi_wm, x %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wn, m %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L)),
         band3(logi_wn, m %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wo, , ),
         band3(logi_wo, , ))
  exp_eq(and3s(logi_wp, , ),
         band3(logi_wp, , ))
  exp_eq(and3s(logi_wq, , ),
         band3(logi_wq, , ))
  exp_eq(and3s(logi_wr, , d %between% c(-1L, 1L)),
         band3(logi_wr, , d %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ws, , d %between% c(-1L, 1L)),
         band3(logi_ws, , d %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wt, , g %between% c(-1L, 1L)),
         band3(logi_wt, , g %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wu, z %in% 1:4, ),
         band3(logi_wu, z %in% 1:4, ))
  exp_eq(and3s(logi_wv, t %in% 1:4, ),
         band3(logi_wv, t %in% 1:4, ))
  exp_eq(and3s(logi_ww, r %in% 1:4, ),
         band3(logi_ww, r %in% 1:4, ))
  exp_eq(and3s(logi_wx, s %in% 1:4, j %between% c(-1L, 1L)),
         band3(logi_wx, s %in% 1:4, j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wy, u %in% 1:4, q %between% c(-1L, 1L)),
         band3(logi_wy, u %in% 1:4, q %between% c(-1L, 1L)))
  exp_eq(and3s(logi_wz, d %in% 1:4, j %between% c(-1L, 1L)),
         band3(logi_wz, d %in% 1:4, j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_xa, , ),
         band3(logi_xa, , ))
  exp_eq(and3s(logi_xb, , ),
         band3(logi_xb, , ))
  exp_eq(and3s(logi_xc, , ),
         band3(logi_xc, , ))
  exp_eq(and3s(logi_xd, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xd, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xe, , d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xe, , d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xf, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xf, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xg, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_xg, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_xh, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_xh, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_xi, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_xi, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_xj, o %in% c(4L, -3L, 2L, 7L, 8L), h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xj, o %in% c(4L, -3L, 2L, 7L, 8L), h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xk, b %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xk, b %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xl, e %in% c(4L, -3L, 2L, 7L, 8L), s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_xl, e %in% c(4L, -3L, 2L, 7L, 8L), s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_xm, , ),
         band3(logi_xm, , ))
  exp_eq(and3s(logi_xn, , ),
         band3(logi_xn, , ))
  exp_eq(and3s(logi_xo, , ),
         band3(logi_xo, , ))
  exp_eq(and3s(logi_xp, , c %in% 1:4),
         band3(logi_xp, , c %in% 1:4))
  exp_eq(and3s(logi_xq, , x %in% 1:4),
         band3(logi_xq, , x %in% 1:4))
  exp_eq(and3s(logi_xr, , f %in% 1:4),
         band3(logi_xr, , f %in% 1:4))
  exp_eq(and3s(logi_xs, j %in% 1:4, ),
         band3(logi_xs, j %in% 1:4, ))
  exp_eq(and3s(logi_xt, v %in% 1:4, ),
         band3(logi_xt, v %in% 1:4, ))
  exp_eq(and3s(logi_xu, d %in% 1:4, ),
         band3(logi_xu, d %in% 1:4, ))
  exp_eq(and3s(logi_xv, f %in% 1:4, c %in% 1:4),
         band3(logi_xv, f %in% 1:4, c %in% 1:4))
  exp_eq(and3s(logi_xw, w %in% 1:4, j %in% 1:4),
         band3(logi_xw, w %in% 1:4, j %in% 1:4))
  exp_eq(and3s(logi_xx, o %in% 1:4, n %in% 1:4),
         band3(logi_xx, o %in% 1:4, n %in% 1:4))
  exp_eq(and3s(logi_xy, , ),
         band3(logi_xy, , ))
  exp_eq(and3s(logi_xz, , ),
         band3(logi_xz, , ))
  exp_eq(and3s(logi_ya, , ),
         band3(logi_ya, , ))
  exp_eq(and3s(logi_yb, , s < 0L),
         band3(logi_yb, , s < 0L))
  exp_eq(and3s(logi_yc, , e < 1L),
         band3(logi_yc, , e < 1L))
  exp_eq(and3s(logi_yd, , d < 9L),
         band3(logi_yd, , d < 9L))
  exp_eq(and3s(logi_ye, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_ye, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_yf, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_yf, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_yg, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_yg, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_yh, e %in% c(4L, -3L, 2L, 7L, 8L), h < 0L),
         band3(logi_yh, e %in% c(4L, -3L, 2L, 7L, 8L), h < 0L))
  exp_eq(and3s(logi_yi, g %in% c(4L, -3L, 2L, 7L, 8L), p < 1L),
         band3(logi_yi, g %in% c(4L, -3L, 2L, 7L, 8L), p < 1L))
  exp_eq(and3s(logi_yj, e %in% c(4L, -3L, 2L, 7L, 8L), o < 9L),
         band3(logi_yj, e %in% c(4L, -3L, 2L, 7L, 8L), o < 9L))
  exp_eq(and3s(logi_yk, , ),
         band3(logi_yk, , ))
  exp_eq(and3s(logi_yl, , ),
         band3(logi_yl, , ))
  exp_eq(and3s(logi_ym, , ),
         band3(logi_ym, , ))
  exp_eq(and3s(logi_yn, , j < 0L),
         band3(logi_yn, , j < 0L))
  exp_eq(and3s(logi_yo, , t < 1L),
         band3(logi_yo, , t < 1L))
  exp_eq(and3s(logi_yp, , m < 9L),
         band3(logi_yp, , m < 9L))
  exp_eq(and3s(logi_yq, m %in% 1:4, ),
         band3(logi_yq, m %in% 1:4, ))
  exp_eq(and3s(logi_yr, q %in% 1:4, ),
         band3(logi_yr, q %in% 1:4, ))
  exp_eq(and3s(logi_ys, d %in% 1:4, ),
         band3(logi_ys, d %in% 1:4, ))
  exp_eq(and3s(logi_yt, w %in% 1:4, a < 0L),
         band3(logi_yt, w %in% 1:4, a < 0L))
  exp_eq(and3s(logi_yu, k %in% 1:4, d < 1L),
         band3(logi_yu, k %in% 1:4, d < 1L))
  exp_eq(and3s(logi_yv, p %in% 1:4, l < 9L),
         band3(logi_yv, p %in% 1:4, l < 9L))
  exp_eq(and3s(logi_yw, , ),
         band3(logi_yw, , ))
  exp_eq(and3s(logi_yx, , ),
         band3(logi_yx, , ))
  exp_eq(and3s(logi_yy, , ),
         band3(logi_yy, , ))
  exp_eq(and3s(logi_yz, , a <= 0L),
         band3(logi_yz, , a <= 0L))
  exp_eq(and3s(logi_aa, , b <= 1L),
         band3(logi_aa, , b <= 1L))
  exp_eq(and3s(logi_ab, , i <= 9L),
         band3(logi_ab, , i <= 9L))
  exp_eq(and3s(logi_ac, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_ac, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_ad, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_ad, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_ae, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_ae, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_af, f %in% c(4L, -3L, 2L, 7L, 8L), x <= 0L),
         band3(logi_af, f %in% c(4L, -3L, 2L, 7L, 8L), x <= 0L))
  exp_eq(and3s(logi_ag, q %in% c(4L, -3L, 2L, 7L, 8L), a <= 1L),
         band3(logi_ag, q %in% c(4L, -3L, 2L, 7L, 8L), a <= 1L))
  exp_eq(and3s(logi_ah, j %in% c(4L, -3L, 2L, 7L, 8L), d <= 9L),
         band3(logi_ah, j %in% c(4L, -3L, 2L, 7L, 8L), d <= 9L))
  exp_eq(and3s(logi_ai, , ),
         band3(logi_ai, , ))
  exp_eq(and3s(logi_aj, , ),
         band3(logi_aj, , ))
  exp_eq(and3s(logi_ak, , ),
         band3(logi_ak, , ))
  exp_eq(and3s(logi_al, , a <= 0L),
         band3(logi_al, , a <= 0L))
  exp_eq(and3s(logi_am, , l <= 1L),
         band3(logi_am, , l <= 1L))
  exp_eq(and3s(logi_an, , w <= 9L),
         band3(logi_an, , w <= 9L))
  exp_eq(and3s(logi_ao, w %in% 1:4, ),
         band3(logi_ao, w %in% 1:4, ))
  exp_eq(and3s(logi_ap, f %in% 1:4, ),
         band3(logi_ap, f %in% 1:4, ))
  exp_eq(and3s(logi_aq, w %in% 1:4, ),
         band3(logi_aq, w %in% 1:4, ))
  exp_eq(and3s(logi_ar, w %in% 1:4, z <= 0L),
         band3(logi_ar, w %in% 1:4, z <= 0L))
  exp_eq(and3s(logi_as, b %in% 1:4, a <= 1L),
         band3(logi_as, b %in% 1:4, a <= 1L))
  exp_eq(and3s(logi_at, f %in% 1:4, f <= 9L),
         band3(logi_at, f %in% 1:4, f <= 9L))
  exp_eq(and3s(logi_au, , ),
         band3(logi_au, , ))
  exp_eq(and3s(logi_av, , ),
         band3(logi_av, , ))
  exp_eq(and3s(logi_aw, , ),
         band3(logi_aw, , ))
  exp_eq(and3s(logi_ax, , b == 0L),
         band3(logi_ax, , b == 0L))
  exp_eq(and3s(logi_ay, , a == 1L),
         band3(logi_ay, , a == 1L))
  exp_eq(and3s(logi_az, , g == 9L),
         band3(logi_az, , g == 9L))
  exp_eq(and3s(logi_aaa, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aaa, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aab, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aab, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aac, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aac, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aad, h %in% c(4L, -3L, 2L, 7L, 8L), i == 0L),
         band3(logi_aad, h %in% c(4L, -3L, 2L, 7L, 8L), i == 0L))
  exp_eq(and3s(logi_aae, b %in% c(4L, -3L, 2L, 7L, 8L), s == 1L),
         band3(logi_aae, b %in% c(4L, -3L, 2L, 7L, 8L), s == 1L))
  exp_eq(and3s(logi_aaf, e %in% c(4L, -3L, 2L, 7L, 8L), k == 9L),
         band3(logi_aaf, e %in% c(4L, -3L, 2L, 7L, 8L), k == 9L))
  exp_eq(and3s(logi_aag, , ),
         band3(logi_aag, , ))
  exp_eq(and3s(logi_aah, , ),
         band3(logi_aah, , ))
  exp_eq(and3s(logi_aai, , ),
         band3(logi_aai, , ))
  exp_eq(and3s(logi_aaj, , g == 0L),
         band3(logi_aaj, , g == 0L))
  exp_eq(and3s(logi_aak, , u == 1L),
         band3(logi_aak, , u == 1L))
  exp_eq(and3s(logi_aal, , q == 9L),
         band3(logi_aal, , q == 9L))
  exp_eq(and3s(logi_aam, w %in% 1:4, ),
         band3(logi_aam, w %in% 1:4, ))
  exp_eq(and3s(logi_aan, w %in% 1:4, ),
         band3(logi_aan, w %in% 1:4, ))
  exp_eq(and3s(logi_aao, r %in% 1:4, ),
         band3(logi_aao, r %in% 1:4, ))
  exp_eq(and3s(logi_aap, b %in% 1:4, b == 0L),
         band3(logi_aap, b %in% 1:4, b == 0L))
  exp_eq(and3s(logi_aaq, u %in% 1:4, x == 1L),
         band3(logi_aaq, u %in% 1:4, x == 1L))
  exp_eq(and3s(logi_aar, d %in% 1:4, p == 9L),
         band3(logi_aar, d %in% 1:4, p == 9L))
  exp_eq(and3s(logi_aas, , ),
         band3(logi_aas, , ))
  exp_eq(and3s(logi_aat, , ),
         band3(logi_aat, , ))
  exp_eq(and3s(logi_aau, , ),
         band3(logi_aau, , ))
  exp_eq(and3s(logi_aav, , y > 0L),
         band3(logi_aav, , y > 0L))
  exp_eq(and3s(logi_aaw, , b > 1L),
         band3(logi_aaw, , b > 1L))
  exp_eq(and3s(logi_aax, , b > 9L),
         band3(logi_aax, , b > 9L))
  exp_eq(and3s(logi_aay, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aay, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aaz, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aaz, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aba, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aba, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_abb, s %in% c(4L, -3L, 2L, 7L, 8L), i > 0L),
         band3(logi_abb, s %in% c(4L, -3L, 2L, 7L, 8L), i > 0L))
  exp_eq(and3s(logi_abc, o %in% c(4L, -3L, 2L, 7L, 8L), x > 1L),
         band3(logi_abc, o %in% c(4L, -3L, 2L, 7L, 8L), x > 1L))
  exp_eq(and3s(logi_abd, y %in% c(4L, -3L, 2L, 7L, 8L), k > 9L),
         band3(logi_abd, y %in% c(4L, -3L, 2L, 7L, 8L), k > 9L))
  exp_eq(and3s(logi_abe, , ),
         band3(logi_abe, , ))
  exp_eq(and3s(logi_abf, , ),
         band3(logi_abf, , ))
  exp_eq(and3s(logi_abg, , ),
         band3(logi_abg, , ))
  exp_eq(and3s(logi_abh, , w > 0L),
         band3(logi_abh, , w > 0L))
  exp_eq(and3s(logi_abi, , h > 1L),
         band3(logi_abi, , h > 1L))
  exp_eq(and3s(logi_abj, , x > 9L),
         band3(logi_abj, , x > 9L))
  exp_eq(and3s(logi_abk, j %in% 1:4, ),
         band3(logi_abk, j %in% 1:4, ))
  exp_eq(and3s(logi_abl, f %in% 1:4, ),
         band3(logi_abl, f %in% 1:4, ))
  exp_eq(and3s(logi_abm, j %in% 1:4, ),
         band3(logi_abm, j %in% 1:4, ))
  exp_eq(and3s(logi_abn, d %in% 1:4, i > 0L),
         band3(logi_abn, d %in% 1:4, i > 0L))
  exp_eq(and3s(logi_abo, f %in% 1:4, r > 1L),
         band3(logi_abo, f %in% 1:4, r > 1L))
  exp_eq(and3s(logi_abp, i %in% 1:4, k > 9L),
         band3(logi_abp, i %in% 1:4, k > 9L))
  exp_eq(and3s(logi_abq, , ),
         band3(logi_abq, , ))
  exp_eq(and3s(logi_abr, , ),
         band3(logi_abr, , ))
  exp_eq(and3s(logi_abs, , ),
         band3(logi_abs, , ))
  exp_eq(and3s(logi_abt, , p >= 0L),
         band3(logi_abt, , p >= 0L))
  exp_eq(and3s(logi_abu, , u >= 1L),
         band3(logi_abu, , u >= 1L))
  exp_eq(and3s(logi_abv, , x >= 9L),
         band3(logi_abv, , x >= 9L))
  exp_eq(and3s(logi_abw, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_abw, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_abx, b %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_abx, b %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_aby, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(logi_aby, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(logi_abz, v %in% c(4L, -3L, 2L, 7L, 8L), a >= 0L),
         band3(logi_abz, v %in% c(4L, -3L, 2L, 7L, 8L), a >= 0L))
  exp_eq(and3s(logi_aca, r %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L),
         band3(logi_aca, r %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L))
  exp_eq(and3s(logi_acb, x %in% c(4L, -3L, 2L, 7L, 8L), i >= 9L),
         band3(logi_acb, x %in% c(4L, -3L, 2L, 7L, 8L), i >= 9L))
  exp_eq(and3s(logi_acc, , ),
         band3(logi_acc, , ))
  exp_eq(and3s(logi_acd, , ),
         band3(logi_acd, , ))
  exp_eq(and3s(logi_ace, , ),
         band3(logi_ace, , ))
  exp_eq(and3s(logi_acf, , a >= 0L),
         band3(logi_acf, , a >= 0L))
  exp_eq(and3s(logi_acg, , e >= 1L),
         band3(logi_acg, , e >= 1L))
  exp_eq(and3s(logi_ach, , r >= 9L),
         band3(logi_ach, , r >= 9L))
  exp_eq(and3s(logi_aci, n %in% 1:4, ),
         band3(logi_aci, n %in% 1:4, ))
  exp_eq(and3s(logi_acj, p %in% 1:4, ),
         band3(logi_acj, p %in% 1:4, ))
  exp_eq(and3s(logi_ack, m %in% 1:4, ),
         band3(logi_ack, m %in% 1:4, ))
  exp_eq(and3s(logi_acl, e %in% 1:4, c >= 0L),
         band3(logi_acl, e %in% 1:4, c >= 0L))
  exp_eq(and3s(logi_acm, d %in% 1:4, a >= 1L),
         band3(logi_acm, d %in% 1:4, a >= 1L))
  exp_eq(and3s(logi_acn, h %in% 1:4, c >= 9L),
         band3(logi_acn, h %in% 1:4, c >= 9L))
  exp_eq(and3s(logi_aco, , ),
         band3(logi_aco, , ))
  exp_eq(and3s(logi_acp, , ),
         band3(logi_acp, , ))
  exp_eq(and3s(logi_acq, , ),
         band3(logi_acq, , ))
  exp_eq(and3s(logi_acr, , logi_w),
         band3(logi_acr, , logi_w))
  exp_eq(and3s(logi_acs, , logi_f),
         band3(logi_acs, , logi_f))
  exp_eq(and3s(logi_act, , logi_y),
         band3(logi_act, , logi_y))
  exp_eq(and3s(logi_acu, h < 0L, ),
         band3(logi_acu, h < 0L, ))
  exp_eq(and3s(logi_acv, n < 1L, ),
         band3(logi_acv, n < 1L, ))
  exp_eq(and3s(logi_acw, w < 9L, ),
         band3(logi_acw, w < 9L, ))
  exp_eq(and3s(logi_acx, o < 0L, logi_b),
         band3(logi_acx, o < 0L, logi_b))
  exp_eq(and3s(logi_acy, l < 1L, logi_b),
         band3(logi_acy, l < 1L, logi_b))
  exp_eq(and3s(logi_acz, s < 9L, logi_g),
         band3(logi_acz, s < 9L, logi_g))
  exp_eq(and3s(logi_ada, , ),
         band3(logi_ada, , ))
  exp_eq(and3s(logi_adb, , ),
         band3(logi_adb, , ))
  exp_eq(and3s(logi_adc, , ),
         band3(logi_adc, , ))
  exp_eq(and3s(logi_add, , !logi_r),
         band3(logi_add, , !logi_r))
  exp_eq(and3s(logi_ade, , !logi_e),
         band3(logi_ade, , !logi_e))
  exp_eq(and3s(logi_adf, , !logi_g),
         band3(logi_adf, , !logi_g))
  exp_eq(and3s(logi_adg, d < 0L, ),
         band3(logi_adg, d < 0L, ))
  exp_eq(and3s(logi_adh, v < 1L, ),
         band3(logi_adh, v < 1L, ))
  exp_eq(and3s(logi_adi, q < 9L, ),
         band3(logi_adi, q < 9L, ))
  exp_eq(and3s(logi_adj, n < 0L, !logi_x),
         band3(logi_adj, n < 0L, !logi_x))
  exp_eq(and3s(logi_adk, z < 1L, !logi_i),
         band3(logi_adk, z < 1L, !logi_i))
  exp_eq(and3s(logi_adl, m < 9L, !logi_o),
         band3(logi_adl, m < 9L, !logi_o))
  exp_eq(and3s(logi_adm, , ),
         band3(logi_adm, , ))
  exp_eq(and3s(logi_adn, , ),
         band3(logi_adn, , ))
  exp_eq(and3s(logi_ado, , ),
         band3(logi_ado, , ))
  exp_eq(and3s(logi_adp, , e != 0L),
         band3(logi_adp, , e != 0L))
  exp_eq(and3s(logi_adq, , z != 1L),
         band3(logi_adq, , z != 1L))
  exp_eq(and3s(logi_adr, , u != 9L),
         band3(logi_adr, , u != 9L))
  exp_eq(and3s(logi_ads, b < 0L, ),
         band3(logi_ads, b < 0L, ))
  exp_eq(and3s(logi_adt, m < 1L, ),
         band3(logi_adt, m < 1L, ))
  exp_eq(and3s(logi_adu, y < 9L, ),
         band3(logi_adu, y < 9L, ))
  exp_eq(and3s(logi_adv, x < 0L, y != 0L),
         band3(logi_adv, x < 0L, y != 0L))
  exp_eq(and3s(logi_adw, h < 1L, k != 1L),
         band3(logi_adw, h < 1L, k != 1L))
  exp_eq(and3s(logi_adx, a < 9L, k != 9L),
         band3(logi_adx, a < 9L, k != 9L))
  exp_eq(and3s(logi_ady, , ),
         band3(logi_ady, , ))
  exp_eq(and3s(logi_adz, , ),
         band3(logi_adz, , ))
  exp_eq(and3s(logi_aea, , ),
         band3(logi_aea, , ))
  exp_eq(and3s(logi_aeb, , g %between% c(-1L, 1L)),
         band3(logi_aeb, , g %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aec, , a %between% c(-1L, 1L)),
         band3(logi_aec, , a %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aed, , u %between% c(-1L, 1L)),
         band3(logi_aed, , u %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aee, z < 0L, ),
         band3(logi_aee, z < 0L, ))
  exp_eq(and3s(logi_aef, q < 1L, ),
         band3(logi_aef, q < 1L, ))
  exp_eq(and3s(logi_aeg, x < 9L, ),
         band3(logi_aeg, x < 9L, ))
  exp_eq(and3s(logi_aeh, d < 0L, x %between% c(-1L, 1L)),
         band3(logi_aeh, d < 0L, x %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aei, l < 1L, b %between% c(-1L, 1L)),
         band3(logi_aei, l < 1L, b %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aej, i < 9L, k %between% c(-1L, 1L)),
         band3(logi_aej, i < 9L, k %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aek, , ),
         band3(logi_aek, , ))
  exp_eq(and3s(logi_ael, , ),
         band3(logi_ael, , ))
  exp_eq(and3s(logi_aem, , ),
         band3(logi_aem, , ))
  exp_eq(and3s(logi_aen, , m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aen, , m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aeo, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aeo, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aep, , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aep, , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aeq, e < 0L, ),
         band3(logi_aeq, e < 0L, ))
  exp_eq(and3s(logi_aer, d < 1L, ),
         band3(logi_aer, d < 1L, ))
  exp_eq(and3s(logi_aes, i < 9L, ),
         band3(logi_aes, i < 9L, ))
  exp_eq(and3s(logi_aet, z < 0L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aet, z < 0L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aeu, m < 1L, g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aeu, m < 1L, g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aev, q < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aev, q < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aew, , ),
         band3(logi_aew, , ))
  exp_eq(and3s(logi_aex, , ),
         band3(logi_aex, , ))
  exp_eq(and3s(logi_aey, , ),
         band3(logi_aey, , ))
  exp_eq(and3s(logi_aez, , s %in% 1:4),
         band3(logi_aez, , s %in% 1:4))
  exp_eq(and3s(logi_afa, , e %in% 1:4),
         band3(logi_afa, , e %in% 1:4))
  exp_eq(and3s(logi_afb, , p %in% 1:4),
         band3(logi_afb, , p %in% 1:4))
  exp_eq(and3s(logi_afc, a < 0L, ),
         band3(logi_afc, a < 0L, ))
  exp_eq(and3s(logi_afd, u < 1L, ),
         band3(logi_afd, u < 1L, ))
  exp_eq(and3s(logi_afe, z < 9L, ),
         band3(logi_afe, z < 9L, ))
  exp_eq(and3s(logi_aff, d < 0L, d %in% 1:4),
         band3(logi_aff, d < 0L, d %in% 1:4))
  exp_eq(and3s(logi_afg, a < 1L, b %in% 1:4),
         band3(logi_afg, a < 1L, b %in% 1:4))
  exp_eq(and3s(logi_afh, y < 9L, q %in% 1:4),
         band3(logi_afh, y < 9L, q %in% 1:4))
  exp_eq(and3s(logi_afi, , ),
         band3(logi_afi, , ))
  exp_eq(and3s(logi_afj, , ),
         band3(logi_afj, , ))
  exp_eq(and3s(logi_afk, , ),
         band3(logi_afk, , ))
  exp_eq(and3s(logi_afl, , q < 0L),
         band3(logi_afl, , q < 0L))
  exp_eq(and3s(logi_afm, , k < 1L),
         band3(logi_afm, , k < 1L))
  exp_eq(and3s(logi_afn, , f < 9L),
         band3(logi_afn, , f < 9L))
  exp_eq(and3s(logi_afo, y < 0L, ),
         band3(logi_afo, y < 0L, ))
  exp_eq(and3s(logi_afp, j < 1L, ),
         band3(logi_afp, j < 1L, ))
  exp_eq(and3s(logi_afq, l < 9L, ),
         band3(logi_afq, l < 9L, ))
  exp_eq(and3s(logi_afr, e < 0L, y < 0L),
         band3(logi_afr, e < 0L, y < 0L))
  exp_eq(and3s(logi_afs, w < 1L, x < 1L),
         band3(logi_afs, w < 1L, x < 1L))
  exp_eq(and3s(logi_aft, y < 9L, c < 9L),
         band3(logi_aft, y < 9L, c < 9L))
  exp_eq(and3s(logi_afu, , ),
         band3(logi_afu, , ))
  exp_eq(and3s(logi_afv, , ),
         band3(logi_afv, , ))
  exp_eq(and3s(logi_afw, , ),
         band3(logi_afw, , ))
  exp_eq(and3s(logi_afx, , o <= 0L),
         band3(logi_afx, , o <= 0L))
  exp_eq(and3s(logi_afy, , r <= 1L),
         band3(logi_afy, , r <= 1L))
  exp_eq(and3s(logi_afz, , p <= 9L),
         band3(logi_afz, , p <= 9L))
  exp_eq(and3s(logi_aga, g < 0L, ),
         band3(logi_aga, g < 0L, ))
  exp_eq(and3s(logi_agb, u < 1L, ),
         band3(logi_agb, u < 1L, ))
  exp_eq(and3s(logi_agc, i < 9L, ),
         band3(logi_agc, i < 9L, ))
  exp_eq(and3s(logi_agd, e < 0L, d <= 0L),
         band3(logi_agd, e < 0L, d <= 0L))
  exp_eq(and3s(logi_age, m < 1L, i <= 1L),
         band3(logi_age, m < 1L, i <= 1L))
  exp_eq(and3s(logi_agf, x < 9L, h <= 9L),
         band3(logi_agf, x < 9L, h <= 9L))
  exp_eq(and3s(logi_agg, , ),
         band3(logi_agg, , ))
  exp_eq(and3s(logi_agh, , ),
         band3(logi_agh, , ))
  exp_eq(and3s(logi_agi, , ),
         band3(logi_agi, , ))
  exp_eq(and3s(logi_agj, , z == 0L),
         band3(logi_agj, , z == 0L))
  exp_eq(and3s(logi_agk, , i == 1L),
         band3(logi_agk, , i == 1L))
  exp_eq(and3s(logi_agl, , o == 9L),
         band3(logi_agl, , o == 9L))
  exp_eq(and3s(logi_agm, h < 0L, ),
         band3(logi_agm, h < 0L, ))
  exp_eq(and3s(logi_agn, q < 1L, ),
         band3(logi_agn, q < 1L, ))
  exp_eq(and3s(logi_ago, j < 9L, ),
         band3(logi_ago, j < 9L, ))
  exp_eq(and3s(logi_agp, i < 0L, u == 0L),
         band3(logi_agp, i < 0L, u == 0L))
  exp_eq(and3s(logi_agq, x < 1L, e == 1L),
         band3(logi_agq, x < 1L, e == 1L))
  exp_eq(and3s(logi_agr, j < 9L, w == 9L),
         band3(logi_agr, j < 9L, w == 9L))
  exp_eq(and3s(logi_ags, , ),
         band3(logi_ags, , ))
  exp_eq(and3s(logi_agt, , ),
         band3(logi_agt, , ))
  exp_eq(and3s(logi_agu, , ),
         band3(logi_agu, , ))
  exp_eq(and3s(logi_agv, , w > 0L),
         band3(logi_agv, , w > 0L))
  exp_eq(and3s(logi_agw, , k > 1L),
         band3(logi_agw, , k > 1L))
  exp_eq(and3s(logi_agx, , n > 9L),
         band3(logi_agx, , n > 9L))
  exp_eq(and3s(logi_agy, j < 0L, ),
         band3(logi_agy, j < 0L, ))
  exp_eq(and3s(logi_agz, z < 1L, ),
         band3(logi_agz, z < 1L, ))
  exp_eq(and3s(logi_aha, e < 9L, ),
         band3(logi_aha, e < 9L, ))
  exp_eq(and3s(logi_ahb, k < 0L, j > 0L),
         band3(logi_ahb, k < 0L, j > 0L))
  exp_eq(and3s(logi_ahc, m < 1L, f > 1L),
         band3(logi_ahc, m < 1L, f > 1L))
  exp_eq(and3s(logi_ahd, g < 9L, l > 9L),
         band3(logi_ahd, g < 9L, l > 9L))
  exp_eq(and3s(logi_ahe, , ),
         band3(logi_ahe, , ))
  exp_eq(and3s(logi_ahf, , ),
         band3(logi_ahf, , ))
  exp_eq(and3s(logi_ahg, , ),
         band3(logi_ahg, , ))
  exp_eq(and3s(logi_ahh, , z >= 0L),
         band3(logi_ahh, , z >= 0L))
  exp_eq(and3s(logi_ahi, , y >= 1L),
         band3(logi_ahi, , y >= 1L))
  exp_eq(and3s(logi_ahj, , j >= 9L),
         band3(logi_ahj, , j >= 9L))
  exp_eq(and3s(logi_ahk, w < 0L, ),
         band3(logi_ahk, w < 0L, ))
  exp_eq(and3s(logi_ahl, e < 1L, ),
         band3(logi_ahl, e < 1L, ))
  exp_eq(and3s(logi_ahm, p < 9L, ),
         band3(logi_ahm, p < 9L, ))
  exp_eq(and3s(logi_ahn, u < 0L, z >= 0L),
         band3(logi_ahn, u < 0L, z >= 0L))
  exp_eq(and3s(logi_aho, z < 1L, y >= 1L),
         band3(logi_aho, z < 1L, y >= 1L))
  exp_eq(and3s(logi_ahp, u < 9L, t >= 9L),
         band3(logi_ahp, u < 9L, t >= 9L))
  exp_eq(and3s(logi_ahq, , ),
         band3(logi_ahq, , ))
  exp_eq(and3s(logi_ahr, , ),
         band3(logi_ahr, , ))
  exp_eq(and3s(logi_ahs, , ),
         band3(logi_ahs, , ))
  exp_eq(and3s(logi_aht, , logi_c),
         band3(logi_aht, , logi_c))
  exp_eq(and3s(logi_ahu, , logi_c),
         band3(logi_ahu, , logi_c))
  exp_eq(and3s(logi_ahv, , logi_u),
         band3(logi_ahv, , logi_u))
  exp_eq(and3s(logi_ahw, i <= 0L, ),
         band3(logi_ahw, i <= 0L, ))
  exp_eq(and3s(logi_ahx, q <= 1L, ),
         band3(logi_ahx, q <= 1L, ))
  exp_eq(and3s(logi_ahy, n <= 9L, ),
         band3(logi_ahy, n <= 9L, ))
  exp_eq(and3s(logi_ahz, p <= 0L, logi_q),
         band3(logi_ahz, p <= 0L, logi_q))
  exp_eq(and3s(logi_aia, n <= 1L, logi_d),
         band3(logi_aia, n <= 1L, logi_d))
  exp_eq(and3s(logi_aib, w <= 9L, logi_c),
         band3(logi_aib, w <= 9L, logi_c))
  exp_eq(and3s(logi_aic, , ),
         band3(logi_aic, , ))
  exp_eq(and3s(logi_aid, , ),
         band3(logi_aid, , ))
  exp_eq(and3s(logi_aie, , ),
         band3(logi_aie, , ))
  exp_eq(and3s(logi_aif, , !logi_k),
         band3(logi_aif, , !logi_k))
  exp_eq(and3s(logi_aig, , !logi_c),
         band3(logi_aig, , !logi_c))
  exp_eq(and3s(logi_aih, , !logi_l),
         band3(logi_aih, , !logi_l))
  exp_eq(and3s(logi_aii, e <= 0L, ),
         band3(logi_aii, e <= 0L, ))
  exp_eq(and3s(logi_aij, a <= 1L, ),
         band3(logi_aij, a <= 1L, ))
  exp_eq(and3s(logi_aik, d <= 9L, ),
         band3(logi_aik, d <= 9L, ))
  exp_eq(and3s(logi_ail, t <= 0L, !logi_q),
         band3(logi_ail, t <= 0L, !logi_q))
  exp_eq(and3s(logi_aim, g <= 1L, !logi_p),
         band3(logi_aim, g <= 1L, !logi_p))
  exp_eq(and3s(logi_ain, f <= 9L, !logi_w),
         band3(logi_ain, f <= 9L, !logi_w))
  exp_eq(and3s(logi_aio, , ),
         band3(logi_aio, , ))
  exp_eq(and3s(logi_aip, , ),
         band3(logi_aip, , ))
  exp_eq(and3s(logi_aiq, , ),
         band3(logi_aiq, , ))
  exp_eq(and3s(logi_air, , n != 0L),
         band3(logi_air, , n != 0L))
  exp_eq(and3s(logi_ais, , s != 1L),
         band3(logi_ais, , s != 1L))
  exp_eq(and3s(logi_ait, , p != 9L),
         band3(logi_ait, , p != 9L))
  exp_eq(and3s(logi_aiu, h <= 0L, ),
         band3(logi_aiu, h <= 0L, ))
  exp_eq(and3s(logi_aiv, d <= 1L, ),
         band3(logi_aiv, d <= 1L, ))
  exp_eq(and3s(logi_aiw, w <= 9L, ),
         band3(logi_aiw, w <= 9L, ))
  exp_eq(and3s(logi_aix, r <= 0L, h != 0L),
         band3(logi_aix, r <= 0L, h != 0L))
  exp_eq(and3s(logi_aiy, g <= 1L, u != 1L),
         band3(logi_aiy, g <= 1L, u != 1L))
  exp_eq(and3s(logi_aiz, p <= 9L, v != 9L),
         band3(logi_aiz, p <= 9L, v != 9L))
  exp_eq(and3s(logi_aja, , ),
         band3(logi_aja, , ))
  exp_eq(and3s(logi_ajb, , ),
         band3(logi_ajb, , ))
  exp_eq(and3s(logi_ajc, , ),
         band3(logi_ajc, , ))
  exp_eq(and3s(logi_ajd, , w %between% c(-1L, 1L)),
         band3(logi_ajd, , w %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aje, , z %between% c(-1L, 1L)),
         band3(logi_aje, , z %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ajf, , q %between% c(-1L, 1L)),
         band3(logi_ajf, , q %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ajg, v <= 0L, ),
         band3(logi_ajg, v <= 0L, ))
  exp_eq(and3s(logi_ajh, i <= 1L, ),
         band3(logi_ajh, i <= 1L, ))
  exp_eq(and3s(logi_aji, n <= 9L, ),
         band3(logi_aji, n <= 9L, ))
  exp_eq(and3s(logi_ajj, q <= 0L, i %between% c(-1L, 1L)),
         band3(logi_ajj, q <= 0L, i %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ajk, d <= 1L, s %between% c(-1L, 1L)),
         band3(logi_ajk, d <= 1L, s %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ajl, p <= 9L, f %between% c(-1L, 1L)),
         band3(logi_ajl, p <= 9L, f %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ajm, , ),
         band3(logi_ajm, , ))
  exp_eq(and3s(logi_ajn, , ),
         band3(logi_ajn, , ))
  exp_eq(and3s(logi_ajo, , ),
         band3(logi_ajo, , ))
  exp_eq(and3s(logi_ajp, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajp, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajq, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajq, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajr, , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajr, , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajs, v <= 0L, ),
         band3(logi_ajs, v <= 0L, ))
  exp_eq(and3s(logi_ajt, t <= 1L, ),
         band3(logi_ajt, t <= 1L, ))
  exp_eq(and3s(logi_aju, s <= 9L, ),
         band3(logi_aju, s <= 9L, ))
  exp_eq(and3s(logi_ajv, n <= 0L, l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajv, n <= 0L, l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajw, a <= 1L, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajw, a <= 1L, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajx, i <= 9L, b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ajx, i <= 9L, b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ajy, , ),
         band3(logi_ajy, , ))
  exp_eq(and3s(logi_ajz, , ),
         band3(logi_ajz, , ))
  exp_eq(and3s(logi_aka, , ),
         band3(logi_aka, , ))
  exp_eq(and3s(logi_akb, , t %in% 1:4),
         band3(logi_akb, , t %in% 1:4))
  exp_eq(and3s(logi_akc, , g %in% 1:4),
         band3(logi_akc, , g %in% 1:4))
  exp_eq(and3s(logi_akd, , d %in% 1:4),
         band3(logi_akd, , d %in% 1:4))
  exp_eq(and3s(logi_ake, b <= 0L, ),
         band3(logi_ake, b <= 0L, ))
  exp_eq(and3s(logi_akf, y <= 1L, ),
         band3(logi_akf, y <= 1L, ))
  exp_eq(and3s(logi_akg, y <= 9L, ),
         band3(logi_akg, y <= 9L, ))
  exp_eq(and3s(logi_akh, x <= 0L, r %in% 1:4),
         band3(logi_akh, x <= 0L, r %in% 1:4))
  exp_eq(and3s(logi_aki, i <= 1L, a %in% 1:4),
         band3(logi_aki, i <= 1L, a %in% 1:4))
  exp_eq(and3s(logi_akj, d <= 9L, n %in% 1:4),
         band3(logi_akj, d <= 9L, n %in% 1:4))
  exp_eq(and3s(logi_akk, , ),
         band3(logi_akk, , ))
  exp_eq(and3s(logi_akl, , ),
         band3(logi_akl, , ))
  exp_eq(and3s(logi_akm, , ),
         band3(logi_akm, , ))
  exp_eq(and3s(logi_akn, , p < 0L),
         band3(logi_akn, , p < 0L))
  exp_eq(and3s(logi_ako, , w < 1L),
         band3(logi_ako, , w < 1L))
  exp_eq(and3s(logi_akp, , t < 9L),
         band3(logi_akp, , t < 9L))
  exp_eq(and3s(logi_akq, r <= 0L, ),
         band3(logi_akq, r <= 0L, ))
  exp_eq(and3s(logi_akr, w <= 1L, ),
         band3(logi_akr, w <= 1L, ))
  exp_eq(and3s(logi_aks, w <= 9L, ),
         band3(logi_aks, w <= 9L, ))
  exp_eq(and3s(logi_akt, t <= 0L, j < 0L),
         band3(logi_akt, t <= 0L, j < 0L))
  exp_eq(and3s(logi_aku, x <= 1L, b < 1L),
         band3(logi_aku, x <= 1L, b < 1L))
  exp_eq(and3s(logi_akv, e <= 9L, v < 9L),
         band3(logi_akv, e <= 9L, v < 9L))
  exp_eq(and3s(logi_akw, , ),
         band3(logi_akw, , ))
  exp_eq(and3s(logi_akx, , ),
         band3(logi_akx, , ))
  exp_eq(and3s(logi_aky, , ),
         band3(logi_aky, , ))
  exp_eq(and3s(logi_akz, , r <= 0L),
         band3(logi_akz, , r <= 0L))
  exp_eq(and3s(logi_ala, , o <= 1L),
         band3(logi_ala, , o <= 1L))
  exp_eq(and3s(logi_alb, , d <= 9L),
         band3(logi_alb, , d <= 9L))
  exp_eq(and3s(logi_alc, h <= 0L, ),
         band3(logi_alc, h <= 0L, ))
  exp_eq(and3s(logi_ald, a <= 1L, ),
         band3(logi_ald, a <= 1L, ))
  exp_eq(and3s(logi_ale, r <= 9L, ),
         band3(logi_ale, r <= 9L, ))
  exp_eq(and3s(logi_alf, n <= 0L, b <= 0L),
         band3(logi_alf, n <= 0L, b <= 0L))
  exp_eq(and3s(logi_alg, s <= 1L, u <= 1L),
         band3(logi_alg, s <= 1L, u <= 1L))
  exp_eq(and3s(logi_alh, m <= 9L, e <= 9L),
         band3(logi_alh, m <= 9L, e <= 9L))
  exp_eq(and3s(logi_ali, , ),
         band3(logi_ali, , ))
  exp_eq(and3s(logi_alj, , ),
         band3(logi_alj, , ))
  exp_eq(and3s(logi_alk, , ),
         band3(logi_alk, , ))
  exp_eq(and3s(logi_all, , c == 0L),
         band3(logi_all, , c == 0L))
  exp_eq(and3s(logi_alm, , u == 1L),
         band3(logi_alm, , u == 1L))
  exp_eq(and3s(logi_aln, , k == 9L),
         band3(logi_aln, , k == 9L))
  exp_eq(and3s(logi_alo, r <= 0L, ),
         band3(logi_alo, r <= 0L, ))
  exp_eq(and3s(logi_alp, g <= 1L, ),
         band3(logi_alp, g <= 1L, ))
  exp_eq(and3s(logi_alq, m <= 9L, ),
         band3(logi_alq, m <= 9L, ))
  exp_eq(and3s(logi_alr, e <= 0L, x == 0L),
         band3(logi_alr, e <= 0L, x == 0L))
  exp_eq(and3s(logi_als, r <= 1L, a == 1L),
         band3(logi_als, r <= 1L, a == 1L))
  exp_eq(and3s(logi_alt, d <= 9L, h == 9L),
         band3(logi_alt, d <= 9L, h == 9L))
  exp_eq(and3s(logi_alu, , ),
         band3(logi_alu, , ))
  exp_eq(and3s(logi_alv, , ),
         band3(logi_alv, , ))
  exp_eq(and3s(logi_alw, , ),
         band3(logi_alw, , ))
  exp_eq(and3s(logi_alx, , h > 0L),
         band3(logi_alx, , h > 0L))
  exp_eq(and3s(logi_aly, , q > 1L),
         band3(logi_aly, , q > 1L))
  exp_eq(and3s(logi_alz, , c > 9L),
         band3(logi_alz, , c > 9L))
  exp_eq(and3s(logi_ama, e <= 0L, ),
         band3(logi_ama, e <= 0L, ))
  exp_eq(and3s(logi_amb, k <= 1L, ),
         band3(logi_amb, k <= 1L, ))
  exp_eq(and3s(logi_amc, d <= 9L, ),
         band3(logi_amc, d <= 9L, ))
  exp_eq(and3s(logi_amd, f <= 0L, z > 0L),
         band3(logi_amd, f <= 0L, z > 0L))
  exp_eq(and3s(logi_ame, x <= 1L, u > 1L),
         band3(logi_ame, x <= 1L, u > 1L))
  exp_eq(and3s(logi_amf, l <= 9L, b > 9L),
         band3(logi_amf, l <= 9L, b > 9L))
  exp_eq(and3s(logi_amg, , ),
         band3(logi_amg, , ))
  exp_eq(and3s(logi_amh, , ),
         band3(logi_amh, , ))
  exp_eq(and3s(logi_ami, , ),
         band3(logi_ami, , ))
  exp_eq(and3s(logi_amj, , q >= 0L),
         band3(logi_amj, , q >= 0L))
  exp_eq(and3s(logi_amk, , a >= 1L),
         band3(logi_amk, , a >= 1L))
  exp_eq(and3s(logi_aml, , p >= 9L),
         band3(logi_aml, , p >= 9L))
  exp_eq(and3s(logi_amm, k <= 0L, ),
         band3(logi_amm, k <= 0L, ))
  exp_eq(and3s(logi_amn, g <= 1L, ),
         band3(logi_amn, g <= 1L, ))
  exp_eq(and3s(logi_amo, e <= 9L, ),
         band3(logi_amo, e <= 9L, ))
  exp_eq(and3s(logi_amp, r <= 0L, e >= 0L),
         band3(logi_amp, r <= 0L, e >= 0L))
  exp_eq(and3s(logi_amq, x <= 1L, y >= 1L),
         band3(logi_amq, x <= 1L, y >= 1L))
  exp_eq(and3s(logi_amr, v <= 9L, u >= 9L),
         band3(logi_amr, v <= 9L, u >= 9L))
  exp_eq(and3s(logi_ams, , ),
         band3(logi_ams, , ))
  exp_eq(and3s(logi_amt, , ),
         band3(logi_amt, , ))
  exp_eq(and3s(logi_amu, , ),
         band3(logi_amu, , ))
  exp_eq(and3s(logi_amv, , logi_c),
         band3(logi_amv, , logi_c))
  exp_eq(and3s(logi_amw, , logi_j),
         band3(logi_amw, , logi_j))
  exp_eq(and3s(logi_amx, , logi_i),
         band3(logi_amx, , logi_i))
  exp_eq(and3s(logi_amy, u == 0L, ),
         band3(logi_amy, u == 0L, ))
  exp_eq(and3s(logi_amz, m == 1L, ),
         band3(logi_amz, m == 1L, ))
  exp_eq(and3s(logi_ana, p == 9L, ),
         band3(logi_ana, p == 9L, ))
  exp_eq(and3s(logi_anb, d == 0L, logi_t),
         band3(logi_anb, d == 0L, logi_t))
  exp_eq(and3s(logi_anc, y == 1L, logi_r),
         band3(logi_anc, y == 1L, logi_r))
  exp_eq(and3s(logi_and, p == 9L, logi_e),
         band3(logi_and, p == 9L, logi_e))
  exp_eq(and3s(logi_ane, , ),
         band3(logi_ane, , ))
  exp_eq(and3s(logi_anf, , ),
         band3(logi_anf, , ))
  exp_eq(and3s(logi_ang, , ),
         band3(logi_ang, , ))
  exp_eq(and3s(logi_anh, , !logi_s),
         band3(logi_anh, , !logi_s))
  exp_eq(and3s(logi_ani, , !logi_w),
         band3(logi_ani, , !logi_w))
  exp_eq(and3s(logi_anj, , !logi_y),
         band3(logi_anj, , !logi_y))
  exp_eq(and3s(logi_ank, e == 0L, ),
         band3(logi_ank, e == 0L, ))
  exp_eq(and3s(logi_anl, m == 1L, ),
         band3(logi_anl, m == 1L, ))
  exp_eq(and3s(logi_anm, p == 9L, ),
         band3(logi_anm, p == 9L, ))
  exp_eq(and3s(logi_ann, f == 0L, !logi_b),
         band3(logi_ann, f == 0L, !logi_b))
  exp_eq(and3s(logi_ano, p == 1L, !logi_l),
         band3(logi_ano, p == 1L, !logi_l))
  exp_eq(and3s(logi_anp, w == 9L, !logi_w),
         band3(logi_anp, w == 9L, !logi_w))
  exp_eq(and3s(logi_anq, , ),
         band3(logi_anq, , ))
  exp_eq(and3s(logi_anr, , ),
         band3(logi_anr, , ))
  exp_eq(and3s(logi_ans, , ),
         band3(logi_ans, , ))
  exp_eq(and3s(logi_ant, , f != 0L),
         band3(logi_ant, , f != 0L))
  exp_eq(and3s(logi_anu, , h != 1L),
         band3(logi_anu, , h != 1L))
  exp_eq(and3s(logi_anv, , r != 9L),
         band3(logi_anv, , r != 9L))
  exp_eq(and3s(logi_anw, v == 0L, ),
         band3(logi_anw, v == 0L, ))
  exp_eq(and3s(logi_anx, p == 1L, ),
         band3(logi_anx, p == 1L, ))
  exp_eq(and3s(logi_any, k == 9L, ),
         band3(logi_any, k == 9L, ))
  exp_eq(and3s(logi_anz, o == 0L, p != 0L),
         band3(logi_anz, o == 0L, p != 0L))
  exp_eq(and3s(logi_aoa, y == 1L, i != 1L),
         band3(logi_aoa, y == 1L, i != 1L))
  exp_eq(and3s(logi_aob, t == 9L, h != 9L),
         band3(logi_aob, t == 9L, h != 9L))
  exp_eq(and3s(logi_aoc, , ),
         band3(logi_aoc, , ))
  exp_eq(and3s(logi_aod, , ),
         band3(logi_aod, , ))
  exp_eq(and3s(logi_aoe, , ),
         band3(logi_aoe, , ))
  exp_eq(and3s(logi_aof, , x %between% c(-1L, 1L)),
         band3(logi_aof, , x %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aog, , t %between% c(-1L, 1L)),
         band3(logi_aog, , t %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aoh, , h %between% c(-1L, 1L)),
         band3(logi_aoh, , h %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aoi, j == 0L, ),
         band3(logi_aoi, j == 0L, ))
  exp_eq(and3s(logi_aoj, h == 1L, ),
         band3(logi_aoj, h == 1L, ))
  exp_eq(and3s(logi_aok, r == 9L, ),
         band3(logi_aok, r == 9L, ))
  exp_eq(and3s(logi_aol, f == 0L, c %between% c(-1L, 1L)),
         band3(logi_aol, f == 0L, c %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aom, f == 1L, c %between% c(-1L, 1L)),
         band3(logi_aom, f == 1L, c %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aon, q == 9L, k %between% c(-1L, 1L)),
         band3(logi_aon, q == 9L, k %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aoo, , ),
         band3(logi_aoo, , ))
  exp_eq(and3s(logi_aop, , ),
         band3(logi_aop, , ))
  exp_eq(and3s(logi_aoq, , ),
         band3(logi_aoq, , ))
  exp_eq(and3s(logi_aor, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aor, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aos, , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aos, , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aot, , s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aot, , s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aou, o == 0L, ),
         band3(logi_aou, o == 0L, ))
  exp_eq(and3s(logi_aov, p == 1L, ),
         band3(logi_aov, p == 1L, ))
  exp_eq(and3s(logi_aow, k == 9L, ),
         band3(logi_aow, k == 9L, ))
  exp_eq(and3s(logi_aox, z == 0L, j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aox, z == 0L, j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aoy, n == 1L, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aoy, n == 1L, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aoz, m == 9L, u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aoz, m == 9L, u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_apa, , ),
         band3(logi_apa, , ))
  exp_eq(and3s(logi_apb, , ),
         band3(logi_apb, , ))
  exp_eq(and3s(logi_apc, , ),
         band3(logi_apc, , ))
  exp_eq(and3s(logi_apd, , d %in% 1:4),
         band3(logi_apd, , d %in% 1:4))
  exp_eq(and3s(logi_ape, , w %in% 1:4),
         band3(logi_ape, , w %in% 1:4))
  exp_eq(and3s(logi_apf, , t %in% 1:4),
         band3(logi_apf, , t %in% 1:4))
  exp_eq(and3s(logi_apg, u == 0L, ),
         band3(logi_apg, u == 0L, ))
  exp_eq(and3s(logi_aph, m == 1L, ),
         band3(logi_aph, m == 1L, ))
  exp_eq(and3s(logi_api, o == 9L, ),
         band3(logi_api, o == 9L, ))
  exp_eq(and3s(logi_apj, a == 0L, z %in% 1:4),
         band3(logi_apj, a == 0L, z %in% 1:4))
  exp_eq(and3s(logi_apk, m == 1L, n %in% 1:4),
         band3(logi_apk, m == 1L, n %in% 1:4))
  exp_eq(and3s(logi_apl, d == 9L, d %in% 1:4),
         band3(logi_apl, d == 9L, d %in% 1:4))
  exp_eq(and3s(logi_apm, , ),
         band3(logi_apm, , ))
  exp_eq(and3s(logi_apn, , ),
         band3(logi_apn, , ))
  exp_eq(and3s(logi_apo, , ),
         band3(logi_apo, , ))
  exp_eq(and3s(logi_app, , i < 0L),
         band3(logi_app, , i < 0L))
  exp_eq(and3s(logi_apq, , k < 1L),
         band3(logi_apq, , k < 1L))
  exp_eq(and3s(logi_apr, , t < 9L),
         band3(logi_apr, , t < 9L))
  exp_eq(and3s(logi_aps, a == 0L, ),
         band3(logi_aps, a == 0L, ))
  exp_eq(and3s(logi_apt, h == 1L, ),
         band3(logi_apt, h == 1L, ))
  exp_eq(and3s(logi_apu, g == 9L, ),
         band3(logi_apu, g == 9L, ))
  exp_eq(and3s(logi_apv, i == 0L, t < 0L),
         band3(logi_apv, i == 0L, t < 0L))
  exp_eq(and3s(logi_apw, a == 1L, b < 1L),
         band3(logi_apw, a == 1L, b < 1L))
  exp_eq(and3s(logi_apx, y == 9L, n < 9L),
         band3(logi_apx, y == 9L, n < 9L))
  exp_eq(and3s(logi_apy, , ),
         band3(logi_apy, , ))
  exp_eq(and3s(logi_apz, , ),
         band3(logi_apz, , ))
  exp_eq(and3s(logi_aqa, , ),
         band3(logi_aqa, , ))
  exp_eq(and3s(logi_aqb, , l <= 0L),
         band3(logi_aqb, , l <= 0L))
  exp_eq(and3s(logi_aqc, , l <= 1L),
         band3(logi_aqc, , l <= 1L))
  exp_eq(and3s(logi_aqd, , r <= 9L),
         band3(logi_aqd, , r <= 9L))
  exp_eq(and3s(logi_aqe, r == 0L, ),
         band3(logi_aqe, r == 0L, ))
  exp_eq(and3s(logi_aqf, k == 1L, ),
         band3(logi_aqf, k == 1L, ))
  exp_eq(and3s(logi_aqg, s == 9L, ),
         band3(logi_aqg, s == 9L, ))
  exp_eq(and3s(logi_aqh, u == 0L, i <= 0L),
         band3(logi_aqh, u == 0L, i <= 0L))
  exp_eq(and3s(logi_aqi, c == 1L, j <= 1L),
         band3(logi_aqi, c == 1L, j <= 1L))
  exp_eq(and3s(logi_aqj, n == 9L, n <= 9L),
         band3(logi_aqj, n == 9L, n <= 9L))
  exp_eq(and3s(logi_aqk, , ),
         band3(logi_aqk, , ))
  exp_eq(and3s(logi_aql, , ),
         band3(logi_aql, , ))
  exp_eq(and3s(logi_aqm, , ),
         band3(logi_aqm, , ))
  exp_eq(and3s(logi_aqn, , z == 0L),
         band3(logi_aqn, , z == 0L))
  exp_eq(and3s(logi_aqo, , n == 1L),
         band3(logi_aqo, , n == 1L))
  exp_eq(and3s(logi_aqp, , l == 9L),
         band3(logi_aqp, , l == 9L))
  exp_eq(and3s(logi_aqq, p == 0L, ),
         band3(logi_aqq, p == 0L, ))
  exp_eq(and3s(logi_aqr, s == 1L, ),
         band3(logi_aqr, s == 1L, ))
  exp_eq(and3s(logi_aqs, b == 9L, ),
         band3(logi_aqs, b == 9L, ))
  exp_eq(and3s(logi_aqt, u == 0L, x == 0L),
         band3(logi_aqt, u == 0L, x == 0L))
  exp_eq(and3s(logi_aqu, n == 1L, j == 1L),
         band3(logi_aqu, n == 1L, j == 1L))
  exp_eq(and3s(logi_aqv, v == 9L, h == 9L),
         band3(logi_aqv, v == 9L, h == 9L))
  exp_eq(and3s(logi_aqw, , ),
         band3(logi_aqw, , ))
  exp_eq(and3s(logi_aqx, , ),
         band3(logi_aqx, , ))
  exp_eq(and3s(logi_aqy, , ),
         band3(logi_aqy, , ))
  exp_eq(and3s(logi_aqz, , w > 0L),
         band3(logi_aqz, , w > 0L))
  exp_eq(and3s(logi_ara, , p > 1L),
         band3(logi_ara, , p > 1L))
  exp_eq(and3s(logi_arb, , l > 9L),
         band3(logi_arb, , l > 9L))
  exp_eq(and3s(logi_arc, o == 0L, ),
         band3(logi_arc, o == 0L, ))
  exp_eq(and3s(logi_ard, l == 1L, ),
         band3(logi_ard, l == 1L, ))
  exp_eq(and3s(logi_are, h == 9L, ),
         band3(logi_are, h == 9L, ))
  exp_eq(and3s(logi_arf, h == 0L, r > 0L),
         band3(logi_arf, h == 0L, r > 0L))
  exp_eq(and3s(logi_arg, h == 1L, y > 1L),
         band3(logi_arg, h == 1L, y > 1L))
  exp_eq(and3s(logi_arh, g == 9L, q > 9L),
         band3(logi_arh, g == 9L, q > 9L))
  exp_eq(and3s(logi_ari, , ),
         band3(logi_ari, , ))
  exp_eq(and3s(logi_arj, , ),
         band3(logi_arj, , ))
  exp_eq(and3s(logi_ark, , ),
         band3(logi_ark, , ))
  exp_eq(and3s(logi_arl, , h >= 0L),
         band3(logi_arl, , h >= 0L))
  exp_eq(and3s(logi_arm, , a >= 1L),
         band3(logi_arm, , a >= 1L))
  exp_eq(and3s(logi_arn, , g >= 9L),
         band3(logi_arn, , g >= 9L))
  exp_eq(and3s(logi_aro, b == 0L, ),
         band3(logi_aro, b == 0L, ))
  exp_eq(and3s(logi_arp, a == 1L, ),
         band3(logi_arp, a == 1L, ))
  exp_eq(and3s(logi_arq, r == 9L, ),
         band3(logi_arq, r == 9L, ))
  exp_eq(and3s(logi_arr, s == 0L, k >= 0L),
         band3(logi_arr, s == 0L, k >= 0L))
  exp_eq(and3s(logi_ars, h == 1L, q >= 1L),
         band3(logi_ars, h == 1L, q >= 1L))
  exp_eq(and3s(logi_art, h == 9L, c >= 9L),
         band3(logi_art, h == 9L, c >= 9L))
  exp_eq(and3s(logi_aru, , ),
         band3(logi_aru, , ))
  exp_eq(and3s(logi_arv, , ),
         band3(logi_arv, , ))
  exp_eq(and3s(logi_arw, , ),
         band3(logi_arw, , ))
  exp_eq(and3s(logi_arx, , logi_x),
         band3(logi_arx, , logi_x))
  exp_eq(and3s(logi_ary, , logi_b),
         band3(logi_ary, , logi_b))
  exp_eq(and3s(logi_arz, , logi_q),
         band3(logi_arz, , logi_q))
  exp_eq(and3s(logi_asa, b > 0L, ),
         band3(logi_asa, b > 0L, ))
  exp_eq(and3s(logi_asb, i > 1L, ),
         band3(logi_asb, i > 1L, ))
  exp_eq(and3s(logi_asc, f > 9L, ),
         band3(logi_asc, f > 9L, ))
  exp_eq(and3s(logi_asd, s > 0L, logi_k),
         band3(logi_asd, s > 0L, logi_k))
  exp_eq(and3s(logi_ase, d > 1L, logi_u),
         band3(logi_ase, d > 1L, logi_u))
  exp_eq(and3s(logi_asf, v > 9L, logi_g),
         band3(logi_asf, v > 9L, logi_g))
  exp_eq(and3s(logi_asg, , ),
         band3(logi_asg, , ))
  exp_eq(and3s(logi_ash, , ),
         band3(logi_ash, , ))
  exp_eq(and3s(logi_asi, , ),
         band3(logi_asi, , ))
  exp_eq(and3s(logi_asj, , !logi_l),
         band3(logi_asj, , !logi_l))
  exp_eq(and3s(logi_ask, , !logi_z),
         band3(logi_ask, , !logi_z))
  exp_eq(and3s(logi_asl, , !logi_t),
         band3(logi_asl, , !logi_t))
  exp_eq(and3s(logi_asm, c > 0L, ),
         band3(logi_asm, c > 0L, ))
  exp_eq(and3s(logi_asn, m > 1L, ),
         band3(logi_asn, m > 1L, ))
  exp_eq(and3s(logi_aso, t > 9L, ),
         band3(logi_aso, t > 9L, ))
  exp_eq(and3s(logi_asp, f > 0L, !logi_n),
         band3(logi_asp, f > 0L, !logi_n))
  exp_eq(and3s(logi_asq, i > 1L, !logi_p),
         band3(logi_asq, i > 1L, !logi_p))
  exp_eq(and3s(logi_asr, i > 9L, !logi_s),
         band3(logi_asr, i > 9L, !logi_s))
  exp_eq(and3s(logi_ass, , ),
         band3(logi_ass, , ))
  exp_eq(and3s(logi_ast, , ),
         band3(logi_ast, , ))
  exp_eq(and3s(logi_asu, , ),
         band3(logi_asu, , ))
  exp_eq(and3s(logi_asv, , o != 0L),
         band3(logi_asv, , o != 0L))
  exp_eq(and3s(logi_asw, , k != 1L),
         band3(logi_asw, , k != 1L))
  exp_eq(and3s(logi_asx, , b != 9L),
         band3(logi_asx, , b != 9L))
  exp_eq(and3s(logi_asy, w > 0L, ),
         band3(logi_asy, w > 0L, ))
  exp_eq(and3s(logi_asz, r > 1L, ),
         band3(logi_asz, r > 1L, ))
  exp_eq(and3s(logi_ata, v > 9L, ),
         band3(logi_ata, v > 9L, ))
  exp_eq(and3s(logi_atb, b > 0L, i != 0L),
         band3(logi_atb, b > 0L, i != 0L))
  exp_eq(and3s(logi_atc, u > 1L, b != 1L),
         band3(logi_atc, u > 1L, b != 1L))
  exp_eq(and3s(logi_atd, k > 9L, m != 9L),
         band3(logi_atd, k > 9L, m != 9L))
  exp_eq(and3s(logi_ate, , ),
         band3(logi_ate, , ))
  exp_eq(and3s(logi_atf, , ),
         band3(logi_atf, , ))
  exp_eq(and3s(logi_atg, , ),
         band3(logi_atg, , ))
  exp_eq(and3s(logi_ath, , d %between% c(-1L, 1L)),
         band3(logi_ath, , d %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ati, , y %between% c(-1L, 1L)),
         band3(logi_ati, , y %between% c(-1L, 1L)))
  exp_eq(and3s(logi_atj, , s %between% c(-1L, 1L)),
         band3(logi_atj, , s %between% c(-1L, 1L)))
  exp_eq(and3s(logi_atk, m > 0L, ),
         band3(logi_atk, m > 0L, ))
  exp_eq(and3s(logi_atl, d > 1L, ),
         band3(logi_atl, d > 1L, ))
  exp_eq(and3s(logi_atm, u > 9L, ),
         band3(logi_atm, u > 9L, ))
  exp_eq(and3s(logi_atn, n > 0L, g %between% c(-1L, 1L)),
         band3(logi_atn, n > 0L, g %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ato, w > 1L, z %between% c(-1L, 1L)),
         band3(logi_ato, w > 1L, z %between% c(-1L, 1L)))
  exp_eq(and3s(logi_atp, n > 9L, x %between% c(-1L, 1L)),
         band3(logi_atp, n > 9L, x %between% c(-1L, 1L)))
  exp_eq(and3s(logi_atq, , ),
         band3(logi_atq, , ))
  exp_eq(and3s(logi_atr, , ),
         band3(logi_atr, , ))
  exp_eq(and3s(logi_ats, , ),
         band3(logi_ats, , ))
  exp_eq(and3s(logi_att, , d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_att, , d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_atu, , m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_atu, , m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_atv, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_atv, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_atw, r > 0L, ),
         band3(logi_atw, r > 0L, ))
  exp_eq(and3s(logi_atx, c > 1L, ),
         band3(logi_atx, c > 1L, ))
  exp_eq(and3s(logi_aty, i > 9L, ),
         band3(logi_aty, i > 9L, ))
  exp_eq(and3s(logi_atz, l > 0L, g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_atz, l > 0L, g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aua, p > 1L, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aua, p > 1L, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_aub, n > 9L, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_aub, n > 9L, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_auc, , ),
         band3(logi_auc, , ))
  exp_eq(and3s(logi_aud, , ),
         band3(logi_aud, , ))
  exp_eq(and3s(logi_aue, , ),
         band3(logi_aue, , ))
  exp_eq(and3s(logi_auf, , e %in% 1:4),
         band3(logi_auf, , e %in% 1:4))
  exp_eq(and3s(logi_aug, , f %in% 1:4),
         band3(logi_aug, , f %in% 1:4))
  exp_eq(and3s(logi_auh, , t %in% 1:4),
         band3(logi_auh, , t %in% 1:4))
  exp_eq(and3s(logi_aui, o > 0L, ),
         band3(logi_aui, o > 0L, ))
  exp_eq(and3s(logi_auj, x > 1L, ),
         band3(logi_auj, x > 1L, ))
  exp_eq(and3s(logi_auk, c > 9L, ),
         band3(logi_auk, c > 9L, ))
  exp_eq(and3s(logi_aul, x > 0L, c %in% 1:4),
         band3(logi_aul, x > 0L, c %in% 1:4))
  exp_eq(and3s(logi_aum, o > 1L, e %in% 1:4),
         band3(logi_aum, o > 1L, e %in% 1:4))
  exp_eq(and3s(logi_aun, w > 9L, b %in% 1:4),
         band3(logi_aun, w > 9L, b %in% 1:4))
  exp_eq(and3s(logi_auo, , ),
         band3(logi_auo, , ))
  exp_eq(and3s(logi_aup, , ),
         band3(logi_aup, , ))
  exp_eq(and3s(logi_auq, , ),
         band3(logi_auq, , ))
  exp_eq(and3s(logi_aur, , t < 0L),
         band3(logi_aur, , t < 0L))
  exp_eq(and3s(logi_aus, , s < 1L),
         band3(logi_aus, , s < 1L))
  exp_eq(and3s(logi_aut, , h < 9L),
         band3(logi_aut, , h < 9L))
  exp_eq(and3s(logi_auu, d > 0L, ),
         band3(logi_auu, d > 0L, ))
  exp_eq(and3s(logi_auv, q > 1L, ),
         band3(logi_auv, q > 1L, ))
  exp_eq(and3s(logi_auw, y > 9L, ),
         band3(logi_auw, y > 9L, ))
  exp_eq(and3s(logi_aux, i > 0L, s < 0L),
         band3(logi_aux, i > 0L, s < 0L))
  exp_eq(and3s(logi_auy, f > 1L, t < 1L),
         band3(logi_auy, f > 1L, t < 1L))
  exp_eq(and3s(logi_auz, n > 9L, m < 9L),
         band3(logi_auz, n > 9L, m < 9L))
  exp_eq(and3s(logi_ava, , ),
         band3(logi_ava, , ))
  exp_eq(and3s(logi_avb, , ),
         band3(logi_avb, , ))
  exp_eq(and3s(logi_avc, , ),
         band3(logi_avc, , ))
  exp_eq(and3s(logi_avd, , m <= 0L),
         band3(logi_avd, , m <= 0L))
  exp_eq(and3s(logi_ave, , m <= 1L),
         band3(logi_ave, , m <= 1L))
  exp_eq(and3s(logi_avf, , v <= 9L),
         band3(logi_avf, , v <= 9L))
  exp_eq(and3s(logi_avg, h > 0L, ),
         band3(logi_avg, h > 0L, ))
  exp_eq(and3s(logi_avh, b > 1L, ),
         band3(logi_avh, b > 1L, ))
  exp_eq(and3s(logi_avi, x > 9L, ),
         band3(logi_avi, x > 9L, ))
  exp_eq(and3s(logi_avj, z > 0L, m <= 0L),
         band3(logi_avj, z > 0L, m <= 0L))
  exp_eq(and3s(logi_avk, m > 1L, b <= 1L),
         band3(logi_avk, m > 1L, b <= 1L))
  exp_eq(and3s(logi_avl, v > 9L, d <= 9L),
         band3(logi_avl, v > 9L, d <= 9L))
  exp_eq(and3s(logi_avm, , ),
         band3(logi_avm, , ))
  exp_eq(and3s(logi_avn, , ),
         band3(logi_avn, , ))
  exp_eq(and3s(logi_avo, , ),
         band3(logi_avo, , ))
  exp_eq(and3s(logi_avp, , e == 0L),
         band3(logi_avp, , e == 0L))
  exp_eq(and3s(logi_avq, , g == 1L),
         band3(logi_avq, , g == 1L))
  exp_eq(and3s(logi_avr, , n == 9L),
         band3(logi_avr, , n == 9L))
  exp_eq(and3s(logi_avs, r > 0L, ),
         band3(logi_avs, r > 0L, ))
  exp_eq(and3s(logi_avt, x > 1L, ),
         band3(logi_avt, x > 1L, ))
  exp_eq(and3s(logi_avu, k > 9L, ),
         band3(logi_avu, k > 9L, ))
  exp_eq(and3s(logi_avv, e > 0L, p == 0L),
         band3(logi_avv, e > 0L, p == 0L))
  exp_eq(and3s(logi_avw, g > 1L, p == 1L),
         band3(logi_avw, g > 1L, p == 1L))
  exp_eq(and3s(logi_avx, p > 9L, m == 9L),
         band3(logi_avx, p > 9L, m == 9L))
  exp_eq(and3s(logi_avy, , ),
         band3(logi_avy, , ))
  exp_eq(and3s(logi_avz, , ),
         band3(logi_avz, , ))
  exp_eq(and3s(logi_awa, , ),
         band3(logi_awa, , ))
  exp_eq(and3s(logi_awb, , l > 0L),
         band3(logi_awb, , l > 0L))
  exp_eq(and3s(logi_awc, , z > 1L),
         band3(logi_awc, , z > 1L))
  exp_eq(and3s(logi_awd, , g > 9L),
         band3(logi_awd, , g > 9L))
  exp_eq(and3s(logi_awe, g > 0L, ),
         band3(logi_awe, g > 0L, ))
  exp_eq(and3s(logi_awf, v > 1L, ),
         band3(logi_awf, v > 1L, ))
  exp_eq(and3s(logi_awg, v > 9L, ),
         band3(logi_awg, v > 9L, ))
  exp_eq(and3s(logi_awh, p > 0L, q > 0L),
         band3(logi_awh, p > 0L, q > 0L))
  exp_eq(and3s(logi_awi, v > 1L, t > 1L),
         band3(logi_awi, v > 1L, t > 1L))
  exp_eq(and3s(logi_awj, y > 9L, y > 9L),
         band3(logi_awj, y > 9L, y > 9L))
  exp_eq(and3s(logi_awk, , ),
         band3(logi_awk, , ))
  exp_eq(and3s(logi_awl, , ),
         band3(logi_awl, , ))
  exp_eq(and3s(logi_awm, , ),
         band3(logi_awm, , ))
  exp_eq(and3s(logi_awn, , k >= 0L),
         band3(logi_awn, , k >= 0L))
  exp_eq(and3s(logi_awo, , r >= 1L),
         band3(logi_awo, , r >= 1L))
  exp_eq(and3s(logi_awp, , t >= 9L),
         band3(logi_awp, , t >= 9L))
  exp_eq(and3s(logi_awq, f > 0L, ),
         band3(logi_awq, f > 0L, ))
  exp_eq(and3s(logi_awr, o > 1L, ),
         band3(logi_awr, o > 1L, ))
  exp_eq(and3s(logi_aws, w > 9L, ),
         band3(logi_aws, w > 9L, ))
  exp_eq(and3s(logi_awt, i > 0L, a >= 0L),
         band3(logi_awt, i > 0L, a >= 0L))
  exp_eq(and3s(logi_awu, b > 1L, t >= 1L),
         band3(logi_awu, b > 1L, t >= 1L))
  exp_eq(and3s(logi_awv, z > 9L, s >= 9L),
         band3(logi_awv, z > 9L, s >= 9L))
  exp_eq(and3s(logi_aww, , ),
         band3(logi_aww, , ))
  exp_eq(and3s(logi_awx, , ),
         band3(logi_awx, , ))
  exp_eq(and3s(logi_awy, , ),
         band3(logi_awy, , ))
  exp_eq(and3s(logi_awz, , logi_h),
         band3(logi_awz, , logi_h))
  exp_eq(and3s(logi_axa, , logi_s),
         band3(logi_axa, , logi_s))
  exp_eq(and3s(logi_axb, , logi_j),
         band3(logi_axb, , logi_j))
  exp_eq(and3s(logi_axc, b >= 0L, ),
         band3(logi_axc, b >= 0L, ))
  exp_eq(and3s(logi_axd, p >= 1L, ),
         band3(logi_axd, p >= 1L, ))
  exp_eq(and3s(logi_axe, u >= 9L, ),
         band3(logi_axe, u >= 9L, ))
  exp_eq(and3s(logi_axf, c >= 0L, logi_l),
         band3(logi_axf, c >= 0L, logi_l))
  exp_eq(and3s(logi_axg, i >= 1L, logi_r),
         band3(logi_axg, i >= 1L, logi_r))
  exp_eq(and3s(logi_axh, p >= 9L, logi_k),
         band3(logi_axh, p >= 9L, logi_k))
  exp_eq(and3s(logi_axi, , ),
         band3(logi_axi, , ))
  exp_eq(and3s(logi_axj, , ),
         band3(logi_axj, , ))
  exp_eq(and3s(logi_axk, , ),
         band3(logi_axk, , ))
  exp_eq(and3s(logi_axl, , !logi_p),
         band3(logi_axl, , !logi_p))
  exp_eq(and3s(logi_axm, , !logi_i),
         band3(logi_axm, , !logi_i))
  exp_eq(and3s(logi_axn, , !logi_b),
         band3(logi_axn, , !logi_b))
  exp_eq(and3s(logi_axo, e >= 0L, ),
         band3(logi_axo, e >= 0L, ))
  exp_eq(and3s(logi_axp, d >= 1L, ),
         band3(logi_axp, d >= 1L, ))
  exp_eq(and3s(logi_axq, y >= 9L, ),
         band3(logi_axq, y >= 9L, ))
  exp_eq(and3s(logi_axr, b >= 0L, !logi_o),
         band3(logi_axr, b >= 0L, !logi_o))
  exp_eq(and3s(logi_axs, i >= 1L, !logi_z),
         band3(logi_axs, i >= 1L, !logi_z))
  exp_eq(and3s(logi_axt, x >= 9L, !logi_f),
         band3(logi_axt, x >= 9L, !logi_f))
  exp_eq(and3s(logi_axu, , ),
         band3(logi_axu, , ))
  exp_eq(and3s(logi_axv, , ),
         band3(logi_axv, , ))
  exp_eq(and3s(logi_axw, , ),
         band3(logi_axw, , ))
  exp_eq(and3s(logi_axx, , u != 0L),
         band3(logi_axx, , u != 0L))
  exp_eq(and3s(logi_axy, , u != 1L),
         band3(logi_axy, , u != 1L))
  exp_eq(and3s(logi_axz, , r != 9L),
         band3(logi_axz, , r != 9L))
  exp_eq(and3s(logi_aya, g >= 0L, ),
         band3(logi_aya, g >= 0L, ))
  exp_eq(and3s(logi_ayb, x >= 1L, ),
         band3(logi_ayb, x >= 1L, ))
  exp_eq(and3s(logi_ayc, b >= 9L, ),
         band3(logi_ayc, b >= 9L, ))
  exp_eq(and3s(logi_ayd, i >= 0L, x != 0L),
         band3(logi_ayd, i >= 0L, x != 0L))
  exp_eq(and3s(logi_aye, e >= 1L, v != 1L),
         band3(logi_aye, e >= 1L, v != 1L))
  exp_eq(and3s(logi_ayf, x >= 9L, r != 9L),
         band3(logi_ayf, x >= 9L, r != 9L))
  exp_eq(and3s(logi_ayg, , ),
         band3(logi_ayg, , ))
  exp_eq(and3s(logi_ayh, , ),
         band3(logi_ayh, , ))
  exp_eq(and3s(logi_ayi, , ),
         band3(logi_ayi, , ))
  exp_eq(and3s(logi_ayj, , e %between% c(-1L, 1L)),
         band3(logi_ayj, , e %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ayk, , l %between% c(-1L, 1L)),
         band3(logi_ayk, , l %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ayl, , b %between% c(-1L, 1L)),
         band3(logi_ayl, , b %between% c(-1L, 1L)))
  exp_eq(and3s(logi_aym, l >= 0L, ),
         band3(logi_aym, l >= 0L, ))
  exp_eq(and3s(logi_ayn, t >= 1L, ),
         band3(logi_ayn, t >= 1L, ))
  exp_eq(and3s(logi_ayo, n >= 9L, ),
         band3(logi_ayo, n >= 9L, ))
  exp_eq(and3s(logi_ayp, l >= 0L, r %between% c(-1L, 1L)),
         band3(logi_ayp, l >= 0L, r %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ayq, m >= 1L, j %between% c(-1L, 1L)),
         band3(logi_ayq, m >= 1L, j %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ayr, q >= 9L, q %between% c(-1L, 1L)),
         band3(logi_ayr, q >= 9L, q %between% c(-1L, 1L)))
  exp_eq(and3s(logi_ays, , ),
         band3(logi_ays, , ))
  exp_eq(and3s(logi_ayt, , ),
         band3(logi_ayt, , ))
  exp_eq(and3s(logi_ayu, , ),
         band3(logi_ayu, , ))
  exp_eq(and3s(logi_ayv, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ayv, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ayw, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ayw, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ayx, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_ayx, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_ayy, s >= 0L, ),
         band3(logi_ayy, s >= 0L, ))
  exp_eq(and3s(logi_ayz, e >= 1L, ),
         band3(logi_ayz, e >= 1L, ))
  exp_eq(and3s(logi_ba, r >= 9L, ),
         band3(logi_ba, r >= 9L, ))
  exp_eq(and3s(logi_bb, n >= 0L, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bb, n >= 0L, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bc, g >= 1L, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bc, g >= 1L, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_bd, h >= 9L, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(logi_bd, h >= 9L, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(logi_be, , ),
         band3(logi_be, , ))
  exp_eq(and3s(logi_bf, , ),
         band3(logi_bf, , ))
  exp_eq(and3s(logi_bg, , ),
         band3(logi_bg, , ))
  exp_eq(and3s(logi_bh, , z %in% 1:4),
         band3(logi_bh, , z %in% 1:4))
  exp_eq(and3s(logi_bi, , z %in% 1:4),
         band3(logi_bi, , z %in% 1:4))
  exp_eq(and3s(logi_bj, , w %in% 1:4),
         band3(logi_bj, , w %in% 1:4))
  exp_eq(and3s(logi_bk, k >= 0L, ),
         band3(logi_bk, k >= 0L, ))
  exp_eq(and3s(logi_bl, i >= 1L, ),
         band3(logi_bl, i >= 1L, ))
  exp_eq(and3s(logi_bm, b >= 9L, ),
         band3(logi_bm, b >= 9L, ))
  exp_eq(and3s(logi_bn, d >= 0L, n %in% 1:4),
         band3(logi_bn, d >= 0L, n %in% 1:4))
  exp_eq(and3s(logi_bo, k >= 1L, c %in% 1:4),
         band3(logi_bo, k >= 1L, c %in% 1:4))
  exp_eq(and3s(logi_bp, o >= 9L, h %in% 1:4),
         band3(logi_bp, o >= 9L, h %in% 1:4))
  exp_eq(and3s(logi_bq, , ),
         band3(logi_bq, , ))
  exp_eq(and3s(logi_br, , ),
         band3(logi_br, , ))
  exp_eq(and3s(logi_bs, , ),
         band3(logi_bs, , ))
  exp_eq(and3s(logi_bt, , q < 0L),
         band3(logi_bt, , q < 0L))
  exp_eq(and3s(logi_bu, , e < 1L),
         band3(logi_bu, , e < 1L))
  exp_eq(and3s(logi_bv, , i < 9L),
         band3(logi_bv, , i < 9L))
  exp_eq(and3s(logi_bw, u >= 0L, ),
         band3(logi_bw, u >= 0L, ))
  exp_eq(and3s(logi_bx, d >= 1L, ),
         band3(logi_bx, d >= 1L, ))
  exp_eq(and3s(logi_by, n >= 9L, ),
         band3(logi_by, n >= 9L, ))
  exp_eq(and3s(logi_bz, k >= 0L, j < 0L),
         band3(logi_bz, k >= 0L, j < 0L))
  exp_eq(and3s(logi_baa, e >= 1L, r < 1L),
         band3(logi_baa, e >= 1L, r < 1L))
  exp_eq(and3s(logi_bab, x >= 9L, r < 9L),
         band3(logi_bab, x >= 9L, r < 9L))
  exp_eq(and3s(logi_bac, , ),
         band3(logi_bac, , ))
  exp_eq(and3s(logi_bad, , ),
         band3(logi_bad, , ))
  exp_eq(and3s(logi_bae, , ),
         band3(logi_bae, , ))
  exp_eq(and3s(logi_baf, , o <= 0L),
         band3(logi_baf, , o <= 0L))
  exp_eq(and3s(logi_bag, , g <= 1L),
         band3(logi_bag, , g <= 1L))
  exp_eq(and3s(logi_bah, , e <= 9L),
         band3(logi_bah, , e <= 9L))
  exp_eq(and3s(logi_bai, a >= 0L, ),
         band3(logi_bai, a >= 0L, ))
  exp_eq(and3s(logi_baj, m >= 1L, ),
         band3(logi_baj, m >= 1L, ))
  exp_eq(and3s(logi_bak, q >= 9L, ),
         band3(logi_bak, q >= 9L, ))
  exp_eq(and3s(logi_bal, q >= 0L, l <= 0L),
         band3(logi_bal, q >= 0L, l <= 0L))
  exp_eq(and3s(logi_bam, o >= 1L, c <= 1L),
         band3(logi_bam, o >= 1L, c <= 1L))
  exp_eq(and3s(logi_ban, a >= 9L, k <= 9L),
         band3(logi_ban, a >= 9L, k <= 9L))
  exp_eq(and3s(logi_bao, , ),
         band3(logi_bao, , ))
  exp_eq(and3s(logi_bap, , ),
         band3(logi_bap, , ))
  exp_eq(and3s(logi_baq, , ),
         band3(logi_baq, , ))
  exp_eq(and3s(logi_bar, , n == 0L),
         band3(logi_bar, , n == 0L))
  exp_eq(and3s(logi_bas, , i == 1L),
         band3(logi_bas, , i == 1L))
  exp_eq(and3s(logi_bat, , n == 9L),
         band3(logi_bat, , n == 9L))
  exp_eq(and3s(logi_bau, q >= 0L, ),
         band3(logi_bau, q >= 0L, ))
  exp_eq(and3s(logi_bav, r >= 1L, ),
         band3(logi_bav, r >= 1L, ))
  exp_eq(and3s(logi_baw, p >= 9L, ),
         band3(logi_baw, p >= 9L, ))
  exp_eq(and3s(logi_bax, r >= 0L, x == 0L),
         band3(logi_bax, r >= 0L, x == 0L))
  exp_eq(and3s(logi_bay, n >= 1L, u == 1L),
         band3(logi_bay, n >= 1L, u == 1L))
  exp_eq(and3s(logi_baz, z >= 9L, h == 9L),
         band3(logi_baz, z >= 9L, h == 9L))
  exp_eq(and3s(logi_bba, , ),
         band3(logi_bba, , ))
  exp_eq(and3s(logi_bbb, , ),
         band3(logi_bbb, , ))
  exp_eq(and3s(logi_bbc, , ),
         band3(logi_bbc, , ))
  exp_eq(and3s(logi_bbd, , i > 0L),
         band3(logi_bbd, , i > 0L))
  exp_eq(and3s(logi_bbe, , y > 1L),
         band3(logi_bbe, , y > 1L))
  exp_eq(and3s(logi_bbf, , t > 9L),
         band3(logi_bbf, , t > 9L))
  exp_eq(and3s(logi_bbg, t >= 0L, ),
         band3(logi_bbg, t >= 0L, ))
  exp_eq(and3s(logi_bbh, f >= 1L, ),
         band3(logi_bbh, f >= 1L, ))
  exp_eq(and3s(logi_bbi, k >= 9L, ),
         band3(logi_bbi, k >= 9L, ))
  exp_eq(and3s(logi_bbj, r >= 0L, m > 0L),
         band3(logi_bbj, r >= 0L, m > 0L))
  exp_eq(and3s(logi_bbk, i >= 1L, d > 1L),
         band3(logi_bbk, i >= 1L, d > 1L))
  exp_eq(and3s(logi_bbl, t >= 9L, k > 9L),
         band3(logi_bbl, t >= 9L, k > 9L))
  exp_eq(and3s(logi_bbm, , ),
         band3(logi_bbm, , ))
  exp_eq(and3s(logi_bbn, , ),
         band3(logi_bbn, , ))
  exp_eq(and3s(logi_bbo, , ),
         band3(logi_bbo, , ))
  exp_eq(and3s(logi_bbp, , l >= 0L),
         band3(logi_bbp, , l >= 0L))
  exp_eq(and3s(logi_bbq, , m >= 1L),
         band3(logi_bbq, , m >= 1L))
  exp_eq(and3s(logi_bbr, , x >= 9L),
         band3(logi_bbr, , x >= 9L))
  exp_eq(and3s(logi_bbs, v >= 0L, ),
         band3(logi_bbs, v >= 0L, ))
  exp_eq(and3s(logi_bbt, j >= 1L, ),
         band3(logi_bbt, j >= 1L, ))
  exp_eq(and3s(logi_bbu, s >= 9L, ),
         band3(logi_bbu, s >= 9L, ))
  exp_eq(and3s(logi_bbv, p >= 0L, u >= 0L),
         band3(logi_bbv, p >= 0L, u >= 0L))
  exp_eq(and3s(logi_bbw, w >= 1L, a >= 1L),
         band3(logi_bbw, w >= 1L, a >= 1L))
  exp_eq(and3s(logi_bbx, f >= 9L, o >= 9L),
         band3(logi_bbx, f >= 9L, o >= 9L))
  exp_eq(and3s(!logi_bby, , ),
         band3(!logi_bby, , ))
  exp_eq(and3s(!logi_bbz, , ),
         band3(!logi_bbz, , ))
  exp_eq(and3s(!logi_bca, , ),
         band3(!logi_bca, , ))
  exp_eq(and3s(!logi_bcb, , logi_l),
         band3(!logi_bcb, , logi_l))
  exp_eq(and3s(!logi_bcc, , logi_n),
         band3(!logi_bcc, , logi_n))
  exp_eq(and3s(!logi_bcd, , logi_b),
         band3(!logi_bcd, , logi_b))
  exp_eq(and3s(!logi_bce, logi_t, ),
         band3(!logi_bce, logi_t, ))
  exp_eq(and3s(!logi_bcf, logi_x, ),
         band3(!logi_bcf, logi_x, ))
  exp_eq(and3s(!logi_bcg, logi_h, ),
         band3(!logi_bcg, logi_h, ))
  exp_eq(and3s(!logi_bch, logi_h, logi_i),
         band3(!logi_bch, logi_h, logi_i))
  exp_eq(and3s(!logi_bci, logi_f, logi_v),
         band3(!logi_bci, logi_f, logi_v))
  exp_eq(and3s(!logi_bcj, logi_f, logi_i),
         band3(!logi_bcj, logi_f, logi_i))
  exp_eq(and3s(!logi_bck, , ),
         band3(!logi_bck, , ))
  exp_eq(and3s(!logi_bcl, , ),
         band3(!logi_bcl, , ))
  exp_eq(and3s(!logi_bcm, , ),
         band3(!logi_bcm, , ))
  exp_eq(and3s(!logi_bcn, , !logi_w),
         band3(!logi_bcn, , !logi_w))
  exp_eq(and3s(!logi_bco, , !logi_v),
         band3(!logi_bco, , !logi_v))
  exp_eq(and3s(!logi_bcp, , !logi_i),
         band3(!logi_bcp, , !logi_i))
  exp_eq(and3s(!logi_bcq, logi_b, ),
         band3(!logi_bcq, logi_b, ))
  exp_eq(and3s(!logi_bcr, logi_l, ),
         band3(!logi_bcr, logi_l, ))
  exp_eq(and3s(!logi_bcs, logi_l, ),
         band3(!logi_bcs, logi_l, ))
  exp_eq(and3s(!logi_bct, logi_i, !logi_b),
         band3(!logi_bct, logi_i, !logi_b))
  exp_eq(and3s(!logi_bcu, logi_h, !logi_f),
         band3(!logi_bcu, logi_h, !logi_f))
  exp_eq(and3s(!logi_bcv, logi_f, !logi_n),
         band3(!logi_bcv, logi_f, !logi_n))
  exp_eq(and3s(!logi_bcw, , ),
         band3(!logi_bcw, , ))
  exp_eq(and3s(!logi_bcx, , ),
         band3(!logi_bcx, , ))
  exp_eq(and3s(!logi_bcy, , ),
         band3(!logi_bcy, , ))
  exp_eq(and3s(!logi_bcz, , f != 0L),
         band3(!logi_bcz, , f != 0L))
  exp_eq(and3s(!logi_bda, , e != 1L),
         band3(!logi_bda, , e != 1L))
  exp_eq(and3s(!logi_bdb, , r != 9L),
         band3(!logi_bdb, , r != 9L))
  exp_eq(and3s(!logi_bdc, logi_s, ),
         band3(!logi_bdc, logi_s, ))
  exp_eq(and3s(!logi_bdd, logi_s, ),
         band3(!logi_bdd, logi_s, ))
  exp_eq(and3s(!logi_bde, logi_b, ),
         band3(!logi_bde, logi_b, ))
  exp_eq(and3s(!logi_bdf, logi_c, p != 0L),
         band3(!logi_bdf, logi_c, p != 0L))
  exp_eq(and3s(!logi_bdg, logi_n, b != 1L),
         band3(!logi_bdg, logi_n, b != 1L))
  exp_eq(and3s(!logi_bdh, logi_g, c != 9L),
         band3(!logi_bdh, logi_g, c != 9L))
  exp_eq(and3s(!logi_bdi, , ),
         band3(!logi_bdi, , ))
  exp_eq(and3s(!logi_bdj, , ),
         band3(!logi_bdj, , ))
  exp_eq(and3s(!logi_bdk, , ),
         band3(!logi_bdk, , ))
  exp_eq(and3s(!logi_bdl, , t %between% c(-1L, 1L)),
         band3(!logi_bdl, , t %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bdm, , p %between% c(-1L, 1L)),
         band3(!logi_bdm, , p %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bdn, , m %between% c(-1L, 1L)),
         band3(!logi_bdn, , m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bdo, logi_i, ),
         band3(!logi_bdo, logi_i, ))
  exp_eq(and3s(!logi_bdp, logi_w, ),
         band3(!logi_bdp, logi_w, ))
  exp_eq(and3s(!logi_bdq, logi_t, ),
         band3(!logi_bdq, logi_t, ))
  exp_eq(and3s(!logi_bdr, logi_e, t %between% c(-1L, 1L)),
         band3(!logi_bdr, logi_e, t %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bds, logi_t, r %between% c(-1L, 1L)),
         band3(!logi_bds, logi_t, r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bdt, logi_j, c %between% c(-1L, 1L)),
         band3(!logi_bdt, logi_j, c %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bdu, , ),
         band3(!logi_bdu, , ))
  exp_eq(and3s(!logi_bdv, , ),
         band3(!logi_bdv, , ))
  exp_eq(and3s(!logi_bdw, , ),
         band3(!logi_bdw, , ))
  exp_eq(and3s(!logi_bdx, , s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bdx, , s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bdy, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bdy, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bdz, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bdz, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bea, logi_b, ),
         band3(!logi_bea, logi_b, ))
  exp_eq(and3s(!logi_beb, logi_o, ),
         band3(!logi_beb, logi_o, ))
  exp_eq(and3s(!logi_bec, logi_d, ),
         band3(!logi_bec, logi_d, ))
  exp_eq(and3s(!logi_bed, logi_v, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bed, logi_v, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bee, logi_m, t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bee, logi_m, t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bef, logi_e, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bef, logi_e, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_beg, , ),
         band3(!logi_beg, , ))
  exp_eq(and3s(!logi_beh, , ),
         band3(!logi_beh, , ))
  exp_eq(and3s(!logi_bei, , ),
         band3(!logi_bei, , ))
  exp_eq(and3s(!logi_bej, , t %in% 1:4),
         band3(!logi_bej, , t %in% 1:4))
  exp_eq(and3s(!logi_bek, , v %in% 1:4),
         band3(!logi_bek, , v %in% 1:4))
  exp_eq(and3s(!logi_bel, , e %in% 1:4),
         band3(!logi_bel, , e %in% 1:4))
  exp_eq(and3s(!logi_bem, logi_l, ),
         band3(!logi_bem, logi_l, ))
  exp_eq(and3s(!logi_ben, logi_s, ),
         band3(!logi_ben, logi_s, ))
  exp_eq(and3s(!logi_beo, logi_b, ),
         band3(!logi_beo, logi_b, ))
  exp_eq(and3s(!logi_bep, logi_c, r %in% 1:4),
         band3(!logi_bep, logi_c, r %in% 1:4))
  exp_eq(and3s(!logi_beq, logi_j, u %in% 1:4),
         band3(!logi_beq, logi_j, u %in% 1:4))
  exp_eq(and3s(!logi_ber, logi_l, e %in% 1:4),
         band3(!logi_ber, logi_l, e %in% 1:4))
  exp_eq(and3s(!logi_bes, , ),
         band3(!logi_bes, , ))
  exp_eq(and3s(!logi_bet, , ),
         band3(!logi_bet, , ))
  exp_eq(and3s(!logi_beu, , ),
         band3(!logi_beu, , ))
  exp_eq(and3s(!logi_bev, , c < 0L),
         band3(!logi_bev, , c < 0L))
  exp_eq(and3s(!logi_bew, , u < 1L),
         band3(!logi_bew, , u < 1L))
  exp_eq(and3s(!logi_bex, , b < 9L),
         band3(!logi_bex, , b < 9L))
  exp_eq(and3s(!logi_bey, logi_g, ),
         band3(!logi_bey, logi_g, ))
  exp_eq(and3s(!logi_bez, logi_h, ),
         band3(!logi_bez, logi_h, ))
  exp_eq(and3s(!logi_bfa, logi_q, ),
         band3(!logi_bfa, logi_q, ))
  exp_eq(and3s(!logi_bfb, logi_u, k < 0L),
         band3(!logi_bfb, logi_u, k < 0L))
  exp_eq(and3s(!logi_bfc, logi_a, x < 1L),
         band3(!logi_bfc, logi_a, x < 1L))
  exp_eq(and3s(!logi_bfd, logi_h, u < 9L),
         band3(!logi_bfd, logi_h, u < 9L))
  exp_eq(and3s(!logi_bfe, , ),
         band3(!logi_bfe, , ))
  exp_eq(and3s(!logi_bff, , ),
         band3(!logi_bff, , ))
  exp_eq(and3s(!logi_bfg, , ),
         band3(!logi_bfg, , ))
  exp_eq(and3s(!logi_bfh, , y <= 0L),
         band3(!logi_bfh, , y <= 0L))
  exp_eq(and3s(!logi_bfi, , z <= 1L),
         band3(!logi_bfi, , z <= 1L))
  exp_eq(and3s(!logi_bfj, , r <= 9L),
         band3(!logi_bfj, , r <= 9L))
  exp_eq(and3s(!logi_bfk, logi_h, ),
         band3(!logi_bfk, logi_h, ))
  exp_eq(and3s(!logi_bfl, logi_p, ),
         band3(!logi_bfl, logi_p, ))
  exp_eq(and3s(!logi_bfm, logi_y, ),
         band3(!logi_bfm, logi_y, ))
  exp_eq(and3s(!logi_bfn, logi_z, e <= 0L),
         band3(!logi_bfn, logi_z, e <= 0L))
  exp_eq(and3s(!logi_bfo, logi_c, b <= 1L),
         band3(!logi_bfo, logi_c, b <= 1L))
  exp_eq(and3s(!logi_bfp, logi_l, b <= 9L),
         band3(!logi_bfp, logi_l, b <= 9L))
  exp_eq(and3s(!logi_bfq, , ),
         band3(!logi_bfq, , ))
  exp_eq(and3s(!logi_bfr, , ),
         band3(!logi_bfr, , ))
  exp_eq(and3s(!logi_bfs, , ),
         band3(!logi_bfs, , ))
  exp_eq(and3s(!logi_bft, , x == 0L),
         band3(!logi_bft, , x == 0L))
  exp_eq(and3s(!logi_bfu, , h == 1L),
         band3(!logi_bfu, , h == 1L))
  exp_eq(and3s(!logi_bfv, , t == 9L),
         band3(!logi_bfv, , t == 9L))
  exp_eq(and3s(!logi_bfw, logi_p, ),
         band3(!logi_bfw, logi_p, ))
  exp_eq(and3s(!logi_bfx, logi_v, ),
         band3(!logi_bfx, logi_v, ))
  exp_eq(and3s(!logi_bfy, logi_y, ),
         band3(!logi_bfy, logi_y, ))
  exp_eq(and3s(!logi_bfz, logi_v, o == 0L),
         band3(!logi_bfz, logi_v, o == 0L))
  exp_eq(and3s(!logi_bga, logi_t, k == 1L),
         band3(!logi_bga, logi_t, k == 1L))
  exp_eq(and3s(!logi_bgb, logi_d, s == 9L),
         band3(!logi_bgb, logi_d, s == 9L))
  exp_eq(and3s(!logi_bgc, , ),
         band3(!logi_bgc, , ))
  exp_eq(and3s(!logi_bgd, , ),
         band3(!logi_bgd, , ))
  exp_eq(and3s(!logi_bge, , ),
         band3(!logi_bge, , ))
  exp_eq(and3s(!logi_bgf, , x > 0L),
         band3(!logi_bgf, , x > 0L))
  exp_eq(and3s(!logi_bgg, , b > 1L),
         band3(!logi_bgg, , b > 1L))
  exp_eq(and3s(!logi_bgh, , h > 9L),
         band3(!logi_bgh, , h > 9L))
  exp_eq(and3s(!logi_bgi, logi_i, ),
         band3(!logi_bgi, logi_i, ))
  exp_eq(and3s(!logi_bgj, logi_f, ),
         band3(!logi_bgj, logi_f, ))
  exp_eq(and3s(!logi_bgk, logi_j, ),
         band3(!logi_bgk, logi_j, ))
  exp_eq(and3s(!logi_bgl, logi_o, n > 0L),
         band3(!logi_bgl, logi_o, n > 0L))
  exp_eq(and3s(!logi_bgm, logi_h, s > 1L),
         band3(!logi_bgm, logi_h, s > 1L))
  exp_eq(and3s(!logi_bgn, logi_w, s > 9L),
         band3(!logi_bgn, logi_w, s > 9L))
  exp_eq(and3s(!logi_bgo, , ),
         band3(!logi_bgo, , ))
  exp_eq(and3s(!logi_bgp, , ),
         band3(!logi_bgp, , ))
  exp_eq(and3s(!logi_bgq, , ),
         band3(!logi_bgq, , ))
  exp_eq(and3s(!logi_bgr, , u >= 0L),
         band3(!logi_bgr, , u >= 0L))
  exp_eq(and3s(!logi_bgs, , f >= 1L),
         band3(!logi_bgs, , f >= 1L))
  exp_eq(and3s(!logi_bgt, , a >= 9L),
         band3(!logi_bgt, , a >= 9L))
  exp_eq(and3s(!logi_bgu, logi_f, ),
         band3(!logi_bgu, logi_f, ))
  exp_eq(and3s(!logi_bgv, logi_a, ),
         band3(!logi_bgv, logi_a, ))
  exp_eq(and3s(!logi_bgw, logi_z, ),
         band3(!logi_bgw, logi_z, ))
  exp_eq(and3s(!logi_bgx, logi_p, i >= 0L),
         band3(!logi_bgx, logi_p, i >= 0L))
  exp_eq(and3s(!logi_bgy, logi_u, m >= 1L),
         band3(!logi_bgy, logi_u, m >= 1L))
  exp_eq(and3s(!logi_bgz, logi_d, k >= 9L),
         band3(!logi_bgz, logi_d, k >= 9L))
  exp_eq(and3s(!logi_bha, , ),
         band3(!logi_bha, , ))
  exp_eq(and3s(!logi_bhb, , ),
         band3(!logi_bhb, , ))
  exp_eq(and3s(!logi_bhc, , ),
         band3(!logi_bhc, , ))
  exp_eq(and3s(!logi_bhd, , logi_g),
         band3(!logi_bhd, , logi_g))
  exp_eq(and3s(!logi_bhe, , logi_n),
         band3(!logi_bhe, , logi_n))
  exp_eq(and3s(!logi_bhf, , logi_y),
         band3(!logi_bhf, , logi_y))
  exp_eq(and3s(!logi_bhg, !logi_d, ),
         band3(!logi_bhg, !logi_d, ))
  exp_eq(and3s(!logi_bhh, !logi_l, ),
         band3(!logi_bhh, !logi_l, ))
  exp_eq(and3s(!logi_bhi, !logi_l, ),
         band3(!logi_bhi, !logi_l, ))
  exp_eq(and3s(!logi_bhj, !logi_p, logi_q),
         band3(!logi_bhj, !logi_p, logi_q))
  exp_eq(and3s(!logi_bhk, !logi_i, logi_x),
         band3(!logi_bhk, !logi_i, logi_x))
  exp_eq(and3s(!logi_bhl, !logi_x, logi_i),
         band3(!logi_bhl, !logi_x, logi_i))
  exp_eq(and3s(!logi_bhm, , ),
         band3(!logi_bhm, , ))
  exp_eq(and3s(!logi_bhn, , ),
         band3(!logi_bhn, , ))
  exp_eq(and3s(!logi_bho, , ),
         band3(!logi_bho, , ))
  exp_eq(and3s(!logi_bhp, , !logi_a),
         band3(!logi_bhp, , !logi_a))
  exp_eq(and3s(!logi_bhq, , !logi_l),
         band3(!logi_bhq, , !logi_l))
  exp_eq(and3s(!logi_bhr, , !logi_x),
         band3(!logi_bhr, , !logi_x))
  exp_eq(and3s(!logi_bhs, !logi_g, ),
         band3(!logi_bhs, !logi_g, ))
  exp_eq(and3s(!logi_bht, !logi_b, ),
         band3(!logi_bht, !logi_b, ))
  exp_eq(and3s(!logi_bhu, !logi_g, ),
         band3(!logi_bhu, !logi_g, ))
  exp_eq(and3s(!logi_bhv, !logi_f, !logi_u),
         band3(!logi_bhv, !logi_f, !logi_u))
  exp_eq(and3s(!logi_bhw, !logi_q, !logi_d),
         band3(!logi_bhw, !logi_q, !logi_d))
  exp_eq(and3s(!logi_bhx, !logi_y, !logi_l),
         band3(!logi_bhx, !logi_y, !logi_l))
  exp_eq(and3s(!logi_bhy, , ),
         band3(!logi_bhy, , ))
  exp_eq(and3s(!logi_bhz, , ),
         band3(!logi_bhz, , ))
  exp_eq(and3s(!logi_bia, , ),
         band3(!logi_bia, , ))
  exp_eq(and3s(!logi_bib, , x != 0L),
         band3(!logi_bib, , x != 0L))
  exp_eq(and3s(!logi_bic, , o != 1L),
         band3(!logi_bic, , o != 1L))
  exp_eq(and3s(!logi_bid, , z != 9L),
         band3(!logi_bid, , z != 9L))
  exp_eq(and3s(!logi_bie, !logi_k, ),
         band3(!logi_bie, !logi_k, ))
  exp_eq(and3s(!logi_bif, !logi_x, ),
         band3(!logi_bif, !logi_x, ))
  exp_eq(and3s(!logi_big, !logi_c, ),
         band3(!logi_big, !logi_c, ))
  exp_eq(and3s(!logi_bih, !logi_q, c != 0L),
         band3(!logi_bih, !logi_q, c != 0L))
  exp_eq(and3s(!logi_bii, !logi_p, w != 1L),
         band3(!logi_bii, !logi_p, w != 1L))
  exp_eq(and3s(!logi_bij, !logi_p, u != 9L),
         band3(!logi_bij, !logi_p, u != 9L))
  exp_eq(and3s(!logi_bik, , ),
         band3(!logi_bik, , ))
  exp_eq(and3s(!logi_bil, , ),
         band3(!logi_bil, , ))
  exp_eq(and3s(!logi_bim, , ),
         band3(!logi_bim, , ))
  exp_eq(and3s(!logi_bin, , v %between% c(-1L, 1L)),
         band3(!logi_bin, , v %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bio, , n %between% c(-1L, 1L)),
         band3(!logi_bio, , n %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bip, , o %between% c(-1L, 1L)),
         band3(!logi_bip, , o %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_biq, !logi_k, ),
         band3(!logi_biq, !logi_k, ))
  exp_eq(and3s(!logi_bir, !logi_a, ),
         band3(!logi_bir, !logi_a, ))
  exp_eq(and3s(!logi_bis, !logi_k, ),
         band3(!logi_bis, !logi_k, ))
  exp_eq(and3s(!logi_bit, !logi_t, q %between% c(-1L, 1L)),
         band3(!logi_bit, !logi_t, q %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_biu, !logi_s, z %between% c(-1L, 1L)),
         band3(!logi_biu, !logi_s, z %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_biv, !logi_s, m %between% c(-1L, 1L)),
         band3(!logi_biv, !logi_s, m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_biw, , ),
         band3(!logi_biw, , ))
  exp_eq(and3s(!logi_bix, , ),
         band3(!logi_bix, , ))
  exp_eq(and3s(!logi_biy, , ),
         band3(!logi_biy, , ))
  exp_eq(and3s(!logi_biz, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_biz, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bja, , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bja, , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bjb, , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bjb, , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bjc, !logi_d, ),
         band3(!logi_bjc, !logi_d, ))
  exp_eq(and3s(!logi_bjd, !logi_c, ),
         band3(!logi_bjd, !logi_c, ))
  exp_eq(and3s(!logi_bje, !logi_r, ),
         band3(!logi_bje, !logi_r, ))
  exp_eq(and3s(!logi_bjf, !logi_x, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bjf, !logi_x, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bjg, !logi_c, u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bjg, !logi_c, u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bjh, !logi_a, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bjh, !logi_a, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bji, , ),
         band3(!logi_bji, , ))
  exp_eq(and3s(!logi_bjj, , ),
         band3(!logi_bjj, , ))
  exp_eq(and3s(!logi_bjk, , ),
         band3(!logi_bjk, , ))
  exp_eq(and3s(!logi_bjl, , x %in% 1:4),
         band3(!logi_bjl, , x %in% 1:4))
  exp_eq(and3s(!logi_bjm, , d %in% 1:4),
         band3(!logi_bjm, , d %in% 1:4))
  exp_eq(and3s(!logi_bjn, , m %in% 1:4),
         band3(!logi_bjn, , m %in% 1:4))
  exp_eq(and3s(!logi_bjo, !logi_e, ),
         band3(!logi_bjo, !logi_e, ))
  exp_eq(and3s(!logi_bjp, !logi_r, ),
         band3(!logi_bjp, !logi_r, ))
  exp_eq(and3s(!logi_bjq, !logi_m, ),
         band3(!logi_bjq, !logi_m, ))
  exp_eq(and3s(!logi_bjr, !logi_z, z %in% 1:4),
         band3(!logi_bjr, !logi_z, z %in% 1:4))
  exp_eq(and3s(!logi_bjs, !logi_z, o %in% 1:4),
         band3(!logi_bjs, !logi_z, o %in% 1:4))
  exp_eq(and3s(!logi_bjt, !logi_e, q %in% 1:4),
         band3(!logi_bjt, !logi_e, q %in% 1:4))
  exp_eq(and3s(!logi_bju, , ),
         band3(!logi_bju, , ))
  exp_eq(and3s(!logi_bjv, , ),
         band3(!logi_bjv, , ))
  exp_eq(and3s(!logi_bjw, , ),
         band3(!logi_bjw, , ))
  exp_eq(and3s(!logi_bjx, , i < 0L),
         band3(!logi_bjx, , i < 0L))
  exp_eq(and3s(!logi_bjy, , o < 1L),
         band3(!logi_bjy, , o < 1L))
  exp_eq(and3s(!logi_bjz, , e < 9L),
         band3(!logi_bjz, , e < 9L))
  exp_eq(and3s(!logi_bka, !logi_a, ),
         band3(!logi_bka, !logi_a, ))
  exp_eq(and3s(!logi_bkb, !logi_m, ),
         band3(!logi_bkb, !logi_m, ))
  exp_eq(and3s(!logi_bkc, !logi_b, ),
         band3(!logi_bkc, !logi_b, ))
  exp_eq(and3s(!logi_bkd, !logi_y, r < 0L),
         band3(!logi_bkd, !logi_y, r < 0L))
  exp_eq(and3s(!logi_bke, !logi_l, u < 1L),
         band3(!logi_bke, !logi_l, u < 1L))
  exp_eq(and3s(!logi_bkf, !logi_y, l < 9L),
         band3(!logi_bkf, !logi_y, l < 9L))
  exp_eq(and3s(!logi_bkg, , ),
         band3(!logi_bkg, , ))
  exp_eq(and3s(!logi_bkh, , ),
         band3(!logi_bkh, , ))
  exp_eq(and3s(!logi_bki, , ),
         band3(!logi_bki, , ))
  exp_eq(and3s(!logi_bkj, , u <= 0L),
         band3(!logi_bkj, , u <= 0L))
  exp_eq(and3s(!logi_bkk, , i <= 1L),
         band3(!logi_bkk, , i <= 1L))
  exp_eq(and3s(!logi_bkl, , e <= 9L),
         band3(!logi_bkl, , e <= 9L))
  exp_eq(and3s(!logi_bkm, !logi_l, ),
         band3(!logi_bkm, !logi_l, ))
  exp_eq(and3s(!logi_bkn, !logi_v, ),
         band3(!logi_bkn, !logi_v, ))
  exp_eq(and3s(!logi_bko, !logi_s, ),
         band3(!logi_bko, !logi_s, ))
  exp_eq(and3s(!logi_bkp, !logi_n, o <= 0L),
         band3(!logi_bkp, !logi_n, o <= 0L))
  exp_eq(and3s(!logi_bkq, !logi_u, s <= 1L),
         band3(!logi_bkq, !logi_u, s <= 1L))
  exp_eq(and3s(!logi_bkr, !logi_d, m <= 9L),
         band3(!logi_bkr, !logi_d, m <= 9L))
  exp_eq(and3s(!logi_bks, , ),
         band3(!logi_bks, , ))
  exp_eq(and3s(!logi_bkt, , ),
         band3(!logi_bkt, , ))
  exp_eq(and3s(!logi_bku, , ),
         band3(!logi_bku, , ))
  exp_eq(and3s(!logi_bkv, , p == 0L),
         band3(!logi_bkv, , p == 0L))
  exp_eq(and3s(!logi_bkw, , j == 1L),
         band3(!logi_bkw, , j == 1L))
  exp_eq(and3s(!logi_bkx, , c == 9L),
         band3(!logi_bkx, , c == 9L))
  exp_eq(and3s(!logi_bky, !logi_e, ),
         band3(!logi_bky, !logi_e, ))
  exp_eq(and3s(!logi_bkz, !logi_r, ),
         band3(!logi_bkz, !logi_r, ))
  exp_eq(and3s(!logi_bla, !logi_y, ),
         band3(!logi_bla, !logi_y, ))
  exp_eq(and3s(!logi_blb, !logi_m, d == 0L),
         band3(!logi_blb, !logi_m, d == 0L))
  exp_eq(and3s(!logi_blc, !logi_e, g == 1L),
         band3(!logi_blc, !logi_e, g == 1L))
  exp_eq(and3s(!logi_bld, !logi_a, z == 9L),
         band3(!logi_bld, !logi_a, z == 9L))
  exp_eq(and3s(!logi_ble, , ),
         band3(!logi_ble, , ))
  exp_eq(and3s(!logi_blf, , ),
         band3(!logi_blf, , ))
  exp_eq(and3s(!logi_blg, , ),
         band3(!logi_blg, , ))
  exp_eq(and3s(!logi_blh, , j > 0L),
         band3(!logi_blh, , j > 0L))
  exp_eq(and3s(!logi_bli, , s > 1L),
         band3(!logi_bli, , s > 1L))
  exp_eq(and3s(!logi_blj, , t > 9L),
         band3(!logi_blj, , t > 9L))
  exp_eq(and3s(!logi_blk, !logi_b, ),
         band3(!logi_blk, !logi_b, ))
  exp_eq(and3s(!logi_bll, !logi_f, ),
         band3(!logi_bll, !logi_f, ))
  exp_eq(and3s(!logi_blm, !logi_k, ),
         band3(!logi_blm, !logi_k, ))
  exp_eq(and3s(!logi_bln, !logi_h, c > 0L),
         band3(!logi_bln, !logi_h, c > 0L))
  exp_eq(and3s(!logi_blo, !logi_j, t > 1L),
         band3(!logi_blo, !logi_j, t > 1L))
  exp_eq(and3s(!logi_blp, !logi_k, v > 9L),
         band3(!logi_blp, !logi_k, v > 9L))
  exp_eq(and3s(!logi_blq, , ),
         band3(!logi_blq, , ))
  exp_eq(and3s(!logi_blr, , ),
         band3(!logi_blr, , ))
  exp_eq(and3s(!logi_bls, , ),
         band3(!logi_bls, , ))
  exp_eq(and3s(!logi_blt, , n >= 0L),
         band3(!logi_blt, , n >= 0L))
  exp_eq(and3s(!logi_blu, , e >= 1L),
         band3(!logi_blu, , e >= 1L))
  exp_eq(and3s(!logi_blv, , j >= 9L),
         band3(!logi_blv, , j >= 9L))
  exp_eq(and3s(!logi_blw, !logi_f, ),
         band3(!logi_blw, !logi_f, ))
  exp_eq(and3s(!logi_blx, !logi_u, ),
         band3(!logi_blx, !logi_u, ))
  exp_eq(and3s(!logi_bly, !logi_e, ),
         band3(!logi_bly, !logi_e, ))
  exp_eq(and3s(!logi_blz, !logi_k, b >= 0L),
         band3(!logi_blz, !logi_k, b >= 0L))
  exp_eq(and3s(!logi_bma, !logi_w, g >= 1L),
         band3(!logi_bma, !logi_w, g >= 1L))
  exp_eq(and3s(!logi_bmb, !logi_d, f >= 9L),
         band3(!logi_bmb, !logi_d, f >= 9L))
  exp_eq(and3s(!logi_bmc, , ),
         band3(!logi_bmc, , ))
  exp_eq(and3s(!logi_bmd, , ),
         band3(!logi_bmd, , ))
  exp_eq(and3s(!logi_bme, , ),
         band3(!logi_bme, , ))
  exp_eq(and3s(!logi_bmf, , logi_u),
         band3(!logi_bmf, , logi_u))
  exp_eq(and3s(!logi_bmg, , logi_y),
         band3(!logi_bmg, , logi_y))
  exp_eq(and3s(!logi_bmh, , logi_u),
         band3(!logi_bmh, , logi_u))
  exp_eq(and3s(!logi_bmi, p != 0L, ),
         band3(!logi_bmi, p != 0L, ))
  exp_eq(and3s(!logi_bmj, p != 1L, ),
         band3(!logi_bmj, p != 1L, ))
  exp_eq(and3s(!logi_bmk, z != 9L, ),
         band3(!logi_bmk, z != 9L, ))
  exp_eq(and3s(!logi_bml, g != 0L, logi_c),
         band3(!logi_bml, g != 0L, logi_c))
  exp_eq(and3s(!logi_bmm, c != 1L, logi_e),
         band3(!logi_bmm, c != 1L, logi_e))
  exp_eq(and3s(!logi_bmn, d != 9L, logi_k),
         band3(!logi_bmn, d != 9L, logi_k))
  exp_eq(and3s(!logi_bmo, , ),
         band3(!logi_bmo, , ))
  exp_eq(and3s(!logi_bmp, , ),
         band3(!logi_bmp, , ))
  exp_eq(and3s(!logi_bmq, , ),
         band3(!logi_bmq, , ))
  exp_eq(and3s(!logi_bmr, , !logi_c),
         band3(!logi_bmr, , !logi_c))
  exp_eq(and3s(!logi_bms, , !logi_y),
         band3(!logi_bms, , !logi_y))
  exp_eq(and3s(!logi_bmt, , !logi_f),
         band3(!logi_bmt, , !logi_f))
  exp_eq(and3s(!logi_bmu, z != 0L, ),
         band3(!logi_bmu, z != 0L, ))
  exp_eq(and3s(!logi_bmv, a != 1L, ),
         band3(!logi_bmv, a != 1L, ))
  exp_eq(and3s(!logi_bmw, y != 9L, ),
         band3(!logi_bmw, y != 9L, ))
  exp_eq(and3s(!logi_bmx, r != 0L, !logi_n),
         band3(!logi_bmx, r != 0L, !logi_n))
  exp_eq(and3s(!logi_bmy, h != 1L, !logi_u),
         band3(!logi_bmy, h != 1L, !logi_u))
  exp_eq(and3s(!logi_bmz, e != 9L, !logi_c),
         band3(!logi_bmz, e != 9L, !logi_c))
  exp_eq(and3s(!logi_bna, , ),
         band3(!logi_bna, , ))
  exp_eq(and3s(!logi_bnb, , ),
         band3(!logi_bnb, , ))
  exp_eq(and3s(!logi_bnc, , ),
         band3(!logi_bnc, , ))
  exp_eq(and3s(!logi_bnd, , n != 0L),
         band3(!logi_bnd, , n != 0L))
  exp_eq(and3s(!logi_bne, , y != 1L),
         band3(!logi_bne, , y != 1L))
  exp_eq(and3s(!logi_bnf, , k != 9L),
         band3(!logi_bnf, , k != 9L))
  exp_eq(and3s(!logi_bng, d != 0L, ),
         band3(!logi_bng, d != 0L, ))
  exp_eq(and3s(!logi_bnh, t != 1L, ),
         band3(!logi_bnh, t != 1L, ))
  exp_eq(and3s(!logi_bni, m != 9L, ),
         band3(!logi_bni, m != 9L, ))
  exp_eq(and3s(!logi_bnj, m != 0L, v != 0L),
         band3(!logi_bnj, m != 0L, v != 0L))
  exp_eq(and3s(!logi_bnk, v != 1L, z != 1L),
         band3(!logi_bnk, v != 1L, z != 1L))
  exp_eq(and3s(!logi_bnl, o != 9L, n != 9L),
         band3(!logi_bnl, o != 9L, n != 9L))
  exp_eq(and3s(!logi_bnm, , ),
         band3(!logi_bnm, , ))
  exp_eq(and3s(!logi_bnn, , ),
         band3(!logi_bnn, , ))
  exp_eq(and3s(!logi_bno, , ),
         band3(!logi_bno, , ))
  exp_eq(and3s(!logi_bnp, , a %between% c(-1L, 1L)),
         band3(!logi_bnp, , a %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bnq, , e %between% c(-1L, 1L)),
         band3(!logi_bnq, , e %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bnr, , i %between% c(-1L, 1L)),
         band3(!logi_bnr, , i %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bns, w != 0L, ),
         band3(!logi_bns, w != 0L, ))
  exp_eq(and3s(!logi_bnt, n != 1L, ),
         band3(!logi_bnt, n != 1L, ))
  exp_eq(and3s(!logi_bnu, s != 9L, ),
         band3(!logi_bnu, s != 9L, ))
  exp_eq(and3s(!logi_bnv, j != 0L, b %between% c(-1L, 1L)),
         band3(!logi_bnv, j != 0L, b %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bnw, c != 1L, l %between% c(-1L, 1L)),
         band3(!logi_bnw, c != 1L, l %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bnx, q != 9L, v %between% c(-1L, 1L)),
         band3(!logi_bnx, q != 9L, v %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bny, , ),
         band3(!logi_bny, , ))
  exp_eq(and3s(!logi_bnz, , ),
         band3(!logi_bnz, , ))
  exp_eq(and3s(!logi_boa, , ),
         band3(!logi_boa, , ))
  exp_eq(and3s(!logi_bob, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bob, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_boc, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_boc, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bod, , q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bod, , q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_boe, t != 0L, ),
         band3(!logi_boe, t != 0L, ))
  exp_eq(and3s(!logi_bof, z != 1L, ),
         band3(!logi_bof, z != 1L, ))
  exp_eq(and3s(!logi_bog, t != 9L, ),
         band3(!logi_bog, t != 9L, ))
  exp_eq(and3s(!logi_boh, k != 0L, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_boh, k != 0L, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_boi, r != 1L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_boi, r != 1L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_boj, v != 9L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_boj, v != 9L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bok, , ),
         band3(!logi_bok, , ))
  exp_eq(and3s(!logi_bol, , ),
         band3(!logi_bol, , ))
  exp_eq(and3s(!logi_bom, , ),
         band3(!logi_bom, , ))
  exp_eq(and3s(!logi_bon, , b %in% 1:4),
         band3(!logi_bon, , b %in% 1:4))
  exp_eq(and3s(!logi_boo, , u %in% 1:4),
         band3(!logi_boo, , u %in% 1:4))
  exp_eq(and3s(!logi_bop, , v %in% 1:4),
         band3(!logi_bop, , v %in% 1:4))
  exp_eq(and3s(!logi_boq, i != 0L, ),
         band3(!logi_boq, i != 0L, ))
  exp_eq(and3s(!logi_bor, v != 1L, ),
         band3(!logi_bor, v != 1L, ))
  exp_eq(and3s(!logi_bos, t != 9L, ),
         band3(!logi_bos, t != 9L, ))
  exp_eq(and3s(!logi_bot, o != 0L, f %in% 1:4),
         band3(!logi_bot, o != 0L, f %in% 1:4))
  exp_eq(and3s(!logi_bou, l != 1L, p %in% 1:4),
         band3(!logi_bou, l != 1L, p %in% 1:4))
  exp_eq(and3s(!logi_bov, r != 9L, o %in% 1:4),
         band3(!logi_bov, r != 9L, o %in% 1:4))
  exp_eq(and3s(!logi_bow, , ),
         band3(!logi_bow, , ))
  exp_eq(and3s(!logi_box, , ),
         band3(!logi_box, , ))
  exp_eq(and3s(!logi_boy, , ),
         band3(!logi_boy, , ))
  exp_eq(and3s(!logi_boz, , y < 0L),
         band3(!logi_boz, , y < 0L))
  exp_eq(and3s(!logi_bpa, , e < 1L),
         band3(!logi_bpa, , e < 1L))
  exp_eq(and3s(!logi_bpb, , e < 9L),
         band3(!logi_bpb, , e < 9L))
  exp_eq(and3s(!logi_bpc, g != 0L, ),
         band3(!logi_bpc, g != 0L, ))
  exp_eq(and3s(!logi_bpd, q != 1L, ),
         band3(!logi_bpd, q != 1L, ))
  exp_eq(and3s(!logi_bpe, m != 9L, ),
         band3(!logi_bpe, m != 9L, ))
  exp_eq(and3s(!logi_bpf, t != 0L, i < 0L),
         band3(!logi_bpf, t != 0L, i < 0L))
  exp_eq(and3s(!logi_bpg, u != 1L, u < 1L),
         band3(!logi_bpg, u != 1L, u < 1L))
  exp_eq(and3s(!logi_bph, h != 9L, i < 9L),
         band3(!logi_bph, h != 9L, i < 9L))
  exp_eq(and3s(!logi_bpi, , ),
         band3(!logi_bpi, , ))
  exp_eq(and3s(!logi_bpj, , ),
         band3(!logi_bpj, , ))
  exp_eq(and3s(!logi_bpk, , ),
         band3(!logi_bpk, , ))
  exp_eq(and3s(!logi_bpl, , f <= 0L),
         band3(!logi_bpl, , f <= 0L))
  exp_eq(and3s(!logi_bpm, , s <= 1L),
         band3(!logi_bpm, , s <= 1L))
  exp_eq(and3s(!logi_bpn, , p <= 9L),
         band3(!logi_bpn, , p <= 9L))
  exp_eq(and3s(!logi_bpo, f != 0L, ),
         band3(!logi_bpo, f != 0L, ))
  exp_eq(and3s(!logi_bpp, f != 1L, ),
         band3(!logi_bpp, f != 1L, ))
  exp_eq(and3s(!logi_bpq, y != 9L, ),
         band3(!logi_bpq, y != 9L, ))
  exp_eq(and3s(!logi_bpr, y != 0L, c <= 0L),
         band3(!logi_bpr, y != 0L, c <= 0L))
  exp_eq(and3s(!logi_bps, e != 1L, j <= 1L),
         band3(!logi_bps, e != 1L, j <= 1L))
  exp_eq(and3s(!logi_bpt, a != 9L, r <= 9L),
         band3(!logi_bpt, a != 9L, r <= 9L))
  exp_eq(and3s(!logi_bpu, , ),
         band3(!logi_bpu, , ))
  exp_eq(and3s(!logi_bpv, , ),
         band3(!logi_bpv, , ))
  exp_eq(and3s(!logi_bpw, , ),
         band3(!logi_bpw, , ))
  exp_eq(and3s(!logi_bpx, , p == 0L),
         band3(!logi_bpx, , p == 0L))
  exp_eq(and3s(!logi_bpy, , q == 1L),
         band3(!logi_bpy, , q == 1L))
  exp_eq(and3s(!logi_bpz, , z == 9L),
         band3(!logi_bpz, , z == 9L))
  exp_eq(and3s(!logi_bqa, g != 0L, ),
         band3(!logi_bqa, g != 0L, ))
  exp_eq(and3s(!logi_bqb, b != 1L, ),
         band3(!logi_bqb, b != 1L, ))
  exp_eq(and3s(!logi_bqc, d != 9L, ),
         band3(!logi_bqc, d != 9L, ))
  exp_eq(and3s(!logi_bqd, j != 0L, j == 0L),
         band3(!logi_bqd, j != 0L, j == 0L))
  exp_eq(and3s(!logi_bqe, t != 1L, y == 1L),
         band3(!logi_bqe, t != 1L, y == 1L))
  exp_eq(and3s(!logi_bqf, z != 9L, n == 9L),
         band3(!logi_bqf, z != 9L, n == 9L))
  exp_eq(and3s(!logi_bqg, , ),
         band3(!logi_bqg, , ))
  exp_eq(and3s(!logi_bqh, , ),
         band3(!logi_bqh, , ))
  exp_eq(and3s(!logi_bqi, , ),
         band3(!logi_bqi, , ))
  exp_eq(and3s(!logi_bqj, , q > 0L),
         band3(!logi_bqj, , q > 0L))
  exp_eq(and3s(!logi_bqk, , w > 1L),
         band3(!logi_bqk, , w > 1L))
  exp_eq(and3s(!logi_bql, , a > 9L),
         band3(!logi_bql, , a > 9L))
  exp_eq(and3s(!logi_bqm, r != 0L, ),
         band3(!logi_bqm, r != 0L, ))
  exp_eq(and3s(!logi_bqn, w != 1L, ),
         band3(!logi_bqn, w != 1L, ))
  exp_eq(and3s(!logi_bqo, u != 9L, ),
         band3(!logi_bqo, u != 9L, ))
  exp_eq(and3s(!logi_bqp, x != 0L, e > 0L),
         band3(!logi_bqp, x != 0L, e > 0L))
  exp_eq(and3s(!logi_bqq, r != 1L, s > 1L),
         band3(!logi_bqq, r != 1L, s > 1L))
  exp_eq(and3s(!logi_bqr, e != 9L, r > 9L),
         band3(!logi_bqr, e != 9L, r > 9L))
  exp_eq(and3s(!logi_bqs, , ),
         band3(!logi_bqs, , ))
  exp_eq(and3s(!logi_bqt, , ),
         band3(!logi_bqt, , ))
  exp_eq(and3s(!logi_bqu, , ),
         band3(!logi_bqu, , ))
  exp_eq(and3s(!logi_bqv, , k >= 0L),
         band3(!logi_bqv, , k >= 0L))
  exp_eq(and3s(!logi_bqw, , s >= 1L),
         band3(!logi_bqw, , s >= 1L))
  exp_eq(and3s(!logi_bqx, , m >= 9L),
         band3(!logi_bqx, , m >= 9L))
  exp_eq(and3s(!logi_bqy, c != 0L, ),
         band3(!logi_bqy, c != 0L, ))
  exp_eq(and3s(!logi_bqz, v != 1L, ),
         band3(!logi_bqz, v != 1L, ))
  exp_eq(and3s(!logi_bra, x != 9L, ),
         band3(!logi_bra, x != 9L, ))
  exp_eq(and3s(!logi_brb, t != 0L, y >= 0L),
         band3(!logi_brb, t != 0L, y >= 0L))
  exp_eq(and3s(!logi_brc, q != 1L, f >= 1L),
         band3(!logi_brc, q != 1L, f >= 1L))
  exp_eq(and3s(!logi_brd, z != 9L, t >= 9L),
         band3(!logi_brd, z != 9L, t >= 9L))
  exp_eq(and3s(!logi_bre, , ),
         band3(!logi_bre, , ))
  exp_eq(and3s(!logi_brf, , ),
         band3(!logi_brf, , ))
  exp_eq(and3s(!logi_brg, , ),
         band3(!logi_brg, , ))
  exp_eq(and3s(!logi_brh, , logi_c),
         band3(!logi_brh, , logi_c))
  exp_eq(and3s(!logi_bri, , logi_g),
         band3(!logi_bri, , logi_g))
  exp_eq(and3s(!logi_brj, , logi_u),
         band3(!logi_brj, , logi_u))
  exp_eq(and3s(!logi_brk, p %between% c(-1L, 1L), ),
         band3(!logi_brk, p %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_brl, y %between% c(-1L, 1L), ),
         band3(!logi_brl, y %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_brm, d %between% c(-1L, 1L), ),
         band3(!logi_brm, d %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_brn, e %between% c(-1L, 1L), logi_l),
         band3(!logi_brn, e %between% c(-1L, 1L), logi_l))
  exp_eq(and3s(!logi_bro, l %between% c(-1L, 1L), logi_n),
         band3(!logi_bro, l %between% c(-1L, 1L), logi_n))
  exp_eq(and3s(!logi_brp, m %between% c(-1L, 1L), logi_w),
         band3(!logi_brp, m %between% c(-1L, 1L), logi_w))
  exp_eq(and3s(!logi_brq, , ),
         band3(!logi_brq, , ))
  exp_eq(and3s(!logi_brr, , ),
         band3(!logi_brr, , ))
  exp_eq(and3s(!logi_brs, , ),
         band3(!logi_brs, , ))
  exp_eq(and3s(!logi_brt, , !logi_a),
         band3(!logi_brt, , !logi_a))
  exp_eq(and3s(!logi_bru, , !logi_w),
         band3(!logi_bru, , !logi_w))
  exp_eq(and3s(!logi_brv, , !logi_x),
         band3(!logi_brv, , !logi_x))
  exp_eq(and3s(!logi_brw, o %between% c(-1L, 1L), ),
         band3(!logi_brw, o %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_brx, v %between% c(-1L, 1L), ),
         band3(!logi_brx, v %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bry, c %between% c(-1L, 1L), ),
         band3(!logi_bry, c %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_brz, l %between% c(-1L, 1L), !logi_e),
         band3(!logi_brz, l %between% c(-1L, 1L), !logi_e))
  exp_eq(and3s(!logi_bsa, n %between% c(-1L, 1L), !logi_i),
         band3(!logi_bsa, n %between% c(-1L, 1L), !logi_i))
  exp_eq(and3s(!logi_bsb, d %between% c(-1L, 1L), !logi_v),
         band3(!logi_bsb, d %between% c(-1L, 1L), !logi_v))
  exp_eq(and3s(!logi_bsc, , ),
         band3(!logi_bsc, , ))
  exp_eq(and3s(!logi_bsd, , ),
         band3(!logi_bsd, , ))
  exp_eq(and3s(!logi_bse, , ),
         band3(!logi_bse, , ))
  exp_eq(and3s(!logi_bsf, , u != 0L),
         band3(!logi_bsf, , u != 0L))
  exp_eq(and3s(!logi_bsg, , h != 1L),
         band3(!logi_bsg, , h != 1L))
  exp_eq(and3s(!logi_bsh, , d != 9L),
         band3(!logi_bsh, , d != 9L))
  exp_eq(and3s(!logi_bsi, h %between% c(-1L, 1L), ),
         band3(!logi_bsi, h %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsj, s %between% c(-1L, 1L), ),
         band3(!logi_bsj, s %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsk, y %between% c(-1L, 1L), ),
         band3(!logi_bsk, y %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsl, m %between% c(-1L, 1L), i != 0L),
         band3(!logi_bsl, m %between% c(-1L, 1L), i != 0L))
  exp_eq(and3s(!logi_bsm, h %between% c(-1L, 1L), v != 1L),
         band3(!logi_bsm, h %between% c(-1L, 1L), v != 1L))
  exp_eq(and3s(!logi_bsn, e %between% c(-1L, 1L), i != 9L),
         band3(!logi_bsn, e %between% c(-1L, 1L), i != 9L))
  exp_eq(and3s(!logi_bso, , ),
         band3(!logi_bso, , ))
  exp_eq(and3s(!logi_bsp, , ),
         band3(!logi_bsp, , ))
  exp_eq(and3s(!logi_bsq, , ),
         band3(!logi_bsq, , ))
  exp_eq(and3s(!logi_bsr, , o %between% c(-1L, 1L)),
         band3(!logi_bsr, , o %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bss, , u %between% c(-1L, 1L)),
         band3(!logi_bss, , u %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bst, , d %between% c(-1L, 1L)),
         band3(!logi_bst, , d %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bsu, c %between% c(-1L, 1L), ),
         band3(!logi_bsu, c %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsv, q %between% c(-1L, 1L), ),
         band3(!logi_bsv, q %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsw, k %between% c(-1L, 1L), ),
         band3(!logi_bsw, k %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bsx, l %between% c(-1L, 1L), e %between% c(-1L, 1L)),
         band3(!logi_bsx, l %between% c(-1L, 1L), e %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bsy, e %between% c(-1L, 1L), i %between% c(-1L, 1L)),
         band3(!logi_bsy, e %between% c(-1L, 1L), i %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bsz, b %between% c(-1L, 1L), b %between% c(-1L, 1L)),
         band3(!logi_bsz, b %between% c(-1L, 1L), b %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_bta, , ),
         band3(!logi_bta, , ))
  exp_eq(and3s(!logi_btb, , ),
         band3(!logi_btb, , ))
  exp_eq(and3s(!logi_btc, , ),
         band3(!logi_btc, , ))
  exp_eq(and3s(!logi_btd, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_btd, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_bte, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_bte, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_btf, , s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_btf, , s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_btg, g %between% c(-1L, 1L), ),
         band3(!logi_btg, g %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bth, m %between% c(-1L, 1L), ),
         band3(!logi_bth, m %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bti, i %between% c(-1L, 1L), ),
         band3(!logi_bti, i %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_btj, j %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_btj, j %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_btk, w %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_btk, w %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_btl, b %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_btl, b %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_btm, , ),
         band3(!logi_btm, , ))
  exp_eq(and3s(!logi_btn, , ),
         band3(!logi_btn, , ))
  exp_eq(and3s(!logi_bto, , ),
         band3(!logi_bto, , ))
  exp_eq(and3s(!logi_btp, , r %in% 1:4),
         band3(!logi_btp, , r %in% 1:4))
  exp_eq(and3s(!logi_btq, , j %in% 1:4),
         band3(!logi_btq, , j %in% 1:4))
  exp_eq(and3s(!logi_btr, , x %in% 1:4),
         band3(!logi_btr, , x %in% 1:4))
  exp_eq(and3s(!logi_bts, a %between% c(-1L, 1L), ),
         band3(!logi_bts, a %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_btt, x %between% c(-1L, 1L), ),
         band3(!logi_btt, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_btu, v %between% c(-1L, 1L), ),
         band3(!logi_btu, v %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_btv, u %between% c(-1L, 1L), t %in% 1:4),
         band3(!logi_btv, u %between% c(-1L, 1L), t %in% 1:4))
  exp_eq(and3s(!logi_btw, d %between% c(-1L, 1L), y %in% 1:4),
         band3(!logi_btw, d %between% c(-1L, 1L), y %in% 1:4))
  exp_eq(and3s(!logi_btx, s %between% c(-1L, 1L), f %in% 1:4),
         band3(!logi_btx, s %between% c(-1L, 1L), f %in% 1:4))
  exp_eq(and3s(!logi_bty, , ),
         band3(!logi_bty, , ))
  exp_eq(and3s(!logi_btz, , ),
         band3(!logi_btz, , ))
  exp_eq(and3s(!logi_bua, , ),
         band3(!logi_bua, , ))
  exp_eq(and3s(!logi_bub, , g < 0L),
         band3(!logi_bub, , g < 0L))
  exp_eq(and3s(!logi_buc, , i < 1L),
         band3(!logi_buc, , i < 1L))
  exp_eq(and3s(!logi_bud, , o < 9L),
         band3(!logi_bud, , o < 9L))
  exp_eq(and3s(!logi_bue, h %between% c(-1L, 1L), ),
         band3(!logi_bue, h %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_buf, x %between% c(-1L, 1L), ),
         band3(!logi_buf, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bug, v %between% c(-1L, 1L), ),
         band3(!logi_bug, v %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_buh, m %between% c(-1L, 1L), n < 0L),
         band3(!logi_buh, m %between% c(-1L, 1L), n < 0L))
  exp_eq(and3s(!logi_bui, c %between% c(-1L, 1L), d < 1L),
         band3(!logi_bui, c %between% c(-1L, 1L), d < 1L))
  exp_eq(and3s(!logi_buj, a %between% c(-1L, 1L), i < 9L),
         band3(!logi_buj, a %between% c(-1L, 1L), i < 9L))
  exp_eq(and3s(!logi_buk, , ),
         band3(!logi_buk, , ))
  exp_eq(and3s(!logi_bul, , ),
         band3(!logi_bul, , ))
  exp_eq(and3s(!logi_bum, , ),
         band3(!logi_bum, , ))
  exp_eq(and3s(!logi_bun, , w <= 0L),
         band3(!logi_bun, , w <= 0L))
  exp_eq(and3s(!logi_buo, , b <= 1L),
         band3(!logi_buo, , b <= 1L))
  exp_eq(and3s(!logi_bup, , i <= 9L),
         band3(!logi_bup, , i <= 9L))
  exp_eq(and3s(!logi_buq, n %between% c(-1L, 1L), ),
         band3(!logi_buq, n %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bur, x %between% c(-1L, 1L), ),
         band3(!logi_bur, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bus, j %between% c(-1L, 1L), ),
         band3(!logi_bus, j %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_but, y %between% c(-1L, 1L), o <= 0L),
         band3(!logi_but, y %between% c(-1L, 1L), o <= 0L))
  exp_eq(and3s(!logi_buu, p %between% c(-1L, 1L), f <= 1L),
         band3(!logi_buu, p %between% c(-1L, 1L), f <= 1L))
  exp_eq(and3s(!logi_buv, o %between% c(-1L, 1L), d <= 9L),
         band3(!logi_buv, o %between% c(-1L, 1L), d <= 9L))
  exp_eq(and3s(!logi_buw, , ),
         band3(!logi_buw, , ))
  exp_eq(and3s(!logi_bux, , ),
         band3(!logi_bux, , ))
  exp_eq(and3s(!logi_buy, , ),
         band3(!logi_buy, , ))
  exp_eq(and3s(!logi_buz, , s == 0L),
         band3(!logi_buz, , s == 0L))
  exp_eq(and3s(!logi_bva, , m == 1L),
         band3(!logi_bva, , m == 1L))
  exp_eq(and3s(!logi_bvb, , l == 9L),
         band3(!logi_bvb, , l == 9L))
  exp_eq(and3s(!logi_bvc, x %between% c(-1L, 1L), ),
         band3(!logi_bvc, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bvd, r %between% c(-1L, 1L), ),
         band3(!logi_bvd, r %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bve, n %between% c(-1L, 1L), ),
         band3(!logi_bve, n %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bvf, o %between% c(-1L, 1L), s == 0L),
         band3(!logi_bvf, o %between% c(-1L, 1L), s == 0L))
  exp_eq(and3s(!logi_bvg, d %between% c(-1L, 1L), y == 1L),
         band3(!logi_bvg, d %between% c(-1L, 1L), y == 1L))
  exp_eq(and3s(!logi_bvh, m %between% c(-1L, 1L), q == 9L),
         band3(!logi_bvh, m %between% c(-1L, 1L), q == 9L))
  exp_eq(and3s(!logi_bvi, , ),
         band3(!logi_bvi, , ))
  exp_eq(and3s(!logi_bvj, , ),
         band3(!logi_bvj, , ))
  exp_eq(and3s(!logi_bvk, , ),
         band3(!logi_bvk, , ))
  exp_eq(and3s(!logi_bvl, , s > 0L),
         band3(!logi_bvl, , s > 0L))
  exp_eq(and3s(!logi_bvm, , d > 1L),
         band3(!logi_bvm, , d > 1L))
  exp_eq(and3s(!logi_bvn, , g > 9L),
         band3(!logi_bvn, , g > 9L))
  exp_eq(and3s(!logi_bvo, x %between% c(-1L, 1L), ),
         band3(!logi_bvo, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bvp, k %between% c(-1L, 1L), ),
         band3(!logi_bvp, k %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bvq, x %between% c(-1L, 1L), ),
         band3(!logi_bvq, x %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bvr, j %between% c(-1L, 1L), n > 0L),
         band3(!logi_bvr, j %between% c(-1L, 1L), n > 0L))
  exp_eq(and3s(!logi_bvs, r %between% c(-1L, 1L), s > 1L),
         band3(!logi_bvs, r %between% c(-1L, 1L), s > 1L))
  exp_eq(and3s(!logi_bvt, q %between% c(-1L, 1L), y > 9L),
         band3(!logi_bvt, q %between% c(-1L, 1L), y > 9L))
  exp_eq(and3s(!logi_bvu, , ),
         band3(!logi_bvu, , ))
  exp_eq(and3s(!logi_bvv, , ),
         band3(!logi_bvv, , ))
  exp_eq(and3s(!logi_bvw, , ),
         band3(!logi_bvw, , ))
  exp_eq(and3s(!logi_bvx, , l >= 0L),
         band3(!logi_bvx, , l >= 0L))
  exp_eq(and3s(!logi_bvy, , r >= 1L),
         band3(!logi_bvy, , r >= 1L))
  exp_eq(and3s(!logi_bvz, , q >= 9L),
         band3(!logi_bvz, , q >= 9L))
  exp_eq(and3s(!logi_bwa, n %between% c(-1L, 1L), ),
         band3(!logi_bwa, n %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bwb, o %between% c(-1L, 1L), ),
         band3(!logi_bwb, o %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bwc, l %between% c(-1L, 1L), ),
         band3(!logi_bwc, l %between% c(-1L, 1L), ))
  exp_eq(and3s(!logi_bwd, z %between% c(-1L, 1L), v >= 0L),
         band3(!logi_bwd, z %between% c(-1L, 1L), v >= 0L))
  exp_eq(and3s(!logi_bwe, d %between% c(-1L, 1L), p >= 1L),
         band3(!logi_bwe, d %between% c(-1L, 1L), p >= 1L))
  exp_eq(and3s(!logi_bwf, w %between% c(-1L, 1L), r >= 9L),
         band3(!logi_bwf, w %between% c(-1L, 1L), r >= 9L))
  exp_eq(and3s(!logi_bwg, , ),
         band3(!logi_bwg, , ))
  exp_eq(and3s(!logi_bwh, , ),
         band3(!logi_bwh, , ))
  exp_eq(and3s(!logi_bwi, , ),
         band3(!logi_bwi, , ))
  exp_eq(and3s(!logi_bwj, , logi_b),
         band3(!logi_bwj, , logi_b))
  exp_eq(and3s(!logi_bwk, , logi_j),
         band3(!logi_bwk, , logi_j))
  exp_eq(and3s(!logi_bwl, , logi_r),
         band3(!logi_bwl, , logi_r))
  exp_eq(and3s(!logi_bwm, c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bwm, c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bwn, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bwn, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bwo, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bwo, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bwp, o %in% c(4L, -3L, 2L, 7L, 8L), logi_d),
         band3(!logi_bwp, o %in% c(4L, -3L, 2L, 7L, 8L), logi_d))
  exp_eq(and3s(!logi_bwq, s %in% c(4L, -3L, 2L, 7L, 8L), logi_m),
         band3(!logi_bwq, s %in% c(4L, -3L, 2L, 7L, 8L), logi_m))
  exp_eq(and3s(!logi_bwr, k %in% c(4L, -3L, 2L, 7L, 8L), logi_m),
         band3(!logi_bwr, k %in% c(4L, -3L, 2L, 7L, 8L), logi_m))
  exp_eq(and3s(!logi_bws, , ),
         band3(!logi_bws, , ))
  exp_eq(and3s(!logi_bwt, , ),
         band3(!logi_bwt, , ))
  exp_eq(and3s(!logi_bwu, , ),
         band3(!logi_bwu, , ))
  exp_eq(and3s(!logi_bwv, , logi_u),
         band3(!logi_bwv, , logi_u))
  exp_eq(and3s(!logi_bww, , logi_v),
         band3(!logi_bww, , logi_v))
  exp_eq(and3s(!logi_bwx, , logi_y),
         band3(!logi_bwx, , logi_y))
  exp_eq(and3s(!logi_bwy, r %in% 1:4, ),
         band3(!logi_bwy, r %in% 1:4, ))
  exp_eq(and3s(!logi_bwz, t %in% 1:4, ),
         band3(!logi_bwz, t %in% 1:4, ))
  exp_eq(and3s(!logi_bxa, k %in% 1:4, ),
         band3(!logi_bxa, k %in% 1:4, ))
  exp_eq(and3s(!logi_bxb, q %in% 1:4, logi_w),
         band3(!logi_bxb, q %in% 1:4, logi_w))
  exp_eq(and3s(!logi_bxc, k %in% 1:4, logi_f),
         band3(!logi_bxc, k %in% 1:4, logi_f))
  exp_eq(and3s(!logi_bxd, u %in% 1:4, logi_r),
         band3(!logi_bxd, u %in% 1:4, logi_r))
  exp_eq(and3s(!logi_bxe, , ),
         band3(!logi_bxe, , ))
  exp_eq(and3s(!logi_bxf, , ),
         band3(!logi_bxf, , ))
  exp_eq(and3s(!logi_bxg, , ),
         band3(!logi_bxg, , ))
  exp_eq(and3s(!logi_bxh, , !logi_w),
         band3(!logi_bxh, , !logi_w))
  exp_eq(and3s(!logi_bxi, , !logi_c),
         band3(!logi_bxi, , !logi_c))
  exp_eq(and3s(!logi_bxj, , !logi_k),
         band3(!logi_bxj, , !logi_k))
  exp_eq(and3s(!logi_bxk, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bxk, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bxl, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bxl, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bxm, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_bxm, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_bxn, y %in% c(4L, -3L, 2L, 7L, 8L), !logi_e),
         band3(!logi_bxn, y %in% c(4L, -3L, 2L, 7L, 8L), !logi_e))
  exp_eq(and3s(!logi_bxo, k %in% c(4L, -3L, 2L, 7L, 8L), !logi_z),
         band3(!logi_bxo, k %in% c(4L, -3L, 2L, 7L, 8L), !logi_z))
  exp_eq(and3s(!logi_bxp, n %in% c(4L, -3L, 2L, 7L, 8L), !logi_n),
         band3(!logi_bxp, n %in% c(4L, -3L, 2L, 7L, 8L), !logi_n))
  exp_eq(and3s(!logi_bxq, , ),
         band3(!logi_bxq, , ))
  exp_eq(and3s(!logi_bxr, , ),
         band3(!logi_bxr, , ))
  exp_eq(and3s(!logi_bxs, , ),
         band3(!logi_bxs, , ))
  exp_eq(and3s(!logi_bxt, , !logi_g),
         band3(!logi_bxt, , !logi_g))
  exp_eq(and3s(!logi_bxu, , !logi_n),
         band3(!logi_bxu, , !logi_n))
  exp_eq(and3s(!logi_bxv, , !logi_m),
         band3(!logi_bxv, , !logi_m))
  exp_eq(and3s(!logi_bxw, y %in% 1:4, ),
         band3(!logi_bxw, y %in% 1:4, ))
  exp_eq(and3s(!logi_bxx, c %in% 1:4, ),
         band3(!logi_bxx, c %in% 1:4, ))
  exp_eq(and3s(!logi_bxy, l %in% 1:4, ),
         band3(!logi_bxy, l %in% 1:4, ))
  exp_eq(and3s(!logi_bxz, y %in% 1:4, !logi_o),
         band3(!logi_bxz, y %in% 1:4, !logi_o))
  exp_eq(and3s(!logi_bya, i %in% 1:4, !logi_h),
         band3(!logi_bya, i %in% 1:4, !logi_h))
  exp_eq(and3s(!logi_byb, k %in% 1:4, !logi_a),
         band3(!logi_byb, k %in% 1:4, !logi_a))
  exp_eq(and3s(!logi_byc, , ),
         band3(!logi_byc, , ))
  exp_eq(and3s(!logi_byd, , ),
         band3(!logi_byd, , ))
  exp_eq(and3s(!logi_bye, , ),
         band3(!logi_bye, , ))
  exp_eq(and3s(!logi_byf, , i != 0L),
         band3(!logi_byf, , i != 0L))
  exp_eq(and3s(!logi_byg, , g != 1L),
         band3(!logi_byg, , g != 1L))
  exp_eq(and3s(!logi_byh, , o != 9L),
         band3(!logi_byh, , o != 9L))
  exp_eq(and3s(!logi_byi, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_byi, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_byj, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_byj, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_byk, l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_byk, l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_byl, w %in% c(4L, -3L, 2L, 7L, 8L), i != 0L),
         band3(!logi_byl, w %in% c(4L, -3L, 2L, 7L, 8L), i != 0L))
  exp_eq(and3s(!logi_bym, d %in% c(4L, -3L, 2L, 7L, 8L), j != 1L),
         band3(!logi_bym, d %in% c(4L, -3L, 2L, 7L, 8L), j != 1L))
  exp_eq(and3s(!logi_byn, g %in% c(4L, -3L, 2L, 7L, 8L), k != 9L),
         band3(!logi_byn, g %in% c(4L, -3L, 2L, 7L, 8L), k != 9L))
  exp_eq(and3s(!logi_byo, , ),
         band3(!logi_byo, , ))
  exp_eq(and3s(!logi_byp, , ),
         band3(!logi_byp, , ))
  exp_eq(and3s(!logi_byq, , ),
         band3(!logi_byq, , ))
  exp_eq(and3s(!logi_byr, , y != 0L),
         band3(!logi_byr, , y != 0L))
  exp_eq(and3s(!logi_bys, , b != 1L),
         band3(!logi_bys, , b != 1L))
  exp_eq(and3s(!logi_byt, , h != 9L),
         band3(!logi_byt, , h != 9L))
  exp_eq(and3s(!logi_byu, t %in% 1:4, ),
         band3(!logi_byu, t %in% 1:4, ))
  exp_eq(and3s(!logi_byv, t %in% 1:4, ),
         band3(!logi_byv, t %in% 1:4, ))
  exp_eq(and3s(!logi_byw, r %in% 1:4, ),
         band3(!logi_byw, r %in% 1:4, ))
  exp_eq(and3s(!logi_byx, v %in% 1:4, f != 0L),
         band3(!logi_byx, v %in% 1:4, f != 0L))
  exp_eq(and3s(!logi_byy, r %in% 1:4, k != 1L),
         band3(!logi_byy, r %in% 1:4, k != 1L))
  exp_eq(and3s(!logi_byz, k %in% 1:4, k != 9L),
         band3(!logi_byz, k %in% 1:4, k != 9L))
  exp_eq(and3s(!logi_ca, , ),
         band3(!logi_ca, , ))
  exp_eq(and3s(!logi_cb, , ),
         band3(!logi_cb, , ))
  exp_eq(and3s(!logi_cc, , ),
         band3(!logi_cc, , ))
  exp_eq(and3s(!logi_cd, , r %between% c(-1L, 1L)),
         band3(!logi_cd, , r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_ce, , g %between% c(-1L, 1L)),
         band3(!logi_ce, , g %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cf, , b %between% c(-1L, 1L)),
         band3(!logi_cf, , b %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cg, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cg, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ch, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ch, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ci, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ci, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cj, k %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)),
         band3(!logi_cj, k %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_ck, f %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L)),
         band3(!logi_ck, f %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cl, a %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L)),
         band3(!logi_cl, a %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cm, , ),
         band3(!logi_cm, , ))
  exp_eq(and3s(!logi_cn, , ),
         band3(!logi_cn, , ))
  exp_eq(and3s(!logi_co, , ),
         band3(!logi_co, , ))
  exp_eq(and3s(!logi_cp, , r %between% c(-1L, 1L)),
         band3(!logi_cp, , r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cq, , y %between% c(-1L, 1L)),
         band3(!logi_cq, , y %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cr, , w %between% c(-1L, 1L)),
         band3(!logi_cr, , w %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cs, g %in% 1:4, ),
         band3(!logi_cs, g %in% 1:4, ))
  exp_eq(and3s(!logi_ct, o %in% 1:4, ),
         band3(!logi_ct, o %in% 1:4, ))
  exp_eq(and3s(!logi_cu, x %in% 1:4, ),
         band3(!logi_cu, x %in% 1:4, ))
  exp_eq(and3s(!logi_cv, z %in% 1:4, t %between% c(-1L, 1L)),
         band3(!logi_cv, z %in% 1:4, t %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cw, m %in% 1:4, b %between% c(-1L, 1L)),
         band3(!logi_cw, m %in% 1:4, b %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cx, z %in% 1:4, o %between% c(-1L, 1L)),
         band3(!logi_cx, z %in% 1:4, o %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cy, , ),
         band3(!logi_cy, , ))
  exp_eq(and3s(!logi_cz, , ),
         band3(!logi_cz, , ))
  exp_eq(and3s(!logi_caa, , ),
         band3(!logi_caa, , ))
  exp_eq(and3s(!logi_cab, , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cab, , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cac, , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cac, , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cad, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cad, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cae, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cae, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_caf, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_caf, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cag, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cag, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cah, j %in% c(4L, -3L, 2L, 7L, 8L), j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cah, j %in% c(4L, -3L, 2L, 7L, 8L), j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cai, y %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cai, y %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_caj, b %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_caj, b %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cak, , ),
         band3(!logi_cak, , ))
  exp_eq(and3s(!logi_cal, , ),
         band3(!logi_cal, , ))
  exp_eq(and3s(!logi_cam, , ),
         band3(!logi_cam, , ))
  exp_eq(and3s(!logi_can, , p %in% 1:4),
         band3(!logi_can, , p %in% 1:4))
  exp_eq(and3s(!logi_cao, , f %in% 1:4),
         band3(!logi_cao, , f %in% 1:4))
  exp_eq(and3s(!logi_cap, , x %in% 1:4),
         band3(!logi_cap, , x %in% 1:4))
  exp_eq(and3s(!logi_caq, k %in% 1:4, ),
         band3(!logi_caq, k %in% 1:4, ))
  exp_eq(and3s(!logi_car, i %in% 1:4, ),
         band3(!logi_car, i %in% 1:4, ))
  exp_eq(and3s(!logi_cas, q %in% 1:4, ),
         band3(!logi_cas, q %in% 1:4, ))
  exp_eq(and3s(!logi_cat, z %in% 1:4, z %in% 1:4),
         band3(!logi_cat, z %in% 1:4, z %in% 1:4))
  exp_eq(and3s(!logi_cau, c %in% 1:4, c %in% 1:4),
         band3(!logi_cau, c %in% 1:4, c %in% 1:4))
  exp_eq(and3s(!logi_cav, t %in% 1:4, l %in% 1:4),
         band3(!logi_cav, t %in% 1:4, l %in% 1:4))
  exp_eq(and3s(!logi_caw, , ),
         band3(!logi_caw, , ))
  exp_eq(and3s(!logi_cax, , ),
         band3(!logi_cax, , ))
  exp_eq(and3s(!logi_cay, , ),
         band3(!logi_cay, , ))
  exp_eq(and3s(!logi_caz, , s < 0L),
         band3(!logi_caz, , s < 0L))
  exp_eq(and3s(!logi_cba, , z < 1L),
         band3(!logi_cba, , z < 1L))
  exp_eq(and3s(!logi_cbb, , b < 9L),
         band3(!logi_cbb, , b < 9L))
  exp_eq(and3s(!logi_cbc, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cbc, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cbd, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cbd, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cbe, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cbe, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cbf, t %in% c(4L, -3L, 2L, 7L, 8L), c < 0L),
         band3(!logi_cbf, t %in% c(4L, -3L, 2L, 7L, 8L), c < 0L))
  exp_eq(and3s(!logi_cbg, h %in% c(4L, -3L, 2L, 7L, 8L), b < 1L),
         band3(!logi_cbg, h %in% c(4L, -3L, 2L, 7L, 8L), b < 1L))
  exp_eq(and3s(!logi_cbh, h %in% c(4L, -3L, 2L, 7L, 8L), u < 9L),
         band3(!logi_cbh, h %in% c(4L, -3L, 2L, 7L, 8L), u < 9L))
  exp_eq(and3s(!logi_cbi, , ),
         band3(!logi_cbi, , ))
  exp_eq(and3s(!logi_cbj, , ),
         band3(!logi_cbj, , ))
  exp_eq(and3s(!logi_cbk, , ),
         band3(!logi_cbk, , ))
  exp_eq(and3s(!logi_cbl, , a < 0L),
         band3(!logi_cbl, , a < 0L))
  exp_eq(and3s(!logi_cbm, , w < 1L),
         band3(!logi_cbm, , w < 1L))
  exp_eq(and3s(!logi_cbn, , d < 9L),
         band3(!logi_cbn, , d < 9L))
  exp_eq(and3s(!logi_cbo, q %in% 1:4, ),
         band3(!logi_cbo, q %in% 1:4, ))
  exp_eq(and3s(!logi_cbp, w %in% 1:4, ),
         band3(!logi_cbp, w %in% 1:4, ))
  exp_eq(and3s(!logi_cbq, r %in% 1:4, ),
         band3(!logi_cbq, r %in% 1:4, ))
  exp_eq(and3s(!logi_cbr, x %in% 1:4, u < 0L),
         band3(!logi_cbr, x %in% 1:4, u < 0L))
  exp_eq(and3s(!logi_cbs, l %in% 1:4, c < 1L),
         band3(!logi_cbs, l %in% 1:4, c < 1L))
  exp_eq(and3s(!logi_cbt, h %in% 1:4, q < 9L),
         band3(!logi_cbt, h %in% 1:4, q < 9L))
  exp_eq(and3s(!logi_cbu, , ),
         band3(!logi_cbu, , ))
  exp_eq(and3s(!logi_cbv, , ),
         band3(!logi_cbv, , ))
  exp_eq(and3s(!logi_cbw, , ),
         band3(!logi_cbw, , ))
  exp_eq(and3s(!logi_cbx, , d <= 0L),
         band3(!logi_cbx, , d <= 0L))
  exp_eq(and3s(!logi_cby, , m <= 1L),
         band3(!logi_cby, , m <= 1L))
  exp_eq(and3s(!logi_cbz, , h <= 9L),
         band3(!logi_cbz, , h <= 9L))
  exp_eq(and3s(!logi_cca, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cca, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ccb, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ccb, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ccc, m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ccc, m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ccd, h %in% c(4L, -3L, 2L, 7L, 8L), q <= 0L),
         band3(!logi_ccd, h %in% c(4L, -3L, 2L, 7L, 8L), q <= 0L))
  exp_eq(and3s(!logi_cce, h %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L),
         band3(!logi_cce, h %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L))
  exp_eq(and3s(!logi_ccf, r %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L),
         band3(!logi_ccf, r %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L))
  exp_eq(and3s(!logi_ccg, , ),
         band3(!logi_ccg, , ))
  exp_eq(and3s(!logi_cch, , ),
         band3(!logi_cch, , ))
  exp_eq(and3s(!logi_cci, , ),
         band3(!logi_cci, , ))
  exp_eq(and3s(!logi_ccj, , e <= 0L),
         band3(!logi_ccj, , e <= 0L))
  exp_eq(and3s(!logi_cck, , w <= 1L),
         band3(!logi_cck, , w <= 1L))
  exp_eq(and3s(!logi_ccl, , a <= 9L),
         band3(!logi_ccl, , a <= 9L))
  exp_eq(and3s(!logi_ccm, w %in% 1:4, ),
         band3(!logi_ccm, w %in% 1:4, ))
  exp_eq(and3s(!logi_ccn, k %in% 1:4, ),
         band3(!logi_ccn, k %in% 1:4, ))
  exp_eq(and3s(!logi_cco, s %in% 1:4, ),
         band3(!logi_cco, s %in% 1:4, ))
  exp_eq(and3s(!logi_ccp, q %in% 1:4, t <= 0L),
         band3(!logi_ccp, q %in% 1:4, t <= 0L))
  exp_eq(and3s(!logi_ccq, u %in% 1:4, r <= 1L),
         band3(!logi_ccq, u %in% 1:4, r <= 1L))
  exp_eq(and3s(!logi_ccr, o %in% 1:4, i <= 9L),
         band3(!logi_ccr, o %in% 1:4, i <= 9L))
  exp_eq(and3s(!logi_ccs, , ),
         band3(!logi_ccs, , ))
  exp_eq(and3s(!logi_cct, , ),
         band3(!logi_cct, , ))
  exp_eq(and3s(!logi_ccu, , ),
         band3(!logi_ccu, , ))
  exp_eq(and3s(!logi_ccv, , v == 0L),
         band3(!logi_ccv, , v == 0L))
  exp_eq(and3s(!logi_ccw, , j == 1L),
         band3(!logi_ccw, , j == 1L))
  exp_eq(and3s(!logi_ccx, , b == 9L),
         band3(!logi_ccx, , b == 9L))
  exp_eq(and3s(!logi_ccy, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ccy, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_ccz, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ccz, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cda, z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cda, z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cdb, i %in% c(4L, -3L, 2L, 7L, 8L), h == 0L),
         band3(!logi_cdb, i %in% c(4L, -3L, 2L, 7L, 8L), h == 0L))
  exp_eq(and3s(!logi_cdc, f %in% c(4L, -3L, 2L, 7L, 8L), c == 1L),
         band3(!logi_cdc, f %in% c(4L, -3L, 2L, 7L, 8L), c == 1L))
  exp_eq(and3s(!logi_cdd, x %in% c(4L, -3L, 2L, 7L, 8L), d == 9L),
         band3(!logi_cdd, x %in% c(4L, -3L, 2L, 7L, 8L), d == 9L))
  exp_eq(and3s(!logi_cde, , ),
         band3(!logi_cde, , ))
  exp_eq(and3s(!logi_cdf, , ),
         band3(!logi_cdf, , ))
  exp_eq(and3s(!logi_cdg, , ),
         band3(!logi_cdg, , ))
  exp_eq(and3s(!logi_cdh, , i == 0L),
         band3(!logi_cdh, , i == 0L))
  exp_eq(and3s(!logi_cdi, , h == 1L),
         band3(!logi_cdi, , h == 1L))
  exp_eq(and3s(!logi_cdj, , c == 9L),
         band3(!logi_cdj, , c == 9L))
  exp_eq(and3s(!logi_cdk, l %in% 1:4, ),
         band3(!logi_cdk, l %in% 1:4, ))
  exp_eq(and3s(!logi_cdl, x %in% 1:4, ),
         band3(!logi_cdl, x %in% 1:4, ))
  exp_eq(and3s(!logi_cdm, a %in% 1:4, ),
         band3(!logi_cdm, a %in% 1:4, ))
  exp_eq(and3s(!logi_cdn, k %in% 1:4, p == 0L),
         band3(!logi_cdn, k %in% 1:4, p == 0L))
  exp_eq(and3s(!logi_cdo, u %in% 1:4, j == 1L),
         band3(!logi_cdo, u %in% 1:4, j == 1L))
  exp_eq(and3s(!logi_cdp, p %in% 1:4, t == 9L),
         band3(!logi_cdp, p %in% 1:4, t == 9L))
  exp_eq(and3s(!logi_cdq, , ),
         band3(!logi_cdq, , ))
  exp_eq(and3s(!logi_cdr, , ),
         band3(!logi_cdr, , ))
  exp_eq(and3s(!logi_cds, , ),
         band3(!logi_cds, , ))
  exp_eq(and3s(!logi_cdt, , y > 0L),
         band3(!logi_cdt, , y > 0L))
  exp_eq(and3s(!logi_cdu, , o > 1L),
         band3(!logi_cdu, , o > 1L))
  exp_eq(and3s(!logi_cdv, , r > 9L),
         band3(!logi_cdv, , r > 9L))
  exp_eq(and3s(!logi_cdw, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cdw, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cdx, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cdx, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cdy, m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cdy, m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cdz, v %in% c(4L, -3L, 2L, 7L, 8L), x > 0L),
         band3(!logi_cdz, v %in% c(4L, -3L, 2L, 7L, 8L), x > 0L))
  exp_eq(and3s(!logi_cea, c %in% c(4L, -3L, 2L, 7L, 8L), w > 1L),
         band3(!logi_cea, c %in% c(4L, -3L, 2L, 7L, 8L), w > 1L))
  exp_eq(and3s(!logi_ceb, w %in% c(4L, -3L, 2L, 7L, 8L), i > 9L),
         band3(!logi_ceb, w %in% c(4L, -3L, 2L, 7L, 8L), i > 9L))
  exp_eq(and3s(!logi_cec, , ),
         band3(!logi_cec, , ))
  exp_eq(and3s(!logi_ced, , ),
         band3(!logi_ced, , ))
  exp_eq(and3s(!logi_cee, , ),
         band3(!logi_cee, , ))
  exp_eq(and3s(!logi_cef, , c > 0L),
         band3(!logi_cef, , c > 0L))
  exp_eq(and3s(!logi_ceg, , k > 1L),
         band3(!logi_ceg, , k > 1L))
  exp_eq(and3s(!logi_ceh, , b > 9L),
         band3(!logi_ceh, , b > 9L))
  exp_eq(and3s(!logi_cei, b %in% 1:4, ),
         band3(!logi_cei, b %in% 1:4, ))
  exp_eq(and3s(!logi_cej, k %in% 1:4, ),
         band3(!logi_cej, k %in% 1:4, ))
  exp_eq(and3s(!logi_cek, k %in% 1:4, ),
         band3(!logi_cek, k %in% 1:4, ))
  exp_eq(and3s(!logi_cel, m %in% 1:4, i > 0L),
         band3(!logi_cel, m %in% 1:4, i > 0L))
  exp_eq(and3s(!logi_cem, b %in% 1:4, c > 1L),
         band3(!logi_cem, b %in% 1:4, c > 1L))
  exp_eq(and3s(!logi_cen, v %in% 1:4, b > 9L),
         band3(!logi_cen, v %in% 1:4, b > 9L))
  exp_eq(and3s(!logi_ceo, , ),
         band3(!logi_ceo, , ))
  exp_eq(and3s(!logi_cep, , ),
         band3(!logi_cep, , ))
  exp_eq(and3s(!logi_ceq, , ),
         band3(!logi_ceq, , ))
  exp_eq(and3s(!logi_cer, , b >= 0L),
         band3(!logi_cer, , b >= 0L))
  exp_eq(and3s(!logi_ces, , y >= 1L),
         band3(!logi_ces, , y >= 1L))
  exp_eq(and3s(!logi_cet, , s >= 9L),
         band3(!logi_cet, , s >= 9L))
  exp_eq(and3s(!logi_ceu, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_ceu, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cev, s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cev, s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cew, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(!logi_cew, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(!logi_cex, e %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L),
         band3(!logi_cex, e %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L))
  exp_eq(and3s(!logi_cey, s %in% c(4L, -3L, 2L, 7L, 8L), k >= 1L),
         band3(!logi_cey, s %in% c(4L, -3L, 2L, 7L, 8L), k >= 1L))
  exp_eq(and3s(!logi_cez, z %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L),
         band3(!logi_cez, z %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L))
  exp_eq(and3s(!logi_cfa, , ),
         band3(!logi_cfa, , ))
  exp_eq(and3s(!logi_cfb, , ),
         band3(!logi_cfb, , ))
  exp_eq(and3s(!logi_cfc, , ),
         band3(!logi_cfc, , ))
  exp_eq(and3s(!logi_cfd, , p >= 0L),
         band3(!logi_cfd, , p >= 0L))
  exp_eq(and3s(!logi_cfe, , y >= 1L),
         band3(!logi_cfe, , y >= 1L))
  exp_eq(and3s(!logi_cff, , u >= 9L),
         band3(!logi_cff, , u >= 9L))
  exp_eq(and3s(!logi_cfg, b %in% 1:4, ),
         band3(!logi_cfg, b %in% 1:4, ))
  exp_eq(and3s(!logi_cfh, q %in% 1:4, ),
         band3(!logi_cfh, q %in% 1:4, ))
  exp_eq(and3s(!logi_cfi, j %in% 1:4, ),
         band3(!logi_cfi, j %in% 1:4, ))
  exp_eq(and3s(!logi_cfj, b %in% 1:4, x >= 0L),
         band3(!logi_cfj, b %in% 1:4, x >= 0L))
  exp_eq(and3s(!logi_cfk, x %in% 1:4, k >= 1L),
         band3(!logi_cfk, x %in% 1:4, k >= 1L))
  exp_eq(and3s(!logi_cfl, d %in% 1:4, g >= 9L),
         band3(!logi_cfl, d %in% 1:4, g >= 9L))
  exp_eq(and3s(!logi_cfm, , ),
         band3(!logi_cfm, , ))
  exp_eq(and3s(!logi_cfn, , ),
         band3(!logi_cfn, , ))
  exp_eq(and3s(!logi_cfo, , ),
         band3(!logi_cfo, , ))
  exp_eq(and3s(!logi_cfp, , logi_q),
         band3(!logi_cfp, , logi_q))
  exp_eq(and3s(!logi_cfq, , logi_o),
         band3(!logi_cfq, , logi_o))
  exp_eq(and3s(!logi_cfr, , logi_s),
         band3(!logi_cfr, , logi_s))
  exp_eq(and3s(!logi_cfs, b < 0L, ),
         band3(!logi_cfs, b < 0L, ))
  exp_eq(and3s(!logi_cft, g < 1L, ),
         band3(!logi_cft, g < 1L, ))
  exp_eq(and3s(!logi_cfu, a < 9L, ),
         band3(!logi_cfu, a < 9L, ))
  exp_eq(and3s(!logi_cfv, o < 0L, logi_m),
         band3(!logi_cfv, o < 0L, logi_m))
  exp_eq(and3s(!logi_cfw, v < 1L, logi_w),
         band3(!logi_cfw, v < 1L, logi_w))
  exp_eq(and3s(!logi_cfx, i < 9L, logi_h),
         band3(!logi_cfx, i < 9L, logi_h))
  exp_eq(and3s(!logi_cfy, , ),
         band3(!logi_cfy, , ))
  exp_eq(and3s(!logi_cfz, , ),
         band3(!logi_cfz, , ))
  exp_eq(and3s(!logi_cga, , ),
         band3(!logi_cga, , ))
  exp_eq(and3s(!logi_cgb, , !logi_z),
         band3(!logi_cgb, , !logi_z))
  exp_eq(and3s(!logi_cgc, , !logi_l),
         band3(!logi_cgc, , !logi_l))
  exp_eq(and3s(!logi_cgd, , !logi_y),
         band3(!logi_cgd, , !logi_y))
  exp_eq(and3s(!logi_cge, w < 0L, ),
         band3(!logi_cge, w < 0L, ))
  exp_eq(and3s(!logi_cgf, z < 1L, ),
         band3(!logi_cgf, z < 1L, ))
  exp_eq(and3s(!logi_cgg, n < 9L, ),
         band3(!logi_cgg, n < 9L, ))
  exp_eq(and3s(!logi_cgh, q < 0L, !logi_e),
         band3(!logi_cgh, q < 0L, !logi_e))
  exp_eq(and3s(!logi_cgi, l < 1L, !logi_t),
         band3(!logi_cgi, l < 1L, !logi_t))
  exp_eq(and3s(!logi_cgj, t < 9L, !logi_h),
         band3(!logi_cgj, t < 9L, !logi_h))
  exp_eq(and3s(!logi_cgk, , ),
         band3(!logi_cgk, , ))
  exp_eq(and3s(!logi_cgl, , ),
         band3(!logi_cgl, , ))
  exp_eq(and3s(!logi_cgm, , ),
         band3(!logi_cgm, , ))
  exp_eq(and3s(!logi_cgn, , z != 0L),
         band3(!logi_cgn, , z != 0L))
  exp_eq(and3s(!logi_cgo, , c != 1L),
         band3(!logi_cgo, , c != 1L))
  exp_eq(and3s(!logi_cgp, , e != 9L),
         band3(!logi_cgp, , e != 9L))
  exp_eq(and3s(!logi_cgq, e < 0L, ),
         band3(!logi_cgq, e < 0L, ))
  exp_eq(and3s(!logi_cgr, t < 1L, ),
         band3(!logi_cgr, t < 1L, ))
  exp_eq(and3s(!logi_cgs, c < 9L, ),
         band3(!logi_cgs, c < 9L, ))
  exp_eq(and3s(!logi_cgt, x < 0L, k != 0L),
         band3(!logi_cgt, x < 0L, k != 0L))
  exp_eq(and3s(!logi_cgu, s < 1L, q != 1L),
         band3(!logi_cgu, s < 1L, q != 1L))
  exp_eq(and3s(!logi_cgv, w < 9L, h != 9L),
         band3(!logi_cgv, w < 9L, h != 9L))
  exp_eq(and3s(!logi_cgw, , ),
         band3(!logi_cgw, , ))
  exp_eq(and3s(!logi_cgx, , ),
         band3(!logi_cgx, , ))
  exp_eq(and3s(!logi_cgy, , ),
         band3(!logi_cgy, , ))
  exp_eq(and3s(!logi_cgz, , k %between% c(-1L, 1L)),
         band3(!logi_cgz, , k %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cha, , m %between% c(-1L, 1L)),
         band3(!logi_cha, , m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_chb, , u %between% c(-1L, 1L)),
         band3(!logi_chb, , u %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_chc, c < 0L, ),
         band3(!logi_chc, c < 0L, ))
  exp_eq(and3s(!logi_chd, u < 1L, ),
         band3(!logi_chd, u < 1L, ))
  exp_eq(and3s(!logi_che, a < 9L, ),
         band3(!logi_che, a < 9L, ))
  exp_eq(and3s(!logi_chf, r < 0L, m %between% c(-1L, 1L)),
         band3(!logi_chf, r < 0L, m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_chg, t < 1L, h %between% c(-1L, 1L)),
         band3(!logi_chg, t < 1L, h %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_chh, c < 9L, k %between% c(-1L, 1L)),
         band3(!logi_chh, c < 9L, k %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_chi, , ),
         band3(!logi_chi, , ))
  exp_eq(and3s(!logi_chj, , ),
         band3(!logi_chj, , ))
  exp_eq(and3s(!logi_chk, , ),
         band3(!logi_chk, , ))
  exp_eq(and3s(!logi_chl, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_chl, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_chm, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_chm, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_chn, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_chn, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cho, h < 0L, ),
         band3(!logi_cho, h < 0L, ))
  exp_eq(and3s(!logi_chp, n < 1L, ),
         band3(!logi_chp, n < 1L, ))
  exp_eq(and3s(!logi_chq, m < 9L, ),
         band3(!logi_chq, m < 9L, ))
  exp_eq(and3s(!logi_chr, c < 0L, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_chr, c < 0L, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_chs, o < 1L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_chs, o < 1L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cht, e < 9L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cht, e < 9L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_chu, , ),
         band3(!logi_chu, , ))
  exp_eq(and3s(!logi_chv, , ),
         band3(!logi_chv, , ))
  exp_eq(and3s(!logi_chw, , ),
         band3(!logi_chw, , ))
  exp_eq(and3s(!logi_chx, , y %in% 1:4),
         band3(!logi_chx, , y %in% 1:4))
  exp_eq(and3s(!logi_chy, , m %in% 1:4),
         band3(!logi_chy, , m %in% 1:4))
  exp_eq(and3s(!logi_chz, , r %in% 1:4),
         band3(!logi_chz, , r %in% 1:4))
  exp_eq(and3s(!logi_cia, a < 0L, ),
         band3(!logi_cia, a < 0L, ))
  exp_eq(and3s(!logi_cib, m < 1L, ),
         band3(!logi_cib, m < 1L, ))
  exp_eq(and3s(!logi_cic, n < 9L, ),
         band3(!logi_cic, n < 9L, ))
  exp_eq(and3s(!logi_cid, r < 0L, f %in% 1:4),
         band3(!logi_cid, r < 0L, f %in% 1:4))
  exp_eq(and3s(!logi_cie, v < 1L, z %in% 1:4),
         band3(!logi_cie, v < 1L, z %in% 1:4))
  exp_eq(and3s(!logi_cif, o < 9L, v %in% 1:4),
         band3(!logi_cif, o < 9L, v %in% 1:4))
  exp_eq(and3s(!logi_cig, , ),
         band3(!logi_cig, , ))
  exp_eq(and3s(!logi_cih, , ),
         band3(!logi_cih, , ))
  exp_eq(and3s(!logi_cii, , ),
         band3(!logi_cii, , ))
  exp_eq(and3s(!logi_cij, , m < 0L),
         band3(!logi_cij, , m < 0L))
  exp_eq(and3s(!logi_cik, , b < 1L),
         band3(!logi_cik, , b < 1L))
  exp_eq(and3s(!logi_cil, , j < 9L),
         band3(!logi_cil, , j < 9L))
  exp_eq(and3s(!logi_cim, y < 0L, ),
         band3(!logi_cim, y < 0L, ))
  exp_eq(and3s(!logi_cin, t < 1L, ),
         band3(!logi_cin, t < 1L, ))
  exp_eq(and3s(!logi_cio, w < 9L, ),
         band3(!logi_cio, w < 9L, ))
  exp_eq(and3s(!logi_cip, p < 0L, k < 0L),
         band3(!logi_cip, p < 0L, k < 0L))
  exp_eq(and3s(!logi_ciq, a < 1L, f < 1L),
         band3(!logi_ciq, a < 1L, f < 1L))
  exp_eq(and3s(!logi_cir, l < 9L, v < 9L),
         band3(!logi_cir, l < 9L, v < 9L))
  exp_eq(and3s(!logi_cis, , ),
         band3(!logi_cis, , ))
  exp_eq(and3s(!logi_cit, , ),
         band3(!logi_cit, , ))
  exp_eq(and3s(!logi_ciu, , ),
         band3(!logi_ciu, , ))
  exp_eq(and3s(!logi_civ, , e <= 0L),
         band3(!logi_civ, , e <= 0L))
  exp_eq(and3s(!logi_ciw, , k <= 1L),
         band3(!logi_ciw, , k <= 1L))
  exp_eq(and3s(!logi_cix, , q <= 9L),
         band3(!logi_cix, , q <= 9L))
  exp_eq(and3s(!logi_ciy, u < 0L, ),
         band3(!logi_ciy, u < 0L, ))
  exp_eq(and3s(!logi_ciz, i < 1L, ),
         band3(!logi_ciz, i < 1L, ))
  exp_eq(and3s(!logi_cja, b < 9L, ),
         band3(!logi_cja, b < 9L, ))
  exp_eq(and3s(!logi_cjb, k < 0L, t <= 0L),
         band3(!logi_cjb, k < 0L, t <= 0L))
  exp_eq(and3s(!logi_cjc, u < 1L, s <= 1L),
         band3(!logi_cjc, u < 1L, s <= 1L))
  exp_eq(and3s(!logi_cjd, u < 9L, n <= 9L),
         band3(!logi_cjd, u < 9L, n <= 9L))
  exp_eq(and3s(!logi_cje, , ),
         band3(!logi_cje, , ))
  exp_eq(and3s(!logi_cjf, , ),
         band3(!logi_cjf, , ))
  exp_eq(and3s(!logi_cjg, , ),
         band3(!logi_cjg, , ))
  exp_eq(and3s(!logi_cjh, , s == 0L),
         band3(!logi_cjh, , s == 0L))
  exp_eq(and3s(!logi_cji, , n == 1L),
         band3(!logi_cji, , n == 1L))
  exp_eq(and3s(!logi_cjj, , q == 9L),
         band3(!logi_cjj, , q == 9L))
  exp_eq(and3s(!logi_cjk, l < 0L, ),
         band3(!logi_cjk, l < 0L, ))
  exp_eq(and3s(!logi_cjl, f < 1L, ),
         band3(!logi_cjl, f < 1L, ))
  exp_eq(and3s(!logi_cjm, s < 9L, ),
         band3(!logi_cjm, s < 9L, ))
  exp_eq(and3s(!logi_cjn, t < 0L, z == 0L),
         band3(!logi_cjn, t < 0L, z == 0L))
  exp_eq(and3s(!logi_cjo, j < 1L, n == 1L),
         band3(!logi_cjo, j < 1L, n == 1L))
  exp_eq(and3s(!logi_cjp, n < 9L, j == 9L),
         band3(!logi_cjp, n < 9L, j == 9L))
  exp_eq(and3s(!logi_cjq, , ),
         band3(!logi_cjq, , ))
  exp_eq(and3s(!logi_cjr, , ),
         band3(!logi_cjr, , ))
  exp_eq(and3s(!logi_cjs, , ),
         band3(!logi_cjs, , ))
  exp_eq(and3s(!logi_cjt, , e > 0L),
         band3(!logi_cjt, , e > 0L))
  exp_eq(and3s(!logi_cju, , h > 1L),
         band3(!logi_cju, , h > 1L))
  exp_eq(and3s(!logi_cjv, , s > 9L),
         band3(!logi_cjv, , s > 9L))
  exp_eq(and3s(!logi_cjw, a < 0L, ),
         band3(!logi_cjw, a < 0L, ))
  exp_eq(and3s(!logi_cjx, v < 1L, ),
         band3(!logi_cjx, v < 1L, ))
  exp_eq(and3s(!logi_cjy, a < 9L, ),
         band3(!logi_cjy, a < 9L, ))
  exp_eq(and3s(!logi_cjz, h < 0L, i > 0L),
         band3(!logi_cjz, h < 0L, i > 0L))
  exp_eq(and3s(!logi_cka, x < 1L, s > 1L),
         band3(!logi_cka, x < 1L, s > 1L))
  exp_eq(and3s(!logi_ckb, q < 9L, f > 9L),
         band3(!logi_ckb, q < 9L, f > 9L))
  exp_eq(and3s(!logi_ckc, , ),
         band3(!logi_ckc, , ))
  exp_eq(and3s(!logi_ckd, , ),
         band3(!logi_ckd, , ))
  exp_eq(and3s(!logi_cke, , ),
         band3(!logi_cke, , ))
  exp_eq(and3s(!logi_ckf, , w >= 0L),
         band3(!logi_ckf, , w >= 0L))
  exp_eq(and3s(!logi_ckg, , j >= 1L),
         band3(!logi_ckg, , j >= 1L))
  exp_eq(and3s(!logi_ckh, , t >= 9L),
         band3(!logi_ckh, , t >= 9L))
  exp_eq(and3s(!logi_cki, s < 0L, ),
         band3(!logi_cki, s < 0L, ))
  exp_eq(and3s(!logi_ckj, q < 1L, ),
         band3(!logi_ckj, q < 1L, ))
  exp_eq(and3s(!logi_ckk, y < 9L, ),
         band3(!logi_ckk, y < 9L, ))
  exp_eq(and3s(!logi_ckl, d < 0L, v >= 0L),
         band3(!logi_ckl, d < 0L, v >= 0L))
  exp_eq(and3s(!logi_ckm, g < 1L, z >= 1L),
         band3(!logi_ckm, g < 1L, z >= 1L))
  exp_eq(and3s(!logi_ckn, j < 9L, l >= 9L),
         band3(!logi_ckn, j < 9L, l >= 9L))
  exp_eq(and3s(!logi_cko, , ),
         band3(!logi_cko, , ))
  exp_eq(and3s(!logi_ckp, , ),
         band3(!logi_ckp, , ))
  exp_eq(and3s(!logi_ckq, , ),
         band3(!logi_ckq, , ))
  exp_eq(and3s(!logi_ckr, , logi_m),
         band3(!logi_ckr, , logi_m))
  exp_eq(and3s(!logi_cks, , logi_u),
         band3(!logi_cks, , logi_u))
  exp_eq(and3s(!logi_ckt, , logi_l),
         band3(!logi_ckt, , logi_l))
  exp_eq(and3s(!logi_cku, j <= 0L, ),
         band3(!logi_cku, j <= 0L, ))
  exp_eq(and3s(!logi_ckv, t <= 1L, ),
         band3(!logi_ckv, t <= 1L, ))
  exp_eq(and3s(!logi_ckw, m <= 9L, ),
         band3(!logi_ckw, m <= 9L, ))
  exp_eq(and3s(!logi_ckx, j <= 0L, logi_e),
         band3(!logi_ckx, j <= 0L, logi_e))
  exp_eq(and3s(!logi_cky, m <= 1L, logi_w),
         band3(!logi_cky, m <= 1L, logi_w))
  exp_eq(and3s(!logi_ckz, p <= 9L, logi_u),
         band3(!logi_ckz, p <= 9L, logi_u))
  exp_eq(and3s(!logi_cla, , ),
         band3(!logi_cla, , ))
  exp_eq(and3s(!logi_clb, , ),
         band3(!logi_clb, , ))
  exp_eq(and3s(!logi_clc, , ),
         band3(!logi_clc, , ))
  exp_eq(and3s(!logi_cld, , !logi_e),
         band3(!logi_cld, , !logi_e))
  exp_eq(and3s(!logi_cle, , !logi_i),
         band3(!logi_cle, , !logi_i))
  exp_eq(and3s(!logi_clf, , !logi_k),
         band3(!logi_clf, , !logi_k))
  exp_eq(and3s(!logi_clg, d <= 0L, ),
         band3(!logi_clg, d <= 0L, ))
  exp_eq(and3s(!logi_clh, h <= 1L, ),
         band3(!logi_clh, h <= 1L, ))
  exp_eq(and3s(!logi_cli, o <= 9L, ),
         band3(!logi_cli, o <= 9L, ))
  exp_eq(and3s(!logi_clj, v <= 0L, !logi_i),
         band3(!logi_clj, v <= 0L, !logi_i))
  exp_eq(and3s(!logi_clk, u <= 1L, !logi_n),
         band3(!logi_clk, u <= 1L, !logi_n))
  exp_eq(and3s(!logi_cll, v <= 9L, !logi_l),
         band3(!logi_cll, v <= 9L, !logi_l))
  exp_eq(and3s(!logi_clm, , ),
         band3(!logi_clm, , ))
  exp_eq(and3s(!logi_cln, , ),
         band3(!logi_cln, , ))
  exp_eq(and3s(!logi_clo, , ),
         band3(!logi_clo, , ))
  exp_eq(and3s(!logi_clp, , a != 0L),
         band3(!logi_clp, , a != 0L))
  exp_eq(and3s(!logi_clq, , l != 1L),
         band3(!logi_clq, , l != 1L))
  exp_eq(and3s(!logi_clr, , y != 9L),
         band3(!logi_clr, , y != 9L))
  exp_eq(and3s(!logi_cls, o <= 0L, ),
         band3(!logi_cls, o <= 0L, ))
  exp_eq(and3s(!logi_clt, h <= 1L, ),
         band3(!logi_clt, h <= 1L, ))
  exp_eq(and3s(!logi_clu, v <= 9L, ),
         band3(!logi_clu, v <= 9L, ))
  exp_eq(and3s(!logi_clv, p <= 0L, a != 0L),
         band3(!logi_clv, p <= 0L, a != 0L))
  exp_eq(and3s(!logi_clw, a <= 1L, f != 1L),
         band3(!logi_clw, a <= 1L, f != 1L))
  exp_eq(and3s(!logi_clx, m <= 9L, x != 9L),
         band3(!logi_clx, m <= 9L, x != 9L))
  exp_eq(and3s(!logi_cly, , ),
         band3(!logi_cly, , ))
  exp_eq(and3s(!logi_clz, , ),
         band3(!logi_clz, , ))
  exp_eq(and3s(!logi_cma, , ),
         band3(!logi_cma, , ))
  exp_eq(and3s(!logi_cmb, , w %between% c(-1L, 1L)),
         band3(!logi_cmb, , w %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cmc, , w %between% c(-1L, 1L)),
         band3(!logi_cmc, , w %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cmd, , a %between% c(-1L, 1L)),
         band3(!logi_cmd, , a %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cme, p <= 0L, ),
         band3(!logi_cme, p <= 0L, ))
  exp_eq(and3s(!logi_cmf, u <= 1L, ),
         band3(!logi_cmf, u <= 1L, ))
  exp_eq(and3s(!logi_cmg, n <= 9L, ),
         band3(!logi_cmg, n <= 9L, ))
  exp_eq(and3s(!logi_cmh, l <= 0L, g %between% c(-1L, 1L)),
         band3(!logi_cmh, l <= 0L, g %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cmi, x <= 1L, s %between% c(-1L, 1L)),
         band3(!logi_cmi, x <= 1L, s %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cmj, c <= 9L, o %between% c(-1L, 1L)),
         band3(!logi_cmj, c <= 9L, o %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cmk, , ),
         band3(!logi_cmk, , ))
  exp_eq(and3s(!logi_cml, , ),
         band3(!logi_cml, , ))
  exp_eq(and3s(!logi_cmm, , ),
         band3(!logi_cmm, , ))
  exp_eq(and3s(!logi_cmn, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmn, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmo, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmo, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmp, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmp, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmq, f <= 0L, ),
         band3(!logi_cmq, f <= 0L, ))
  exp_eq(and3s(!logi_cmr, c <= 1L, ),
         band3(!logi_cmr, c <= 1L, ))
  exp_eq(and3s(!logi_cms, f <= 9L, ),
         band3(!logi_cms, f <= 9L, ))
  exp_eq(and3s(!logi_cmt, h <= 0L, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmt, h <= 0L, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmu, w <= 1L, j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmu, w <= 1L, j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmv, z <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cmv, z <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cmw, , ),
         band3(!logi_cmw, , ))
  exp_eq(and3s(!logi_cmx, , ),
         band3(!logi_cmx, , ))
  exp_eq(and3s(!logi_cmy, , ),
         band3(!logi_cmy, , ))
  exp_eq(and3s(!logi_cmz, , j %in% 1:4),
         band3(!logi_cmz, , j %in% 1:4))
  exp_eq(and3s(!logi_cna, , v %in% 1:4),
         band3(!logi_cna, , v %in% 1:4))
  exp_eq(and3s(!logi_cnb, , t %in% 1:4),
         band3(!logi_cnb, , t %in% 1:4))
  exp_eq(and3s(!logi_cnc, p <= 0L, ),
         band3(!logi_cnc, p <= 0L, ))
  exp_eq(and3s(!logi_cnd, b <= 1L, ),
         band3(!logi_cnd, b <= 1L, ))
  exp_eq(and3s(!logi_cne, a <= 9L, ),
         band3(!logi_cne, a <= 9L, ))
  exp_eq(and3s(!logi_cnf, s <= 0L, r %in% 1:4),
         band3(!logi_cnf, s <= 0L, r %in% 1:4))
  exp_eq(and3s(!logi_cng, x <= 1L, b %in% 1:4),
         band3(!logi_cng, x <= 1L, b %in% 1:4))
  exp_eq(and3s(!logi_cnh, p <= 9L, f %in% 1:4),
         band3(!logi_cnh, p <= 9L, f %in% 1:4))
  exp_eq(and3s(!logi_cni, , ),
         band3(!logi_cni, , ))
  exp_eq(and3s(!logi_cnj, , ),
         band3(!logi_cnj, , ))
  exp_eq(and3s(!logi_cnk, , ),
         band3(!logi_cnk, , ))
  exp_eq(and3s(!logi_cnl, , r < 0L),
         band3(!logi_cnl, , r < 0L))
  exp_eq(and3s(!logi_cnm, , f < 1L),
         band3(!logi_cnm, , f < 1L))
  exp_eq(and3s(!logi_cnn, , s < 9L),
         band3(!logi_cnn, , s < 9L))
  exp_eq(and3s(!logi_cno, z <= 0L, ),
         band3(!logi_cno, z <= 0L, ))
  exp_eq(and3s(!logi_cnp, k <= 1L, ),
         band3(!logi_cnp, k <= 1L, ))
  exp_eq(and3s(!logi_cnq, d <= 9L, ),
         band3(!logi_cnq, d <= 9L, ))
  exp_eq(and3s(!logi_cnr, f <= 0L, u < 0L),
         band3(!logi_cnr, f <= 0L, u < 0L))
  exp_eq(and3s(!logi_cns, w <= 1L, f < 1L),
         band3(!logi_cns, w <= 1L, f < 1L))
  exp_eq(and3s(!logi_cnt, x <= 9L, i < 9L),
         band3(!logi_cnt, x <= 9L, i < 9L))
  exp_eq(and3s(!logi_cnu, , ),
         band3(!logi_cnu, , ))
  exp_eq(and3s(!logi_cnv, , ),
         band3(!logi_cnv, , ))
  exp_eq(and3s(!logi_cnw, , ),
         band3(!logi_cnw, , ))
  exp_eq(and3s(!logi_cnx, , f <= 0L),
         band3(!logi_cnx, , f <= 0L))
  exp_eq(and3s(!logi_cny, , o <= 1L),
         band3(!logi_cny, , o <= 1L))
  exp_eq(and3s(!logi_cnz, , g <= 9L),
         band3(!logi_cnz, , g <= 9L))
  exp_eq(and3s(!logi_coa, d <= 0L, ),
         band3(!logi_coa, d <= 0L, ))
  exp_eq(and3s(!logi_cob, x <= 1L, ),
         band3(!logi_cob, x <= 1L, ))
  exp_eq(and3s(!logi_coc, j <= 9L, ),
         band3(!logi_coc, j <= 9L, ))
  exp_eq(and3s(!logi_cod, c <= 0L, o <= 0L),
         band3(!logi_cod, c <= 0L, o <= 0L))
  exp_eq(and3s(!logi_coe, w <= 1L, u <= 1L),
         band3(!logi_coe, w <= 1L, u <= 1L))
  exp_eq(and3s(!logi_cof, h <= 9L, m <= 9L),
         band3(!logi_cof, h <= 9L, m <= 9L))
  exp_eq(and3s(!logi_cog, , ),
         band3(!logi_cog, , ))
  exp_eq(and3s(!logi_coh, , ),
         band3(!logi_coh, , ))
  exp_eq(and3s(!logi_coi, , ),
         band3(!logi_coi, , ))
  exp_eq(and3s(!logi_coj, , y == 0L),
         band3(!logi_coj, , y == 0L))
  exp_eq(and3s(!logi_cok, , c == 1L),
         band3(!logi_cok, , c == 1L))
  exp_eq(and3s(!logi_col, , o == 9L),
         band3(!logi_col, , o == 9L))
  exp_eq(and3s(!logi_com, z <= 0L, ),
         band3(!logi_com, z <= 0L, ))
  exp_eq(and3s(!logi_con, t <= 1L, ),
         band3(!logi_con, t <= 1L, ))
  exp_eq(and3s(!logi_coo, u <= 9L, ),
         band3(!logi_coo, u <= 9L, ))
  exp_eq(and3s(!logi_cop, r <= 0L, l == 0L),
         band3(!logi_cop, r <= 0L, l == 0L))
  exp_eq(and3s(!logi_coq, a <= 1L, k == 1L),
         band3(!logi_coq, a <= 1L, k == 1L))
  exp_eq(and3s(!logi_cor, u <= 9L, h == 9L),
         band3(!logi_cor, u <= 9L, h == 9L))
  exp_eq(and3s(!logi_cos, , ),
         band3(!logi_cos, , ))
  exp_eq(and3s(!logi_cot, , ),
         band3(!logi_cot, , ))
  exp_eq(and3s(!logi_cou, , ),
         band3(!logi_cou, , ))
  exp_eq(and3s(!logi_cov, , m > 0L),
         band3(!logi_cov, , m > 0L))
  exp_eq(and3s(!logi_cow, , r > 1L),
         band3(!logi_cow, , r > 1L))
  exp_eq(and3s(!logi_cox, , h > 9L),
         band3(!logi_cox, , h > 9L))
  exp_eq(and3s(!logi_coy, k <= 0L, ),
         band3(!logi_coy, k <= 0L, ))
  exp_eq(and3s(!logi_coz, h <= 1L, ),
         band3(!logi_coz, h <= 1L, ))
  exp_eq(and3s(!logi_cpa, q <= 9L, ),
         band3(!logi_cpa, q <= 9L, ))
  exp_eq(and3s(!logi_cpb, p <= 0L, g > 0L),
         band3(!logi_cpb, p <= 0L, g > 0L))
  exp_eq(and3s(!logi_cpc, x <= 1L, q > 1L),
         band3(!logi_cpc, x <= 1L, q > 1L))
  exp_eq(and3s(!logi_cpd, v <= 9L, d > 9L),
         band3(!logi_cpd, v <= 9L, d > 9L))
  exp_eq(and3s(!logi_cpe, , ),
         band3(!logi_cpe, , ))
  exp_eq(and3s(!logi_cpf, , ),
         band3(!logi_cpf, , ))
  exp_eq(and3s(!logi_cpg, , ),
         band3(!logi_cpg, , ))
  exp_eq(and3s(!logi_cph, , t >= 0L),
         band3(!logi_cph, , t >= 0L))
  exp_eq(and3s(!logi_cpi, , q >= 1L),
         band3(!logi_cpi, , q >= 1L))
  exp_eq(and3s(!logi_cpj, , j >= 9L),
         band3(!logi_cpj, , j >= 9L))
  exp_eq(and3s(!logi_cpk, o <= 0L, ),
         band3(!logi_cpk, o <= 0L, ))
  exp_eq(and3s(!logi_cpl, s <= 1L, ),
         band3(!logi_cpl, s <= 1L, ))
  exp_eq(and3s(!logi_cpm, d <= 9L, ),
         band3(!logi_cpm, d <= 9L, ))
  exp_eq(and3s(!logi_cpn, t <= 0L, g >= 0L),
         band3(!logi_cpn, t <= 0L, g >= 0L))
  exp_eq(and3s(!logi_cpo, k <= 1L, x >= 1L),
         band3(!logi_cpo, k <= 1L, x >= 1L))
  exp_eq(and3s(!logi_cpp, y <= 9L, c >= 9L),
         band3(!logi_cpp, y <= 9L, c >= 9L))
  exp_eq(and3s(!logi_cpq, , ),
         band3(!logi_cpq, , ))
  exp_eq(and3s(!logi_cpr, , ),
         band3(!logi_cpr, , ))
  exp_eq(and3s(!logi_cps, , ),
         band3(!logi_cps, , ))
  exp_eq(and3s(!logi_cpt, , logi_f),
         band3(!logi_cpt, , logi_f))
  exp_eq(and3s(!logi_cpu, , logi_o),
         band3(!logi_cpu, , logi_o))
  exp_eq(and3s(!logi_cpv, , logi_g),
         band3(!logi_cpv, , logi_g))
  exp_eq(and3s(!logi_cpw, f == 0L, ),
         band3(!logi_cpw, f == 0L, ))
  exp_eq(and3s(!logi_cpx, a == 1L, ),
         band3(!logi_cpx, a == 1L, ))
  exp_eq(and3s(!logi_cpy, c == 9L, ),
         band3(!logi_cpy, c == 9L, ))
  exp_eq(and3s(!logi_cpz, g == 0L, logi_j),
         band3(!logi_cpz, g == 0L, logi_j))
  exp_eq(and3s(!logi_cqa, h == 1L, logi_j),
         band3(!logi_cqa, h == 1L, logi_j))
  exp_eq(and3s(!logi_cqb, i == 9L, logi_b),
         band3(!logi_cqb, i == 9L, logi_b))
  exp_eq(and3s(!logi_cqc, , ),
         band3(!logi_cqc, , ))
  exp_eq(and3s(!logi_cqd, , ),
         band3(!logi_cqd, , ))
  exp_eq(and3s(!logi_cqe, , ),
         band3(!logi_cqe, , ))
  exp_eq(and3s(!logi_cqf, , !logi_c),
         band3(!logi_cqf, , !logi_c))
  exp_eq(and3s(!logi_cqg, , !logi_g),
         band3(!logi_cqg, , !logi_g))
  exp_eq(and3s(!logi_cqh, , !logi_n),
         band3(!logi_cqh, , !logi_n))
  exp_eq(and3s(!logi_cqi, d == 0L, ),
         band3(!logi_cqi, d == 0L, ))
  exp_eq(and3s(!logi_cqj, n == 1L, ),
         band3(!logi_cqj, n == 1L, ))
  exp_eq(and3s(!logi_cqk, x == 9L, ),
         band3(!logi_cqk, x == 9L, ))
  exp_eq(and3s(!logi_cql, v == 0L, !logi_v),
         band3(!logi_cql, v == 0L, !logi_v))
  exp_eq(and3s(!logi_cqm, z == 1L, !logi_h),
         band3(!logi_cqm, z == 1L, !logi_h))
  exp_eq(and3s(!logi_cqn, y == 9L, !logi_h),
         band3(!logi_cqn, y == 9L, !logi_h))
  exp_eq(and3s(!logi_cqo, , ),
         band3(!logi_cqo, , ))
  exp_eq(and3s(!logi_cqp, , ),
         band3(!logi_cqp, , ))
  exp_eq(and3s(!logi_cqq, , ),
         band3(!logi_cqq, , ))
  exp_eq(and3s(!logi_cqr, , i != 0L),
         band3(!logi_cqr, , i != 0L))
  exp_eq(and3s(!logi_cqs, , m != 1L),
         band3(!logi_cqs, , m != 1L))
  exp_eq(and3s(!logi_cqt, , q != 9L),
         band3(!logi_cqt, , q != 9L))
  exp_eq(and3s(!logi_cqu, r == 0L, ),
         band3(!logi_cqu, r == 0L, ))
  exp_eq(and3s(!logi_cqv, m == 1L, ),
         band3(!logi_cqv, m == 1L, ))
  exp_eq(and3s(!logi_cqw, y == 9L, ),
         band3(!logi_cqw, y == 9L, ))
  exp_eq(and3s(!logi_cqx, w == 0L, u != 0L),
         band3(!logi_cqx, w == 0L, u != 0L))
  exp_eq(and3s(!logi_cqy, g == 1L, y != 1L),
         band3(!logi_cqy, g == 1L, y != 1L))
  exp_eq(and3s(!logi_cqz, l == 9L, w != 9L),
         band3(!logi_cqz, l == 9L, w != 9L))
  exp_eq(and3s(!logi_cra, , ),
         band3(!logi_cra, , ))
  exp_eq(and3s(!logi_crb, , ),
         band3(!logi_crb, , ))
  exp_eq(and3s(!logi_crc, , ),
         band3(!logi_crc, , ))
  exp_eq(and3s(!logi_crd, , z %between% c(-1L, 1L)),
         band3(!logi_crd, , z %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cre, , j %between% c(-1L, 1L)),
         band3(!logi_cre, , j %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_crf, , d %between% c(-1L, 1L)),
         band3(!logi_crf, , d %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_crg, j == 0L, ),
         band3(!logi_crg, j == 0L, ))
  exp_eq(and3s(!logi_crh, s == 1L, ),
         band3(!logi_crh, s == 1L, ))
  exp_eq(and3s(!logi_cri, u == 9L, ),
         band3(!logi_cri, u == 9L, ))
  exp_eq(and3s(!logi_crj, m == 0L, a %between% c(-1L, 1L)),
         band3(!logi_crj, m == 0L, a %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_crk, v == 1L, m %between% c(-1L, 1L)),
         band3(!logi_crk, v == 1L, m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_crl, y == 9L, b %between% c(-1L, 1L)),
         band3(!logi_crl, y == 9L, b %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_crm, , ),
         band3(!logi_crm, , ))
  exp_eq(and3s(!logi_crn, , ),
         band3(!logi_crn, , ))
  exp_eq(and3s(!logi_cro, , ),
         band3(!logi_cro, , ))
  exp_eq(and3s(!logi_crp, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crp, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_crq, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crq, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_crr, , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crr, , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_crs, y == 0L, ),
         band3(!logi_crs, y == 0L, ))
  exp_eq(and3s(!logi_crt, p == 1L, ),
         band3(!logi_crt, p == 1L, ))
  exp_eq(and3s(!logi_cru, c == 9L, ),
         band3(!logi_cru, c == 9L, ))
  exp_eq(and3s(!logi_crv, c == 0L, u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crv, c == 0L, u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_crw, n == 1L, u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crw, n == 1L, u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_crx, a == 9L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_crx, a == 9L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cry, , ),
         band3(!logi_cry, , ))
  exp_eq(and3s(!logi_crz, , ),
         band3(!logi_crz, , ))
  exp_eq(and3s(!logi_csa, , ),
         band3(!logi_csa, , ))
  exp_eq(and3s(!logi_csb, , i %in% 1:4),
         band3(!logi_csb, , i %in% 1:4))
  exp_eq(and3s(!logi_csc, , g %in% 1:4),
         band3(!logi_csc, , g %in% 1:4))
  exp_eq(and3s(!logi_csd, , x %in% 1:4),
         band3(!logi_csd, , x %in% 1:4))
  exp_eq(and3s(!logi_cse, e == 0L, ),
         band3(!logi_cse, e == 0L, ))
  exp_eq(and3s(!logi_csf, h == 1L, ),
         band3(!logi_csf, h == 1L, ))
  exp_eq(and3s(!logi_csg, p == 9L, ),
         band3(!logi_csg, p == 9L, ))
  exp_eq(and3s(!logi_csh, n == 0L, j %in% 1:4),
         band3(!logi_csh, n == 0L, j %in% 1:4))
  exp_eq(and3s(!logi_csi, c == 1L, d %in% 1:4),
         band3(!logi_csi, c == 1L, d %in% 1:4))
  exp_eq(and3s(!logi_csj, a == 9L, j %in% 1:4),
         band3(!logi_csj, a == 9L, j %in% 1:4))
  exp_eq(and3s(!logi_csk, , ),
         band3(!logi_csk, , ))
  exp_eq(and3s(!logi_csl, , ),
         band3(!logi_csl, , ))
  exp_eq(and3s(!logi_csm, , ),
         band3(!logi_csm, , ))
  exp_eq(and3s(!logi_csn, , d < 0L),
         band3(!logi_csn, , d < 0L))
  exp_eq(and3s(!logi_cso, , j < 1L),
         band3(!logi_cso, , j < 1L))
  exp_eq(and3s(!logi_csp, , m < 9L),
         band3(!logi_csp, , m < 9L))
  exp_eq(and3s(!logi_csq, a == 0L, ),
         band3(!logi_csq, a == 0L, ))
  exp_eq(and3s(!logi_csr, z == 1L, ),
         band3(!logi_csr, z == 1L, ))
  exp_eq(and3s(!logi_css, i == 9L, ),
         band3(!logi_css, i == 9L, ))
  exp_eq(and3s(!logi_cst, f == 0L, q < 0L),
         band3(!logi_cst, f == 0L, q < 0L))
  exp_eq(and3s(!logi_csu, j == 1L, z < 1L),
         band3(!logi_csu, j == 1L, z < 1L))
  exp_eq(and3s(!logi_csv, w == 9L, o < 9L),
         band3(!logi_csv, w == 9L, o < 9L))
  exp_eq(and3s(!logi_csw, , ),
         band3(!logi_csw, , ))
  exp_eq(and3s(!logi_csx, , ),
         band3(!logi_csx, , ))
  exp_eq(and3s(!logi_csy, , ),
         band3(!logi_csy, , ))
  exp_eq(and3s(!logi_csz, , u <= 0L),
         band3(!logi_csz, , u <= 0L))
  exp_eq(and3s(!logi_cta, , f <= 1L),
         band3(!logi_cta, , f <= 1L))
  exp_eq(and3s(!logi_ctb, , l <= 9L),
         band3(!logi_ctb, , l <= 9L))
  exp_eq(and3s(!logi_ctc, e == 0L, ),
         band3(!logi_ctc, e == 0L, ))
  exp_eq(and3s(!logi_ctd, u == 1L, ),
         band3(!logi_ctd, u == 1L, ))
  exp_eq(and3s(!logi_cte, p == 9L, ),
         band3(!logi_cte, p == 9L, ))
  exp_eq(and3s(!logi_ctf, a == 0L, f <= 0L),
         band3(!logi_ctf, a == 0L, f <= 0L))
  exp_eq(and3s(!logi_ctg, d == 1L, p <= 1L),
         band3(!logi_ctg, d == 1L, p <= 1L))
  exp_eq(and3s(!logi_cth, e == 9L, e <= 9L),
         band3(!logi_cth, e == 9L, e <= 9L))
  exp_eq(and3s(!logi_cti, , ),
         band3(!logi_cti, , ))
  exp_eq(and3s(!logi_ctj, , ),
         band3(!logi_ctj, , ))
  exp_eq(and3s(!logi_ctk, , ),
         band3(!logi_ctk, , ))
  exp_eq(and3s(!logi_ctl, , v == 0L),
         band3(!logi_ctl, , v == 0L))
  exp_eq(and3s(!logi_ctm, , j == 1L),
         band3(!logi_ctm, , j == 1L))
  exp_eq(and3s(!logi_ctn, , y == 9L),
         band3(!logi_ctn, , y == 9L))
  exp_eq(and3s(!logi_cto, y == 0L, ),
         band3(!logi_cto, y == 0L, ))
  exp_eq(and3s(!logi_ctp, v == 1L, ),
         band3(!logi_ctp, v == 1L, ))
  exp_eq(and3s(!logi_ctq, g == 9L, ),
         band3(!logi_ctq, g == 9L, ))
  exp_eq(and3s(!logi_ctr, q == 0L, n == 0L),
         band3(!logi_ctr, q == 0L, n == 0L))
  exp_eq(and3s(!logi_cts, d == 1L, m == 1L),
         band3(!logi_cts, d == 1L, m == 1L))
  exp_eq(and3s(!logi_ctt, e == 9L, g == 9L),
         band3(!logi_ctt, e == 9L, g == 9L))
  exp_eq(and3s(!logi_ctu, , ),
         band3(!logi_ctu, , ))
  exp_eq(and3s(!logi_ctv, , ),
         band3(!logi_ctv, , ))
  exp_eq(and3s(!logi_ctw, , ),
         band3(!logi_ctw, , ))
  exp_eq(and3s(!logi_ctx, , o > 0L),
         band3(!logi_ctx, , o > 0L))
  exp_eq(and3s(!logi_cty, , s > 1L),
         band3(!logi_cty, , s > 1L))
  exp_eq(and3s(!logi_ctz, , g > 9L),
         band3(!logi_ctz, , g > 9L))
  exp_eq(and3s(!logi_cua, t == 0L, ),
         band3(!logi_cua, t == 0L, ))
  exp_eq(and3s(!logi_cub, f == 1L, ),
         band3(!logi_cub, f == 1L, ))
  exp_eq(and3s(!logi_cuc, x == 9L, ),
         band3(!logi_cuc, x == 9L, ))
  exp_eq(and3s(!logi_cud, y == 0L, k > 0L),
         band3(!logi_cud, y == 0L, k > 0L))
  exp_eq(and3s(!logi_cue, e == 1L, y > 1L),
         band3(!logi_cue, e == 1L, y > 1L))
  exp_eq(and3s(!logi_cuf, r == 9L, u > 9L),
         band3(!logi_cuf, r == 9L, u > 9L))
  exp_eq(and3s(!logi_cug, , ),
         band3(!logi_cug, , ))
  exp_eq(and3s(!logi_cuh, , ),
         band3(!logi_cuh, , ))
  exp_eq(and3s(!logi_cui, , ),
         band3(!logi_cui, , ))
  exp_eq(and3s(!logi_cuj, , t >= 0L),
         band3(!logi_cuj, , t >= 0L))
  exp_eq(and3s(!logi_cuk, , a >= 1L),
         band3(!logi_cuk, , a >= 1L))
  exp_eq(and3s(!logi_cul, , l >= 9L),
         band3(!logi_cul, , l >= 9L))
  exp_eq(and3s(!logi_cum, g == 0L, ),
         band3(!logi_cum, g == 0L, ))
  exp_eq(and3s(!logi_cun, t == 1L, ),
         band3(!logi_cun, t == 1L, ))
  exp_eq(and3s(!logi_cuo, t == 9L, ),
         band3(!logi_cuo, t == 9L, ))
  exp_eq(and3s(!logi_cup, d == 0L, v >= 0L),
         band3(!logi_cup, d == 0L, v >= 0L))
  exp_eq(and3s(!logi_cuq, i == 1L, t >= 1L),
         band3(!logi_cuq, i == 1L, t >= 1L))
  exp_eq(and3s(!logi_cur, m == 9L, j >= 9L),
         band3(!logi_cur, m == 9L, j >= 9L))
  exp_eq(and3s(!logi_cus, , ),
         band3(!logi_cus, , ))
  exp_eq(and3s(!logi_cut, , ),
         band3(!logi_cut, , ))
  exp_eq(and3s(!logi_cuu, , ),
         band3(!logi_cuu, , ))
  exp_eq(and3s(!logi_cuv, , logi_m),
         band3(!logi_cuv, , logi_m))
  exp_eq(and3s(!logi_cuw, , logi_h),
         band3(!logi_cuw, , logi_h))
  exp_eq(and3s(!logi_cux, , logi_j),
         band3(!logi_cux, , logi_j))
  exp_eq(and3s(!logi_cuy, c > 0L, ),
         band3(!logi_cuy, c > 0L, ))
  exp_eq(and3s(!logi_cuz, y > 1L, ),
         band3(!logi_cuz, y > 1L, ))
  exp_eq(and3s(!logi_cva, x > 9L, ),
         band3(!logi_cva, x > 9L, ))
  exp_eq(and3s(!logi_cvb, q > 0L, logi_k),
         band3(!logi_cvb, q > 0L, logi_k))
  exp_eq(and3s(!logi_cvc, d > 1L, logi_x),
         band3(!logi_cvc, d > 1L, logi_x))
  exp_eq(and3s(!logi_cvd, w > 9L, logi_a),
         band3(!logi_cvd, w > 9L, logi_a))
  exp_eq(and3s(!logi_cve, , ),
         band3(!logi_cve, , ))
  exp_eq(and3s(!logi_cvf, , ),
         band3(!logi_cvf, , ))
  exp_eq(and3s(!logi_cvg, , ),
         band3(!logi_cvg, , ))
  exp_eq(and3s(!logi_cvh, , !logi_z),
         band3(!logi_cvh, , !logi_z))
  exp_eq(and3s(!logi_cvi, , !logi_t),
         band3(!logi_cvi, , !logi_t))
  exp_eq(and3s(!logi_cvj, , !logi_s),
         band3(!logi_cvj, , !logi_s))
  exp_eq(and3s(!logi_cvk, k > 0L, ),
         band3(!logi_cvk, k > 0L, ))
  exp_eq(and3s(!logi_cvl, t > 1L, ),
         band3(!logi_cvl, t > 1L, ))
  exp_eq(and3s(!logi_cvm, s > 9L, ),
         band3(!logi_cvm, s > 9L, ))
  exp_eq(and3s(!logi_cvn, x > 0L, !logi_d),
         band3(!logi_cvn, x > 0L, !logi_d))
  exp_eq(and3s(!logi_cvo, l > 1L, !logi_f),
         band3(!logi_cvo, l > 1L, !logi_f))
  exp_eq(and3s(!logi_cvp, p > 9L, !logi_x),
         band3(!logi_cvp, p > 9L, !logi_x))
  exp_eq(and3s(!logi_cvq, , ),
         band3(!logi_cvq, , ))
  exp_eq(and3s(!logi_cvr, , ),
         band3(!logi_cvr, , ))
  exp_eq(and3s(!logi_cvs, , ),
         band3(!logi_cvs, , ))
  exp_eq(and3s(!logi_cvt, , y != 0L),
         band3(!logi_cvt, , y != 0L))
  exp_eq(and3s(!logi_cvu, , s != 1L),
         band3(!logi_cvu, , s != 1L))
  exp_eq(and3s(!logi_cvv, , v != 9L),
         band3(!logi_cvv, , v != 9L))
  exp_eq(and3s(!logi_cvw, w > 0L, ),
         band3(!logi_cvw, w > 0L, ))
  exp_eq(and3s(!logi_cvx, u > 1L, ),
         band3(!logi_cvx, u > 1L, ))
  exp_eq(and3s(!logi_cvy, u > 9L, ),
         band3(!logi_cvy, u > 9L, ))
  exp_eq(and3s(!logi_cvz, a > 0L, g != 0L),
         band3(!logi_cvz, a > 0L, g != 0L))
  exp_eq(and3s(!logi_cwa, x > 1L, g != 1L),
         band3(!logi_cwa, x > 1L, g != 1L))
  exp_eq(and3s(!logi_cwb, h > 9L, e != 9L),
         band3(!logi_cwb, h > 9L, e != 9L))
  exp_eq(and3s(!logi_cwc, , ),
         band3(!logi_cwc, , ))
  exp_eq(and3s(!logi_cwd, , ),
         band3(!logi_cwd, , ))
  exp_eq(and3s(!logi_cwe, , ),
         band3(!logi_cwe, , ))
  exp_eq(and3s(!logi_cwf, , r %between% c(-1L, 1L)),
         band3(!logi_cwf, , r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwg, , z %between% c(-1L, 1L)),
         band3(!logi_cwg, , z %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwh, , o %between% c(-1L, 1L)),
         band3(!logi_cwh, , o %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwi, q > 0L, ),
         band3(!logi_cwi, q > 0L, ))
  exp_eq(and3s(!logi_cwj, l > 1L, ),
         band3(!logi_cwj, l > 1L, ))
  exp_eq(and3s(!logi_cwk, x > 9L, ),
         band3(!logi_cwk, x > 9L, ))
  exp_eq(and3s(!logi_cwl, e > 0L, m %between% c(-1L, 1L)),
         band3(!logi_cwl, e > 0L, m %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwm, c > 1L, u %between% c(-1L, 1L)),
         band3(!logi_cwm, c > 1L, u %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwn, c > 9L, y %between% c(-1L, 1L)),
         band3(!logi_cwn, c > 9L, y %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_cwo, , ),
         band3(!logi_cwo, , ))
  exp_eq(and3s(!logi_cwp, , ),
         band3(!logi_cwp, , ))
  exp_eq(and3s(!logi_cwq, , ),
         band3(!logi_cwq, , ))
  exp_eq(and3s(!logi_cwr, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cwr, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cws, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cws, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cwt, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cwt, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cwu, r > 0L, ),
         band3(!logi_cwu, r > 0L, ))
  exp_eq(and3s(!logi_cwv, r > 1L, ),
         band3(!logi_cwv, r > 1L, ))
  exp_eq(and3s(!logi_cww, k > 9L, ),
         band3(!logi_cww, k > 9L, ))
  exp_eq(and3s(!logi_cwx, b > 0L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cwx, b > 0L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cwy, a > 1L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cwy, a > 1L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cwz, q > 9L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_cwz, q > 9L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_cxa, , ),
         band3(!logi_cxa, , ))
  exp_eq(and3s(!logi_cxb, , ),
         band3(!logi_cxb, , ))
  exp_eq(and3s(!logi_cxc, , ),
         band3(!logi_cxc, , ))
  exp_eq(and3s(!logi_cxd, , r %in% 1:4),
         band3(!logi_cxd, , r %in% 1:4))
  exp_eq(and3s(!logi_cxe, , q %in% 1:4),
         band3(!logi_cxe, , q %in% 1:4))
  exp_eq(and3s(!logi_cxf, , z %in% 1:4),
         band3(!logi_cxf, , z %in% 1:4))
  exp_eq(and3s(!logi_cxg, z > 0L, ),
         band3(!logi_cxg, z > 0L, ))
  exp_eq(and3s(!logi_cxh, z > 1L, ),
         band3(!logi_cxh, z > 1L, ))
  exp_eq(and3s(!logi_cxi, g > 9L, ),
         band3(!logi_cxi, g > 9L, ))
  exp_eq(and3s(!logi_cxj, n > 0L, e %in% 1:4),
         band3(!logi_cxj, n > 0L, e %in% 1:4))
  exp_eq(and3s(!logi_cxk, y > 1L, a %in% 1:4),
         band3(!logi_cxk, y > 1L, a %in% 1:4))
  exp_eq(and3s(!logi_cxl, x > 9L, k %in% 1:4),
         band3(!logi_cxl, x > 9L, k %in% 1:4))
  exp_eq(and3s(!logi_cxm, , ),
         band3(!logi_cxm, , ))
  exp_eq(and3s(!logi_cxn, , ),
         band3(!logi_cxn, , ))
  exp_eq(and3s(!logi_cxo, , ),
         band3(!logi_cxo, , ))
  exp_eq(and3s(!logi_cxp, , k < 0L),
         band3(!logi_cxp, , k < 0L))
  exp_eq(and3s(!logi_cxq, , h < 1L),
         band3(!logi_cxq, , h < 1L))
  exp_eq(and3s(!logi_cxr, , t < 9L),
         band3(!logi_cxr, , t < 9L))
  exp_eq(and3s(!logi_cxs, r > 0L, ),
         band3(!logi_cxs, r > 0L, ))
  exp_eq(and3s(!logi_cxt, m > 1L, ),
         band3(!logi_cxt, m > 1L, ))
  exp_eq(and3s(!logi_cxu, j > 9L, ),
         band3(!logi_cxu, j > 9L, ))
  exp_eq(and3s(!logi_cxv, a > 0L, b < 0L),
         band3(!logi_cxv, a > 0L, b < 0L))
  exp_eq(and3s(!logi_cxw, z > 1L, e < 1L),
         band3(!logi_cxw, z > 1L, e < 1L))
  exp_eq(and3s(!logi_cxx, h > 9L, a < 9L),
         band3(!logi_cxx, h > 9L, a < 9L))
  exp_eq(and3s(!logi_cxy, , ),
         band3(!logi_cxy, , ))
  exp_eq(and3s(!logi_cxz, , ),
         band3(!logi_cxz, , ))
  exp_eq(and3s(!logi_cya, , ),
         band3(!logi_cya, , ))
  exp_eq(and3s(!logi_cyb, , q <= 0L),
         band3(!logi_cyb, , q <= 0L))
  exp_eq(and3s(!logi_cyc, , o <= 1L),
         band3(!logi_cyc, , o <= 1L))
  exp_eq(and3s(!logi_cyd, , f <= 9L),
         band3(!logi_cyd, , f <= 9L))
  exp_eq(and3s(!logi_cye, s > 0L, ),
         band3(!logi_cye, s > 0L, ))
  exp_eq(and3s(!logi_cyf, v > 1L, ),
         band3(!logi_cyf, v > 1L, ))
  exp_eq(and3s(!logi_cyg, r > 9L, ),
         band3(!logi_cyg, r > 9L, ))
  exp_eq(and3s(!logi_cyh, b > 0L, x <= 0L),
         band3(!logi_cyh, b > 0L, x <= 0L))
  exp_eq(and3s(!logi_cyi, w > 1L, m <= 1L),
         band3(!logi_cyi, w > 1L, m <= 1L))
  exp_eq(and3s(!logi_cyj, c > 9L, u <= 9L),
         band3(!logi_cyj, c > 9L, u <= 9L))
  exp_eq(and3s(!logi_cyk, , ),
         band3(!logi_cyk, , ))
  exp_eq(and3s(!logi_cyl, , ),
         band3(!logi_cyl, , ))
  exp_eq(and3s(!logi_cym, , ),
         band3(!logi_cym, , ))
  exp_eq(and3s(!logi_cyn, , x == 0L),
         band3(!logi_cyn, , x == 0L))
  exp_eq(and3s(!logi_cyo, , n == 1L),
         band3(!logi_cyo, , n == 1L))
  exp_eq(and3s(!logi_cyp, , p == 9L),
         band3(!logi_cyp, , p == 9L))
  exp_eq(and3s(!logi_cyq, r > 0L, ),
         band3(!logi_cyq, r > 0L, ))
  exp_eq(and3s(!logi_cyr, v > 1L, ),
         band3(!logi_cyr, v > 1L, ))
  exp_eq(and3s(!logi_cys, r > 9L, ),
         band3(!logi_cys, r > 9L, ))
  exp_eq(and3s(!logi_cyt, y > 0L, c == 0L),
         band3(!logi_cyt, y > 0L, c == 0L))
  exp_eq(and3s(!logi_cyu, t > 1L, r == 1L),
         band3(!logi_cyu, t > 1L, r == 1L))
  exp_eq(and3s(!logi_cyv, m > 9L, v == 9L),
         band3(!logi_cyv, m > 9L, v == 9L))
  exp_eq(and3s(!logi_cyw, , ),
         band3(!logi_cyw, , ))
  exp_eq(and3s(!logi_cyx, , ),
         band3(!logi_cyx, , ))
  exp_eq(and3s(!logi_cyy, , ),
         band3(!logi_cyy, , ))
  exp_eq(and3s(!logi_cyz, , w > 0L),
         band3(!logi_cyz, , w > 0L))
  exp_eq(and3s(!logi_da, , f > 1L),
         band3(!logi_da, , f > 1L))
  exp_eq(and3s(!logi_db, , f > 9L),
         band3(!logi_db, , f > 9L))
  exp_eq(and3s(!logi_dc, m > 0L, ),
         band3(!logi_dc, m > 0L, ))
  exp_eq(and3s(!logi_dd, d > 1L, ),
         band3(!logi_dd, d > 1L, ))
  exp_eq(and3s(!logi_de, o > 9L, ),
         band3(!logi_de, o > 9L, ))
  exp_eq(and3s(!logi_df, f > 0L, y > 0L),
         band3(!logi_df, f > 0L, y > 0L))
  exp_eq(and3s(!logi_dg, i > 1L, y > 1L),
         band3(!logi_dg, i > 1L, y > 1L))
  exp_eq(and3s(!logi_dh, b > 9L, n > 9L),
         band3(!logi_dh, b > 9L, n > 9L))
  exp_eq(and3s(!logi_di, , ),
         band3(!logi_di, , ))
  exp_eq(and3s(!logi_dj, , ),
         band3(!logi_dj, , ))
  exp_eq(and3s(!logi_dk, , ),
         band3(!logi_dk, , ))
  exp_eq(and3s(!logi_dl, , z >= 0L),
         band3(!logi_dl, , z >= 0L))
  exp_eq(and3s(!logi_dm, , v >= 1L),
         band3(!logi_dm, , v >= 1L))
  exp_eq(and3s(!logi_dn, , y >= 9L),
         band3(!logi_dn, , y >= 9L))
  exp_eq(and3s(!logi_do, f > 0L, ),
         band3(!logi_do, f > 0L, ))
  exp_eq(and3s(!logi_dp, g > 1L, ),
         band3(!logi_dp, g > 1L, ))
  exp_eq(and3s(!logi_dq, s > 9L, ),
         band3(!logi_dq, s > 9L, ))
  exp_eq(and3s(!logi_dr, a > 0L, u >= 0L),
         band3(!logi_dr, a > 0L, u >= 0L))
  exp_eq(and3s(!logi_ds, v > 1L, q >= 1L),
         band3(!logi_ds, v > 1L, q >= 1L))
  exp_eq(and3s(!logi_dt, w > 9L, o >= 9L),
         band3(!logi_dt, w > 9L, o >= 9L))
  exp_eq(and3s(!logi_du, , ),
         band3(!logi_du, , ))
  exp_eq(and3s(!logi_dv, , ),
         band3(!logi_dv, , ))
  exp_eq(and3s(!logi_dw, , ),
         band3(!logi_dw, , ))
  exp_eq(and3s(!logi_dx, , logi_z),
         band3(!logi_dx, , logi_z))
  exp_eq(and3s(!logi_dy, , logi_o),
         band3(!logi_dy, , logi_o))
  exp_eq(and3s(!logi_dz, , logi_r),
         band3(!logi_dz, , logi_r))
  exp_eq(and3s(!logi_daa, d >= 0L, ),
         band3(!logi_daa, d >= 0L, ))
  exp_eq(and3s(!logi_dab, k >= 1L, ),
         band3(!logi_dab, k >= 1L, ))
  exp_eq(and3s(!logi_dac, m >= 9L, ),
         band3(!logi_dac, m >= 9L, ))
  exp_eq(and3s(!logi_dad, h >= 0L, logi_z),
         band3(!logi_dad, h >= 0L, logi_z))
  exp_eq(and3s(!logi_dae, p >= 1L, logi_o),
         band3(!logi_dae, p >= 1L, logi_o))
  exp_eq(and3s(!logi_daf, z >= 9L, logi_x),
         band3(!logi_daf, z >= 9L, logi_x))
  exp_eq(and3s(!logi_dag, , ),
         band3(!logi_dag, , ))
  exp_eq(and3s(!logi_dah, , ),
         band3(!logi_dah, , ))
  exp_eq(and3s(!logi_dai, , ),
         band3(!logi_dai, , ))
  exp_eq(and3s(!logi_daj, , !logi_l),
         band3(!logi_daj, , !logi_l))
  exp_eq(and3s(!logi_dak, , !logi_p),
         band3(!logi_dak, , !logi_p))
  exp_eq(and3s(!logi_dal, , !logi_q),
         band3(!logi_dal, , !logi_q))
  exp_eq(and3s(!logi_dam, z >= 0L, ),
         band3(!logi_dam, z >= 0L, ))
  exp_eq(and3s(!logi_dan, p >= 1L, ),
         band3(!logi_dan, p >= 1L, ))
  exp_eq(and3s(!logi_dao, g >= 9L, ),
         band3(!logi_dao, g >= 9L, ))
  exp_eq(and3s(!logi_dap, a >= 0L, !logi_t),
         band3(!logi_dap, a >= 0L, !logi_t))
  exp_eq(and3s(!logi_daq, s >= 1L, !logi_f),
         band3(!logi_daq, s >= 1L, !logi_f))
  exp_eq(and3s(!logi_dar, l >= 9L, !logi_y),
         band3(!logi_dar, l >= 9L, !logi_y))
  exp_eq(and3s(!logi_das, , ),
         band3(!logi_das, , ))
  exp_eq(and3s(!logi_dat, , ),
         band3(!logi_dat, , ))
  exp_eq(and3s(!logi_dau, , ),
         band3(!logi_dau, , ))
  exp_eq(and3s(!logi_dav, , b != 0L),
         band3(!logi_dav, , b != 0L))
  exp_eq(and3s(!logi_daw, , k != 1L),
         band3(!logi_daw, , k != 1L))
  exp_eq(and3s(!logi_dax, , j != 9L),
         band3(!logi_dax, , j != 9L))
  exp_eq(and3s(!logi_day, w >= 0L, ),
         band3(!logi_day, w >= 0L, ))
  exp_eq(and3s(!logi_daz, c >= 1L, ),
         band3(!logi_daz, c >= 1L, ))
  exp_eq(and3s(!logi_dba, z >= 9L, ),
         band3(!logi_dba, z >= 9L, ))
  exp_eq(and3s(!logi_dbb, q >= 0L, g != 0L),
         band3(!logi_dbb, q >= 0L, g != 0L))
  exp_eq(and3s(!logi_dbc, w >= 1L, q != 1L),
         band3(!logi_dbc, w >= 1L, q != 1L))
  exp_eq(and3s(!logi_dbd, a >= 9L, x != 9L),
         band3(!logi_dbd, a >= 9L, x != 9L))
  exp_eq(and3s(!logi_dbe, , ),
         band3(!logi_dbe, , ))
  exp_eq(and3s(!logi_dbf, , ),
         band3(!logi_dbf, , ))
  exp_eq(and3s(!logi_dbg, , ),
         band3(!logi_dbg, , ))
  exp_eq(and3s(!logi_dbh, , f %between% c(-1L, 1L)),
         band3(!logi_dbh, , f %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbi, , h %between% c(-1L, 1L)),
         band3(!logi_dbi, , h %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbj, , r %between% c(-1L, 1L)),
         band3(!logi_dbj, , r %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbk, x >= 0L, ),
         band3(!logi_dbk, x >= 0L, ))
  exp_eq(and3s(!logi_dbl, c >= 1L, ),
         band3(!logi_dbl, c >= 1L, ))
  exp_eq(and3s(!logi_dbm, n >= 9L, ),
         band3(!logi_dbm, n >= 9L, ))
  exp_eq(and3s(!logi_dbn, x >= 0L, k %between% c(-1L, 1L)),
         band3(!logi_dbn, x >= 0L, k %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbo, y >= 1L, k %between% c(-1L, 1L)),
         band3(!logi_dbo, y >= 1L, k %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbp, l >= 9L, u %between% c(-1L, 1L)),
         band3(!logi_dbp, l >= 9L, u %between% c(-1L, 1L)))
  exp_eq(and3s(!logi_dbq, , ),
         band3(!logi_dbq, , ))
  exp_eq(and3s(!logi_dbr, , ),
         band3(!logi_dbr, , ))
  exp_eq(and3s(!logi_dbs, , ),
         band3(!logi_dbs, , ))
  exp_eq(and3s(!logi_dbt, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dbt, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dbu, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dbu, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dbv, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dbv, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dbw, g >= 0L, ),
         band3(!logi_dbw, g >= 0L, ))
  exp_eq(and3s(!logi_dbx, u >= 1L, ),
         band3(!logi_dbx, u >= 1L, ))
  exp_eq(and3s(!logi_dby, r >= 9L, ),
         band3(!logi_dby, r >= 9L, ))
  exp_eq(and3s(!logi_dbz, c >= 0L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dbz, c >= 0L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dca, m >= 1L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dca, m >= 1L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dcb, q >= 9L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(!logi_dcb, q >= 9L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(!logi_dcc, , ),
         band3(!logi_dcc, , ))
  exp_eq(and3s(!logi_dcd, , ),
         band3(!logi_dcd, , ))
  exp_eq(and3s(!logi_dce, , ),
         band3(!logi_dce, , ))
  exp_eq(and3s(!logi_dcf, , k %in% 1:4),
         band3(!logi_dcf, , k %in% 1:4))
  exp_eq(and3s(!logi_dcg, , g %in% 1:4),
         band3(!logi_dcg, , g %in% 1:4))
  exp_eq(and3s(!logi_dch, , x %in% 1:4),
         band3(!logi_dch, , x %in% 1:4))
  exp_eq(and3s(!logi_dci, m >= 0L, ),
         band3(!logi_dci, m >= 0L, ))
  exp_eq(and3s(!logi_dcj, e >= 1L, ),
         band3(!logi_dcj, e >= 1L, ))
  exp_eq(and3s(!logi_dck, d >= 9L, ),
         band3(!logi_dck, d >= 9L, ))
  exp_eq(and3s(!logi_dcl, v >= 0L, k %in% 1:4),
         band3(!logi_dcl, v >= 0L, k %in% 1:4))
  exp_eq(and3s(!logi_dcm, p >= 1L, l %in% 1:4),
         band3(!logi_dcm, p >= 1L, l %in% 1:4))
  exp_eq(and3s(!logi_dcn, g >= 9L, s %in% 1:4),
         band3(!logi_dcn, g >= 9L, s %in% 1:4))
  exp_eq(and3s(!logi_dco, , ),
         band3(!logi_dco, , ))
  exp_eq(and3s(!logi_dcp, , ),
         band3(!logi_dcp, , ))
  exp_eq(and3s(!logi_dcq, , ),
         band3(!logi_dcq, , ))
  exp_eq(and3s(!logi_dcr, , e < 0L),
         band3(!logi_dcr, , e < 0L))
  exp_eq(and3s(!logi_dcs, , x < 1L),
         band3(!logi_dcs, , x < 1L))
  exp_eq(and3s(!logi_dct, , f < 9L),
         band3(!logi_dct, , f < 9L))
  exp_eq(and3s(!logi_dcu, v >= 0L, ),
         band3(!logi_dcu, v >= 0L, ))
  exp_eq(and3s(!logi_dcv, x >= 1L, ),
         band3(!logi_dcv, x >= 1L, ))
  exp_eq(and3s(!logi_dcw, n >= 9L, ),
         band3(!logi_dcw, n >= 9L, ))
  exp_eq(and3s(!logi_dcx, w >= 0L, l < 0L),
         band3(!logi_dcx, w >= 0L, l < 0L))
  exp_eq(and3s(!logi_dcy, n >= 1L, u < 1L),
         band3(!logi_dcy, n >= 1L, u < 1L))
  exp_eq(and3s(!logi_dcz, h >= 9L, q < 9L),
         band3(!logi_dcz, h >= 9L, q < 9L))
  exp_eq(and3s(!logi_dda, , ),
         band3(!logi_dda, , ))
  exp_eq(and3s(!logi_ddb, , ),
         band3(!logi_ddb, , ))
  exp_eq(and3s(!logi_ddc, , ),
         band3(!logi_ddc, , ))
  exp_eq(and3s(!logi_ddd, , g <= 0L),
         band3(!logi_ddd, , g <= 0L))
  exp_eq(and3s(!logi_dde, , o <= 1L),
         band3(!logi_dde, , o <= 1L))
  exp_eq(and3s(!logi_ddf, , c <= 9L),
         band3(!logi_ddf, , c <= 9L))
  exp_eq(and3s(!logi_ddg, i >= 0L, ),
         band3(!logi_ddg, i >= 0L, ))
  exp_eq(and3s(!logi_ddh, q >= 1L, ),
         band3(!logi_ddh, q >= 1L, ))
  exp_eq(and3s(!logi_ddi, o >= 9L, ),
         band3(!logi_ddi, o >= 9L, ))
  exp_eq(and3s(!logi_ddj, v >= 0L, h <= 0L),
         band3(!logi_ddj, v >= 0L, h <= 0L))
  exp_eq(and3s(!logi_ddk, y >= 1L, m <= 1L),
         band3(!logi_ddk, y >= 1L, m <= 1L))
  exp_eq(and3s(!logi_ddl, z >= 9L, l <= 9L),
         band3(!logi_ddl, z >= 9L, l <= 9L))
  exp_eq(and3s(!logi_ddm, , ),
         band3(!logi_ddm, , ))
  exp_eq(and3s(!logi_ddn, , ),
         band3(!logi_ddn, , ))
  exp_eq(and3s(!logi_ddo, , ),
         band3(!logi_ddo, , ))
  exp_eq(and3s(!logi_ddp, , p == 0L),
         band3(!logi_ddp, , p == 0L))
  exp_eq(and3s(!logi_ddq, , z == 1L),
         band3(!logi_ddq, , z == 1L))
  exp_eq(and3s(!logi_ddr, , x == 9L),
         band3(!logi_ddr, , x == 9L))
  exp_eq(and3s(!logi_dds, m >= 0L, ),
         band3(!logi_dds, m >= 0L, ))
  exp_eq(and3s(!logi_ddt, j >= 1L, ),
         band3(!logi_ddt, j >= 1L, ))
  exp_eq(and3s(!logi_ddu, s >= 9L, ),
         band3(!logi_ddu, s >= 9L, ))
  exp_eq(and3s(!logi_ddv, a >= 0L, s == 0L),
         band3(!logi_ddv, a >= 0L, s == 0L))
  exp_eq(and3s(!logi_ddw, t >= 1L, c == 1L),
         band3(!logi_ddw, t >= 1L, c == 1L))
  exp_eq(and3s(!logi_ddx, h >= 9L, x == 9L),
         band3(!logi_ddx, h >= 9L, x == 9L))
  exp_eq(and3s(!logi_ddy, , ),
         band3(!logi_ddy, , ))
  exp_eq(and3s(!logi_ddz, , ),
         band3(!logi_ddz, , ))
  exp_eq(and3s(!logi_dea, , ),
         band3(!logi_dea, , ))
  exp_eq(and3s(!logi_deb, , d > 0L),
         band3(!logi_deb, , d > 0L))
  exp_eq(and3s(!logi_dec, , u > 1L),
         band3(!logi_dec, , u > 1L))
  exp_eq(and3s(!logi_ded, , a > 9L),
         band3(!logi_ded, , a > 9L))
  exp_eq(and3s(!logi_dee, g >= 0L, ),
         band3(!logi_dee, g >= 0L, ))
  exp_eq(and3s(!logi_def, m >= 1L, ),
         band3(!logi_def, m >= 1L, ))
  exp_eq(and3s(!logi_deg, p >= 9L, ),
         band3(!logi_deg, p >= 9L, ))
  exp_eq(and3s(!logi_deh, e >= 0L, i > 0L),
         band3(!logi_deh, e >= 0L, i > 0L))
  exp_eq(and3s(!logi_dei, n >= 1L, i > 1L),
         band3(!logi_dei, n >= 1L, i > 1L))
  exp_eq(and3s(!logi_dej, n >= 9L, j > 9L),
         band3(!logi_dej, n >= 9L, j > 9L))
  exp_eq(and3s(!logi_dek, , ),
         band3(!logi_dek, , ))
  exp_eq(and3s(!logi_del, , ),
         band3(!logi_del, , ))
  exp_eq(and3s(!logi_dem, , ),
         band3(!logi_dem, , ))
  exp_eq(and3s(!logi_den, , l >= 0L),
         band3(!logi_den, , l >= 0L))
  exp_eq(and3s(!logi_deo, , v >= 1L),
         band3(!logi_deo, , v >= 1L))
  exp_eq(and3s(!logi_dep, , w >= 9L),
         band3(!logi_dep, , w >= 9L))
  exp_eq(and3s(!logi_deq, t >= 0L, ),
         band3(!logi_deq, t >= 0L, ))
  exp_eq(and3s(!logi_der, a >= 1L, ),
         band3(!logi_der, a >= 1L, ))
  exp_eq(and3s(!logi_des, n >= 9L, ),
         band3(!logi_des, n >= 9L, ))
  exp_eq(and3s(!logi_det, b >= 0L, y >= 0L),
         band3(!logi_det, b >= 0L, y >= 0L))
  exp_eq(and3s(!logi_deu, r >= 1L, q >= 1L),
         band3(!logi_deu, r >= 1L, q >= 1L))
  exp_eq(and3s(!logi_dev, q >= 9L, z >= 9L),
         band3(!logi_dev, q >= 9L, z >= 9L))
  exp_eq(and3s(dew != 0L, , ),
         band3(dew != 0L, , ))
  exp_eq(and3s(dex != 1L, , ),
         band3(dex != 1L, , ))
  exp_eq(and3s(dey != 9L, , ),
         band3(dey != 9L, , ))
  exp_eq(and3s(dez != 0L, , logi_j),
         band3(dez != 0L, , logi_j))
  exp_eq(and3s(dfa != 1L, , logi_v),
         band3(dfa != 1L, , logi_v))
  exp_eq(and3s(dfb != 9L, , logi_c),
         band3(dfb != 9L, , logi_c))
  exp_eq(and3s(dfc != 0L, logi_t, ),
         band3(dfc != 0L, logi_t, ))
  exp_eq(and3s(dfd != 1L, logi_w, ),
         band3(dfd != 1L, logi_w, ))
  exp_eq(and3s(dfe != 9L, logi_k, ),
         band3(dfe != 9L, logi_k, ))
  exp_eq(and3s(dff != 0L, logi_b, logi_u),
         band3(dff != 0L, logi_b, logi_u))
  exp_eq(and3s(dfg != 1L, logi_y, logi_o),
         band3(dfg != 1L, logi_y, logi_o))
  exp_eq(and3s(dfh != 9L, logi_h, logi_h),
         band3(dfh != 9L, logi_h, logi_h))
  exp_eq(and3s(dfi != 0L, , ),
         band3(dfi != 0L, , ))
  exp_eq(and3s(dfj != 1L, , ),
         band3(dfj != 1L, , ))
  exp_eq(and3s(dfk != 9L, , ),
         band3(dfk != 9L, , ))
  exp_eq(and3s(dfl != 0L, , !logi_n),
         band3(dfl != 0L, , !logi_n))
  exp_eq(and3s(dfm != 1L, , !logi_n),
         band3(dfm != 1L, , !logi_n))
  exp_eq(and3s(dfn != 9L, , !logi_d),
         band3(dfn != 9L, , !logi_d))
  exp_eq(and3s(dfo != 0L, logi_i, ),
         band3(dfo != 0L, logi_i, ))
  exp_eq(and3s(dfp != 1L, logi_o, ),
         band3(dfp != 1L, logi_o, ))
  exp_eq(and3s(dfq != 9L, logi_b, ),
         band3(dfq != 9L, logi_b, ))
  exp_eq(and3s(dfr != 0L, logi_w, !logi_t),
         band3(dfr != 0L, logi_w, !logi_t))
  exp_eq(and3s(dfs != 1L, logi_l, !logi_w),
         band3(dfs != 1L, logi_l, !logi_w))
  exp_eq(and3s(dft != 9L, logi_r, !logi_y),
         band3(dft != 9L, logi_r, !logi_y))
  exp_eq(and3s(dfu != 0L, , ),
         band3(dfu != 0L, , ))
  exp_eq(and3s(dfv != 1L, , ),
         band3(dfv != 1L, , ))
  exp_eq(and3s(dfw != 9L, , ),
         band3(dfw != 9L, , ))
  exp_eq(and3s(dfx != 0L, , i != 0L),
         band3(dfx != 0L, , i != 0L))
  exp_eq(and3s(dfy != 1L, , g != 1L),
         band3(dfy != 1L, , g != 1L))
  exp_eq(and3s(dfz != 9L, , q != 9L),
         band3(dfz != 9L, , q != 9L))
  exp_eq(and3s(dga != 0L, logi_e, ),
         band3(dga != 0L, logi_e, ))
  exp_eq(and3s(dgb != 1L, logi_c, ),
         band3(dgb != 1L, logi_c, ))
  exp_eq(and3s(dgc != 9L, logi_w, ),
         band3(dgc != 9L, logi_w, ))
  exp_eq(and3s(dgd != 0L, logi_f, m != 0L),
         band3(dgd != 0L, logi_f, m != 0L))
  exp_eq(and3s(dge != 1L, logi_p, h != 1L),
         band3(dge != 1L, logi_p, h != 1L))
  exp_eq(and3s(dgf != 9L, logi_l, c != 9L),
         band3(dgf != 9L, logi_l, c != 9L))
  exp_eq(and3s(dgg != 0L, , ),
         band3(dgg != 0L, , ))
  exp_eq(and3s(dgh != 1L, , ),
         band3(dgh != 1L, , ))
  exp_eq(and3s(dgi != 9L, , ),
         band3(dgi != 9L, , ))
  exp_eq(and3s(dgj != 0L, , b %between% c(-1L, 1L)),
         band3(dgj != 0L, , b %between% c(-1L, 1L)))
  exp_eq(and3s(dgk != 1L, , y %between% c(-1L, 1L)),
         band3(dgk != 1L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(dgl != 9L, , l %between% c(-1L, 1L)),
         band3(dgl != 9L, , l %between% c(-1L, 1L)))
  exp_eq(and3s(dgm != 0L, logi_n, ),
         band3(dgm != 0L, logi_n, ))
  exp_eq(and3s(dgn != 1L, logi_g, ),
         band3(dgn != 1L, logi_g, ))
  exp_eq(and3s(dgo != 9L, logi_p, ),
         band3(dgo != 9L, logi_p, ))
  exp_eq(and3s(dgp != 0L, logi_w, p %between% c(-1L, 1L)),
         band3(dgp != 0L, logi_w, p %between% c(-1L, 1L)))
  exp_eq(and3s(dgq != 1L, logi_v, r %between% c(-1L, 1L)),
         band3(dgq != 1L, logi_v, r %between% c(-1L, 1L)))
  exp_eq(and3s(dgr != 9L, logi_z, g %between% c(-1L, 1L)),
         band3(dgr != 9L, logi_z, g %between% c(-1L, 1L)))
  exp_eq(and3s(dgs != 0L, , ),
         band3(dgs != 0L, , ))
  exp_eq(and3s(dgt != 1L, , ),
         band3(dgt != 1L, , ))
  exp_eq(and3s(dgu != 9L, , ),
         band3(dgu != 9L, , ))
  exp_eq(and3s(dgv != 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dgv != 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dgw != 1L, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dgw != 1L, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dgx != 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dgx != 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dgy != 0L, logi_y, ),
         band3(dgy != 0L, logi_y, ))
  exp_eq(and3s(dgz != 1L, logi_w, ),
         band3(dgz != 1L, logi_w, ))
  exp_eq(and3s(dha != 9L, logi_s, ),
         band3(dha != 9L, logi_s, ))
  exp_eq(and3s(dhb != 0L, logi_i, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dhb != 0L, logi_i, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dhc != 1L, logi_y, i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dhc != 1L, logi_y, i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dhd != 9L, logi_o, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dhd != 9L, logi_o, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dhe != 0L, , ),
         band3(dhe != 0L, , ))
  exp_eq(and3s(dhf != 1L, , ),
         band3(dhf != 1L, , ))
  exp_eq(and3s(dhg != 9L, , ),
         band3(dhg != 9L, , ))
  exp_eq(and3s(dhh != 0L, , i %in% 1:4),
         band3(dhh != 0L, , i %in% 1:4))
  exp_eq(and3s(dhi != 1L, , t %in% 1:4),
         band3(dhi != 1L, , t %in% 1:4))
  exp_eq(and3s(dhj != 9L, , g %in% 1:4),
         band3(dhj != 9L, , g %in% 1:4))
  exp_eq(and3s(dhk != 0L, logi_q, ),
         band3(dhk != 0L, logi_q, ))
  exp_eq(and3s(dhl != 1L, logi_q, ),
         band3(dhl != 1L, logi_q, ))
  exp_eq(and3s(dhm != 9L, logi_o, ),
         band3(dhm != 9L, logi_o, ))
  exp_eq(and3s(dhn != 0L, logi_d, g %in% 1:4),
         band3(dhn != 0L, logi_d, g %in% 1:4))
  exp_eq(and3s(dho != 1L, logi_a, a %in% 1:4),
         band3(dho != 1L, logi_a, a %in% 1:4))
  exp_eq(and3s(dhp != 9L, logi_j, d %in% 1:4),
         band3(dhp != 9L, logi_j, d %in% 1:4))
  exp_eq(and3s(dhq != 0L, , ),
         band3(dhq != 0L, , ))
  exp_eq(and3s(dhr != 1L, , ),
         band3(dhr != 1L, , ))
  exp_eq(and3s(dhs != 9L, , ),
         band3(dhs != 9L, , ))
  exp_eq(and3s(dht != 0L, , s < 0L),
         band3(dht != 0L, , s < 0L))
  exp_eq(and3s(dhu != 1L, , z < 1L),
         band3(dhu != 1L, , z < 1L))
  exp_eq(and3s(dhv != 9L, , t < 9L),
         band3(dhv != 9L, , t < 9L))
  exp_eq(and3s(dhw != 0L, logi_p, ),
         band3(dhw != 0L, logi_p, ))
  exp_eq(and3s(dhx != 1L, logi_d, ),
         band3(dhx != 1L, logi_d, ))
  exp_eq(and3s(dhy != 9L, logi_e, ),
         band3(dhy != 9L, logi_e, ))
  exp_eq(and3s(dhz != 0L, logi_f, j < 0L),
         band3(dhz != 0L, logi_f, j < 0L))
  exp_eq(and3s(dia != 1L, logi_a, n < 1L),
         band3(dia != 1L, logi_a, n < 1L))
  exp_eq(and3s(dib != 9L, logi_h, e < 9L),
         band3(dib != 9L, logi_h, e < 9L))
  exp_eq(and3s(dic != 0L, , ),
         band3(dic != 0L, , ))
  exp_eq(and3s(did != 1L, , ),
         band3(did != 1L, , ))
  exp_eq(and3s(die != 9L, , ),
         band3(die != 9L, , ))
  exp_eq(and3s(dif != 0L, , f <= 0L),
         band3(dif != 0L, , f <= 0L))
  exp_eq(and3s(dig != 1L, , z <= 1L),
         band3(dig != 1L, , z <= 1L))
  exp_eq(and3s(dih != 9L, , x <= 9L),
         band3(dih != 9L, , x <= 9L))
  exp_eq(and3s(dii != 0L, logi_r, ),
         band3(dii != 0L, logi_r, ))
  exp_eq(and3s(dij != 1L, logi_k, ),
         band3(dij != 1L, logi_k, ))
  exp_eq(and3s(dik != 9L, logi_b, ),
         band3(dik != 9L, logi_b, ))
  exp_eq(and3s(dil != 0L, logi_a, g <= 0L),
         band3(dil != 0L, logi_a, g <= 0L))
  exp_eq(and3s(dim != 1L, logi_l, w <= 1L),
         band3(dim != 1L, logi_l, w <= 1L))
  exp_eq(and3s(din != 9L, logi_z, x <= 9L),
         band3(din != 9L, logi_z, x <= 9L))
  exp_eq(and3s(dio != 0L, , ),
         band3(dio != 0L, , ))
  exp_eq(and3s(dip != 1L, , ),
         band3(dip != 1L, , ))
  exp_eq(and3s(diq != 9L, , ),
         band3(diq != 9L, , ))
  exp_eq(and3s(dir != 0L, , j == 0L),
         band3(dir != 0L, , j == 0L))
  exp_eq(and3s(dis != 1L, , k == 1L),
         band3(dis != 1L, , k == 1L))
  exp_eq(and3s(dit != 9L, , i == 9L),
         band3(dit != 9L, , i == 9L))
  exp_eq(and3s(diu != 0L, logi_l, ),
         band3(diu != 0L, logi_l, ))
  exp_eq(and3s(div != 1L, logi_u, ),
         band3(div != 1L, logi_u, ))
  exp_eq(and3s(diw != 9L, logi_q, ),
         band3(diw != 9L, logi_q, ))
  exp_eq(and3s(dix != 0L, logi_m, o == 0L),
         band3(dix != 0L, logi_m, o == 0L))
  exp_eq(and3s(diy != 1L, logi_u, t == 1L),
         band3(diy != 1L, logi_u, t == 1L))
  exp_eq(and3s(diz != 9L, logi_v, z == 9L),
         band3(diz != 9L, logi_v, z == 9L))
  exp_eq(and3s(dja != 0L, , ),
         band3(dja != 0L, , ))
  exp_eq(and3s(djb != 1L, , ),
         band3(djb != 1L, , ))
  exp_eq(and3s(djc != 9L, , ),
         band3(djc != 9L, , ))
  exp_eq(and3s(djd != 0L, , g > 0L),
         band3(djd != 0L, , g > 0L))
  exp_eq(and3s(dje != 1L, , y > 1L),
         band3(dje != 1L, , y > 1L))
  exp_eq(and3s(djf != 9L, , z > 9L),
         band3(djf != 9L, , z > 9L))
  exp_eq(and3s(djg != 0L, logi_c, ),
         band3(djg != 0L, logi_c, ))
  exp_eq(and3s(djh != 1L, logi_w, ),
         band3(djh != 1L, logi_w, ))
  exp_eq(and3s(dji != 9L, logi_e, ),
         band3(dji != 9L, logi_e, ))
  exp_eq(and3s(djj != 0L, logi_u, o > 0L),
         band3(djj != 0L, logi_u, o > 0L))
  exp_eq(and3s(djk != 1L, logi_z, q > 1L),
         band3(djk != 1L, logi_z, q > 1L))
  exp_eq(and3s(djl != 9L, logi_v, t > 9L),
         band3(djl != 9L, logi_v, t > 9L))
  exp_eq(and3s(djm != 0L, , ),
         band3(djm != 0L, , ))
  exp_eq(and3s(djn != 1L, , ),
         band3(djn != 1L, , ))
  exp_eq(and3s(djo != 9L, , ),
         band3(djo != 9L, , ))
  exp_eq(and3s(djp != 0L, , d >= 0L),
         band3(djp != 0L, , d >= 0L))
  exp_eq(and3s(djq != 1L, , g >= 1L),
         band3(djq != 1L, , g >= 1L))
  exp_eq(and3s(djr != 9L, , x >= 9L),
         band3(djr != 9L, , x >= 9L))
  exp_eq(and3s(djs != 0L, logi_i, ),
         band3(djs != 0L, logi_i, ))
  exp_eq(and3s(djt != 1L, logi_u, ),
         band3(djt != 1L, logi_u, ))
  exp_eq(and3s(dju != 9L, logi_h, ),
         band3(dju != 9L, logi_h, ))
  exp_eq(and3s(djv != 0L, logi_h, d >= 0L),
         band3(djv != 0L, logi_h, d >= 0L))
  exp_eq(and3s(djw != 1L, logi_f, d >= 1L),
         band3(djw != 1L, logi_f, d >= 1L))
  exp_eq(and3s(djx != 9L, logi_t, s >= 9L),
         band3(djx != 9L, logi_t, s >= 9L))
  exp_eq(and3s(djy != 0L, , ),
         band3(djy != 0L, , ))
  exp_eq(and3s(djz != 1L, , ),
         band3(djz != 1L, , ))
  exp_eq(and3s(dka != 9L, , ),
         band3(dka != 9L, , ))
  exp_eq(and3s(dkb != 0L, , logi_z),
         band3(dkb != 0L, , logi_z))
  exp_eq(and3s(dkc != 1L, , logi_e),
         band3(dkc != 1L, , logi_e))
  exp_eq(and3s(dkd != 9L, , logi_p),
         band3(dkd != 9L, , logi_p))
  exp_eq(and3s(dke != 0L, !logi_k, ),
         band3(dke != 0L, !logi_k, ))
  exp_eq(and3s(dkf != 1L, !logi_o, ),
         band3(dkf != 1L, !logi_o, ))
  exp_eq(and3s(dkg != 9L, !logi_b, ),
         band3(dkg != 9L, !logi_b, ))
  exp_eq(and3s(dkh != 0L, !logi_z, logi_s),
         band3(dkh != 0L, !logi_z, logi_s))
  exp_eq(and3s(dki != 1L, !logi_q, logi_i),
         band3(dki != 1L, !logi_q, logi_i))
  exp_eq(and3s(dkj != 9L, !logi_e, logi_b),
         band3(dkj != 9L, !logi_e, logi_b))
  exp_eq(and3s(dkk != 0L, , ),
         band3(dkk != 0L, , ))
  exp_eq(and3s(dkl != 1L, , ),
         band3(dkl != 1L, , ))
  exp_eq(and3s(dkm != 9L, , ),
         band3(dkm != 9L, , ))
  exp_eq(and3s(dkn != 0L, , !logi_c),
         band3(dkn != 0L, , !logi_c))
  exp_eq(and3s(dko != 1L, , !logi_j),
         band3(dko != 1L, , !logi_j))
  exp_eq(and3s(dkp != 9L, , !logi_j),
         band3(dkp != 9L, , !logi_j))
  exp_eq(and3s(dkq != 0L, !logi_i, ),
         band3(dkq != 0L, !logi_i, ))
  exp_eq(and3s(dkr != 1L, !logi_p, ),
         band3(dkr != 1L, !logi_p, ))
  exp_eq(and3s(dks != 9L, !logi_n, ),
         band3(dks != 9L, !logi_n, ))
  exp_eq(and3s(dkt != 0L, !logi_g, !logi_u),
         band3(dkt != 0L, !logi_g, !logi_u))
  exp_eq(and3s(dku != 1L, !logi_j, !logi_m),
         band3(dku != 1L, !logi_j, !logi_m))
  exp_eq(and3s(dkv != 9L, !logi_d, !logi_n),
         band3(dkv != 9L, !logi_d, !logi_n))
  exp_eq(and3s(dkw != 0L, , ),
         band3(dkw != 0L, , ))
  exp_eq(and3s(dkx != 1L, , ),
         band3(dkx != 1L, , ))
  exp_eq(and3s(dky != 9L, , ),
         band3(dky != 9L, , ))
  exp_eq(and3s(dkz != 0L, , z != 0L),
         band3(dkz != 0L, , z != 0L))
  exp_eq(and3s(dla != 1L, , k != 1L),
         band3(dla != 1L, , k != 1L))
  exp_eq(and3s(dlb != 9L, , t != 9L),
         band3(dlb != 9L, , t != 9L))
  exp_eq(and3s(dlc != 0L, !logi_e, ),
         band3(dlc != 0L, !logi_e, ))
  exp_eq(and3s(dld != 1L, !logi_n, ),
         band3(dld != 1L, !logi_n, ))
  exp_eq(and3s(dle != 9L, !logi_u, ),
         band3(dle != 9L, !logi_u, ))
  exp_eq(and3s(dlf != 0L, !logi_t, o != 0L),
         band3(dlf != 0L, !logi_t, o != 0L))
  exp_eq(and3s(dlg != 1L, !logi_s, i != 1L),
         band3(dlg != 1L, !logi_s, i != 1L))
  exp_eq(and3s(dlh != 9L, !logi_w, a != 9L),
         band3(dlh != 9L, !logi_w, a != 9L))
  exp_eq(and3s(dli != 0L, , ),
         band3(dli != 0L, , ))
  exp_eq(and3s(dlj != 1L, , ),
         band3(dlj != 1L, , ))
  exp_eq(and3s(dlk != 9L, , ),
         band3(dlk != 9L, , ))
  exp_eq(and3s(dll != 0L, , s %between% c(-1L, 1L)),
         band3(dll != 0L, , s %between% c(-1L, 1L)))
  exp_eq(and3s(dlm != 1L, , x %between% c(-1L, 1L)),
         band3(dlm != 1L, , x %between% c(-1L, 1L)))
  exp_eq(and3s(dln != 9L, , x %between% c(-1L, 1L)),
         band3(dln != 9L, , x %between% c(-1L, 1L)))
  exp_eq(and3s(dlo != 0L, !logi_p, ),
         band3(dlo != 0L, !logi_p, ))
  exp_eq(and3s(dlp != 1L, !logi_t, ),
         band3(dlp != 1L, !logi_t, ))
  exp_eq(and3s(dlq != 9L, !logi_u, ),
         band3(dlq != 9L, !logi_u, ))
  exp_eq(and3s(dlr != 0L, !logi_x, b %between% c(-1L, 1L)),
         band3(dlr != 0L, !logi_x, b %between% c(-1L, 1L)))
  exp_eq(and3s(dls != 1L, !logi_m, m %between% c(-1L, 1L)),
         band3(dls != 1L, !logi_m, m %between% c(-1L, 1L)))
  exp_eq(and3s(dlt != 9L, !logi_m, r %between% c(-1L, 1L)),
         band3(dlt != 9L, !logi_m, r %between% c(-1L, 1L)))
  exp_eq(and3s(dlu != 0L, , ),
         band3(dlu != 0L, , ))
  exp_eq(and3s(dlv != 1L, , ),
         band3(dlv != 1L, , ))
  exp_eq(and3s(dlw != 9L, , ),
         band3(dlw != 9L, , ))
  exp_eq(and3s(dlx != 0L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dlx != 0L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dly != 1L, , y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dly != 1L, , y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dlz != 9L, , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dlz != 9L, , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dma != 0L, !logi_v, ),
         band3(dma != 0L, !logi_v, ))
  exp_eq(and3s(dmb != 1L, !logi_k, ),
         band3(dmb != 1L, !logi_k, ))
  exp_eq(and3s(dmc != 9L, !logi_h, ),
         band3(dmc != 9L, !logi_h, ))
  exp_eq(and3s(dmd != 0L, !logi_w, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dmd != 0L, !logi_w, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dme != 1L, !logi_g, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dme != 1L, !logi_g, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dmf != 9L, !logi_q, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dmf != 9L, !logi_q, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dmg != 0L, , ),
         band3(dmg != 0L, , ))
  exp_eq(and3s(dmh != 1L, , ),
         band3(dmh != 1L, , ))
  exp_eq(and3s(dmi != 9L, , ),
         band3(dmi != 9L, , ))
  exp_eq(and3s(dmj != 0L, , a %in% 1:4),
         band3(dmj != 0L, , a %in% 1:4))
  exp_eq(and3s(dmk != 1L, , t %in% 1:4),
         band3(dmk != 1L, , t %in% 1:4))
  exp_eq(and3s(dml != 9L, , p %in% 1:4),
         band3(dml != 9L, , p %in% 1:4))
  exp_eq(and3s(dmm != 0L, !logi_a, ),
         band3(dmm != 0L, !logi_a, ))
  exp_eq(and3s(dmn != 1L, !logi_v, ),
         band3(dmn != 1L, !logi_v, ))
  exp_eq(and3s(dmo != 9L, !logi_m, ),
         band3(dmo != 9L, !logi_m, ))
  exp_eq(and3s(dmp != 0L, !logi_y, o %in% 1:4),
         band3(dmp != 0L, !logi_y, o %in% 1:4))
  exp_eq(and3s(dmq != 1L, !logi_x, d %in% 1:4),
         band3(dmq != 1L, !logi_x, d %in% 1:4))
  exp_eq(and3s(dmr != 9L, !logi_s, o %in% 1:4),
         band3(dmr != 9L, !logi_s, o %in% 1:4))
  exp_eq(and3s(dms != 0L, , ),
         band3(dms != 0L, , ))
  exp_eq(and3s(dmt != 1L, , ),
         band3(dmt != 1L, , ))
  exp_eq(and3s(dmu != 9L, , ),
         band3(dmu != 9L, , ))
  exp_eq(and3s(dmv != 0L, , q < 0L),
         band3(dmv != 0L, , q < 0L))
  exp_eq(and3s(dmw != 1L, , f < 1L),
         band3(dmw != 1L, , f < 1L))
  exp_eq(and3s(dmx != 9L, , i < 9L),
         band3(dmx != 9L, , i < 9L))
  exp_eq(and3s(dmy != 0L, !logi_g, ),
         band3(dmy != 0L, !logi_g, ))
  exp_eq(and3s(dmz != 1L, !logi_k, ),
         band3(dmz != 1L, !logi_k, ))
  exp_eq(and3s(dna != 9L, !logi_k, ),
         band3(dna != 9L, !logi_k, ))
  exp_eq(and3s(dnb != 0L, !logi_p, a < 0L),
         band3(dnb != 0L, !logi_p, a < 0L))
  exp_eq(and3s(dnc != 1L, !logi_z, g < 1L),
         band3(dnc != 1L, !logi_z, g < 1L))
  exp_eq(and3s(dnd != 9L, !logi_d, s < 9L),
         band3(dnd != 9L, !logi_d, s < 9L))
  exp_eq(and3s(dne != 0L, , ),
         band3(dne != 0L, , ))
  exp_eq(and3s(dnf != 1L, , ),
         band3(dnf != 1L, , ))
  exp_eq(and3s(dng != 9L, , ),
         band3(dng != 9L, , ))
  exp_eq(and3s(dnh != 0L, , f <= 0L),
         band3(dnh != 0L, , f <= 0L))
  exp_eq(and3s(dni != 1L, , w <= 1L),
         band3(dni != 1L, , w <= 1L))
  exp_eq(and3s(dnj != 9L, , w <= 9L),
         band3(dnj != 9L, , w <= 9L))
  exp_eq(and3s(dnk != 0L, !logi_c, ),
         band3(dnk != 0L, !logi_c, ))
  exp_eq(and3s(dnl != 1L, !logi_h, ),
         band3(dnl != 1L, !logi_h, ))
  exp_eq(and3s(dnm != 9L, !logi_k, ),
         band3(dnm != 9L, !logi_k, ))
  exp_eq(and3s(dnn != 0L, !logi_e, x <= 0L),
         band3(dnn != 0L, !logi_e, x <= 0L))
  exp_eq(and3s(dno != 1L, !logi_o, x <= 1L),
         band3(dno != 1L, !logi_o, x <= 1L))
  exp_eq(and3s(dnp != 9L, !logi_g, s <= 9L),
         band3(dnp != 9L, !logi_g, s <= 9L))
  exp_eq(and3s(dnq != 0L, , ),
         band3(dnq != 0L, , ))
  exp_eq(and3s(dnr != 1L, , ),
         band3(dnr != 1L, , ))
  exp_eq(and3s(dns != 9L, , ),
         band3(dns != 9L, , ))
  exp_eq(and3s(dnt != 0L, , b == 0L),
         band3(dnt != 0L, , b == 0L))
  exp_eq(and3s(dnu != 1L, , b == 1L),
         band3(dnu != 1L, , b == 1L))
  exp_eq(and3s(dnv != 9L, , n == 9L),
         band3(dnv != 9L, , n == 9L))
  exp_eq(and3s(dnw != 0L, !logi_v, ),
         band3(dnw != 0L, !logi_v, ))
  exp_eq(and3s(dnx != 1L, !logi_t, ),
         band3(dnx != 1L, !logi_t, ))
  exp_eq(and3s(dny != 9L, !logi_b, ),
         band3(dny != 9L, !logi_b, ))
  exp_eq(and3s(dnz != 0L, !logi_x, c == 0L),
         band3(dnz != 0L, !logi_x, c == 0L))
  exp_eq(and3s(doa != 1L, !logi_d, q == 1L),
         band3(doa != 1L, !logi_d, q == 1L))
  exp_eq(and3s(dob != 9L, !logi_k, l == 9L),
         band3(dob != 9L, !logi_k, l == 9L))
  exp_eq(and3s(doc != 0L, , ),
         band3(doc != 0L, , ))
  exp_eq(and3s(dod != 1L, , ),
         band3(dod != 1L, , ))
  exp_eq(and3s(doe != 9L, , ),
         band3(doe != 9L, , ))
  exp_eq(and3s(dof != 0L, , w > 0L),
         band3(dof != 0L, , w > 0L))
  exp_eq(and3s(dog != 1L, , a > 1L),
         band3(dog != 1L, , a > 1L))
  exp_eq(and3s(doh != 9L, , p > 9L),
         band3(doh != 9L, , p > 9L))
  exp_eq(and3s(doi != 0L, !logi_v, ),
         band3(doi != 0L, !logi_v, ))
  exp_eq(and3s(doj != 1L, !logi_j, ),
         band3(doj != 1L, !logi_j, ))
  exp_eq(and3s(dok != 9L, !logi_b, ),
         band3(dok != 9L, !logi_b, ))
  exp_eq(and3s(dol != 0L, !logi_k, s > 0L),
         band3(dol != 0L, !logi_k, s > 0L))
  exp_eq(and3s(dom != 1L, !logi_p, h > 1L),
         band3(dom != 1L, !logi_p, h > 1L))
  exp_eq(and3s(don != 9L, !logi_n, q > 9L),
         band3(don != 9L, !logi_n, q > 9L))
  exp_eq(and3s(doo != 0L, , ),
         band3(doo != 0L, , ))
  exp_eq(and3s(dop != 1L, , ),
         band3(dop != 1L, , ))
  exp_eq(and3s(doq != 9L, , ),
         band3(doq != 9L, , ))
  exp_eq(and3s(dor != 0L, , g >= 0L),
         band3(dor != 0L, , g >= 0L))
  exp_eq(and3s(dos != 1L, , l >= 1L),
         band3(dos != 1L, , l >= 1L))
  exp_eq(and3s(dot != 9L, , f >= 9L),
         band3(dot != 9L, , f >= 9L))
  exp_eq(and3s(dou != 0L, !logi_t, ),
         band3(dou != 0L, !logi_t, ))
  exp_eq(and3s(dov != 1L, !logi_b, ),
         band3(dov != 1L, !logi_b, ))
  exp_eq(and3s(dow != 9L, !logi_g, ),
         band3(dow != 9L, !logi_g, ))
  exp_eq(and3s(dox != 0L, !logi_i, r >= 0L),
         band3(dox != 0L, !logi_i, r >= 0L))
  exp_eq(and3s(doy != 1L, !logi_o, h >= 1L),
         band3(doy != 1L, !logi_o, h >= 1L))
  exp_eq(and3s(doz != 9L, !logi_m, t >= 9L),
         band3(doz != 9L, !logi_m, t >= 9L))
  exp_eq(and3s(dpa != 0L, , ),
         band3(dpa != 0L, , ))
  exp_eq(and3s(dpb != 1L, , ),
         band3(dpb != 1L, , ))
  exp_eq(and3s(dpc != 9L, , ),
         band3(dpc != 9L, , ))
  exp_eq(and3s(dpd != 0L, , logi_p),
         band3(dpd != 0L, , logi_p))
  exp_eq(and3s(dpe != 1L, , logi_f),
         band3(dpe != 1L, , logi_f))
  exp_eq(and3s(dpf != 9L, , logi_k),
         band3(dpf != 9L, , logi_k))
  exp_eq(and3s(dpg != 0L, i != 0L, ),
         band3(dpg != 0L, i != 0L, ))
  exp_eq(and3s(dph != 1L, d != 1L, ),
         band3(dph != 1L, d != 1L, ))
  exp_eq(and3s(dpi != 9L, q != 9L, ),
         band3(dpi != 9L, q != 9L, ))
  exp_eq(and3s(dpj != 0L, u != 0L, logi_z),
         band3(dpj != 0L, u != 0L, logi_z))
  exp_eq(and3s(dpk != 1L, k != 1L, logi_a),
         band3(dpk != 1L, k != 1L, logi_a))
  exp_eq(and3s(dpl != 9L, t != 9L, logi_c),
         band3(dpl != 9L, t != 9L, logi_c))
  exp_eq(and3s(dpm != 0L, , ),
         band3(dpm != 0L, , ))
  exp_eq(and3s(dpn != 1L, , ),
         band3(dpn != 1L, , ))
  exp_eq(and3s(dpo != 9L, , ),
         band3(dpo != 9L, , ))
  exp_eq(and3s(dpp != 0L, , !logi_r),
         band3(dpp != 0L, , !logi_r))
  exp_eq(and3s(dpq != 1L, , !logi_d),
         band3(dpq != 1L, , !logi_d))
  exp_eq(and3s(dpr != 9L, , !logi_p),
         band3(dpr != 9L, , !logi_p))
  exp_eq(and3s(dps != 0L, n != 0L, ),
         band3(dps != 0L, n != 0L, ))
  exp_eq(and3s(dpt != 1L, f != 1L, ),
         band3(dpt != 1L, f != 1L, ))
  exp_eq(and3s(dpu != 9L, r != 9L, ),
         band3(dpu != 9L, r != 9L, ))
  exp_eq(and3s(dpv != 0L, y != 0L, !logi_v),
         band3(dpv != 0L, y != 0L, !logi_v))
  exp_eq(and3s(dpw != 1L, b != 1L, !logi_w),
         band3(dpw != 1L, b != 1L, !logi_w))
  exp_eq(and3s(dpx != 9L, u != 9L, !logi_r),
         band3(dpx != 9L, u != 9L, !logi_r))
  exp_eq(and3s(dpy != 0L, , ),
         band3(dpy != 0L, , ))
  exp_eq(and3s(dpz != 1L, , ),
         band3(dpz != 1L, , ))
  exp_eq(and3s(dqa != 9L, , ),
         band3(dqa != 9L, , ))
  exp_eq(and3s(dqb != 0L, , t != 0L),
         band3(dqb != 0L, , t != 0L))
  exp_eq(and3s(dqc != 1L, , w != 1L),
         band3(dqc != 1L, , w != 1L))
  exp_eq(and3s(dqd != 9L, , g != 9L),
         band3(dqd != 9L, , g != 9L))
  exp_eq(and3s(dqe != 0L, o != 0L, ),
         band3(dqe != 0L, o != 0L, ))
  exp_eq(and3s(dqf != 1L, s != 1L, ),
         band3(dqf != 1L, s != 1L, ))
  exp_eq(and3s(dqg != 9L, i != 9L, ),
         band3(dqg != 9L, i != 9L, ))
  exp_eq(and3s(dqh != 0L, k != 0L, u != 0L),
         band3(dqh != 0L, k != 0L, u != 0L))
  exp_eq(and3s(dqi != 1L, u != 1L, m != 1L),
         band3(dqi != 1L, u != 1L, m != 1L))
  exp_eq(and3s(dqj != 9L, w != 9L, q != 9L),
         band3(dqj != 9L, w != 9L, q != 9L))
  exp_eq(and3s(dqk != 0L, , ),
         band3(dqk != 0L, , ))
  exp_eq(and3s(dql != 1L, , ),
         band3(dql != 1L, , ))
  exp_eq(and3s(dqm != 9L, , ),
         band3(dqm != 9L, , ))
  exp_eq(and3s(dqn != 0L, , c %between% c(-1L, 1L)),
         band3(dqn != 0L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(dqo != 1L, , b %between% c(-1L, 1L)),
         band3(dqo != 1L, , b %between% c(-1L, 1L)))
  exp_eq(and3s(dqp != 9L, , y %between% c(-1L, 1L)),
         band3(dqp != 9L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(dqq != 0L, i != 0L, ),
         band3(dqq != 0L, i != 0L, ))
  exp_eq(and3s(dqr != 1L, w != 1L, ),
         band3(dqr != 1L, w != 1L, ))
  exp_eq(and3s(dqs != 9L, e != 9L, ),
         band3(dqs != 9L, e != 9L, ))
  exp_eq(and3s(dqt != 0L, b != 0L, r %between% c(-1L, 1L)),
         band3(dqt != 0L, b != 0L, r %between% c(-1L, 1L)))
  exp_eq(and3s(dqu != 1L, s != 1L, v %between% c(-1L, 1L)),
         band3(dqu != 1L, s != 1L, v %between% c(-1L, 1L)))
  exp_eq(and3s(dqv != 9L, o != 9L, h %between% c(-1L, 1L)),
         band3(dqv != 9L, o != 9L, h %between% c(-1L, 1L)))
  exp_eq(and3s(dqw != 0L, , ),
         band3(dqw != 0L, , ))
  exp_eq(and3s(dqx != 1L, , ),
         band3(dqx != 1L, , ))
  exp_eq(and3s(dqy != 9L, , ),
         band3(dqy != 9L, , ))
  exp_eq(and3s(dqz != 0L, , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dqz != 0L, , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dra != 1L, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dra != 1L, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(drb != 9L, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(drb != 9L, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(drc != 0L, e != 0L, ),
         band3(drc != 0L, e != 0L, ))
  exp_eq(and3s(drd != 1L, e != 1L, ),
         band3(drd != 1L, e != 1L, ))
  exp_eq(and3s(dre != 9L, y != 9L, ),
         band3(dre != 9L, y != 9L, ))
  exp_eq(and3s(drf != 0L, l != 0L, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(drf != 0L, l != 0L, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(drg != 1L, a != 1L, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(drg != 1L, a != 1L, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(drh != 9L, w != 9L, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(drh != 9L, w != 9L, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dri != 0L, , ),
         band3(dri != 0L, , ))
  exp_eq(and3s(drj != 1L, , ),
         band3(drj != 1L, , ))
  exp_eq(and3s(drk != 9L, , ),
         band3(drk != 9L, , ))
  exp_eq(and3s(drl != 0L, , a %in% 1:4),
         band3(drl != 0L, , a %in% 1:4))
  exp_eq(and3s(drm != 1L, , n %in% 1:4),
         band3(drm != 1L, , n %in% 1:4))
  exp_eq(and3s(drn != 9L, , i %in% 1:4),
         band3(drn != 9L, , i %in% 1:4))
  exp_eq(and3s(dro != 0L, k != 0L, ),
         band3(dro != 0L, k != 0L, ))
  exp_eq(and3s(drp != 1L, z != 1L, ),
         band3(drp != 1L, z != 1L, ))
  exp_eq(and3s(drq != 9L, o != 9L, ),
         band3(drq != 9L, o != 9L, ))
  exp_eq(and3s(drr != 0L, f != 0L, a %in% 1:4),
         band3(drr != 0L, f != 0L, a %in% 1:4))
  exp_eq(and3s(drs != 1L, y != 1L, h %in% 1:4),
         band3(drs != 1L, y != 1L, h %in% 1:4))
  exp_eq(and3s(drt != 9L, n != 9L, o %in% 1:4),
         band3(drt != 9L, n != 9L, o %in% 1:4))
  exp_eq(and3s(dru != 0L, , ),
         band3(dru != 0L, , ))
  exp_eq(and3s(drv != 1L, , ),
         band3(drv != 1L, , ))
  exp_eq(and3s(drw != 9L, , ),
         band3(drw != 9L, , ))
  exp_eq(and3s(drx != 0L, , b < 0L),
         band3(drx != 0L, , b < 0L))
  exp_eq(and3s(dry != 1L, , t < 1L),
         band3(dry != 1L, , t < 1L))
  exp_eq(and3s(drz != 9L, , i < 9L),
         band3(drz != 9L, , i < 9L))
  exp_eq(and3s(dsa != 0L, j != 0L, ),
         band3(dsa != 0L, j != 0L, ))
  exp_eq(and3s(dsb != 1L, k != 1L, ),
         band3(dsb != 1L, k != 1L, ))
  exp_eq(and3s(dsc != 9L, t != 9L, ),
         band3(dsc != 9L, t != 9L, ))
  exp_eq(and3s(dsd != 0L, y != 0L, q < 0L),
         band3(dsd != 0L, y != 0L, q < 0L))
  exp_eq(and3s(dse != 1L, u != 1L, z < 1L),
         band3(dse != 1L, u != 1L, z < 1L))
  exp_eq(and3s(dsf != 9L, i != 9L, n < 9L),
         band3(dsf != 9L, i != 9L, n < 9L))
  exp_eq(and3s(dsg != 0L, , ),
         band3(dsg != 0L, , ))
  exp_eq(and3s(dsh != 1L, , ),
         band3(dsh != 1L, , ))
  exp_eq(and3s(dsi != 9L, , ),
         band3(dsi != 9L, , ))
  exp_eq(and3s(dsj != 0L, , g <= 0L),
         band3(dsj != 0L, , g <= 0L))
  exp_eq(and3s(dsk != 1L, , h <= 1L),
         band3(dsk != 1L, , h <= 1L))
  exp_eq(and3s(dsl != 9L, , u <= 9L),
         band3(dsl != 9L, , u <= 9L))
  exp_eq(and3s(dsm != 0L, h != 0L, ),
         band3(dsm != 0L, h != 0L, ))
  exp_eq(and3s(dsn != 1L, d != 1L, ),
         band3(dsn != 1L, d != 1L, ))
  exp_eq(and3s(dso != 9L, t != 9L, ),
         band3(dso != 9L, t != 9L, ))
  exp_eq(and3s(dsp != 0L, s != 0L, h <= 0L),
         band3(dsp != 0L, s != 0L, h <= 0L))
  exp_eq(and3s(dsq != 1L, d != 1L, i <= 1L),
         band3(dsq != 1L, d != 1L, i <= 1L))
  exp_eq(and3s(dsr != 9L, s != 9L, q <= 9L),
         band3(dsr != 9L, s != 9L, q <= 9L))
  exp_eq(and3s(dss != 0L, , ),
         band3(dss != 0L, , ))
  exp_eq(and3s(dst != 1L, , ),
         band3(dst != 1L, , ))
  exp_eq(and3s(dsu != 9L, , ),
         band3(dsu != 9L, , ))
  exp_eq(and3s(dsv != 0L, , x == 0L),
         band3(dsv != 0L, , x == 0L))
  exp_eq(and3s(dsw != 1L, , i == 1L),
         band3(dsw != 1L, , i == 1L))
  exp_eq(and3s(dsx != 9L, , n == 9L),
         band3(dsx != 9L, , n == 9L))
  exp_eq(and3s(dsy != 0L, z != 0L, ),
         band3(dsy != 0L, z != 0L, ))
  exp_eq(and3s(dsz != 1L, q != 1L, ),
         band3(dsz != 1L, q != 1L, ))
  exp_eq(and3s(dta != 9L, h != 9L, ),
         band3(dta != 9L, h != 9L, ))
  exp_eq(and3s(dtb != 0L, s != 0L, g == 0L),
         band3(dtb != 0L, s != 0L, g == 0L))
  exp_eq(and3s(dtc != 1L, f != 1L, s == 1L),
         band3(dtc != 1L, f != 1L, s == 1L))
  exp_eq(and3s(dtd != 9L, m != 9L, v == 9L),
         band3(dtd != 9L, m != 9L, v == 9L))
  exp_eq(and3s(dte != 0L, , ),
         band3(dte != 0L, , ))
  exp_eq(and3s(dtf != 1L, , ),
         band3(dtf != 1L, , ))
  exp_eq(and3s(dtg != 9L, , ),
         band3(dtg != 9L, , ))
  exp_eq(and3s(dth != 0L, , s > 0L),
         band3(dth != 0L, , s > 0L))
  exp_eq(and3s(dti != 1L, , u > 1L),
         band3(dti != 1L, , u > 1L))
  exp_eq(and3s(dtj != 9L, , k > 9L),
         band3(dtj != 9L, , k > 9L))
  exp_eq(and3s(dtk != 0L, d != 0L, ),
         band3(dtk != 0L, d != 0L, ))
  exp_eq(and3s(dtl != 1L, t != 1L, ),
         band3(dtl != 1L, t != 1L, ))
  exp_eq(and3s(dtm != 9L, j != 9L, ),
         band3(dtm != 9L, j != 9L, ))
  exp_eq(and3s(dtn != 0L, k != 0L, c > 0L),
         band3(dtn != 0L, k != 0L, c > 0L))
  exp_eq(and3s(dto != 1L, j != 1L, l > 1L),
         band3(dto != 1L, j != 1L, l > 1L))
  exp_eq(and3s(dtp != 9L, y != 9L, w > 9L),
         band3(dtp != 9L, y != 9L, w > 9L))
  exp_eq(and3s(dtq != 0L, , ),
         band3(dtq != 0L, , ))
  exp_eq(and3s(dtr != 1L, , ),
         band3(dtr != 1L, , ))
  exp_eq(and3s(dts != 9L, , ),
         band3(dts != 9L, , ))
  exp_eq(and3s(dtt != 0L, , v >= 0L),
         band3(dtt != 0L, , v >= 0L))
  exp_eq(and3s(dtu != 1L, , t >= 1L),
         band3(dtu != 1L, , t >= 1L))
  exp_eq(and3s(dtv != 9L, , i >= 9L),
         band3(dtv != 9L, , i >= 9L))
  exp_eq(and3s(dtw != 0L, n != 0L, ),
         band3(dtw != 0L, n != 0L, ))
  exp_eq(and3s(dtx != 1L, n != 1L, ),
         band3(dtx != 1L, n != 1L, ))
  exp_eq(and3s(dty != 9L, q != 9L, ),
         band3(dty != 9L, q != 9L, ))
  exp_eq(and3s(dtz != 0L, r != 0L, a >= 0L),
         band3(dtz != 0L, r != 0L, a >= 0L))
  exp_eq(and3s(dua != 1L, q != 1L, y >= 1L),
         band3(dua != 1L, q != 1L, y >= 1L))
  exp_eq(and3s(dub != 9L, p != 9L, n >= 9L),
         band3(dub != 9L, p != 9L, n >= 9L))
  exp_eq(and3s(duc != 0L, , ),
         band3(duc != 0L, , ))
  exp_eq(and3s(dud != 1L, , ),
         band3(dud != 1L, , ))
  exp_eq(and3s(due != 9L, , ),
         band3(due != 9L, , ))
  exp_eq(and3s(duf != 0L, , logi_s),
         band3(duf != 0L, , logi_s))
  exp_eq(and3s(dug != 1L, , logi_q),
         band3(dug != 1L, , logi_q))
  exp_eq(and3s(duh != 9L, , logi_c),
         band3(duh != 9L, , logi_c))
  exp_eq(and3s(dui != 0L, t %between% c(-1L, 1L), ),
         band3(dui != 0L, t %between% c(-1L, 1L), ))
  exp_eq(and3s(duj != 1L, e %between% c(-1L, 1L), ),
         band3(duj != 1L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(duk != 9L, i %between% c(-1L, 1L), ),
         band3(duk != 9L, i %between% c(-1L, 1L), ))
  exp_eq(and3s(dul != 0L, u %between% c(-1L, 1L), logi_g),
         band3(dul != 0L, u %between% c(-1L, 1L), logi_g))
  exp_eq(and3s(dum != 1L, l %between% c(-1L, 1L), logi_v),
         band3(dum != 1L, l %between% c(-1L, 1L), logi_v))
  exp_eq(and3s(dun != 9L, t %between% c(-1L, 1L), logi_x),
         band3(dun != 9L, t %between% c(-1L, 1L), logi_x))
  exp_eq(and3s(duo != 0L, , ),
         band3(duo != 0L, , ))
  exp_eq(and3s(dup != 1L, , ),
         band3(dup != 1L, , ))
  exp_eq(and3s(duq != 9L, , ),
         band3(duq != 9L, , ))
  exp_eq(and3s(dur != 0L, , !logi_o),
         band3(dur != 0L, , !logi_o))
  exp_eq(and3s(dus != 1L, , !logi_r),
         band3(dus != 1L, , !logi_r))
  exp_eq(and3s(dut != 9L, , !logi_e),
         band3(dut != 9L, , !logi_e))
  exp_eq(and3s(duu != 0L, d %between% c(-1L, 1L), ),
         band3(duu != 0L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(duv != 1L, e %between% c(-1L, 1L), ),
         band3(duv != 1L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(duw != 9L, e %between% c(-1L, 1L), ),
         band3(duw != 9L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(dux != 0L, s %between% c(-1L, 1L), !logi_c),
         band3(dux != 0L, s %between% c(-1L, 1L), !logi_c))
  exp_eq(and3s(duy != 1L, z %between% c(-1L, 1L), !logi_m),
         band3(duy != 1L, z %between% c(-1L, 1L), !logi_m))
  exp_eq(and3s(duz != 9L, z %between% c(-1L, 1L), !logi_k),
         band3(duz != 9L, z %between% c(-1L, 1L), !logi_k))
  exp_eq(and3s(dva != 0L, , ),
         band3(dva != 0L, , ))
  exp_eq(and3s(dvb != 1L, , ),
         band3(dvb != 1L, , ))
  exp_eq(and3s(dvc != 9L, , ),
         band3(dvc != 9L, , ))
  exp_eq(and3s(dvd != 0L, , b != 0L),
         band3(dvd != 0L, , b != 0L))
  exp_eq(and3s(dve != 1L, , e != 1L),
         band3(dve != 1L, , e != 1L))
  exp_eq(and3s(dvf != 9L, , v != 9L),
         band3(dvf != 9L, , v != 9L))
  exp_eq(and3s(dvg != 0L, w %between% c(-1L, 1L), ),
         band3(dvg != 0L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(dvh != 1L, z %between% c(-1L, 1L), ),
         band3(dvh != 1L, z %between% c(-1L, 1L), ))
  exp_eq(and3s(dvi != 9L, i %between% c(-1L, 1L), ),
         band3(dvi != 9L, i %between% c(-1L, 1L), ))
  exp_eq(and3s(dvj != 0L, z %between% c(-1L, 1L), e != 0L),
         band3(dvj != 0L, z %between% c(-1L, 1L), e != 0L))
  exp_eq(and3s(dvk != 1L, f %between% c(-1L, 1L), b != 1L),
         band3(dvk != 1L, f %between% c(-1L, 1L), b != 1L))
  exp_eq(and3s(dvl != 9L, j %between% c(-1L, 1L), o != 9L),
         band3(dvl != 9L, j %between% c(-1L, 1L), o != 9L))
  exp_eq(and3s(dvm != 0L, , ),
         band3(dvm != 0L, , ))
  exp_eq(and3s(dvn != 1L, , ),
         band3(dvn != 1L, , ))
  exp_eq(and3s(dvo != 9L, , ),
         band3(dvo != 9L, , ))
  exp_eq(and3s(dvp != 0L, , c %between% c(-1L, 1L)),
         band3(dvp != 0L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(dvq != 1L, , p %between% c(-1L, 1L)),
         band3(dvq != 1L, , p %between% c(-1L, 1L)))
  exp_eq(and3s(dvr != 9L, , x %between% c(-1L, 1L)),
         band3(dvr != 9L, , x %between% c(-1L, 1L)))
  exp_eq(and3s(dvs != 0L, t %between% c(-1L, 1L), ),
         band3(dvs != 0L, t %between% c(-1L, 1L), ))
  exp_eq(and3s(dvt != 1L, d %between% c(-1L, 1L), ),
         band3(dvt != 1L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(dvu != 9L, w %between% c(-1L, 1L), ),
         band3(dvu != 9L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(dvv != 0L, s %between% c(-1L, 1L), g %between% c(-1L, 1L)),
         band3(dvv != 0L, s %between% c(-1L, 1L), g %between% c(-1L, 1L)))
  exp_eq(and3s(dvw != 1L, k %between% c(-1L, 1L), q %between% c(-1L, 1L)),
         band3(dvw != 1L, k %between% c(-1L, 1L), q %between% c(-1L, 1L)))
  exp_eq(and3s(dvx != 9L, w %between% c(-1L, 1L), x %between% c(-1L, 1L)),
         band3(dvx != 9L, w %between% c(-1L, 1L), x %between% c(-1L, 1L)))
  exp_eq(and3s(dvy != 0L, , ),
         band3(dvy != 0L, , ))
  exp_eq(and3s(dvz != 1L, , ),
         band3(dvz != 1L, , ))
  exp_eq(and3s(dwa != 9L, , ),
         band3(dwa != 9L, , ))
  exp_eq(and3s(dwb != 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwb != 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwc != 1L, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwc != 1L, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwd != 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwd != 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwe != 0L, x %between% c(-1L, 1L), ),
         band3(dwe != 0L, x %between% c(-1L, 1L), ))
  exp_eq(and3s(dwf != 1L, d %between% c(-1L, 1L), ),
         band3(dwf != 1L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(dwg != 9L, v %between% c(-1L, 1L), ),
         band3(dwg != 9L, v %between% c(-1L, 1L), ))
  exp_eq(and3s(dwh != 0L, w %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwh != 0L, w %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwi != 1L, n %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwi != 1L, n %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwj != 9L, p %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(dwj != 9L, p %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(dwk != 0L, , ),
         band3(dwk != 0L, , ))
  exp_eq(and3s(dwl != 1L, , ),
         band3(dwl != 1L, , ))
  exp_eq(and3s(dwm != 9L, , ),
         band3(dwm != 9L, , ))
  exp_eq(and3s(dwn != 0L, , x %in% 1:4),
         band3(dwn != 0L, , x %in% 1:4))
  exp_eq(and3s(dwo != 1L, , m %in% 1:4),
         band3(dwo != 1L, , m %in% 1:4))
  exp_eq(and3s(dwp != 9L, , b %in% 1:4),
         band3(dwp != 9L, , b %in% 1:4))
  exp_eq(and3s(dwq != 0L, o %between% c(-1L, 1L), ),
         band3(dwq != 0L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(dwr != 1L, r %between% c(-1L, 1L), ),
         band3(dwr != 1L, r %between% c(-1L, 1L), ))
  exp_eq(and3s(dws != 9L, w %between% c(-1L, 1L), ),
         band3(dws != 9L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(dwt != 0L, y %between% c(-1L, 1L), e %in% 1:4),
         band3(dwt != 0L, y %between% c(-1L, 1L), e %in% 1:4))
  exp_eq(and3s(dwu != 1L, x %between% c(-1L, 1L), s %in% 1:4),
         band3(dwu != 1L, x %between% c(-1L, 1L), s %in% 1:4))
  exp_eq(and3s(dwv != 9L, c %between% c(-1L, 1L), z %in% 1:4),
         band3(dwv != 9L, c %between% c(-1L, 1L), z %in% 1:4))
  exp_eq(and3s(dww != 0L, , ),
         band3(dww != 0L, , ))
  exp_eq(and3s(dwx != 1L, , ),
         band3(dwx != 1L, , ))
  exp_eq(and3s(dwy != 9L, , ),
         band3(dwy != 9L, , ))
  exp_eq(and3s(dwz != 0L, , m < 0L),
         band3(dwz != 0L, , m < 0L))
  exp_eq(and3s(dxa != 1L, , y < 1L),
         band3(dxa != 1L, , y < 1L))
  exp_eq(and3s(dxb != 9L, , o < 9L),
         band3(dxb != 9L, , o < 9L))
  exp_eq(and3s(dxc != 0L, c %between% c(-1L, 1L), ),
         band3(dxc != 0L, c %between% c(-1L, 1L), ))
  exp_eq(and3s(dxd != 1L, o %between% c(-1L, 1L), ),
         band3(dxd != 1L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(dxe != 9L, b %between% c(-1L, 1L), ),
         band3(dxe != 9L, b %between% c(-1L, 1L), ))
  exp_eq(and3s(dxf != 0L, b %between% c(-1L, 1L), d < 0L),
         band3(dxf != 0L, b %between% c(-1L, 1L), d < 0L))
  exp_eq(and3s(dxg != 1L, n %between% c(-1L, 1L), g < 1L),
         band3(dxg != 1L, n %between% c(-1L, 1L), g < 1L))
  exp_eq(and3s(dxh != 9L, c %between% c(-1L, 1L), p < 9L),
         band3(dxh != 9L, c %between% c(-1L, 1L), p < 9L))
  exp_eq(and3s(dxi != 0L, , ),
         band3(dxi != 0L, , ))
  exp_eq(and3s(dxj != 1L, , ),
         band3(dxj != 1L, , ))
  exp_eq(and3s(dxk != 9L, , ),
         band3(dxk != 9L, , ))
  exp_eq(and3s(dxl != 0L, , i <= 0L),
         band3(dxl != 0L, , i <= 0L))
  exp_eq(and3s(dxm != 1L, , c <= 1L),
         band3(dxm != 1L, , c <= 1L))
  exp_eq(and3s(dxn != 9L, , z <= 9L),
         band3(dxn != 9L, , z <= 9L))
  exp_eq(and3s(dxo != 0L, j %between% c(-1L, 1L), ),
         band3(dxo != 0L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(dxp != 1L, f %between% c(-1L, 1L), ),
         band3(dxp != 1L, f %between% c(-1L, 1L), ))
  exp_eq(and3s(dxq != 9L, n %between% c(-1L, 1L), ),
         band3(dxq != 9L, n %between% c(-1L, 1L), ))
  exp_eq(and3s(dxr != 0L, q %between% c(-1L, 1L), n <= 0L),
         band3(dxr != 0L, q %between% c(-1L, 1L), n <= 0L))
  exp_eq(and3s(dxs != 1L, k %between% c(-1L, 1L), u <= 1L),
         band3(dxs != 1L, k %between% c(-1L, 1L), u <= 1L))
  exp_eq(and3s(dxt != 9L, c %between% c(-1L, 1L), m <= 9L),
         band3(dxt != 9L, c %between% c(-1L, 1L), m <= 9L))
  exp_eq(and3s(dxu != 0L, , ),
         band3(dxu != 0L, , ))
  exp_eq(and3s(dxv != 1L, , ),
         band3(dxv != 1L, , ))
  exp_eq(and3s(dxw != 9L, , ),
         band3(dxw != 9L, , ))
  exp_eq(and3s(dxx != 0L, , m == 0L),
         band3(dxx != 0L, , m == 0L))
  exp_eq(and3s(dxy != 1L, , r == 1L),
         band3(dxy != 1L, , r == 1L))
  exp_eq(and3s(dxz != 9L, , y == 9L),
         band3(dxz != 9L, , y == 9L))
  exp_eq(and3s(dya != 0L, r %between% c(-1L, 1L), ),
         band3(dya != 0L, r %between% c(-1L, 1L), ))
  exp_eq(and3s(dyb != 1L, p %between% c(-1L, 1L), ),
         band3(dyb != 1L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(dyc != 9L, j %between% c(-1L, 1L), ),
         band3(dyc != 9L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(dyd != 0L, d %between% c(-1L, 1L), x == 0L),
         band3(dyd != 0L, d %between% c(-1L, 1L), x == 0L))
  exp_eq(and3s(dye != 1L, x %between% c(-1L, 1L), c == 1L),
         band3(dye != 1L, x %between% c(-1L, 1L), c == 1L))
  exp_eq(and3s(dyf != 9L, r %between% c(-1L, 1L), d == 9L),
         band3(dyf != 9L, r %between% c(-1L, 1L), d == 9L))
  exp_eq(and3s(dyg != 0L, , ),
         band3(dyg != 0L, , ))
  exp_eq(and3s(dyh != 1L, , ),
         band3(dyh != 1L, , ))
  exp_eq(and3s(dyi != 9L, , ),
         band3(dyi != 9L, , ))
  exp_eq(and3s(dyj != 0L, , l > 0L),
         band3(dyj != 0L, , l > 0L))
  exp_eq(and3s(dyk != 1L, , t > 1L),
         band3(dyk != 1L, , t > 1L))
  exp_eq(and3s(dyl != 9L, , q > 9L),
         band3(dyl != 9L, , q > 9L))
  exp_eq(and3s(dym != 0L, e %between% c(-1L, 1L), ),
         band3(dym != 0L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(dyn != 1L, s %between% c(-1L, 1L), ),
         band3(dyn != 1L, s %between% c(-1L, 1L), ))
  exp_eq(and3s(dyo != 9L, a %between% c(-1L, 1L), ),
         band3(dyo != 9L, a %between% c(-1L, 1L), ))
  exp_eq(and3s(dyp != 0L, v %between% c(-1L, 1L), f > 0L),
         band3(dyp != 0L, v %between% c(-1L, 1L), f > 0L))
  exp_eq(and3s(dyq != 1L, h %between% c(-1L, 1L), q > 1L),
         band3(dyq != 1L, h %between% c(-1L, 1L), q > 1L))
  exp_eq(and3s(dyr != 9L, o %between% c(-1L, 1L), i > 9L),
         band3(dyr != 9L, o %between% c(-1L, 1L), i > 9L))
  exp_eq(and3s(dys != 0L, , ),
         band3(dys != 0L, , ))
  exp_eq(and3s(dyt != 1L, , ),
         band3(dyt != 1L, , ))
  exp_eq(and3s(dyu != 9L, , ),
         band3(dyu != 9L, , ))
  exp_eq(and3s(dyv != 0L, , x >= 0L),
         band3(dyv != 0L, , x >= 0L))
  exp_eq(and3s(dyw != 1L, , x >= 1L),
         band3(dyw != 1L, , x >= 1L))
  exp_eq(and3s(dyx != 9L, , u >= 9L),
         band3(dyx != 9L, , u >= 9L))
  exp_eq(and3s(dyy != 0L, x %between% c(-1L, 1L), ),
         band3(dyy != 0L, x %between% c(-1L, 1L), ))
  exp_eq(and3s(dyz != 1L, k %between% c(-1L, 1L), ),
         band3(dyz != 1L, k %between% c(-1L, 1L), ))
  exp_eq(and3s(ea != 9L, o %between% c(-1L, 1L), ),
         band3(ea != 9L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(eb != 0L, l %between% c(-1L, 1L), b >= 0L),
         band3(eb != 0L, l %between% c(-1L, 1L), b >= 0L))
  exp_eq(and3s(ec != 1L, w %between% c(-1L, 1L), f >= 1L),
         band3(ec != 1L, w %between% c(-1L, 1L), f >= 1L))
  exp_eq(and3s(ed != 9L, q %between% c(-1L, 1L), v >= 9L),
         band3(ed != 9L, q %between% c(-1L, 1L), v >= 9L))
  exp_eq(and3s(ee != 0L, , ),
         band3(ee != 0L, , ))
  exp_eq(and3s(ef != 1L, , ),
         band3(ef != 1L, , ))
  exp_eq(and3s(eg != 9L, , ),
         band3(eg != 9L, , ))
  exp_eq(and3s(eh != 0L, , logi_z),
         band3(eh != 0L, , logi_z))
  exp_eq(and3s(ei != 1L, , logi_v),
         band3(ei != 1L, , logi_v))
  exp_eq(and3s(ej != 9L, , logi_m),
         band3(ej != 9L, , logi_m))
  exp_eq(and3s(ek != 0L, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ek != 0L, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(el != 1L, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(el != 1L, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(em != 9L, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(em != 9L, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(en != 0L, p %in% c(4L, -3L, 2L, 7L, 8L), logi_l),
         band3(en != 0L, p %in% c(4L, -3L, 2L, 7L, 8L), logi_l))
  exp_eq(and3s(eo != 1L, q %in% c(4L, -3L, 2L, 7L, 8L), logi_m),
         band3(eo != 1L, q %in% c(4L, -3L, 2L, 7L, 8L), logi_m))
  exp_eq(and3s(ep != 9L, m %in% c(4L, -3L, 2L, 7L, 8L), logi_f),
         band3(ep != 9L, m %in% c(4L, -3L, 2L, 7L, 8L), logi_f))
  exp_eq(and3s(eq != 0L, , ),
         band3(eq != 0L, , ))
  exp_eq(and3s(er != 1L, , ),
         band3(er != 1L, , ))
  exp_eq(and3s(es != 9L, , ),
         band3(es != 9L, , ))
  exp_eq(and3s(et != 0L, , logi_t),
         band3(et != 0L, , logi_t))
  exp_eq(and3s(eu != 1L, , logi_c),
         band3(eu != 1L, , logi_c))
  exp_eq(and3s(ev != 9L, , logi_l),
         band3(ev != 9L, , logi_l))
  exp_eq(and3s(ew != 0L, e %in% 1:4, ),
         band3(ew != 0L, e %in% 1:4, ))
  exp_eq(and3s(ex != 1L, h %in% 1:4, ),
         band3(ex != 1L, h %in% 1:4, ))
  exp_eq(and3s(ey != 9L, l %in% 1:4, ),
         band3(ey != 9L, l %in% 1:4, ))
  exp_eq(and3s(ez != 0L, m %in% 1:4, logi_f),
         band3(ez != 0L, m %in% 1:4, logi_f))
  exp_eq(and3s(eaa != 1L, g %in% 1:4, logi_q),
         band3(eaa != 1L, g %in% 1:4, logi_q))
  exp_eq(and3s(eab != 9L, l %in% 1:4, logi_u),
         band3(eab != 9L, l %in% 1:4, logi_u))
  exp_eq(and3s(eac != 0L, , ),
         band3(eac != 0L, , ))
  exp_eq(and3s(ead != 1L, , ),
         band3(ead != 1L, , ))
  exp_eq(and3s(eae != 9L, , ),
         band3(eae != 9L, , ))
  exp_eq(and3s(eaf != 0L, , !logi_y),
         band3(eaf != 0L, , !logi_y))
  exp_eq(and3s(eag != 1L, , !logi_q),
         band3(eag != 1L, , !logi_q))
  exp_eq(and3s(eah != 9L, , !logi_a),
         band3(eah != 9L, , !logi_a))
  exp_eq(and3s(eai != 0L, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eai != 0L, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eaj != 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eaj != 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eak != 9L, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eak != 9L, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eal != 0L, j %in% c(4L, -3L, 2L, 7L, 8L), !logi_u),
         band3(eal != 0L, j %in% c(4L, -3L, 2L, 7L, 8L), !logi_u))
  exp_eq(and3s(eam != 1L, t %in% c(4L, -3L, 2L, 7L, 8L), !logi_m),
         band3(eam != 1L, t %in% c(4L, -3L, 2L, 7L, 8L), !logi_m))
  exp_eq(and3s(ean != 9L, t %in% c(4L, -3L, 2L, 7L, 8L), !logi_r),
         band3(ean != 9L, t %in% c(4L, -3L, 2L, 7L, 8L), !logi_r))
  exp_eq(and3s(eao != 0L, , ),
         band3(eao != 0L, , ))
  exp_eq(and3s(eap != 1L, , ),
         band3(eap != 1L, , ))
  exp_eq(and3s(eaq != 9L, , ),
         band3(eaq != 9L, , ))
  exp_eq(and3s(ear != 0L, , !logi_e),
         band3(ear != 0L, , !logi_e))
  exp_eq(and3s(eas != 1L, , !logi_a),
         band3(eas != 1L, , !logi_a))
  exp_eq(and3s(eat != 9L, , !logi_l),
         band3(eat != 9L, , !logi_l))
  exp_eq(and3s(eau != 0L, m %in% 1:4, ),
         band3(eau != 0L, m %in% 1:4, ))
  exp_eq(and3s(eav != 1L, w %in% 1:4, ),
         band3(eav != 1L, w %in% 1:4, ))
  exp_eq(and3s(eaw != 9L, k %in% 1:4, ),
         band3(eaw != 9L, k %in% 1:4, ))
  exp_eq(and3s(eax != 0L, n %in% 1:4, !logi_n),
         band3(eax != 0L, n %in% 1:4, !logi_n))
  exp_eq(and3s(eay != 1L, j %in% 1:4, !logi_w),
         band3(eay != 1L, j %in% 1:4, !logi_w))
  exp_eq(and3s(eaz != 9L, b %in% 1:4, !logi_l),
         band3(eaz != 9L, b %in% 1:4, !logi_l))
  exp_eq(and3s(eba != 0L, , ),
         band3(eba != 0L, , ))
  exp_eq(and3s(ebb != 1L, , ),
         band3(ebb != 1L, , ))
  exp_eq(and3s(ebc != 9L, , ),
         band3(ebc != 9L, , ))
  exp_eq(and3s(ebd != 0L, , b != 0L),
         band3(ebd != 0L, , b != 0L))
  exp_eq(and3s(ebe != 1L, , o != 1L),
         band3(ebe != 1L, , o != 1L))
  exp_eq(and3s(ebf != 9L, , s != 9L),
         band3(ebf != 9L, , s != 9L))
  exp_eq(and3s(ebg != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ebg != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ebh != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ebh != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ebi != 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ebi != 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ebj != 0L, x %in% c(4L, -3L, 2L, 7L, 8L), t != 0L),
         band3(ebj != 0L, x %in% c(4L, -3L, 2L, 7L, 8L), t != 0L))
  exp_eq(and3s(ebk != 1L, j %in% c(4L, -3L, 2L, 7L, 8L), a != 1L),
         band3(ebk != 1L, j %in% c(4L, -3L, 2L, 7L, 8L), a != 1L))
  exp_eq(and3s(ebl != 9L, r %in% c(4L, -3L, 2L, 7L, 8L), g != 9L),
         band3(ebl != 9L, r %in% c(4L, -3L, 2L, 7L, 8L), g != 9L))
  exp_eq(and3s(ebm != 0L, , ),
         band3(ebm != 0L, , ))
  exp_eq(and3s(ebn != 1L, , ),
         band3(ebn != 1L, , ))
  exp_eq(and3s(ebo != 9L, , ),
         band3(ebo != 9L, , ))
  exp_eq(and3s(ebp != 0L, , k != 0L),
         band3(ebp != 0L, , k != 0L))
  exp_eq(and3s(ebq != 1L, , g != 1L),
         band3(ebq != 1L, , g != 1L))
  exp_eq(and3s(ebr != 9L, , o != 9L),
         band3(ebr != 9L, , o != 9L))
  exp_eq(and3s(ebs != 0L, z %in% 1:4, ),
         band3(ebs != 0L, z %in% 1:4, ))
  exp_eq(and3s(ebt != 1L, x %in% 1:4, ),
         band3(ebt != 1L, x %in% 1:4, ))
  exp_eq(and3s(ebu != 9L, i %in% 1:4, ),
         band3(ebu != 9L, i %in% 1:4, ))
  exp_eq(and3s(ebv != 0L, g %in% 1:4, a != 0L),
         band3(ebv != 0L, g %in% 1:4, a != 0L))
  exp_eq(and3s(ebw != 1L, d %in% 1:4, o != 1L),
         band3(ebw != 1L, d %in% 1:4, o != 1L))
  exp_eq(and3s(ebx != 9L, c %in% 1:4, r != 9L),
         band3(ebx != 9L, c %in% 1:4, r != 9L))
  exp_eq(and3s(eby != 0L, , ),
         band3(eby != 0L, , ))
  exp_eq(and3s(ebz != 1L, , ),
         band3(ebz != 1L, , ))
  exp_eq(and3s(eca != 9L, , ),
         band3(eca != 9L, , ))
  exp_eq(and3s(ecb != 0L, , k %between% c(-1L, 1L)),
         band3(ecb != 0L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(ecc != 1L, , r %between% c(-1L, 1L)),
         band3(ecc != 1L, , r %between% c(-1L, 1L)))
  exp_eq(and3s(ecd != 9L, , a %between% c(-1L, 1L)),
         band3(ecd != 9L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(ece != 0L, f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ece != 0L, f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ecf != 1L, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ecf != 1L, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ecg != 9L, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ecg != 9L, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ech != 0L, d %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L)),
         band3(ech != 0L, d %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L)))
  exp_eq(and3s(eci != 1L, y %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)),
         band3(eci != 1L, y %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)))
  exp_eq(and3s(ecj != 9L, a %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L)),
         band3(ecj != 9L, a %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L)))
  exp_eq(and3s(eck != 0L, , ),
         band3(eck != 0L, , ))
  exp_eq(and3s(ecl != 1L, , ),
         band3(ecl != 1L, , ))
  exp_eq(and3s(ecm != 9L, , ),
         band3(ecm != 9L, , ))
  exp_eq(and3s(ecn != 0L, , p %between% c(-1L, 1L)),
         band3(ecn != 0L, , p %between% c(-1L, 1L)))
  exp_eq(and3s(eco != 1L, , p %between% c(-1L, 1L)),
         band3(eco != 1L, , p %between% c(-1L, 1L)))
  exp_eq(and3s(ecp != 9L, , k %between% c(-1L, 1L)),
         band3(ecp != 9L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(ecq != 0L, k %in% 1:4, ),
         band3(ecq != 0L, k %in% 1:4, ))
  exp_eq(and3s(ecr != 1L, s %in% 1:4, ),
         band3(ecr != 1L, s %in% 1:4, ))
  exp_eq(and3s(ecs != 9L, q %in% 1:4, ),
         band3(ecs != 9L, q %in% 1:4, ))
  exp_eq(and3s(ect != 0L, g %in% 1:4, w %between% c(-1L, 1L)),
         band3(ect != 0L, g %in% 1:4, w %between% c(-1L, 1L)))
  exp_eq(and3s(ecu != 1L, k %in% 1:4, c %between% c(-1L, 1L)),
         band3(ecu != 1L, k %in% 1:4, c %between% c(-1L, 1L)))
  exp_eq(and3s(ecv != 9L, i %in% 1:4, a %between% c(-1L, 1L)),
         band3(ecv != 9L, i %in% 1:4, a %between% c(-1L, 1L)))
  exp_eq(and3s(ecw != 0L, , ),
         band3(ecw != 0L, , ))
  exp_eq(and3s(ecx != 1L, , ),
         band3(ecx != 1L, , ))
  exp_eq(and3s(ecy != 9L, , ),
         band3(ecy != 9L, , ))
  exp_eq(and3s(ecz != 0L, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ecz != 0L, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(eda != 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(eda != 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(edb != 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(edb != 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(edc != 0L, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(edc != 0L, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(edd != 1L, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(edd != 1L, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ede != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ede != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(edf != 0L, k %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(edf != 0L, k %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(edg != 1L, r %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(edg != 1L, r %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(edh != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(edh != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(edi != 0L, , ),
         band3(edi != 0L, , ))
  exp_eq(and3s(edj != 1L, , ),
         band3(edj != 1L, , ))
  exp_eq(and3s(edk != 9L, , ),
         band3(edk != 9L, , ))
  exp_eq(and3s(edl != 0L, , u %in% 1:4),
         band3(edl != 0L, , u %in% 1:4))
  exp_eq(and3s(edm != 1L, , v %in% 1:4),
         band3(edm != 1L, , v %in% 1:4))
  exp_eq(and3s(edn != 9L, , h %in% 1:4),
         band3(edn != 9L, , h %in% 1:4))
  exp_eq(and3s(edo != 0L, f %in% 1:4, ),
         band3(edo != 0L, f %in% 1:4, ))
  exp_eq(and3s(edp != 1L, h %in% 1:4, ),
         band3(edp != 1L, h %in% 1:4, ))
  exp_eq(and3s(edq != 9L, h %in% 1:4, ),
         band3(edq != 9L, h %in% 1:4, ))
  exp_eq(and3s(edr != 0L, y %in% 1:4, i %in% 1:4),
         band3(edr != 0L, y %in% 1:4, i %in% 1:4))
  exp_eq(and3s(eds != 1L, d %in% 1:4, s %in% 1:4),
         band3(eds != 1L, d %in% 1:4, s %in% 1:4))
  exp_eq(and3s(edt != 9L, q %in% 1:4, i %in% 1:4),
         band3(edt != 9L, q %in% 1:4, i %in% 1:4))
  exp_eq(and3s(edu != 0L, , ),
         band3(edu != 0L, , ))
  exp_eq(and3s(edv != 1L, , ),
         band3(edv != 1L, , ))
  exp_eq(and3s(edw != 9L, , ),
         band3(edw != 9L, , ))
  exp_eq(and3s(edx != 0L, , v < 0L),
         band3(edx != 0L, , v < 0L))
  exp_eq(and3s(edy != 1L, , w < 1L),
         band3(edy != 1L, , w < 1L))
  exp_eq(and3s(edz != 9L, , q < 9L),
         band3(edz != 9L, , q < 9L))
  exp_eq(and3s(eea != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eea != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eeb != 1L, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eeb != 1L, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eec != 9L, f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eec != 9L, f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eed != 0L, c %in% c(4L, -3L, 2L, 7L, 8L), d < 0L),
         band3(eed != 0L, c %in% c(4L, -3L, 2L, 7L, 8L), d < 0L))
  exp_eq(and3s(eee != 1L, p %in% c(4L, -3L, 2L, 7L, 8L), y < 1L),
         band3(eee != 1L, p %in% c(4L, -3L, 2L, 7L, 8L), y < 1L))
  exp_eq(and3s(eef != 9L, n %in% c(4L, -3L, 2L, 7L, 8L), a < 9L),
         band3(eef != 9L, n %in% c(4L, -3L, 2L, 7L, 8L), a < 9L))
  exp_eq(and3s(eeg != 0L, , ),
         band3(eeg != 0L, , ))
  exp_eq(and3s(eeh != 1L, , ),
         band3(eeh != 1L, , ))
  exp_eq(and3s(eei != 9L, , ),
         band3(eei != 9L, , ))
  exp_eq(and3s(eej != 0L, , w < 0L),
         band3(eej != 0L, , w < 0L))
  exp_eq(and3s(eek != 1L, , c < 1L),
         band3(eek != 1L, , c < 1L))
  exp_eq(and3s(eel != 9L, , k < 9L),
         band3(eel != 9L, , k < 9L))
  exp_eq(and3s(eem != 0L, w %in% 1:4, ),
         band3(eem != 0L, w %in% 1:4, ))
  exp_eq(and3s(een != 1L, g %in% 1:4, ),
         band3(een != 1L, g %in% 1:4, ))
  exp_eq(and3s(eeo != 9L, v %in% 1:4, ),
         band3(eeo != 9L, v %in% 1:4, ))
  exp_eq(and3s(eep != 0L, c %in% 1:4, o < 0L),
         band3(eep != 0L, c %in% 1:4, o < 0L))
  exp_eq(and3s(eeq != 1L, u %in% 1:4, m < 1L),
         band3(eeq != 1L, u %in% 1:4, m < 1L))
  exp_eq(and3s(eer != 9L, l %in% 1:4, p < 9L),
         band3(eer != 9L, l %in% 1:4, p < 9L))
  exp_eq(and3s(ees != 0L, , ),
         band3(ees != 0L, , ))
  exp_eq(and3s(eet != 1L, , ),
         band3(eet != 1L, , ))
  exp_eq(and3s(eeu != 9L, , ),
         band3(eeu != 9L, , ))
  exp_eq(and3s(eev != 0L, , w <= 0L),
         band3(eev != 0L, , w <= 0L))
  exp_eq(and3s(eew != 1L, , w <= 1L),
         band3(eew != 1L, , w <= 1L))
  exp_eq(and3s(eex != 9L, , m <= 9L),
         band3(eex != 9L, , m <= 9L))
  exp_eq(and3s(eey != 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eey != 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eez != 1L, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eez != 1L, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(efa != 9L, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(efa != 9L, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(efb != 0L, r %in% c(4L, -3L, 2L, 7L, 8L), m <= 0L),
         band3(efb != 0L, r %in% c(4L, -3L, 2L, 7L, 8L), m <= 0L))
  exp_eq(and3s(efc != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), a <= 1L),
         band3(efc != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), a <= 1L))
  exp_eq(and3s(efd != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), k <= 9L),
         band3(efd != 9L, b %in% c(4L, -3L, 2L, 7L, 8L), k <= 9L))
  exp_eq(and3s(efe != 0L, , ),
         band3(efe != 0L, , ))
  exp_eq(and3s(eff != 1L, , ),
         band3(eff != 1L, , ))
  exp_eq(and3s(efg != 9L, , ),
         band3(efg != 9L, , ))
  exp_eq(and3s(efh != 0L, , h <= 0L),
         band3(efh != 0L, , h <= 0L))
  exp_eq(and3s(efi != 1L, , a <= 1L),
         band3(efi != 1L, , a <= 1L))
  exp_eq(and3s(efj != 9L, , g <= 9L),
         band3(efj != 9L, , g <= 9L))
  exp_eq(and3s(efk != 0L, q %in% 1:4, ),
         band3(efk != 0L, q %in% 1:4, ))
  exp_eq(and3s(efl != 1L, j %in% 1:4, ),
         band3(efl != 1L, j %in% 1:4, ))
  exp_eq(and3s(efm != 9L, x %in% 1:4, ),
         band3(efm != 9L, x %in% 1:4, ))
  exp_eq(and3s(efn != 0L, f %in% 1:4, o <= 0L),
         band3(efn != 0L, f %in% 1:4, o <= 0L))
  exp_eq(and3s(efo != 1L, s %in% 1:4, c <= 1L),
         band3(efo != 1L, s %in% 1:4, c <= 1L))
  exp_eq(and3s(efp != 9L, n %in% 1:4, e <= 9L),
         band3(efp != 9L, n %in% 1:4, e <= 9L))
  exp_eq(and3s(efq != 0L, , ),
         band3(efq != 0L, , ))
  exp_eq(and3s(efr != 1L, , ),
         band3(efr != 1L, , ))
  exp_eq(and3s(efs != 9L, , ),
         band3(efs != 9L, , ))
  exp_eq(and3s(eft != 0L, , k == 0L),
         band3(eft != 0L, , k == 0L))
  exp_eq(and3s(efu != 1L, , d == 1L),
         band3(efu != 1L, , d == 1L))
  exp_eq(and3s(efv != 9L, , t == 9L),
         band3(efv != 9L, , t == 9L))
  exp_eq(and3s(efw != 0L, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(efw != 0L, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(efx != 1L, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(efx != 1L, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(efy != 9L, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(efy != 9L, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(efz != 0L, h %in% c(4L, -3L, 2L, 7L, 8L), m == 0L),
         band3(efz != 0L, h %in% c(4L, -3L, 2L, 7L, 8L), m == 0L))
  exp_eq(and3s(ega != 1L, f %in% c(4L, -3L, 2L, 7L, 8L), d == 1L),
         band3(ega != 1L, f %in% c(4L, -3L, 2L, 7L, 8L), d == 1L))
  exp_eq(and3s(egb != 9L, a %in% c(4L, -3L, 2L, 7L, 8L), t == 9L),
         band3(egb != 9L, a %in% c(4L, -3L, 2L, 7L, 8L), t == 9L))
  exp_eq(and3s(egc != 0L, , ),
         band3(egc != 0L, , ))
  exp_eq(and3s(egd != 1L, , ),
         band3(egd != 1L, , ))
  exp_eq(and3s(ege != 9L, , ),
         band3(ege != 9L, , ))
  exp_eq(and3s(egf != 0L, , y == 0L),
         band3(egf != 0L, , y == 0L))
  exp_eq(and3s(egg != 1L, , w == 1L),
         band3(egg != 1L, , w == 1L))
  exp_eq(and3s(egh != 9L, , c == 9L),
         band3(egh != 9L, , c == 9L))
  exp_eq(and3s(egi != 0L, d %in% 1:4, ),
         band3(egi != 0L, d %in% 1:4, ))
  exp_eq(and3s(egj != 1L, b %in% 1:4, ),
         band3(egj != 1L, b %in% 1:4, ))
  exp_eq(and3s(egk != 9L, z %in% 1:4, ),
         band3(egk != 9L, z %in% 1:4, ))
  exp_eq(and3s(egl != 0L, q %in% 1:4, c == 0L),
         band3(egl != 0L, q %in% 1:4, c == 0L))
  exp_eq(and3s(egm != 1L, d %in% 1:4, v == 1L),
         band3(egm != 1L, d %in% 1:4, v == 1L))
  exp_eq(and3s(egn != 9L, k %in% 1:4, a == 9L),
         band3(egn != 9L, k %in% 1:4, a == 9L))
  exp_eq(and3s(ego != 0L, , ),
         band3(ego != 0L, , ))
  exp_eq(and3s(egp != 1L, , ),
         band3(egp != 1L, , ))
  exp_eq(and3s(egq != 9L, , ),
         band3(egq != 9L, , ))
  exp_eq(and3s(egr != 0L, , f > 0L),
         band3(egr != 0L, , f > 0L))
  exp_eq(and3s(egs != 1L, , w > 1L),
         band3(egs != 1L, , w > 1L))
  exp_eq(and3s(egt != 9L, , c > 9L),
         band3(egt != 9L, , c > 9L))
  exp_eq(and3s(egu != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(egu != 0L, s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(egv != 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(egv != 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(egw != 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(egw != 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(egx != 0L, e %in% c(4L, -3L, 2L, 7L, 8L), v > 0L),
         band3(egx != 0L, e %in% c(4L, -3L, 2L, 7L, 8L), v > 0L))
  exp_eq(and3s(egy != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), w > 1L),
         band3(egy != 1L, n %in% c(4L, -3L, 2L, 7L, 8L), w > 1L))
  exp_eq(and3s(egz != 9L, u %in% c(4L, -3L, 2L, 7L, 8L), h > 9L),
         band3(egz != 9L, u %in% c(4L, -3L, 2L, 7L, 8L), h > 9L))
  exp_eq(and3s(eha != 0L, , ),
         band3(eha != 0L, , ))
  exp_eq(and3s(ehb != 1L, , ),
         band3(ehb != 1L, , ))
  exp_eq(and3s(ehc != 9L, , ),
         band3(ehc != 9L, , ))
  exp_eq(and3s(ehd != 0L, , l > 0L),
         band3(ehd != 0L, , l > 0L))
  exp_eq(and3s(ehe != 1L, , q > 1L),
         band3(ehe != 1L, , q > 1L))
  exp_eq(and3s(ehf != 9L, , r > 9L),
         band3(ehf != 9L, , r > 9L))
  exp_eq(and3s(ehg != 0L, g %in% 1:4, ),
         band3(ehg != 0L, g %in% 1:4, ))
  exp_eq(and3s(ehh != 1L, h %in% 1:4, ),
         band3(ehh != 1L, h %in% 1:4, ))
  exp_eq(and3s(ehi != 9L, x %in% 1:4, ),
         band3(ehi != 9L, x %in% 1:4, ))
  exp_eq(and3s(ehj != 0L, z %in% 1:4, k > 0L),
         band3(ehj != 0L, z %in% 1:4, k > 0L))
  exp_eq(and3s(ehk != 1L, p %in% 1:4, p > 1L),
         band3(ehk != 1L, p %in% 1:4, p > 1L))
  exp_eq(and3s(ehl != 9L, o %in% 1:4, i > 9L),
         band3(ehl != 9L, o %in% 1:4, i > 9L))
  exp_eq(and3s(ehm != 0L, , ),
         band3(ehm != 0L, , ))
  exp_eq(and3s(ehn != 1L, , ),
         band3(ehn != 1L, , ))
  exp_eq(and3s(eho != 9L, , ),
         band3(eho != 9L, , ))
  exp_eq(and3s(ehp != 0L, , n >= 0L),
         band3(ehp != 0L, , n >= 0L))
  exp_eq(and3s(ehq != 1L, , n >= 1L),
         band3(ehq != 1L, , n >= 1L))
  exp_eq(and3s(ehr != 9L, , x >= 9L),
         band3(ehr != 9L, , x >= 9L))
  exp_eq(and3s(ehs != 0L, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ehs != 0L, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(eht != 1L, b %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(eht != 1L, b %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ehu != 9L, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ehu != 9L, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ehv != 0L, y %in% c(4L, -3L, 2L, 7L, 8L), w >= 0L),
         band3(ehv != 0L, y %in% c(4L, -3L, 2L, 7L, 8L), w >= 0L))
  exp_eq(and3s(ehw != 1L, w %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L),
         band3(ehw != 1L, w %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L))
  exp_eq(and3s(ehx != 9L, o %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L),
         band3(ehx != 9L, o %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L))
  exp_eq(and3s(ehy != 0L, , ),
         band3(ehy != 0L, , ))
  exp_eq(and3s(ehz != 1L, , ),
         band3(ehz != 1L, , ))
  exp_eq(and3s(eia != 9L, , ),
         band3(eia != 9L, , ))
  exp_eq(and3s(eib != 0L, , u >= 0L),
         band3(eib != 0L, , u >= 0L))
  exp_eq(and3s(eic != 1L, , d >= 1L),
         band3(eic != 1L, , d >= 1L))
  exp_eq(and3s(eid != 9L, , t >= 9L),
         band3(eid != 9L, , t >= 9L))
  exp_eq(and3s(eie != 0L, i %in% 1:4, ),
         band3(eie != 0L, i %in% 1:4, ))
  exp_eq(and3s(eif != 1L, r %in% 1:4, ),
         band3(eif != 1L, r %in% 1:4, ))
  exp_eq(and3s(eig != 9L, j %in% 1:4, ),
         band3(eig != 9L, j %in% 1:4, ))
  exp_eq(and3s(eih != 0L, p %in% 1:4, u >= 0L),
         band3(eih != 0L, p %in% 1:4, u >= 0L))
  exp_eq(and3s(eii != 1L, x %in% 1:4, k >= 1L),
         band3(eii != 1L, x %in% 1:4, k >= 1L))
  exp_eq(and3s(eij != 9L, y %in% 1:4, n >= 9L),
         band3(eij != 9L, y %in% 1:4, n >= 9L))
  exp_eq(and3s(eik != 0L, , ),
         band3(eik != 0L, , ))
  exp_eq(and3s(eil != 1L, , ),
         band3(eil != 1L, , ))
  exp_eq(and3s(eim != 9L, , ),
         band3(eim != 9L, , ))
  exp_eq(and3s(ein != 0L, , logi_r),
         band3(ein != 0L, , logi_r))
  exp_eq(and3s(eio != 1L, , logi_h),
         band3(eio != 1L, , logi_h))
  exp_eq(and3s(eip != 9L, , logi_u),
         band3(eip != 9L, , logi_u))
  exp_eq(and3s(eiq != 0L, z < 0L, ),
         band3(eiq != 0L, z < 0L, ))
  exp_eq(and3s(eir != 1L, e < 1L, ),
         band3(eir != 1L, e < 1L, ))
  exp_eq(and3s(eis != 9L, k < 9L, ),
         band3(eis != 9L, k < 9L, ))
  exp_eq(and3s(eit != 0L, k < 0L, logi_q),
         band3(eit != 0L, k < 0L, logi_q))
  exp_eq(and3s(eiu != 1L, n < 1L, logi_z),
         band3(eiu != 1L, n < 1L, logi_z))
  exp_eq(and3s(eiv != 9L, l < 9L, logi_m),
         band3(eiv != 9L, l < 9L, logi_m))
  exp_eq(and3s(eiw != 0L, , ),
         band3(eiw != 0L, , ))
  exp_eq(and3s(eix != 1L, , ),
         band3(eix != 1L, , ))
  exp_eq(and3s(eiy != 9L, , ),
         band3(eiy != 9L, , ))
  exp_eq(and3s(eiz != 0L, , !logi_v),
         band3(eiz != 0L, , !logi_v))
  exp_eq(and3s(eja != 1L, , !logi_e),
         band3(eja != 1L, , !logi_e))
  exp_eq(and3s(ejb != 9L, , !logi_m),
         band3(ejb != 9L, , !logi_m))
  exp_eq(and3s(ejc != 0L, v < 0L, ),
         band3(ejc != 0L, v < 0L, ))
  exp_eq(and3s(ejd != 1L, q < 1L, ),
         band3(ejd != 1L, q < 1L, ))
  exp_eq(and3s(eje != 9L, z < 9L, ),
         band3(eje != 9L, z < 9L, ))
  exp_eq(and3s(ejf != 0L, b < 0L, !logi_u),
         band3(ejf != 0L, b < 0L, !logi_u))
  exp_eq(and3s(ejg != 1L, f < 1L, !logi_t),
         band3(ejg != 1L, f < 1L, !logi_t))
  exp_eq(and3s(ejh != 9L, l < 9L, !logi_u),
         band3(ejh != 9L, l < 9L, !logi_u))
  exp_eq(and3s(eji != 0L, , ),
         band3(eji != 0L, , ))
  exp_eq(and3s(ejj != 1L, , ),
         band3(ejj != 1L, , ))
  exp_eq(and3s(ejk != 9L, , ),
         band3(ejk != 9L, , ))
  exp_eq(and3s(ejl != 0L, , n != 0L),
         band3(ejl != 0L, , n != 0L))
  exp_eq(and3s(ejm != 1L, , m != 1L),
         band3(ejm != 1L, , m != 1L))
  exp_eq(and3s(ejn != 9L, , k != 9L),
         band3(ejn != 9L, , k != 9L))
  exp_eq(and3s(ejo != 0L, l < 0L, ),
         band3(ejo != 0L, l < 0L, ))
  exp_eq(and3s(ejp != 1L, z < 1L, ),
         band3(ejp != 1L, z < 1L, ))
  exp_eq(and3s(ejq != 9L, u < 9L, ),
         band3(ejq != 9L, u < 9L, ))
  exp_eq(and3s(ejr != 0L, e < 0L, v != 0L),
         band3(ejr != 0L, e < 0L, v != 0L))
  exp_eq(and3s(ejs != 1L, u < 1L, z != 1L),
         band3(ejs != 1L, u < 1L, z != 1L))
  exp_eq(and3s(ejt != 9L, w < 9L, u != 9L),
         band3(ejt != 9L, w < 9L, u != 9L))
  exp_eq(and3s(eju != 0L, , ),
         band3(eju != 0L, , ))
  exp_eq(and3s(ejv != 1L, , ),
         band3(ejv != 1L, , ))
  exp_eq(and3s(ejw != 9L, , ),
         band3(ejw != 9L, , ))
  exp_eq(and3s(ejx != 0L, , j %between% c(-1L, 1L)),
         band3(ejx != 0L, , j %between% c(-1L, 1L)))
  exp_eq(and3s(ejy != 1L, , h %between% c(-1L, 1L)),
         band3(ejy != 1L, , h %between% c(-1L, 1L)))
  exp_eq(and3s(ejz != 9L, , k %between% c(-1L, 1L)),
         band3(ejz != 9L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(eka != 0L, x < 0L, ),
         band3(eka != 0L, x < 0L, ))
  exp_eq(and3s(ekb != 1L, q < 1L, ),
         band3(ekb != 1L, q < 1L, ))
  exp_eq(and3s(ekc != 9L, p < 9L, ),
         band3(ekc != 9L, p < 9L, ))
  exp_eq(and3s(ekd != 0L, q < 0L, g %between% c(-1L, 1L)),
         band3(ekd != 0L, q < 0L, g %between% c(-1L, 1L)))
  exp_eq(and3s(eke != 1L, b < 1L, y %between% c(-1L, 1L)),
         band3(eke != 1L, b < 1L, y %between% c(-1L, 1L)))
  exp_eq(and3s(ekf != 9L, y < 9L, j %between% c(-1L, 1L)),
         band3(ekf != 9L, y < 9L, j %between% c(-1L, 1L)))
  exp_eq(and3s(ekg != 0L, , ),
         band3(ekg != 0L, , ))
  exp_eq(and3s(ekh != 1L, , ),
         band3(ekh != 1L, , ))
  exp_eq(and3s(eki != 9L, , ),
         band3(eki != 9L, , ))
  exp_eq(and3s(ekj != 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekj != 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ekk != 1L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekk != 1L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ekl != 9L, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekl != 9L, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ekm != 0L, u < 0L, ),
         band3(ekm != 0L, u < 0L, ))
  exp_eq(and3s(ekn != 1L, z < 1L, ),
         band3(ekn != 1L, z < 1L, ))
  exp_eq(and3s(eko != 9L, y < 9L, ),
         band3(eko != 9L, y < 9L, ))
  exp_eq(and3s(ekp != 0L, a < 0L, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekp != 0L, a < 0L, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ekq != 1L, g < 1L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekq != 1L, g < 1L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ekr != 9L, g < 9L, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ekr != 9L, g < 9L, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(eks != 0L, , ),
         band3(eks != 0L, , ))
  exp_eq(and3s(ekt != 1L, , ),
         band3(ekt != 1L, , ))
  exp_eq(and3s(eku != 9L, , ),
         band3(eku != 9L, , ))
  exp_eq(and3s(ekv != 0L, , n %in% 1:4),
         band3(ekv != 0L, , n %in% 1:4))
  exp_eq(and3s(ekw != 1L, , a %in% 1:4),
         band3(ekw != 1L, , a %in% 1:4))
  exp_eq(and3s(ekx != 9L, , g %in% 1:4),
         band3(ekx != 9L, , g %in% 1:4))
  exp_eq(and3s(eky != 0L, d < 0L, ),
         band3(eky != 0L, d < 0L, ))
  exp_eq(and3s(ekz != 1L, t < 1L, ),
         band3(ekz != 1L, t < 1L, ))
  exp_eq(and3s(ela != 9L, y < 9L, ),
         band3(ela != 9L, y < 9L, ))
  exp_eq(and3s(elb != 0L, p < 0L, z %in% 1:4),
         band3(elb != 0L, p < 0L, z %in% 1:4))
  exp_eq(and3s(elc != 1L, p < 1L, b %in% 1:4),
         band3(elc != 1L, p < 1L, b %in% 1:4))
  exp_eq(and3s(eld != 9L, n < 9L, e %in% 1:4),
         band3(eld != 9L, n < 9L, e %in% 1:4))
  exp_eq(and3s(ele != 0L, , ),
         band3(ele != 0L, , ))
  exp_eq(and3s(elf != 1L, , ),
         band3(elf != 1L, , ))
  exp_eq(and3s(elg != 9L, , ),
         band3(elg != 9L, , ))
  exp_eq(and3s(elh != 0L, , c < 0L),
         band3(elh != 0L, , c < 0L))
  exp_eq(and3s(eli != 1L, , n < 1L),
         band3(eli != 1L, , n < 1L))
  exp_eq(and3s(elj != 9L, , h < 9L),
         band3(elj != 9L, , h < 9L))
  exp_eq(and3s(elk != 0L, p < 0L, ),
         band3(elk != 0L, p < 0L, ))
  exp_eq(and3s(ell != 1L, w < 1L, ),
         band3(ell != 1L, w < 1L, ))
  exp_eq(and3s(elm != 9L, s < 9L, ),
         band3(elm != 9L, s < 9L, ))
  exp_eq(and3s(eln != 0L, r < 0L, z < 0L),
         band3(eln != 0L, r < 0L, z < 0L))
  exp_eq(and3s(elo != 1L, q < 1L, u < 1L),
         band3(elo != 1L, q < 1L, u < 1L))
  exp_eq(and3s(elp != 9L, q < 9L, p < 9L),
         band3(elp != 9L, q < 9L, p < 9L))
  exp_eq(and3s(elq != 0L, , ),
         band3(elq != 0L, , ))
  exp_eq(and3s(elr != 1L, , ),
         band3(elr != 1L, , ))
  exp_eq(and3s(els != 9L, , ),
         band3(els != 9L, , ))
  exp_eq(and3s(elt != 0L, , z <= 0L),
         band3(elt != 0L, , z <= 0L))
  exp_eq(and3s(elu != 1L, , e <= 1L),
         band3(elu != 1L, , e <= 1L))
  exp_eq(and3s(elv != 9L, , a <= 9L),
         band3(elv != 9L, , a <= 9L))
  exp_eq(and3s(elw != 0L, a < 0L, ),
         band3(elw != 0L, a < 0L, ))
  exp_eq(and3s(elx != 1L, u < 1L, ),
         band3(elx != 1L, u < 1L, ))
  exp_eq(and3s(ely != 9L, x < 9L, ),
         band3(ely != 9L, x < 9L, ))
  exp_eq(and3s(elz != 0L, r < 0L, h <= 0L),
         band3(elz != 0L, r < 0L, h <= 0L))
  exp_eq(and3s(ema != 1L, j < 1L, n <= 1L),
         band3(ema != 1L, j < 1L, n <= 1L))
  exp_eq(and3s(emb != 9L, v < 9L, x <= 9L),
         band3(emb != 9L, v < 9L, x <= 9L))
  exp_eq(and3s(emc != 0L, , ),
         band3(emc != 0L, , ))
  exp_eq(and3s(emd != 1L, , ),
         band3(emd != 1L, , ))
  exp_eq(and3s(eme != 9L, , ),
         band3(eme != 9L, , ))
  exp_eq(and3s(emf != 0L, , f == 0L),
         band3(emf != 0L, , f == 0L))
  exp_eq(and3s(emg != 1L, , x == 1L),
         band3(emg != 1L, , x == 1L))
  exp_eq(and3s(emh != 9L, , u == 9L),
         band3(emh != 9L, , u == 9L))
  exp_eq(and3s(emi != 0L, x < 0L, ),
         band3(emi != 0L, x < 0L, ))
  exp_eq(and3s(emj != 1L, l < 1L, ),
         band3(emj != 1L, l < 1L, ))
  exp_eq(and3s(emk != 9L, r < 9L, ),
         band3(emk != 9L, r < 9L, ))
  exp_eq(and3s(eml != 0L, g < 0L, z == 0L),
         band3(eml != 0L, g < 0L, z == 0L))
  exp_eq(and3s(emm != 1L, j < 1L, n == 1L),
         band3(emm != 1L, j < 1L, n == 1L))
  exp_eq(and3s(emn != 9L, v < 9L, u == 9L),
         band3(emn != 9L, v < 9L, u == 9L))
  exp_eq(and3s(emo != 0L, , ),
         band3(emo != 0L, , ))
  exp_eq(and3s(emp != 1L, , ),
         band3(emp != 1L, , ))
  exp_eq(and3s(emq != 9L, , ),
         band3(emq != 9L, , ))
  exp_eq(and3s(emr != 0L, , t > 0L),
         band3(emr != 0L, , t > 0L))
  exp_eq(and3s(ems != 1L, , v > 1L),
         band3(ems != 1L, , v > 1L))
  exp_eq(and3s(emt != 9L, , e > 9L),
         band3(emt != 9L, , e > 9L))
  exp_eq(and3s(emu != 0L, m < 0L, ),
         band3(emu != 0L, m < 0L, ))
  exp_eq(and3s(emv != 1L, i < 1L, ),
         band3(emv != 1L, i < 1L, ))
  exp_eq(and3s(emw != 9L, w < 9L, ),
         band3(emw != 9L, w < 9L, ))
  exp_eq(and3s(emx != 0L, y < 0L, o > 0L),
         band3(emx != 0L, y < 0L, o > 0L))
  exp_eq(and3s(emy != 1L, x < 1L, d > 1L),
         band3(emy != 1L, x < 1L, d > 1L))
  exp_eq(and3s(emz != 9L, x < 9L, s > 9L),
         band3(emz != 9L, x < 9L, s > 9L))
  exp_eq(and3s(ena != 0L, , ),
         band3(ena != 0L, , ))
  exp_eq(and3s(enb != 1L, , ),
         band3(enb != 1L, , ))
  exp_eq(and3s(enc != 9L, , ),
         band3(enc != 9L, , ))
  exp_eq(and3s(end != 0L, , i >= 0L),
         band3(end != 0L, , i >= 0L))
  exp_eq(and3s(ene != 1L, , e >= 1L),
         band3(ene != 1L, , e >= 1L))
  exp_eq(and3s(enf != 9L, , z >= 9L),
         band3(enf != 9L, , z >= 9L))
  exp_eq(and3s(eng != 0L, q < 0L, ),
         band3(eng != 0L, q < 0L, ))
  exp_eq(and3s(enh != 1L, z < 1L, ),
         band3(enh != 1L, z < 1L, ))
  exp_eq(and3s(eni != 9L, s < 9L, ),
         band3(eni != 9L, s < 9L, ))
  exp_eq(and3s(enj != 0L, w < 0L, v >= 0L),
         band3(enj != 0L, w < 0L, v >= 0L))
  exp_eq(and3s(enk != 1L, j < 1L, t >= 1L),
         band3(enk != 1L, j < 1L, t >= 1L))
  exp_eq(and3s(enl != 9L, d < 9L, i >= 9L),
         band3(enl != 9L, d < 9L, i >= 9L))
  exp_eq(and3s(enm != 0L, , ),
         band3(enm != 0L, , ))
  exp_eq(and3s(enn != 1L, , ),
         band3(enn != 1L, , ))
  exp_eq(and3s(eno != 9L, , ),
         band3(eno != 9L, , ))
  exp_eq(and3s(enp != 0L, , logi_k),
         band3(enp != 0L, , logi_k))
  exp_eq(and3s(enq != 1L, , logi_i),
         band3(enq != 1L, , logi_i))
  exp_eq(and3s(enr != 9L, , logi_i),
         band3(enr != 9L, , logi_i))
  exp_eq(and3s(ens != 0L, e <= 0L, ),
         band3(ens != 0L, e <= 0L, ))
  exp_eq(and3s(ent != 1L, f <= 1L, ),
         band3(ent != 1L, f <= 1L, ))
  exp_eq(and3s(enu != 9L, q <= 9L, ),
         band3(enu != 9L, q <= 9L, ))
  exp_eq(and3s(env != 0L, m <= 0L, logi_a),
         band3(env != 0L, m <= 0L, logi_a))
  exp_eq(and3s(enw != 1L, z <= 1L, logi_c),
         band3(enw != 1L, z <= 1L, logi_c))
  exp_eq(and3s(enx != 9L, k <= 9L, logi_c),
         band3(enx != 9L, k <= 9L, logi_c))
  exp_eq(and3s(eny != 0L, , ),
         band3(eny != 0L, , ))
  exp_eq(and3s(enz != 1L, , ),
         band3(enz != 1L, , ))
  exp_eq(and3s(eoa != 9L, , ),
         band3(eoa != 9L, , ))
  exp_eq(and3s(eob != 0L, , !logi_g),
         band3(eob != 0L, , !logi_g))
  exp_eq(and3s(eoc != 1L, , !logi_e),
         band3(eoc != 1L, , !logi_e))
  exp_eq(and3s(eod != 9L, , !logi_d),
         band3(eod != 9L, , !logi_d))
  exp_eq(and3s(eoe != 0L, l <= 0L, ),
         band3(eoe != 0L, l <= 0L, ))
  exp_eq(and3s(eof != 1L, l <= 1L, ),
         band3(eof != 1L, l <= 1L, ))
  exp_eq(and3s(eog != 9L, a <= 9L, ),
         band3(eog != 9L, a <= 9L, ))
  exp_eq(and3s(eoh != 0L, w <= 0L, !logi_f),
         band3(eoh != 0L, w <= 0L, !logi_f))
  exp_eq(and3s(eoi != 1L, f <= 1L, !logi_n),
         band3(eoi != 1L, f <= 1L, !logi_n))
  exp_eq(and3s(eoj != 9L, x <= 9L, !logi_m),
         band3(eoj != 9L, x <= 9L, !logi_m))
  exp_eq(and3s(eok != 0L, , ),
         band3(eok != 0L, , ))
  exp_eq(and3s(eol != 1L, , ),
         band3(eol != 1L, , ))
  exp_eq(and3s(eom != 9L, , ),
         band3(eom != 9L, , ))
  exp_eq(and3s(eon != 0L, , u != 0L),
         band3(eon != 0L, , u != 0L))
  exp_eq(and3s(eoo != 1L, , z != 1L),
         band3(eoo != 1L, , z != 1L))
  exp_eq(and3s(eop != 9L, , a != 9L),
         band3(eop != 9L, , a != 9L))
  exp_eq(and3s(eoq != 0L, p <= 0L, ),
         band3(eoq != 0L, p <= 0L, ))
  exp_eq(and3s(eor != 1L, a <= 1L, ),
         band3(eor != 1L, a <= 1L, ))
  exp_eq(and3s(eos != 9L, q <= 9L, ),
         band3(eos != 9L, q <= 9L, ))
  exp_eq(and3s(eot != 0L, b <= 0L, m != 0L),
         band3(eot != 0L, b <= 0L, m != 0L))
  exp_eq(and3s(eou != 1L, g <= 1L, b != 1L),
         band3(eou != 1L, g <= 1L, b != 1L))
  exp_eq(and3s(eov != 9L, k <= 9L, u != 9L),
         band3(eov != 9L, k <= 9L, u != 9L))
  exp_eq(and3s(eow != 0L, , ),
         band3(eow != 0L, , ))
  exp_eq(and3s(eox != 1L, , ),
         band3(eox != 1L, , ))
  exp_eq(and3s(eoy != 9L, , ),
         band3(eoy != 9L, , ))
  exp_eq(and3s(eoz != 0L, , u %between% c(-1L, 1L)),
         band3(eoz != 0L, , u %between% c(-1L, 1L)))
  exp_eq(and3s(epa != 1L, , k %between% c(-1L, 1L)),
         band3(epa != 1L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(epb != 9L, , v %between% c(-1L, 1L)),
         band3(epb != 9L, , v %between% c(-1L, 1L)))
  exp_eq(and3s(epc != 0L, e <= 0L, ),
         band3(epc != 0L, e <= 0L, ))
  exp_eq(and3s(epd != 1L, m <= 1L, ),
         band3(epd != 1L, m <= 1L, ))
  exp_eq(and3s(epe != 9L, r <= 9L, ),
         band3(epe != 9L, r <= 9L, ))
  exp_eq(and3s(epf != 0L, o <= 0L, v %between% c(-1L, 1L)),
         band3(epf != 0L, o <= 0L, v %between% c(-1L, 1L)))
  exp_eq(and3s(epg != 1L, d <= 1L, i %between% c(-1L, 1L)),
         band3(epg != 1L, d <= 1L, i %between% c(-1L, 1L)))
  exp_eq(and3s(eph != 9L, n <= 9L, w %between% c(-1L, 1L)),
         band3(eph != 9L, n <= 9L, w %between% c(-1L, 1L)))
  exp_eq(and3s(epi != 0L, , ),
         band3(epi != 0L, , ))
  exp_eq(and3s(epj != 1L, , ),
         band3(epj != 1L, , ))
  exp_eq(and3s(epk != 9L, , ),
         band3(epk != 9L, , ))
  exp_eq(and3s(epl != 0L, , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(epl != 0L, , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(epm != 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(epm != 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(epn != 9L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(epn != 9L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(epo != 0L, p <= 0L, ),
         band3(epo != 0L, p <= 0L, ))
  exp_eq(and3s(epp != 1L, j <= 1L, ),
         band3(epp != 1L, j <= 1L, ))
  exp_eq(and3s(epq != 9L, j <= 9L, ),
         band3(epq != 9L, j <= 9L, ))
  exp_eq(and3s(epr != 0L, h <= 0L, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(epr != 0L, h <= 0L, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(eps != 1L, s <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(eps != 1L, s <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ept != 9L, h <= 9L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ept != 9L, h <= 9L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(epu != 0L, , ),
         band3(epu != 0L, , ))
  exp_eq(and3s(epv != 1L, , ),
         band3(epv != 1L, , ))
  exp_eq(and3s(epw != 9L, , ),
         band3(epw != 9L, , ))
  exp_eq(and3s(epx != 0L, , s %in% 1:4),
         band3(epx != 0L, , s %in% 1:4))
  exp_eq(and3s(epy != 1L, , l %in% 1:4),
         band3(epy != 1L, , l %in% 1:4))
  exp_eq(and3s(epz != 9L, , l %in% 1:4),
         band3(epz != 9L, , l %in% 1:4))
  exp_eq(and3s(eqa != 0L, t <= 0L, ),
         band3(eqa != 0L, t <= 0L, ))
  exp_eq(and3s(eqb != 1L, t <= 1L, ),
         band3(eqb != 1L, t <= 1L, ))
  exp_eq(and3s(eqc != 9L, o <= 9L, ),
         band3(eqc != 9L, o <= 9L, ))
  exp_eq(and3s(eqd != 0L, z <= 0L, j %in% 1:4),
         band3(eqd != 0L, z <= 0L, j %in% 1:4))
  exp_eq(and3s(eqe != 1L, p <= 1L, w %in% 1:4),
         band3(eqe != 1L, p <= 1L, w %in% 1:4))
  exp_eq(and3s(eqf != 9L, t <= 9L, h %in% 1:4),
         band3(eqf != 9L, t <= 9L, h %in% 1:4))
  exp_eq(and3s(eqg != 0L, , ),
         band3(eqg != 0L, , ))
  exp_eq(and3s(eqh != 1L, , ),
         band3(eqh != 1L, , ))
  exp_eq(and3s(eqi != 9L, , ),
         band3(eqi != 9L, , ))
  exp_eq(and3s(eqj != 0L, , r < 0L),
         band3(eqj != 0L, , r < 0L))
  exp_eq(and3s(eqk != 1L, , s < 1L),
         band3(eqk != 1L, , s < 1L))
  exp_eq(and3s(eql != 9L, , w < 9L),
         band3(eql != 9L, , w < 9L))
  exp_eq(and3s(eqm != 0L, i <= 0L, ),
         band3(eqm != 0L, i <= 0L, ))
  exp_eq(and3s(eqn != 1L, m <= 1L, ),
         band3(eqn != 1L, m <= 1L, ))
  exp_eq(and3s(eqo != 9L, r <= 9L, ),
         band3(eqo != 9L, r <= 9L, ))
  exp_eq(and3s(eqp != 0L, d <= 0L, f < 0L),
         band3(eqp != 0L, d <= 0L, f < 0L))
  exp_eq(and3s(eqq != 1L, f <= 1L, c < 1L),
         band3(eqq != 1L, f <= 1L, c < 1L))
  exp_eq(and3s(eqr != 9L, w <= 9L, a < 9L),
         band3(eqr != 9L, w <= 9L, a < 9L))
  exp_eq(and3s(eqs != 0L, , ),
         band3(eqs != 0L, , ))
  exp_eq(and3s(eqt != 1L, , ),
         band3(eqt != 1L, , ))
  exp_eq(and3s(equ != 9L, , ),
         band3(equ != 9L, , ))
  exp_eq(and3s(eqv != 0L, , f <= 0L),
         band3(eqv != 0L, , f <= 0L))
  exp_eq(and3s(eqw != 1L, , a <= 1L),
         band3(eqw != 1L, , a <= 1L))
  exp_eq(and3s(eqx != 9L, , s <= 9L),
         band3(eqx != 9L, , s <= 9L))
  exp_eq(and3s(eqy != 0L, b <= 0L, ),
         band3(eqy != 0L, b <= 0L, ))
  exp_eq(and3s(eqz != 1L, q <= 1L, ),
         band3(eqz != 1L, q <= 1L, ))
  exp_eq(and3s(era != 9L, a <= 9L, ),
         band3(era != 9L, a <= 9L, ))
  exp_eq(and3s(erb != 0L, l <= 0L, v <= 0L),
         band3(erb != 0L, l <= 0L, v <= 0L))
  exp_eq(and3s(erc != 1L, j <= 1L, z <= 1L),
         band3(erc != 1L, j <= 1L, z <= 1L))
  exp_eq(and3s(erd != 9L, r <= 9L, r <= 9L),
         band3(erd != 9L, r <= 9L, r <= 9L))
  exp_eq(and3s(ere != 0L, , ),
         band3(ere != 0L, , ))
  exp_eq(and3s(erf != 1L, , ),
         band3(erf != 1L, , ))
  exp_eq(and3s(erg != 9L, , ),
         band3(erg != 9L, , ))
  exp_eq(and3s(erh != 0L, , u == 0L),
         band3(erh != 0L, , u == 0L))
  exp_eq(and3s(eri != 1L, , w == 1L),
         band3(eri != 1L, , w == 1L))
  exp_eq(and3s(erj != 9L, , x == 9L),
         band3(erj != 9L, , x == 9L))
  exp_eq(and3s(erk != 0L, m <= 0L, ),
         band3(erk != 0L, m <= 0L, ))
  exp_eq(and3s(erl != 1L, m <= 1L, ),
         band3(erl != 1L, m <= 1L, ))
  exp_eq(and3s(erm != 9L, l <= 9L, ),
         band3(erm != 9L, l <= 9L, ))
  exp_eq(and3s(ern != 0L, b <= 0L, t == 0L),
         band3(ern != 0L, b <= 0L, t == 0L))
  exp_eq(and3s(ero != 1L, x <= 1L, j == 1L),
         band3(ero != 1L, x <= 1L, j == 1L))
  exp_eq(and3s(erp != 9L, y <= 9L, e == 9L),
         band3(erp != 9L, y <= 9L, e == 9L))
  exp_eq(and3s(erq != 0L, , ),
         band3(erq != 0L, , ))
  exp_eq(and3s(err != 1L, , ),
         band3(err != 1L, , ))
  exp_eq(and3s(ers != 9L, , ),
         band3(ers != 9L, , ))
  exp_eq(and3s(ert != 0L, , v > 0L),
         band3(ert != 0L, , v > 0L))
  exp_eq(and3s(eru != 1L, , t > 1L),
         band3(eru != 1L, , t > 1L))
  exp_eq(and3s(erv != 9L, , y > 9L),
         band3(erv != 9L, , y > 9L))
  exp_eq(and3s(erw != 0L, l <= 0L, ),
         band3(erw != 0L, l <= 0L, ))
  exp_eq(and3s(erx != 1L, j <= 1L, ),
         band3(erx != 1L, j <= 1L, ))
  exp_eq(and3s(ery != 9L, h <= 9L, ),
         band3(ery != 9L, h <= 9L, ))
  exp_eq(and3s(erz != 0L, v <= 0L, a > 0L),
         band3(erz != 0L, v <= 0L, a > 0L))
  exp_eq(and3s(esa != 1L, o <= 1L, r > 1L),
         band3(esa != 1L, o <= 1L, r > 1L))
  exp_eq(and3s(esb != 9L, p <= 9L, e > 9L),
         band3(esb != 9L, p <= 9L, e > 9L))
  exp_eq(and3s(esc != 0L, , ),
         band3(esc != 0L, , ))
  exp_eq(and3s(esd != 1L, , ),
         band3(esd != 1L, , ))
  exp_eq(and3s(ese != 9L, , ),
         band3(ese != 9L, , ))
  exp_eq(and3s(esf != 0L, , i >= 0L),
         band3(esf != 0L, , i >= 0L))
  exp_eq(and3s(esg != 1L, , i >= 1L),
         band3(esg != 1L, , i >= 1L))
  exp_eq(and3s(esh != 9L, , p >= 9L),
         band3(esh != 9L, , p >= 9L))
  exp_eq(and3s(esi != 0L, h <= 0L, ),
         band3(esi != 0L, h <= 0L, ))
  exp_eq(and3s(esj != 1L, z <= 1L, ),
         band3(esj != 1L, z <= 1L, ))
  exp_eq(and3s(esk != 9L, v <= 9L, ),
         band3(esk != 9L, v <= 9L, ))
  exp_eq(and3s(esl != 0L, h <= 0L, d >= 0L),
         band3(esl != 0L, h <= 0L, d >= 0L))
  exp_eq(and3s(esm != 1L, l <= 1L, z >= 1L),
         band3(esm != 1L, l <= 1L, z >= 1L))
  exp_eq(and3s(esn != 9L, n <= 9L, q >= 9L),
         band3(esn != 9L, n <= 9L, q >= 9L))
  exp_eq(and3s(eso != 0L, , ),
         band3(eso != 0L, , ))
  exp_eq(and3s(esp != 1L, , ),
         band3(esp != 1L, , ))
  exp_eq(and3s(esq != 9L, , ),
         band3(esq != 9L, , ))
  exp_eq(and3s(esr != 0L, , logi_g),
         band3(esr != 0L, , logi_g))
  exp_eq(and3s(ess != 1L, , logi_i),
         band3(ess != 1L, , logi_i))
  exp_eq(and3s(est != 9L, , logi_k),
         band3(est != 9L, , logi_k))
  exp_eq(and3s(esu != 0L, m == 0L, ),
         band3(esu != 0L, m == 0L, ))
  exp_eq(and3s(esv != 1L, y == 1L, ),
         band3(esv != 1L, y == 1L, ))
  exp_eq(and3s(esw != 9L, l == 9L, ),
         band3(esw != 9L, l == 9L, ))
  exp_eq(and3s(esx != 0L, w == 0L, logi_g),
         band3(esx != 0L, w == 0L, logi_g))
  exp_eq(and3s(esy != 1L, i == 1L, logi_d),
         band3(esy != 1L, i == 1L, logi_d))
  exp_eq(and3s(esz != 9L, z == 9L, logi_o),
         band3(esz != 9L, z == 9L, logi_o))
  exp_eq(and3s(eta != 0L, , ),
         band3(eta != 0L, , ))
  exp_eq(and3s(etb != 1L, , ),
         band3(etb != 1L, , ))
  exp_eq(and3s(etc != 9L, , ),
         band3(etc != 9L, , ))
  exp_eq(and3s(etd != 0L, , !logi_v),
         band3(etd != 0L, , !logi_v))
  exp_eq(and3s(ete != 1L, , !logi_r),
         band3(ete != 1L, , !logi_r))
  exp_eq(and3s(etf != 9L, , !logi_o),
         band3(etf != 9L, , !logi_o))
  exp_eq(and3s(etg != 0L, p == 0L, ),
         band3(etg != 0L, p == 0L, ))
  exp_eq(and3s(eth != 1L, i == 1L, ),
         band3(eth != 1L, i == 1L, ))
  exp_eq(and3s(eti != 9L, q == 9L, ),
         band3(eti != 9L, q == 9L, ))
  exp_eq(and3s(etj != 0L, t == 0L, !logi_m),
         band3(etj != 0L, t == 0L, !logi_m))
  exp_eq(and3s(etk != 1L, n == 1L, !logi_z),
         band3(etk != 1L, n == 1L, !logi_z))
  exp_eq(and3s(etl != 9L, r == 9L, !logi_a),
         band3(etl != 9L, r == 9L, !logi_a))
  exp_eq(and3s(etm != 0L, , ),
         band3(etm != 0L, , ))
  exp_eq(and3s(etn != 1L, , ),
         band3(etn != 1L, , ))
  exp_eq(and3s(eto != 9L, , ),
         band3(eto != 9L, , ))
  exp_eq(and3s(etp != 0L, , d != 0L),
         band3(etp != 0L, , d != 0L))
  exp_eq(and3s(etq != 1L, , e != 1L),
         band3(etq != 1L, , e != 1L))
  exp_eq(and3s(etr != 9L, , v != 9L),
         band3(etr != 9L, , v != 9L))
  exp_eq(and3s(ets != 0L, q == 0L, ),
         band3(ets != 0L, q == 0L, ))
  exp_eq(and3s(ett != 1L, m == 1L, ),
         band3(ett != 1L, m == 1L, ))
  exp_eq(and3s(etu != 9L, t == 9L, ),
         band3(etu != 9L, t == 9L, ))
  exp_eq(and3s(etv != 0L, b == 0L, u != 0L),
         band3(etv != 0L, b == 0L, u != 0L))
  exp_eq(and3s(etw != 1L, n == 1L, g != 1L),
         band3(etw != 1L, n == 1L, g != 1L))
  exp_eq(and3s(etx != 9L, j == 9L, g != 9L),
         band3(etx != 9L, j == 9L, g != 9L))
  exp_eq(and3s(ety != 0L, , ),
         band3(ety != 0L, , ))
  exp_eq(and3s(etz != 1L, , ),
         band3(etz != 1L, , ))
  exp_eq(and3s(eua != 9L, , ),
         band3(eua != 9L, , ))
  exp_eq(and3s(eub != 0L, , n %between% c(-1L, 1L)),
         band3(eub != 0L, , n %between% c(-1L, 1L)))
  exp_eq(and3s(euc != 1L, , b %between% c(-1L, 1L)),
         band3(euc != 1L, , b %between% c(-1L, 1L)))
  exp_eq(and3s(eud != 9L, , w %between% c(-1L, 1L)),
         band3(eud != 9L, , w %between% c(-1L, 1L)))
  exp_eq(and3s(eue != 0L, o == 0L, ),
         band3(eue != 0L, o == 0L, ))
  exp_eq(and3s(euf != 1L, t == 1L, ),
         band3(euf != 1L, t == 1L, ))
  exp_eq(and3s(eug != 9L, o == 9L, ),
         band3(eug != 9L, o == 9L, ))
  exp_eq(and3s(euh != 0L, n == 0L, u %between% c(-1L, 1L)),
         band3(euh != 0L, n == 0L, u %between% c(-1L, 1L)))
  exp_eq(and3s(eui != 1L, b == 1L, b %between% c(-1L, 1L)),
         band3(eui != 1L, b == 1L, b %between% c(-1L, 1L)))
  exp_eq(and3s(euj != 9L, c == 9L, c %between% c(-1L, 1L)),
         band3(euj != 9L, c == 9L, c %between% c(-1L, 1L)))
  exp_eq(and3s(euk != 0L, , ),
         band3(euk != 0L, , ))
  exp_eq(and3s(eul != 1L, , ),
         band3(eul != 1L, , ))
  exp_eq(and3s(eum != 9L, , ),
         band3(eum != 9L, , ))
  exp_eq(and3s(eun != 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(eun != 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(euo != 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(euo != 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(eup != 9L, , d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(eup != 9L, , d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(euq != 0L, y == 0L, ),
         band3(euq != 0L, y == 0L, ))
  exp_eq(and3s(eur != 1L, q == 1L, ),
         band3(eur != 1L, q == 1L, ))
  exp_eq(and3s(eus != 9L, x == 9L, ),
         band3(eus != 9L, x == 9L, ))
  exp_eq(and3s(eut != 0L, k == 0L, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(eut != 0L, k == 0L, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(euu != 1L, g == 1L, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(euu != 1L, g == 1L, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(euv != 9L, g == 9L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(euv != 9L, g == 9L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(euw != 0L, , ),
         band3(euw != 0L, , ))
  exp_eq(and3s(eux != 1L, , ),
         band3(eux != 1L, , ))
  exp_eq(and3s(euy != 9L, , ),
         band3(euy != 9L, , ))
  exp_eq(and3s(euz != 0L, , f %in% 1:4),
         band3(euz != 0L, , f %in% 1:4))
  exp_eq(and3s(eva != 1L, , r %in% 1:4),
         band3(eva != 1L, , r %in% 1:4))
  exp_eq(and3s(evb != 9L, , l %in% 1:4),
         band3(evb != 9L, , l %in% 1:4))
  exp_eq(and3s(evc != 0L, s == 0L, ),
         band3(evc != 0L, s == 0L, ))
  exp_eq(and3s(evd != 1L, m == 1L, ),
         band3(evd != 1L, m == 1L, ))
  exp_eq(and3s(eve != 9L, a == 9L, ),
         band3(eve != 9L, a == 9L, ))
  exp_eq(and3s(evf != 0L, t == 0L, h %in% 1:4),
         band3(evf != 0L, t == 0L, h %in% 1:4))
  exp_eq(and3s(evg != 1L, p == 1L, g %in% 1:4),
         band3(evg != 1L, p == 1L, g %in% 1:4))
  exp_eq(and3s(evh != 9L, i == 9L, b %in% 1:4),
         band3(evh != 9L, i == 9L, b %in% 1:4))
  exp_eq(and3s(evi != 0L, , ),
         band3(evi != 0L, , ))
  exp_eq(and3s(evj != 1L, , ),
         band3(evj != 1L, , ))
  exp_eq(and3s(evk != 9L, , ),
         band3(evk != 9L, , ))
  exp_eq(and3s(evl != 0L, , k < 0L),
         band3(evl != 0L, , k < 0L))
  exp_eq(and3s(evm != 1L, , p < 1L),
         band3(evm != 1L, , p < 1L))
  exp_eq(and3s(evn != 9L, , s < 9L),
         band3(evn != 9L, , s < 9L))
  exp_eq(and3s(evo != 0L, b == 0L, ),
         band3(evo != 0L, b == 0L, ))
  exp_eq(and3s(evp != 1L, o == 1L, ),
         band3(evp != 1L, o == 1L, ))
  exp_eq(and3s(evq != 9L, u == 9L, ),
         band3(evq != 9L, u == 9L, ))
  exp_eq(and3s(evr != 0L, r == 0L, o < 0L),
         band3(evr != 0L, r == 0L, o < 0L))
  exp_eq(and3s(evs != 1L, q == 1L, w < 1L),
         band3(evs != 1L, q == 1L, w < 1L))
  exp_eq(and3s(evt != 9L, q == 9L, p < 9L),
         band3(evt != 9L, q == 9L, p < 9L))
  exp_eq(and3s(evu != 0L, , ),
         band3(evu != 0L, , ))
  exp_eq(and3s(evv != 1L, , ),
         band3(evv != 1L, , ))
  exp_eq(and3s(evw != 9L, , ),
         band3(evw != 9L, , ))
  exp_eq(and3s(evx != 0L, , i <= 0L),
         band3(evx != 0L, , i <= 0L))
  exp_eq(and3s(evy != 1L, , n <= 1L),
         band3(evy != 1L, , n <= 1L))
  exp_eq(and3s(evz != 9L, , v <= 9L),
         band3(evz != 9L, , v <= 9L))
  exp_eq(and3s(ewa != 0L, t == 0L, ),
         band3(ewa != 0L, t == 0L, ))
  exp_eq(and3s(ewb != 1L, p == 1L, ),
         band3(ewb != 1L, p == 1L, ))
  exp_eq(and3s(ewc != 9L, m == 9L, ),
         band3(ewc != 9L, m == 9L, ))
  exp_eq(and3s(ewd != 0L, j == 0L, w <= 0L),
         band3(ewd != 0L, j == 0L, w <= 0L))
  exp_eq(and3s(ewe != 1L, e == 1L, k <= 1L),
         band3(ewe != 1L, e == 1L, k <= 1L))
  exp_eq(and3s(ewf != 9L, u == 9L, e <= 9L),
         band3(ewf != 9L, u == 9L, e <= 9L))
  exp_eq(and3s(ewg != 0L, , ),
         band3(ewg != 0L, , ))
  exp_eq(and3s(ewh != 1L, , ),
         band3(ewh != 1L, , ))
  exp_eq(and3s(ewi != 9L, , ),
         band3(ewi != 9L, , ))
  exp_eq(and3s(ewj != 0L, , y == 0L),
         band3(ewj != 0L, , y == 0L))
  exp_eq(and3s(ewk != 1L, , a == 1L),
         band3(ewk != 1L, , a == 1L))
  exp_eq(and3s(ewl != 9L, , j == 9L),
         band3(ewl != 9L, , j == 9L))
  exp_eq(and3s(ewm != 0L, z == 0L, ),
         band3(ewm != 0L, z == 0L, ))
  exp_eq(and3s(ewn != 1L, n == 1L, ),
         band3(ewn != 1L, n == 1L, ))
  exp_eq(and3s(ewo != 9L, d == 9L, ),
         band3(ewo != 9L, d == 9L, ))
  exp_eq(and3s(ewp != 0L, x == 0L, v == 0L),
         band3(ewp != 0L, x == 0L, v == 0L))
  exp_eq(and3s(ewq != 1L, a == 1L, j == 1L),
         band3(ewq != 1L, a == 1L, j == 1L))
  exp_eq(and3s(ewr != 9L, x == 9L, x == 9L),
         band3(ewr != 9L, x == 9L, x == 9L))
  exp_eq(and3s(ews != 0L, , ),
         band3(ews != 0L, , ))
  exp_eq(and3s(ewt != 1L, , ),
         band3(ewt != 1L, , ))
  exp_eq(and3s(ewu != 9L, , ),
         band3(ewu != 9L, , ))
  exp_eq(and3s(ewv != 0L, , b > 0L),
         band3(ewv != 0L, , b > 0L))
  exp_eq(and3s(eww != 1L, , j > 1L),
         band3(eww != 1L, , j > 1L))
  exp_eq(and3s(ewx != 9L, , j > 9L),
         band3(ewx != 9L, , j > 9L))
  exp_eq(and3s(ewy != 0L, h == 0L, ),
         band3(ewy != 0L, h == 0L, ))
  exp_eq(and3s(ewz != 1L, o == 1L, ),
         band3(ewz != 1L, o == 1L, ))
  exp_eq(and3s(exa != 9L, t == 9L, ),
         band3(exa != 9L, t == 9L, ))
  exp_eq(and3s(exb != 0L, o == 0L, f > 0L),
         band3(exb != 0L, o == 0L, f > 0L))
  exp_eq(and3s(exc != 1L, d == 1L, t > 1L),
         band3(exc != 1L, d == 1L, t > 1L))
  exp_eq(and3s(exd != 9L, q == 9L, l > 9L),
         band3(exd != 9L, q == 9L, l > 9L))
  exp_eq(and3s(exe != 0L, , ),
         band3(exe != 0L, , ))
  exp_eq(and3s(exf != 1L, , ),
         band3(exf != 1L, , ))
  exp_eq(and3s(exg != 9L, , ),
         band3(exg != 9L, , ))
  exp_eq(and3s(exh != 0L, , b >= 0L),
         band3(exh != 0L, , b >= 0L))
  exp_eq(and3s(exi != 1L, , k >= 1L),
         band3(exi != 1L, , k >= 1L))
  exp_eq(and3s(exj != 9L, , e >= 9L),
         band3(exj != 9L, , e >= 9L))
  exp_eq(and3s(exk != 0L, g == 0L, ),
         band3(exk != 0L, g == 0L, ))
  exp_eq(and3s(exl != 1L, a == 1L, ),
         band3(exl != 1L, a == 1L, ))
  exp_eq(and3s(exm != 9L, h == 9L, ),
         band3(exm != 9L, h == 9L, ))
  exp_eq(and3s(exn != 0L, u == 0L, t >= 0L),
         band3(exn != 0L, u == 0L, t >= 0L))
  exp_eq(and3s(exo != 1L, d == 1L, w >= 1L),
         band3(exo != 1L, d == 1L, w >= 1L))
  exp_eq(and3s(exp != 9L, z == 9L, y >= 9L),
         band3(exp != 9L, z == 9L, y >= 9L))
  exp_eq(and3s(exq != 0L, , ),
         band3(exq != 0L, , ))
  exp_eq(and3s(exr != 1L, , ),
         band3(exr != 1L, , ))
  exp_eq(and3s(exs != 9L, , ),
         band3(exs != 9L, , ))
  exp_eq(and3s(ext != 0L, , logi_v),
         band3(ext != 0L, , logi_v))
  exp_eq(and3s(exu != 1L, , logi_a),
         band3(exu != 1L, , logi_a))
  exp_eq(and3s(exv != 9L, , logi_h),
         band3(exv != 9L, , logi_h))
  exp_eq(and3s(exw != 0L, d > 0L, ),
         band3(exw != 0L, d > 0L, ))
  exp_eq(and3s(exx != 1L, m > 1L, ),
         band3(exx != 1L, m > 1L, ))
  exp_eq(and3s(exy != 9L, c > 9L, ),
         band3(exy != 9L, c > 9L, ))
  exp_eq(and3s(exz != 0L, f > 0L, logi_w),
         band3(exz != 0L, f > 0L, logi_w))
  exp_eq(and3s(eya != 1L, d > 1L, logi_x),
         band3(eya != 1L, d > 1L, logi_x))
  exp_eq(and3s(eyb != 9L, h > 9L, logi_i),
         band3(eyb != 9L, h > 9L, logi_i))
  exp_eq(and3s(eyc != 0L, , ),
         band3(eyc != 0L, , ))
  exp_eq(and3s(eyd != 1L, , ),
         band3(eyd != 1L, , ))
  exp_eq(and3s(eye != 9L, , ),
         band3(eye != 9L, , ))
  exp_eq(and3s(eyf != 0L, , !logi_e),
         band3(eyf != 0L, , !logi_e))
  exp_eq(and3s(eyg != 1L, , !logi_a),
         band3(eyg != 1L, , !logi_a))
  exp_eq(and3s(eyh != 9L, , !logi_o),
         band3(eyh != 9L, , !logi_o))
  exp_eq(and3s(eyi != 0L, s > 0L, ),
         band3(eyi != 0L, s > 0L, ))
  exp_eq(and3s(eyj != 1L, n > 1L, ),
         band3(eyj != 1L, n > 1L, ))
  exp_eq(and3s(eyk != 9L, c > 9L, ),
         band3(eyk != 9L, c > 9L, ))
  exp_eq(and3s(eyl != 0L, m > 0L, !logi_v),
         band3(eyl != 0L, m > 0L, !logi_v))
  exp_eq(and3s(eym != 1L, t > 1L, !logi_l),
         band3(eym != 1L, t > 1L, !logi_l))
  exp_eq(and3s(eyn != 9L, m > 9L, !logi_v),
         band3(eyn != 9L, m > 9L, !logi_v))
  exp_eq(and3s(eyo != 0L, , ),
         band3(eyo != 0L, , ))
  exp_eq(and3s(eyp != 1L, , ),
         band3(eyp != 1L, , ))
  exp_eq(and3s(eyq != 9L, , ),
         band3(eyq != 9L, , ))
  exp_eq(and3s(eyr != 0L, , s != 0L),
         band3(eyr != 0L, , s != 0L))
  exp_eq(and3s(eys != 1L, , c != 1L),
         band3(eys != 1L, , c != 1L))
  exp_eq(and3s(eyt != 9L, , a != 9L),
         band3(eyt != 9L, , a != 9L))
  exp_eq(and3s(eyu != 0L, p > 0L, ),
         band3(eyu != 0L, p > 0L, ))
  exp_eq(and3s(eyv != 1L, t > 1L, ),
         band3(eyv != 1L, t > 1L, ))
  exp_eq(and3s(eyw != 9L, b > 9L, ),
         band3(eyw != 9L, b > 9L, ))
  exp_eq(and3s(eyx != 0L, o > 0L, m != 0L),
         band3(eyx != 0L, o > 0L, m != 0L))
  exp_eq(and3s(eyy != 1L, k > 1L, z != 1L),
         band3(eyy != 1L, k > 1L, z != 1L))
  exp_eq(and3s(eyz != 9L, m > 9L, w != 9L),
         band3(eyz != 9L, m > 9L, w != 9L))
  exp_eq(and3s(fa != 0L, , ),
         band3(fa != 0L, , ))
  exp_eq(and3s(fb != 1L, , ),
         band3(fb != 1L, , ))
  exp_eq(and3s(fc != 9L, , ),
         band3(fc != 9L, , ))
  exp_eq(and3s(fd != 0L, , a %between% c(-1L, 1L)),
         band3(fd != 0L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(fe != 1L, , r %between% c(-1L, 1L)),
         band3(fe != 1L, , r %between% c(-1L, 1L)))
  exp_eq(and3s(ff != 9L, , b %between% c(-1L, 1L)),
         band3(ff != 9L, , b %between% c(-1L, 1L)))
  exp_eq(and3s(fg != 0L, z > 0L, ),
         band3(fg != 0L, z > 0L, ))
  exp_eq(and3s(fh != 1L, u > 1L, ),
         band3(fh != 1L, u > 1L, ))
  exp_eq(and3s(fi != 9L, u > 9L, ),
         band3(fi != 9L, u > 9L, ))
  exp_eq(and3s(fj != 0L, v > 0L, b %between% c(-1L, 1L)),
         band3(fj != 0L, v > 0L, b %between% c(-1L, 1L)))
  exp_eq(and3s(fk != 1L, w > 1L, p %between% c(-1L, 1L)),
         band3(fk != 1L, w > 1L, p %between% c(-1L, 1L)))
  exp_eq(and3s(fl != 9L, x > 9L, l %between% c(-1L, 1L)),
         band3(fl != 9L, x > 9L, l %between% c(-1L, 1L)))
  exp_eq(and3s(fm != 0L, , ),
         band3(fm != 0L, , ))
  exp_eq(and3s(fn != 1L, , ),
         band3(fn != 1L, , ))
  exp_eq(and3s(fo != 9L, , ),
         band3(fo != 9L, , ))
  exp_eq(and3s(fp != 0L, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fp != 0L, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fq != 1L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fq != 1L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fr != 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fr != 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fs != 0L, t > 0L, ),
         band3(fs != 0L, t > 0L, ))
  exp_eq(and3s(ft != 1L, d > 1L, ),
         band3(ft != 1L, d > 1L, ))
  exp_eq(and3s(fu != 9L, u > 9L, ),
         band3(fu != 9L, u > 9L, ))
  exp_eq(and3s(fv != 0L, w > 0L, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fv != 0L, w > 0L, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fw != 1L, u > 1L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fw != 1L, u > 1L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fx != 9L, o > 9L, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fx != 9L, o > 9L, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fy != 0L, , ),
         band3(fy != 0L, , ))
  exp_eq(and3s(fz != 1L, , ),
         band3(fz != 1L, , ))
  exp_eq(and3s(faa != 9L, , ),
         band3(faa != 9L, , ))
  exp_eq(and3s(fab != 0L, , w %in% 1:4),
         band3(fab != 0L, , w %in% 1:4))
  exp_eq(and3s(fac != 1L, , b %in% 1:4),
         band3(fac != 1L, , b %in% 1:4))
  exp_eq(and3s(fad != 9L, , n %in% 1:4),
         band3(fad != 9L, , n %in% 1:4))
  exp_eq(and3s(fae != 0L, c > 0L, ),
         band3(fae != 0L, c > 0L, ))
  exp_eq(and3s(faf != 1L, y > 1L, ),
         band3(faf != 1L, y > 1L, ))
  exp_eq(and3s(fag != 9L, v > 9L, ),
         band3(fag != 9L, v > 9L, ))
  exp_eq(and3s(fah != 0L, w > 0L, e %in% 1:4),
         band3(fah != 0L, w > 0L, e %in% 1:4))
  exp_eq(and3s(fai != 1L, r > 1L, h %in% 1:4),
         band3(fai != 1L, r > 1L, h %in% 1:4))
  exp_eq(and3s(faj != 9L, u > 9L, r %in% 1:4),
         band3(faj != 9L, u > 9L, r %in% 1:4))
  exp_eq(and3s(fak != 0L, , ),
         band3(fak != 0L, , ))
  exp_eq(and3s(fal != 1L, , ),
         band3(fal != 1L, , ))
  exp_eq(and3s(fam != 9L, , ),
         band3(fam != 9L, , ))
  exp_eq(and3s(fan != 0L, , e < 0L),
         band3(fan != 0L, , e < 0L))
  exp_eq(and3s(fao != 1L, , p < 1L),
         band3(fao != 1L, , p < 1L))
  exp_eq(and3s(fap != 9L, , c < 9L),
         band3(fap != 9L, , c < 9L))
  exp_eq(and3s(faq != 0L, h > 0L, ),
         band3(faq != 0L, h > 0L, ))
  exp_eq(and3s(far != 1L, c > 1L, ),
         band3(far != 1L, c > 1L, ))
  exp_eq(and3s(fas != 9L, c > 9L, ),
         band3(fas != 9L, c > 9L, ))
  exp_eq(and3s(fat != 0L, c > 0L, h < 0L),
         band3(fat != 0L, c > 0L, h < 0L))
  exp_eq(and3s(fau != 1L, u > 1L, g < 1L),
         band3(fau != 1L, u > 1L, g < 1L))
  exp_eq(and3s(fav != 9L, l > 9L, y < 9L),
         band3(fav != 9L, l > 9L, y < 9L))
  exp_eq(and3s(faw != 0L, , ),
         band3(faw != 0L, , ))
  exp_eq(and3s(fax != 1L, , ),
         band3(fax != 1L, , ))
  exp_eq(and3s(fay != 9L, , ),
         band3(fay != 9L, , ))
  exp_eq(and3s(faz != 0L, , i <= 0L),
         band3(faz != 0L, , i <= 0L))
  exp_eq(and3s(fba != 1L, , w <= 1L),
         band3(fba != 1L, , w <= 1L))
  exp_eq(and3s(fbb != 9L, , e <= 9L),
         band3(fbb != 9L, , e <= 9L))
  exp_eq(and3s(fbc != 0L, x > 0L, ),
         band3(fbc != 0L, x > 0L, ))
  exp_eq(and3s(fbd != 1L, q > 1L, ),
         band3(fbd != 1L, q > 1L, ))
  exp_eq(and3s(fbe != 9L, x > 9L, ),
         band3(fbe != 9L, x > 9L, ))
  exp_eq(and3s(fbf != 0L, x > 0L, e <= 0L),
         band3(fbf != 0L, x > 0L, e <= 0L))
  exp_eq(and3s(fbg != 1L, n > 1L, q <= 1L),
         band3(fbg != 1L, n > 1L, q <= 1L))
  exp_eq(and3s(fbh != 9L, l > 9L, i <= 9L),
         band3(fbh != 9L, l > 9L, i <= 9L))
  exp_eq(and3s(fbi != 0L, , ),
         band3(fbi != 0L, , ))
  exp_eq(and3s(fbj != 1L, , ),
         band3(fbj != 1L, , ))
  exp_eq(and3s(fbk != 9L, , ),
         band3(fbk != 9L, , ))
  exp_eq(and3s(fbl != 0L, , g == 0L),
         band3(fbl != 0L, , g == 0L))
  exp_eq(and3s(fbm != 1L, , y == 1L),
         band3(fbm != 1L, , y == 1L))
  exp_eq(and3s(fbn != 9L, , n == 9L),
         band3(fbn != 9L, , n == 9L))
  exp_eq(and3s(fbo != 0L, b > 0L, ),
         band3(fbo != 0L, b > 0L, ))
  exp_eq(and3s(fbp != 1L, k > 1L, ),
         band3(fbp != 1L, k > 1L, ))
  exp_eq(and3s(fbq != 9L, z > 9L, ),
         band3(fbq != 9L, z > 9L, ))
  exp_eq(and3s(fbr != 0L, l > 0L, y == 0L),
         band3(fbr != 0L, l > 0L, y == 0L))
  exp_eq(and3s(fbs != 1L, m > 1L, b == 1L),
         band3(fbs != 1L, m > 1L, b == 1L))
  exp_eq(and3s(fbt != 9L, s > 9L, m == 9L),
         band3(fbt != 9L, s > 9L, m == 9L))
  exp_eq(and3s(fbu != 0L, , ),
         band3(fbu != 0L, , ))
  exp_eq(and3s(fbv != 1L, , ),
         band3(fbv != 1L, , ))
  exp_eq(and3s(fbw != 9L, , ),
         band3(fbw != 9L, , ))
  exp_eq(and3s(fbx != 0L, , g > 0L),
         band3(fbx != 0L, , g > 0L))
  exp_eq(and3s(fby != 1L, , t > 1L),
         band3(fby != 1L, , t > 1L))
  exp_eq(and3s(fbz != 9L, , c > 9L),
         band3(fbz != 9L, , c > 9L))
  exp_eq(and3s(fca != 0L, x > 0L, ),
         band3(fca != 0L, x > 0L, ))
  exp_eq(and3s(fcb != 1L, i > 1L, ),
         band3(fcb != 1L, i > 1L, ))
  exp_eq(and3s(fcc != 9L, d > 9L, ),
         band3(fcc != 9L, d > 9L, ))
  exp_eq(and3s(fcd != 0L, j > 0L, y > 0L),
         band3(fcd != 0L, j > 0L, y > 0L))
  exp_eq(and3s(fce != 1L, n > 1L, q > 1L),
         band3(fce != 1L, n > 1L, q > 1L))
  exp_eq(and3s(fcf != 9L, q > 9L, x > 9L),
         band3(fcf != 9L, q > 9L, x > 9L))
  exp_eq(and3s(fcg != 0L, , ),
         band3(fcg != 0L, , ))
  exp_eq(and3s(fch != 1L, , ),
         band3(fch != 1L, , ))
  exp_eq(and3s(fci != 9L, , ),
         band3(fci != 9L, , ))
  exp_eq(and3s(fcj != 0L, , u >= 0L),
         band3(fcj != 0L, , u >= 0L))
  exp_eq(and3s(fck != 1L, , z >= 1L),
         band3(fck != 1L, , z >= 1L))
  exp_eq(and3s(fcl != 9L, , w >= 9L),
         band3(fcl != 9L, , w >= 9L))
  exp_eq(and3s(fcm != 0L, w > 0L, ),
         band3(fcm != 0L, w > 0L, ))
  exp_eq(and3s(fcn != 1L, p > 1L, ),
         band3(fcn != 1L, p > 1L, ))
  exp_eq(and3s(fco != 9L, d > 9L, ),
         band3(fco != 9L, d > 9L, ))
  exp_eq(and3s(fcp != 0L, i > 0L, h >= 0L),
         band3(fcp != 0L, i > 0L, h >= 0L))
  exp_eq(and3s(fcq != 1L, s > 1L, w >= 1L),
         band3(fcq != 1L, s > 1L, w >= 1L))
  exp_eq(and3s(fcr != 9L, a > 9L, z >= 9L),
         band3(fcr != 9L, a > 9L, z >= 9L))
  exp_eq(and3s(fcs != 0L, , ),
         band3(fcs != 0L, , ))
  exp_eq(and3s(fct != 1L, , ),
         band3(fct != 1L, , ))
  exp_eq(and3s(fcu != 9L, , ),
         band3(fcu != 9L, , ))
  exp_eq(and3s(fcv != 0L, , logi_m),
         band3(fcv != 0L, , logi_m))
  exp_eq(and3s(fcw != 1L, , logi_u),
         band3(fcw != 1L, , logi_u))
  exp_eq(and3s(fcx != 9L, , logi_f),
         band3(fcx != 9L, , logi_f))
  exp_eq(and3s(fcy != 0L, a >= 0L, ),
         band3(fcy != 0L, a >= 0L, ))
  exp_eq(and3s(fcz != 1L, t >= 1L, ),
         band3(fcz != 1L, t >= 1L, ))
  exp_eq(and3s(fda != 9L, c >= 9L, ),
         band3(fda != 9L, c >= 9L, ))
  exp_eq(and3s(fdb != 0L, a >= 0L, logi_v),
         band3(fdb != 0L, a >= 0L, logi_v))
  exp_eq(and3s(fdc != 1L, d >= 1L, logi_q),
         band3(fdc != 1L, d >= 1L, logi_q))
  exp_eq(and3s(fdd != 9L, v >= 9L, logi_y),
         band3(fdd != 9L, v >= 9L, logi_y))
  exp_eq(and3s(fde != 0L, , ),
         band3(fde != 0L, , ))
  exp_eq(and3s(fdf != 1L, , ),
         band3(fdf != 1L, , ))
  exp_eq(and3s(fdg != 9L, , ),
         band3(fdg != 9L, , ))
  exp_eq(and3s(fdh != 0L, , !logi_x),
         band3(fdh != 0L, , !logi_x))
  exp_eq(and3s(fdi != 1L, , !logi_e),
         band3(fdi != 1L, , !logi_e))
  exp_eq(and3s(fdj != 9L, , !logi_j),
         band3(fdj != 9L, , !logi_j))
  exp_eq(and3s(fdk != 0L, i >= 0L, ),
         band3(fdk != 0L, i >= 0L, ))
  exp_eq(and3s(fdl != 1L, o >= 1L, ),
         band3(fdl != 1L, o >= 1L, ))
  exp_eq(and3s(fdm != 9L, q >= 9L, ),
         band3(fdm != 9L, q >= 9L, ))
  exp_eq(and3s(fdn != 0L, c >= 0L, !logi_a),
         band3(fdn != 0L, c >= 0L, !logi_a))
  exp_eq(and3s(fdo != 1L, u >= 1L, !logi_s),
         band3(fdo != 1L, u >= 1L, !logi_s))
  exp_eq(and3s(fdp != 9L, d >= 9L, !logi_i),
         band3(fdp != 9L, d >= 9L, !logi_i))
  exp_eq(and3s(fdq != 0L, , ),
         band3(fdq != 0L, , ))
  exp_eq(and3s(fdr != 1L, , ),
         band3(fdr != 1L, , ))
  exp_eq(and3s(fds != 9L, , ),
         band3(fds != 9L, , ))
  exp_eq(and3s(fdt != 0L, , n != 0L),
         band3(fdt != 0L, , n != 0L))
  exp_eq(and3s(fdu != 1L, , v != 1L),
         band3(fdu != 1L, , v != 1L))
  exp_eq(and3s(fdv != 9L, , p != 9L),
         band3(fdv != 9L, , p != 9L))
  exp_eq(and3s(fdw != 0L, h >= 0L, ),
         band3(fdw != 0L, h >= 0L, ))
  exp_eq(and3s(fdx != 1L, x >= 1L, ),
         band3(fdx != 1L, x >= 1L, ))
  exp_eq(and3s(fdy != 9L, t >= 9L, ),
         band3(fdy != 9L, t >= 9L, ))
  exp_eq(and3s(fdz != 0L, k >= 0L, h != 0L),
         band3(fdz != 0L, k >= 0L, h != 0L))
  exp_eq(and3s(fea != 1L, b >= 1L, z != 1L),
         band3(fea != 1L, b >= 1L, z != 1L))
  exp_eq(and3s(feb != 9L, k >= 9L, t != 9L),
         band3(feb != 9L, k >= 9L, t != 9L))
  exp_eq(and3s(fec != 0L, , ),
         band3(fec != 0L, , ))
  exp_eq(and3s(fed != 1L, , ),
         band3(fed != 1L, , ))
  exp_eq(and3s(fee != 9L, , ),
         band3(fee != 9L, , ))
  exp_eq(and3s(fef != 0L, , e %between% c(-1L, 1L)),
         band3(fef != 0L, , e %between% c(-1L, 1L)))
  exp_eq(and3s(feg != 1L, , s %between% c(-1L, 1L)),
         band3(feg != 1L, , s %between% c(-1L, 1L)))
  exp_eq(and3s(feh != 9L, , a %between% c(-1L, 1L)),
         band3(feh != 9L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(fei != 0L, a >= 0L, ),
         band3(fei != 0L, a >= 0L, ))
  exp_eq(and3s(fej != 1L, z >= 1L, ),
         band3(fej != 1L, z >= 1L, ))
  exp_eq(and3s(fek != 9L, u >= 9L, ),
         band3(fek != 9L, u >= 9L, ))
  exp_eq(and3s(fel != 0L, z >= 0L, i %between% c(-1L, 1L)),
         band3(fel != 0L, z >= 0L, i %between% c(-1L, 1L)))
  exp_eq(and3s(fem != 1L, m >= 1L, i %between% c(-1L, 1L)),
         band3(fem != 1L, m >= 1L, i %between% c(-1L, 1L)))
  exp_eq(and3s(fen != 9L, d >= 9L, f %between% c(-1L, 1L)),
         band3(fen != 9L, d >= 9L, f %between% c(-1L, 1L)))
  exp_eq(and3s(feo != 0L, , ),
         band3(feo != 0L, , ))
  exp_eq(and3s(fep != 1L, , ),
         band3(fep != 1L, , ))
  exp_eq(and3s(feq != 9L, , ),
         band3(feq != 9L, , ))
  exp_eq(and3s(fer != 0L, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fer != 0L, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fes != 1L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fes != 1L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fet != 9L, , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fet != 9L, , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(feu != 0L, q >= 0L, ),
         band3(feu != 0L, q >= 0L, ))
  exp_eq(and3s(fev != 1L, k >= 1L, ),
         band3(fev != 1L, k >= 1L, ))
  exp_eq(and3s(few != 9L, z >= 9L, ),
         band3(few != 9L, z >= 9L, ))
  exp_eq(and3s(fex != 0L, m >= 0L, l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fex != 0L, m >= 0L, l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fey != 1L, q >= 1L, a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fey != 1L, q >= 1L, a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fez != 9L, u >= 9L, l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fez != 9L, u >= 9L, l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ffa != 0L, , ),
         band3(ffa != 0L, , ))
  exp_eq(and3s(ffb != 1L, , ),
         band3(ffb != 1L, , ))
  exp_eq(and3s(ffc != 9L, , ),
         band3(ffc != 9L, , ))
  exp_eq(and3s(ffd != 0L, , n %in% 1:4),
         band3(ffd != 0L, , n %in% 1:4))
  exp_eq(and3s(ffe != 1L, , l %in% 1:4),
         band3(ffe != 1L, , l %in% 1:4))
  exp_eq(and3s(fff != 9L, , w %in% 1:4),
         band3(fff != 9L, , w %in% 1:4))
  exp_eq(and3s(ffg != 0L, m >= 0L, ),
         band3(ffg != 0L, m >= 0L, ))
  exp_eq(and3s(ffh != 1L, t >= 1L, ),
         band3(ffh != 1L, t >= 1L, ))
  exp_eq(and3s(ffi != 9L, m >= 9L, ),
         band3(ffi != 9L, m >= 9L, ))
  exp_eq(and3s(ffj != 0L, v >= 0L, x %in% 1:4),
         band3(ffj != 0L, v >= 0L, x %in% 1:4))
  exp_eq(and3s(ffk != 1L, w >= 1L, x %in% 1:4),
         band3(ffk != 1L, w >= 1L, x %in% 1:4))
  exp_eq(and3s(ffl != 9L, n >= 9L, h %in% 1:4),
         band3(ffl != 9L, n >= 9L, h %in% 1:4))
  exp_eq(and3s(ffm != 0L, , ),
         band3(ffm != 0L, , ))
  exp_eq(and3s(ffn != 1L, , ),
         band3(ffn != 1L, , ))
  exp_eq(and3s(ffo != 9L, , ),
         band3(ffo != 9L, , ))
  exp_eq(and3s(ffp != 0L, , c < 0L),
         band3(ffp != 0L, , c < 0L))
  exp_eq(and3s(ffq != 1L, , l < 1L),
         band3(ffq != 1L, , l < 1L))
  exp_eq(and3s(ffr != 9L, , m < 9L),
         band3(ffr != 9L, , m < 9L))
  exp_eq(and3s(ffs != 0L, l >= 0L, ),
         band3(ffs != 0L, l >= 0L, ))
  exp_eq(and3s(fft != 1L, v >= 1L, ),
         band3(fft != 1L, v >= 1L, ))
  exp_eq(and3s(ffu != 9L, x >= 9L, ),
         band3(ffu != 9L, x >= 9L, ))
  exp_eq(and3s(ffv != 0L, v >= 0L, h < 0L),
         band3(ffv != 0L, v >= 0L, h < 0L))
  exp_eq(and3s(ffw != 1L, h >= 1L, d < 1L),
         band3(ffw != 1L, h >= 1L, d < 1L))
  exp_eq(and3s(ffx != 9L, w >= 9L, o < 9L),
         band3(ffx != 9L, w >= 9L, o < 9L))
  exp_eq(and3s(ffy != 0L, , ),
         band3(ffy != 0L, , ))
  exp_eq(and3s(ffz != 1L, , ),
         band3(ffz != 1L, , ))
  exp_eq(and3s(fga != 9L, , ),
         band3(fga != 9L, , ))
  exp_eq(and3s(fgb != 0L, , d <= 0L),
         band3(fgb != 0L, , d <= 0L))
  exp_eq(and3s(fgc != 1L, , x <= 1L),
         band3(fgc != 1L, , x <= 1L))
  exp_eq(and3s(fgd != 9L, , l <= 9L),
         band3(fgd != 9L, , l <= 9L))
  exp_eq(and3s(fge != 0L, w >= 0L, ),
         band3(fge != 0L, w >= 0L, ))
  exp_eq(and3s(fgf != 1L, k >= 1L, ),
         band3(fgf != 1L, k >= 1L, ))
  exp_eq(and3s(fgg != 9L, v >= 9L, ),
         band3(fgg != 9L, v >= 9L, ))
  exp_eq(and3s(fgh != 0L, y >= 0L, o <= 0L),
         band3(fgh != 0L, y >= 0L, o <= 0L))
  exp_eq(and3s(fgi != 1L, t >= 1L, z <= 1L),
         band3(fgi != 1L, t >= 1L, z <= 1L))
  exp_eq(and3s(fgj != 9L, p >= 9L, y <= 9L),
         band3(fgj != 9L, p >= 9L, y <= 9L))
  exp_eq(and3s(fgk != 0L, , ),
         band3(fgk != 0L, , ))
  exp_eq(and3s(fgl != 1L, , ),
         band3(fgl != 1L, , ))
  exp_eq(and3s(fgm != 9L, , ),
         band3(fgm != 9L, , ))
  exp_eq(and3s(fgn != 0L, , w == 0L),
         band3(fgn != 0L, , w == 0L))
  exp_eq(and3s(fgo != 1L, , f == 1L),
         band3(fgo != 1L, , f == 1L))
  exp_eq(and3s(fgp != 9L, , c == 9L),
         band3(fgp != 9L, , c == 9L))
  exp_eq(and3s(fgq != 0L, n >= 0L, ),
         band3(fgq != 0L, n >= 0L, ))
  exp_eq(and3s(fgr != 1L, v >= 1L, ),
         band3(fgr != 1L, v >= 1L, ))
  exp_eq(and3s(fgs != 9L, y >= 9L, ),
         band3(fgs != 9L, y >= 9L, ))
  exp_eq(and3s(fgt != 0L, k >= 0L, n == 0L),
         band3(fgt != 0L, k >= 0L, n == 0L))
  exp_eq(and3s(fgu != 1L, u >= 1L, e == 1L),
         band3(fgu != 1L, u >= 1L, e == 1L))
  exp_eq(and3s(fgv != 9L, d >= 9L, n == 9L),
         band3(fgv != 9L, d >= 9L, n == 9L))
  exp_eq(and3s(fgw != 0L, , ),
         band3(fgw != 0L, , ))
  exp_eq(and3s(fgx != 1L, , ),
         band3(fgx != 1L, , ))
  exp_eq(and3s(fgy != 9L, , ),
         band3(fgy != 9L, , ))
  exp_eq(and3s(fgz != 0L, , v > 0L),
         band3(fgz != 0L, , v > 0L))
  exp_eq(and3s(fha != 1L, , m > 1L),
         band3(fha != 1L, , m > 1L))
  exp_eq(and3s(fhb != 9L, , b > 9L),
         band3(fhb != 9L, , b > 9L))
  exp_eq(and3s(fhc != 0L, y >= 0L, ),
         band3(fhc != 0L, y >= 0L, ))
  exp_eq(and3s(fhd != 1L, k >= 1L, ),
         band3(fhd != 1L, k >= 1L, ))
  exp_eq(and3s(fhe != 9L, t >= 9L, ),
         band3(fhe != 9L, t >= 9L, ))
  exp_eq(and3s(fhf != 0L, n >= 0L, t > 0L),
         band3(fhf != 0L, n >= 0L, t > 0L))
  exp_eq(and3s(fhg != 1L, g >= 1L, s > 1L),
         band3(fhg != 1L, g >= 1L, s > 1L))
  exp_eq(and3s(fhh != 9L, f >= 9L, i > 9L),
         band3(fhh != 9L, f >= 9L, i > 9L))
  exp_eq(and3s(fhi != 0L, , ),
         band3(fhi != 0L, , ))
  exp_eq(and3s(fhj != 1L, , ),
         band3(fhj != 1L, , ))
  exp_eq(and3s(fhk != 9L, , ),
         band3(fhk != 9L, , ))
  exp_eq(and3s(fhl != 0L, , h >= 0L),
         band3(fhl != 0L, , h >= 0L))
  exp_eq(and3s(fhm != 1L, , n >= 1L),
         band3(fhm != 1L, , n >= 1L))
  exp_eq(and3s(fhn != 9L, , n >= 9L),
         band3(fhn != 9L, , n >= 9L))
  exp_eq(and3s(fho != 0L, p >= 0L, ),
         band3(fho != 0L, p >= 0L, ))
  exp_eq(and3s(fhp != 1L, b >= 1L, ),
         band3(fhp != 1L, b >= 1L, ))
  exp_eq(and3s(fhq != 9L, b >= 9L, ),
         band3(fhq != 9L, b >= 9L, ))
  exp_eq(and3s(fhr != 0L, e >= 0L, c >= 0L),
         band3(fhr != 0L, e >= 0L, c >= 0L))
  exp_eq(and3s(fhs != 1L, t >= 1L, k >= 1L),
         band3(fhs != 1L, t >= 1L, k >= 1L))
  exp_eq(and3s(fht != 9L, t >= 9L, g >= 9L),
         band3(fht != 9L, t >= 9L, g >= 9L))
  exp_eq(and3s(fhu %between% c(-1L, 1L), , ),
         band3(fhu %between% c(-1L, 1L), , ))
  exp_eq(and3s(fhv %between% c(-1L, 1L), , ),
         band3(fhv %between% c(-1L, 1L), , ))
  exp_eq(and3s(fhw %between% c(-1L, 1L), , ),
         band3(fhw %between% c(-1L, 1L), , ))
  exp_eq(and3s(fhx %between% c(-1L, 1L), , logi_m),
         band3(fhx %between% c(-1L, 1L), , logi_m))
  exp_eq(and3s(fhy %between% c(-1L, 1L), , logi_e),
         band3(fhy %between% c(-1L, 1L), , logi_e))
  exp_eq(and3s(fhz %between% c(-1L, 1L), , logi_y),
         band3(fhz %between% c(-1L, 1L), , logi_y))
  exp_eq(and3s(fia %between% c(-1L, 1L), logi_k, ),
         band3(fia %between% c(-1L, 1L), logi_k, ))
  exp_eq(and3s(fib %between% c(-1L, 1L), logi_e, ),
         band3(fib %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fic %between% c(-1L, 1L), logi_m, ),
         band3(fic %between% c(-1L, 1L), logi_m, ))
  exp_eq(and3s(fid %between% c(-1L, 1L), logi_n, logi_f),
         band3(fid %between% c(-1L, 1L), logi_n, logi_f))
  exp_eq(and3s(fie %between% c(-1L, 1L), logi_e, logi_k),
         band3(fie %between% c(-1L, 1L), logi_e, logi_k))
  exp_eq(and3s(fif %between% c(-1L, 1L), logi_n, logi_m),
         band3(fif %between% c(-1L, 1L), logi_n, logi_m))
  exp_eq(and3s(fig %between% c(-1L, 1L), , ),
         band3(fig %between% c(-1L, 1L), , ))
  exp_eq(and3s(fih %between% c(-1L, 1L), , ),
         band3(fih %between% c(-1L, 1L), , ))
  exp_eq(and3s(fii %between% c(-1L, 1L), , ),
         band3(fii %between% c(-1L, 1L), , ))
  exp_eq(and3s(fij %between% c(-1L, 1L), , !logi_c),
         band3(fij %between% c(-1L, 1L), , !logi_c))
  exp_eq(and3s(fik %between% c(-1L, 1L), , !logi_i),
         band3(fik %between% c(-1L, 1L), , !logi_i))
  exp_eq(and3s(fil %between% c(-1L, 1L), , !logi_n),
         band3(fil %between% c(-1L, 1L), , !logi_n))
  exp_eq(and3s(fim %between% c(-1L, 1L), logi_n, ),
         band3(fim %between% c(-1L, 1L), logi_n, ))
  exp_eq(and3s(fin %between% c(-1L, 1L), logi_g, ),
         band3(fin %between% c(-1L, 1L), logi_g, ))
  exp_eq(and3s(fio %between% c(-1L, 1L), logi_r, ),
         band3(fio %between% c(-1L, 1L), logi_r, ))
  exp_eq(and3s(fip %between% c(-1L, 1L), logi_a, !logi_n),
         band3(fip %between% c(-1L, 1L), logi_a, !logi_n))
  exp_eq(and3s(fiq %between% c(-1L, 1L), logi_g, !logi_a),
         band3(fiq %between% c(-1L, 1L), logi_g, !logi_a))
  exp_eq(and3s(fir %between% c(-1L, 1L), logi_t, !logi_h),
         band3(fir %between% c(-1L, 1L), logi_t, !logi_h))
  exp_eq(and3s(fis %between% c(-1L, 1L), , ),
         band3(fis %between% c(-1L, 1L), , ))
  exp_eq(and3s(fit %between% c(-1L, 1L), , ),
         band3(fit %between% c(-1L, 1L), , ))
  exp_eq(and3s(fiu %between% c(-1L, 1L), , ),
         band3(fiu %between% c(-1L, 1L), , ))
  exp_eq(and3s(fiv %between% c(-1L, 1L), , w != 0L),
         band3(fiv %between% c(-1L, 1L), , w != 0L))
  exp_eq(and3s(fiw %between% c(-1L, 1L), , t != 1L),
         band3(fiw %between% c(-1L, 1L), , t != 1L))
  exp_eq(and3s(fix %between% c(-1L, 1L), , u != 9L),
         band3(fix %between% c(-1L, 1L), , u != 9L))
  exp_eq(and3s(fiy %between% c(-1L, 1L), logi_y, ),
         band3(fiy %between% c(-1L, 1L), logi_y, ))
  exp_eq(and3s(fiz %between% c(-1L, 1L), logi_q, ),
         band3(fiz %between% c(-1L, 1L), logi_q, ))
  exp_eq(and3s(fja %between% c(-1L, 1L), logi_a, ),
         band3(fja %between% c(-1L, 1L), logi_a, ))
  exp_eq(and3s(fjb %between% c(-1L, 1L), logi_l, u != 0L),
         band3(fjb %between% c(-1L, 1L), logi_l, u != 0L))
  exp_eq(and3s(fjc %between% c(-1L, 1L), logi_b, g != 1L),
         band3(fjc %between% c(-1L, 1L), logi_b, g != 1L))
  exp_eq(and3s(fjd %between% c(-1L, 1L), logi_e, v != 9L),
         band3(fjd %between% c(-1L, 1L), logi_e, v != 9L))
  exp_eq(and3s(fje %between% c(-1L, 1L), , ),
         band3(fje %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjf %between% c(-1L, 1L), , ),
         band3(fjf %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjg %between% c(-1L, 1L), , ),
         band3(fjg %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjh %between% c(-1L, 1L), , x %between% c(-1L, 1L)),
         band3(fjh %between% c(-1L, 1L), , x %between% c(-1L, 1L)))
  exp_eq(and3s(fji %between% c(-1L, 1L), , c %between% c(-1L, 1L)),
         band3(fji %between% c(-1L, 1L), , c %between% c(-1L, 1L)))
  exp_eq(and3s(fjj %between% c(-1L, 1L), , u %between% c(-1L, 1L)),
         band3(fjj %between% c(-1L, 1L), , u %between% c(-1L, 1L)))
  exp_eq(and3s(fjk %between% c(-1L, 1L), logi_t, ),
         band3(fjk %between% c(-1L, 1L), logi_t, ))
  exp_eq(and3s(fjl %between% c(-1L, 1L), logi_e, ),
         band3(fjl %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fjm %between% c(-1L, 1L), logi_r, ),
         band3(fjm %between% c(-1L, 1L), logi_r, ))
  exp_eq(and3s(fjn %between% c(-1L, 1L), logi_e, h %between% c(-1L, 1L)),
         band3(fjn %between% c(-1L, 1L), logi_e, h %between% c(-1L, 1L)))
  exp_eq(and3s(fjo %between% c(-1L, 1L), logi_m, y %between% c(-1L, 1L)),
         band3(fjo %between% c(-1L, 1L), logi_m, y %between% c(-1L, 1L)))
  exp_eq(and3s(fjp %between% c(-1L, 1L), logi_g, a %between% c(-1L, 1L)),
         band3(fjp %between% c(-1L, 1L), logi_g, a %between% c(-1L, 1L)))
  exp_eq(and3s(fjq %between% c(-1L, 1L), , ),
         band3(fjq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjr %between% c(-1L, 1L), , ),
         band3(fjr %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjs %between% c(-1L, 1L), , ),
         band3(fjs %between% c(-1L, 1L), , ))
  exp_eq(and3s(fjt %between% c(-1L, 1L), , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fjt %between% c(-1L, 1L), , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fju %between% c(-1L, 1L), , y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fju %between% c(-1L, 1L), , y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fjv %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fjv %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fjw %between% c(-1L, 1L), logi_k, ),
         band3(fjw %between% c(-1L, 1L), logi_k, ))
  exp_eq(and3s(fjx %between% c(-1L, 1L), logi_d, ),
         band3(fjx %between% c(-1L, 1L), logi_d, ))
  exp_eq(and3s(fjy %between% c(-1L, 1L), logi_x, ),
         band3(fjy %between% c(-1L, 1L), logi_x, ))
  exp_eq(and3s(fjz %between% c(-1L, 1L), logi_c, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fjz %between% c(-1L, 1L), logi_c, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fka %between% c(-1L, 1L), logi_l, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fka %between% c(-1L, 1L), logi_l, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fkb %between% c(-1L, 1L), logi_q, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fkb %between% c(-1L, 1L), logi_q, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fkc %between% c(-1L, 1L), , ),
         band3(fkc %between% c(-1L, 1L), , ))
  exp_eq(and3s(fkd %between% c(-1L, 1L), , ),
         band3(fkd %between% c(-1L, 1L), , ))
  exp_eq(and3s(fke %between% c(-1L, 1L), , ),
         band3(fke %between% c(-1L, 1L), , ))
  exp_eq(and3s(fkf %between% c(-1L, 1L), , h %in% 1:4),
         band3(fkf %between% c(-1L, 1L), , h %in% 1:4))
  exp_eq(and3s(fkg %between% c(-1L, 1L), , v %in% 1:4),
         band3(fkg %between% c(-1L, 1L), , v %in% 1:4))
  exp_eq(and3s(fkh %between% c(-1L, 1L), , w %in% 1:4),
         band3(fkh %between% c(-1L, 1L), , w %in% 1:4))
  exp_eq(and3s(fki %between% c(-1L, 1L), logi_e, ),
         band3(fki %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fkj %between% c(-1L, 1L), logi_x, ),
         band3(fkj %between% c(-1L, 1L), logi_x, ))
  exp_eq(and3s(fkk %between% c(-1L, 1L), logi_s, ),
         band3(fkk %between% c(-1L, 1L), logi_s, ))
  exp_eq(and3s(fkl %between% c(-1L, 1L), logi_w, a %in% 1:4),
         band3(fkl %between% c(-1L, 1L), logi_w, a %in% 1:4))
  exp_eq(and3s(fkm %between% c(-1L, 1L), logi_b, r %in% 1:4),
         band3(fkm %between% c(-1L, 1L), logi_b, r %in% 1:4))
  exp_eq(and3s(fkn %between% c(-1L, 1L), logi_k, a %in% 1:4),
         band3(fkn %between% c(-1L, 1L), logi_k, a %in% 1:4))
  exp_eq(and3s(fko %between% c(-1L, 1L), , ),
         band3(fko %between% c(-1L, 1L), , ))
  exp_eq(and3s(fkp %between% c(-1L, 1L), , ),
         band3(fkp %between% c(-1L, 1L), , ))
  exp_eq(and3s(fkq %between% c(-1L, 1L), , ),
         band3(fkq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fkr %between% c(-1L, 1L), , e < 0L),
         band3(fkr %between% c(-1L, 1L), , e < 0L))
  exp_eq(and3s(fks %between% c(-1L, 1L), , n < 1L),
         band3(fks %between% c(-1L, 1L), , n < 1L))
  exp_eq(and3s(fkt %between% c(-1L, 1L), , a < 9L),
         band3(fkt %between% c(-1L, 1L), , a < 9L))
  exp_eq(and3s(fku %between% c(-1L, 1L), logi_e, ),
         band3(fku %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fkv %between% c(-1L, 1L), logi_i, ),
         band3(fkv %between% c(-1L, 1L), logi_i, ))
  exp_eq(and3s(fkw %between% c(-1L, 1L), logi_o, ),
         band3(fkw %between% c(-1L, 1L), logi_o, ))
  exp_eq(and3s(fkx %between% c(-1L, 1L), logi_e, m < 0L),
         band3(fkx %between% c(-1L, 1L), logi_e, m < 0L))
  exp_eq(and3s(fky %between% c(-1L, 1L), logi_d, d < 1L),
         band3(fky %between% c(-1L, 1L), logi_d, d < 1L))
  exp_eq(and3s(fkz %between% c(-1L, 1L), logi_u, a < 9L),
         band3(fkz %between% c(-1L, 1L), logi_u, a < 9L))
  exp_eq(and3s(fla %between% c(-1L, 1L), , ),
         band3(fla %between% c(-1L, 1L), , ))
  exp_eq(and3s(flb %between% c(-1L, 1L), , ),
         band3(flb %between% c(-1L, 1L), , ))
  exp_eq(and3s(flc %between% c(-1L, 1L), , ),
         band3(flc %between% c(-1L, 1L), , ))
  exp_eq(and3s(fld %between% c(-1L, 1L), , s <= 0L),
         band3(fld %between% c(-1L, 1L), , s <= 0L))
  exp_eq(and3s(fle %between% c(-1L, 1L), , w <= 1L),
         band3(fle %between% c(-1L, 1L), , w <= 1L))
  exp_eq(and3s(flf %between% c(-1L, 1L), , f <= 9L),
         band3(flf %between% c(-1L, 1L), , f <= 9L))
  exp_eq(and3s(flg %between% c(-1L, 1L), logi_g, ),
         band3(flg %between% c(-1L, 1L), logi_g, ))
  exp_eq(and3s(flh %between% c(-1L, 1L), logi_t, ),
         band3(flh %between% c(-1L, 1L), logi_t, ))
  exp_eq(and3s(fli %between% c(-1L, 1L), logi_e, ),
         band3(fli %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(flj %between% c(-1L, 1L), logi_o, s <= 0L),
         band3(flj %between% c(-1L, 1L), logi_o, s <= 0L))
  exp_eq(and3s(flk %between% c(-1L, 1L), logi_n, c <= 1L),
         band3(flk %between% c(-1L, 1L), logi_n, c <= 1L))
  exp_eq(and3s(fll %between% c(-1L, 1L), logi_n, c <= 9L),
         band3(fll %between% c(-1L, 1L), logi_n, c <= 9L))
  exp_eq(and3s(flm %between% c(-1L, 1L), , ),
         band3(flm %between% c(-1L, 1L), , ))
  exp_eq(and3s(fln %between% c(-1L, 1L), , ),
         band3(fln %between% c(-1L, 1L), , ))
  exp_eq(and3s(flo %between% c(-1L, 1L), , ),
         band3(flo %between% c(-1L, 1L), , ))
  exp_eq(and3s(flp %between% c(-1L, 1L), , a == 0L),
         band3(flp %between% c(-1L, 1L), , a == 0L))
  exp_eq(and3s(flq %between% c(-1L, 1L), , p == 1L),
         band3(flq %between% c(-1L, 1L), , p == 1L))
  exp_eq(and3s(flr %between% c(-1L, 1L), , k == 9L),
         band3(flr %between% c(-1L, 1L), , k == 9L))
  exp_eq(and3s(fls %between% c(-1L, 1L), logi_n, ),
         band3(fls %between% c(-1L, 1L), logi_n, ))
  exp_eq(and3s(flt %between% c(-1L, 1L), logi_e, ),
         band3(flt %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(flu %between% c(-1L, 1L), logi_s, ),
         band3(flu %between% c(-1L, 1L), logi_s, ))
  exp_eq(and3s(flv %between% c(-1L, 1L), logi_d, f == 0L),
         band3(flv %between% c(-1L, 1L), logi_d, f == 0L))
  exp_eq(and3s(flw %between% c(-1L, 1L), logi_a, g == 1L),
         band3(flw %between% c(-1L, 1L), logi_a, g == 1L))
  exp_eq(and3s(flx %between% c(-1L, 1L), logi_b, q == 9L),
         band3(flx %between% c(-1L, 1L), logi_b, q == 9L))
  exp_eq(and3s(fly %between% c(-1L, 1L), , ),
         band3(fly %between% c(-1L, 1L), , ))
  exp_eq(and3s(flz %between% c(-1L, 1L), , ),
         band3(flz %between% c(-1L, 1L), , ))
  exp_eq(and3s(fma %between% c(-1L, 1L), , ),
         band3(fma %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmb %between% c(-1L, 1L), , p > 0L),
         band3(fmb %between% c(-1L, 1L), , p > 0L))
  exp_eq(and3s(fmc %between% c(-1L, 1L), , y > 1L),
         band3(fmc %between% c(-1L, 1L), , y > 1L))
  exp_eq(and3s(fmd %between% c(-1L, 1L), , u > 9L),
         band3(fmd %between% c(-1L, 1L), , u > 9L))
  exp_eq(and3s(fme %between% c(-1L, 1L), logi_c, ),
         band3(fme %between% c(-1L, 1L), logi_c, ))
  exp_eq(and3s(fmf %between% c(-1L, 1L), logi_e, ),
         band3(fmf %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fmg %between% c(-1L, 1L), logi_k, ),
         band3(fmg %between% c(-1L, 1L), logi_k, ))
  exp_eq(and3s(fmh %between% c(-1L, 1L), logi_k, n > 0L),
         band3(fmh %between% c(-1L, 1L), logi_k, n > 0L))
  exp_eq(and3s(fmi %between% c(-1L, 1L), logi_g, q > 1L),
         band3(fmi %between% c(-1L, 1L), logi_g, q > 1L))
  exp_eq(and3s(fmj %between% c(-1L, 1L), logi_t, r > 9L),
         band3(fmj %between% c(-1L, 1L), logi_t, r > 9L))
  exp_eq(and3s(fmk %between% c(-1L, 1L), , ),
         band3(fmk %between% c(-1L, 1L), , ))
  exp_eq(and3s(fml %between% c(-1L, 1L), , ),
         band3(fml %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmm %between% c(-1L, 1L), , ),
         band3(fmm %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmn %between% c(-1L, 1L), , b >= 0L),
         band3(fmn %between% c(-1L, 1L), , b >= 0L))
  exp_eq(and3s(fmo %between% c(-1L, 1L), , l >= 1L),
         band3(fmo %between% c(-1L, 1L), , l >= 1L))
  exp_eq(and3s(fmp %between% c(-1L, 1L), , v >= 9L),
         band3(fmp %between% c(-1L, 1L), , v >= 9L))
  exp_eq(and3s(fmq %between% c(-1L, 1L), logi_e, ),
         band3(fmq %between% c(-1L, 1L), logi_e, ))
  exp_eq(and3s(fmr %between% c(-1L, 1L), logi_h, ),
         band3(fmr %between% c(-1L, 1L), logi_h, ))
  exp_eq(and3s(fms %between% c(-1L, 1L), logi_v, ),
         band3(fms %between% c(-1L, 1L), logi_v, ))
  exp_eq(and3s(fmt %between% c(-1L, 1L), logi_u, b >= 0L),
         band3(fmt %between% c(-1L, 1L), logi_u, b >= 0L))
  exp_eq(and3s(fmu %between% c(-1L, 1L), logi_w, v >= 1L),
         band3(fmu %between% c(-1L, 1L), logi_w, v >= 1L))
  exp_eq(and3s(fmv %between% c(-1L, 1L), logi_d, l >= 9L),
         band3(fmv %between% c(-1L, 1L), logi_d, l >= 9L))
  exp_eq(and3s(fmw %between% c(-1L, 1L), , ),
         band3(fmw %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmx %between% c(-1L, 1L), , ),
         band3(fmx %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmy %between% c(-1L, 1L), , ),
         band3(fmy %between% c(-1L, 1L), , ))
  exp_eq(and3s(fmz %between% c(-1L, 1L), , logi_w),
         band3(fmz %between% c(-1L, 1L), , logi_w))
  exp_eq(and3s(fna %between% c(-1L, 1L), , logi_w),
         band3(fna %between% c(-1L, 1L), , logi_w))
  exp_eq(and3s(fnb %between% c(-1L, 1L), , logi_f),
         band3(fnb %between% c(-1L, 1L), , logi_f))
  exp_eq(and3s(fnc %between% c(-1L, 1L), !logi_m, ),
         band3(fnc %between% c(-1L, 1L), !logi_m, ))
  exp_eq(and3s(fnd %between% c(-1L, 1L), !logi_z, ),
         band3(fnd %between% c(-1L, 1L), !logi_z, ))
  exp_eq(and3s(fne %between% c(-1L, 1L), !logi_s, ),
         band3(fne %between% c(-1L, 1L), !logi_s, ))
  exp_eq(and3s(fnf %between% c(-1L, 1L), !logi_r, logi_q),
         band3(fnf %between% c(-1L, 1L), !logi_r, logi_q))
  exp_eq(and3s(fng %between% c(-1L, 1L), !logi_d, logi_y),
         band3(fng %between% c(-1L, 1L), !logi_d, logi_y))
  exp_eq(and3s(fnh %between% c(-1L, 1L), !logi_f, logi_b),
         band3(fnh %between% c(-1L, 1L), !logi_f, logi_b))
  exp_eq(and3s(fni %between% c(-1L, 1L), , ),
         band3(fni %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnj %between% c(-1L, 1L), , ),
         band3(fnj %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnk %between% c(-1L, 1L), , ),
         band3(fnk %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnl %between% c(-1L, 1L), , !logi_j),
         band3(fnl %between% c(-1L, 1L), , !logi_j))
  exp_eq(and3s(fnm %between% c(-1L, 1L), , !logi_b),
         band3(fnm %between% c(-1L, 1L), , !logi_b))
  exp_eq(and3s(fnn %between% c(-1L, 1L), , !logi_f),
         band3(fnn %between% c(-1L, 1L), , !logi_f))
  exp_eq(and3s(fno %between% c(-1L, 1L), !logi_n, ),
         band3(fno %between% c(-1L, 1L), !logi_n, ))
  exp_eq(and3s(fnp %between% c(-1L, 1L), !logi_e, ),
         band3(fnp %between% c(-1L, 1L), !logi_e, ))
  exp_eq(and3s(fnq %between% c(-1L, 1L), !logi_u, ),
         band3(fnq %between% c(-1L, 1L), !logi_u, ))
  exp_eq(and3s(fnr %between% c(-1L, 1L), !logi_x, !logi_p),
         band3(fnr %between% c(-1L, 1L), !logi_x, !logi_p))
  exp_eq(and3s(fns %between% c(-1L, 1L), !logi_z, !logi_n),
         band3(fns %between% c(-1L, 1L), !logi_z, !logi_n))
  exp_eq(and3s(fnt %between% c(-1L, 1L), !logi_m, !logi_l),
         band3(fnt %between% c(-1L, 1L), !logi_m, !logi_l))
  exp_eq(and3s(fnu %between% c(-1L, 1L), , ),
         band3(fnu %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnv %between% c(-1L, 1L), , ),
         band3(fnv %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnw %between% c(-1L, 1L), , ),
         band3(fnw %between% c(-1L, 1L), , ))
  exp_eq(and3s(fnx %between% c(-1L, 1L), , b != 0L),
         band3(fnx %between% c(-1L, 1L), , b != 0L))
  exp_eq(and3s(fny %between% c(-1L, 1L), , y != 1L),
         band3(fny %between% c(-1L, 1L), , y != 1L))
  exp_eq(and3s(fnz %between% c(-1L, 1L), , s != 9L),
         band3(fnz %between% c(-1L, 1L), , s != 9L))
  exp_eq(and3s(foa %between% c(-1L, 1L), !logi_j, ),
         band3(foa %between% c(-1L, 1L), !logi_j, ))
  exp_eq(and3s(fob %between% c(-1L, 1L), !logi_m, ),
         band3(fob %between% c(-1L, 1L), !logi_m, ))
  exp_eq(and3s(foc %between% c(-1L, 1L), !logi_y, ),
         band3(foc %between% c(-1L, 1L), !logi_y, ))
  exp_eq(and3s(fod %between% c(-1L, 1L), !logi_k, g != 0L),
         band3(fod %between% c(-1L, 1L), !logi_k, g != 0L))
  exp_eq(and3s(foe %between% c(-1L, 1L), !logi_b, u != 1L),
         band3(foe %between% c(-1L, 1L), !logi_b, u != 1L))
  exp_eq(and3s(fof %between% c(-1L, 1L), !logi_q, s != 9L),
         band3(fof %between% c(-1L, 1L), !logi_q, s != 9L))
  exp_eq(and3s(fog %between% c(-1L, 1L), , ),
         band3(fog %between% c(-1L, 1L), , ))
  exp_eq(and3s(foh %between% c(-1L, 1L), , ),
         band3(foh %between% c(-1L, 1L), , ))
  exp_eq(and3s(foi %between% c(-1L, 1L), , ),
         band3(foi %between% c(-1L, 1L), , ))
  exp_eq(and3s(foj %between% c(-1L, 1L), , o %between% c(-1L, 1L)),
         band3(foj %between% c(-1L, 1L), , o %between% c(-1L, 1L)))
  exp_eq(and3s(fok %between% c(-1L, 1L), , v %between% c(-1L, 1L)),
         band3(fok %between% c(-1L, 1L), , v %between% c(-1L, 1L)))
  exp_eq(and3s(fol %between% c(-1L, 1L), , h %between% c(-1L, 1L)),
         band3(fol %between% c(-1L, 1L), , h %between% c(-1L, 1L)))
  exp_eq(and3s(fom %between% c(-1L, 1L), !logi_w, ),
         band3(fom %between% c(-1L, 1L), !logi_w, ))
  exp_eq(and3s(fon %between% c(-1L, 1L), !logi_k, ),
         band3(fon %between% c(-1L, 1L), !logi_k, ))
  exp_eq(and3s(foo %between% c(-1L, 1L), !logi_w, ),
         band3(foo %between% c(-1L, 1L), !logi_w, ))
  exp_eq(and3s(fop %between% c(-1L, 1L), !logi_y, p %between% c(-1L, 1L)),
         band3(fop %between% c(-1L, 1L), !logi_y, p %between% c(-1L, 1L)))
  exp_eq(and3s(foq %between% c(-1L, 1L), !logi_b, h %between% c(-1L, 1L)),
         band3(foq %between% c(-1L, 1L), !logi_b, h %between% c(-1L, 1L)))
  exp_eq(and3s(FOR %between% c(-1L, 1L), !logi_h, v %between% c(-1L, 1L)),
         band3(FOR %between% c(-1L, 1L), !logi_h, v %between% c(-1L, 1L)))
  exp_eq(and3s(fos %between% c(-1L, 1L), , ),
         band3(fos %between% c(-1L, 1L), , ))
  exp_eq(and3s(fot %between% c(-1L, 1L), , ),
         band3(fot %between% c(-1L, 1L), , ))
  exp_eq(and3s(fou %between% c(-1L, 1L), , ),
         band3(fou %between% c(-1L, 1L), , ))
  exp_eq(and3s(fov %between% c(-1L, 1L), , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fov %between% c(-1L, 1L), , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fow %between% c(-1L, 1L), , s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fow %between% c(-1L, 1L), , s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fox %between% c(-1L, 1L), , d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fox %between% c(-1L, 1L), , d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(foy %between% c(-1L, 1L), !logi_x, ),
         band3(foy %between% c(-1L, 1L), !logi_x, ))
  exp_eq(and3s(foz %between% c(-1L, 1L), !logi_b, ),
         band3(foz %between% c(-1L, 1L), !logi_b, ))
  exp_eq(and3s(fpa %between% c(-1L, 1L), !logi_o, ),
         band3(fpa %between% c(-1L, 1L), !logi_o, ))
  exp_eq(and3s(fpb %between% c(-1L, 1L), !logi_b, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fpb %between% c(-1L, 1L), !logi_b, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fpc %between% c(-1L, 1L), !logi_n, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fpc %between% c(-1L, 1L), !logi_n, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fpd %between% c(-1L, 1L), !logi_c, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fpd %between% c(-1L, 1L), !logi_c, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fpe %between% c(-1L, 1L), , ),
         band3(fpe %between% c(-1L, 1L), , ))
  exp_eq(and3s(fpf %between% c(-1L, 1L), , ),
         band3(fpf %between% c(-1L, 1L), , ))
  exp_eq(and3s(fpg %between% c(-1L, 1L), , ),
         band3(fpg %between% c(-1L, 1L), , ))
  exp_eq(and3s(fph %between% c(-1L, 1L), , e %in% 1:4),
         band3(fph %between% c(-1L, 1L), , e %in% 1:4))
  exp_eq(and3s(fpi %between% c(-1L, 1L), , e %in% 1:4),
         band3(fpi %between% c(-1L, 1L), , e %in% 1:4))
  exp_eq(and3s(fpj %between% c(-1L, 1L), , u %in% 1:4),
         band3(fpj %between% c(-1L, 1L), , u %in% 1:4))
  exp_eq(and3s(fpk %between% c(-1L, 1L), !logi_e, ),
         band3(fpk %between% c(-1L, 1L), !logi_e, ))
  exp_eq(and3s(fpl %between% c(-1L, 1L), !logi_x, ),
         band3(fpl %between% c(-1L, 1L), !logi_x, ))
  exp_eq(and3s(fpm %between% c(-1L, 1L), !logi_m, ),
         band3(fpm %between% c(-1L, 1L), !logi_m, ))
  exp_eq(and3s(fpn %between% c(-1L, 1L), !logi_j, l %in% 1:4),
         band3(fpn %between% c(-1L, 1L), !logi_j, l %in% 1:4))
  exp_eq(and3s(fpo %between% c(-1L, 1L), !logi_w, k %in% 1:4),
         band3(fpo %between% c(-1L, 1L), !logi_w, k %in% 1:4))
  exp_eq(and3s(fpp %between% c(-1L, 1L), !logi_y, v %in% 1:4),
         band3(fpp %between% c(-1L, 1L), !logi_y, v %in% 1:4))
  exp_eq(and3s(fpq %between% c(-1L, 1L), , ),
         band3(fpq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fpr %between% c(-1L, 1L), , ),
         band3(fpr %between% c(-1L, 1L), , ))
  exp_eq(and3s(fps %between% c(-1L, 1L), , ),
         band3(fps %between% c(-1L, 1L), , ))
  exp_eq(and3s(fpt %between% c(-1L, 1L), , l < 0L),
         band3(fpt %between% c(-1L, 1L), , l < 0L))
  exp_eq(and3s(fpu %between% c(-1L, 1L), , u < 1L),
         band3(fpu %between% c(-1L, 1L), , u < 1L))
  exp_eq(and3s(fpv %between% c(-1L, 1L), , r < 9L),
         band3(fpv %between% c(-1L, 1L), , r < 9L))
  exp_eq(and3s(fpw %between% c(-1L, 1L), !logi_d, ),
         band3(fpw %between% c(-1L, 1L), !logi_d, ))
  exp_eq(and3s(fpx %between% c(-1L, 1L), !logi_j, ),
         band3(fpx %between% c(-1L, 1L), !logi_j, ))
  exp_eq(and3s(fpy %between% c(-1L, 1L), !logi_c, ),
         band3(fpy %between% c(-1L, 1L), !logi_c, ))
  exp_eq(and3s(fpz %between% c(-1L, 1L), !logi_d, n < 0L),
         band3(fpz %between% c(-1L, 1L), !logi_d, n < 0L))
  exp_eq(and3s(fqa %between% c(-1L, 1L), !logi_g, h < 1L),
         band3(fqa %between% c(-1L, 1L), !logi_g, h < 1L))
  exp_eq(and3s(fqb %between% c(-1L, 1L), !logi_f, c < 9L),
         band3(fqb %between% c(-1L, 1L), !logi_f, c < 9L))
  exp_eq(and3s(fqc %between% c(-1L, 1L), , ),
         band3(fqc %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqd %between% c(-1L, 1L), , ),
         band3(fqd %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqe %between% c(-1L, 1L), , ),
         band3(fqe %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqf %between% c(-1L, 1L), , f <= 0L),
         band3(fqf %between% c(-1L, 1L), , f <= 0L))
  exp_eq(and3s(fqg %between% c(-1L, 1L), , h <= 1L),
         band3(fqg %between% c(-1L, 1L), , h <= 1L))
  exp_eq(and3s(fqh %between% c(-1L, 1L), , b <= 9L),
         band3(fqh %between% c(-1L, 1L), , b <= 9L))
  exp_eq(and3s(fqi %between% c(-1L, 1L), !logi_q, ),
         band3(fqi %between% c(-1L, 1L), !logi_q, ))
  exp_eq(and3s(fqj %between% c(-1L, 1L), !logi_n, ),
         band3(fqj %between% c(-1L, 1L), !logi_n, ))
  exp_eq(and3s(fqk %between% c(-1L, 1L), !logi_t, ),
         band3(fqk %between% c(-1L, 1L), !logi_t, ))
  exp_eq(and3s(fql %between% c(-1L, 1L), !logi_e, o <= 0L),
         band3(fql %between% c(-1L, 1L), !logi_e, o <= 0L))
  exp_eq(and3s(fqm %between% c(-1L, 1L), !logi_i, r <= 1L),
         band3(fqm %between% c(-1L, 1L), !logi_i, r <= 1L))
  exp_eq(and3s(fqn %between% c(-1L, 1L), !logi_w, d <= 9L),
         band3(fqn %between% c(-1L, 1L), !logi_w, d <= 9L))
  exp_eq(and3s(fqo %between% c(-1L, 1L), , ),
         band3(fqo %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqp %between% c(-1L, 1L), , ),
         band3(fqp %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqq %between% c(-1L, 1L), , ),
         band3(fqq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fqr %between% c(-1L, 1L), , m == 0L),
         band3(fqr %between% c(-1L, 1L), , m == 0L))
  exp_eq(and3s(fqs %between% c(-1L, 1L), , d == 1L),
         band3(fqs %between% c(-1L, 1L), , d == 1L))
  exp_eq(and3s(fqt %between% c(-1L, 1L), , p == 9L),
         band3(fqt %between% c(-1L, 1L), , p == 9L))
  exp_eq(and3s(fqu %between% c(-1L, 1L), !logi_o, ),
         band3(fqu %between% c(-1L, 1L), !logi_o, ))
  exp_eq(and3s(fqv %between% c(-1L, 1L), !logi_r, ),
         band3(fqv %between% c(-1L, 1L), !logi_r, ))
  exp_eq(and3s(fqw %between% c(-1L, 1L), !logi_n, ),
         band3(fqw %between% c(-1L, 1L), !logi_n, ))
  exp_eq(and3s(fqx %between% c(-1L, 1L), !logi_l, b == 0L),
         band3(fqx %between% c(-1L, 1L), !logi_l, b == 0L))
  exp_eq(and3s(fqy %between% c(-1L, 1L), !logi_d, d == 1L),
         band3(fqy %between% c(-1L, 1L), !logi_d, d == 1L))
  exp_eq(and3s(fqz %between% c(-1L, 1L), !logi_t, h == 9L),
         band3(fqz %between% c(-1L, 1L), !logi_t, h == 9L))
  exp_eq(and3s(fra %between% c(-1L, 1L), , ),
         band3(fra %between% c(-1L, 1L), , ))
  exp_eq(and3s(frb %between% c(-1L, 1L), , ),
         band3(frb %between% c(-1L, 1L), , ))
  exp_eq(and3s(frc %between% c(-1L, 1L), , ),
         band3(frc %between% c(-1L, 1L), , ))
  exp_eq(and3s(frd %between% c(-1L, 1L), , m > 0L),
         band3(frd %between% c(-1L, 1L), , m > 0L))
  exp_eq(and3s(fre %between% c(-1L, 1L), , w > 1L),
         band3(fre %between% c(-1L, 1L), , w > 1L))
  exp_eq(and3s(frf %between% c(-1L, 1L), , x > 9L),
         band3(frf %between% c(-1L, 1L), , x > 9L))
  exp_eq(and3s(frg %between% c(-1L, 1L), !logi_d, ),
         band3(frg %between% c(-1L, 1L), !logi_d, ))
  exp_eq(and3s(frh %between% c(-1L, 1L), !logi_m, ),
         band3(frh %between% c(-1L, 1L), !logi_m, ))
  exp_eq(and3s(fri %between% c(-1L, 1L), !logi_l, ),
         band3(fri %between% c(-1L, 1L), !logi_l, ))
  exp_eq(and3s(frj %between% c(-1L, 1L), !logi_z, j > 0L),
         band3(frj %between% c(-1L, 1L), !logi_z, j > 0L))
  exp_eq(and3s(frk %between% c(-1L, 1L), !logi_c, d > 1L),
         band3(frk %between% c(-1L, 1L), !logi_c, d > 1L))
  exp_eq(and3s(frl %between% c(-1L, 1L), !logi_r, q > 9L),
         band3(frl %between% c(-1L, 1L), !logi_r, q > 9L))
  exp_eq(and3s(frm %between% c(-1L, 1L), , ),
         band3(frm %between% c(-1L, 1L), , ))
  exp_eq(and3s(frn %between% c(-1L, 1L), , ),
         band3(frn %between% c(-1L, 1L), , ))
  exp_eq(and3s(fro %between% c(-1L, 1L), , ),
         band3(fro %between% c(-1L, 1L), , ))
  exp_eq(and3s(frp %between% c(-1L, 1L), , t >= 0L),
         band3(frp %between% c(-1L, 1L), , t >= 0L))
  exp_eq(and3s(frq %between% c(-1L, 1L), , c >= 1L),
         band3(frq %between% c(-1L, 1L), , c >= 1L))
  exp_eq(and3s(frr %between% c(-1L, 1L), , m >= 9L),
         band3(frr %between% c(-1L, 1L), , m >= 9L))
  exp_eq(and3s(frs %between% c(-1L, 1L), !logi_e, ),
         band3(frs %between% c(-1L, 1L), !logi_e, ))
  exp_eq(and3s(frt %between% c(-1L, 1L), !logi_a, ),
         band3(frt %between% c(-1L, 1L), !logi_a, ))
  exp_eq(and3s(fru %between% c(-1L, 1L), !logi_l, ),
         band3(fru %between% c(-1L, 1L), !logi_l, ))
  exp_eq(and3s(frv %between% c(-1L, 1L), !logi_k, d >= 0L),
         band3(frv %between% c(-1L, 1L), !logi_k, d >= 0L))
  exp_eq(and3s(frw %between% c(-1L, 1L), !logi_t, l >= 1L),
         band3(frw %between% c(-1L, 1L), !logi_t, l >= 1L))
  exp_eq(and3s(frx %between% c(-1L, 1L), !logi_b, b >= 9L),
         band3(frx %between% c(-1L, 1L), !logi_b, b >= 9L))
  exp_eq(and3s(fry %between% c(-1L, 1L), , ),
         band3(fry %between% c(-1L, 1L), , ))
  exp_eq(and3s(frz %between% c(-1L, 1L), , ),
         band3(frz %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsa %between% c(-1L, 1L), , ),
         band3(fsa %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsb %between% c(-1L, 1L), , logi_h),
         band3(fsb %between% c(-1L, 1L), , logi_h))
  exp_eq(and3s(fsc %between% c(-1L, 1L), , logi_h),
         band3(fsc %between% c(-1L, 1L), , logi_h))
  exp_eq(and3s(fsd %between% c(-1L, 1L), , logi_q),
         band3(fsd %between% c(-1L, 1L), , logi_q))
  exp_eq(and3s(fse %between% c(-1L, 1L), u != 0L, ),
         band3(fse %between% c(-1L, 1L), u != 0L, ))
  exp_eq(and3s(fsf %between% c(-1L, 1L), t != 1L, ),
         band3(fsf %between% c(-1L, 1L), t != 1L, ))
  exp_eq(and3s(fsg %between% c(-1L, 1L), u != 9L, ),
         band3(fsg %between% c(-1L, 1L), u != 9L, ))
  exp_eq(and3s(fsh %between% c(-1L, 1L), f != 0L, logi_h),
         band3(fsh %between% c(-1L, 1L), f != 0L, logi_h))
  exp_eq(and3s(fsi %between% c(-1L, 1L), g != 1L, logi_d),
         band3(fsi %between% c(-1L, 1L), g != 1L, logi_d))
  exp_eq(and3s(fsj %between% c(-1L, 1L), n != 9L, logi_i),
         band3(fsj %between% c(-1L, 1L), n != 9L, logi_i))
  exp_eq(and3s(fsk %between% c(-1L, 1L), , ),
         band3(fsk %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsl %between% c(-1L, 1L), , ),
         band3(fsl %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsm %between% c(-1L, 1L), , ),
         band3(fsm %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsn %between% c(-1L, 1L), , !logi_y),
         band3(fsn %between% c(-1L, 1L), , !logi_y))
  exp_eq(and3s(fso %between% c(-1L, 1L), , !logi_w),
         band3(fso %between% c(-1L, 1L), , !logi_w))
  exp_eq(and3s(fsp %between% c(-1L, 1L), , !logi_z),
         band3(fsp %between% c(-1L, 1L), , !logi_z))
  exp_eq(and3s(fsq %between% c(-1L, 1L), b != 0L, ),
         band3(fsq %between% c(-1L, 1L), b != 0L, ))
  exp_eq(and3s(fsr %between% c(-1L, 1L), c != 1L, ),
         band3(fsr %between% c(-1L, 1L), c != 1L, ))
  exp_eq(and3s(fss %between% c(-1L, 1L), m != 9L, ),
         band3(fss %between% c(-1L, 1L), m != 9L, ))
  exp_eq(and3s(fst %between% c(-1L, 1L), s != 0L, !logi_d),
         band3(fst %between% c(-1L, 1L), s != 0L, !logi_d))
  exp_eq(and3s(fsu %between% c(-1L, 1L), m != 1L, !logi_q),
         band3(fsu %between% c(-1L, 1L), m != 1L, !logi_q))
  exp_eq(and3s(fsv %between% c(-1L, 1L), x != 9L, !logi_n),
         band3(fsv %between% c(-1L, 1L), x != 9L, !logi_n))
  exp_eq(and3s(fsw %between% c(-1L, 1L), , ),
         band3(fsw %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsx %between% c(-1L, 1L), , ),
         band3(fsx %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsy %between% c(-1L, 1L), , ),
         band3(fsy %between% c(-1L, 1L), , ))
  exp_eq(and3s(fsz %between% c(-1L, 1L), , m != 0L),
         band3(fsz %between% c(-1L, 1L), , m != 0L))
  exp_eq(and3s(fta %between% c(-1L, 1L), , n != 1L),
         band3(fta %between% c(-1L, 1L), , n != 1L))
  exp_eq(and3s(ftb %between% c(-1L, 1L), , n != 9L),
         band3(ftb %between% c(-1L, 1L), , n != 9L))
  exp_eq(and3s(ftc %between% c(-1L, 1L), l != 0L, ),
         band3(ftc %between% c(-1L, 1L), l != 0L, ))
  exp_eq(and3s(ftd %between% c(-1L, 1L), b != 1L, ),
         band3(ftd %between% c(-1L, 1L), b != 1L, ))
  exp_eq(and3s(fte %between% c(-1L, 1L), p != 9L, ),
         band3(fte %between% c(-1L, 1L), p != 9L, ))
  exp_eq(and3s(ftf %between% c(-1L, 1L), h != 0L, l != 0L),
         band3(ftf %between% c(-1L, 1L), h != 0L, l != 0L))
  exp_eq(and3s(ftg %between% c(-1L, 1L), n != 1L, l != 1L),
         band3(ftg %between% c(-1L, 1L), n != 1L, l != 1L))
  exp_eq(and3s(fth %between% c(-1L, 1L), i != 9L, e != 9L),
         band3(fth %between% c(-1L, 1L), i != 9L, e != 9L))
  exp_eq(and3s(fti %between% c(-1L, 1L), , ),
         band3(fti %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftj %between% c(-1L, 1L), , ),
         band3(ftj %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftk %between% c(-1L, 1L), , ),
         band3(ftk %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftl %between% c(-1L, 1L), , i %between% c(-1L, 1L)),
         band3(ftl %between% c(-1L, 1L), , i %between% c(-1L, 1L)))
  exp_eq(and3s(ftm %between% c(-1L, 1L), , k %between% c(-1L, 1L)),
         band3(ftm %between% c(-1L, 1L), , k %between% c(-1L, 1L)))
  exp_eq(and3s(ftn %between% c(-1L, 1L), , g %between% c(-1L, 1L)),
         band3(ftn %between% c(-1L, 1L), , g %between% c(-1L, 1L)))
  exp_eq(and3s(fto %between% c(-1L, 1L), e != 0L, ),
         band3(fto %between% c(-1L, 1L), e != 0L, ))
  exp_eq(and3s(ftp %between% c(-1L, 1L), d != 1L, ),
         band3(ftp %between% c(-1L, 1L), d != 1L, ))
  exp_eq(and3s(ftq %between% c(-1L, 1L), z != 9L, ),
         band3(ftq %between% c(-1L, 1L), z != 9L, ))
  exp_eq(and3s(ftr %between% c(-1L, 1L), n != 0L, s %between% c(-1L, 1L)),
         band3(ftr %between% c(-1L, 1L), n != 0L, s %between% c(-1L, 1L)))
  exp_eq(and3s(fts %between% c(-1L, 1L), x != 1L, i %between% c(-1L, 1L)),
         band3(fts %between% c(-1L, 1L), x != 1L, i %between% c(-1L, 1L)))
  exp_eq(and3s(ftt %between% c(-1L, 1L), o != 9L, z %between% c(-1L, 1L)),
         band3(ftt %between% c(-1L, 1L), o != 9L, z %between% c(-1L, 1L)))
  exp_eq(and3s(ftu %between% c(-1L, 1L), , ),
         band3(ftu %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftv %between% c(-1L, 1L), , ),
         band3(ftv %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftw %between% c(-1L, 1L), , ),
         band3(ftw %between% c(-1L, 1L), , ))
  exp_eq(and3s(ftx %between% c(-1L, 1L), , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ftx %between% c(-1L, 1L), , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fty %between% c(-1L, 1L), , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fty %between% c(-1L, 1L), , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ftz %between% c(-1L, 1L), , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ftz %between% c(-1L, 1L), , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fua %between% c(-1L, 1L), p != 0L, ),
         band3(fua %between% c(-1L, 1L), p != 0L, ))
  exp_eq(and3s(fub %between% c(-1L, 1L), m != 1L, ),
         band3(fub %between% c(-1L, 1L), m != 1L, ))
  exp_eq(and3s(fuc %between% c(-1L, 1L), i != 9L, ),
         band3(fuc %between% c(-1L, 1L), i != 9L, ))
  exp_eq(and3s(fud %between% c(-1L, 1L), x != 0L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fud %between% c(-1L, 1L), x != 0L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fue %between% c(-1L, 1L), a != 1L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fue %between% c(-1L, 1L), a != 1L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fuf %between% c(-1L, 1L), y != 9L, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fuf %between% c(-1L, 1L), y != 9L, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(fug %between% c(-1L, 1L), , ),
         band3(fug %between% c(-1L, 1L), , ))
  exp_eq(and3s(fuh %between% c(-1L, 1L), , ),
         band3(fuh %between% c(-1L, 1L), , ))
  exp_eq(and3s(fui %between% c(-1L, 1L), , ),
         band3(fui %between% c(-1L, 1L), , ))
  exp_eq(and3s(fuj %between% c(-1L, 1L), , a %in% 1:4),
         band3(fuj %between% c(-1L, 1L), , a %in% 1:4))
  exp_eq(and3s(fuk %between% c(-1L, 1L), , o %in% 1:4),
         band3(fuk %between% c(-1L, 1L), , o %in% 1:4))
  exp_eq(and3s(ful %between% c(-1L, 1L), , l %in% 1:4),
         band3(ful %between% c(-1L, 1L), , l %in% 1:4))
  exp_eq(and3s(fum %between% c(-1L, 1L), q != 0L, ),
         band3(fum %between% c(-1L, 1L), q != 0L, ))
  exp_eq(and3s(fun %between% c(-1L, 1L), y != 1L, ),
         band3(fun %between% c(-1L, 1L), y != 1L, ))
  exp_eq(and3s(fuo %between% c(-1L, 1L), k != 9L, ),
         band3(fuo %between% c(-1L, 1L), k != 9L, ))
  exp_eq(and3s(fup %between% c(-1L, 1L), t != 0L, w %in% 1:4),
         band3(fup %between% c(-1L, 1L), t != 0L, w %in% 1:4))
  exp_eq(and3s(fuq %between% c(-1L, 1L), g != 1L, q %in% 1:4),
         band3(fuq %between% c(-1L, 1L), g != 1L, q %in% 1:4))
  exp_eq(and3s(fur %between% c(-1L, 1L), x != 9L, c %in% 1:4),
         band3(fur %between% c(-1L, 1L), x != 9L, c %in% 1:4))
  exp_eq(and3s(fus %between% c(-1L, 1L), , ),
         band3(fus %between% c(-1L, 1L), , ))
  exp_eq(and3s(fut %between% c(-1L, 1L), , ),
         band3(fut %between% c(-1L, 1L), , ))
  exp_eq(and3s(fuu %between% c(-1L, 1L), , ),
         band3(fuu %between% c(-1L, 1L), , ))
  exp_eq(and3s(fuv %between% c(-1L, 1L), , o < 0L),
         band3(fuv %between% c(-1L, 1L), , o < 0L))
  exp_eq(and3s(fuw %between% c(-1L, 1L), , z < 1L),
         band3(fuw %between% c(-1L, 1L), , z < 1L))
  exp_eq(and3s(fux %between% c(-1L, 1L), , l < 9L),
         band3(fux %between% c(-1L, 1L), , l < 9L))
  exp_eq(and3s(fuy %between% c(-1L, 1L), k != 0L, ),
         band3(fuy %between% c(-1L, 1L), k != 0L, ))
  exp_eq(and3s(fuz %between% c(-1L, 1L), e != 1L, ),
         band3(fuz %between% c(-1L, 1L), e != 1L, ))
  exp_eq(and3s(fva %between% c(-1L, 1L), x != 9L, ),
         band3(fva %between% c(-1L, 1L), x != 9L, ))
  exp_eq(and3s(fvb %between% c(-1L, 1L), n != 0L, b < 0L),
         band3(fvb %between% c(-1L, 1L), n != 0L, b < 0L))
  exp_eq(and3s(fvc %between% c(-1L, 1L), i != 1L, h < 1L),
         band3(fvc %between% c(-1L, 1L), i != 1L, h < 1L))
  exp_eq(and3s(fvd %between% c(-1L, 1L), x != 9L, o < 9L),
         band3(fvd %between% c(-1L, 1L), x != 9L, o < 9L))
  exp_eq(and3s(fve %between% c(-1L, 1L), , ),
         band3(fve %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvf %between% c(-1L, 1L), , ),
         band3(fvf %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvg %between% c(-1L, 1L), , ),
         band3(fvg %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvh %between% c(-1L, 1L), , o <= 0L),
         band3(fvh %between% c(-1L, 1L), , o <= 0L))
  exp_eq(and3s(fvi %between% c(-1L, 1L), , d <= 1L),
         band3(fvi %between% c(-1L, 1L), , d <= 1L))
  exp_eq(and3s(fvj %between% c(-1L, 1L), , s <= 9L),
         band3(fvj %between% c(-1L, 1L), , s <= 9L))
  exp_eq(and3s(fvk %between% c(-1L, 1L), u != 0L, ),
         band3(fvk %between% c(-1L, 1L), u != 0L, ))
  exp_eq(and3s(fvl %between% c(-1L, 1L), f != 1L, ),
         band3(fvl %between% c(-1L, 1L), f != 1L, ))
  exp_eq(and3s(fvm %between% c(-1L, 1L), o != 9L, ),
         band3(fvm %between% c(-1L, 1L), o != 9L, ))
  exp_eq(and3s(fvn %between% c(-1L, 1L), z != 0L, b <= 0L),
         band3(fvn %between% c(-1L, 1L), z != 0L, b <= 0L))
  exp_eq(and3s(fvo %between% c(-1L, 1L), g != 1L, j <= 1L),
         band3(fvo %between% c(-1L, 1L), g != 1L, j <= 1L))
  exp_eq(and3s(fvp %between% c(-1L, 1L), w != 9L, v <= 9L),
         band3(fvp %between% c(-1L, 1L), w != 9L, v <= 9L))
  exp_eq(and3s(fvq %between% c(-1L, 1L), , ),
         band3(fvq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvr %between% c(-1L, 1L), , ),
         band3(fvr %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvs %between% c(-1L, 1L), , ),
         band3(fvs %between% c(-1L, 1L), , ))
  exp_eq(and3s(fvt %between% c(-1L, 1L), , y == 0L),
         band3(fvt %between% c(-1L, 1L), , y == 0L))
  exp_eq(and3s(fvu %between% c(-1L, 1L), , e == 1L),
         band3(fvu %between% c(-1L, 1L), , e == 1L))
  exp_eq(and3s(fvv %between% c(-1L, 1L), , j == 9L),
         band3(fvv %between% c(-1L, 1L), , j == 9L))
  exp_eq(and3s(fvw %between% c(-1L, 1L), j != 0L, ),
         band3(fvw %between% c(-1L, 1L), j != 0L, ))
  exp_eq(and3s(fvx %between% c(-1L, 1L), a != 1L, ),
         band3(fvx %between% c(-1L, 1L), a != 1L, ))
  exp_eq(and3s(fvy %between% c(-1L, 1L), u != 9L, ),
         band3(fvy %between% c(-1L, 1L), u != 9L, ))
  exp_eq(and3s(fvz %between% c(-1L, 1L), d != 0L, k == 0L),
         band3(fvz %between% c(-1L, 1L), d != 0L, k == 0L))
  exp_eq(and3s(fwa %between% c(-1L, 1L), m != 1L, a == 1L),
         band3(fwa %between% c(-1L, 1L), m != 1L, a == 1L))
  exp_eq(and3s(fwb %between% c(-1L, 1L), h != 9L, j == 9L),
         band3(fwb %between% c(-1L, 1L), h != 9L, j == 9L))
  exp_eq(and3s(fwc %between% c(-1L, 1L), , ),
         band3(fwc %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwd %between% c(-1L, 1L), , ),
         band3(fwd %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwe %between% c(-1L, 1L), , ),
         band3(fwe %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwf %between% c(-1L, 1L), , c > 0L),
         band3(fwf %between% c(-1L, 1L), , c > 0L))
  exp_eq(and3s(fwg %between% c(-1L, 1L), , a > 1L),
         band3(fwg %between% c(-1L, 1L), , a > 1L))
  exp_eq(and3s(fwh %between% c(-1L, 1L), , j > 9L),
         band3(fwh %between% c(-1L, 1L), , j > 9L))
  exp_eq(and3s(fwi %between% c(-1L, 1L), t != 0L, ),
         band3(fwi %between% c(-1L, 1L), t != 0L, ))
  exp_eq(and3s(fwj %between% c(-1L, 1L), b != 1L, ),
         band3(fwj %between% c(-1L, 1L), b != 1L, ))
  exp_eq(and3s(fwk %between% c(-1L, 1L), t != 9L, ),
         band3(fwk %between% c(-1L, 1L), t != 9L, ))
  exp_eq(and3s(fwl %between% c(-1L, 1L), g != 0L, y > 0L),
         band3(fwl %between% c(-1L, 1L), g != 0L, y > 0L))
  exp_eq(and3s(fwm %between% c(-1L, 1L), f != 1L, c > 1L),
         band3(fwm %between% c(-1L, 1L), f != 1L, c > 1L))
  exp_eq(and3s(fwn %between% c(-1L, 1L), h != 9L, m > 9L),
         band3(fwn %between% c(-1L, 1L), h != 9L, m > 9L))
  exp_eq(and3s(fwo %between% c(-1L, 1L), , ),
         band3(fwo %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwp %between% c(-1L, 1L), , ),
         band3(fwp %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwq %between% c(-1L, 1L), , ),
         band3(fwq %between% c(-1L, 1L), , ))
  exp_eq(and3s(fwr %between% c(-1L, 1L), , m >= 0L),
         band3(fwr %between% c(-1L, 1L), , m >= 0L))
  exp_eq(and3s(fws %between% c(-1L, 1L), , u >= 1L),
         band3(fws %between% c(-1L, 1L), , u >= 1L))
  exp_eq(and3s(fwt %between% c(-1L, 1L), , r >= 9L),
         band3(fwt %between% c(-1L, 1L), , r >= 9L))
  exp_eq(and3s(fwu %between% c(-1L, 1L), o != 0L, ),
         band3(fwu %between% c(-1L, 1L), o != 0L, ))
  exp_eq(and3s(fwv %between% c(-1L, 1L), q != 1L, ),
         band3(fwv %between% c(-1L, 1L), q != 1L, ))
  exp_eq(and3s(fww %between% c(-1L, 1L), n != 9L, ),
         band3(fww %between% c(-1L, 1L), n != 9L, ))
  exp_eq(and3s(fwx %between% c(-1L, 1L), n != 0L, g >= 0L),
         band3(fwx %between% c(-1L, 1L), n != 0L, g >= 0L))
  exp_eq(and3s(fwy %between% c(-1L, 1L), i != 1L, u >= 1L),
         band3(fwy %between% c(-1L, 1L), i != 1L, u >= 1L))
  exp_eq(and3s(fwz %between% c(-1L, 1L), a != 9L, z >= 9L),
         band3(fwz %between% c(-1L, 1L), a != 9L, z >= 9L))
  exp_eq(and3s(fxa %between% c(-1L, 1L), , ),
         band3(fxa %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxb %between% c(-1L, 1L), , ),
         band3(fxb %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxc %between% c(-1L, 1L), , ),
         band3(fxc %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxd %between% c(-1L, 1L), , logi_e),
         band3(fxd %between% c(-1L, 1L), , logi_e))
  exp_eq(and3s(fxe %between% c(-1L, 1L), , logi_h),
         band3(fxe %between% c(-1L, 1L), , logi_h))
  exp_eq(and3s(fxf %between% c(-1L, 1L), , logi_l),
         band3(fxf %between% c(-1L, 1L), , logi_l))
  exp_eq(and3s(fxg %between% c(-1L, 1L), p %between% c(-1L, 1L), ),
         band3(fxg %between% c(-1L, 1L), p %between% c(-1L, 1L), ))
  exp_eq(and3s(fxh %between% c(-1L, 1L), b %between% c(-1L, 1L), ),
         band3(fxh %between% c(-1L, 1L), b %between% c(-1L, 1L), ))
  exp_eq(and3s(fxi %between% c(-1L, 1L), s %between% c(-1L, 1L), ),
         band3(fxi %between% c(-1L, 1L), s %between% c(-1L, 1L), ))
  exp_eq(and3s(fxj %between% c(-1L, 1L), v %between% c(-1L, 1L), logi_u),
         band3(fxj %between% c(-1L, 1L), v %between% c(-1L, 1L), logi_u))
  exp_eq(and3s(fxk %between% c(-1L, 1L), s %between% c(-1L, 1L), logi_b),
         band3(fxk %between% c(-1L, 1L), s %between% c(-1L, 1L), logi_b))
  exp_eq(and3s(fxl %between% c(-1L, 1L), f %between% c(-1L, 1L), logi_q),
         band3(fxl %between% c(-1L, 1L), f %between% c(-1L, 1L), logi_q))
  exp_eq(and3s(fxm %between% c(-1L, 1L), , ),
         band3(fxm %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxn %between% c(-1L, 1L), , ),
         band3(fxn %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxo %between% c(-1L, 1L), , ),
         band3(fxo %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxp %between% c(-1L, 1L), , !logi_l),
         band3(fxp %between% c(-1L, 1L), , !logi_l))
  exp_eq(and3s(fxq %between% c(-1L, 1L), , !logi_u),
         band3(fxq %between% c(-1L, 1L), , !logi_u))
  exp_eq(and3s(fxr %between% c(-1L, 1L), , !logi_u),
         band3(fxr %between% c(-1L, 1L), , !logi_u))
  exp_eq(and3s(fxs %between% c(-1L, 1L), c %between% c(-1L, 1L), ),
         band3(fxs %between% c(-1L, 1L), c %between% c(-1L, 1L), ))
  exp_eq(and3s(fxt %between% c(-1L, 1L), h %between% c(-1L, 1L), ),
         band3(fxt %between% c(-1L, 1L), h %between% c(-1L, 1L), ))
  exp_eq(and3s(fxu %between% c(-1L, 1L), a %between% c(-1L, 1L), ),
         band3(fxu %between% c(-1L, 1L), a %between% c(-1L, 1L), ))
  exp_eq(and3s(fxv %between% c(-1L, 1L), t %between% c(-1L, 1L), !logi_o),
         band3(fxv %between% c(-1L, 1L), t %between% c(-1L, 1L), !logi_o))
  exp_eq(and3s(fxw %between% c(-1L, 1L), f %between% c(-1L, 1L), !logi_l),
         band3(fxw %between% c(-1L, 1L), f %between% c(-1L, 1L), !logi_l))
  exp_eq(and3s(fxx %between% c(-1L, 1L), z %between% c(-1L, 1L), !logi_c),
         band3(fxx %between% c(-1L, 1L), z %between% c(-1L, 1L), !logi_c))
  exp_eq(and3s(fxy %between% c(-1L, 1L), , ),
         band3(fxy %between% c(-1L, 1L), , ))
  exp_eq(and3s(fxz %between% c(-1L, 1L), , ),
         band3(fxz %between% c(-1L, 1L), , ))
  exp_eq(and3s(fya %between% c(-1L, 1L), , ),
         band3(fya %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyb %between% c(-1L, 1L), , y != 0L),
         band3(fyb %between% c(-1L, 1L), , y != 0L))
  exp_eq(and3s(fyc %between% c(-1L, 1L), , r != 1L),
         band3(fyc %between% c(-1L, 1L), , r != 1L))
  exp_eq(and3s(fyd %between% c(-1L, 1L), , y != 9L),
         band3(fyd %between% c(-1L, 1L), , y != 9L))
  exp_eq(and3s(fye %between% c(-1L, 1L), n %between% c(-1L, 1L), ),
         band3(fye %between% c(-1L, 1L), n %between% c(-1L, 1L), ))
  exp_eq(and3s(fyf %between% c(-1L, 1L), e %between% c(-1L, 1L), ),
         band3(fyf %between% c(-1L, 1L), e %between% c(-1L, 1L), ))
  exp_eq(and3s(fyg %between% c(-1L, 1L), k %between% c(-1L, 1L), ),
         band3(fyg %between% c(-1L, 1L), k %between% c(-1L, 1L), ))
  exp_eq(and3s(fyh %between% c(-1L, 1L), i %between% c(-1L, 1L), s != 0L),
         band3(fyh %between% c(-1L, 1L), i %between% c(-1L, 1L), s != 0L))
  exp_eq(and3s(fyi %between% c(-1L, 1L), q %between% c(-1L, 1L), k != 1L),
         band3(fyi %between% c(-1L, 1L), q %between% c(-1L, 1L), k != 1L))
  exp_eq(and3s(fyj %between% c(-1L, 1L), c %between% c(-1L, 1L), q != 9L),
         band3(fyj %between% c(-1L, 1L), c %between% c(-1L, 1L), q != 9L))
  exp_eq(and3s(fyk %between% c(-1L, 1L), , ),
         band3(fyk %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyl %between% c(-1L, 1L), , ),
         band3(fyl %between% c(-1L, 1L), , ))
  exp_eq(and3s(fym %between% c(-1L, 1L), , ),
         band3(fym %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyn %between% c(-1L, 1L), , n %between% c(-1L, 1L)),
         band3(fyn %between% c(-1L, 1L), , n %between% c(-1L, 1L)))
  exp_eq(and3s(fyo %between% c(-1L, 1L), , i %between% c(-1L, 1L)),
         band3(fyo %between% c(-1L, 1L), , i %between% c(-1L, 1L)))
  exp_eq(and3s(fyp %between% c(-1L, 1L), , t %between% c(-1L, 1L)),
         band3(fyp %between% c(-1L, 1L), , t %between% c(-1L, 1L)))
  exp_eq(and3s(fyq %between% c(-1L, 1L), x %between% c(-1L, 1L), ),
         band3(fyq %between% c(-1L, 1L), x %between% c(-1L, 1L), ))
  exp_eq(and3s(fyr %between% c(-1L, 1L), s %between% c(-1L, 1L), ),
         band3(fyr %between% c(-1L, 1L), s %between% c(-1L, 1L), ))
  exp_eq(and3s(fys %between% c(-1L, 1L), g %between% c(-1L, 1L), ),
         band3(fys %between% c(-1L, 1L), g %between% c(-1L, 1L), ))
  exp_eq(and3s(fyt %between% c(-1L, 1L), v %between% c(-1L, 1L), u %between% c(-1L, 1L)),
         band3(fyt %between% c(-1L, 1L), v %between% c(-1L, 1L), u %between% c(-1L, 1L)))
  exp_eq(and3s(fyu %between% c(-1L, 1L), d %between% c(-1L, 1L), b %between% c(-1L, 1L)),
         band3(fyu %between% c(-1L, 1L), d %between% c(-1L, 1L), b %between% c(-1L, 1L)))
  exp_eq(and3s(fyv %between% c(-1L, 1L), i %between% c(-1L, 1L), q %between% c(-1L, 1L)),
         band3(fyv %between% c(-1L, 1L), i %between% c(-1L, 1L), q %between% c(-1L, 1L)))
  exp_eq(and3s(fyw %between% c(-1L, 1L), , ),
         band3(fyw %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyx %between% c(-1L, 1L), , ),
         band3(fyx %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyy %between% c(-1L, 1L), , ),
         band3(fyy %between% c(-1L, 1L), , ))
  exp_eq(and3s(fyz %between% c(-1L, 1L), , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(fyz %between% c(-1L, 1L), , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ga %between% c(-1L, 1L), , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ga %between% c(-1L, 1L), , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gb %between% c(-1L, 1L), , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gb %between% c(-1L, 1L), , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gc %between% c(-1L, 1L), h %between% c(-1L, 1L), ),
         band3(gc %between% c(-1L, 1L), h %between% c(-1L, 1L), ))
  exp_eq(and3s(gd %between% c(-1L, 1L), r %between% c(-1L, 1L), ),
         band3(gd %between% c(-1L, 1L), r %between% c(-1L, 1L), ))
  exp_eq(and3s(ge %between% c(-1L, 1L), g %between% c(-1L, 1L), ),
         band3(ge %between% c(-1L, 1L), g %between% c(-1L, 1L), ))
  exp_eq(and3s(gf %between% c(-1L, 1L), j %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gf %between% c(-1L, 1L), j %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gg %between% c(-1L, 1L), v %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gg %between% c(-1L, 1L), v %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gh %between% c(-1L, 1L), h %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gh %between% c(-1L, 1L), h %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gi %between% c(-1L, 1L), , ),
         band3(gi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gj %between% c(-1L, 1L), , ),
         band3(gj %between% c(-1L, 1L), , ))
  exp_eq(and3s(gk %between% c(-1L, 1L), , ),
         band3(gk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gl %between% c(-1L, 1L), , u %in% 1:4),
         band3(gl %between% c(-1L, 1L), , u %in% 1:4))
  exp_eq(and3s(gm %between% c(-1L, 1L), , r %in% 1:4),
         band3(gm %between% c(-1L, 1L), , r %in% 1:4))
  exp_eq(and3s(gn %between% c(-1L, 1L), , x %in% 1:4),
         band3(gn %between% c(-1L, 1L), , x %in% 1:4))
  exp_eq(and3s(go %between% c(-1L, 1L), v %between% c(-1L, 1L), ),
         band3(go %between% c(-1L, 1L), v %between% c(-1L, 1L), ))
  exp_eq(and3s(gp %between% c(-1L, 1L), u %between% c(-1L, 1L), ),
         band3(gp %between% c(-1L, 1L), u %between% c(-1L, 1L), ))
  exp_eq(and3s(gq %between% c(-1L, 1L), m %between% c(-1L, 1L), ),
         band3(gq %between% c(-1L, 1L), m %between% c(-1L, 1L), ))
  exp_eq(and3s(gr %between% c(-1L, 1L), v %between% c(-1L, 1L), t %in% 1:4),
         band3(gr %between% c(-1L, 1L), v %between% c(-1L, 1L), t %in% 1:4))
  exp_eq(and3s(gs %between% c(-1L, 1L), t %between% c(-1L, 1L), x %in% 1:4),
         band3(gs %between% c(-1L, 1L), t %between% c(-1L, 1L), x %in% 1:4))
  exp_eq(and3s(gt %between% c(-1L, 1L), m %between% c(-1L, 1L), t %in% 1:4),
         band3(gt %between% c(-1L, 1L), m %between% c(-1L, 1L), t %in% 1:4))
  exp_eq(and3s(gu %between% c(-1L, 1L), , ),
         band3(gu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gv %between% c(-1L, 1L), , ),
         band3(gv %between% c(-1L, 1L), , ))
  exp_eq(and3s(gw %between% c(-1L, 1L), , ),
         band3(gw %between% c(-1L, 1L), , ))
  exp_eq(and3s(gx %between% c(-1L, 1L), , q < 0L),
         band3(gx %between% c(-1L, 1L), , q < 0L))
  exp_eq(and3s(gy %between% c(-1L, 1L), , o < 1L),
         band3(gy %between% c(-1L, 1L), , o < 1L))
  exp_eq(and3s(gz %between% c(-1L, 1L), , u < 9L),
         band3(gz %between% c(-1L, 1L), , u < 9L))
  exp_eq(and3s(gaa %between% c(-1L, 1L), y %between% c(-1L, 1L), ),
         band3(gaa %between% c(-1L, 1L), y %between% c(-1L, 1L), ))
  exp_eq(and3s(gab %between% c(-1L, 1L), h %between% c(-1L, 1L), ),
         band3(gab %between% c(-1L, 1L), h %between% c(-1L, 1L), ))
  exp_eq(and3s(gac %between% c(-1L, 1L), t %between% c(-1L, 1L), ),
         band3(gac %between% c(-1L, 1L), t %between% c(-1L, 1L), ))
  exp_eq(and3s(gad %between% c(-1L, 1L), i %between% c(-1L, 1L), s < 0L),
         band3(gad %between% c(-1L, 1L), i %between% c(-1L, 1L), s < 0L))
  exp_eq(and3s(gae %between% c(-1L, 1L), e %between% c(-1L, 1L), e < 1L),
         band3(gae %between% c(-1L, 1L), e %between% c(-1L, 1L), e < 1L))
  exp_eq(and3s(gaf %between% c(-1L, 1L), w %between% c(-1L, 1L), s < 9L),
         band3(gaf %between% c(-1L, 1L), w %between% c(-1L, 1L), s < 9L))
  exp_eq(and3s(gag %between% c(-1L, 1L), , ),
         band3(gag %between% c(-1L, 1L), , ))
  exp_eq(and3s(gah %between% c(-1L, 1L), , ),
         band3(gah %between% c(-1L, 1L), , ))
  exp_eq(and3s(gai %between% c(-1L, 1L), , ),
         band3(gai %between% c(-1L, 1L), , ))
  exp_eq(and3s(gaj %between% c(-1L, 1L), , k <= 0L),
         band3(gaj %between% c(-1L, 1L), , k <= 0L))
  exp_eq(and3s(gak %between% c(-1L, 1L), , c <= 1L),
         band3(gak %between% c(-1L, 1L), , c <= 1L))
  exp_eq(and3s(gal %between% c(-1L, 1L), , h <= 9L),
         band3(gal %between% c(-1L, 1L), , h <= 9L))
  exp_eq(and3s(gam %between% c(-1L, 1L), n %between% c(-1L, 1L), ),
         band3(gam %between% c(-1L, 1L), n %between% c(-1L, 1L), ))
  exp_eq(and3s(gan %between% c(-1L, 1L), i %between% c(-1L, 1L), ),
         band3(gan %between% c(-1L, 1L), i %between% c(-1L, 1L), ))
  exp_eq(and3s(gao %between% c(-1L, 1L), n %between% c(-1L, 1L), ),
         band3(gao %between% c(-1L, 1L), n %between% c(-1L, 1L), ))
  exp_eq(and3s(gap %between% c(-1L, 1L), n %between% c(-1L, 1L), f <= 0L),
         band3(gap %between% c(-1L, 1L), n %between% c(-1L, 1L), f <= 0L))
  exp_eq(and3s(gaq %between% c(-1L, 1L), q %between% c(-1L, 1L), d <= 1L),
         band3(gaq %between% c(-1L, 1L), q %between% c(-1L, 1L), d <= 1L))
  exp_eq(and3s(gar %between% c(-1L, 1L), b %between% c(-1L, 1L), z <= 9L),
         band3(gar %between% c(-1L, 1L), b %between% c(-1L, 1L), z <= 9L))
  exp_eq(and3s(gas %between% c(-1L, 1L), , ),
         band3(gas %between% c(-1L, 1L), , ))
  exp_eq(and3s(gat %between% c(-1L, 1L), , ),
         band3(gat %between% c(-1L, 1L), , ))
  exp_eq(and3s(gau %between% c(-1L, 1L), , ),
         band3(gau %between% c(-1L, 1L), , ))
  exp_eq(and3s(gav %between% c(-1L, 1L), , d == 0L),
         band3(gav %between% c(-1L, 1L), , d == 0L))
  exp_eq(and3s(gaw %between% c(-1L, 1L), , f == 1L),
         band3(gaw %between% c(-1L, 1L), , f == 1L))
  exp_eq(and3s(gax %between% c(-1L, 1L), , v == 9L),
         band3(gax %between% c(-1L, 1L), , v == 9L))
  exp_eq(and3s(gay %between% c(-1L, 1L), j %between% c(-1L, 1L), ),
         band3(gay %between% c(-1L, 1L), j %between% c(-1L, 1L), ))
  exp_eq(and3s(gaz %between% c(-1L, 1L), o %between% c(-1L, 1L), ),
         band3(gaz %between% c(-1L, 1L), o %between% c(-1L, 1L), ))
  exp_eq(and3s(gba %between% c(-1L, 1L), h %between% c(-1L, 1L), ),
         band3(gba %between% c(-1L, 1L), h %between% c(-1L, 1L), ))
  exp_eq(and3s(gbb %between% c(-1L, 1L), d %between% c(-1L, 1L), o == 0L),
         band3(gbb %between% c(-1L, 1L), d %between% c(-1L, 1L), o == 0L))
  exp_eq(and3s(gbc %between% c(-1L, 1L), w %between% c(-1L, 1L), t == 1L),
         band3(gbc %between% c(-1L, 1L), w %between% c(-1L, 1L), t == 1L))
  exp_eq(and3s(gbd %between% c(-1L, 1L), v %between% c(-1L, 1L), p == 9L),
         band3(gbd %between% c(-1L, 1L), v %between% c(-1L, 1L), p == 9L))
  exp_eq(and3s(gbe %between% c(-1L, 1L), , ),
         band3(gbe %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbf %between% c(-1L, 1L), , ),
         band3(gbf %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbg %between% c(-1L, 1L), , ),
         band3(gbg %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbh %between% c(-1L, 1L), , k > 0L),
         band3(gbh %between% c(-1L, 1L), , k > 0L))
  exp_eq(and3s(gbi %between% c(-1L, 1L), , q > 1L),
         band3(gbi %between% c(-1L, 1L), , q > 1L))
  exp_eq(and3s(gbj %between% c(-1L, 1L), , l > 9L),
         band3(gbj %between% c(-1L, 1L), , l > 9L))
  exp_eq(and3s(gbk %between% c(-1L, 1L), u %between% c(-1L, 1L), ),
         band3(gbk %between% c(-1L, 1L), u %between% c(-1L, 1L), ))
  exp_eq(and3s(gbl %between% c(-1L, 1L), t %between% c(-1L, 1L), ),
         band3(gbl %between% c(-1L, 1L), t %between% c(-1L, 1L), ))
  exp_eq(and3s(gbm %between% c(-1L, 1L), e %between% c(-1L, 1L), ),
         band3(gbm %between% c(-1L, 1L), e %between% c(-1L, 1L), ))
  exp_eq(and3s(gbn %between% c(-1L, 1L), d %between% c(-1L, 1L), j > 0L),
         band3(gbn %between% c(-1L, 1L), d %between% c(-1L, 1L), j > 0L))
  exp_eq(and3s(gbo %between% c(-1L, 1L), l %between% c(-1L, 1L), n > 1L),
         band3(gbo %between% c(-1L, 1L), l %between% c(-1L, 1L), n > 1L))
  exp_eq(and3s(gbp %between% c(-1L, 1L), r %between% c(-1L, 1L), y > 9L),
         band3(gbp %between% c(-1L, 1L), r %between% c(-1L, 1L), y > 9L))
  exp_eq(and3s(gbq %between% c(-1L, 1L), , ),
         band3(gbq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbr %between% c(-1L, 1L), , ),
         band3(gbr %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbs %between% c(-1L, 1L), , ),
         band3(gbs %between% c(-1L, 1L), , ))
  exp_eq(and3s(gbt %between% c(-1L, 1L), , d >= 0L),
         band3(gbt %between% c(-1L, 1L), , d >= 0L))
  exp_eq(and3s(gbu %between% c(-1L, 1L), , l >= 1L),
         band3(gbu %between% c(-1L, 1L), , l >= 1L))
  exp_eq(and3s(gbv %between% c(-1L, 1L), , x >= 9L),
         band3(gbv %between% c(-1L, 1L), , x >= 9L))
  exp_eq(and3s(gbw %between% c(-1L, 1L), u %between% c(-1L, 1L), ),
         band3(gbw %between% c(-1L, 1L), u %between% c(-1L, 1L), ))
  exp_eq(and3s(gbx %between% c(-1L, 1L), p %between% c(-1L, 1L), ),
         band3(gbx %between% c(-1L, 1L), p %between% c(-1L, 1L), ))
  exp_eq(and3s(gby %between% c(-1L, 1L), t %between% c(-1L, 1L), ),
         band3(gby %between% c(-1L, 1L), t %between% c(-1L, 1L), ))
  exp_eq(and3s(gbz %between% c(-1L, 1L), p %between% c(-1L, 1L), g >= 0L),
         band3(gbz %between% c(-1L, 1L), p %between% c(-1L, 1L), g >= 0L))
  exp_eq(and3s(gca %between% c(-1L, 1L), l %between% c(-1L, 1L), u >= 1L),
         band3(gca %between% c(-1L, 1L), l %between% c(-1L, 1L), u >= 1L))
  exp_eq(and3s(gcb %between% c(-1L, 1L), r %between% c(-1L, 1L), a >= 9L),
         band3(gcb %between% c(-1L, 1L), r %between% c(-1L, 1L), a >= 9L))
  exp_eq(and3s(gcc %between% c(-1L, 1L), , ),
         band3(gcc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gcd %between% c(-1L, 1L), , ),
         band3(gcd %between% c(-1L, 1L), , ))
  exp_eq(and3s(gce %between% c(-1L, 1L), , ),
         band3(gce %between% c(-1L, 1L), , ))
  exp_eq(and3s(gcf %between% c(-1L, 1L), , logi_z),
         band3(gcf %between% c(-1L, 1L), , logi_z))
  exp_eq(and3s(gcg %between% c(-1L, 1L), , logi_q),
         band3(gcg %between% c(-1L, 1L), , logi_q))
  exp_eq(and3s(gch %between% c(-1L, 1L), , logi_d),
         band3(gch %between% c(-1L, 1L), , logi_d))
  exp_eq(and3s(gci %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gci %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gcj %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gcj %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gck %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gck %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gcl %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), logi_h),
         band3(gcl %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), logi_h))
  exp_eq(and3s(gcm %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), logi_i),
         band3(gcm %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), logi_i))
  exp_eq(and3s(gcn %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L), logi_y),
         band3(gcn %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L), logi_y))
  exp_eq(and3s(gco %between% c(-1L, 1L), , ),
         band3(gco %between% c(-1L, 1L), , ))
  exp_eq(and3s(gcp %between% c(-1L, 1L), , ),
         band3(gcp %between% c(-1L, 1L), , ))
  exp_eq(and3s(gcq %between% c(-1L, 1L), , ),
         band3(gcq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gcr %between% c(-1L, 1L), , logi_q),
         band3(gcr %between% c(-1L, 1L), , logi_q))
  exp_eq(and3s(gcs %between% c(-1L, 1L), , logi_a),
         band3(gcs %between% c(-1L, 1L), , logi_a))
  exp_eq(and3s(gct %between% c(-1L, 1L), , logi_g),
         band3(gct %between% c(-1L, 1L), , logi_g))
  exp_eq(and3s(gcu %between% c(-1L, 1L), d %in% 1:4, ),
         band3(gcu %between% c(-1L, 1L), d %in% 1:4, ))
  exp_eq(and3s(gcv %between% c(-1L, 1L), a %in% 1:4, ),
         band3(gcv %between% c(-1L, 1L), a %in% 1:4, ))
  exp_eq(and3s(gcw %between% c(-1L, 1L), a %in% 1:4, ),
         band3(gcw %between% c(-1L, 1L), a %in% 1:4, ))
  exp_eq(and3s(gcx %between% c(-1L, 1L), i %in% 1:4, logi_n),
         band3(gcx %between% c(-1L, 1L), i %in% 1:4, logi_n))
  exp_eq(and3s(gcy %between% c(-1L, 1L), y %in% 1:4, logi_u),
         band3(gcy %between% c(-1L, 1L), y %in% 1:4, logi_u))
  exp_eq(and3s(gcz %between% c(-1L, 1L), z %in% 1:4, logi_g),
         band3(gcz %between% c(-1L, 1L), z %in% 1:4, logi_g))
  exp_eq(and3s(gda %between% c(-1L, 1L), , ),
         band3(gda %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdb %between% c(-1L, 1L), , ),
         band3(gdb %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdc %between% c(-1L, 1L), , ),
         band3(gdc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdd %between% c(-1L, 1L), , !logi_m),
         band3(gdd %between% c(-1L, 1L), , !logi_m))
  exp_eq(and3s(gde %between% c(-1L, 1L), , !logi_n),
         band3(gde %between% c(-1L, 1L), , !logi_n))
  exp_eq(and3s(gdf %between% c(-1L, 1L), , !logi_c),
         band3(gdf %between% c(-1L, 1L), , !logi_c))
  exp_eq(and3s(gdg %between% c(-1L, 1L), i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gdg %between% c(-1L, 1L), i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gdh %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gdh %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gdi %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gdi %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gdj %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L), !logi_j),
         band3(gdj %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L), !logi_j))
  exp_eq(and3s(gdk %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), !logi_c),
         band3(gdk %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), !logi_c))
  exp_eq(and3s(gdl %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), !logi_e),
         band3(gdl %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), !logi_e))
  exp_eq(and3s(gdm %between% c(-1L, 1L), , ),
         band3(gdm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdn %between% c(-1L, 1L), , ),
         band3(gdn %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdo %between% c(-1L, 1L), , ),
         band3(gdo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdp %between% c(-1L, 1L), , !logi_u),
         band3(gdp %between% c(-1L, 1L), , !logi_u))
  exp_eq(and3s(gdq %between% c(-1L, 1L), , !logi_v),
         band3(gdq %between% c(-1L, 1L), , !logi_v))
  exp_eq(and3s(gdr %between% c(-1L, 1L), , !logi_n),
         band3(gdr %between% c(-1L, 1L), , !logi_n))
  exp_eq(and3s(gds %between% c(-1L, 1L), s %in% 1:4, ),
         band3(gds %between% c(-1L, 1L), s %in% 1:4, ))
  exp_eq(and3s(gdt %between% c(-1L, 1L), k %in% 1:4, ),
         band3(gdt %between% c(-1L, 1L), k %in% 1:4, ))
  exp_eq(and3s(gdu %between% c(-1L, 1L), j %in% 1:4, ),
         band3(gdu %between% c(-1L, 1L), j %in% 1:4, ))
  exp_eq(and3s(gdv %between% c(-1L, 1L), e %in% 1:4, !logi_r),
         band3(gdv %between% c(-1L, 1L), e %in% 1:4, !logi_r))
  exp_eq(and3s(gdw %between% c(-1L, 1L), u %in% 1:4, !logi_o),
         band3(gdw %between% c(-1L, 1L), u %in% 1:4, !logi_o))
  exp_eq(and3s(gdx %between% c(-1L, 1L), a %in% 1:4, !logi_k),
         band3(gdx %between% c(-1L, 1L), a %in% 1:4, !logi_k))
  exp_eq(and3s(gdy %between% c(-1L, 1L), , ),
         band3(gdy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gdz %between% c(-1L, 1L), , ),
         band3(gdz %between% c(-1L, 1L), , ))
  exp_eq(and3s(gea %between% c(-1L, 1L), , ),
         band3(gea %between% c(-1L, 1L), , ))
  exp_eq(and3s(geb %between% c(-1L, 1L), , k != 0L),
         band3(geb %between% c(-1L, 1L), , k != 0L))
  exp_eq(and3s(gec %between% c(-1L, 1L), , h != 1L),
         band3(gec %between% c(-1L, 1L), , h != 1L))
  exp_eq(and3s(ged %between% c(-1L, 1L), , x != 9L),
         band3(ged %between% c(-1L, 1L), , x != 9L))
  exp_eq(and3s(gee %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gee %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gef %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gef %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(geg %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(geg %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(geh %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), l != 0L),
         band3(geh %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), l != 0L))
  exp_eq(and3s(gei %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L), e != 1L),
         band3(gei %between% c(-1L, 1L), a %in% c(4L, -3L, 2L, 7L, 8L), e != 1L))
  exp_eq(and3s(gej %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L), i != 9L),
         band3(gej %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L), i != 9L))
  exp_eq(and3s(gek %between% c(-1L, 1L), , ),
         band3(gek %between% c(-1L, 1L), , ))
  exp_eq(and3s(gel %between% c(-1L, 1L), , ),
         band3(gel %between% c(-1L, 1L), , ))
  exp_eq(and3s(gem %between% c(-1L, 1L), , ),
         band3(gem %between% c(-1L, 1L), , ))
  exp_eq(and3s(gen %between% c(-1L, 1L), , a != 0L),
         band3(gen %between% c(-1L, 1L), , a != 0L))
  exp_eq(and3s(geo %between% c(-1L, 1L), , m != 1L),
         band3(geo %between% c(-1L, 1L), , m != 1L))
  exp_eq(and3s(gep %between% c(-1L, 1L), , r != 9L),
         band3(gep %between% c(-1L, 1L), , r != 9L))
  exp_eq(and3s(geq %between% c(-1L, 1L), e %in% 1:4, ),
         band3(geq %between% c(-1L, 1L), e %in% 1:4, ))
  exp_eq(and3s(ger %between% c(-1L, 1L), l %in% 1:4, ),
         band3(ger %between% c(-1L, 1L), l %in% 1:4, ))
  exp_eq(and3s(ges %between% c(-1L, 1L), q %in% 1:4, ),
         band3(ges %between% c(-1L, 1L), q %in% 1:4, ))
  exp_eq(and3s(get %between% c(-1L, 1L), q %in% 1:4, s != 0L),
         band3(get %between% c(-1L, 1L), q %in% 1:4, s != 0L))
  exp_eq(and3s(geu %between% c(-1L, 1L), k %in% 1:4, q != 1L),
         band3(geu %between% c(-1L, 1L), k %in% 1:4, q != 1L))
  exp_eq(and3s(gev %between% c(-1L, 1L), s %in% 1:4, w != 9L),
         band3(gev %between% c(-1L, 1L), s %in% 1:4, w != 9L))
  exp_eq(and3s(gew %between% c(-1L, 1L), , ),
         band3(gew %between% c(-1L, 1L), , ))
  exp_eq(and3s(gex %between% c(-1L, 1L), , ),
         band3(gex %between% c(-1L, 1L), , ))
  exp_eq(and3s(gey %between% c(-1L, 1L), , ),
         band3(gey %between% c(-1L, 1L), , ))
  exp_eq(and3s(gez %between% c(-1L, 1L), , z %between% c(-1L, 1L)),
         band3(gez %between% c(-1L, 1L), , z %between% c(-1L, 1L)))
  exp_eq(and3s(gfa %between% c(-1L, 1L), , z %between% c(-1L, 1L)),
         band3(gfa %between% c(-1L, 1L), , z %between% c(-1L, 1L)))
  exp_eq(and3s(gfb %between% c(-1L, 1L), , r %between% c(-1L, 1L)),
         band3(gfb %between% c(-1L, 1L), , r %between% c(-1L, 1L)))
  exp_eq(and3s(gfc %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gfc %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gfd %between% c(-1L, 1L), u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gfd %between% c(-1L, 1L), u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gfe %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gfe %between% c(-1L, 1L), c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gff %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L)),
         band3(gff %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L)))
  exp_eq(and3s(gfg %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L)),
         band3(gfg %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L)))
  exp_eq(and3s(gfh %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L)),
         band3(gfh %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L)))
  exp_eq(and3s(gfi %between% c(-1L, 1L), , ),
         band3(gfi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfj %between% c(-1L, 1L), , ),
         band3(gfj %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfk %between% c(-1L, 1L), , ),
         band3(gfk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfl %between% c(-1L, 1L), , n %between% c(-1L, 1L)),
         band3(gfl %between% c(-1L, 1L), , n %between% c(-1L, 1L)))
  exp_eq(and3s(gfm %between% c(-1L, 1L), , r %between% c(-1L, 1L)),
         band3(gfm %between% c(-1L, 1L), , r %between% c(-1L, 1L)))
  exp_eq(and3s(gfn %between% c(-1L, 1L), , t %between% c(-1L, 1L)),
         band3(gfn %between% c(-1L, 1L), , t %between% c(-1L, 1L)))
  exp_eq(and3s(gfo %between% c(-1L, 1L), j %in% 1:4, ),
         band3(gfo %between% c(-1L, 1L), j %in% 1:4, ))
  exp_eq(and3s(gfp %between% c(-1L, 1L), j %in% 1:4, ),
         band3(gfp %between% c(-1L, 1L), j %in% 1:4, ))
  exp_eq(and3s(gfq %between% c(-1L, 1L), m %in% 1:4, ),
         band3(gfq %between% c(-1L, 1L), m %in% 1:4, ))
  exp_eq(and3s(gfr %between% c(-1L, 1L), q %in% 1:4, x %between% c(-1L, 1L)),
         band3(gfr %between% c(-1L, 1L), q %in% 1:4, x %between% c(-1L, 1L)))
  exp_eq(and3s(gfs %between% c(-1L, 1L), m %in% 1:4, p %between% c(-1L, 1L)),
         band3(gfs %between% c(-1L, 1L), m %in% 1:4, p %between% c(-1L, 1L)))
  exp_eq(and3s(gft %between% c(-1L, 1L), x %in% 1:4, j %between% c(-1L, 1L)),
         band3(gft %between% c(-1L, 1L), x %in% 1:4, j %between% c(-1L, 1L)))
  exp_eq(and3s(gfu %between% c(-1L, 1L), , ),
         band3(gfu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfv %between% c(-1L, 1L), , ),
         band3(gfv %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfw %between% c(-1L, 1L), , ),
         band3(gfw %between% c(-1L, 1L), , ))
  exp_eq(and3s(gfx %between% c(-1L, 1L), , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gfx %between% c(-1L, 1L), , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gfy %between% c(-1L, 1L), , x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gfy %between% c(-1L, 1L), , x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gfz %between% c(-1L, 1L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gfz %between% c(-1L, 1L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gga %between% c(-1L, 1L), r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gga %between% c(-1L, 1L), r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ggb %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ggb %between% c(-1L, 1L), j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ggc %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ggc %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ggd %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L), j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ggd %between% c(-1L, 1L), q %in% c(4L, -3L, 2L, 7L, 8L), j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gge %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gge %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ggf %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ggf %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ggg %between% c(-1L, 1L), , ),
         band3(ggg %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggh %between% c(-1L, 1L), , ),
         band3(ggh %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggi %between% c(-1L, 1L), , ),
         band3(ggi %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggj %between% c(-1L, 1L), , b %in% 1:4),
         band3(ggj %between% c(-1L, 1L), , b %in% 1:4))
  exp_eq(and3s(ggk %between% c(-1L, 1L), , s %in% 1:4),
         band3(ggk %between% c(-1L, 1L), , s %in% 1:4))
  exp_eq(and3s(ggl %between% c(-1L, 1L), , f %in% 1:4),
         band3(ggl %between% c(-1L, 1L), , f %in% 1:4))
  exp_eq(and3s(ggm %between% c(-1L, 1L), n %in% 1:4, ),
         band3(ggm %between% c(-1L, 1L), n %in% 1:4, ))
  exp_eq(and3s(ggn %between% c(-1L, 1L), u %in% 1:4, ),
         band3(ggn %between% c(-1L, 1L), u %in% 1:4, ))
  exp_eq(and3s(ggo %between% c(-1L, 1L), x %in% 1:4, ),
         band3(ggo %between% c(-1L, 1L), x %in% 1:4, ))
  exp_eq(and3s(ggp %between% c(-1L, 1L), x %in% 1:4, c %in% 1:4),
         band3(ggp %between% c(-1L, 1L), x %in% 1:4, c %in% 1:4))
  exp_eq(and3s(ggq %between% c(-1L, 1L), t %in% 1:4, n %in% 1:4),
         band3(ggq %between% c(-1L, 1L), t %in% 1:4, n %in% 1:4))
  exp_eq(and3s(ggr %between% c(-1L, 1L), c %in% 1:4, y %in% 1:4),
         band3(ggr %between% c(-1L, 1L), c %in% 1:4, y %in% 1:4))
  exp_eq(and3s(ggs %between% c(-1L, 1L), , ),
         band3(ggs %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggt %between% c(-1L, 1L), , ),
         band3(ggt %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggu %between% c(-1L, 1L), , ),
         band3(ggu %between% c(-1L, 1L), , ))
  exp_eq(and3s(ggv %between% c(-1L, 1L), , o < 0L),
         band3(ggv %between% c(-1L, 1L), , o < 0L))
  exp_eq(and3s(ggw %between% c(-1L, 1L), , a < 1L),
         band3(ggw %between% c(-1L, 1L), , a < 1L))
  exp_eq(and3s(ggx %between% c(-1L, 1L), , j < 9L),
         band3(ggx %between% c(-1L, 1L), , j < 9L))
  exp_eq(and3s(ggy %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ggy %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ggz %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ggz %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gha %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gha %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ghb %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), g < 0L),
         band3(ghb %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), g < 0L))
  exp_eq(and3s(ghc %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), d < 1L),
         band3(ghc %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), d < 1L))
  exp_eq(and3s(ghd %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L), d < 9L),
         band3(ghd %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L), d < 9L))
  exp_eq(and3s(ghe %between% c(-1L, 1L), , ),
         band3(ghe %between% c(-1L, 1L), , ))
  exp_eq(and3s(ghf %between% c(-1L, 1L), , ),
         band3(ghf %between% c(-1L, 1L), , ))
  exp_eq(and3s(ghg %between% c(-1L, 1L), , ),
         band3(ghg %between% c(-1L, 1L), , ))
  exp_eq(and3s(ghh %between% c(-1L, 1L), , a < 0L),
         band3(ghh %between% c(-1L, 1L), , a < 0L))
  exp_eq(and3s(ghi %between% c(-1L, 1L), , v < 1L),
         band3(ghi %between% c(-1L, 1L), , v < 1L))
  exp_eq(and3s(ghj %between% c(-1L, 1L), , w < 9L),
         band3(ghj %between% c(-1L, 1L), , w < 9L))
  exp_eq(and3s(ghk %between% c(-1L, 1L), s %in% 1:4, ),
         band3(ghk %between% c(-1L, 1L), s %in% 1:4, ))
  exp_eq(and3s(ghl %between% c(-1L, 1L), w %in% 1:4, ),
         band3(ghl %between% c(-1L, 1L), w %in% 1:4, ))
  exp_eq(and3s(ghm %between% c(-1L, 1L), r %in% 1:4, ),
         band3(ghm %between% c(-1L, 1L), r %in% 1:4, ))
  exp_eq(and3s(ghn %between% c(-1L, 1L), t %in% 1:4, j < 0L),
         band3(ghn %between% c(-1L, 1L), t %in% 1:4, j < 0L))
  exp_eq(and3s(gho %between% c(-1L, 1L), w %in% 1:4, o < 1L),
         band3(gho %between% c(-1L, 1L), w %in% 1:4, o < 1L))
  exp_eq(and3s(ghp %between% c(-1L, 1L), x %in% 1:4, f < 9L),
         band3(ghp %between% c(-1L, 1L), x %in% 1:4, f < 9L))
  exp_eq(and3s(ghq %between% c(-1L, 1L), , ),
         band3(ghq %between% c(-1L, 1L), , ))
  exp_eq(and3s(ghr %between% c(-1L, 1L), , ),
         band3(ghr %between% c(-1L, 1L), , ))
  exp_eq(and3s(ghs %between% c(-1L, 1L), , ),
         band3(ghs %between% c(-1L, 1L), , ))
  exp_eq(and3s(ght %between% c(-1L, 1L), , g <= 0L),
         band3(ght %between% c(-1L, 1L), , g <= 0L))
  exp_eq(and3s(ghu %between% c(-1L, 1L), , r <= 1L),
         band3(ghu %between% c(-1L, 1L), , r <= 1L))
  exp_eq(and3s(ghv %between% c(-1L, 1L), , b <= 9L),
         band3(ghv %between% c(-1L, 1L), , b <= 9L))
  exp_eq(and3s(ghw %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ghw %between% c(-1L, 1L), w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ghx %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ghx %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ghy %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ghy %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ghz %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), b <= 0L),
         band3(ghz %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), b <= 0L))
  exp_eq(and3s(gia %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), b <= 1L),
         band3(gia %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), b <= 1L))
  exp_eq(and3s(gib %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), d <= 9L),
         band3(gib %between% c(-1L, 1L), m %in% c(4L, -3L, 2L, 7L, 8L), d <= 9L))
  exp_eq(and3s(gic %between% c(-1L, 1L), , ),
         band3(gic %between% c(-1L, 1L), , ))
  exp_eq(and3s(gid %between% c(-1L, 1L), , ),
         band3(gid %between% c(-1L, 1L), , ))
  exp_eq(and3s(gie %between% c(-1L, 1L), , ),
         band3(gie %between% c(-1L, 1L), , ))
  exp_eq(and3s(gif %between% c(-1L, 1L), , w <= 0L),
         band3(gif %between% c(-1L, 1L), , w <= 0L))
  exp_eq(and3s(gig %between% c(-1L, 1L), , o <= 1L),
         band3(gig %between% c(-1L, 1L), , o <= 1L))
  exp_eq(and3s(gih %between% c(-1L, 1L), , d <= 9L),
         band3(gih %between% c(-1L, 1L), , d <= 9L))
  exp_eq(and3s(gii %between% c(-1L, 1L), l %in% 1:4, ),
         band3(gii %between% c(-1L, 1L), l %in% 1:4, ))
  exp_eq(and3s(gij %between% c(-1L, 1L), p %in% 1:4, ),
         band3(gij %between% c(-1L, 1L), p %in% 1:4, ))
  exp_eq(and3s(gik %between% c(-1L, 1L), k %in% 1:4, ),
         band3(gik %between% c(-1L, 1L), k %in% 1:4, ))
  exp_eq(and3s(gil %between% c(-1L, 1L), h %in% 1:4, s <= 0L),
         band3(gil %between% c(-1L, 1L), h %in% 1:4, s <= 0L))
  exp_eq(and3s(gim %between% c(-1L, 1L), j %in% 1:4, t <= 1L),
         band3(gim %between% c(-1L, 1L), j %in% 1:4, t <= 1L))
  exp_eq(and3s(gin %between% c(-1L, 1L), p %in% 1:4, b <= 9L),
         band3(gin %between% c(-1L, 1L), p %in% 1:4, b <= 9L))
  exp_eq(and3s(gio %between% c(-1L, 1L), , ),
         band3(gio %between% c(-1L, 1L), , ))
  exp_eq(and3s(gip %between% c(-1L, 1L), , ),
         band3(gip %between% c(-1L, 1L), , ))
  exp_eq(and3s(giq %between% c(-1L, 1L), , ),
         band3(giq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gir %between% c(-1L, 1L), , v == 0L),
         band3(gir %between% c(-1L, 1L), , v == 0L))
  exp_eq(and3s(gis %between% c(-1L, 1L), , b == 1L),
         band3(gis %between% c(-1L, 1L), , b == 1L))
  exp_eq(and3s(git %between% c(-1L, 1L), , f == 9L),
         band3(git %between% c(-1L, 1L), , f == 9L))
  exp_eq(and3s(giu %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(giu %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(giv %between% c(-1L, 1L), v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(giv %between% c(-1L, 1L), v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(giw %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(giw %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gix %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), u == 0L),
         band3(gix %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), u == 0L))
  exp_eq(and3s(giy %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), m == 1L),
         band3(giy %between% c(-1L, 1L), f %in% c(4L, -3L, 2L, 7L, 8L), m == 1L))
  exp_eq(and3s(giz %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), a == 9L),
         band3(giz %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L), a == 9L))
  exp_eq(and3s(gja %between% c(-1L, 1L), , ),
         band3(gja %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjb %between% c(-1L, 1L), , ),
         band3(gjb %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjc %between% c(-1L, 1L), , ),
         band3(gjc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjd %between% c(-1L, 1L), , r == 0L),
         band3(gjd %between% c(-1L, 1L), , r == 0L))
  exp_eq(and3s(gje %between% c(-1L, 1L), , n == 1L),
         band3(gje %between% c(-1L, 1L), , n == 1L))
  exp_eq(and3s(gjf %between% c(-1L, 1L), , c == 9L),
         band3(gjf %between% c(-1L, 1L), , c == 9L))
  exp_eq(and3s(gjg %between% c(-1L, 1L), f %in% 1:4, ),
         band3(gjg %between% c(-1L, 1L), f %in% 1:4, ))
  exp_eq(and3s(gjh %between% c(-1L, 1L), h %in% 1:4, ),
         band3(gjh %between% c(-1L, 1L), h %in% 1:4, ))
  exp_eq(and3s(gji %between% c(-1L, 1L), n %in% 1:4, ),
         band3(gji %between% c(-1L, 1L), n %in% 1:4, ))
  exp_eq(and3s(gjj %between% c(-1L, 1L), r %in% 1:4, g == 0L),
         band3(gjj %between% c(-1L, 1L), r %in% 1:4, g == 0L))
  exp_eq(and3s(gjk %between% c(-1L, 1L), m %in% 1:4, i == 1L),
         band3(gjk %between% c(-1L, 1L), m %in% 1:4, i == 1L))
  exp_eq(and3s(gjl %between% c(-1L, 1L), t %in% 1:4, e == 9L),
         band3(gjl %between% c(-1L, 1L), t %in% 1:4, e == 9L))
  exp_eq(and3s(gjm %between% c(-1L, 1L), , ),
         band3(gjm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjn %between% c(-1L, 1L), , ),
         band3(gjn %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjo %between% c(-1L, 1L), , ),
         band3(gjo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjp %between% c(-1L, 1L), , v > 0L),
         band3(gjp %between% c(-1L, 1L), , v > 0L))
  exp_eq(and3s(gjq %between% c(-1L, 1L), , l > 1L),
         band3(gjq %between% c(-1L, 1L), , l > 1L))
  exp_eq(and3s(gjr %between% c(-1L, 1L), , u > 9L),
         band3(gjr %between% c(-1L, 1L), , u > 9L))
  exp_eq(and3s(gjs %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gjs %between% c(-1L, 1L), z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gjt %between% c(-1L, 1L), i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gjt %between% c(-1L, 1L), i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gju %between% c(-1L, 1L), x %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gju %between% c(-1L, 1L), x %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gjv %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), v > 0L),
         band3(gjv %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), v > 0L))
  exp_eq(and3s(gjw %between% c(-1L, 1L), e %in% c(4L, -3L, 2L, 7L, 8L), e > 1L),
         band3(gjw %between% c(-1L, 1L), e %in% c(4L, -3L, 2L, 7L, 8L), e > 1L))
  exp_eq(and3s(gjx %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L), n > 9L),
         band3(gjx %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L), n > 9L))
  exp_eq(and3s(gjy %between% c(-1L, 1L), , ),
         band3(gjy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gjz %between% c(-1L, 1L), , ),
         band3(gjz %between% c(-1L, 1L), , ))
  exp_eq(and3s(gka %between% c(-1L, 1L), , ),
         band3(gka %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkb %between% c(-1L, 1L), , c > 0L),
         band3(gkb %between% c(-1L, 1L), , c > 0L))
  exp_eq(and3s(gkc %between% c(-1L, 1L), , j > 1L),
         band3(gkc %between% c(-1L, 1L), , j > 1L))
  exp_eq(and3s(gkd %between% c(-1L, 1L), , s > 9L),
         band3(gkd %between% c(-1L, 1L), , s > 9L))
  exp_eq(and3s(gke %between% c(-1L, 1L), d %in% 1:4, ),
         band3(gke %between% c(-1L, 1L), d %in% 1:4, ))
  exp_eq(and3s(gkf %between% c(-1L, 1L), t %in% 1:4, ),
         band3(gkf %between% c(-1L, 1L), t %in% 1:4, ))
  exp_eq(and3s(gkg %between% c(-1L, 1L), k %in% 1:4, ),
         band3(gkg %between% c(-1L, 1L), k %in% 1:4, ))
  exp_eq(and3s(gkh %between% c(-1L, 1L), t %in% 1:4, g > 0L),
         band3(gkh %between% c(-1L, 1L), t %in% 1:4, g > 0L))
  exp_eq(and3s(gki %between% c(-1L, 1L), z %in% 1:4, n > 1L),
         band3(gki %between% c(-1L, 1L), z %in% 1:4, n > 1L))
  exp_eq(and3s(gkj %between% c(-1L, 1L), p %in% 1:4, w > 9L),
         band3(gkj %between% c(-1L, 1L), p %in% 1:4, w > 9L))
  exp_eq(and3s(gkk %between% c(-1L, 1L), , ),
         band3(gkk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkl %between% c(-1L, 1L), , ),
         band3(gkl %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkm %between% c(-1L, 1L), , ),
         band3(gkm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkn %between% c(-1L, 1L), , x >= 0L),
         band3(gkn %between% c(-1L, 1L), , x >= 0L))
  exp_eq(and3s(gko %between% c(-1L, 1L), , c >= 1L),
         band3(gko %between% c(-1L, 1L), , c >= 1L))
  exp_eq(and3s(gkp %between% c(-1L, 1L), , x >= 9L),
         band3(gkp %between% c(-1L, 1L), , x >= 9L))
  exp_eq(and3s(gkq %between% c(-1L, 1L), r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gkq %between% c(-1L, 1L), r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gkr %between% c(-1L, 1L), v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gkr %between% c(-1L, 1L), v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gks %between% c(-1L, 1L), o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(gks %between% c(-1L, 1L), o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(gkt %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L),
         band3(gkt %between% c(-1L, 1L), y %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L))
  exp_eq(and3s(gku %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), x >= 1L),
         band3(gku %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L), x >= 1L))
  exp_eq(and3s(gkv %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), f >= 9L),
         band3(gkv %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L), f >= 9L))
  exp_eq(and3s(gkw %between% c(-1L, 1L), , ),
         band3(gkw %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkx %between% c(-1L, 1L), , ),
         band3(gkx %between% c(-1L, 1L), , ))
  exp_eq(and3s(gky %between% c(-1L, 1L), , ),
         band3(gky %between% c(-1L, 1L), , ))
  exp_eq(and3s(gkz %between% c(-1L, 1L), , j >= 0L),
         band3(gkz %between% c(-1L, 1L), , j >= 0L))
  exp_eq(and3s(gla %between% c(-1L, 1L), , r >= 1L),
         band3(gla %between% c(-1L, 1L), , r >= 1L))
  exp_eq(and3s(glb %between% c(-1L, 1L), , h >= 9L),
         band3(glb %between% c(-1L, 1L), , h >= 9L))
  exp_eq(and3s(glc %between% c(-1L, 1L), m %in% 1:4, ),
         band3(glc %between% c(-1L, 1L), m %in% 1:4, ))
  exp_eq(and3s(gld %between% c(-1L, 1L), o %in% 1:4, ),
         band3(gld %between% c(-1L, 1L), o %in% 1:4, ))
  exp_eq(and3s(gle %between% c(-1L, 1L), x %in% 1:4, ),
         band3(gle %between% c(-1L, 1L), x %in% 1:4, ))
  exp_eq(and3s(glf %between% c(-1L, 1L), d %in% 1:4, r >= 0L),
         band3(glf %between% c(-1L, 1L), d %in% 1:4, r >= 0L))
  exp_eq(and3s(glg %between% c(-1L, 1L), z %in% 1:4, p >= 1L),
         band3(glg %between% c(-1L, 1L), z %in% 1:4, p >= 1L))
  exp_eq(and3s(glh %between% c(-1L, 1L), f %in% 1:4, a >= 9L),
         band3(glh %between% c(-1L, 1L), f %in% 1:4, a >= 9L))
  exp_eq(and3s(gli %between% c(-1L, 1L), , ),
         band3(gli %between% c(-1L, 1L), , ))
  exp_eq(and3s(glj %between% c(-1L, 1L), , ),
         band3(glj %between% c(-1L, 1L), , ))
  exp_eq(and3s(glk %between% c(-1L, 1L), , ),
         band3(glk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gll %between% c(-1L, 1L), , logi_f),
         band3(gll %between% c(-1L, 1L), , logi_f))
  exp_eq(and3s(glm %between% c(-1L, 1L), , logi_s),
         band3(glm %between% c(-1L, 1L), , logi_s))
  exp_eq(and3s(gln %between% c(-1L, 1L), , logi_s),
         band3(gln %between% c(-1L, 1L), , logi_s))
  exp_eq(and3s(glo %between% c(-1L, 1L), b < 0L, ),
         band3(glo %between% c(-1L, 1L), b < 0L, ))
  exp_eq(and3s(glp %between% c(-1L, 1L), l < 1L, ),
         band3(glp %between% c(-1L, 1L), l < 1L, ))
  exp_eq(and3s(glq %between% c(-1L, 1L), e < 9L, ),
         band3(glq %between% c(-1L, 1L), e < 9L, ))
  exp_eq(and3s(glr %between% c(-1L, 1L), c < 0L, logi_d),
         band3(glr %between% c(-1L, 1L), c < 0L, logi_d))
  exp_eq(and3s(gls %between% c(-1L, 1L), n < 1L, logi_x),
         band3(gls %between% c(-1L, 1L), n < 1L, logi_x))
  exp_eq(and3s(glt %between% c(-1L, 1L), s < 9L, logi_k),
         band3(glt %between% c(-1L, 1L), s < 9L, logi_k))
  exp_eq(and3s(glu %between% c(-1L, 1L), , ),
         band3(glu %between% c(-1L, 1L), , ))
  exp_eq(and3s(glv %between% c(-1L, 1L), , ),
         band3(glv %between% c(-1L, 1L), , ))
  exp_eq(and3s(glw %between% c(-1L, 1L), , ),
         band3(glw %between% c(-1L, 1L), , ))
  exp_eq(and3s(glx %between% c(-1L, 1L), , !logi_c),
         band3(glx %between% c(-1L, 1L), , !logi_c))
  exp_eq(and3s(gly %between% c(-1L, 1L), , !logi_w),
         band3(gly %between% c(-1L, 1L), , !logi_w))
  exp_eq(and3s(glz %between% c(-1L, 1L), , !logi_a),
         band3(glz %between% c(-1L, 1L), , !logi_a))
  exp_eq(and3s(gma %between% c(-1L, 1L), o < 0L, ),
         band3(gma %between% c(-1L, 1L), o < 0L, ))
  exp_eq(and3s(gmb %between% c(-1L, 1L), u < 1L, ),
         band3(gmb %between% c(-1L, 1L), u < 1L, ))
  exp_eq(and3s(gmc %between% c(-1L, 1L), p < 9L, ),
         band3(gmc %between% c(-1L, 1L), p < 9L, ))
  exp_eq(and3s(gmd %between% c(-1L, 1L), v < 0L, !logi_u),
         band3(gmd %between% c(-1L, 1L), v < 0L, !logi_u))
  exp_eq(and3s(gme %between% c(-1L, 1L), v < 1L, !logi_e),
         band3(gme %between% c(-1L, 1L), v < 1L, !logi_e))
  exp_eq(and3s(gmf %between% c(-1L, 1L), s < 9L, !logi_r),
         band3(gmf %between% c(-1L, 1L), s < 9L, !logi_r))
  exp_eq(and3s(gmg %between% c(-1L, 1L), , ),
         band3(gmg %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmh %between% c(-1L, 1L), , ),
         band3(gmh %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmi %between% c(-1L, 1L), , ),
         band3(gmi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmj %between% c(-1L, 1L), , o != 0L),
         band3(gmj %between% c(-1L, 1L), , o != 0L))
  exp_eq(and3s(gmk %between% c(-1L, 1L), , b != 1L),
         band3(gmk %between% c(-1L, 1L), , b != 1L))
  exp_eq(and3s(gml %between% c(-1L, 1L), , m != 9L),
         band3(gml %between% c(-1L, 1L), , m != 9L))
  exp_eq(and3s(gmm %between% c(-1L, 1L), o < 0L, ),
         band3(gmm %between% c(-1L, 1L), o < 0L, ))
  exp_eq(and3s(gmn %between% c(-1L, 1L), j < 1L, ),
         band3(gmn %between% c(-1L, 1L), j < 1L, ))
  exp_eq(and3s(gmo %between% c(-1L, 1L), o < 9L, ),
         band3(gmo %between% c(-1L, 1L), o < 9L, ))
  exp_eq(and3s(gmp %between% c(-1L, 1L), w < 0L, x != 0L),
         band3(gmp %between% c(-1L, 1L), w < 0L, x != 0L))
  exp_eq(and3s(gmq %between% c(-1L, 1L), h < 1L, u != 1L),
         band3(gmq %between% c(-1L, 1L), h < 1L, u != 1L))
  exp_eq(and3s(gmr %between% c(-1L, 1L), c < 9L, c != 9L),
         band3(gmr %between% c(-1L, 1L), c < 9L, c != 9L))
  exp_eq(and3s(gms %between% c(-1L, 1L), , ),
         band3(gms %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmt %between% c(-1L, 1L), , ),
         band3(gmt %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmu %between% c(-1L, 1L), , ),
         band3(gmu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gmv %between% c(-1L, 1L), , d %between% c(-1L, 1L)),
         band3(gmv %between% c(-1L, 1L), , d %between% c(-1L, 1L)))
  exp_eq(and3s(gmw %between% c(-1L, 1L), , b %between% c(-1L, 1L)),
         band3(gmw %between% c(-1L, 1L), , b %between% c(-1L, 1L)))
  exp_eq(and3s(gmx %between% c(-1L, 1L), , l %between% c(-1L, 1L)),
         band3(gmx %between% c(-1L, 1L), , l %between% c(-1L, 1L)))
  exp_eq(and3s(gmy %between% c(-1L, 1L), o < 0L, ),
         band3(gmy %between% c(-1L, 1L), o < 0L, ))
  exp_eq(and3s(gmz %between% c(-1L, 1L), w < 1L, ),
         band3(gmz %between% c(-1L, 1L), w < 1L, ))
  exp_eq(and3s(gna %between% c(-1L, 1L), u < 9L, ),
         band3(gna %between% c(-1L, 1L), u < 9L, ))
  exp_eq(and3s(gnb %between% c(-1L, 1L), x < 0L, b %between% c(-1L, 1L)),
         band3(gnb %between% c(-1L, 1L), x < 0L, b %between% c(-1L, 1L)))
  exp_eq(and3s(gnc %between% c(-1L, 1L), t < 1L, e %between% c(-1L, 1L)),
         band3(gnc %between% c(-1L, 1L), t < 1L, e %between% c(-1L, 1L)))
  exp_eq(and3s(gnd %between% c(-1L, 1L), w < 9L, n %between% c(-1L, 1L)),
         band3(gnd %between% c(-1L, 1L), w < 9L, n %between% c(-1L, 1L)))
  exp_eq(and3s(gne %between% c(-1L, 1L), , ),
         band3(gne %between% c(-1L, 1L), , ))
  exp_eq(and3s(gnf %between% c(-1L, 1L), , ),
         band3(gnf %between% c(-1L, 1L), , ))
  exp_eq(and3s(gng %between% c(-1L, 1L), , ),
         band3(gng %between% c(-1L, 1L), , ))
  exp_eq(and3s(gnh %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gnh %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gni %between% c(-1L, 1L), , m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gni %between% c(-1L, 1L), , m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gnj %between% c(-1L, 1L), , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gnj %between% c(-1L, 1L), , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gnk %between% c(-1L, 1L), x < 0L, ),
         band3(gnk %between% c(-1L, 1L), x < 0L, ))
  exp_eq(and3s(gnl %between% c(-1L, 1L), n < 1L, ),
         band3(gnl %between% c(-1L, 1L), n < 1L, ))
  exp_eq(and3s(gnm %between% c(-1L, 1L), r < 9L, ),
         band3(gnm %between% c(-1L, 1L), r < 9L, ))
  exp_eq(and3s(gnn %between% c(-1L, 1L), z < 0L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gnn %between% c(-1L, 1L), z < 0L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gno %between% c(-1L, 1L), d < 1L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gno %between% c(-1L, 1L), d < 1L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gnp %between% c(-1L, 1L), s < 9L, a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gnp %between% c(-1L, 1L), s < 9L, a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gnq %between% c(-1L, 1L), , ),
         band3(gnq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gnr %between% c(-1L, 1L), , ),
         band3(gnr %between% c(-1L, 1L), , ))
  exp_eq(and3s(gns %between% c(-1L, 1L), , ),
         band3(gns %between% c(-1L, 1L), , ))
  exp_eq(and3s(gnt %between% c(-1L, 1L), , r %in% 1:4),
         band3(gnt %between% c(-1L, 1L), , r %in% 1:4))
  exp_eq(and3s(gnu %between% c(-1L, 1L), , s %in% 1:4),
         band3(gnu %between% c(-1L, 1L), , s %in% 1:4))
  exp_eq(and3s(gnv %between% c(-1L, 1L), , f %in% 1:4),
         band3(gnv %between% c(-1L, 1L), , f %in% 1:4))
  exp_eq(and3s(gnw %between% c(-1L, 1L), d < 0L, ),
         band3(gnw %between% c(-1L, 1L), d < 0L, ))
  exp_eq(and3s(gnx %between% c(-1L, 1L), n < 1L, ),
         band3(gnx %between% c(-1L, 1L), n < 1L, ))
  exp_eq(and3s(gny %between% c(-1L, 1L), c < 9L, ),
         band3(gny %between% c(-1L, 1L), c < 9L, ))
  exp_eq(and3s(gnz %between% c(-1L, 1L), u < 0L, a %in% 1:4),
         band3(gnz %between% c(-1L, 1L), u < 0L, a %in% 1:4))
  exp_eq(and3s(goa %between% c(-1L, 1L), p < 1L, q %in% 1:4),
         band3(goa %between% c(-1L, 1L), p < 1L, q %in% 1:4))
  exp_eq(and3s(gob %between% c(-1L, 1L), f < 9L, x %in% 1:4),
         band3(gob %between% c(-1L, 1L), f < 9L, x %in% 1:4))
  exp_eq(and3s(goc %between% c(-1L, 1L), , ),
         band3(goc %between% c(-1L, 1L), , ))
  exp_eq(and3s(god %between% c(-1L, 1L), , ),
         band3(god %between% c(-1L, 1L), , ))
  exp_eq(and3s(goe %between% c(-1L, 1L), , ),
         band3(goe %between% c(-1L, 1L), , ))
  exp_eq(and3s(gof %between% c(-1L, 1L), , n < 0L),
         band3(gof %between% c(-1L, 1L), , n < 0L))
  exp_eq(and3s(gog %between% c(-1L, 1L), , i < 1L),
         band3(gog %between% c(-1L, 1L), , i < 1L))
  exp_eq(and3s(goh %between% c(-1L, 1L), , o < 9L),
         band3(goh %between% c(-1L, 1L), , o < 9L))
  exp_eq(and3s(goi %between% c(-1L, 1L), u < 0L, ),
         band3(goi %between% c(-1L, 1L), u < 0L, ))
  exp_eq(and3s(goj %between% c(-1L, 1L), w < 1L, ),
         band3(goj %between% c(-1L, 1L), w < 1L, ))
  exp_eq(and3s(gok %between% c(-1L, 1L), l < 9L, ),
         band3(gok %between% c(-1L, 1L), l < 9L, ))
  exp_eq(and3s(gol %between% c(-1L, 1L), f < 0L, g < 0L),
         band3(gol %between% c(-1L, 1L), f < 0L, g < 0L))
  exp_eq(and3s(gom %between% c(-1L, 1L), f < 1L, h < 1L),
         band3(gom %between% c(-1L, 1L), f < 1L, h < 1L))
  exp_eq(and3s(gon %between% c(-1L, 1L), k < 9L, z < 9L),
         band3(gon %between% c(-1L, 1L), k < 9L, z < 9L))
  exp_eq(and3s(goo %between% c(-1L, 1L), , ),
         band3(goo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gop %between% c(-1L, 1L), , ),
         band3(gop %between% c(-1L, 1L), , ))
  exp_eq(and3s(goq %between% c(-1L, 1L), , ),
         band3(goq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gor %between% c(-1L, 1L), , d <= 0L),
         band3(gor %between% c(-1L, 1L), , d <= 0L))
  exp_eq(and3s(gos %between% c(-1L, 1L), , b <= 1L),
         band3(gos %between% c(-1L, 1L), , b <= 1L))
  exp_eq(and3s(got %between% c(-1L, 1L), , y <= 9L),
         band3(got %between% c(-1L, 1L), , y <= 9L))
  exp_eq(and3s(gou %between% c(-1L, 1L), h < 0L, ),
         band3(gou %between% c(-1L, 1L), h < 0L, ))
  exp_eq(and3s(gov %between% c(-1L, 1L), b < 1L, ),
         band3(gov %between% c(-1L, 1L), b < 1L, ))
  exp_eq(and3s(gow %between% c(-1L, 1L), s < 9L, ),
         band3(gow %between% c(-1L, 1L), s < 9L, ))
  exp_eq(and3s(gox %between% c(-1L, 1L), g < 0L, n <= 0L),
         band3(gox %between% c(-1L, 1L), g < 0L, n <= 0L))
  exp_eq(and3s(goy %between% c(-1L, 1L), p < 1L, k <= 1L),
         band3(goy %between% c(-1L, 1L), p < 1L, k <= 1L))
  exp_eq(and3s(goz %between% c(-1L, 1L), l < 9L, v <= 9L),
         band3(goz %between% c(-1L, 1L), l < 9L, v <= 9L))
  exp_eq(and3s(gpa %between% c(-1L, 1L), , ),
         band3(gpa %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpb %between% c(-1L, 1L), , ),
         band3(gpb %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpc %between% c(-1L, 1L), , ),
         band3(gpc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpd %between% c(-1L, 1L), , f == 0L),
         band3(gpd %between% c(-1L, 1L), , f == 0L))
  exp_eq(and3s(gpe %between% c(-1L, 1L), , n == 1L),
         band3(gpe %between% c(-1L, 1L), , n == 1L))
  exp_eq(and3s(gpf %between% c(-1L, 1L), , g == 9L),
         band3(gpf %between% c(-1L, 1L), , g == 9L))
  exp_eq(and3s(gpg %between% c(-1L, 1L), x < 0L, ),
         band3(gpg %between% c(-1L, 1L), x < 0L, ))
  exp_eq(and3s(gph %between% c(-1L, 1L), t < 1L, ),
         band3(gph %between% c(-1L, 1L), t < 1L, ))
  exp_eq(and3s(gpi %between% c(-1L, 1L), y < 9L, ),
         band3(gpi %between% c(-1L, 1L), y < 9L, ))
  exp_eq(and3s(gpj %between% c(-1L, 1L), y < 0L, g == 0L),
         band3(gpj %between% c(-1L, 1L), y < 0L, g == 0L))
  exp_eq(and3s(gpk %between% c(-1L, 1L), y < 1L, x == 1L),
         band3(gpk %between% c(-1L, 1L), y < 1L, x == 1L))
  exp_eq(and3s(gpl %between% c(-1L, 1L), m < 9L, z == 9L),
         band3(gpl %between% c(-1L, 1L), m < 9L, z == 9L))
  exp_eq(and3s(gpm %between% c(-1L, 1L), , ),
         band3(gpm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpn %between% c(-1L, 1L), , ),
         band3(gpn %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpo %between% c(-1L, 1L), , ),
         band3(gpo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpp %between% c(-1L, 1L), , k > 0L),
         band3(gpp %between% c(-1L, 1L), , k > 0L))
  exp_eq(and3s(gpq %between% c(-1L, 1L), , n > 1L),
         band3(gpq %between% c(-1L, 1L), , n > 1L))
  exp_eq(and3s(gpr %between% c(-1L, 1L), , q > 9L),
         band3(gpr %between% c(-1L, 1L), , q > 9L))
  exp_eq(and3s(gps %between% c(-1L, 1L), s < 0L, ),
         band3(gps %between% c(-1L, 1L), s < 0L, ))
  exp_eq(and3s(gpt %between% c(-1L, 1L), d < 1L, ),
         band3(gpt %between% c(-1L, 1L), d < 1L, ))
  exp_eq(and3s(gpu %between% c(-1L, 1L), n < 9L, ),
         band3(gpu %between% c(-1L, 1L), n < 9L, ))
  exp_eq(and3s(gpv %between% c(-1L, 1L), x < 0L, j > 0L),
         band3(gpv %between% c(-1L, 1L), x < 0L, j > 0L))
  exp_eq(and3s(gpw %between% c(-1L, 1L), x < 1L, h > 1L),
         band3(gpw %between% c(-1L, 1L), x < 1L, h > 1L))
  exp_eq(and3s(gpx %between% c(-1L, 1L), z < 9L, z > 9L),
         band3(gpx %between% c(-1L, 1L), z < 9L, z > 9L))
  exp_eq(and3s(gpy %between% c(-1L, 1L), , ),
         band3(gpy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gpz %between% c(-1L, 1L), , ),
         band3(gpz %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqa %between% c(-1L, 1L), , ),
         band3(gqa %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqb %between% c(-1L, 1L), , f >= 0L),
         band3(gqb %between% c(-1L, 1L), , f >= 0L))
  exp_eq(and3s(gqc %between% c(-1L, 1L), , o >= 1L),
         band3(gqc %between% c(-1L, 1L), , o >= 1L))
  exp_eq(and3s(gqd %between% c(-1L, 1L), , v >= 9L),
         band3(gqd %between% c(-1L, 1L), , v >= 9L))
  exp_eq(and3s(gqe %between% c(-1L, 1L), h < 0L, ),
         band3(gqe %between% c(-1L, 1L), h < 0L, ))
  exp_eq(and3s(gqf %between% c(-1L, 1L), i < 1L, ),
         band3(gqf %between% c(-1L, 1L), i < 1L, ))
  exp_eq(and3s(gqg %between% c(-1L, 1L), b < 9L, ),
         band3(gqg %between% c(-1L, 1L), b < 9L, ))
  exp_eq(and3s(gqh %between% c(-1L, 1L), x < 0L, u >= 0L),
         band3(gqh %between% c(-1L, 1L), x < 0L, u >= 0L))
  exp_eq(and3s(gqi %between% c(-1L, 1L), u < 1L, r >= 1L),
         band3(gqi %between% c(-1L, 1L), u < 1L, r >= 1L))
  exp_eq(and3s(gqj %between% c(-1L, 1L), z < 9L, i >= 9L),
         band3(gqj %between% c(-1L, 1L), z < 9L, i >= 9L))
  exp_eq(and3s(gqk %between% c(-1L, 1L), , ),
         band3(gqk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gql %between% c(-1L, 1L), , ),
         band3(gql %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqm %between% c(-1L, 1L), , ),
         band3(gqm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqn %between% c(-1L, 1L), , logi_k),
         band3(gqn %between% c(-1L, 1L), , logi_k))
  exp_eq(and3s(gqo %between% c(-1L, 1L), , logi_u),
         band3(gqo %between% c(-1L, 1L), , logi_u))
  exp_eq(and3s(gqp %between% c(-1L, 1L), , logi_l),
         band3(gqp %between% c(-1L, 1L), , logi_l))
  exp_eq(and3s(gqq %between% c(-1L, 1L), w <= 0L, ),
         band3(gqq %between% c(-1L, 1L), w <= 0L, ))
  exp_eq(and3s(gqr %between% c(-1L, 1L), b <= 1L, ),
         band3(gqr %between% c(-1L, 1L), b <= 1L, ))
  exp_eq(and3s(gqs %between% c(-1L, 1L), v <= 9L, ),
         band3(gqs %between% c(-1L, 1L), v <= 9L, ))
  exp_eq(and3s(gqt %between% c(-1L, 1L), m <= 0L, logi_i),
         band3(gqt %between% c(-1L, 1L), m <= 0L, logi_i))
  exp_eq(and3s(gqu %between% c(-1L, 1L), f <= 1L, logi_z),
         band3(gqu %between% c(-1L, 1L), f <= 1L, logi_z))
  exp_eq(and3s(gqv %between% c(-1L, 1L), e <= 9L, logi_a),
         band3(gqv %between% c(-1L, 1L), e <= 9L, logi_a))
  exp_eq(and3s(gqw %between% c(-1L, 1L), , ),
         band3(gqw %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqx %between% c(-1L, 1L), , ),
         band3(gqx %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqy %between% c(-1L, 1L), , ),
         band3(gqy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gqz %between% c(-1L, 1L), , !logi_h),
         band3(gqz %between% c(-1L, 1L), , !logi_h))
  exp_eq(and3s(gra %between% c(-1L, 1L), , !logi_m),
         band3(gra %between% c(-1L, 1L), , !logi_m))
  exp_eq(and3s(grb %between% c(-1L, 1L), , !logi_k),
         band3(grb %between% c(-1L, 1L), , !logi_k))
  exp_eq(and3s(grc %between% c(-1L, 1L), o <= 0L, ),
         band3(grc %between% c(-1L, 1L), o <= 0L, ))
  exp_eq(and3s(grd %between% c(-1L, 1L), u <= 1L, ),
         band3(grd %between% c(-1L, 1L), u <= 1L, ))
  exp_eq(and3s(gre %between% c(-1L, 1L), n <= 9L, ),
         band3(gre %between% c(-1L, 1L), n <= 9L, ))
  exp_eq(and3s(grf %between% c(-1L, 1L), r <= 0L, !logi_y),
         band3(grf %between% c(-1L, 1L), r <= 0L, !logi_y))
  exp_eq(and3s(grg %between% c(-1L, 1L), s <= 1L, !logi_z),
         band3(grg %between% c(-1L, 1L), s <= 1L, !logi_z))
  exp_eq(and3s(grh %between% c(-1L, 1L), n <= 9L, !logi_i),
         band3(grh %between% c(-1L, 1L), n <= 9L, !logi_i))
  exp_eq(and3s(gri %between% c(-1L, 1L), , ),
         band3(gri %between% c(-1L, 1L), , ))
  exp_eq(and3s(grj %between% c(-1L, 1L), , ),
         band3(grj %between% c(-1L, 1L), , ))
  exp_eq(and3s(grk %between% c(-1L, 1L), , ),
         band3(grk %between% c(-1L, 1L), , ))
  exp_eq(and3s(grl %between% c(-1L, 1L), , s != 0L),
         band3(grl %between% c(-1L, 1L), , s != 0L))
  exp_eq(and3s(grm %between% c(-1L, 1L), , v != 1L),
         band3(grm %between% c(-1L, 1L), , v != 1L))
  exp_eq(and3s(grn %between% c(-1L, 1L), , i != 9L),
         band3(grn %between% c(-1L, 1L), , i != 9L))
  exp_eq(and3s(gro %between% c(-1L, 1L), m <= 0L, ),
         band3(gro %between% c(-1L, 1L), m <= 0L, ))
  exp_eq(and3s(grp %between% c(-1L, 1L), b <= 1L, ),
         band3(grp %between% c(-1L, 1L), b <= 1L, ))
  exp_eq(and3s(grq %between% c(-1L, 1L), r <= 9L, ),
         band3(grq %between% c(-1L, 1L), r <= 9L, ))
  exp_eq(and3s(grr %between% c(-1L, 1L), a <= 0L, s != 0L),
         band3(grr %between% c(-1L, 1L), a <= 0L, s != 0L))
  exp_eq(and3s(grs %between% c(-1L, 1L), j <= 1L, q != 1L),
         band3(grs %between% c(-1L, 1L), j <= 1L, q != 1L))
  exp_eq(and3s(grt %between% c(-1L, 1L), t <= 9L, p != 9L),
         band3(grt %between% c(-1L, 1L), t <= 9L, p != 9L))
  exp_eq(and3s(gru %between% c(-1L, 1L), , ),
         band3(gru %between% c(-1L, 1L), , ))
  exp_eq(and3s(grv %between% c(-1L, 1L), , ),
         band3(grv %between% c(-1L, 1L), , ))
  exp_eq(and3s(grw %between% c(-1L, 1L), , ),
         band3(grw %between% c(-1L, 1L), , ))
  exp_eq(and3s(grx %between% c(-1L, 1L), , a %between% c(-1L, 1L)),
         band3(grx %between% c(-1L, 1L), , a %between% c(-1L, 1L)))
  exp_eq(and3s(gry %between% c(-1L, 1L), , p %between% c(-1L, 1L)),
         band3(gry %between% c(-1L, 1L), , p %between% c(-1L, 1L)))
  exp_eq(and3s(grz %between% c(-1L, 1L), , q %between% c(-1L, 1L)),
         band3(grz %between% c(-1L, 1L), , q %between% c(-1L, 1L)))
  exp_eq(and3s(gsa %between% c(-1L, 1L), u <= 0L, ),
         band3(gsa %between% c(-1L, 1L), u <= 0L, ))
  exp_eq(and3s(gsb %between% c(-1L, 1L), a <= 1L, ),
         band3(gsb %between% c(-1L, 1L), a <= 1L, ))
  exp_eq(and3s(gsc %between% c(-1L, 1L), u <= 9L, ),
         band3(gsc %between% c(-1L, 1L), u <= 9L, ))
  exp_eq(and3s(gsd %between% c(-1L, 1L), r <= 0L, w %between% c(-1L, 1L)),
         band3(gsd %between% c(-1L, 1L), r <= 0L, w %between% c(-1L, 1L)))
  exp_eq(and3s(gse %between% c(-1L, 1L), i <= 1L, w %between% c(-1L, 1L)),
         band3(gse %between% c(-1L, 1L), i <= 1L, w %between% c(-1L, 1L)))
  exp_eq(and3s(gsf %between% c(-1L, 1L), g <= 9L, b %between% c(-1L, 1L)),
         band3(gsf %between% c(-1L, 1L), g <= 9L, b %between% c(-1L, 1L)))
  exp_eq(and3s(gsg %between% c(-1L, 1L), , ),
         band3(gsg %between% c(-1L, 1L), , ))
  exp_eq(and3s(gsh %between% c(-1L, 1L), , ),
         band3(gsh %between% c(-1L, 1L), , ))
  exp_eq(and3s(gsi %between% c(-1L, 1L), , ),
         band3(gsi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gsj %between% c(-1L, 1L), , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsj %between% c(-1L, 1L), , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gsk %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsk %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gsl %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsl %between% c(-1L, 1L), , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gsm %between% c(-1L, 1L), m <= 0L, ),
         band3(gsm %between% c(-1L, 1L), m <= 0L, ))
  exp_eq(and3s(gsn %between% c(-1L, 1L), r <= 1L, ),
         band3(gsn %between% c(-1L, 1L), r <= 1L, ))
  exp_eq(and3s(gso %between% c(-1L, 1L), e <= 9L, ),
         band3(gso %between% c(-1L, 1L), e <= 9L, ))
  exp_eq(and3s(gsp %between% c(-1L, 1L), v <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsp %between% c(-1L, 1L), v <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gsq %between% c(-1L, 1L), n <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsq %between% c(-1L, 1L), n <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gsr %between% c(-1L, 1L), d <= 9L, i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gsr %between% c(-1L, 1L), d <= 9L, i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gss %between% c(-1L, 1L), , ),
         band3(gss %between% c(-1L, 1L), , ))
  exp_eq(and3s(gst %between% c(-1L, 1L), , ),
         band3(gst %between% c(-1L, 1L), , ))
  exp_eq(and3s(gsu %between% c(-1L, 1L), , ),
         band3(gsu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gsv %between% c(-1L, 1L), , a %in% 1:4),
         band3(gsv %between% c(-1L, 1L), , a %in% 1:4))
  exp_eq(and3s(gsw %between% c(-1L, 1L), , f %in% 1:4),
         band3(gsw %between% c(-1L, 1L), , f %in% 1:4))
  exp_eq(and3s(gsx %between% c(-1L, 1L), , x %in% 1:4),
         band3(gsx %between% c(-1L, 1L), , x %in% 1:4))
  exp_eq(and3s(gsy %between% c(-1L, 1L), o <= 0L, ),
         band3(gsy %between% c(-1L, 1L), o <= 0L, ))
  exp_eq(and3s(gsz %between% c(-1L, 1L), k <= 1L, ),
         band3(gsz %between% c(-1L, 1L), k <= 1L, ))
  exp_eq(and3s(gta %between% c(-1L, 1L), k <= 9L, ),
         band3(gta %between% c(-1L, 1L), k <= 9L, ))
  exp_eq(and3s(gtb %between% c(-1L, 1L), i <= 0L, a %in% 1:4),
         band3(gtb %between% c(-1L, 1L), i <= 0L, a %in% 1:4))
  exp_eq(and3s(gtc %between% c(-1L, 1L), w <= 1L, g %in% 1:4),
         band3(gtc %between% c(-1L, 1L), w <= 1L, g %in% 1:4))
  exp_eq(and3s(gtd %between% c(-1L, 1L), v <= 9L, h %in% 1:4),
         band3(gtd %between% c(-1L, 1L), v <= 9L, h %in% 1:4))
  exp_eq(and3s(gte %between% c(-1L, 1L), , ),
         band3(gte %between% c(-1L, 1L), , ))
  exp_eq(and3s(gtf %between% c(-1L, 1L), , ),
         band3(gtf %between% c(-1L, 1L), , ))
  exp_eq(and3s(gtg %between% c(-1L, 1L), , ),
         band3(gtg %between% c(-1L, 1L), , ))
  exp_eq(and3s(gth %between% c(-1L, 1L), , d < 0L),
         band3(gth %between% c(-1L, 1L), , d < 0L))
  exp_eq(and3s(gti %between% c(-1L, 1L), , p < 1L),
         band3(gti %between% c(-1L, 1L), , p < 1L))
  exp_eq(and3s(gtj %between% c(-1L, 1L), , c < 9L),
         band3(gtj %between% c(-1L, 1L), , c < 9L))
  exp_eq(and3s(gtk %between% c(-1L, 1L), f <= 0L, ),
         band3(gtk %between% c(-1L, 1L), f <= 0L, ))
  exp_eq(and3s(gtl %between% c(-1L, 1L), f <= 1L, ),
         band3(gtl %between% c(-1L, 1L), f <= 1L, ))
  exp_eq(and3s(gtm %between% c(-1L, 1L), q <= 9L, ),
         band3(gtm %between% c(-1L, 1L), q <= 9L, ))
  exp_eq(and3s(gtn %between% c(-1L, 1L), l <= 0L, x < 0L),
         band3(gtn %between% c(-1L, 1L), l <= 0L, x < 0L))
  exp_eq(and3s(gto %between% c(-1L, 1L), q <= 1L, p < 1L),
         band3(gto %between% c(-1L, 1L), q <= 1L, p < 1L))
  exp_eq(and3s(gtp %between% c(-1L, 1L), j <= 9L, n < 9L),
         band3(gtp %between% c(-1L, 1L), j <= 9L, n < 9L))
  exp_eq(and3s(gtq %between% c(-1L, 1L), , ),
         band3(gtq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gtr %between% c(-1L, 1L), , ),
         band3(gtr %between% c(-1L, 1L), , ))
  exp_eq(and3s(gts %between% c(-1L, 1L), , ),
         band3(gts %between% c(-1L, 1L), , ))
  exp_eq(and3s(gtt %between% c(-1L, 1L), , k <= 0L),
         band3(gtt %between% c(-1L, 1L), , k <= 0L))
  exp_eq(and3s(gtu %between% c(-1L, 1L), , u <= 1L),
         band3(gtu %between% c(-1L, 1L), , u <= 1L))
  exp_eq(and3s(gtv %between% c(-1L, 1L), , c <= 9L),
         band3(gtv %between% c(-1L, 1L), , c <= 9L))
  exp_eq(and3s(gtw %between% c(-1L, 1L), s <= 0L, ),
         band3(gtw %between% c(-1L, 1L), s <= 0L, ))
  exp_eq(and3s(gtx %between% c(-1L, 1L), e <= 1L, ),
         band3(gtx %between% c(-1L, 1L), e <= 1L, ))
  exp_eq(and3s(gty %between% c(-1L, 1L), v <= 9L, ),
         band3(gty %between% c(-1L, 1L), v <= 9L, ))
  exp_eq(and3s(gtz %between% c(-1L, 1L), d <= 0L, k <= 0L),
         band3(gtz %between% c(-1L, 1L), d <= 0L, k <= 0L))
  exp_eq(and3s(gua %between% c(-1L, 1L), c <= 1L, d <= 1L),
         band3(gua %between% c(-1L, 1L), c <= 1L, d <= 1L))
  exp_eq(and3s(gub %between% c(-1L, 1L), g <= 9L, r <= 9L),
         band3(gub %between% c(-1L, 1L), g <= 9L, r <= 9L))
  exp_eq(and3s(guc %between% c(-1L, 1L), , ),
         band3(guc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gud %between% c(-1L, 1L), , ),
         band3(gud %between% c(-1L, 1L), , ))
  exp_eq(and3s(gue %between% c(-1L, 1L), , ),
         band3(gue %between% c(-1L, 1L), , ))
  exp_eq(and3s(guf %between% c(-1L, 1L), , q == 0L),
         band3(guf %between% c(-1L, 1L), , q == 0L))
  exp_eq(and3s(gug %between% c(-1L, 1L), , k == 1L),
         band3(gug %between% c(-1L, 1L), , k == 1L))
  exp_eq(and3s(guh %between% c(-1L, 1L), , x == 9L),
         band3(guh %between% c(-1L, 1L), , x == 9L))
  exp_eq(and3s(gui %between% c(-1L, 1L), b <= 0L, ),
         band3(gui %between% c(-1L, 1L), b <= 0L, ))
  exp_eq(and3s(guj %between% c(-1L, 1L), v <= 1L, ),
         band3(guj %between% c(-1L, 1L), v <= 1L, ))
  exp_eq(and3s(guk %between% c(-1L, 1L), k <= 9L, ),
         band3(guk %between% c(-1L, 1L), k <= 9L, ))
  exp_eq(and3s(gul %between% c(-1L, 1L), h <= 0L, m == 0L),
         band3(gul %between% c(-1L, 1L), h <= 0L, m == 0L))
  exp_eq(and3s(gum %between% c(-1L, 1L), h <= 1L, k == 1L),
         band3(gum %between% c(-1L, 1L), h <= 1L, k == 1L))
  exp_eq(and3s(gun %between% c(-1L, 1L), j <= 9L, v == 9L),
         band3(gun %between% c(-1L, 1L), j <= 9L, v == 9L))
  exp_eq(and3s(guo %between% c(-1L, 1L), , ),
         band3(guo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gup %between% c(-1L, 1L), , ),
         band3(gup %between% c(-1L, 1L), , ))
  exp_eq(and3s(guq %between% c(-1L, 1L), , ),
         band3(guq %between% c(-1L, 1L), , ))
  exp_eq(and3s(gur %between% c(-1L, 1L), , n > 0L),
         band3(gur %between% c(-1L, 1L), , n > 0L))
  exp_eq(and3s(gus %between% c(-1L, 1L), , p > 1L),
         band3(gus %between% c(-1L, 1L), , p > 1L))
  exp_eq(and3s(gut %between% c(-1L, 1L), , j > 9L),
         band3(gut %between% c(-1L, 1L), , j > 9L))
  exp_eq(and3s(guu %between% c(-1L, 1L), u <= 0L, ),
         band3(guu %between% c(-1L, 1L), u <= 0L, ))
  exp_eq(and3s(guv %between% c(-1L, 1L), s <= 1L, ),
         band3(guv %between% c(-1L, 1L), s <= 1L, ))
  exp_eq(and3s(guw %between% c(-1L, 1L), k <= 9L, ),
         band3(guw %between% c(-1L, 1L), k <= 9L, ))
  exp_eq(and3s(gux %between% c(-1L, 1L), e <= 0L, e > 0L),
         band3(gux %between% c(-1L, 1L), e <= 0L, e > 0L))
  exp_eq(and3s(guy %between% c(-1L, 1L), y <= 1L, u > 1L),
         band3(guy %between% c(-1L, 1L), y <= 1L, u > 1L))
  exp_eq(and3s(guz %between% c(-1L, 1L), p <= 9L, m > 9L),
         band3(guz %between% c(-1L, 1L), p <= 9L, m > 9L))
  exp_eq(and3s(gva %between% c(-1L, 1L), , ),
         band3(gva %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvb %between% c(-1L, 1L), , ),
         band3(gvb %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvc %between% c(-1L, 1L), , ),
         band3(gvc %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvd %between% c(-1L, 1L), , k >= 0L),
         band3(gvd %between% c(-1L, 1L), , k >= 0L))
  exp_eq(and3s(gve %between% c(-1L, 1L), , b >= 1L),
         band3(gve %between% c(-1L, 1L), , b >= 1L))
  exp_eq(and3s(gvf %between% c(-1L, 1L), , o >= 9L),
         band3(gvf %between% c(-1L, 1L), , o >= 9L))
  exp_eq(and3s(gvg %between% c(-1L, 1L), s <= 0L, ),
         band3(gvg %between% c(-1L, 1L), s <= 0L, ))
  exp_eq(and3s(gvh %between% c(-1L, 1L), p <= 1L, ),
         band3(gvh %between% c(-1L, 1L), p <= 1L, ))
  exp_eq(and3s(gvi %between% c(-1L, 1L), z <= 9L, ),
         band3(gvi %between% c(-1L, 1L), z <= 9L, ))
  exp_eq(and3s(gvj %between% c(-1L, 1L), t <= 0L, k >= 0L),
         band3(gvj %between% c(-1L, 1L), t <= 0L, k >= 0L))
  exp_eq(and3s(gvk %between% c(-1L, 1L), d <= 1L, b >= 1L),
         band3(gvk %between% c(-1L, 1L), d <= 1L, b >= 1L))
  exp_eq(and3s(gvl %between% c(-1L, 1L), c <= 9L, t >= 9L),
         band3(gvl %between% c(-1L, 1L), c <= 9L, t >= 9L))
  exp_eq(and3s(gvm %between% c(-1L, 1L), , ),
         band3(gvm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvn %between% c(-1L, 1L), , ),
         band3(gvn %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvo %between% c(-1L, 1L), , ),
         band3(gvo %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvp %between% c(-1L, 1L), , logi_l),
         band3(gvp %between% c(-1L, 1L), , logi_l))
  exp_eq(and3s(gvq %between% c(-1L, 1L), , logi_f),
         band3(gvq %between% c(-1L, 1L), , logi_f))
  exp_eq(and3s(gvr %between% c(-1L, 1L), , logi_f),
         band3(gvr %between% c(-1L, 1L), , logi_f))
  exp_eq(and3s(gvs %between% c(-1L, 1L), e == 0L, ),
         band3(gvs %between% c(-1L, 1L), e == 0L, ))
  exp_eq(and3s(gvt %between% c(-1L, 1L), e == 1L, ),
         band3(gvt %between% c(-1L, 1L), e == 1L, ))
  exp_eq(and3s(gvu %between% c(-1L, 1L), z == 9L, ),
         band3(gvu %between% c(-1L, 1L), z == 9L, ))
  exp_eq(and3s(gvv %between% c(-1L, 1L), k == 0L, logi_a),
         band3(gvv %between% c(-1L, 1L), k == 0L, logi_a))
  exp_eq(and3s(gvw %between% c(-1L, 1L), p == 1L, logi_o),
         band3(gvw %between% c(-1L, 1L), p == 1L, logi_o))
  exp_eq(and3s(gvx %between% c(-1L, 1L), m == 9L, logi_v),
         band3(gvx %between% c(-1L, 1L), m == 9L, logi_v))
  exp_eq(and3s(gvy %between% c(-1L, 1L), , ),
         band3(gvy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gvz %between% c(-1L, 1L), , ),
         band3(gvz %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwa %between% c(-1L, 1L), , ),
         band3(gwa %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwb %between% c(-1L, 1L), , !logi_z),
         band3(gwb %between% c(-1L, 1L), , !logi_z))
  exp_eq(and3s(gwc %between% c(-1L, 1L), , !logi_b),
         band3(gwc %between% c(-1L, 1L), , !logi_b))
  exp_eq(and3s(gwd %between% c(-1L, 1L), , !logi_r),
         band3(gwd %between% c(-1L, 1L), , !logi_r))
  exp_eq(and3s(gwe %between% c(-1L, 1L), f == 0L, ),
         band3(gwe %between% c(-1L, 1L), f == 0L, ))
  exp_eq(and3s(gwf %between% c(-1L, 1L), i == 1L, ),
         band3(gwf %between% c(-1L, 1L), i == 1L, ))
  exp_eq(and3s(gwg %between% c(-1L, 1L), a == 9L, ),
         band3(gwg %between% c(-1L, 1L), a == 9L, ))
  exp_eq(and3s(gwh %between% c(-1L, 1L), t == 0L, !logi_d),
         band3(gwh %between% c(-1L, 1L), t == 0L, !logi_d))
  exp_eq(and3s(gwi %between% c(-1L, 1L), a == 1L, !logi_o),
         band3(gwi %between% c(-1L, 1L), a == 1L, !logi_o))
  exp_eq(and3s(gwj %between% c(-1L, 1L), b == 9L, !logi_x),
         band3(gwj %between% c(-1L, 1L), b == 9L, !logi_x))
  exp_eq(and3s(gwk %between% c(-1L, 1L), , ),
         band3(gwk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwl %between% c(-1L, 1L), , ),
         band3(gwl %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwm %between% c(-1L, 1L), , ),
         band3(gwm %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwn %between% c(-1L, 1L), , d != 0L),
         band3(gwn %between% c(-1L, 1L), , d != 0L))
  exp_eq(and3s(gwo %between% c(-1L, 1L), , f != 1L),
         band3(gwo %between% c(-1L, 1L), , f != 1L))
  exp_eq(and3s(gwp %between% c(-1L, 1L), , z != 9L),
         band3(gwp %between% c(-1L, 1L), , z != 9L))
  exp_eq(and3s(gwq %between% c(-1L, 1L), l == 0L, ),
         band3(gwq %between% c(-1L, 1L), l == 0L, ))
  exp_eq(and3s(gwr %between% c(-1L, 1L), h == 1L, ),
         band3(gwr %between% c(-1L, 1L), h == 1L, ))
  exp_eq(and3s(gws %between% c(-1L, 1L), g == 9L, ),
         band3(gws %between% c(-1L, 1L), g == 9L, ))
  exp_eq(and3s(gwt %between% c(-1L, 1L), n == 0L, v != 0L),
         band3(gwt %between% c(-1L, 1L), n == 0L, v != 0L))
  exp_eq(and3s(gwu %between% c(-1L, 1L), s == 1L, a != 1L),
         band3(gwu %between% c(-1L, 1L), s == 1L, a != 1L))
  exp_eq(and3s(gwv %between% c(-1L, 1L), w == 9L, k != 9L),
         band3(gwv %between% c(-1L, 1L), w == 9L, k != 9L))
  exp_eq(and3s(gww %between% c(-1L, 1L), , ),
         band3(gww %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwx %between% c(-1L, 1L), , ),
         band3(gwx %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwy %between% c(-1L, 1L), , ),
         band3(gwy %between% c(-1L, 1L), , ))
  exp_eq(and3s(gwz %between% c(-1L, 1L), , l %between% c(-1L, 1L)),
         band3(gwz %between% c(-1L, 1L), , l %between% c(-1L, 1L)))
  exp_eq(and3s(gxa %between% c(-1L, 1L), , k %between% c(-1L, 1L)),
         band3(gxa %between% c(-1L, 1L), , k %between% c(-1L, 1L)))
  exp_eq(and3s(gxb %between% c(-1L, 1L), , i %between% c(-1L, 1L)),
         band3(gxb %between% c(-1L, 1L), , i %between% c(-1L, 1L)))
  exp_eq(and3s(gxc %between% c(-1L, 1L), v == 0L, ),
         band3(gxc %between% c(-1L, 1L), v == 0L, ))
  exp_eq(and3s(gxd %between% c(-1L, 1L), j == 1L, ),
         band3(gxd %between% c(-1L, 1L), j == 1L, ))
  exp_eq(and3s(gxe %between% c(-1L, 1L), l == 9L, ),
         band3(gxe %between% c(-1L, 1L), l == 9L, ))
  exp_eq(and3s(gxf %between% c(-1L, 1L), u == 0L, y %between% c(-1L, 1L)),
         band3(gxf %between% c(-1L, 1L), u == 0L, y %between% c(-1L, 1L)))
  exp_eq(and3s(gxg %between% c(-1L, 1L), j == 1L, h %between% c(-1L, 1L)),
         band3(gxg %between% c(-1L, 1L), j == 1L, h %between% c(-1L, 1L)))
  exp_eq(and3s(gxh %between% c(-1L, 1L), o == 9L, s %between% c(-1L, 1L)),
         band3(gxh %between% c(-1L, 1L), o == 9L, s %between% c(-1L, 1L)))
  exp_eq(and3s(gxi %between% c(-1L, 1L), , ),
         band3(gxi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxj %between% c(-1L, 1L), , ),
         band3(gxj %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxk %between% c(-1L, 1L), , ),
         band3(gxk %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxl %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxl %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxm %between% c(-1L, 1L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxm %between% c(-1L, 1L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxn %between% c(-1L, 1L), , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxn %between% c(-1L, 1L), , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxo %between% c(-1L, 1L), a == 0L, ),
         band3(gxo %between% c(-1L, 1L), a == 0L, ))
  exp_eq(and3s(gxp %between% c(-1L, 1L), t == 1L, ),
         band3(gxp %between% c(-1L, 1L), t == 1L, ))
  exp_eq(and3s(gxq %between% c(-1L, 1L), o == 9L, ),
         band3(gxq %between% c(-1L, 1L), o == 9L, ))
  exp_eq(and3s(gxr %between% c(-1L, 1L), g == 0L, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxr %between% c(-1L, 1L), g == 0L, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxs %between% c(-1L, 1L), t == 1L, i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxs %between% c(-1L, 1L), t == 1L, i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxt %between% c(-1L, 1L), h == 9L, f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(gxt %between% c(-1L, 1L), h == 9L, f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(gxu %between% c(-1L, 1L), , ),
         band3(gxu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxv %between% c(-1L, 1L), , ),
         band3(gxv %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxw %between% c(-1L, 1L), , ),
         band3(gxw %between% c(-1L, 1L), , ))
  exp_eq(and3s(gxx %between% c(-1L, 1L), , v %in% 1:4),
         band3(gxx %between% c(-1L, 1L), , v %in% 1:4))
  exp_eq(and3s(gxy %between% c(-1L, 1L), , i %in% 1:4),
         band3(gxy %between% c(-1L, 1L), , i %in% 1:4))
  exp_eq(and3s(gxz %between% c(-1L, 1L), , e %in% 1:4),
         band3(gxz %between% c(-1L, 1L), , e %in% 1:4))
  exp_eq(and3s(gya %between% c(-1L, 1L), u == 0L, ),
         band3(gya %between% c(-1L, 1L), u == 0L, ))
  exp_eq(and3s(gyb %between% c(-1L, 1L), e == 1L, ),
         band3(gyb %between% c(-1L, 1L), e == 1L, ))
  exp_eq(and3s(gyc %between% c(-1L, 1L), o == 9L, ),
         band3(gyc %between% c(-1L, 1L), o == 9L, ))
  exp_eq(and3s(gyd %between% c(-1L, 1L), b == 0L, r %in% 1:4),
         band3(gyd %between% c(-1L, 1L), b == 0L, r %in% 1:4))
  exp_eq(and3s(gye %between% c(-1L, 1L), v == 1L, z %in% 1:4),
         band3(gye %between% c(-1L, 1L), v == 1L, z %in% 1:4))
  exp_eq(and3s(gyf %between% c(-1L, 1L), w == 9L, a %in% 1:4),
         band3(gyf %between% c(-1L, 1L), w == 9L, a %in% 1:4))
  exp_eq(and3s(gyg %between% c(-1L, 1L), , ),
         band3(gyg %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyh %between% c(-1L, 1L), , ),
         band3(gyh %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyi %between% c(-1L, 1L), , ),
         band3(gyi %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyj %between% c(-1L, 1L), , o < 0L),
         band3(gyj %between% c(-1L, 1L), , o < 0L))
  exp_eq(and3s(gyk %between% c(-1L, 1L), , t < 1L),
         band3(gyk %between% c(-1L, 1L), , t < 1L))
  exp_eq(and3s(gyl %between% c(-1L, 1L), , v < 9L),
         band3(gyl %between% c(-1L, 1L), , v < 9L))
  exp_eq(and3s(gym %between% c(-1L, 1L), y == 0L, ),
         band3(gym %between% c(-1L, 1L), y == 0L, ))
  exp_eq(and3s(gyn %between% c(-1L, 1L), a == 1L, ),
         band3(gyn %between% c(-1L, 1L), a == 1L, ))
  exp_eq(and3s(gyo %between% c(-1L, 1L), c == 9L, ),
         band3(gyo %between% c(-1L, 1L), c == 9L, ))
  exp_eq(and3s(gyp %between% c(-1L, 1L), d == 0L, y < 0L),
         band3(gyp %between% c(-1L, 1L), d == 0L, y < 0L))
  exp_eq(and3s(gyq %between% c(-1L, 1L), x == 1L, i < 1L),
         band3(gyq %between% c(-1L, 1L), x == 1L, i < 1L))
  exp_eq(and3s(gyr %between% c(-1L, 1L), g == 9L, t < 9L),
         band3(gyr %between% c(-1L, 1L), g == 9L, t < 9L))
  exp_eq(and3s(gys %between% c(-1L, 1L), , ),
         band3(gys %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyt %between% c(-1L, 1L), , ),
         band3(gyt %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyu %between% c(-1L, 1L), , ),
         band3(gyu %between% c(-1L, 1L), , ))
  exp_eq(and3s(gyv %between% c(-1L, 1L), , e <= 0L),
         band3(gyv %between% c(-1L, 1L), , e <= 0L))
  exp_eq(and3s(gyw %between% c(-1L, 1L), , r <= 1L),
         band3(gyw %between% c(-1L, 1L), , r <= 1L))
  exp_eq(and3s(gyx %between% c(-1L, 1L), , e <= 9L),
         band3(gyx %between% c(-1L, 1L), , e <= 9L))
  exp_eq(and3s(gyy %between% c(-1L, 1L), v == 0L, ),
         band3(gyy %between% c(-1L, 1L), v == 0L, ))
  exp_eq(and3s(gyz %between% c(-1L, 1L), l == 1L, ),
         band3(gyz %between% c(-1L, 1L), l == 1L, ))
  exp_eq(and3s(ha %between% c(-1L, 1L), q == 9L, ),
         band3(ha %between% c(-1L, 1L), q == 9L, ))
  exp_eq(and3s(hb %between% c(-1L, 1L), g == 0L, z <= 0L),
         band3(hb %between% c(-1L, 1L), g == 0L, z <= 0L))
  exp_eq(and3s(hc %between% c(-1L, 1L), f == 1L, d <= 1L),
         band3(hc %between% c(-1L, 1L), f == 1L, d <= 1L))
  exp_eq(and3s(hd %between% c(-1L, 1L), r == 9L, q <= 9L),
         band3(hd %between% c(-1L, 1L), r == 9L, q <= 9L))
  exp_eq(and3s(he %between% c(-1L, 1L), , ),
         band3(he %between% c(-1L, 1L), , ))
  exp_eq(and3s(hf %between% c(-1L, 1L), , ),
         band3(hf %between% c(-1L, 1L), , ))
  exp_eq(and3s(hg %between% c(-1L, 1L), , ),
         band3(hg %between% c(-1L, 1L), , ))
  exp_eq(and3s(hh %between% c(-1L, 1L), , o == 0L),
         band3(hh %between% c(-1L, 1L), , o == 0L))
  exp_eq(and3s(hi %between% c(-1L, 1L), , a == 1L),
         band3(hi %between% c(-1L, 1L), , a == 1L))
  exp_eq(and3s(hj %between% c(-1L, 1L), , g == 9L),
         band3(hj %between% c(-1L, 1L), , g == 9L))
  exp_eq(and3s(hk %between% c(-1L, 1L), h == 0L, ),
         band3(hk %between% c(-1L, 1L), h == 0L, ))
  exp_eq(and3s(hl %between% c(-1L, 1L), w == 1L, ),
         band3(hl %between% c(-1L, 1L), w == 1L, ))
  exp_eq(and3s(hm %between% c(-1L, 1L), s == 9L, ),
         band3(hm %between% c(-1L, 1L), s == 9L, ))
  exp_eq(and3s(hn %between% c(-1L, 1L), q == 0L, n == 0L),
         band3(hn %between% c(-1L, 1L), q == 0L, n == 0L))
  exp_eq(and3s(ho %between% c(-1L, 1L), m == 1L, z == 1L),
         band3(ho %between% c(-1L, 1L), m == 1L, z == 1L))
  exp_eq(and3s(hp %between% c(-1L, 1L), o == 9L, x == 9L),
         band3(hp %between% c(-1L, 1L), o == 9L, x == 9L))
  exp_eq(and3s(hq %between% c(-1L, 1L), , ),
         band3(hq %between% c(-1L, 1L), , ))
  exp_eq(and3s(hr %between% c(-1L, 1L), , ),
         band3(hr %between% c(-1L, 1L), , ))
  exp_eq(and3s(hs %between% c(-1L, 1L), , ),
         band3(hs %between% c(-1L, 1L), , ))
  exp_eq(and3s(ht %between% c(-1L, 1L), , q > 0L),
         band3(ht %between% c(-1L, 1L), , q > 0L))
  exp_eq(and3s(hu %between% c(-1L, 1L), , s > 1L),
         band3(hu %between% c(-1L, 1L), , s > 1L))
  exp_eq(and3s(hv %between% c(-1L, 1L), , o > 9L),
         band3(hv %between% c(-1L, 1L), , o > 9L))
  exp_eq(and3s(hw %between% c(-1L, 1L), i == 0L, ),
         band3(hw %between% c(-1L, 1L), i == 0L, ))
  exp_eq(and3s(hx %between% c(-1L, 1L), v == 1L, ),
         band3(hx %between% c(-1L, 1L), v == 1L, ))
  exp_eq(and3s(hy %between% c(-1L, 1L), e == 9L, ),
         band3(hy %between% c(-1L, 1L), e == 9L, ))
  exp_eq(and3s(hz %between% c(-1L, 1L), b == 0L, t > 0L),
         band3(hz %between% c(-1L, 1L), b == 0L, t > 0L))
  exp_eq(and3s(haa %between% c(-1L, 1L), r == 1L, l > 1L),
         band3(haa %between% c(-1L, 1L), r == 1L, l > 1L))
  exp_eq(and3s(hab %between% c(-1L, 1L), f == 9L, s > 9L),
         band3(hab %between% c(-1L, 1L), f == 9L, s > 9L))
  exp_eq(and3s(hac %between% c(-1L, 1L), , ),
         band3(hac %between% c(-1L, 1L), , ))
  exp_eq(and3s(had %between% c(-1L, 1L), , ),
         band3(had %between% c(-1L, 1L), , ))
  exp_eq(and3s(hae %between% c(-1L, 1L), , ),
         band3(hae %between% c(-1L, 1L), , ))
  exp_eq(and3s(haf %between% c(-1L, 1L), , e >= 0L),
         band3(haf %between% c(-1L, 1L), , e >= 0L))
  exp_eq(and3s(hag %between% c(-1L, 1L), , v >= 1L),
         band3(hag %between% c(-1L, 1L), , v >= 1L))
  exp_eq(and3s(hah %between% c(-1L, 1L), , a >= 9L),
         band3(hah %between% c(-1L, 1L), , a >= 9L))
  exp_eq(and3s(hai %between% c(-1L, 1L), r == 0L, ),
         band3(hai %between% c(-1L, 1L), r == 0L, ))
  exp_eq(and3s(haj %between% c(-1L, 1L), g == 1L, ),
         band3(haj %between% c(-1L, 1L), g == 1L, ))
  exp_eq(and3s(hak %between% c(-1L, 1L), z == 9L, ),
         band3(hak %between% c(-1L, 1L), z == 9L, ))
  exp_eq(and3s(hal %between% c(-1L, 1L), n == 0L, a >= 0L),
         band3(hal %between% c(-1L, 1L), n == 0L, a >= 0L))
  exp_eq(and3s(ham %between% c(-1L, 1L), z == 1L, l >= 1L),
         band3(ham %between% c(-1L, 1L), z == 1L, l >= 1L))
  exp_eq(and3s(han %between% c(-1L, 1L), s == 9L, g >= 9L),
         band3(han %between% c(-1L, 1L), s == 9L, g >= 9L))
  exp_eq(and3s(hao %between% c(-1L, 1L), , ),
         band3(hao %between% c(-1L, 1L), , ))
  exp_eq(and3s(hap %between% c(-1L, 1L), , ),
         band3(hap %between% c(-1L, 1L), , ))
  exp_eq(and3s(haq %between% c(-1L, 1L), , ),
         band3(haq %between% c(-1L, 1L), , ))
  exp_eq(and3s(har %between% c(-1L, 1L), , logi_j),
         band3(har %between% c(-1L, 1L), , logi_j))
  exp_eq(and3s(has %between% c(-1L, 1L), , logi_p),
         band3(has %between% c(-1L, 1L), , logi_p))
  exp_eq(and3s(hat %between% c(-1L, 1L), , logi_k),
         band3(hat %between% c(-1L, 1L), , logi_k))
  exp_eq(and3s(hau %between% c(-1L, 1L), l > 0L, ),
         band3(hau %between% c(-1L, 1L), l > 0L, ))
  exp_eq(and3s(hav %between% c(-1L, 1L), i > 1L, ),
         band3(hav %between% c(-1L, 1L), i > 1L, ))
  exp_eq(and3s(haw %between% c(-1L, 1L), m > 9L, ),
         band3(haw %between% c(-1L, 1L), m > 9L, ))
  exp_eq(and3s(hax %between% c(-1L, 1L), l > 0L, logi_d),
         band3(hax %between% c(-1L, 1L), l > 0L, logi_d))
  exp_eq(and3s(hay %between% c(-1L, 1L), f > 1L, logi_y),
         band3(hay %between% c(-1L, 1L), f > 1L, logi_y))
  exp_eq(and3s(haz %between% c(-1L, 1L), z > 9L, logi_a),
         band3(haz %between% c(-1L, 1L), z > 9L, logi_a))
  exp_eq(and3s(hba %between% c(-1L, 1L), , ),
         band3(hba %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbb %between% c(-1L, 1L), , ),
         band3(hbb %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbc %between% c(-1L, 1L), , ),
         band3(hbc %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbd %between% c(-1L, 1L), , !logi_p),
         band3(hbd %between% c(-1L, 1L), , !logi_p))
  exp_eq(and3s(hbe %between% c(-1L, 1L), , !logi_e),
         band3(hbe %between% c(-1L, 1L), , !logi_e))
  exp_eq(and3s(hbf %between% c(-1L, 1L), , !logi_n),
         band3(hbf %between% c(-1L, 1L), , !logi_n))
  exp_eq(and3s(hbg %between% c(-1L, 1L), l > 0L, ),
         band3(hbg %between% c(-1L, 1L), l > 0L, ))
  exp_eq(and3s(hbh %between% c(-1L, 1L), e > 1L, ),
         band3(hbh %between% c(-1L, 1L), e > 1L, ))
  exp_eq(and3s(hbi %between% c(-1L, 1L), v > 9L, ),
         band3(hbi %between% c(-1L, 1L), v > 9L, ))
  exp_eq(and3s(hbj %between% c(-1L, 1L), m > 0L, !logi_l),
         band3(hbj %between% c(-1L, 1L), m > 0L, !logi_l))
  exp_eq(and3s(hbk %between% c(-1L, 1L), k > 1L, !logi_e),
         band3(hbk %between% c(-1L, 1L), k > 1L, !logi_e))
  exp_eq(and3s(hbl %between% c(-1L, 1L), c > 9L, !logi_f),
         band3(hbl %between% c(-1L, 1L), c > 9L, !logi_f))
  exp_eq(and3s(hbm %between% c(-1L, 1L), , ),
         band3(hbm %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbn %between% c(-1L, 1L), , ),
         band3(hbn %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbo %between% c(-1L, 1L), , ),
         band3(hbo %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbp %between% c(-1L, 1L), , o != 0L),
         band3(hbp %between% c(-1L, 1L), , o != 0L))
  exp_eq(and3s(hbq %between% c(-1L, 1L), , d != 1L),
         band3(hbq %between% c(-1L, 1L), , d != 1L))
  exp_eq(and3s(hbr %between% c(-1L, 1L), , s != 9L),
         band3(hbr %between% c(-1L, 1L), , s != 9L))
  exp_eq(and3s(hbs %between% c(-1L, 1L), e > 0L, ),
         band3(hbs %between% c(-1L, 1L), e > 0L, ))
  exp_eq(and3s(hbt %between% c(-1L, 1L), d > 1L, ),
         band3(hbt %between% c(-1L, 1L), d > 1L, ))
  exp_eq(and3s(hbu %between% c(-1L, 1L), d > 9L, ),
         band3(hbu %between% c(-1L, 1L), d > 9L, ))
  exp_eq(and3s(hbv %between% c(-1L, 1L), d > 0L, m != 0L),
         band3(hbv %between% c(-1L, 1L), d > 0L, m != 0L))
  exp_eq(and3s(hbw %between% c(-1L, 1L), c > 1L, e != 1L),
         band3(hbw %between% c(-1L, 1L), c > 1L, e != 1L))
  exp_eq(and3s(hbx %between% c(-1L, 1L), s > 9L, q != 9L),
         band3(hbx %between% c(-1L, 1L), s > 9L, q != 9L))
  exp_eq(and3s(hby %between% c(-1L, 1L), , ),
         band3(hby %between% c(-1L, 1L), , ))
  exp_eq(and3s(hbz %between% c(-1L, 1L), , ),
         band3(hbz %between% c(-1L, 1L), , ))
  exp_eq(and3s(hca %between% c(-1L, 1L), , ),
         band3(hca %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcb %between% c(-1L, 1L), , v %between% c(-1L, 1L)),
         band3(hcb %between% c(-1L, 1L), , v %between% c(-1L, 1L)))
  exp_eq(and3s(hcc %between% c(-1L, 1L), , f %between% c(-1L, 1L)),
         band3(hcc %between% c(-1L, 1L), , f %between% c(-1L, 1L)))
  exp_eq(and3s(hcd %between% c(-1L, 1L), , w %between% c(-1L, 1L)),
         band3(hcd %between% c(-1L, 1L), , w %between% c(-1L, 1L)))
  exp_eq(and3s(hce %between% c(-1L, 1L), p > 0L, ),
         band3(hce %between% c(-1L, 1L), p > 0L, ))
  exp_eq(and3s(hcf %between% c(-1L, 1L), r > 1L, ),
         band3(hcf %between% c(-1L, 1L), r > 1L, ))
  exp_eq(and3s(hcg %between% c(-1L, 1L), s > 9L, ),
         band3(hcg %between% c(-1L, 1L), s > 9L, ))
  exp_eq(and3s(hch %between% c(-1L, 1L), s > 0L, c %between% c(-1L, 1L)),
         band3(hch %between% c(-1L, 1L), s > 0L, c %between% c(-1L, 1L)))
  exp_eq(and3s(hci %between% c(-1L, 1L), e > 1L, r %between% c(-1L, 1L)),
         band3(hci %between% c(-1L, 1L), e > 1L, r %between% c(-1L, 1L)))
  exp_eq(and3s(hcj %between% c(-1L, 1L), b > 9L, b %between% c(-1L, 1L)),
         band3(hcj %between% c(-1L, 1L), b > 9L, b %between% c(-1L, 1L)))
  exp_eq(and3s(hck %between% c(-1L, 1L), , ),
         band3(hck %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcl %between% c(-1L, 1L), , ),
         band3(hcl %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcm %between% c(-1L, 1L), , ),
         band3(hcm %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcn %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hcn %between% c(-1L, 1L), , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hco %between% c(-1L, 1L), , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hco %between% c(-1L, 1L), , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hcp %between% c(-1L, 1L), , s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hcp %between% c(-1L, 1L), , s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hcq %between% c(-1L, 1L), b > 0L, ),
         band3(hcq %between% c(-1L, 1L), b > 0L, ))
  exp_eq(and3s(hcr %between% c(-1L, 1L), i > 1L, ),
         band3(hcr %between% c(-1L, 1L), i > 1L, ))
  exp_eq(and3s(hcs %between% c(-1L, 1L), z > 9L, ),
         band3(hcs %between% c(-1L, 1L), z > 9L, ))
  exp_eq(and3s(hct %between% c(-1L, 1L), r > 0L, i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hct %between% c(-1L, 1L), r > 0L, i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hcu %between% c(-1L, 1L), a > 1L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hcu %between% c(-1L, 1L), a > 1L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hcv %between% c(-1L, 1L), m > 9L, g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hcv %between% c(-1L, 1L), m > 9L, g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hcw %between% c(-1L, 1L), , ),
         band3(hcw %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcx %between% c(-1L, 1L), , ),
         band3(hcx %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcy %between% c(-1L, 1L), , ),
         band3(hcy %between% c(-1L, 1L), , ))
  exp_eq(and3s(hcz %between% c(-1L, 1L), , b %in% 1:4),
         band3(hcz %between% c(-1L, 1L), , b %in% 1:4))
  exp_eq(and3s(hda %between% c(-1L, 1L), , w %in% 1:4),
         band3(hda %between% c(-1L, 1L), , w %in% 1:4))
  exp_eq(and3s(hdb %between% c(-1L, 1L), , c %in% 1:4),
         band3(hdb %between% c(-1L, 1L), , c %in% 1:4))
  exp_eq(and3s(hdc %between% c(-1L, 1L), d > 0L, ),
         band3(hdc %between% c(-1L, 1L), d > 0L, ))
  exp_eq(and3s(hdd %between% c(-1L, 1L), k > 1L, ),
         band3(hdd %between% c(-1L, 1L), k > 1L, ))
  exp_eq(and3s(hde %between% c(-1L, 1L), v > 9L, ),
         band3(hde %between% c(-1L, 1L), v > 9L, ))
  exp_eq(and3s(hdf %between% c(-1L, 1L), q > 0L, h %in% 1:4),
         band3(hdf %between% c(-1L, 1L), q > 0L, h %in% 1:4))
  exp_eq(and3s(hdg %between% c(-1L, 1L), a > 1L, j %in% 1:4),
         band3(hdg %between% c(-1L, 1L), a > 1L, j %in% 1:4))
  exp_eq(and3s(hdh %between% c(-1L, 1L), p > 9L, c %in% 1:4),
         band3(hdh %between% c(-1L, 1L), p > 9L, c %in% 1:4))
  exp_eq(and3s(hdi %between% c(-1L, 1L), , ),
         band3(hdi %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdj %between% c(-1L, 1L), , ),
         band3(hdj %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdk %between% c(-1L, 1L), , ),
         band3(hdk %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdl %between% c(-1L, 1L), , j < 0L),
         band3(hdl %between% c(-1L, 1L), , j < 0L))
  exp_eq(and3s(hdm %between% c(-1L, 1L), , x < 1L),
         band3(hdm %between% c(-1L, 1L), , x < 1L))
  exp_eq(and3s(hdn %between% c(-1L, 1L), , o < 9L),
         band3(hdn %between% c(-1L, 1L), , o < 9L))
  exp_eq(and3s(hdo %between% c(-1L, 1L), f > 0L, ),
         band3(hdo %between% c(-1L, 1L), f > 0L, ))
  exp_eq(and3s(hdp %between% c(-1L, 1L), v > 1L, ),
         band3(hdp %between% c(-1L, 1L), v > 1L, ))
  exp_eq(and3s(hdq %between% c(-1L, 1L), m > 9L, ),
         band3(hdq %between% c(-1L, 1L), m > 9L, ))
  exp_eq(and3s(hdr %between% c(-1L, 1L), u > 0L, n < 0L),
         band3(hdr %between% c(-1L, 1L), u > 0L, n < 0L))
  exp_eq(and3s(hds %between% c(-1L, 1L), b > 1L, c < 1L),
         band3(hds %between% c(-1L, 1L), b > 1L, c < 1L))
  exp_eq(and3s(hdt %between% c(-1L, 1L), o > 9L, u < 9L),
         band3(hdt %between% c(-1L, 1L), o > 9L, u < 9L))
  exp_eq(and3s(hdu %between% c(-1L, 1L), , ),
         band3(hdu %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdv %between% c(-1L, 1L), , ),
         band3(hdv %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdw %between% c(-1L, 1L), , ),
         band3(hdw %between% c(-1L, 1L), , ))
  exp_eq(and3s(hdx %between% c(-1L, 1L), , l <= 0L),
         band3(hdx %between% c(-1L, 1L), , l <= 0L))
  exp_eq(and3s(hdy %between% c(-1L, 1L), , t <= 1L),
         band3(hdy %between% c(-1L, 1L), , t <= 1L))
  exp_eq(and3s(hdz %between% c(-1L, 1L), , u <= 9L),
         band3(hdz %between% c(-1L, 1L), , u <= 9L))
  exp_eq(and3s(hea %between% c(-1L, 1L), p > 0L, ),
         band3(hea %between% c(-1L, 1L), p > 0L, ))
  exp_eq(and3s(heb %between% c(-1L, 1L), q > 1L, ),
         band3(heb %between% c(-1L, 1L), q > 1L, ))
  exp_eq(and3s(hec %between% c(-1L, 1L), k > 9L, ),
         band3(hec %between% c(-1L, 1L), k > 9L, ))
  exp_eq(and3s(hed %between% c(-1L, 1L), b > 0L, v <= 0L),
         band3(hed %between% c(-1L, 1L), b > 0L, v <= 0L))
  exp_eq(and3s(hee %between% c(-1L, 1L), r > 1L, x <= 1L),
         band3(hee %between% c(-1L, 1L), r > 1L, x <= 1L))
  exp_eq(and3s(hef %between% c(-1L, 1L), h > 9L, s <= 9L),
         band3(hef %between% c(-1L, 1L), h > 9L, s <= 9L))
  exp_eq(and3s(heg %between% c(-1L, 1L), , ),
         band3(heg %between% c(-1L, 1L), , ))
  exp_eq(and3s(heh %between% c(-1L, 1L), , ),
         band3(heh %between% c(-1L, 1L), , ))
  exp_eq(and3s(hei %between% c(-1L, 1L), , ),
         band3(hei %between% c(-1L, 1L), , ))
  exp_eq(and3s(hej %between% c(-1L, 1L), , h == 0L),
         band3(hej %between% c(-1L, 1L), , h == 0L))
  exp_eq(and3s(hek %between% c(-1L, 1L), , h == 1L),
         band3(hek %between% c(-1L, 1L), , h == 1L))
  exp_eq(and3s(hel %between% c(-1L, 1L), , j == 9L),
         band3(hel %between% c(-1L, 1L), , j == 9L))
  exp_eq(and3s(hem %between% c(-1L, 1L), t > 0L, ),
         band3(hem %between% c(-1L, 1L), t > 0L, ))
  exp_eq(and3s(hen %between% c(-1L, 1L), h > 1L, ),
         band3(hen %between% c(-1L, 1L), h > 1L, ))
  exp_eq(and3s(heo %between% c(-1L, 1L), d > 9L, ),
         band3(heo %between% c(-1L, 1L), d > 9L, ))
  exp_eq(and3s(hep %between% c(-1L, 1L), m > 0L, g == 0L),
         band3(hep %between% c(-1L, 1L), m > 0L, g == 0L))
  exp_eq(and3s(heq %between% c(-1L, 1L), r > 1L, v == 1L),
         band3(heq %between% c(-1L, 1L), r > 1L, v == 1L))
  exp_eq(and3s(her %between% c(-1L, 1L), u > 9L, g == 9L),
         band3(her %between% c(-1L, 1L), u > 9L, g == 9L))
  exp_eq(and3s(hes %between% c(-1L, 1L), , ),
         band3(hes %between% c(-1L, 1L), , ))
  exp_eq(and3s(het %between% c(-1L, 1L), , ),
         band3(het %between% c(-1L, 1L), , ))
  exp_eq(and3s(heu %between% c(-1L, 1L), , ),
         band3(heu %between% c(-1L, 1L), , ))
  exp_eq(and3s(hev %between% c(-1L, 1L), , r > 0L),
         band3(hev %between% c(-1L, 1L), , r > 0L))
  exp_eq(and3s(hew %between% c(-1L, 1L), , q > 1L),
         band3(hew %between% c(-1L, 1L), , q > 1L))
  exp_eq(and3s(hex %between% c(-1L, 1L), , f > 9L),
         band3(hex %between% c(-1L, 1L), , f > 9L))
  exp_eq(and3s(hey %between% c(-1L, 1L), o > 0L, ),
         band3(hey %between% c(-1L, 1L), o > 0L, ))
  exp_eq(and3s(hez %between% c(-1L, 1L), p > 1L, ),
         band3(hez %between% c(-1L, 1L), p > 1L, ))
  exp_eq(and3s(hfa %between% c(-1L, 1L), w > 9L, ),
         band3(hfa %between% c(-1L, 1L), w > 9L, ))
  exp_eq(and3s(hfb %between% c(-1L, 1L), p > 0L, f > 0L),
         band3(hfb %between% c(-1L, 1L), p > 0L, f > 0L))
  exp_eq(and3s(hfc %between% c(-1L, 1L), s > 1L, n > 1L),
         band3(hfc %between% c(-1L, 1L), s > 1L, n > 1L))
  exp_eq(and3s(hfd %between% c(-1L, 1L), f > 9L, o > 9L),
         band3(hfd %between% c(-1L, 1L), f > 9L, o > 9L))
  exp_eq(and3s(hfe %between% c(-1L, 1L), , ),
         band3(hfe %between% c(-1L, 1L), , ))
  exp_eq(and3s(hff %between% c(-1L, 1L), , ),
         band3(hff %between% c(-1L, 1L), , ))
  exp_eq(and3s(hfg %between% c(-1L, 1L), , ),
         band3(hfg %between% c(-1L, 1L), , ))
  exp_eq(and3s(hfh %between% c(-1L, 1L), , o >= 0L),
         band3(hfh %between% c(-1L, 1L), , o >= 0L))
  exp_eq(and3s(hfi %between% c(-1L, 1L), , a >= 1L),
         band3(hfi %between% c(-1L, 1L), , a >= 1L))
  exp_eq(and3s(hfj %between% c(-1L, 1L), , g >= 9L),
         band3(hfj %between% c(-1L, 1L), , g >= 9L))
  exp_eq(and3s(hfk %between% c(-1L, 1L), u > 0L, ),
         band3(hfk %between% c(-1L, 1L), u > 0L, ))
  exp_eq(and3s(hfl %between% c(-1L, 1L), u > 1L, ),
         band3(hfl %between% c(-1L, 1L), u > 1L, ))
  exp_eq(and3s(hfm %between% c(-1L, 1L), w > 9L, ),
         band3(hfm %between% c(-1L, 1L), w > 9L, ))
  exp_eq(and3s(hfn %between% c(-1L, 1L), c > 0L, r >= 0L),
         band3(hfn %between% c(-1L, 1L), c > 0L, r >= 0L))
  exp_eq(and3s(hfo %between% c(-1L, 1L), b > 1L, q >= 1L),
         band3(hfo %between% c(-1L, 1L), b > 1L, q >= 1L))
  exp_eq(and3s(hfp %between% c(-1L, 1L), k > 9L, u >= 9L),
         band3(hfp %between% c(-1L, 1L), k > 9L, u >= 9L))
  exp_eq(and3s(hfq %between% c(-1L, 1L), , ),
         band3(hfq %between% c(-1L, 1L), , ))
  exp_eq(and3s(hfr %between% c(-1L, 1L), , ),
         band3(hfr %between% c(-1L, 1L), , ))
  exp_eq(and3s(hfs %between% c(-1L, 1L), , ),
         band3(hfs %between% c(-1L, 1L), , ))
  exp_eq(and3s(hft %between% c(-1L, 1L), , logi_a),
         band3(hft %between% c(-1L, 1L), , logi_a))
  exp_eq(and3s(hfu %between% c(-1L, 1L), , logi_u),
         band3(hfu %between% c(-1L, 1L), , logi_u))
  exp_eq(and3s(hfv %between% c(-1L, 1L), , logi_o),
         band3(hfv %between% c(-1L, 1L), , logi_o))
  exp_eq(and3s(hfw %between% c(-1L, 1L), l >= 0L, ),
         band3(hfw %between% c(-1L, 1L), l >= 0L, ))
  exp_eq(and3s(hfx %between% c(-1L, 1L), i >= 1L, ),
         band3(hfx %between% c(-1L, 1L), i >= 1L, ))
  exp_eq(and3s(hfy %between% c(-1L, 1L), l >= 9L, ),
         band3(hfy %between% c(-1L, 1L), l >= 9L, ))
  exp_eq(and3s(hfz %between% c(-1L, 1L), w >= 0L, logi_g),
         band3(hfz %between% c(-1L, 1L), w >= 0L, logi_g))
  exp_eq(and3s(hga %between% c(-1L, 1L), k >= 1L, logi_j),
         band3(hga %between% c(-1L, 1L), k >= 1L, logi_j))
  exp_eq(and3s(hgb %between% c(-1L, 1L), p >= 9L, logi_k),
         band3(hgb %between% c(-1L, 1L), p >= 9L, logi_k))
  exp_eq(and3s(hgc %between% c(-1L, 1L), , ),
         band3(hgc %between% c(-1L, 1L), , ))
  exp_eq(and3s(hgd %between% c(-1L, 1L), , ),
         band3(hgd %between% c(-1L, 1L), , ))
  exp_eq(and3s(hge %between% c(-1L, 1L), , ),
         band3(hge %between% c(-1L, 1L), , ))
  exp_eq(and3s(hgf %between% c(-1L, 1L), , !logi_t),
         band3(hgf %between% c(-1L, 1L), , !logi_t))
  exp_eq(and3s(hgg %between% c(-1L, 1L), , !logi_s),
         band3(hgg %between% c(-1L, 1L), , !logi_s))
  exp_eq(and3s(hgh %between% c(-1L, 1L), , !logi_y),
         band3(hgh %between% c(-1L, 1L), , !logi_y))
  exp_eq(and3s(hgi %between% c(-1L, 1L), d >= 0L, ),
         band3(hgi %between% c(-1L, 1L), d >= 0L, ))
  exp_eq(and3s(hgj %between% c(-1L, 1L), h >= 1L, ),
         band3(hgj %between% c(-1L, 1L), h >= 1L, ))
  exp_eq(and3s(hgk %between% c(-1L, 1L), q >= 9L, ),
         band3(hgk %between% c(-1L, 1L), q >= 9L, ))
  exp_eq(and3s(hgl %between% c(-1L, 1L), o >= 0L, !logi_v),
         band3(hgl %between% c(-1L, 1L), o >= 0L, !logi_v))
  exp_eq(and3s(hgm %between% c(-1L, 1L), f >= 1L, !logi_h),
         band3(hgm %between% c(-1L, 1L), f >= 1L, !logi_h))
  exp_eq(and3s(hgn %between% c(-1L, 1L), h >= 9L, !logi_g),
         band3(hgn %between% c(-1L, 1L), h >= 9L, !logi_g))
  exp_eq(and3s(hgo %between% c(-1L, 1L), , ),
         band3(hgo %between% c(-1L, 1L), , ))
  exp_eq(and3s(hgp %between% c(-1L, 1L), , ),
         band3(hgp %between% c(-1L, 1L), , ))
  exp_eq(and3s(hgq %between% c(-1L, 1L), , ),
         band3(hgq %between% c(-1L, 1L), , ))
  exp_eq(and3s(hgr %between% c(-1L, 1L), , u != 0L),
         band3(hgr %between% c(-1L, 1L), , u != 0L))
  exp_eq(and3s(hgs %between% c(-1L, 1L), , h != 1L),
         band3(hgs %between% c(-1L, 1L), , h != 1L))
  exp_eq(and3s(hgt %between% c(-1L, 1L), , z != 9L),
         band3(hgt %between% c(-1L, 1L), , z != 9L))
  exp_eq(and3s(hgu %between% c(-1L, 1L), k >= 0L, ),
         band3(hgu %between% c(-1L, 1L), k >= 0L, ))
  exp_eq(and3s(hgv %between% c(-1L, 1L), b >= 1L, ),
         band3(hgv %between% c(-1L, 1L), b >= 1L, ))
  exp_eq(and3s(hgw %between% c(-1L, 1L), k >= 9L, ),
         band3(hgw %between% c(-1L, 1L), k >= 9L, ))
  exp_eq(and3s(hgx %between% c(-1L, 1L), l >= 0L, r != 0L),
         band3(hgx %between% c(-1L, 1L), l >= 0L, r != 0L))
  exp_eq(and3s(hgy %between% c(-1L, 1L), q >= 1L, y != 1L),
         band3(hgy %between% c(-1L, 1L), q >= 1L, y != 1L))
  exp_eq(and3s(hgz %between% c(-1L, 1L), s >= 9L, u != 9L),
         band3(hgz %between% c(-1L, 1L), s >= 9L, u != 9L))
  exp_eq(and3s(hha %between% c(-1L, 1L), , ),
         band3(hha %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhb %between% c(-1L, 1L), , ),
         band3(hhb %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhc %between% c(-1L, 1L), , ),
         band3(hhc %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhd %between% c(-1L, 1L), , f %between% c(-1L, 1L)),
         band3(hhd %between% c(-1L, 1L), , f %between% c(-1L, 1L)))
  exp_eq(and3s(hhe %between% c(-1L, 1L), , y %between% c(-1L, 1L)),
         band3(hhe %between% c(-1L, 1L), , y %between% c(-1L, 1L)))
  exp_eq(and3s(hhf %between% c(-1L, 1L), , v %between% c(-1L, 1L)),
         band3(hhf %between% c(-1L, 1L), , v %between% c(-1L, 1L)))
  exp_eq(and3s(hhg %between% c(-1L, 1L), i >= 0L, ),
         band3(hhg %between% c(-1L, 1L), i >= 0L, ))
  exp_eq(and3s(hhh %between% c(-1L, 1L), s >= 1L, ),
         band3(hhh %between% c(-1L, 1L), s >= 1L, ))
  exp_eq(and3s(hhi %between% c(-1L, 1L), g >= 9L, ),
         band3(hhi %between% c(-1L, 1L), g >= 9L, ))
  exp_eq(and3s(hhj %between% c(-1L, 1L), j >= 0L, y %between% c(-1L, 1L)),
         band3(hhj %between% c(-1L, 1L), j >= 0L, y %between% c(-1L, 1L)))
  exp_eq(and3s(hhk %between% c(-1L, 1L), g >= 1L, q %between% c(-1L, 1L)),
         band3(hhk %between% c(-1L, 1L), g >= 1L, q %between% c(-1L, 1L)))
  exp_eq(and3s(hhl %between% c(-1L, 1L), u >= 9L, k %between% c(-1L, 1L)),
         band3(hhl %between% c(-1L, 1L), u >= 9L, k %between% c(-1L, 1L)))
  exp_eq(and3s(hhm %between% c(-1L, 1L), , ),
         band3(hhm %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhn %between% c(-1L, 1L), , ),
         band3(hhn %between% c(-1L, 1L), , ))
  exp_eq(and3s(hho %between% c(-1L, 1L), , ),
         band3(hho %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhp %between% c(-1L, 1L), , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhp %between% c(-1L, 1L), , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhq %between% c(-1L, 1L), , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhq %between% c(-1L, 1L), , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhr %between% c(-1L, 1L), , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhr %between% c(-1L, 1L), , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhs %between% c(-1L, 1L), h >= 0L, ),
         band3(hhs %between% c(-1L, 1L), h >= 0L, ))
  exp_eq(and3s(hht %between% c(-1L, 1L), z >= 1L, ),
         band3(hht %between% c(-1L, 1L), z >= 1L, ))
  exp_eq(and3s(hhu %between% c(-1L, 1L), j >= 9L, ),
         band3(hhu %between% c(-1L, 1L), j >= 9L, ))
  exp_eq(and3s(hhv %between% c(-1L, 1L), g >= 0L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhv %between% c(-1L, 1L), g >= 0L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhw %between% c(-1L, 1L), v >= 1L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhw %between% c(-1L, 1L), v >= 1L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhx %between% c(-1L, 1L), d >= 9L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hhx %between% c(-1L, 1L), d >= 9L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hhy %between% c(-1L, 1L), , ),
         band3(hhy %between% c(-1L, 1L), , ))
  exp_eq(and3s(hhz %between% c(-1L, 1L), , ),
         band3(hhz %between% c(-1L, 1L), , ))
  exp_eq(and3s(hia %between% c(-1L, 1L), , ),
         band3(hia %between% c(-1L, 1L), , ))
  exp_eq(and3s(hib %between% c(-1L, 1L), , b %in% 1:4),
         band3(hib %between% c(-1L, 1L), , b %in% 1:4))
  exp_eq(and3s(hic %between% c(-1L, 1L), , t %in% 1:4),
         band3(hic %between% c(-1L, 1L), , t %in% 1:4))
  exp_eq(and3s(hid %between% c(-1L, 1L), , t %in% 1:4),
         band3(hid %between% c(-1L, 1L), , t %in% 1:4))
  exp_eq(and3s(hie %between% c(-1L, 1L), r >= 0L, ),
         band3(hie %between% c(-1L, 1L), r >= 0L, ))
  exp_eq(and3s(hif %between% c(-1L, 1L), a >= 1L, ),
         band3(hif %between% c(-1L, 1L), a >= 1L, ))
  exp_eq(and3s(hig %between% c(-1L, 1L), s >= 9L, ),
         band3(hig %between% c(-1L, 1L), s >= 9L, ))
  exp_eq(and3s(hih %between% c(-1L, 1L), e >= 0L, z %in% 1:4),
         band3(hih %between% c(-1L, 1L), e >= 0L, z %in% 1:4))
  exp_eq(and3s(hii %between% c(-1L, 1L), r >= 1L, f %in% 1:4),
         band3(hii %between% c(-1L, 1L), r >= 1L, f %in% 1:4))
  exp_eq(and3s(hij %between% c(-1L, 1L), i >= 9L, m %in% 1:4),
         band3(hij %between% c(-1L, 1L), i >= 9L, m %in% 1:4))
  exp_eq(and3s(hik %between% c(-1L, 1L), , ),
         band3(hik %between% c(-1L, 1L), , ))
  exp_eq(and3s(hil %between% c(-1L, 1L), , ),
         band3(hil %between% c(-1L, 1L), , ))
  exp_eq(and3s(him %between% c(-1L, 1L), , ),
         band3(him %between% c(-1L, 1L), , ))
  exp_eq(and3s(hin %between% c(-1L, 1L), , f < 0L),
         band3(hin %between% c(-1L, 1L), , f < 0L))
  exp_eq(and3s(hio %between% c(-1L, 1L), , d < 1L),
         band3(hio %between% c(-1L, 1L), , d < 1L))
  exp_eq(and3s(hip %between% c(-1L, 1L), , h < 9L),
         band3(hip %between% c(-1L, 1L), , h < 9L))
  exp_eq(and3s(hiq %between% c(-1L, 1L), r >= 0L, ),
         band3(hiq %between% c(-1L, 1L), r >= 0L, ))
  exp_eq(and3s(hir %between% c(-1L, 1L), s >= 1L, ),
         band3(hir %between% c(-1L, 1L), s >= 1L, ))
  exp_eq(and3s(his %between% c(-1L, 1L), f >= 9L, ),
         band3(his %between% c(-1L, 1L), f >= 9L, ))
  exp_eq(and3s(hit %between% c(-1L, 1L), x >= 0L, r < 0L),
         band3(hit %between% c(-1L, 1L), x >= 0L, r < 0L))
  exp_eq(and3s(hiu %between% c(-1L, 1L), u >= 1L, s < 1L),
         band3(hiu %between% c(-1L, 1L), u >= 1L, s < 1L))
  exp_eq(and3s(hiv %between% c(-1L, 1L), o >= 9L, u < 9L),
         band3(hiv %between% c(-1L, 1L), o >= 9L, u < 9L))
  exp_eq(and3s(hiw %between% c(-1L, 1L), , ),
         band3(hiw %between% c(-1L, 1L), , ))
  exp_eq(and3s(hix %between% c(-1L, 1L), , ),
         band3(hix %between% c(-1L, 1L), , ))
  exp_eq(and3s(hiy %between% c(-1L, 1L), , ),
         band3(hiy %between% c(-1L, 1L), , ))
  exp_eq(and3s(hiz %between% c(-1L, 1L), , g <= 0L),
         band3(hiz %between% c(-1L, 1L), , g <= 0L))
  exp_eq(and3s(hja %between% c(-1L, 1L), , k <= 1L),
         band3(hja %between% c(-1L, 1L), , k <= 1L))
  exp_eq(and3s(hjb %between% c(-1L, 1L), , b <= 9L),
         band3(hjb %between% c(-1L, 1L), , b <= 9L))
  exp_eq(and3s(hjc %between% c(-1L, 1L), p >= 0L, ),
         band3(hjc %between% c(-1L, 1L), p >= 0L, ))
  exp_eq(and3s(hjd %between% c(-1L, 1L), f >= 1L, ),
         band3(hjd %between% c(-1L, 1L), f >= 1L, ))
  exp_eq(and3s(hje %between% c(-1L, 1L), a >= 9L, ),
         band3(hje %between% c(-1L, 1L), a >= 9L, ))
  exp_eq(and3s(hjf %between% c(-1L, 1L), s >= 0L, p <= 0L),
         band3(hjf %between% c(-1L, 1L), s >= 0L, p <= 0L))
  exp_eq(and3s(hjg %between% c(-1L, 1L), u >= 1L, b <= 1L),
         band3(hjg %between% c(-1L, 1L), u >= 1L, b <= 1L))
  exp_eq(and3s(hjh %between% c(-1L, 1L), z >= 9L, s <= 9L),
         band3(hjh %between% c(-1L, 1L), z >= 9L, s <= 9L))
  exp_eq(and3s(hji %between% c(-1L, 1L), , ),
         band3(hji %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjj %between% c(-1L, 1L), , ),
         band3(hjj %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjk %between% c(-1L, 1L), , ),
         band3(hjk %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjl %between% c(-1L, 1L), , e == 0L),
         band3(hjl %between% c(-1L, 1L), , e == 0L))
  exp_eq(and3s(hjm %between% c(-1L, 1L), , d == 1L),
         band3(hjm %between% c(-1L, 1L), , d == 1L))
  exp_eq(and3s(hjn %between% c(-1L, 1L), , c == 9L),
         band3(hjn %between% c(-1L, 1L), , c == 9L))
  exp_eq(and3s(hjo %between% c(-1L, 1L), h >= 0L, ),
         band3(hjo %between% c(-1L, 1L), h >= 0L, ))
  exp_eq(and3s(hjp %between% c(-1L, 1L), k >= 1L, ),
         band3(hjp %between% c(-1L, 1L), k >= 1L, ))
  exp_eq(and3s(hjq %between% c(-1L, 1L), i >= 9L, ),
         band3(hjq %between% c(-1L, 1L), i >= 9L, ))
  exp_eq(and3s(hjr %between% c(-1L, 1L), o >= 0L, r == 0L),
         band3(hjr %between% c(-1L, 1L), o >= 0L, r == 0L))
  exp_eq(and3s(hjs %between% c(-1L, 1L), y >= 1L, u == 1L),
         band3(hjs %between% c(-1L, 1L), y >= 1L, u == 1L))
  exp_eq(and3s(hjt %between% c(-1L, 1L), z >= 9L, e == 9L),
         band3(hjt %between% c(-1L, 1L), z >= 9L, e == 9L))
  exp_eq(and3s(hju %between% c(-1L, 1L), , ),
         band3(hju %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjv %between% c(-1L, 1L), , ),
         band3(hjv %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjw %between% c(-1L, 1L), , ),
         band3(hjw %between% c(-1L, 1L), , ))
  exp_eq(and3s(hjx %between% c(-1L, 1L), , o > 0L),
         band3(hjx %between% c(-1L, 1L), , o > 0L))
  exp_eq(and3s(hjy %between% c(-1L, 1L), , p > 1L),
         band3(hjy %between% c(-1L, 1L), , p > 1L))
  exp_eq(and3s(hjz %between% c(-1L, 1L), , b > 9L),
         band3(hjz %between% c(-1L, 1L), , b > 9L))
  exp_eq(and3s(hka %between% c(-1L, 1L), s >= 0L, ),
         band3(hka %between% c(-1L, 1L), s >= 0L, ))
  exp_eq(and3s(hkb %between% c(-1L, 1L), g >= 1L, ),
         band3(hkb %between% c(-1L, 1L), g >= 1L, ))
  exp_eq(and3s(hkc %between% c(-1L, 1L), y >= 9L, ),
         band3(hkc %between% c(-1L, 1L), y >= 9L, ))
  exp_eq(and3s(hkd %between% c(-1L, 1L), d >= 0L, a > 0L),
         band3(hkd %between% c(-1L, 1L), d >= 0L, a > 0L))
  exp_eq(and3s(hke %between% c(-1L, 1L), h >= 1L, p > 1L),
         band3(hke %between% c(-1L, 1L), h >= 1L, p > 1L))
  exp_eq(and3s(hkf %between% c(-1L, 1L), z >= 9L, g > 9L),
         band3(hkf %between% c(-1L, 1L), z >= 9L, g > 9L))
  exp_eq(and3s(hkg %between% c(-1L, 1L), , ),
         band3(hkg %between% c(-1L, 1L), , ))
  exp_eq(and3s(hkh %between% c(-1L, 1L), , ),
         band3(hkh %between% c(-1L, 1L), , ))
  exp_eq(and3s(hki %between% c(-1L, 1L), , ),
         band3(hki %between% c(-1L, 1L), , ))
  exp_eq(and3s(hkj %between% c(-1L, 1L), , i >= 0L),
         band3(hkj %between% c(-1L, 1L), , i >= 0L))
  exp_eq(and3s(hkk %between% c(-1L, 1L), , g >= 1L),
         band3(hkk %between% c(-1L, 1L), , g >= 1L))
  exp_eq(and3s(hkl %between% c(-1L, 1L), , n >= 9L),
         band3(hkl %between% c(-1L, 1L), , n >= 9L))
  exp_eq(and3s(hkm %between% c(-1L, 1L), s >= 0L, ),
         band3(hkm %between% c(-1L, 1L), s >= 0L, ))
  exp_eq(and3s(hkn %between% c(-1L, 1L), s >= 1L, ),
         band3(hkn %between% c(-1L, 1L), s >= 1L, ))
  exp_eq(and3s(hko %between% c(-1L, 1L), o >= 9L, ),
         band3(hko %between% c(-1L, 1L), o >= 9L, ))
  exp_eq(and3s(hkp %between% c(-1L, 1L), c >= 0L, l >= 0L),
         band3(hkp %between% c(-1L, 1L), c >= 0L, l >= 0L))
  exp_eq(and3s(hkq %between% c(-1L, 1L), e >= 1L, o >= 1L),
         band3(hkq %between% c(-1L, 1L), e >= 1L, o >= 1L))
  exp_eq(and3s(hkr %between% c(-1L, 1L), c >= 9L, f >= 9L),
         band3(hkr %between% c(-1L, 1L), c >= 9L, f >= 9L))
  exp_eq(and3s(hks %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hks %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hkt %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hkt %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hku %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hku %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hkv %in% c(4L, -3L, 2L, 7L, 8L), , logi_k),
         band3(hkv %in% c(4L, -3L, 2L, 7L, 8L), , logi_k))
  exp_eq(and3s(hkw %in% c(4L, -3L, 2L, 7L, 8L), , logi_e),
         band3(hkw %in% c(4L, -3L, 2L, 7L, 8L), , logi_e))
  exp_eq(and3s(hkx %in% c(4L, -3L, 2L, 7L, 8L), , logi_g),
         band3(hkx %in% c(4L, -3L, 2L, 7L, 8L), , logi_g))
  exp_eq(and3s(hky %in% c(4L, -3L, 2L, 7L, 8L), logi_q, ),
         band3(hky %in% c(4L, -3L, 2L, 7L, 8L), logi_q, ))
  exp_eq(and3s(hkz %in% c(4L, -3L, 2L, 7L, 8L), logi_a, ),
         band3(hkz %in% c(4L, -3L, 2L, 7L, 8L), logi_a, ))
  exp_eq(and3s(hla %in% c(4L, -3L, 2L, 7L, 8L), logi_z, ),
         band3(hla %in% c(4L, -3L, 2L, 7L, 8L), logi_z, ))
  exp_eq(and3s(hlb %in% c(4L, -3L, 2L, 7L, 8L), logi_h, logi_n),
         band3(hlb %in% c(4L, -3L, 2L, 7L, 8L), logi_h, logi_n))
  exp_eq(and3s(hlc %in% c(4L, -3L, 2L, 7L, 8L), logi_c, logi_i),
         band3(hlc %in% c(4L, -3L, 2L, 7L, 8L), logi_c, logi_i))
  exp_eq(and3s(hld %in% c(4L, -3L, 2L, 7L, 8L), logi_i, logi_c),
         band3(hld %in% c(4L, -3L, 2L, 7L, 8L), logi_i, logi_c))
  exp_eq(and3s(hle %in% 1:4, , ),
         band3(hle %in% 1:4, , ))
  exp_eq(and3s(hlf %in% 1:4, , ),
         band3(hlf %in% 1:4, , ))
  exp_eq(and3s(hlg %in% 1:4, , ),
         band3(hlg %in% 1:4, , ))
  exp_eq(and3s(hlh %in% 1:4, , logi_v),
         band3(hlh %in% 1:4, , logi_v))
  exp_eq(and3s(hli %in% 1:4, , logi_g),
         band3(hli %in% 1:4, , logi_g))
  exp_eq(and3s(hlj %in% 1:4, , logi_y),
         band3(hlj %in% 1:4, , logi_y))
  exp_eq(and3s(hlk %in% 1:4, logi_u, ),
         band3(hlk %in% 1:4, logi_u, ))
  exp_eq(and3s(hll %in% 1:4, logi_r, ),
         band3(hll %in% 1:4, logi_r, ))
  exp_eq(and3s(hlm %in% 1:4, logi_x, ),
         band3(hlm %in% 1:4, logi_x, ))
  exp_eq(and3s(hln %in% 1:4, logi_u, logi_y),
         band3(hln %in% 1:4, logi_u, logi_y))
  exp_eq(and3s(hlo %in% 1:4, logi_z, logi_l),
         band3(hlo %in% 1:4, logi_z, logi_l))
  exp_eq(and3s(hlp %in% 1:4, logi_m, logi_p),
         band3(hlp %in% 1:4, logi_m, logi_p))
  exp_eq(and3s(hlq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hlq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hlr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hlr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hls %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hls %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hlt %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u),
         band3(hlt %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u))
  exp_eq(and3s(hlu %in% c(4L, -3L, 2L, 7L, 8L), , !logi_r),
         band3(hlu %in% c(4L, -3L, 2L, 7L, 8L), , !logi_r))
  exp_eq(and3s(hlv %in% c(4L, -3L, 2L, 7L, 8L), , !logi_e),
         band3(hlv %in% c(4L, -3L, 2L, 7L, 8L), , !logi_e))
  exp_eq(and3s(hlw %in% c(4L, -3L, 2L, 7L, 8L), logi_j, ),
         band3(hlw %in% c(4L, -3L, 2L, 7L, 8L), logi_j, ))
  exp_eq(and3s(hlx %in% c(4L, -3L, 2L, 7L, 8L), logi_h, ),
         band3(hlx %in% c(4L, -3L, 2L, 7L, 8L), logi_h, ))
  exp_eq(and3s(hly %in% c(4L, -3L, 2L, 7L, 8L), logi_a, ),
         band3(hly %in% c(4L, -3L, 2L, 7L, 8L), logi_a, ))
  exp_eq(and3s(hlz %in% c(4L, -3L, 2L, 7L, 8L), logi_b, !logi_d),
         band3(hlz %in% c(4L, -3L, 2L, 7L, 8L), logi_b, !logi_d))
  exp_eq(and3s(hma %in% c(4L, -3L, 2L, 7L, 8L), logi_r, !logi_m),
         band3(hma %in% c(4L, -3L, 2L, 7L, 8L), logi_r, !logi_m))
  exp_eq(and3s(hmb %in% c(4L, -3L, 2L, 7L, 8L), logi_h, !logi_q),
         band3(hmb %in% c(4L, -3L, 2L, 7L, 8L), logi_h, !logi_q))
  exp_eq(and3s(hmc %in% 1:4, , ),
         band3(hmc %in% 1:4, , ))
  exp_eq(and3s(hmd %in% 1:4, , ),
         band3(hmd %in% 1:4, , ))
  exp_eq(and3s(hme %in% 1:4, , ),
         band3(hme %in% 1:4, , ))
  exp_eq(and3s(hmf %in% 1:4, , !logi_x),
         band3(hmf %in% 1:4, , !logi_x))
  exp_eq(and3s(hmg %in% 1:4, , !logi_t),
         band3(hmg %in% 1:4, , !logi_t))
  exp_eq(and3s(hmh %in% 1:4, , !logi_x),
         band3(hmh %in% 1:4, , !logi_x))
  exp_eq(and3s(hmi %in% 1:4, logi_r, ),
         band3(hmi %in% 1:4, logi_r, ))
  exp_eq(and3s(hmj %in% 1:4, logi_m, ),
         band3(hmj %in% 1:4, logi_m, ))
  exp_eq(and3s(hmk %in% 1:4, logi_f, ),
         band3(hmk %in% 1:4, logi_f, ))
  exp_eq(and3s(hml %in% 1:4, logi_t, !logi_t),
         band3(hml %in% 1:4, logi_t, !logi_t))
  exp_eq(and3s(hmm %in% 1:4, logi_a, !logi_g),
         band3(hmm %in% 1:4, logi_a, !logi_g))
  exp_eq(and3s(hmn %in% 1:4, logi_f, !logi_r),
         band3(hmn %in% 1:4, logi_f, !logi_r))
  exp_eq(and3s(hmo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hmo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hmp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hmp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hmq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hmq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hmr %in% c(4L, -3L, 2L, 7L, 8L), , m != 0L),
         band3(hmr %in% c(4L, -3L, 2L, 7L, 8L), , m != 0L))
  exp_eq(and3s(hms %in% c(4L, -3L, 2L, 7L, 8L), , d != 1L),
         band3(hms %in% c(4L, -3L, 2L, 7L, 8L), , d != 1L))
  exp_eq(and3s(hmt %in% c(4L, -3L, 2L, 7L, 8L), , n != 9L),
         band3(hmt %in% c(4L, -3L, 2L, 7L, 8L), , n != 9L))
  exp_eq(and3s(hmu %in% c(4L, -3L, 2L, 7L, 8L), logi_g, ),
         band3(hmu %in% c(4L, -3L, 2L, 7L, 8L), logi_g, ))
  exp_eq(and3s(hmv %in% c(4L, -3L, 2L, 7L, 8L), logi_s, ),
         band3(hmv %in% c(4L, -3L, 2L, 7L, 8L), logi_s, ))
  exp_eq(and3s(hmw %in% c(4L, -3L, 2L, 7L, 8L), logi_e, ),
         band3(hmw %in% c(4L, -3L, 2L, 7L, 8L), logi_e, ))
  exp_eq(and3s(hmx %in% c(4L, -3L, 2L, 7L, 8L), logi_a, s != 0L),
         band3(hmx %in% c(4L, -3L, 2L, 7L, 8L), logi_a, s != 0L))
  exp_eq(and3s(hmy %in% c(4L, -3L, 2L, 7L, 8L), logi_x, j != 1L),
         band3(hmy %in% c(4L, -3L, 2L, 7L, 8L), logi_x, j != 1L))
  exp_eq(and3s(hmz %in% c(4L, -3L, 2L, 7L, 8L), logi_j, g != 9L),
         band3(hmz %in% c(4L, -3L, 2L, 7L, 8L), logi_j, g != 9L))
  exp_eq(and3s(hna %in% 1:4, , ),
         band3(hna %in% 1:4, , ))
  exp_eq(and3s(hnb %in% 1:4, , ),
         band3(hnb %in% 1:4, , ))
  exp_eq(and3s(hnc %in% 1:4, , ),
         band3(hnc %in% 1:4, , ))
  exp_eq(and3s(hnd %in% 1:4, , k != 0L),
         band3(hnd %in% 1:4, , k != 0L))
  exp_eq(and3s(hne %in% 1:4, , u != 1L),
         band3(hne %in% 1:4, , u != 1L))
  exp_eq(and3s(hnf %in% 1:4, , i != 9L),
         band3(hnf %in% 1:4, , i != 9L))
  exp_eq(and3s(hng %in% 1:4, logi_y, ),
         band3(hng %in% 1:4, logi_y, ))
  exp_eq(and3s(hnh %in% 1:4, logi_j, ),
         band3(hnh %in% 1:4, logi_j, ))
  exp_eq(and3s(hni %in% 1:4, logi_y, ),
         band3(hni %in% 1:4, logi_y, ))
  exp_eq(and3s(hnj %in% 1:4, logi_j, n != 0L),
         band3(hnj %in% 1:4, logi_j, n != 0L))
  exp_eq(and3s(hnk %in% 1:4, logi_i, o != 1L),
         band3(hnk %in% 1:4, logi_i, o != 1L))
  exp_eq(and3s(hnl %in% 1:4, logi_x, h != 9L),
         band3(hnl %in% 1:4, logi_x, h != 9L))
  exp_eq(and3s(hnm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hnm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hnn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hnn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hno %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hno %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hnp %in% c(4L, -3L, 2L, 7L, 8L), , l %between% c(-1L, 1L)),
         band3(hnp %in% c(4L, -3L, 2L, 7L, 8L), , l %between% c(-1L, 1L)))
  exp_eq(and3s(hnq %in% c(4L, -3L, 2L, 7L, 8L), , d %between% c(-1L, 1L)),
         band3(hnq %in% c(4L, -3L, 2L, 7L, 8L), , d %between% c(-1L, 1L)))
  exp_eq(and3s(hnr %in% c(4L, -3L, 2L, 7L, 8L), , c %between% c(-1L, 1L)),
         band3(hnr %in% c(4L, -3L, 2L, 7L, 8L), , c %between% c(-1L, 1L)))
  exp_eq(and3s(hns %in% c(4L, -3L, 2L, 7L, 8L), logi_m, ),
         band3(hns %in% c(4L, -3L, 2L, 7L, 8L), logi_m, ))
  exp_eq(and3s(hnt %in% c(4L, -3L, 2L, 7L, 8L), logi_p, ),
         band3(hnt %in% c(4L, -3L, 2L, 7L, 8L), logi_p, ))
  exp_eq(and3s(hnu %in% c(4L, -3L, 2L, 7L, 8L), logi_f, ),
         band3(hnu %in% c(4L, -3L, 2L, 7L, 8L), logi_f, ))
  exp_eq(and3s(hnv %in% c(4L, -3L, 2L, 7L, 8L), logi_k, q %between% c(-1L, 1L)),
         band3(hnv %in% c(4L, -3L, 2L, 7L, 8L), logi_k, q %between% c(-1L, 1L)))
  exp_eq(and3s(hnw %in% c(4L, -3L, 2L, 7L, 8L), logi_r, h %between% c(-1L, 1L)),
         band3(hnw %in% c(4L, -3L, 2L, 7L, 8L), logi_r, h %between% c(-1L, 1L)))
  exp_eq(and3s(hnx %in% c(4L, -3L, 2L, 7L, 8L), logi_f, d %between% c(-1L, 1L)),
         band3(hnx %in% c(4L, -3L, 2L, 7L, 8L), logi_f, d %between% c(-1L, 1L)))
  exp_eq(and3s(hny %in% 1:4, , ),
         band3(hny %in% 1:4, , ))
  exp_eq(and3s(hnz %in% 1:4, , ),
         band3(hnz %in% 1:4, , ))
  exp_eq(and3s(hoa %in% 1:4, , ),
         band3(hoa %in% 1:4, , ))
  exp_eq(and3s(hob %in% 1:4, , w %between% c(-1L, 1L)),
         band3(hob %in% 1:4, , w %between% c(-1L, 1L)))
  exp_eq(and3s(hoc %in% 1:4, , r %between% c(-1L, 1L)),
         band3(hoc %in% 1:4, , r %between% c(-1L, 1L)))
  exp_eq(and3s(hod %in% 1:4, , c %between% c(-1L, 1L)),
         band3(hod %in% 1:4, , c %between% c(-1L, 1L)))
  exp_eq(and3s(hoe %in% 1:4, logi_b, ),
         band3(hoe %in% 1:4, logi_b, ))
  exp_eq(and3s(hof %in% 1:4, logi_t, ),
         band3(hof %in% 1:4, logi_t, ))
  exp_eq(and3s(hog %in% 1:4, logi_o, ),
         band3(hog %in% 1:4, logi_o, ))
  exp_eq(and3s(hoh %in% 1:4, logi_f, a %between% c(-1L, 1L)),
         band3(hoh %in% 1:4, logi_f, a %between% c(-1L, 1L)))
  exp_eq(and3s(hoi %in% 1:4, logi_k, e %between% c(-1L, 1L)),
         band3(hoi %in% 1:4, logi_k, e %between% c(-1L, 1L)))
  exp_eq(and3s(hoj %in% 1:4, logi_k, q %between% c(-1L, 1L)),
         band3(hoj %in% 1:4, logi_k, q %between% c(-1L, 1L)))
  exp_eq(and3s(hok %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hok %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hol %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hol %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hom %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hom %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hon %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hon %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hoo %in% c(4L, -3L, 2L, 7L, 8L), , d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hoo %in% c(4L, -3L, 2L, 7L, 8L), , d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hop %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hop %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hoq %in% c(4L, -3L, 2L, 7L, 8L), logi_h, ),
         band3(hoq %in% c(4L, -3L, 2L, 7L, 8L), logi_h, ))
  exp_eq(and3s(hor %in% c(4L, -3L, 2L, 7L, 8L), logi_x, ),
         band3(hor %in% c(4L, -3L, 2L, 7L, 8L), logi_x, ))
  exp_eq(and3s(hos %in% c(4L, -3L, 2L, 7L, 8L), logi_s, ),
         band3(hos %in% c(4L, -3L, 2L, 7L, 8L), logi_s, ))
  exp_eq(and3s(hot %in% c(4L, -3L, 2L, 7L, 8L), logi_w, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hot %in% c(4L, -3L, 2L, 7L, 8L), logi_w, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hou %in% c(4L, -3L, 2L, 7L, 8L), logi_y, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hou %in% c(4L, -3L, 2L, 7L, 8L), logi_y, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hov %in% c(4L, -3L, 2L, 7L, 8L), logi_k, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hov %in% c(4L, -3L, 2L, 7L, 8L), logi_k, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(how %in% 1:4, , ),
         band3(how %in% 1:4, , ))
  exp_eq(and3s(hox %in% 1:4, , ),
         band3(hox %in% 1:4, , ))
  exp_eq(and3s(hoy %in% 1:4, , ),
         band3(hoy %in% 1:4, , ))
  exp_eq(and3s(hoz %in% 1:4, , h %in% 1:4),
         band3(hoz %in% 1:4, , h %in% 1:4))
  exp_eq(and3s(hpa %in% 1:4, , k %in% 1:4),
         band3(hpa %in% 1:4, , k %in% 1:4))
  exp_eq(and3s(hpb %in% 1:4, , i %in% 1:4),
         band3(hpb %in% 1:4, , i %in% 1:4))
  exp_eq(and3s(hpc %in% 1:4, logi_w, ),
         band3(hpc %in% 1:4, logi_w, ))
  exp_eq(and3s(hpd %in% 1:4, logi_q, ),
         band3(hpd %in% 1:4, logi_q, ))
  exp_eq(and3s(hpe %in% 1:4, logi_c, ),
         band3(hpe %in% 1:4, logi_c, ))
  exp_eq(and3s(hpf %in% 1:4, logi_d, e %in% 1:4),
         band3(hpf %in% 1:4, logi_d, e %in% 1:4))
  exp_eq(and3s(hpg %in% 1:4, logi_j, y %in% 1:4),
         band3(hpg %in% 1:4, logi_j, y %in% 1:4))
  exp_eq(and3s(hph %in% 1:4, logi_j, u %in% 1:4),
         band3(hph %in% 1:4, logi_j, u %in% 1:4))
  exp_eq(and3s(hpi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hpi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hpj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hpj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hpk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hpk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hpl %in% c(4L, -3L, 2L, 7L, 8L), , d < 0L),
         band3(hpl %in% c(4L, -3L, 2L, 7L, 8L), , d < 0L))
  exp_eq(and3s(hpm %in% c(4L, -3L, 2L, 7L, 8L), , n < 1L),
         band3(hpm %in% c(4L, -3L, 2L, 7L, 8L), , n < 1L))
  exp_eq(and3s(hpn %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L),
         band3(hpn %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L))
  exp_eq(and3s(hpo %in% c(4L, -3L, 2L, 7L, 8L), logi_t, ),
         band3(hpo %in% c(4L, -3L, 2L, 7L, 8L), logi_t, ))
  exp_eq(and3s(hpp %in% c(4L, -3L, 2L, 7L, 8L), logi_t, ),
         band3(hpp %in% c(4L, -3L, 2L, 7L, 8L), logi_t, ))
  exp_eq(and3s(hpq %in% c(4L, -3L, 2L, 7L, 8L), logi_r, ),
         band3(hpq %in% c(4L, -3L, 2L, 7L, 8L), logi_r, ))
  exp_eq(and3s(hpr %in% c(4L, -3L, 2L, 7L, 8L), logi_k, b < 0L),
         band3(hpr %in% c(4L, -3L, 2L, 7L, 8L), logi_k, b < 0L))
  exp_eq(and3s(hps %in% c(4L, -3L, 2L, 7L, 8L), logi_d, h < 1L),
         band3(hps %in% c(4L, -3L, 2L, 7L, 8L), logi_d, h < 1L))
  exp_eq(and3s(hpt %in% c(4L, -3L, 2L, 7L, 8L), logi_v, i < 9L),
         band3(hpt %in% c(4L, -3L, 2L, 7L, 8L), logi_v, i < 9L))
  exp_eq(and3s(hpu %in% 1:4, , ),
         band3(hpu %in% 1:4, , ))
  exp_eq(and3s(hpv %in% 1:4, , ),
         band3(hpv %in% 1:4, , ))
  exp_eq(and3s(hpw %in% 1:4, , ),
         band3(hpw %in% 1:4, , ))
  exp_eq(and3s(hpx %in% 1:4, , f < 0L),
         band3(hpx %in% 1:4, , f < 0L))
  exp_eq(and3s(hpy %in% 1:4, , n < 1L),
         band3(hpy %in% 1:4, , n < 1L))
  exp_eq(and3s(hpz %in% 1:4, , d < 9L),
         band3(hpz %in% 1:4, , d < 9L))
  exp_eq(and3s(hqa %in% 1:4, logi_d, ),
         band3(hqa %in% 1:4, logi_d, ))
  exp_eq(and3s(hqb %in% 1:4, logi_z, ),
         band3(hqb %in% 1:4, logi_z, ))
  exp_eq(and3s(hqc %in% 1:4, logi_q, ),
         band3(hqc %in% 1:4, logi_q, ))
  exp_eq(and3s(hqd %in% 1:4, logi_e, b < 0L),
         band3(hqd %in% 1:4, logi_e, b < 0L))
  exp_eq(and3s(hqe %in% 1:4, logi_t, y < 1L),
         band3(hqe %in% 1:4, logi_t, y < 1L))
  exp_eq(and3s(hqf %in% 1:4, logi_x, l < 9L),
         band3(hqf %in% 1:4, logi_x, l < 9L))
  exp_eq(and3s(hqg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hqg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hqh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hqh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hqi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hqi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hqj %in% c(4L, -3L, 2L, 7L, 8L), , s <= 0L),
         band3(hqj %in% c(4L, -3L, 2L, 7L, 8L), , s <= 0L))
  exp_eq(and3s(hqk %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L),
         band3(hqk %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L))
  exp_eq(and3s(hql %in% c(4L, -3L, 2L, 7L, 8L), , l <= 9L),
         band3(hql %in% c(4L, -3L, 2L, 7L, 8L), , l <= 9L))
  exp_eq(and3s(hqm %in% c(4L, -3L, 2L, 7L, 8L), logi_i, ),
         band3(hqm %in% c(4L, -3L, 2L, 7L, 8L), logi_i, ))
  exp_eq(and3s(hqn %in% c(4L, -3L, 2L, 7L, 8L), logi_y, ),
         band3(hqn %in% c(4L, -3L, 2L, 7L, 8L), logi_y, ))
  exp_eq(and3s(hqo %in% c(4L, -3L, 2L, 7L, 8L), logi_p, ),
         band3(hqo %in% c(4L, -3L, 2L, 7L, 8L), logi_p, ))
  exp_eq(and3s(hqp %in% c(4L, -3L, 2L, 7L, 8L), logi_q, x <= 0L),
         band3(hqp %in% c(4L, -3L, 2L, 7L, 8L), logi_q, x <= 0L))
  exp_eq(and3s(hqq %in% c(4L, -3L, 2L, 7L, 8L), logi_v, f <= 1L),
         band3(hqq %in% c(4L, -3L, 2L, 7L, 8L), logi_v, f <= 1L))
  exp_eq(and3s(hqr %in% c(4L, -3L, 2L, 7L, 8L), logi_l, l <= 9L),
         band3(hqr %in% c(4L, -3L, 2L, 7L, 8L), logi_l, l <= 9L))
  exp_eq(and3s(hqs %in% 1:4, , ),
         band3(hqs %in% 1:4, , ))
  exp_eq(and3s(hqt %in% 1:4, , ),
         band3(hqt %in% 1:4, , ))
  exp_eq(and3s(hqu %in% 1:4, , ),
         band3(hqu %in% 1:4, , ))
  exp_eq(and3s(hqv %in% 1:4, , j <= 0L),
         band3(hqv %in% 1:4, , j <= 0L))
  exp_eq(and3s(hqw %in% 1:4, , g <= 1L),
         band3(hqw %in% 1:4, , g <= 1L))
  exp_eq(and3s(hqx %in% 1:4, , x <= 9L),
         band3(hqx %in% 1:4, , x <= 9L))
  exp_eq(and3s(hqy %in% 1:4, logi_q, ),
         band3(hqy %in% 1:4, logi_q, ))
  exp_eq(and3s(hqz %in% 1:4, logi_m, ),
         band3(hqz %in% 1:4, logi_m, ))
  exp_eq(and3s(hra %in% 1:4, logi_z, ),
         band3(hra %in% 1:4, logi_z, ))
  exp_eq(and3s(hrb %in% 1:4, logi_l, k <= 0L),
         band3(hrb %in% 1:4, logi_l, k <= 0L))
  exp_eq(and3s(hrc %in% 1:4, logi_a, d <= 1L),
         band3(hrc %in% 1:4, logi_a, d <= 1L))
  exp_eq(and3s(hrd %in% 1:4, logi_s, o <= 9L),
         band3(hrd %in% 1:4, logi_s, o <= 9L))
  exp_eq(and3s(hre %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hre %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hrf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hrf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hrg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hrg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hrh %in% c(4L, -3L, 2L, 7L, 8L), , v == 0L),
         band3(hrh %in% c(4L, -3L, 2L, 7L, 8L), , v == 0L))
  exp_eq(and3s(hri %in% c(4L, -3L, 2L, 7L, 8L), , u == 1L),
         band3(hri %in% c(4L, -3L, 2L, 7L, 8L), , u == 1L))
  exp_eq(and3s(hrj %in% c(4L, -3L, 2L, 7L, 8L), , y == 9L),
         band3(hrj %in% c(4L, -3L, 2L, 7L, 8L), , y == 9L))
  exp_eq(and3s(hrk %in% c(4L, -3L, 2L, 7L, 8L), logi_i, ),
         band3(hrk %in% c(4L, -3L, 2L, 7L, 8L), logi_i, ))
  exp_eq(and3s(hrl %in% c(4L, -3L, 2L, 7L, 8L), logi_v, ),
         band3(hrl %in% c(4L, -3L, 2L, 7L, 8L), logi_v, ))
  exp_eq(and3s(hrm %in% c(4L, -3L, 2L, 7L, 8L), logi_e, ),
         band3(hrm %in% c(4L, -3L, 2L, 7L, 8L), logi_e, ))
  exp_eq(and3s(hrn %in% c(4L, -3L, 2L, 7L, 8L), logi_p, i == 0L),
         band3(hrn %in% c(4L, -3L, 2L, 7L, 8L), logi_p, i == 0L))
  exp_eq(and3s(hro %in% c(4L, -3L, 2L, 7L, 8L), logi_u, y == 1L),
         band3(hro %in% c(4L, -3L, 2L, 7L, 8L), logi_u, y == 1L))
  exp_eq(and3s(hrp %in% c(4L, -3L, 2L, 7L, 8L), logi_n, t == 9L),
         band3(hrp %in% c(4L, -3L, 2L, 7L, 8L), logi_n, t == 9L))
  exp_eq(and3s(hrq %in% 1:4, , ),
         band3(hrq %in% 1:4, , ))
  exp_eq(and3s(hrr %in% 1:4, , ),
         band3(hrr %in% 1:4, , ))
  exp_eq(and3s(hrs %in% 1:4, , ),
         band3(hrs %in% 1:4, , ))
  exp_eq(and3s(hrt %in% 1:4, , q == 0L),
         band3(hrt %in% 1:4, , q == 0L))
  exp_eq(and3s(hru %in% 1:4, , c == 1L),
         band3(hru %in% 1:4, , c == 1L))
  exp_eq(and3s(hrv %in% 1:4, , a == 9L),
         band3(hrv %in% 1:4, , a == 9L))
  exp_eq(and3s(hrw %in% 1:4, logi_b, ),
         band3(hrw %in% 1:4, logi_b, ))
  exp_eq(and3s(hrx %in% 1:4, logi_o, ),
         band3(hrx %in% 1:4, logi_o, ))
  exp_eq(and3s(hry %in% 1:4, logi_o, ),
         band3(hry %in% 1:4, logi_o, ))
  exp_eq(and3s(hrz %in% 1:4, logi_i, w == 0L),
         band3(hrz %in% 1:4, logi_i, w == 0L))
  exp_eq(and3s(hsa %in% 1:4, logi_r, p == 1L),
         band3(hsa %in% 1:4, logi_r, p == 1L))
  exp_eq(and3s(hsb %in% 1:4, logi_d, p == 9L),
         band3(hsb %in% 1:4, logi_d, p == 9L))
  exp_eq(and3s(hsc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hsc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hsd %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hsd %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hse %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hse %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hsf %in% c(4L, -3L, 2L, 7L, 8L), , e > 0L),
         band3(hsf %in% c(4L, -3L, 2L, 7L, 8L), , e > 0L))
  exp_eq(and3s(hsg %in% c(4L, -3L, 2L, 7L, 8L), , e > 1L),
         band3(hsg %in% c(4L, -3L, 2L, 7L, 8L), , e > 1L))
  exp_eq(and3s(hsh %in% c(4L, -3L, 2L, 7L, 8L), , w > 9L),
         band3(hsh %in% c(4L, -3L, 2L, 7L, 8L), , w > 9L))
  exp_eq(and3s(hsi %in% c(4L, -3L, 2L, 7L, 8L), logi_b, ),
         band3(hsi %in% c(4L, -3L, 2L, 7L, 8L), logi_b, ))
  exp_eq(and3s(hsj %in% c(4L, -3L, 2L, 7L, 8L), logi_r, ),
         band3(hsj %in% c(4L, -3L, 2L, 7L, 8L), logi_r, ))
  exp_eq(and3s(hsk %in% c(4L, -3L, 2L, 7L, 8L), logi_b, ),
         band3(hsk %in% c(4L, -3L, 2L, 7L, 8L), logi_b, ))
  exp_eq(and3s(hsl %in% c(4L, -3L, 2L, 7L, 8L), logi_p, j > 0L),
         band3(hsl %in% c(4L, -3L, 2L, 7L, 8L), logi_p, j > 0L))
  exp_eq(and3s(hsm %in% c(4L, -3L, 2L, 7L, 8L), logi_u, r > 1L),
         band3(hsm %in% c(4L, -3L, 2L, 7L, 8L), logi_u, r > 1L))
  exp_eq(and3s(hsn %in% c(4L, -3L, 2L, 7L, 8L), logi_e, p > 9L),
         band3(hsn %in% c(4L, -3L, 2L, 7L, 8L), logi_e, p > 9L))
  exp_eq(and3s(hso %in% 1:4, , ),
         band3(hso %in% 1:4, , ))
  exp_eq(and3s(hsp %in% 1:4, , ),
         band3(hsp %in% 1:4, , ))
  exp_eq(and3s(hsq %in% 1:4, , ),
         band3(hsq %in% 1:4, , ))
  exp_eq(and3s(hsr %in% 1:4, , d > 0L),
         band3(hsr %in% 1:4, , d > 0L))
  exp_eq(and3s(hss %in% 1:4, , s > 1L),
         band3(hss %in% 1:4, , s > 1L))
  exp_eq(and3s(hst %in% 1:4, , s > 9L),
         band3(hst %in% 1:4, , s > 9L))
  exp_eq(and3s(hsu %in% 1:4, logi_w, ),
         band3(hsu %in% 1:4, logi_w, ))
  exp_eq(and3s(hsv %in% 1:4, logi_r, ),
         band3(hsv %in% 1:4, logi_r, ))
  exp_eq(and3s(hsw %in% 1:4, logi_j, ),
         band3(hsw %in% 1:4, logi_j, ))
  exp_eq(and3s(hsx %in% 1:4, logi_z, d > 0L),
         band3(hsx %in% 1:4, logi_z, d > 0L))
  exp_eq(and3s(hsy %in% 1:4, logi_l, o > 1L),
         band3(hsy %in% 1:4, logi_l, o > 1L))
  exp_eq(and3s(hsz %in% 1:4, logi_m, k > 9L),
         band3(hsz %in% 1:4, logi_m, k > 9L))
  exp_eq(and3s(hta %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hta %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(htb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(htb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(htc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(htc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(htd %in% c(4L, -3L, 2L, 7L, 8L), , t >= 0L),
         band3(htd %in% c(4L, -3L, 2L, 7L, 8L), , t >= 0L))
  exp_eq(and3s(hte %in% c(4L, -3L, 2L, 7L, 8L), , p >= 1L),
         band3(hte %in% c(4L, -3L, 2L, 7L, 8L), , p >= 1L))
  exp_eq(and3s(htf %in% c(4L, -3L, 2L, 7L, 8L), , r >= 9L),
         band3(htf %in% c(4L, -3L, 2L, 7L, 8L), , r >= 9L))
  exp_eq(and3s(htg %in% c(4L, -3L, 2L, 7L, 8L), logi_m, ),
         band3(htg %in% c(4L, -3L, 2L, 7L, 8L), logi_m, ))
  exp_eq(and3s(hth %in% c(4L, -3L, 2L, 7L, 8L), logi_q, ),
         band3(hth %in% c(4L, -3L, 2L, 7L, 8L), logi_q, ))
  exp_eq(and3s(hti %in% c(4L, -3L, 2L, 7L, 8L), logi_c, ),
         band3(hti %in% c(4L, -3L, 2L, 7L, 8L), logi_c, ))
  exp_eq(and3s(htj %in% c(4L, -3L, 2L, 7L, 8L), logi_a, b >= 0L),
         band3(htj %in% c(4L, -3L, 2L, 7L, 8L), logi_a, b >= 0L))
  exp_eq(and3s(htk %in% c(4L, -3L, 2L, 7L, 8L), logi_c, i >= 1L),
         band3(htk %in% c(4L, -3L, 2L, 7L, 8L), logi_c, i >= 1L))
  exp_eq(and3s(htl %in% c(4L, -3L, 2L, 7L, 8L), logi_s, h >= 9L),
         band3(htl %in% c(4L, -3L, 2L, 7L, 8L), logi_s, h >= 9L))
  exp_eq(and3s(htm %in% 1:4, , ),
         band3(htm %in% 1:4, , ))
  exp_eq(and3s(htn %in% 1:4, , ),
         band3(htn %in% 1:4, , ))
  exp_eq(and3s(hto %in% 1:4, , ),
         band3(hto %in% 1:4, , ))
  exp_eq(and3s(htp %in% 1:4, , e >= 0L),
         band3(htp %in% 1:4, , e >= 0L))
  exp_eq(and3s(htq %in% 1:4, , s >= 1L),
         band3(htq %in% 1:4, , s >= 1L))
  exp_eq(and3s(htr %in% 1:4, , l >= 9L),
         band3(htr %in% 1:4, , l >= 9L))
  exp_eq(and3s(hts %in% 1:4, logi_n, ),
         band3(hts %in% 1:4, logi_n, ))
  exp_eq(and3s(htt %in% 1:4, logi_p, ),
         band3(htt %in% 1:4, logi_p, ))
  exp_eq(and3s(htu %in% 1:4, logi_e, ),
         band3(htu %in% 1:4, logi_e, ))
  exp_eq(and3s(htv %in% 1:4, logi_l, x >= 0L),
         band3(htv %in% 1:4, logi_l, x >= 0L))
  exp_eq(and3s(htw %in% 1:4, logi_t, d >= 1L),
         band3(htw %in% 1:4, logi_t, d >= 1L))
  exp_eq(and3s(htx %in% 1:4, logi_i, m >= 9L),
         band3(htx %in% 1:4, logi_i, m >= 9L))
  exp_eq(and3s(hty %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hty %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(htz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(htz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hua %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hua %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hub %in% c(4L, -3L, 2L, 7L, 8L), , logi_c),
         band3(hub %in% c(4L, -3L, 2L, 7L, 8L), , logi_c))
  exp_eq(and3s(huc %in% c(4L, -3L, 2L, 7L, 8L), , logi_j),
         band3(huc %in% c(4L, -3L, 2L, 7L, 8L), , logi_j))
  exp_eq(and3s(hud %in% c(4L, -3L, 2L, 7L, 8L), , logi_x),
         band3(hud %in% c(4L, -3L, 2L, 7L, 8L), , logi_x))
  exp_eq(and3s(hue %in% c(4L, -3L, 2L, 7L, 8L), !logi_g, ),
         band3(hue %in% c(4L, -3L, 2L, 7L, 8L), !logi_g, ))
  exp_eq(and3s(huf %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ),
         band3(huf %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ))
  exp_eq(and3s(hug %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ),
         band3(hug %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ))
  exp_eq(and3s(huh %in% c(4L, -3L, 2L, 7L, 8L), !logi_y, logi_h),
         band3(huh %in% c(4L, -3L, 2L, 7L, 8L), !logi_y, logi_h))
  exp_eq(and3s(hui %in% c(4L, -3L, 2L, 7L, 8L), !logi_f, logi_g),
         band3(hui %in% c(4L, -3L, 2L, 7L, 8L), !logi_f, logi_g))
  exp_eq(and3s(huj %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, logi_i),
         band3(huj %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, logi_i))
  exp_eq(and3s(huk %in% 1:4, , ),
         band3(huk %in% 1:4, , ))
  exp_eq(and3s(hul %in% 1:4, , ),
         band3(hul %in% 1:4, , ))
  exp_eq(and3s(hum %in% 1:4, , ),
         band3(hum %in% 1:4, , ))
  exp_eq(and3s(hun %in% 1:4, , logi_d),
         band3(hun %in% 1:4, , logi_d))
  exp_eq(and3s(huo %in% 1:4, , logi_w),
         band3(huo %in% 1:4, , logi_w))
  exp_eq(and3s(hup %in% 1:4, , logi_f),
         band3(hup %in% 1:4, , logi_f))
  exp_eq(and3s(huq %in% 1:4, !logi_h, ),
         band3(huq %in% 1:4, !logi_h, ))
  exp_eq(and3s(hur %in% 1:4, !logi_q, ),
         band3(hur %in% 1:4, !logi_q, ))
  exp_eq(and3s(hus %in% 1:4, !logi_e, ),
         band3(hus %in% 1:4, !logi_e, ))
  exp_eq(and3s(hut %in% 1:4, !logi_s, logi_g),
         band3(hut %in% 1:4, !logi_s, logi_g))
  exp_eq(and3s(huu %in% 1:4, !logi_h, logi_k),
         band3(huu %in% 1:4, !logi_h, logi_k))
  exp_eq(and3s(huv %in% 1:4, !logi_q, logi_n),
         band3(huv %in% 1:4, !logi_q, logi_n))
  exp_eq(and3s(huw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(huw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hux %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hux %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(huy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(huy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(huz %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u),
         band3(huz %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u))
  exp_eq(and3s(hva %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f),
         band3(hva %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f))
  exp_eq(and3s(hvb %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f),
         band3(hvb %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f))
  exp_eq(and3s(hvc %in% c(4L, -3L, 2L, 7L, 8L), !logi_k, ),
         band3(hvc %in% c(4L, -3L, 2L, 7L, 8L), !logi_k, ))
  exp_eq(and3s(hvd %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ),
         band3(hvd %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ))
  exp_eq(and3s(hve %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, ),
         band3(hve %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, ))
  exp_eq(and3s(hvf %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, !logi_z),
         band3(hvf %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, !logi_z))
  exp_eq(and3s(hvg %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, !logi_o),
         band3(hvg %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, !logi_o))
  exp_eq(and3s(hvh %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, !logi_p),
         band3(hvh %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, !logi_p))
  exp_eq(and3s(hvi %in% 1:4, , ),
         band3(hvi %in% 1:4, , ))
  exp_eq(and3s(hvj %in% 1:4, , ),
         band3(hvj %in% 1:4, , ))
  exp_eq(and3s(hvk %in% 1:4, , ),
         band3(hvk %in% 1:4, , ))
  exp_eq(and3s(hvl %in% 1:4, , !logi_g),
         band3(hvl %in% 1:4, , !logi_g))
  exp_eq(and3s(hvm %in% 1:4, , !logi_d),
         band3(hvm %in% 1:4, , !logi_d))
  exp_eq(and3s(hvn %in% 1:4, , !logi_d),
         band3(hvn %in% 1:4, , !logi_d))
  exp_eq(and3s(hvo %in% 1:4, !logi_g, ),
         band3(hvo %in% 1:4, !logi_g, ))
  exp_eq(and3s(hvp %in% 1:4, !logi_q, ),
         band3(hvp %in% 1:4, !logi_q, ))
  exp_eq(and3s(hvq %in% 1:4, !logi_i, ),
         band3(hvq %in% 1:4, !logi_i, ))
  exp_eq(and3s(hvr %in% 1:4, !logi_w, !logi_n),
         band3(hvr %in% 1:4, !logi_w, !logi_n))
  exp_eq(and3s(hvs %in% 1:4, !logi_z, !logi_f),
         band3(hvs %in% 1:4, !logi_z, !logi_f))
  exp_eq(and3s(hvt %in% 1:4, !logi_a, !logi_y),
         band3(hvt %in% 1:4, !logi_a, !logi_y))
  exp_eq(and3s(hvu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hvu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hvv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hvv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hvw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hvw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hvx %in% c(4L, -3L, 2L, 7L, 8L), , f != 0L),
         band3(hvx %in% c(4L, -3L, 2L, 7L, 8L), , f != 0L))
  exp_eq(and3s(hvy %in% c(4L, -3L, 2L, 7L, 8L), , t != 1L),
         band3(hvy %in% c(4L, -3L, 2L, 7L, 8L), , t != 1L))
  exp_eq(and3s(hvz %in% c(4L, -3L, 2L, 7L, 8L), , z != 9L),
         band3(hvz %in% c(4L, -3L, 2L, 7L, 8L), , z != 9L))
  exp_eq(and3s(hwa %in% c(4L, -3L, 2L, 7L, 8L), !logi_u, ),
         band3(hwa %in% c(4L, -3L, 2L, 7L, 8L), !logi_u, ))
  exp_eq(and3s(hwb %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, ),
         band3(hwb %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, ))
  exp_eq(and3s(hwc %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, ),
         band3(hwc %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, ))
  exp_eq(and3s(hwd %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, u != 0L),
         band3(hwd %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, u != 0L))
  exp_eq(and3s(hwe %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, c != 1L),
         band3(hwe %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, c != 1L))
  exp_eq(and3s(hwf %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, h != 9L),
         band3(hwf %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, h != 9L))
  exp_eq(and3s(hwg %in% 1:4, , ),
         band3(hwg %in% 1:4, , ))
  exp_eq(and3s(hwh %in% 1:4, , ),
         band3(hwh %in% 1:4, , ))
  exp_eq(and3s(hwi %in% 1:4, , ),
         band3(hwi %in% 1:4, , ))
  exp_eq(and3s(hwj %in% 1:4, , r != 0L),
         band3(hwj %in% 1:4, , r != 0L))
  exp_eq(and3s(hwk %in% 1:4, , v != 1L),
         band3(hwk %in% 1:4, , v != 1L))
  exp_eq(and3s(hwl %in% 1:4, , n != 9L),
         band3(hwl %in% 1:4, , n != 9L))
  exp_eq(and3s(hwm %in% 1:4, !logi_k, ),
         band3(hwm %in% 1:4, !logi_k, ))
  exp_eq(and3s(hwn %in% 1:4, !logi_a, ),
         band3(hwn %in% 1:4, !logi_a, ))
  exp_eq(and3s(hwo %in% 1:4, !logi_v, ),
         band3(hwo %in% 1:4, !logi_v, ))
  exp_eq(and3s(hwp %in% 1:4, !logi_u, r != 0L),
         band3(hwp %in% 1:4, !logi_u, r != 0L))
  exp_eq(and3s(hwq %in% 1:4, !logi_w, k != 1L),
         band3(hwq %in% 1:4, !logi_w, k != 1L))
  exp_eq(and3s(hwr %in% 1:4, !logi_b, a != 9L),
         band3(hwr %in% 1:4, !logi_b, a != 9L))
  exp_eq(and3s(hws %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hws %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hwt %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hwt %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hwu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hwu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hwv %in% c(4L, -3L, 2L, 7L, 8L), , u %between% c(-1L, 1L)),
         band3(hwv %in% c(4L, -3L, 2L, 7L, 8L), , u %between% c(-1L, 1L)))
  exp_eq(and3s(hww %in% c(4L, -3L, 2L, 7L, 8L), , q %between% c(-1L, 1L)),
         band3(hww %in% c(4L, -3L, 2L, 7L, 8L), , q %between% c(-1L, 1L)))
  exp_eq(and3s(hwx %in% c(4L, -3L, 2L, 7L, 8L), , z %between% c(-1L, 1L)),
         band3(hwx %in% c(4L, -3L, 2L, 7L, 8L), , z %between% c(-1L, 1L)))
  exp_eq(and3s(hwy %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, ),
         band3(hwy %in% c(4L, -3L, 2L, 7L, 8L), !logi_j, ))
  exp_eq(and3s(hwz %in% c(4L, -3L, 2L, 7L, 8L), !logi_d, ),
         band3(hwz %in% c(4L, -3L, 2L, 7L, 8L), !logi_d, ))
  exp_eq(and3s(hxa %in% c(4L, -3L, 2L, 7L, 8L), !logi_n, ),
         band3(hxa %in% c(4L, -3L, 2L, 7L, 8L), !logi_n, ))
  exp_eq(and3s(hxb %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, b %between% c(-1L, 1L)),
         band3(hxb %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, b %between% c(-1L, 1L)))
  exp_eq(and3s(hxc %in% c(4L, -3L, 2L, 7L, 8L), !logi_c, f %between% c(-1L, 1L)),
         band3(hxc %in% c(4L, -3L, 2L, 7L, 8L), !logi_c, f %between% c(-1L, 1L)))
  exp_eq(and3s(hxd %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, a %between% c(-1L, 1L)),
         band3(hxd %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, a %between% c(-1L, 1L)))
  exp_eq(and3s(hxe %in% 1:4, , ),
         band3(hxe %in% 1:4, , ))
  exp_eq(and3s(hxf %in% 1:4, , ),
         band3(hxf %in% 1:4, , ))
  exp_eq(and3s(hxg %in% 1:4, , ),
         band3(hxg %in% 1:4, , ))
  exp_eq(and3s(hxh %in% 1:4, , e %between% c(-1L, 1L)),
         band3(hxh %in% 1:4, , e %between% c(-1L, 1L)))
  exp_eq(and3s(hxi %in% 1:4, , n %between% c(-1L, 1L)),
         band3(hxi %in% 1:4, , n %between% c(-1L, 1L)))
  exp_eq(and3s(hxj %in% 1:4, , y %between% c(-1L, 1L)),
         band3(hxj %in% 1:4, , y %between% c(-1L, 1L)))
  exp_eq(and3s(hxk %in% 1:4, !logi_u, ),
         band3(hxk %in% 1:4, !logi_u, ))
  exp_eq(and3s(hxl %in% 1:4, !logi_z, ),
         band3(hxl %in% 1:4, !logi_z, ))
  exp_eq(and3s(hxm %in% 1:4, !logi_q, ),
         band3(hxm %in% 1:4, !logi_q, ))
  exp_eq(and3s(hxn %in% 1:4, !logi_o, f %between% c(-1L, 1L)),
         band3(hxn %in% 1:4, !logi_o, f %between% c(-1L, 1L)))
  exp_eq(and3s(hxo %in% 1:4, !logi_a, v %between% c(-1L, 1L)),
         band3(hxo %in% 1:4, !logi_a, v %between% c(-1L, 1L)))
  exp_eq(and3s(hxp %in% 1:4, !logi_h, i %between% c(-1L, 1L)),
         band3(hxp %in% 1:4, !logi_h, i %between% c(-1L, 1L)))
  exp_eq(and3s(hxq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hxq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hxr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hxr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hxs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hxs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hxt %in% c(4L, -3L, 2L, 7L, 8L), , q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hxt %in% c(4L, -3L, 2L, 7L, 8L), , q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hxu %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hxu %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hxv %in% c(4L, -3L, 2L, 7L, 8L), , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hxv %in% c(4L, -3L, 2L, 7L, 8L), , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hxw %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, ),
         band3(hxw %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, ))
  exp_eq(and3s(hxx %in% c(4L, -3L, 2L, 7L, 8L), !logi_i, ),
         band3(hxx %in% c(4L, -3L, 2L, 7L, 8L), !logi_i, ))
  exp_eq(and3s(hxy %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, ),
         band3(hxy %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, ))
  exp_eq(and3s(hxz %in% c(4L, -3L, 2L, 7L, 8L), !logi_t, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hxz %in% c(4L, -3L, 2L, 7L, 8L), !logi_t, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hya %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hya %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hyb %in% c(4L, -3L, 2L, 7L, 8L), !logi_a, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(hyb %in% c(4L, -3L, 2L, 7L, 8L), !logi_a, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(hyc %in% 1:4, , ),
         band3(hyc %in% 1:4, , ))
  exp_eq(and3s(hyd %in% 1:4, , ),
         band3(hyd %in% 1:4, , ))
  exp_eq(and3s(hye %in% 1:4, , ),
         band3(hye %in% 1:4, , ))
  exp_eq(and3s(hyf %in% 1:4, , t %in% 1:4),
         band3(hyf %in% 1:4, , t %in% 1:4))
  exp_eq(and3s(hyg %in% 1:4, , q %in% 1:4),
         band3(hyg %in% 1:4, , q %in% 1:4))
  exp_eq(and3s(hyh %in% 1:4, , l %in% 1:4),
         band3(hyh %in% 1:4, , l %in% 1:4))
  exp_eq(and3s(hyi %in% 1:4, !logi_u, ),
         band3(hyi %in% 1:4, !logi_u, ))
  exp_eq(and3s(hyj %in% 1:4, !logi_v, ),
         band3(hyj %in% 1:4, !logi_v, ))
  exp_eq(and3s(hyk %in% 1:4, !logi_p, ),
         band3(hyk %in% 1:4, !logi_p, ))
  exp_eq(and3s(hyl %in% 1:4, !logi_t, r %in% 1:4),
         band3(hyl %in% 1:4, !logi_t, r %in% 1:4))
  exp_eq(and3s(hym %in% 1:4, !logi_v, d %in% 1:4),
         band3(hym %in% 1:4, !logi_v, d %in% 1:4))
  exp_eq(and3s(hyn %in% 1:4, !logi_x, y %in% 1:4),
         band3(hyn %in% 1:4, !logi_x, y %in% 1:4))
  exp_eq(and3s(hyo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hyo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hyp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hyp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hyq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(hyq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(hyr %in% c(4L, -3L, 2L, 7L, 8L), , u < 0L),
         band3(hyr %in% c(4L, -3L, 2L, 7L, 8L), , u < 0L))
  exp_eq(and3s(hys %in% c(4L, -3L, 2L, 7L, 8L), , p < 1L),
         band3(hys %in% c(4L, -3L, 2L, 7L, 8L), , p < 1L))
  exp_eq(and3s(hyt %in% c(4L, -3L, 2L, 7L, 8L), , s < 9L),
         band3(hyt %in% c(4L, -3L, 2L, 7L, 8L), , s < 9L))
  exp_eq(and3s(hyu %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, ),
         band3(hyu %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, ))
  exp_eq(and3s(hyv %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, ),
         band3(hyv %in% c(4L, -3L, 2L, 7L, 8L), !logi_b, ))
  exp_eq(and3s(hyw %in% c(4L, -3L, 2L, 7L, 8L), !logi_p, ),
         band3(hyw %in% c(4L, -3L, 2L, 7L, 8L), !logi_p, ))
  exp_eq(and3s(hyx %in% c(4L, -3L, 2L, 7L, 8L), !logi_n, w < 0L),
         band3(hyx %in% c(4L, -3L, 2L, 7L, 8L), !logi_n, w < 0L))
  exp_eq(and3s(hyy %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, u < 1L),
         band3(hyy %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, u < 1L))
  exp_eq(and3s(hyz %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, s < 9L),
         band3(hyz %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, s < 9L))
  exp_eq(and3s(ia %in% 1:4, , ),
         band3(ia %in% 1:4, , ))
  exp_eq(and3s(ib %in% 1:4, , ),
         band3(ib %in% 1:4, , ))
  exp_eq(and3s(ic %in% 1:4, , ),
         band3(ic %in% 1:4, , ))
  exp_eq(and3s(id %in% 1:4, , d < 0L),
         band3(id %in% 1:4, , d < 0L))
  exp_eq(and3s(ie %in% 1:4, , k < 1L),
         band3(ie %in% 1:4, , k < 1L))
  exp_eq(and3s(IF %in% 1:4, , t < 9L),
         band3(IF %in% 1:4, , t < 9L))
  exp_eq(and3s(ig %in% 1:4, !logi_d, ),
         band3(ig %in% 1:4, !logi_d, ))
  exp_eq(and3s(ih %in% 1:4, !logi_n, ),
         band3(ih %in% 1:4, !logi_n, ))
  exp_eq(and3s(ii %in% 1:4, !logi_c, ),
         band3(ii %in% 1:4, !logi_c, ))
  exp_eq(and3s(ij %in% 1:4, !logi_x, h < 0L),
         band3(ij %in% 1:4, !logi_x, h < 0L))
  exp_eq(and3s(ik %in% 1:4, !logi_z, q < 1L),
         band3(ik %in% 1:4, !logi_z, q < 1L))
  exp_eq(and3s(il %in% 1:4, !logi_v, j < 9L),
         band3(il %in% 1:4, !logi_v, j < 9L))
  exp_eq(and3s(im %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(im %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(IN %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(IN %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(io %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(io %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ip %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L),
         band3(ip %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L))
  exp_eq(and3s(iq %in% c(4L, -3L, 2L, 7L, 8L), , w <= 1L),
         band3(iq %in% c(4L, -3L, 2L, 7L, 8L), , w <= 1L))
  exp_eq(and3s(ir %in% c(4L, -3L, 2L, 7L, 8L), , c <= 9L),
         band3(ir %in% c(4L, -3L, 2L, 7L, 8L), , c <= 9L))
  exp_eq(and3s(is %in% c(4L, -3L, 2L, 7L, 8L), !logi_s, ),
         band3(is %in% c(4L, -3L, 2L, 7L, 8L), !logi_s, ))
  exp_eq(and3s(it %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ),
         band3(it %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ))
  exp_eq(and3s(iu %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ),
         band3(iu %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ))
  exp_eq(and3s(iv %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, o <= 0L),
         band3(iv %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, o <= 0L))
  exp_eq(and3s(iw %in% c(4L, -3L, 2L, 7L, 8L), !logi_f, q <= 1L),
         band3(iw %in% c(4L, -3L, 2L, 7L, 8L), !logi_f, q <= 1L))
  exp_eq(and3s(ix %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, m <= 9L),
         band3(ix %in% c(4L, -3L, 2L, 7L, 8L), !logi_q, m <= 9L))
  exp_eq(and3s(iy %in% 1:4, , ),
         band3(iy %in% 1:4, , ))
  exp_eq(and3s(iz %in% 1:4, , ),
         band3(iz %in% 1:4, , ))
  exp_eq(and3s(iaa %in% 1:4, , ),
         band3(iaa %in% 1:4, , ))
  exp_eq(and3s(iab %in% 1:4, , j <= 0L),
         band3(iab %in% 1:4, , j <= 0L))
  exp_eq(and3s(iac %in% 1:4, , h <= 1L),
         band3(iac %in% 1:4, , h <= 1L))
  exp_eq(and3s(iad %in% 1:4, , u <= 9L),
         band3(iad %in% 1:4, , u <= 9L))
  exp_eq(and3s(iae %in% 1:4, !logi_k, ),
         band3(iae %in% 1:4, !logi_k, ))
  exp_eq(and3s(iaf %in% 1:4, !logi_k, ),
         band3(iaf %in% 1:4, !logi_k, ))
  exp_eq(and3s(iag %in% 1:4, !logi_p, ),
         band3(iag %in% 1:4, !logi_p, ))
  exp_eq(and3s(iah %in% 1:4, !logi_t, g <= 0L),
         band3(iah %in% 1:4, !logi_t, g <= 0L))
  exp_eq(and3s(iai %in% 1:4, !logi_r, r <= 1L),
         band3(iai %in% 1:4, !logi_r, r <= 1L))
  exp_eq(and3s(iaj %in% 1:4, !logi_a, n <= 9L),
         band3(iaj %in% 1:4, !logi_a, n <= 9L))
  exp_eq(and3s(iak %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iak %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ial %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ial %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iam %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iam %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ian %in% c(4L, -3L, 2L, 7L, 8L), , i == 0L),
         band3(ian %in% c(4L, -3L, 2L, 7L, 8L), , i == 0L))
  exp_eq(and3s(iao %in% c(4L, -3L, 2L, 7L, 8L), , d == 1L),
         band3(iao %in% c(4L, -3L, 2L, 7L, 8L), , d == 1L))
  exp_eq(and3s(iap %in% c(4L, -3L, 2L, 7L, 8L), , r == 9L),
         band3(iap %in% c(4L, -3L, 2L, 7L, 8L), , r == 9L))
  exp_eq(and3s(iaq %in% c(4L, -3L, 2L, 7L, 8L), !logi_s, ),
         band3(iaq %in% c(4L, -3L, 2L, 7L, 8L), !logi_s, ))
  exp_eq(and3s(iar %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ),
         band3(iar %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, ))
  exp_eq(and3s(ias %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ),
         band3(ias %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ))
  exp_eq(and3s(iat %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, z == 0L),
         band3(iat %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, z == 0L))
  exp_eq(and3s(iau %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, z == 1L),
         band3(iau %in% c(4L, -3L, 2L, 7L, 8L), !logi_h, z == 1L))
  exp_eq(and3s(iav %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, t == 9L),
         band3(iav %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, t == 9L))
  exp_eq(and3s(iaw %in% 1:4, , ),
         band3(iaw %in% 1:4, , ))
  exp_eq(and3s(iax %in% 1:4, , ),
         band3(iax %in% 1:4, , ))
  exp_eq(and3s(iay %in% 1:4, , ),
         band3(iay %in% 1:4, , ))
  exp_eq(and3s(iaz %in% 1:4, , d == 0L),
         band3(iaz %in% 1:4, , d == 0L))
  exp_eq(and3s(iba %in% 1:4, , n == 1L),
         band3(iba %in% 1:4, , n == 1L))
  exp_eq(and3s(ibb %in% 1:4, , n == 9L),
         band3(ibb %in% 1:4, , n == 9L))
  exp_eq(and3s(ibc %in% 1:4, !logi_r, ),
         band3(ibc %in% 1:4, !logi_r, ))
  exp_eq(and3s(ibd %in% 1:4, !logi_a, ),
         band3(ibd %in% 1:4, !logi_a, ))
  exp_eq(and3s(ibe %in% 1:4, !logi_w, ),
         band3(ibe %in% 1:4, !logi_w, ))
  exp_eq(and3s(ibf %in% 1:4, !logi_r, x == 0L),
         band3(ibf %in% 1:4, !logi_r, x == 0L))
  exp_eq(and3s(ibg %in% 1:4, !logi_y, i == 1L),
         band3(ibg %in% 1:4, !logi_y, i == 1L))
  exp_eq(and3s(ibh %in% 1:4, !logi_w, r == 9L),
         band3(ibh %in% 1:4, !logi_w, r == 9L))
  exp_eq(and3s(ibi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ibi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ibj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ibj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ibk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ibk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ibl %in% c(4L, -3L, 2L, 7L, 8L), , w > 0L),
         band3(ibl %in% c(4L, -3L, 2L, 7L, 8L), , w > 0L))
  exp_eq(and3s(ibm %in% c(4L, -3L, 2L, 7L, 8L), , i > 1L),
         band3(ibm %in% c(4L, -3L, 2L, 7L, 8L), , i > 1L))
  exp_eq(and3s(ibn %in% c(4L, -3L, 2L, 7L, 8L), , u > 9L),
         band3(ibn %in% c(4L, -3L, 2L, 7L, 8L), , u > 9L))
  exp_eq(and3s(ibo %in% c(4L, -3L, 2L, 7L, 8L), !logi_d, ),
         band3(ibo %in% c(4L, -3L, 2L, 7L, 8L), !logi_d, ))
  exp_eq(and3s(ibp %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ),
         band3(ibp %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, ))
  exp_eq(and3s(ibq %in% c(4L, -3L, 2L, 7L, 8L), !logi_t, ),
         band3(ibq %in% c(4L, -3L, 2L, 7L, 8L), !logi_t, ))
  exp_eq(and3s(ibr %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, y > 0L),
         band3(ibr %in% c(4L, -3L, 2L, 7L, 8L), !logi_w, y > 0L))
  exp_eq(and3s(ibs %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, d > 1L),
         band3(ibs %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, d > 1L))
  exp_eq(and3s(ibt %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, o > 9L),
         band3(ibt %in% c(4L, -3L, 2L, 7L, 8L), !logi_r, o > 9L))
  exp_eq(and3s(ibu %in% 1:4, , ),
         band3(ibu %in% 1:4, , ))
  exp_eq(and3s(ibv %in% 1:4, , ),
         band3(ibv %in% 1:4, , ))
  exp_eq(and3s(ibw %in% 1:4, , ),
         band3(ibw %in% 1:4, , ))
  exp_eq(and3s(ibx %in% 1:4, , q > 0L),
         band3(ibx %in% 1:4, , q > 0L))
  exp_eq(and3s(iby %in% 1:4, , h > 1L),
         band3(iby %in% 1:4, , h > 1L))
  exp_eq(and3s(ibz %in% 1:4, , d > 9L),
         band3(ibz %in% 1:4, , d > 9L))
  exp_eq(and3s(ica %in% 1:4, !logi_h, ),
         band3(ica %in% 1:4, !logi_h, ))
  exp_eq(and3s(icb %in% 1:4, !logi_n, ),
         band3(icb %in% 1:4, !logi_n, ))
  exp_eq(and3s(icc %in% 1:4, !logi_r, ),
         band3(icc %in% 1:4, !logi_r, ))
  exp_eq(and3s(icd %in% 1:4, !logi_d, c > 0L),
         band3(icd %in% 1:4, !logi_d, c > 0L))
  exp_eq(and3s(ice %in% 1:4, !logi_h, y > 1L),
         band3(ice %in% 1:4, !logi_h, y > 1L))
  exp_eq(and3s(icf %in% 1:4, !logi_z, z > 9L),
         band3(icf %in% 1:4, !logi_z, z > 9L))
  exp_eq(and3s(icg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(icg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ich %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ich %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ici %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ici %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(icj %in% c(4L, -3L, 2L, 7L, 8L), , f >= 0L),
         band3(icj %in% c(4L, -3L, 2L, 7L, 8L), , f >= 0L))
  exp_eq(and3s(ick %in% c(4L, -3L, 2L, 7L, 8L), , f >= 1L),
         band3(ick %in% c(4L, -3L, 2L, 7L, 8L), , f >= 1L))
  exp_eq(and3s(icl %in% c(4L, -3L, 2L, 7L, 8L), , t >= 9L),
         band3(icl %in% c(4L, -3L, 2L, 7L, 8L), , t >= 9L))
  exp_eq(and3s(icm %in% c(4L, -3L, 2L, 7L, 8L), !logi_u, ),
         band3(icm %in% c(4L, -3L, 2L, 7L, 8L), !logi_u, ))
  exp_eq(and3s(icn %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, ),
         band3(icn %in% c(4L, -3L, 2L, 7L, 8L), !logi_l, ))
  exp_eq(and3s(ico %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ),
         band3(ico %in% c(4L, -3L, 2L, 7L, 8L), !logi_m, ))
  exp_eq(and3s(icp %in% c(4L, -3L, 2L, 7L, 8L), !logi_a, z >= 0L),
         band3(icp %in% c(4L, -3L, 2L, 7L, 8L), !logi_a, z >= 0L))
  exp_eq(and3s(icq %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, p >= 1L),
         band3(icq %in% c(4L, -3L, 2L, 7L, 8L), !logi_v, p >= 1L))
  exp_eq(and3s(icr %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, t >= 9L),
         band3(icr %in% c(4L, -3L, 2L, 7L, 8L), !logi_z, t >= 9L))
  exp_eq(and3s(ics %in% 1:4, , ),
         band3(ics %in% 1:4, , ))
  exp_eq(and3s(ict %in% 1:4, , ),
         band3(ict %in% 1:4, , ))
  exp_eq(and3s(icu %in% 1:4, , ),
         band3(icu %in% 1:4, , ))
  exp_eq(and3s(icv %in% 1:4, , r >= 0L),
         band3(icv %in% 1:4, , r >= 0L))
  exp_eq(and3s(icw %in% 1:4, , z >= 1L),
         band3(icw %in% 1:4, , z >= 1L))
  exp_eq(and3s(icx %in% 1:4, , h >= 9L),
         band3(icx %in% 1:4, , h >= 9L))
  exp_eq(and3s(icy %in% 1:4, !logi_a, ),
         band3(icy %in% 1:4, !logi_a, ))
  exp_eq(and3s(icz %in% 1:4, !logi_r, ),
         band3(icz %in% 1:4, !logi_r, ))
  exp_eq(and3s(ida %in% 1:4, !logi_l, ),
         band3(ida %in% 1:4, !logi_l, ))
  exp_eq(and3s(idb %in% 1:4, !logi_n, d >= 0L),
         band3(idb %in% 1:4, !logi_n, d >= 0L))
  exp_eq(and3s(idc %in% 1:4, !logi_z, j >= 1L),
         band3(idc %in% 1:4, !logi_z, j >= 1L))
  exp_eq(and3s(idd %in% 1:4, !logi_q, z >= 9L),
         band3(idd %in% 1:4, !logi_q, z >= 9L))
  exp_eq(and3s(ide %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ide %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(idf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(idf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(idg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(idg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(idh %in% c(4L, -3L, 2L, 7L, 8L), , logi_n),
         band3(idh %in% c(4L, -3L, 2L, 7L, 8L), , logi_n))
  exp_eq(and3s(idi %in% c(4L, -3L, 2L, 7L, 8L), , logi_o),
         band3(idi %in% c(4L, -3L, 2L, 7L, 8L), , logi_o))
  exp_eq(and3s(idj %in% c(4L, -3L, 2L, 7L, 8L), , logi_l),
         band3(idj %in% c(4L, -3L, 2L, 7L, 8L), , logi_l))
  exp_eq(and3s(idk %in% c(4L, -3L, 2L, 7L, 8L), d != 0L, ),
         band3(idk %in% c(4L, -3L, 2L, 7L, 8L), d != 0L, ))
  exp_eq(and3s(idl %in% c(4L, -3L, 2L, 7L, 8L), g != 1L, ),
         band3(idl %in% c(4L, -3L, 2L, 7L, 8L), g != 1L, ))
  exp_eq(and3s(idm %in% c(4L, -3L, 2L, 7L, 8L), w != 9L, ),
         band3(idm %in% c(4L, -3L, 2L, 7L, 8L), w != 9L, ))
  exp_eq(and3s(idn %in% c(4L, -3L, 2L, 7L, 8L), t != 0L, logi_v),
         band3(idn %in% c(4L, -3L, 2L, 7L, 8L), t != 0L, logi_v))
  exp_eq(and3s(ido %in% c(4L, -3L, 2L, 7L, 8L), u != 1L, logi_j),
         band3(ido %in% c(4L, -3L, 2L, 7L, 8L), u != 1L, logi_j))
  exp_eq(and3s(idp %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, logi_u),
         band3(idp %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, logi_u))
  exp_eq(and3s(idq %in% 1:4, , ),
         band3(idq %in% 1:4, , ))
  exp_eq(and3s(idr %in% 1:4, , ),
         band3(idr %in% 1:4, , ))
  exp_eq(and3s(ids %in% 1:4, , ),
         band3(ids %in% 1:4, , ))
  exp_eq(and3s(idt %in% 1:4, , logi_o),
         band3(idt %in% 1:4, , logi_o))
  exp_eq(and3s(idu %in% 1:4, , logi_z),
         band3(idu %in% 1:4, , logi_z))
  exp_eq(and3s(idv %in% 1:4, , logi_h),
         band3(idv %in% 1:4, , logi_h))
  exp_eq(and3s(idw %in% 1:4, f != 0L, ),
         band3(idw %in% 1:4, f != 0L, ))
  exp_eq(and3s(idx %in% 1:4, z != 1L, ),
         band3(idx %in% 1:4, z != 1L, ))
  exp_eq(and3s(idy %in% 1:4, x != 9L, ),
         band3(idy %in% 1:4, x != 9L, ))
  exp_eq(and3s(idz %in% 1:4, h != 0L, logi_e),
         band3(idz %in% 1:4, h != 0L, logi_e))
  exp_eq(and3s(iea %in% 1:4, c != 1L, logi_q),
         band3(iea %in% 1:4, c != 1L, logi_q))
  exp_eq(and3s(ieb %in% 1:4, j != 9L, logi_z),
         band3(ieb %in% 1:4, j != 9L, logi_z))
  exp_eq(and3s(iec %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iec %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ied %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ied %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iee %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iee %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ief %in% c(4L, -3L, 2L, 7L, 8L), , !logi_q),
         band3(ief %in% c(4L, -3L, 2L, 7L, 8L), , !logi_q))
  exp_eq(and3s(ieg %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u),
         band3(ieg %in% c(4L, -3L, 2L, 7L, 8L), , !logi_u))
  exp_eq(and3s(ieh %in% c(4L, -3L, 2L, 7L, 8L), , !logi_d),
         band3(ieh %in% c(4L, -3L, 2L, 7L, 8L), , !logi_d))
  exp_eq(and3s(iei %in% c(4L, -3L, 2L, 7L, 8L), a != 0L, ),
         band3(iei %in% c(4L, -3L, 2L, 7L, 8L), a != 0L, ))
  exp_eq(and3s(iej %in% c(4L, -3L, 2L, 7L, 8L), m != 1L, ),
         band3(iej %in% c(4L, -3L, 2L, 7L, 8L), m != 1L, ))
  exp_eq(and3s(iek %in% c(4L, -3L, 2L, 7L, 8L), b != 9L, ),
         band3(iek %in% c(4L, -3L, 2L, 7L, 8L), b != 9L, ))
  exp_eq(and3s(iel %in% c(4L, -3L, 2L, 7L, 8L), i != 0L, !logi_k),
         band3(iel %in% c(4L, -3L, 2L, 7L, 8L), i != 0L, !logi_k))
  exp_eq(and3s(iem %in% c(4L, -3L, 2L, 7L, 8L), p != 1L, !logi_g),
         band3(iem %in% c(4L, -3L, 2L, 7L, 8L), p != 1L, !logi_g))
  exp_eq(and3s(ien %in% c(4L, -3L, 2L, 7L, 8L), q != 9L, !logi_p),
         band3(ien %in% c(4L, -3L, 2L, 7L, 8L), q != 9L, !logi_p))
  exp_eq(and3s(ieo %in% 1:4, , ),
         band3(ieo %in% 1:4, , ))
  exp_eq(and3s(iep %in% 1:4, , ),
         band3(iep %in% 1:4, , ))
  exp_eq(and3s(ieq %in% 1:4, , ),
         band3(ieq %in% 1:4, , ))
  exp_eq(and3s(ier %in% 1:4, , !logi_x),
         band3(ier %in% 1:4, , !logi_x))
  exp_eq(and3s(ies %in% 1:4, , !logi_p),
         band3(ies %in% 1:4, , !logi_p))
  exp_eq(and3s(iet %in% 1:4, , !logi_l),
         band3(iet %in% 1:4, , !logi_l))
  exp_eq(and3s(ieu %in% 1:4, m != 0L, ),
         band3(ieu %in% 1:4, m != 0L, ))
  exp_eq(and3s(iev %in% 1:4, h != 1L, ),
         band3(iev %in% 1:4, h != 1L, ))
  exp_eq(and3s(iew %in% 1:4, p != 9L, ),
         band3(iew %in% 1:4, p != 9L, ))
  exp_eq(and3s(iex %in% 1:4, w != 0L, !logi_b),
         band3(iex %in% 1:4, w != 0L, !logi_b))
  exp_eq(and3s(iey %in% 1:4, e != 1L, !logi_d),
         band3(iey %in% 1:4, e != 1L, !logi_d))
  exp_eq(and3s(iez %in% 1:4, m != 9L, !logi_f),
         band3(iez %in% 1:4, m != 9L, !logi_f))
  exp_eq(and3s(ifa %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ifa %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ifb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ifb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ifc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ifc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ifd %in% c(4L, -3L, 2L, 7L, 8L), , t != 0L),
         band3(ifd %in% c(4L, -3L, 2L, 7L, 8L), , t != 0L))
  exp_eq(and3s(ife %in% c(4L, -3L, 2L, 7L, 8L), , v != 1L),
         band3(ife %in% c(4L, -3L, 2L, 7L, 8L), , v != 1L))
  exp_eq(and3s(iff %in% c(4L, -3L, 2L, 7L, 8L), , o != 9L),
         band3(iff %in% c(4L, -3L, 2L, 7L, 8L), , o != 9L))
  exp_eq(and3s(ifg %in% c(4L, -3L, 2L, 7L, 8L), e != 0L, ),
         band3(ifg %in% c(4L, -3L, 2L, 7L, 8L), e != 0L, ))
  exp_eq(and3s(ifh %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ),
         band3(ifh %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ))
  exp_eq(and3s(ifi %in% c(4L, -3L, 2L, 7L, 8L), i != 9L, ),
         band3(ifi %in% c(4L, -3L, 2L, 7L, 8L), i != 9L, ))
  exp_eq(and3s(ifj %in% c(4L, -3L, 2L, 7L, 8L), e != 0L, y != 0L),
         band3(ifj %in% c(4L, -3L, 2L, 7L, 8L), e != 0L, y != 0L))
  exp_eq(and3s(ifk %in% c(4L, -3L, 2L, 7L, 8L), b != 1L, m != 1L),
         band3(ifk %in% c(4L, -3L, 2L, 7L, 8L), b != 1L, m != 1L))
  exp_eq(and3s(ifl %in% c(4L, -3L, 2L, 7L, 8L), u != 9L, s != 9L),
         band3(ifl %in% c(4L, -3L, 2L, 7L, 8L), u != 9L, s != 9L))
  exp_eq(and3s(ifm %in% 1:4, , ),
         band3(ifm %in% 1:4, , ))
  exp_eq(and3s(ifn %in% 1:4, , ),
         band3(ifn %in% 1:4, , ))
  exp_eq(and3s(ifo %in% 1:4, , ),
         band3(ifo %in% 1:4, , ))
  exp_eq(and3s(ifp %in% 1:4, , r != 0L),
         band3(ifp %in% 1:4, , r != 0L))
  exp_eq(and3s(ifq %in% 1:4, , w != 1L),
         band3(ifq %in% 1:4, , w != 1L))
  exp_eq(and3s(ifr %in% 1:4, , z != 9L),
         band3(ifr %in% 1:4, , z != 9L))
  exp_eq(and3s(ifs %in% 1:4, i != 0L, ),
         band3(ifs %in% 1:4, i != 0L, ))
  exp_eq(and3s(ift %in% 1:4, h != 1L, ),
         band3(ift %in% 1:4, h != 1L, ))
  exp_eq(and3s(ifu %in% 1:4, w != 9L, ),
         band3(ifu %in% 1:4, w != 9L, ))
  exp_eq(and3s(ifv %in% 1:4, p != 0L, m != 0L),
         band3(ifv %in% 1:4, p != 0L, m != 0L))
  exp_eq(and3s(ifw %in% 1:4, w != 1L, l != 1L),
         band3(ifw %in% 1:4, w != 1L, l != 1L))
  exp_eq(and3s(ifx %in% 1:4, r != 9L, r != 9L),
         band3(ifx %in% 1:4, r != 9L, r != 9L))
  exp_eq(and3s(ify %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ify %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ifz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ifz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iga %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iga %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(igb %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)),
         band3(igb %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)))
  exp_eq(and3s(igc %in% c(4L, -3L, 2L, 7L, 8L), , u %between% c(-1L, 1L)),
         band3(igc %in% c(4L, -3L, 2L, 7L, 8L), , u %between% c(-1L, 1L)))
  exp_eq(and3s(igd %in% c(4L, -3L, 2L, 7L, 8L), , o %between% c(-1L, 1L)),
         band3(igd %in% c(4L, -3L, 2L, 7L, 8L), , o %between% c(-1L, 1L)))
  exp_eq(and3s(ige %in% c(4L, -3L, 2L, 7L, 8L), z != 0L, ),
         band3(ige %in% c(4L, -3L, 2L, 7L, 8L), z != 0L, ))
  exp_eq(and3s(igf %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ),
         band3(igf %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ))
  exp_eq(and3s(igg %in% c(4L, -3L, 2L, 7L, 8L), b != 9L, ),
         band3(igg %in% c(4L, -3L, 2L, 7L, 8L), b != 9L, ))
  exp_eq(and3s(igh %in% c(4L, -3L, 2L, 7L, 8L), v != 0L, t %between% c(-1L, 1L)),
         band3(igh %in% c(4L, -3L, 2L, 7L, 8L), v != 0L, t %between% c(-1L, 1L)))
  exp_eq(and3s(igi %in% c(4L, -3L, 2L, 7L, 8L), m != 1L, e %between% c(-1L, 1L)),
         band3(igi %in% c(4L, -3L, 2L, 7L, 8L), m != 1L, e %between% c(-1L, 1L)))
  exp_eq(and3s(igj %in% c(4L, -3L, 2L, 7L, 8L), n != 9L, g %between% c(-1L, 1L)),
         band3(igj %in% c(4L, -3L, 2L, 7L, 8L), n != 9L, g %between% c(-1L, 1L)))
  exp_eq(and3s(igk %in% 1:4, , ),
         band3(igk %in% 1:4, , ))
  exp_eq(and3s(igl %in% 1:4, , ),
         band3(igl %in% 1:4, , ))
  exp_eq(and3s(igm %in% 1:4, , ),
         band3(igm %in% 1:4, , ))
  exp_eq(and3s(ign %in% 1:4, , k %between% c(-1L, 1L)),
         band3(ign %in% 1:4, , k %between% c(-1L, 1L)))
  exp_eq(and3s(igo %in% 1:4, , q %between% c(-1L, 1L)),
         band3(igo %in% 1:4, , q %between% c(-1L, 1L)))
  exp_eq(and3s(igp %in% 1:4, , f %between% c(-1L, 1L)),
         band3(igp %in% 1:4, , f %between% c(-1L, 1L)))
  exp_eq(and3s(igq %in% 1:4, w != 0L, ),
         band3(igq %in% 1:4, w != 0L, ))
  exp_eq(and3s(igr %in% 1:4, w != 1L, ),
         band3(igr %in% 1:4, w != 1L, ))
  exp_eq(and3s(igs %in% 1:4, z != 9L, ),
         band3(igs %in% 1:4, z != 9L, ))
  exp_eq(and3s(igt %in% 1:4, c != 0L, e %between% c(-1L, 1L)),
         band3(igt %in% 1:4, c != 0L, e %between% c(-1L, 1L)))
  exp_eq(and3s(igu %in% 1:4, d != 1L, x %between% c(-1L, 1L)),
         band3(igu %in% 1:4, d != 1L, x %between% c(-1L, 1L)))
  exp_eq(and3s(igv %in% 1:4, o != 9L, n %between% c(-1L, 1L)),
         band3(igv %in% 1:4, o != 9L, n %between% c(-1L, 1L)))
  exp_eq(and3s(igw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(igw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(igx %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(igx %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(igy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(igy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(igz %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(igz %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iha %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iha %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ihb %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ihb %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ihc %in% c(4L, -3L, 2L, 7L, 8L), k != 0L, ),
         band3(ihc %in% c(4L, -3L, 2L, 7L, 8L), k != 0L, ))
  exp_eq(and3s(ihd %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ),
         band3(ihd %in% c(4L, -3L, 2L, 7L, 8L), o != 1L, ))
  exp_eq(and3s(ihe %in% c(4L, -3L, 2L, 7L, 8L), u != 9L, ),
         band3(ihe %in% c(4L, -3L, 2L, 7L, 8L), u != 9L, ))
  exp_eq(and3s(ihf %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ihf %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ihg %in% c(4L, -3L, 2L, 7L, 8L), r != 1L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ihg %in% c(4L, -3L, 2L, 7L, 8L), r != 1L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ihh %in% c(4L, -3L, 2L, 7L, 8L), y != 9L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ihh %in% c(4L, -3L, 2L, 7L, 8L), y != 9L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ihi %in% 1:4, , ),
         band3(ihi %in% 1:4, , ))
  exp_eq(and3s(ihj %in% 1:4, , ),
         band3(ihj %in% 1:4, , ))
  exp_eq(and3s(ihk %in% 1:4, , ),
         band3(ihk %in% 1:4, , ))
  exp_eq(and3s(ihl %in% 1:4, , g %in% 1:4),
         band3(ihl %in% 1:4, , g %in% 1:4))
  exp_eq(and3s(ihm %in% 1:4, , w %in% 1:4),
         band3(ihm %in% 1:4, , w %in% 1:4))
  exp_eq(and3s(ihn %in% 1:4, , b %in% 1:4),
         band3(ihn %in% 1:4, , b %in% 1:4))
  exp_eq(and3s(iho %in% 1:4, x != 0L, ),
         band3(iho %in% 1:4, x != 0L, ))
  exp_eq(and3s(ihp %in% 1:4, t != 1L, ),
         band3(ihp %in% 1:4, t != 1L, ))
  exp_eq(and3s(ihq %in% 1:4, i != 9L, ),
         band3(ihq %in% 1:4, i != 9L, ))
  exp_eq(and3s(ihr %in% 1:4, p != 0L, v %in% 1:4),
         band3(ihr %in% 1:4, p != 0L, v %in% 1:4))
  exp_eq(and3s(ihs %in% 1:4, p != 1L, l %in% 1:4),
         band3(ihs %in% 1:4, p != 1L, l %in% 1:4))
  exp_eq(and3s(iht %in% 1:4, h != 9L, k %in% 1:4),
         band3(iht %in% 1:4, h != 9L, k %in% 1:4))
  exp_eq(and3s(ihu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ihu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ihv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ihv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ihw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ihw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ihx %in% c(4L, -3L, 2L, 7L, 8L), , c < 0L),
         band3(ihx %in% c(4L, -3L, 2L, 7L, 8L), , c < 0L))
  exp_eq(and3s(ihy %in% c(4L, -3L, 2L, 7L, 8L), , d < 1L),
         band3(ihy %in% c(4L, -3L, 2L, 7L, 8L), , d < 1L))
  exp_eq(and3s(ihz %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L),
         band3(ihz %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L))
  exp_eq(and3s(iia %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, ),
         band3(iia %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, ))
  exp_eq(and3s(iib %in% c(4L, -3L, 2L, 7L, 8L), y != 1L, ),
         band3(iib %in% c(4L, -3L, 2L, 7L, 8L), y != 1L, ))
  exp_eq(and3s(iic %in% c(4L, -3L, 2L, 7L, 8L), y != 9L, ),
         band3(iic %in% c(4L, -3L, 2L, 7L, 8L), y != 9L, ))
  exp_eq(and3s(iid %in% c(4L, -3L, 2L, 7L, 8L), m != 0L, b < 0L),
         band3(iid %in% c(4L, -3L, 2L, 7L, 8L), m != 0L, b < 0L))
  exp_eq(and3s(iie %in% c(4L, -3L, 2L, 7L, 8L), r != 1L, e < 1L),
         band3(iie %in% c(4L, -3L, 2L, 7L, 8L), r != 1L, e < 1L))
  exp_eq(and3s(iif %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, w < 9L),
         band3(iif %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, w < 9L))
  exp_eq(and3s(iig %in% 1:4, , ),
         band3(iig %in% 1:4, , ))
  exp_eq(and3s(iih %in% 1:4, , ),
         band3(iih %in% 1:4, , ))
  exp_eq(and3s(iii %in% 1:4, , ),
         band3(iii %in% 1:4, , ))
  exp_eq(and3s(iij %in% 1:4, , m < 0L),
         band3(iij %in% 1:4, , m < 0L))
  exp_eq(and3s(iik %in% 1:4, , p < 1L),
         band3(iik %in% 1:4, , p < 1L))
  exp_eq(and3s(iil %in% 1:4, , p < 9L),
         band3(iil %in% 1:4, , p < 9L))
  exp_eq(and3s(iim %in% 1:4, t != 0L, ),
         band3(iim %in% 1:4, t != 0L, ))
  exp_eq(and3s(iin %in% 1:4, h != 1L, ),
         band3(iin %in% 1:4, h != 1L, ))
  exp_eq(and3s(iio %in% 1:4, g != 9L, ),
         band3(iio %in% 1:4, g != 9L, ))
  exp_eq(and3s(iip %in% 1:4, k != 0L, t < 0L),
         band3(iip %in% 1:4, k != 0L, t < 0L))
  exp_eq(and3s(iiq %in% 1:4, u != 1L, r < 1L),
         band3(iiq %in% 1:4, u != 1L, r < 1L))
  exp_eq(and3s(iir %in% 1:4, x != 9L, g < 9L),
         band3(iir %in% 1:4, x != 9L, g < 9L))
  exp_eq(and3s(iis %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iis %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iit %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iit %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iiu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iiu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iiv %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L),
         band3(iiv %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L))
  exp_eq(and3s(iiw %in% c(4L, -3L, 2L, 7L, 8L), , c <= 1L),
         band3(iiw %in% c(4L, -3L, 2L, 7L, 8L), , c <= 1L))
  exp_eq(and3s(iix %in% c(4L, -3L, 2L, 7L, 8L), , v <= 9L),
         band3(iix %in% c(4L, -3L, 2L, 7L, 8L), , v <= 9L))
  exp_eq(and3s(iiy %in% c(4L, -3L, 2L, 7L, 8L), y != 0L, ),
         band3(iiy %in% c(4L, -3L, 2L, 7L, 8L), y != 0L, ))
  exp_eq(and3s(iiz %in% c(4L, -3L, 2L, 7L, 8L), a != 1L, ),
         band3(iiz %in% c(4L, -3L, 2L, 7L, 8L), a != 1L, ))
  exp_eq(and3s(ija %in% c(4L, -3L, 2L, 7L, 8L), o != 9L, ),
         band3(ija %in% c(4L, -3L, 2L, 7L, 8L), o != 9L, ))
  exp_eq(and3s(ijb %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, m <= 0L),
         band3(ijb %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, m <= 0L))
  exp_eq(and3s(ijc %in% c(4L, -3L, 2L, 7L, 8L), h != 1L, h <= 1L),
         band3(ijc %in% c(4L, -3L, 2L, 7L, 8L), h != 1L, h <= 1L))
  exp_eq(and3s(ijd %in% c(4L, -3L, 2L, 7L, 8L), s != 9L, g <= 9L),
         band3(ijd %in% c(4L, -3L, 2L, 7L, 8L), s != 9L, g <= 9L))
  exp_eq(and3s(ije %in% 1:4, , ),
         band3(ije %in% 1:4, , ))
  exp_eq(and3s(ijf %in% 1:4, , ),
         band3(ijf %in% 1:4, , ))
  exp_eq(and3s(ijg %in% 1:4, , ),
         band3(ijg %in% 1:4, , ))
  exp_eq(and3s(ijh %in% 1:4, , r <= 0L),
         band3(ijh %in% 1:4, , r <= 0L))
  exp_eq(and3s(iji %in% 1:4, , s <= 1L),
         band3(iji %in% 1:4, , s <= 1L))
  exp_eq(and3s(ijj %in% 1:4, , n <= 9L),
         band3(ijj %in% 1:4, , n <= 9L))
  exp_eq(and3s(ijk %in% 1:4, w != 0L, ),
         band3(ijk %in% 1:4, w != 0L, ))
  exp_eq(and3s(ijl %in% 1:4, v != 1L, ),
         band3(ijl %in% 1:4, v != 1L, ))
  exp_eq(and3s(ijm %in% 1:4, y != 9L, ),
         band3(ijm %in% 1:4, y != 9L, ))
  exp_eq(and3s(ijn %in% 1:4, v != 0L, y <= 0L),
         band3(ijn %in% 1:4, v != 0L, y <= 0L))
  exp_eq(and3s(ijo %in% 1:4, k != 1L, e <= 1L),
         band3(ijo %in% 1:4, k != 1L, e <= 1L))
  exp_eq(and3s(ijp %in% 1:4, r != 9L, w <= 9L),
         band3(ijp %in% 1:4, r != 9L, w <= 9L))
  exp_eq(and3s(ijq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ijq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ijr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ijr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ijs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ijs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ijt %in% c(4L, -3L, 2L, 7L, 8L), , q == 0L),
         band3(ijt %in% c(4L, -3L, 2L, 7L, 8L), , q == 0L))
  exp_eq(and3s(iju %in% c(4L, -3L, 2L, 7L, 8L), , u == 1L),
         band3(iju %in% c(4L, -3L, 2L, 7L, 8L), , u == 1L))
  exp_eq(and3s(ijv %in% c(4L, -3L, 2L, 7L, 8L), , f == 9L),
         band3(ijv %in% c(4L, -3L, 2L, 7L, 8L), , f == 9L))
  exp_eq(and3s(ijw %in% c(4L, -3L, 2L, 7L, 8L), a != 0L, ),
         band3(ijw %in% c(4L, -3L, 2L, 7L, 8L), a != 0L, ))
  exp_eq(and3s(ijx %in% c(4L, -3L, 2L, 7L, 8L), i != 1L, ),
         band3(ijx %in% c(4L, -3L, 2L, 7L, 8L), i != 1L, ))
  exp_eq(and3s(ijy %in% c(4L, -3L, 2L, 7L, 8L), l != 9L, ),
         band3(ijy %in% c(4L, -3L, 2L, 7L, 8L), l != 9L, ))
  exp_eq(and3s(ijz %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, m == 0L),
         band3(ijz %in% c(4L, -3L, 2L, 7L, 8L), r != 0L, m == 0L))
  exp_eq(and3s(ika %in% c(4L, -3L, 2L, 7L, 8L), z != 1L, p == 1L),
         band3(ika %in% c(4L, -3L, 2L, 7L, 8L), z != 1L, p == 1L))
  exp_eq(and3s(ikb %in% c(4L, -3L, 2L, 7L, 8L), e != 9L, w == 9L),
         band3(ikb %in% c(4L, -3L, 2L, 7L, 8L), e != 9L, w == 9L))
  exp_eq(and3s(ikc %in% 1:4, , ),
         band3(ikc %in% 1:4, , ))
  exp_eq(and3s(ikd %in% 1:4, , ),
         band3(ikd %in% 1:4, , ))
  exp_eq(and3s(ike %in% 1:4, , ),
         band3(ike %in% 1:4, , ))
  exp_eq(and3s(ikf %in% 1:4, , z == 0L),
         band3(ikf %in% 1:4, , z == 0L))
  exp_eq(and3s(ikg %in% 1:4, , q == 1L),
         band3(ikg %in% 1:4, , q == 1L))
  exp_eq(and3s(ikh %in% 1:4, , n == 9L),
         band3(ikh %in% 1:4, , n == 9L))
  exp_eq(and3s(iki %in% 1:4, t != 0L, ),
         band3(iki %in% 1:4, t != 0L, ))
  exp_eq(and3s(ikj %in% 1:4, a != 1L, ),
         band3(ikj %in% 1:4, a != 1L, ))
  exp_eq(and3s(ikk %in% 1:4, e != 9L, ),
         band3(ikk %in% 1:4, e != 9L, ))
  exp_eq(and3s(ikl %in% 1:4, t != 0L, n == 0L),
         band3(ikl %in% 1:4, t != 0L, n == 0L))
  exp_eq(and3s(ikm %in% 1:4, t != 1L, l == 1L),
         band3(ikm %in% 1:4, t != 1L, l == 1L))
  exp_eq(and3s(ikn %in% 1:4, n != 9L, i == 9L),
         band3(ikn %in% 1:4, n != 9L, i == 9L))
  exp_eq(and3s(iko %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iko %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ikp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ikp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ikq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ikq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ikr %in% c(4L, -3L, 2L, 7L, 8L), , x > 0L),
         band3(ikr %in% c(4L, -3L, 2L, 7L, 8L), , x > 0L))
  exp_eq(and3s(iks %in% c(4L, -3L, 2L, 7L, 8L), , m > 1L),
         band3(iks %in% c(4L, -3L, 2L, 7L, 8L), , m > 1L))
  exp_eq(and3s(ikt %in% c(4L, -3L, 2L, 7L, 8L), , n > 9L),
         band3(ikt %in% c(4L, -3L, 2L, 7L, 8L), , n > 9L))
  exp_eq(and3s(iku %in% c(4L, -3L, 2L, 7L, 8L), q != 0L, ),
         band3(iku %in% c(4L, -3L, 2L, 7L, 8L), q != 0L, ))
  exp_eq(and3s(ikv %in% c(4L, -3L, 2L, 7L, 8L), l != 1L, ),
         band3(ikv %in% c(4L, -3L, 2L, 7L, 8L), l != 1L, ))
  exp_eq(and3s(ikw %in% c(4L, -3L, 2L, 7L, 8L), e != 9L, ),
         band3(ikw %in% c(4L, -3L, 2L, 7L, 8L), e != 9L, ))
  exp_eq(and3s(ikx %in% c(4L, -3L, 2L, 7L, 8L), l != 0L, c > 0L),
         band3(ikx %in% c(4L, -3L, 2L, 7L, 8L), l != 0L, c > 0L))
  exp_eq(and3s(iky %in% c(4L, -3L, 2L, 7L, 8L), f != 1L, a > 1L),
         band3(iky %in% c(4L, -3L, 2L, 7L, 8L), f != 1L, a > 1L))
  exp_eq(and3s(ikz %in% c(4L, -3L, 2L, 7L, 8L), j != 9L, p > 9L),
         band3(ikz %in% c(4L, -3L, 2L, 7L, 8L), j != 9L, p > 9L))
  exp_eq(and3s(ila %in% 1:4, , ),
         band3(ila %in% 1:4, , ))
  exp_eq(and3s(ilb %in% 1:4, , ),
         band3(ilb %in% 1:4, , ))
  exp_eq(and3s(ilc %in% 1:4, , ),
         band3(ilc %in% 1:4, , ))
  exp_eq(and3s(ild %in% 1:4, , n > 0L),
         band3(ild %in% 1:4, , n > 0L))
  exp_eq(and3s(ile %in% 1:4, , s > 1L),
         band3(ile %in% 1:4, , s > 1L))
  exp_eq(and3s(ilf %in% 1:4, , y > 9L),
         band3(ilf %in% 1:4, , y > 9L))
  exp_eq(and3s(ilg %in% 1:4, l != 0L, ),
         band3(ilg %in% 1:4, l != 0L, ))
  exp_eq(and3s(ilh %in% 1:4, m != 1L, ),
         band3(ilh %in% 1:4, m != 1L, ))
  exp_eq(and3s(ili %in% 1:4, n != 9L, ),
         band3(ili %in% 1:4, n != 9L, ))
  exp_eq(and3s(ilj %in% 1:4, z != 0L, u > 0L),
         band3(ilj %in% 1:4, z != 0L, u > 0L))
  exp_eq(and3s(ilk %in% 1:4, p != 1L, z > 1L),
         band3(ilk %in% 1:4, p != 1L, z > 1L))
  exp_eq(and3s(ill %in% 1:4, t != 9L, n > 9L),
         band3(ill %in% 1:4, t != 9L, n > 9L))
  exp_eq(and3s(ilm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ilm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iln %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iln %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ilo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ilo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ilp %in% c(4L, -3L, 2L, 7L, 8L), , s >= 0L),
         band3(ilp %in% c(4L, -3L, 2L, 7L, 8L), , s >= 0L))
  exp_eq(and3s(ilq %in% c(4L, -3L, 2L, 7L, 8L), , w >= 1L),
         band3(ilq %in% c(4L, -3L, 2L, 7L, 8L), , w >= 1L))
  exp_eq(and3s(ilr %in% c(4L, -3L, 2L, 7L, 8L), , p >= 9L),
         band3(ilr %in% c(4L, -3L, 2L, 7L, 8L), , p >= 9L))
  exp_eq(and3s(ils %in% c(4L, -3L, 2L, 7L, 8L), p != 0L, ),
         band3(ils %in% c(4L, -3L, 2L, 7L, 8L), p != 0L, ))
  exp_eq(and3s(ilt %in% c(4L, -3L, 2L, 7L, 8L), s != 1L, ),
         band3(ilt %in% c(4L, -3L, 2L, 7L, 8L), s != 1L, ))
  exp_eq(and3s(ilu %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, ),
         band3(ilu %in% c(4L, -3L, 2L, 7L, 8L), d != 9L, ))
  exp_eq(and3s(ilv %in% c(4L, -3L, 2L, 7L, 8L), p != 0L, b >= 0L),
         band3(ilv %in% c(4L, -3L, 2L, 7L, 8L), p != 0L, b >= 0L))
  exp_eq(and3s(ilw %in% c(4L, -3L, 2L, 7L, 8L), p != 1L, k >= 1L),
         band3(ilw %in% c(4L, -3L, 2L, 7L, 8L), p != 1L, k >= 1L))
  exp_eq(and3s(ilx %in% c(4L, -3L, 2L, 7L, 8L), r != 9L, p >= 9L),
         band3(ilx %in% c(4L, -3L, 2L, 7L, 8L), r != 9L, p >= 9L))
  exp_eq(and3s(ily %in% 1:4, , ),
         band3(ily %in% 1:4, , ))
  exp_eq(and3s(ilz %in% 1:4, , ),
         band3(ilz %in% 1:4, , ))
  exp_eq(and3s(ima %in% 1:4, , ),
         band3(ima %in% 1:4, , ))
  exp_eq(and3s(imb %in% 1:4, , h >= 0L),
         band3(imb %in% 1:4, , h >= 0L))
  exp_eq(and3s(imc %in% 1:4, , r >= 1L),
         band3(imc %in% 1:4, , r >= 1L))
  exp_eq(and3s(imd %in% 1:4, , i >= 9L),
         band3(imd %in% 1:4, , i >= 9L))
  exp_eq(and3s(ime %in% 1:4, v != 0L, ),
         band3(ime %in% 1:4, v != 0L, ))
  exp_eq(and3s(imf %in% 1:4, n != 1L, ),
         band3(imf %in% 1:4, n != 1L, ))
  exp_eq(and3s(img %in% 1:4, f != 9L, ),
         band3(img %in% 1:4, f != 9L, ))
  exp_eq(and3s(imh %in% 1:4, e != 0L, z >= 0L),
         band3(imh %in% 1:4, e != 0L, z >= 0L))
  exp_eq(and3s(imi %in% 1:4, w != 1L, u >= 1L),
         band3(imi %in% 1:4, w != 1L, u >= 1L))
  exp_eq(and3s(imj %in% 1:4, i != 9L, e >= 9L),
         band3(imj %in% 1:4, i != 9L, e >= 9L))
  exp_eq(and3s(imk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(imk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iml %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iml %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(imm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(imm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(imn %in% c(4L, -3L, 2L, 7L, 8L), , logi_z),
         band3(imn %in% c(4L, -3L, 2L, 7L, 8L), , logi_z))
  exp_eq(and3s(imo %in% c(4L, -3L, 2L, 7L, 8L), , logi_l),
         band3(imo %in% c(4L, -3L, 2L, 7L, 8L), , logi_l))
  exp_eq(and3s(imp %in% c(4L, -3L, 2L, 7L, 8L), , logi_p),
         band3(imp %in% c(4L, -3L, 2L, 7L, 8L), , logi_p))
  exp_eq(and3s(imq %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), ),
         band3(imq %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), ))
  exp_eq(and3s(imr %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L), ),
         band3(imr %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L), ))
  exp_eq(and3s(ims %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L), ),
         band3(ims %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L), ))
  exp_eq(and3s(imt %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), logi_g),
         band3(imt %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), logi_g))
  exp_eq(and3s(imu %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L), logi_t),
         band3(imu %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L), logi_t))
  exp_eq(and3s(imv %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L), logi_e),
         band3(imv %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L), logi_e))
  exp_eq(and3s(imw %in% 1:4, , ),
         band3(imw %in% 1:4, , ))
  exp_eq(and3s(imx %in% 1:4, , ),
         band3(imx %in% 1:4, , ))
  exp_eq(and3s(imy %in% 1:4, , ),
         band3(imy %in% 1:4, , ))
  exp_eq(and3s(imz %in% 1:4, , logi_y),
         band3(imz %in% 1:4, , logi_y))
  exp_eq(and3s(ina %in% 1:4, , logi_u),
         band3(ina %in% 1:4, , logi_u))
  exp_eq(and3s(inb %in% 1:4, , logi_y),
         band3(inb %in% 1:4, , logi_y))
  exp_eq(and3s(inc %in% 1:4, u %between% c(-1L, 1L), ),
         band3(inc %in% 1:4, u %between% c(-1L, 1L), ))
  exp_eq(and3s(ind %in% 1:4, n %between% c(-1L, 1L), ),
         band3(ind %in% 1:4, n %between% c(-1L, 1L), ))
  exp_eq(and3s(ine %in% 1:4, j %between% c(-1L, 1L), ),
         band3(ine %in% 1:4, j %between% c(-1L, 1L), ))
  exp_eq(and3s(inf %in% 1:4, p %between% c(-1L, 1L), logi_v),
         band3(inf %in% 1:4, p %between% c(-1L, 1L), logi_v))
  exp_eq(and3s(ing %in% 1:4, w %between% c(-1L, 1L), logi_f),
         band3(ing %in% 1:4, w %between% c(-1L, 1L), logi_f))
  exp_eq(and3s(inh %in% 1:4, q %between% c(-1L, 1L), logi_k),
         band3(inh %in% 1:4, q %between% c(-1L, 1L), logi_k))
  exp_eq(and3s(ini %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ini %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(inj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(inj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ink %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ink %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(inl %in% c(4L, -3L, 2L, 7L, 8L), , !logi_w),
         band3(inl %in% c(4L, -3L, 2L, 7L, 8L), , !logi_w))
  exp_eq(and3s(inm %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t),
         band3(inm %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t))
  exp_eq(and3s(inn %in% c(4L, -3L, 2L, 7L, 8L), , !logi_k),
         band3(inn %in% c(4L, -3L, 2L, 7L, 8L), , !logi_k))
  exp_eq(and3s(ino %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L), ),
         band3(ino %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L), ))
  exp_eq(and3s(inp %in% c(4L, -3L, 2L, 7L, 8L), c %between% c(-1L, 1L), ),
         band3(inp %in% c(4L, -3L, 2L, 7L, 8L), c %between% c(-1L, 1L), ))
  exp_eq(and3s(inq %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L), ),
         band3(inq %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L), ))
  exp_eq(and3s(inr %in% c(4L, -3L, 2L, 7L, 8L), h %between% c(-1L, 1L), !logi_x),
         band3(inr %in% c(4L, -3L, 2L, 7L, 8L), h %between% c(-1L, 1L), !logi_x))
  exp_eq(and3s(ins %in% c(4L, -3L, 2L, 7L, 8L), m %between% c(-1L, 1L), !logi_n),
         band3(ins %in% c(4L, -3L, 2L, 7L, 8L), m %between% c(-1L, 1L), !logi_n))
  exp_eq(and3s(int %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), !logi_w),
         band3(int %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), !logi_w))
  exp_eq(and3s(inu %in% 1:4, , ),
         band3(inu %in% 1:4, , ))
  exp_eq(and3s(inv %in% 1:4, , ),
         band3(inv %in% 1:4, , ))
  exp_eq(and3s(inw %in% 1:4, , ),
         band3(inw %in% 1:4, , ))
  exp_eq(and3s(inx %in% 1:4, , !logi_n),
         band3(inx %in% 1:4, , !logi_n))
  exp_eq(and3s(iny %in% 1:4, , !logi_b),
         band3(iny %in% 1:4, , !logi_b))
  exp_eq(and3s(inz %in% 1:4, , !logi_d),
         band3(inz %in% 1:4, , !logi_d))
  exp_eq(and3s(ioa %in% 1:4, g %between% c(-1L, 1L), ),
         band3(ioa %in% 1:4, g %between% c(-1L, 1L), ))
  exp_eq(and3s(iob %in% 1:4, u %between% c(-1L, 1L), ),
         band3(iob %in% 1:4, u %between% c(-1L, 1L), ))
  exp_eq(and3s(ioc %in% 1:4, g %between% c(-1L, 1L), ),
         band3(ioc %in% 1:4, g %between% c(-1L, 1L), ))
  exp_eq(and3s(iod %in% 1:4, n %between% c(-1L, 1L), !logi_b),
         band3(iod %in% 1:4, n %between% c(-1L, 1L), !logi_b))
  exp_eq(and3s(ioe %in% 1:4, s %between% c(-1L, 1L), !logi_s),
         band3(ioe %in% 1:4, s %between% c(-1L, 1L), !logi_s))
  exp_eq(and3s(iof %in% 1:4, o %between% c(-1L, 1L), !logi_p),
         band3(iof %in% 1:4, o %between% c(-1L, 1L), !logi_p))
  exp_eq(and3s(iog %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iog %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ioh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ioh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ioi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ioi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ioj %in% c(4L, -3L, 2L, 7L, 8L), , d != 0L),
         band3(ioj %in% c(4L, -3L, 2L, 7L, 8L), , d != 0L))
  exp_eq(and3s(iok %in% c(4L, -3L, 2L, 7L, 8L), , j != 1L),
         band3(iok %in% c(4L, -3L, 2L, 7L, 8L), , j != 1L))
  exp_eq(and3s(iol %in% c(4L, -3L, 2L, 7L, 8L), , i != 9L),
         band3(iol %in% c(4L, -3L, 2L, 7L, 8L), , i != 9L))
  exp_eq(and3s(iom %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L), ),
         band3(iom %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L), ))
  exp_eq(and3s(ion %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), ),
         band3(ion %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), ))
  exp_eq(and3s(ioo %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L), ),
         band3(ioo %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L), ))
  exp_eq(and3s(iop %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), h != 0L),
         band3(iop %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), h != 0L))
  exp_eq(and3s(ioq %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), y != 1L),
         band3(ioq %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), y != 1L))
  exp_eq(and3s(ior %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L), a != 9L),
         band3(ior %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L), a != 9L))
  exp_eq(and3s(ios %in% 1:4, , ),
         band3(ios %in% 1:4, , ))
  exp_eq(and3s(iot %in% 1:4, , ),
         band3(iot %in% 1:4, , ))
  exp_eq(and3s(iou %in% 1:4, , ),
         band3(iou %in% 1:4, , ))
  exp_eq(and3s(iov %in% 1:4, , q != 0L),
         band3(iov %in% 1:4, , q != 0L))
  exp_eq(and3s(iow %in% 1:4, , w != 1L),
         band3(iow %in% 1:4, , w != 1L))
  exp_eq(and3s(iox %in% 1:4, , l != 9L),
         band3(iox %in% 1:4, , l != 9L))
  exp_eq(and3s(ioy %in% 1:4, n %between% c(-1L, 1L), ),
         band3(ioy %in% 1:4, n %between% c(-1L, 1L), ))
  exp_eq(and3s(ioz %in% 1:4, t %between% c(-1L, 1L), ),
         band3(ioz %in% 1:4, t %between% c(-1L, 1L), ))
  exp_eq(and3s(ipa %in% 1:4, l %between% c(-1L, 1L), ),
         band3(ipa %in% 1:4, l %between% c(-1L, 1L), ))
  exp_eq(and3s(ipb %in% 1:4, j %between% c(-1L, 1L), g != 0L),
         band3(ipb %in% 1:4, j %between% c(-1L, 1L), g != 0L))
  exp_eq(and3s(ipc %in% 1:4, j %between% c(-1L, 1L), k != 1L),
         band3(ipc %in% 1:4, j %between% c(-1L, 1L), k != 1L))
  exp_eq(and3s(ipd %in% 1:4, g %between% c(-1L, 1L), b != 9L),
         band3(ipd %in% 1:4, g %between% c(-1L, 1L), b != 9L))
  exp_eq(and3s(ipe %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ipe %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ipf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ipf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ipg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ipg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iph %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)),
         band3(iph %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)))
  exp_eq(and3s(ipi %in% c(4L, -3L, 2L, 7L, 8L), , w %between% c(-1L, 1L)),
         band3(ipi %in% c(4L, -3L, 2L, 7L, 8L), , w %between% c(-1L, 1L)))
  exp_eq(and3s(ipj %in% c(4L, -3L, 2L, 7L, 8L), , j %between% c(-1L, 1L)),
         band3(ipj %in% c(4L, -3L, 2L, 7L, 8L), , j %between% c(-1L, 1L)))
  exp_eq(and3s(ipk %in% c(4L, -3L, 2L, 7L, 8L), f %between% c(-1L, 1L), ),
         band3(ipk %in% c(4L, -3L, 2L, 7L, 8L), f %between% c(-1L, 1L), ))
  exp_eq(and3s(ipl %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L), ),
         band3(ipl %in% c(4L, -3L, 2L, 7L, 8L), s %between% c(-1L, 1L), ))
  exp_eq(and3s(ipm %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), ),
         band3(ipm %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), ))
  exp_eq(and3s(ipn %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), p %between% c(-1L, 1L)),
         band3(ipn %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), p %between% c(-1L, 1L)))
  exp_eq(and3s(ipo %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L), y %between% c(-1L, 1L)),
         band3(ipo %in% c(4L, -3L, 2L, 7L, 8L), w %between% c(-1L, 1L), y %between% c(-1L, 1L)))
  exp_eq(and3s(ipp %in% c(4L, -3L, 2L, 7L, 8L), i %between% c(-1L, 1L), t %between% c(-1L, 1L)),
         band3(ipp %in% c(4L, -3L, 2L, 7L, 8L), i %between% c(-1L, 1L), t %between% c(-1L, 1L)))
  exp_eq(and3s(ipq %in% 1:4, , ),
         band3(ipq %in% 1:4, , ))
  exp_eq(and3s(ipr %in% 1:4, , ),
         band3(ipr %in% 1:4, , ))
  exp_eq(and3s(ips %in% 1:4, , ),
         band3(ips %in% 1:4, , ))
  exp_eq(and3s(ipt %in% 1:4, , f %between% c(-1L, 1L)),
         band3(ipt %in% 1:4, , f %between% c(-1L, 1L)))
  exp_eq(and3s(ipu %in% 1:4, , u %between% c(-1L, 1L)),
         band3(ipu %in% 1:4, , u %between% c(-1L, 1L)))
  exp_eq(and3s(ipv %in% 1:4, , l %between% c(-1L, 1L)),
         band3(ipv %in% 1:4, , l %between% c(-1L, 1L)))
  exp_eq(and3s(ipw %in% 1:4, k %between% c(-1L, 1L), ),
         band3(ipw %in% 1:4, k %between% c(-1L, 1L), ))
  exp_eq(and3s(ipx %in% 1:4, v %between% c(-1L, 1L), ),
         band3(ipx %in% 1:4, v %between% c(-1L, 1L), ))
  exp_eq(and3s(ipy %in% 1:4, p %between% c(-1L, 1L), ),
         band3(ipy %in% 1:4, p %between% c(-1L, 1L), ))
  exp_eq(and3s(ipz %in% 1:4, d %between% c(-1L, 1L), a %between% c(-1L, 1L)),
         band3(ipz %in% 1:4, d %between% c(-1L, 1L), a %between% c(-1L, 1L)))
  exp_eq(and3s(iqa %in% 1:4, v %between% c(-1L, 1L), b %between% c(-1L, 1L)),
         band3(iqa %in% 1:4, v %between% c(-1L, 1L), b %between% c(-1L, 1L)))
  exp_eq(and3s(iqb %in% 1:4, m %between% c(-1L, 1L), r %between% c(-1L, 1L)),
         band3(iqb %in% 1:4, m %between% c(-1L, 1L), r %between% c(-1L, 1L)))
  exp_eq(and3s(iqc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iqc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iqd %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iqd %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iqe %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iqe %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iqf %in% c(4L, -3L, 2L, 7L, 8L), , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iqf %in% c(4L, -3L, 2L, 7L, 8L), , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqg %in% c(4L, -3L, 2L, 7L, 8L), , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iqg %in% c(4L, -3L, 2L, 7L, 8L), , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqh %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iqh %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqi %in% c(4L, -3L, 2L, 7L, 8L), d %between% c(-1L, 1L), ),
         band3(iqi %in% c(4L, -3L, 2L, 7L, 8L), d %between% c(-1L, 1L), ))
  exp_eq(and3s(iqj %in% c(4L, -3L, 2L, 7L, 8L), d %between% c(-1L, 1L), ),
         band3(iqj %in% c(4L, -3L, 2L, 7L, 8L), d %between% c(-1L, 1L), ))
  exp_eq(and3s(iqk %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L), ),
         band3(iqk %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L), ))
  exp_eq(and3s(iql %in% c(4L, -3L, 2L, 7L, 8L), f %between% c(-1L, 1L), u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iql %in% c(4L, -3L, 2L, 7L, 8L), f %between% c(-1L, 1L), u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqm %in% c(4L, -3L, 2L, 7L, 8L), o %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iqm %in% c(4L, -3L, 2L, 7L, 8L), o %between% c(-1L, 1L), s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqn %in% c(4L, -3L, 2L, 7L, 8L), z %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(iqn %in% c(4L, -3L, 2L, 7L, 8L), z %between% c(-1L, 1L), k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(iqo %in% 1:4, , ),
         band3(iqo %in% 1:4, , ))
  exp_eq(and3s(iqp %in% 1:4, , ),
         band3(iqp %in% 1:4, , ))
  exp_eq(and3s(iqq %in% 1:4, , ),
         band3(iqq %in% 1:4, , ))
  exp_eq(and3s(iqr %in% 1:4, , o %in% 1:4),
         band3(iqr %in% 1:4, , o %in% 1:4))
  exp_eq(and3s(iqs %in% 1:4, , o %in% 1:4),
         band3(iqs %in% 1:4, , o %in% 1:4))
  exp_eq(and3s(iqt %in% 1:4, , p %in% 1:4),
         band3(iqt %in% 1:4, , p %in% 1:4))
  exp_eq(and3s(iqu %in% 1:4, j %between% c(-1L, 1L), ),
         band3(iqu %in% 1:4, j %between% c(-1L, 1L), ))
  exp_eq(and3s(iqv %in% 1:4, s %between% c(-1L, 1L), ),
         band3(iqv %in% 1:4, s %between% c(-1L, 1L), ))
  exp_eq(and3s(iqw %in% 1:4, d %between% c(-1L, 1L), ),
         band3(iqw %in% 1:4, d %between% c(-1L, 1L), ))
  exp_eq(and3s(iqx %in% 1:4, x %between% c(-1L, 1L), x %in% 1:4),
         band3(iqx %in% 1:4, x %between% c(-1L, 1L), x %in% 1:4))
  exp_eq(and3s(iqy %in% 1:4, c %between% c(-1L, 1L), h %in% 1:4),
         band3(iqy %in% 1:4, c %between% c(-1L, 1L), h %in% 1:4))
  exp_eq(and3s(iqz %in% 1:4, m %between% c(-1L, 1L), l %in% 1:4),
         band3(iqz %in% 1:4, m %between% c(-1L, 1L), l %in% 1:4))
  exp_eq(and3s(ira %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ira %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(irb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(irb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(irc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(irc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ird %in% c(4L, -3L, 2L, 7L, 8L), , o < 0L),
         band3(ird %in% c(4L, -3L, 2L, 7L, 8L), , o < 0L))
  exp_eq(and3s(ire %in% c(4L, -3L, 2L, 7L, 8L), , d < 1L),
         band3(ire %in% c(4L, -3L, 2L, 7L, 8L), , d < 1L))
  exp_eq(and3s(irf %in% c(4L, -3L, 2L, 7L, 8L), , y < 9L),
         band3(irf %in% c(4L, -3L, 2L, 7L, 8L), , y < 9L))
  exp_eq(and3s(irg %in% c(4L, -3L, 2L, 7L, 8L), z %between% c(-1L, 1L), ),
         band3(irg %in% c(4L, -3L, 2L, 7L, 8L), z %between% c(-1L, 1L), ))
  exp_eq(and3s(irh %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L), ),
         band3(irh %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L), ))
  exp_eq(and3s(iri %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ),
         band3(iri %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ))
  exp_eq(and3s(irj %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), q < 0L),
         band3(irj %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), q < 0L))
  exp_eq(and3s(irk %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), i < 1L),
         band3(irk %in% c(4L, -3L, 2L, 7L, 8L), q %between% c(-1L, 1L), i < 1L))
  exp_eq(and3s(irl %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), k < 9L),
         band3(irl %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), k < 9L))
  exp_eq(and3s(irm %in% 1:4, , ),
         band3(irm %in% 1:4, , ))
  exp_eq(and3s(irn %in% 1:4, , ),
         band3(irn %in% 1:4, , ))
  exp_eq(and3s(iro %in% 1:4, , ),
         band3(iro %in% 1:4, , ))
  exp_eq(and3s(irp %in% 1:4, , h < 0L),
         band3(irp %in% 1:4, , h < 0L))
  exp_eq(and3s(irq %in% 1:4, , p < 1L),
         band3(irq %in% 1:4, , p < 1L))
  exp_eq(and3s(irr %in% 1:4, , n < 9L),
         band3(irr %in% 1:4, , n < 9L))
  exp_eq(and3s(irs %in% 1:4, y %between% c(-1L, 1L), ),
         band3(irs %in% 1:4, y %between% c(-1L, 1L), ))
  exp_eq(and3s(irt %in% 1:4, v %between% c(-1L, 1L), ),
         band3(irt %in% 1:4, v %between% c(-1L, 1L), ))
  exp_eq(and3s(iru %in% 1:4, j %between% c(-1L, 1L), ),
         band3(iru %in% 1:4, j %between% c(-1L, 1L), ))
  exp_eq(and3s(irv %in% 1:4, s %between% c(-1L, 1L), q < 0L),
         band3(irv %in% 1:4, s %between% c(-1L, 1L), q < 0L))
  exp_eq(and3s(irw %in% 1:4, w %between% c(-1L, 1L), f < 1L),
         band3(irw %in% 1:4, w %between% c(-1L, 1L), f < 1L))
  exp_eq(and3s(irx %in% 1:4, i %between% c(-1L, 1L), t < 9L),
         band3(irx %in% 1:4, i %between% c(-1L, 1L), t < 9L))
  exp_eq(and3s(iry %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iry %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(irz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(irz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(isa %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(isa %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(isb %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L),
         band3(isb %in% c(4L, -3L, 2L, 7L, 8L), , c <= 0L))
  exp_eq(and3s(isc %in% c(4L, -3L, 2L, 7L, 8L), , k <= 1L),
         band3(isc %in% c(4L, -3L, 2L, 7L, 8L), , k <= 1L))
  exp_eq(and3s(isd %in% c(4L, -3L, 2L, 7L, 8L), , r <= 9L),
         band3(isd %in% c(4L, -3L, 2L, 7L, 8L), , r <= 9L))
  exp_eq(and3s(ise %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ),
         band3(ise %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ))
  exp_eq(and3s(isf %in% c(4L, -3L, 2L, 7L, 8L), h %between% c(-1L, 1L), ),
         band3(isf %in% c(4L, -3L, 2L, 7L, 8L), h %between% c(-1L, 1L), ))
  exp_eq(and3s(isg %in% c(4L, -3L, 2L, 7L, 8L), c %between% c(-1L, 1L), ),
         band3(isg %in% c(4L, -3L, 2L, 7L, 8L), c %between% c(-1L, 1L), ))
  exp_eq(and3s(ish %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), i <= 0L),
         band3(ish %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), i <= 0L))
  exp_eq(and3s(isi %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), w <= 1L),
         band3(isi %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), w <= 1L))
  exp_eq(and3s(isj %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), u <= 9L),
         band3(isj %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), u <= 9L))
  exp_eq(and3s(isk %in% 1:4, , ),
         band3(isk %in% 1:4, , ))
  exp_eq(and3s(isl %in% 1:4, , ),
         band3(isl %in% 1:4, , ))
  exp_eq(and3s(ism %in% 1:4, , ),
         band3(ism %in% 1:4, , ))
  exp_eq(and3s(isn %in% 1:4, , o <= 0L),
         band3(isn %in% 1:4, , o <= 0L))
  exp_eq(and3s(iso %in% 1:4, , p <= 1L),
         band3(iso %in% 1:4, , p <= 1L))
  exp_eq(and3s(isp %in% 1:4, , m <= 9L),
         band3(isp %in% 1:4, , m <= 9L))
  exp_eq(and3s(isq %in% 1:4, l %between% c(-1L, 1L), ),
         band3(isq %in% 1:4, l %between% c(-1L, 1L), ))
  exp_eq(and3s(isr %in% 1:4, j %between% c(-1L, 1L), ),
         band3(isr %in% 1:4, j %between% c(-1L, 1L), ))
  exp_eq(and3s(iss %in% 1:4, f %between% c(-1L, 1L), ),
         band3(iss %in% 1:4, f %between% c(-1L, 1L), ))
  exp_eq(and3s(ist %in% 1:4, b %between% c(-1L, 1L), j <= 0L),
         band3(ist %in% 1:4, b %between% c(-1L, 1L), j <= 0L))
  exp_eq(and3s(isu %in% 1:4, q %between% c(-1L, 1L), k <= 1L),
         band3(isu %in% 1:4, q %between% c(-1L, 1L), k <= 1L))
  exp_eq(and3s(isv %in% 1:4, e %between% c(-1L, 1L), d <= 9L),
         band3(isv %in% 1:4, e %between% c(-1L, 1L), d <= 9L))
  exp_eq(and3s(isw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(isw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(isx %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(isx %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(isy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(isy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(isz %in% c(4L, -3L, 2L, 7L, 8L), , y == 0L),
         band3(isz %in% c(4L, -3L, 2L, 7L, 8L), , y == 0L))
  exp_eq(and3s(ita %in% c(4L, -3L, 2L, 7L, 8L), , q == 1L),
         band3(ita %in% c(4L, -3L, 2L, 7L, 8L), , q == 1L))
  exp_eq(and3s(itb %in% c(4L, -3L, 2L, 7L, 8L), , v == 9L),
         band3(itb %in% c(4L, -3L, 2L, 7L, 8L), , v == 9L))
  exp_eq(and3s(itc %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L), ),
         band3(itc %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L), ))
  exp_eq(and3s(itd %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ),
         band3(itd %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ))
  exp_eq(and3s(ite %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), ),
         band3(ite %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), ))
  exp_eq(and3s(itf %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L), m == 0L),
         band3(itf %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L), m == 0L))
  exp_eq(and3s(itg %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), e == 1L),
         band3(itg %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), e == 1L))
  exp_eq(and3s(ith %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), b == 9L),
         band3(ith %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), b == 9L))
  exp_eq(and3s(iti %in% 1:4, , ),
         band3(iti %in% 1:4, , ))
  exp_eq(and3s(itj %in% 1:4, , ),
         band3(itj %in% 1:4, , ))
  exp_eq(and3s(itk %in% 1:4, , ),
         band3(itk %in% 1:4, , ))
  exp_eq(and3s(itl %in% 1:4, , k == 0L),
         band3(itl %in% 1:4, , k == 0L))
  exp_eq(and3s(itm %in% 1:4, , k == 1L),
         band3(itm %in% 1:4, , k == 1L))
  exp_eq(and3s(itn %in% 1:4, , o == 9L),
         band3(itn %in% 1:4, , o == 9L))
  exp_eq(and3s(ito %in% 1:4, r %between% c(-1L, 1L), ),
         band3(ito %in% 1:4, r %between% c(-1L, 1L), ))
  exp_eq(and3s(itp %in% 1:4, q %between% c(-1L, 1L), ),
         band3(itp %in% 1:4, q %between% c(-1L, 1L), ))
  exp_eq(and3s(itq %in% 1:4, x %between% c(-1L, 1L), ),
         band3(itq %in% 1:4, x %between% c(-1L, 1L), ))
  exp_eq(and3s(itr %in% 1:4, j %between% c(-1L, 1L), t == 0L),
         band3(itr %in% 1:4, j %between% c(-1L, 1L), t == 0L))
  exp_eq(and3s(its %in% 1:4, k %between% c(-1L, 1L), n == 1L),
         band3(its %in% 1:4, k %between% c(-1L, 1L), n == 1L))
  exp_eq(and3s(itt %in% 1:4, r %between% c(-1L, 1L), g == 9L),
         band3(itt %in% 1:4, r %between% c(-1L, 1L), g == 9L))
  exp_eq(and3s(itu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(itu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(itv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(itv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(itw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(itw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(itx %in% c(4L, -3L, 2L, 7L, 8L), , c > 0L),
         band3(itx %in% c(4L, -3L, 2L, 7L, 8L), , c > 0L))
  exp_eq(and3s(ity %in% c(4L, -3L, 2L, 7L, 8L), , e > 1L),
         band3(ity %in% c(4L, -3L, 2L, 7L, 8L), , e > 1L))
  exp_eq(and3s(itz %in% c(4L, -3L, 2L, 7L, 8L), , p > 9L),
         band3(itz %in% c(4L, -3L, 2L, 7L, 8L), , p > 9L))
  exp_eq(and3s(iua %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L), ),
         band3(iua %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L), ))
  exp_eq(and3s(iub %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L), ),
         band3(iub %in% c(4L, -3L, 2L, 7L, 8L), x %between% c(-1L, 1L), ))
  exp_eq(and3s(iuc %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ),
         band3(iuc %in% c(4L, -3L, 2L, 7L, 8L), k %between% c(-1L, 1L), ))
  exp_eq(and3s(iud %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), b > 0L),
         band3(iud %in% c(4L, -3L, 2L, 7L, 8L), u %between% c(-1L, 1L), b > 0L))
  exp_eq(and3s(iue %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L), x > 1L),
         band3(iue %in% c(4L, -3L, 2L, 7L, 8L), p %between% c(-1L, 1L), x > 1L))
  exp_eq(and3s(iuf %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), e > 9L),
         band3(iuf %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), e > 9L))
  exp_eq(and3s(iug %in% 1:4, , ),
         band3(iug %in% 1:4, , ))
  exp_eq(and3s(iuh %in% 1:4, , ),
         band3(iuh %in% 1:4, , ))
  exp_eq(and3s(iui %in% 1:4, , ),
         band3(iui %in% 1:4, , ))
  exp_eq(and3s(iuj %in% 1:4, , s > 0L),
         band3(iuj %in% 1:4, , s > 0L))
  exp_eq(and3s(iuk %in% 1:4, , w > 1L),
         band3(iuk %in% 1:4, , w > 1L))
  exp_eq(and3s(iul %in% 1:4, , z > 9L),
         band3(iul %in% 1:4, , z > 9L))
  exp_eq(and3s(ium %in% 1:4, q %between% c(-1L, 1L), ),
         band3(ium %in% 1:4, q %between% c(-1L, 1L), ))
  exp_eq(and3s(iun %in% 1:4, o %between% c(-1L, 1L), ),
         band3(iun %in% 1:4, o %between% c(-1L, 1L), ))
  exp_eq(and3s(iuo %in% 1:4, t %between% c(-1L, 1L), ),
         band3(iuo %in% 1:4, t %between% c(-1L, 1L), ))
  exp_eq(and3s(iup %in% 1:4, j %between% c(-1L, 1L), a > 0L),
         band3(iup %in% 1:4, j %between% c(-1L, 1L), a > 0L))
  exp_eq(and3s(iuq %in% 1:4, d %between% c(-1L, 1L), i > 1L),
         band3(iuq %in% 1:4, d %between% c(-1L, 1L), i > 1L))
  exp_eq(and3s(iur %in% 1:4, x %between% c(-1L, 1L), i > 9L),
         band3(iur %in% 1:4, x %between% c(-1L, 1L), i > 9L))
  exp_eq(and3s(ius %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ius %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iut %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iut %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iuu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iuu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iuv %in% c(4L, -3L, 2L, 7L, 8L), , z >= 0L),
         band3(iuv %in% c(4L, -3L, 2L, 7L, 8L), , z >= 0L))
  exp_eq(and3s(iuw %in% c(4L, -3L, 2L, 7L, 8L), , j >= 1L),
         band3(iuw %in% c(4L, -3L, 2L, 7L, 8L), , j >= 1L))
  exp_eq(and3s(iux %in% c(4L, -3L, 2L, 7L, 8L), , l >= 9L),
         band3(iux %in% c(4L, -3L, 2L, 7L, 8L), , l >= 9L))
  exp_eq(and3s(iuy %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), ),
         band3(iuy %in% c(4L, -3L, 2L, 7L, 8L), e %between% c(-1L, 1L), ))
  exp_eq(and3s(iuz %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), ),
         band3(iuz %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L), ))
  exp_eq(and3s(iva %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), ),
         band3(iva %in% c(4L, -3L, 2L, 7L, 8L), j %between% c(-1L, 1L), ))
  exp_eq(and3s(ivb %in% c(4L, -3L, 2L, 7L, 8L), a %between% c(-1L, 1L), z >= 0L),
         band3(ivb %in% c(4L, -3L, 2L, 7L, 8L), a %between% c(-1L, 1L), z >= 0L))
  exp_eq(and3s(ivc %in% c(4L, -3L, 2L, 7L, 8L), i %between% c(-1L, 1L), c >= 1L),
         band3(ivc %in% c(4L, -3L, 2L, 7L, 8L), i %between% c(-1L, 1L), c >= 1L))
  exp_eq(and3s(ivd %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L), k >= 9L),
         band3(ivd %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L), k >= 9L))
  exp_eq(and3s(ive %in% 1:4, , ),
         band3(ive %in% 1:4, , ))
  exp_eq(and3s(ivf %in% 1:4, , ),
         band3(ivf %in% 1:4, , ))
  exp_eq(and3s(ivg %in% 1:4, , ),
         band3(ivg %in% 1:4, , ))
  exp_eq(and3s(ivh %in% 1:4, , l >= 0L),
         band3(ivh %in% 1:4, , l >= 0L))
  exp_eq(and3s(ivi %in% 1:4, , w >= 1L),
         band3(ivi %in% 1:4, , w >= 1L))
  exp_eq(and3s(ivj %in% 1:4, , e >= 9L),
         band3(ivj %in% 1:4, , e >= 9L))
  exp_eq(and3s(ivk %in% 1:4, x %between% c(-1L, 1L), ),
         band3(ivk %in% 1:4, x %between% c(-1L, 1L), ))
  exp_eq(and3s(ivl %in% 1:4, a %between% c(-1L, 1L), ),
         band3(ivl %in% 1:4, a %between% c(-1L, 1L), ))
  exp_eq(and3s(ivm %in% 1:4, a %between% c(-1L, 1L), ),
         band3(ivm %in% 1:4, a %between% c(-1L, 1L), ))
  exp_eq(and3s(ivn %in% 1:4, s %between% c(-1L, 1L), e >= 0L),
         band3(ivn %in% 1:4, s %between% c(-1L, 1L), e >= 0L))
  exp_eq(and3s(ivo %in% 1:4, r %between% c(-1L, 1L), j >= 1L),
         band3(ivo %in% 1:4, r %between% c(-1L, 1L), j >= 1L))
  exp_eq(and3s(ivp %in% 1:4, u %between% c(-1L, 1L), l >= 9L),
         band3(ivp %in% 1:4, u %between% c(-1L, 1L), l >= 9L))
  exp_eq(and3s(ivq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ivq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ivr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ivr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ivs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ivs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ivt %in% c(4L, -3L, 2L, 7L, 8L), , logi_h),
         band3(ivt %in% c(4L, -3L, 2L, 7L, 8L), , logi_h))
  exp_eq(and3s(ivu %in% c(4L, -3L, 2L, 7L, 8L), , logi_o),
         band3(ivu %in% c(4L, -3L, 2L, 7L, 8L), , logi_o))
  exp_eq(and3s(ivv %in% c(4L, -3L, 2L, 7L, 8L), , logi_q),
         band3(ivv %in% c(4L, -3L, 2L, 7L, 8L), , logi_q))
  exp_eq(and3s(ivw %in% c(4L, -3L, 2L, 7L, 8L), o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ivw %in% c(4L, -3L, 2L, 7L, 8L), o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ivx %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ivx %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ivy %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ivy %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ivz %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L), logi_l),
         band3(ivz %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L), logi_l))
  exp_eq(and3s(iwa %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), logi_i),
         band3(iwa %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), logi_i))
  exp_eq(and3s(iwb %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), logi_c),
         band3(iwb %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), logi_c))
  exp_eq(and3s(iwc %in% 1:4, , ),
         band3(iwc %in% 1:4, , ))
  exp_eq(and3s(iwd %in% 1:4, , ),
         band3(iwd %in% 1:4, , ))
  exp_eq(and3s(iwe %in% 1:4, , ),
         band3(iwe %in% 1:4, , ))
  exp_eq(and3s(iwf %in% 1:4, , logi_v),
         band3(iwf %in% 1:4, , logi_v))
  exp_eq(and3s(iwg %in% 1:4, , logi_k),
         band3(iwg %in% 1:4, , logi_k))
  exp_eq(and3s(iwh %in% 1:4, , logi_z),
         band3(iwh %in% 1:4, , logi_z))
  exp_eq(and3s(iwi %in% 1:4, v %in% 1:4, ),
         band3(iwi %in% 1:4, v %in% 1:4, ))
  exp_eq(and3s(iwj %in% 1:4, c %in% 1:4, ),
         band3(iwj %in% 1:4, c %in% 1:4, ))
  exp_eq(and3s(iwk %in% 1:4, h %in% 1:4, ),
         band3(iwk %in% 1:4, h %in% 1:4, ))
  exp_eq(and3s(iwl %in% 1:4, i %in% 1:4, logi_n),
         band3(iwl %in% 1:4, i %in% 1:4, logi_n))
  exp_eq(and3s(iwm %in% 1:4, n %in% 1:4, logi_s),
         band3(iwm %in% 1:4, n %in% 1:4, logi_s))
  exp_eq(and3s(iwn %in% 1:4, x %in% 1:4, logi_t),
         band3(iwn %in% 1:4, x %in% 1:4, logi_t))
  exp_eq(and3s(iwo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iwo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iwp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iwp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iwq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iwq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iwr %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a),
         band3(iwr %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a))
  exp_eq(and3s(iws %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t),
         band3(iws %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t))
  exp_eq(and3s(iwt %in% c(4L, -3L, 2L, 7L, 8L), , !logi_z),
         band3(iwt %in% c(4L, -3L, 2L, 7L, 8L), , !logi_z))
  exp_eq(and3s(iwu %in% c(4L, -3L, 2L, 7L, 8L), s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iwu %in% c(4L, -3L, 2L, 7L, 8L), s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iwv %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iwv %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iww %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iww %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iwx %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), !logi_k),
         band3(iwx %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), !logi_k))
  exp_eq(and3s(iwy %in% c(4L, -3L, 2L, 7L, 8L), b %in% c(4L, -3L, 2L, 7L, 8L), !logi_k),
         band3(iwy %in% c(4L, -3L, 2L, 7L, 8L), b %in% c(4L, -3L, 2L, 7L, 8L), !logi_k))
  exp_eq(and3s(iwz %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), !logi_x),
         band3(iwz %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), !logi_x))
  exp_eq(and3s(ixa %in% 1:4, , ),
         band3(ixa %in% 1:4, , ))
  exp_eq(and3s(ixb %in% 1:4, , ),
         band3(ixb %in% 1:4, , ))
  exp_eq(and3s(ixc %in% 1:4, , ),
         band3(ixc %in% 1:4, , ))
  exp_eq(and3s(ixd %in% 1:4, , !logi_r),
         band3(ixd %in% 1:4, , !logi_r))
  exp_eq(and3s(ixe %in% 1:4, , !logi_b),
         band3(ixe %in% 1:4, , !logi_b))
  exp_eq(and3s(ixf %in% 1:4, , !logi_d),
         band3(ixf %in% 1:4, , !logi_d))
  exp_eq(and3s(ixg %in% 1:4, f %in% 1:4, ),
         band3(ixg %in% 1:4, f %in% 1:4, ))
  exp_eq(and3s(ixh %in% 1:4, y %in% 1:4, ),
         band3(ixh %in% 1:4, y %in% 1:4, ))
  exp_eq(and3s(ixi %in% 1:4, q %in% 1:4, ),
         band3(ixi %in% 1:4, q %in% 1:4, ))
  exp_eq(and3s(ixj %in% 1:4, z %in% 1:4, !logi_v),
         band3(ixj %in% 1:4, z %in% 1:4, !logi_v))
  exp_eq(and3s(ixk %in% 1:4, h %in% 1:4, !logi_y),
         band3(ixk %in% 1:4, h %in% 1:4, !logi_y))
  exp_eq(and3s(ixl %in% 1:4, o %in% 1:4, !logi_q),
         band3(ixl %in% 1:4, o %in% 1:4, !logi_q))
  exp_eq(and3s(ixm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ixm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ixn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ixn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ixo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ixo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ixp %in% c(4L, -3L, 2L, 7L, 8L), , m != 0L),
         band3(ixp %in% c(4L, -3L, 2L, 7L, 8L), , m != 0L))
  exp_eq(and3s(ixq %in% c(4L, -3L, 2L, 7L, 8L), , q != 1L),
         band3(ixq %in% c(4L, -3L, 2L, 7L, 8L), , q != 1L))
  exp_eq(and3s(ixr %in% c(4L, -3L, 2L, 7L, 8L), , v != 9L),
         band3(ixr %in% c(4L, -3L, 2L, 7L, 8L), , v != 9L))
  exp_eq(and3s(ixs %in% c(4L, -3L, 2L, 7L, 8L), a %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ixs %in% c(4L, -3L, 2L, 7L, 8L), a %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ixt %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ixt %in% c(4L, -3L, 2L, 7L, 8L), p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ixu %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ixu %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ixv %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), c != 0L),
         band3(ixv %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), c != 0L))
  exp_eq(and3s(ixw %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), z != 1L),
         band3(ixw %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), z != 1L))
  exp_eq(and3s(ixx %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L), k != 9L),
         band3(ixx %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L), k != 9L))
  exp_eq(and3s(ixy %in% 1:4, , ),
         band3(ixy %in% 1:4, , ))
  exp_eq(and3s(ixz %in% 1:4, , ),
         band3(ixz %in% 1:4, , ))
  exp_eq(and3s(iya %in% 1:4, , ),
         band3(iya %in% 1:4, , ))
  exp_eq(and3s(iyb %in% 1:4, , r != 0L),
         band3(iyb %in% 1:4, , r != 0L))
  exp_eq(and3s(iyc %in% 1:4, , i != 1L),
         band3(iyc %in% 1:4, , i != 1L))
  exp_eq(and3s(iyd %in% 1:4, , r != 9L),
         band3(iyd %in% 1:4, , r != 9L))
  exp_eq(and3s(iye %in% 1:4, m %in% 1:4, ),
         band3(iye %in% 1:4, m %in% 1:4, ))
  exp_eq(and3s(iyf %in% 1:4, t %in% 1:4, ),
         band3(iyf %in% 1:4, t %in% 1:4, ))
  exp_eq(and3s(iyg %in% 1:4, u %in% 1:4, ),
         band3(iyg %in% 1:4, u %in% 1:4, ))
  exp_eq(and3s(iyh %in% 1:4, k %in% 1:4, t != 0L),
         band3(iyh %in% 1:4, k %in% 1:4, t != 0L))
  exp_eq(and3s(iyi %in% 1:4, a %in% 1:4, d != 1L),
         band3(iyi %in% 1:4, a %in% 1:4, d != 1L))
  exp_eq(and3s(iyj %in% 1:4, l %in% 1:4, o != 9L),
         band3(iyj %in% 1:4, l %in% 1:4, o != 9L))
  exp_eq(and3s(iyk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iyk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iyl %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iyl %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iym %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(iym %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(iyn %in% c(4L, -3L, 2L, 7L, 8L), , e %between% c(-1L, 1L)),
         band3(iyn %in% c(4L, -3L, 2L, 7L, 8L), , e %between% c(-1L, 1L)))
  exp_eq(and3s(iyo %in% c(4L, -3L, 2L, 7L, 8L), , o %between% c(-1L, 1L)),
         band3(iyo %in% c(4L, -3L, 2L, 7L, 8L), , o %between% c(-1L, 1L)))
  exp_eq(and3s(iyp %in% c(4L, -3L, 2L, 7L, 8L), , s %between% c(-1L, 1L)),
         band3(iyp %in% c(4L, -3L, 2L, 7L, 8L), , s %between% c(-1L, 1L)))
  exp_eq(and3s(iyq %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iyq %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iyr %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iyr %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iys %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(iys %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(iyt %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L)),
         band3(iyt %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), b %between% c(-1L, 1L)))
  exp_eq(and3s(iyu %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L)),
         band3(iyu %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), n %between% c(-1L, 1L)))
  exp_eq(and3s(iyv %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L)),
         band3(iyv %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L), g %between% c(-1L, 1L)))
  exp_eq(and3s(iyw %in% 1:4, , ),
         band3(iyw %in% 1:4, , ))
  exp_eq(and3s(iyx %in% 1:4, , ),
         band3(iyx %in% 1:4, , ))
  exp_eq(and3s(iyy %in% 1:4, , ),
         band3(iyy %in% 1:4, , ))
  exp_eq(and3s(iyz %in% 1:4, , j %between% c(-1L, 1L)),
         band3(iyz %in% 1:4, , j %between% c(-1L, 1L)))
  exp_eq(and3s(ja %in% 1:4, , f %between% c(-1L, 1L)),
         band3(ja %in% 1:4, , f %between% c(-1L, 1L)))
  exp_eq(and3s(jb %in% 1:4, , z %between% c(-1L, 1L)),
         band3(jb %in% 1:4, , z %between% c(-1L, 1L)))
  exp_eq(and3s(jc %in% 1:4, z %in% 1:4, ),
         band3(jc %in% 1:4, z %in% 1:4, ))
  exp_eq(and3s(jd %in% 1:4, h %in% 1:4, ),
         band3(jd %in% 1:4, h %in% 1:4, ))
  exp_eq(and3s(je %in% 1:4, e %in% 1:4, ),
         band3(je %in% 1:4, e %in% 1:4, ))
  exp_eq(and3s(jf %in% 1:4, k %in% 1:4, c %between% c(-1L, 1L)),
         band3(jf %in% 1:4, k %in% 1:4, c %between% c(-1L, 1L)))
  exp_eq(and3s(jg %in% 1:4, n %in% 1:4, l %between% c(-1L, 1L)),
         band3(jg %in% 1:4, n %in% 1:4, l %between% c(-1L, 1L)))
  exp_eq(and3s(jh %in% 1:4, h %in% 1:4, o %between% c(-1L, 1L)),
         band3(jh %in% 1:4, h %in% 1:4, o %between% c(-1L, 1L)))
  exp_eq(and3s(ji %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ji %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jl %in% c(4L, -3L, 2L, 7L, 8L), , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jl %in% c(4L, -3L, 2L, 7L, 8L), , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jm %in% c(4L, -3L, 2L, 7L, 8L), , y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jm %in% c(4L, -3L, 2L, 7L, 8L), , y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jn %in% c(4L, -3L, 2L, 7L, 8L), , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jn %in% c(4L, -3L, 2L, 7L, 8L), , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jo %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jo %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jp %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jp %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jq %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jq %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jr %in% c(4L, -3L, 2L, 7L, 8L), d %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jr %in% c(4L, -3L, 2L, 7L, 8L), d %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(js %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(js %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jt %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jt %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ju %in% 1:4, , ),
         band3(ju %in% 1:4, , ))
  exp_eq(and3s(jv %in% 1:4, , ),
         band3(jv %in% 1:4, , ))
  exp_eq(and3s(jw %in% 1:4, , ),
         band3(jw %in% 1:4, , ))
  exp_eq(and3s(jx %in% 1:4, , b %in% 1:4),
         band3(jx %in% 1:4, , b %in% 1:4))
  exp_eq(and3s(jy %in% 1:4, , f %in% 1:4),
         band3(jy %in% 1:4, , f %in% 1:4))
  exp_eq(and3s(jz %in% 1:4, , h %in% 1:4),
         band3(jz %in% 1:4, , h %in% 1:4))
  exp_eq(and3s(jaa %in% 1:4, a %in% 1:4, ),
         band3(jaa %in% 1:4, a %in% 1:4, ))
  exp_eq(and3s(jab %in% 1:4, e %in% 1:4, ),
         band3(jab %in% 1:4, e %in% 1:4, ))
  exp_eq(and3s(jac %in% 1:4, r %in% 1:4, ),
         band3(jac %in% 1:4, r %in% 1:4, ))
  exp_eq(and3s(jad %in% 1:4, g %in% 1:4, h %in% 1:4),
         band3(jad %in% 1:4, g %in% 1:4, h %in% 1:4))
  exp_eq(and3s(jae %in% 1:4, e %in% 1:4, k %in% 1:4),
         band3(jae %in% 1:4, e %in% 1:4, k %in% 1:4))
  exp_eq(and3s(jaf %in% 1:4, n %in% 1:4, v %in% 1:4),
         band3(jaf %in% 1:4, n %in% 1:4, v %in% 1:4))
  exp_eq(and3s(jag %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jag %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jah %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jah %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jai %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jai %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jaj %in% c(4L, -3L, 2L, 7L, 8L), , w < 0L),
         band3(jaj %in% c(4L, -3L, 2L, 7L, 8L), , w < 0L))
  exp_eq(and3s(jak %in% c(4L, -3L, 2L, 7L, 8L), , r < 1L),
         band3(jak %in% c(4L, -3L, 2L, 7L, 8L), , r < 1L))
  exp_eq(and3s(jal %in% c(4L, -3L, 2L, 7L, 8L), , p < 9L),
         band3(jal %in% c(4L, -3L, 2L, 7L, 8L), , p < 9L))
  exp_eq(and3s(jam %in% c(4L, -3L, 2L, 7L, 8L), t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jam %in% c(4L, -3L, 2L, 7L, 8L), t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jan %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jan %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jao %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jao %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jap %in% c(4L, -3L, 2L, 7L, 8L), b %in% c(4L, -3L, 2L, 7L, 8L), j < 0L),
         band3(jap %in% c(4L, -3L, 2L, 7L, 8L), b %in% c(4L, -3L, 2L, 7L, 8L), j < 0L))
  exp_eq(and3s(jaq %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), u < 1L),
         band3(jaq %in% c(4L, -3L, 2L, 7L, 8L), e %in% c(4L, -3L, 2L, 7L, 8L), u < 1L))
  exp_eq(and3s(jar %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), z < 9L),
         band3(jar %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), z < 9L))
  exp_eq(and3s(jas %in% 1:4, , ),
         band3(jas %in% 1:4, , ))
  exp_eq(and3s(jat %in% 1:4, , ),
         band3(jat %in% 1:4, , ))
  exp_eq(and3s(jau %in% 1:4, , ),
         band3(jau %in% 1:4, , ))
  exp_eq(and3s(jav %in% 1:4, , h < 0L),
         band3(jav %in% 1:4, , h < 0L))
  exp_eq(and3s(jaw %in% 1:4, , l < 1L),
         band3(jaw %in% 1:4, , l < 1L))
  exp_eq(and3s(jax %in% 1:4, , n < 9L),
         band3(jax %in% 1:4, , n < 9L))
  exp_eq(and3s(jay %in% 1:4, m %in% 1:4, ),
         band3(jay %in% 1:4, m %in% 1:4, ))
  exp_eq(and3s(jaz %in% 1:4, a %in% 1:4, ),
         band3(jaz %in% 1:4, a %in% 1:4, ))
  exp_eq(and3s(jba %in% 1:4, p %in% 1:4, ),
         band3(jba %in% 1:4, p %in% 1:4, ))
  exp_eq(and3s(jbb %in% 1:4, c %in% 1:4, w < 0L),
         band3(jbb %in% 1:4, c %in% 1:4, w < 0L))
  exp_eq(and3s(jbc %in% 1:4, v %in% 1:4, l < 1L),
         band3(jbc %in% 1:4, v %in% 1:4, l < 1L))
  exp_eq(and3s(jbd %in% 1:4, i %in% 1:4, a < 9L),
         band3(jbd %in% 1:4, i %in% 1:4, a < 9L))
  exp_eq(and3s(jbe %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jbe %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jbf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jbf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jbg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jbg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jbh %in% c(4L, -3L, 2L, 7L, 8L), , d <= 0L),
         band3(jbh %in% c(4L, -3L, 2L, 7L, 8L), , d <= 0L))
  exp_eq(and3s(jbi %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L),
         band3(jbi %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L))
  exp_eq(and3s(jbj %in% c(4L, -3L, 2L, 7L, 8L), , n <= 9L),
         band3(jbj %in% c(4L, -3L, 2L, 7L, 8L), , n <= 9L))
  exp_eq(and3s(jbk %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jbk %in% c(4L, -3L, 2L, 7L, 8L), x %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jbl %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jbl %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jbm %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jbm %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jbn %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L),
         band3(jbn %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L))
  exp_eq(and3s(jbo %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L),
         band3(jbo %in% c(4L, -3L, 2L, 7L, 8L), c %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L))
  exp_eq(and3s(jbp %in% c(4L, -3L, 2L, 7L, 8L), k %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L),
         band3(jbp %in% c(4L, -3L, 2L, 7L, 8L), k %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L))
  exp_eq(and3s(jbq %in% 1:4, , ),
         band3(jbq %in% 1:4, , ))
  exp_eq(and3s(jbr %in% 1:4, , ),
         band3(jbr %in% 1:4, , ))
  exp_eq(and3s(jbs %in% 1:4, , ),
         band3(jbs %in% 1:4, , ))
  exp_eq(and3s(jbt %in% 1:4, , k <= 0L),
         band3(jbt %in% 1:4, , k <= 0L))
  exp_eq(and3s(jbu %in% 1:4, , w <= 1L),
         band3(jbu %in% 1:4, , w <= 1L))
  exp_eq(and3s(jbv %in% 1:4, , f <= 9L),
         band3(jbv %in% 1:4, , f <= 9L))
  exp_eq(and3s(jbw %in% 1:4, x %in% 1:4, ),
         band3(jbw %in% 1:4, x %in% 1:4, ))
  exp_eq(and3s(jbx %in% 1:4, k %in% 1:4, ),
         band3(jbx %in% 1:4, k %in% 1:4, ))
  exp_eq(and3s(jby %in% 1:4, n %in% 1:4, ),
         band3(jby %in% 1:4, n %in% 1:4, ))
  exp_eq(and3s(jbz %in% 1:4, x %in% 1:4, f <= 0L),
         band3(jbz %in% 1:4, x %in% 1:4, f <= 0L))
  exp_eq(and3s(jca %in% 1:4, r %in% 1:4, h <= 1L),
         band3(jca %in% 1:4, r %in% 1:4, h <= 1L))
  exp_eq(and3s(jcb %in% 1:4, o %in% 1:4, c <= 9L),
         band3(jcb %in% 1:4, o %in% 1:4, c <= 9L))
  exp_eq(and3s(jcc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jcc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jcd %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jcd %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jce %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jce %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jcf %in% c(4L, -3L, 2L, 7L, 8L), , z == 0L),
         band3(jcf %in% c(4L, -3L, 2L, 7L, 8L), , z == 0L))
  exp_eq(and3s(jcg %in% c(4L, -3L, 2L, 7L, 8L), , o == 1L),
         band3(jcg %in% c(4L, -3L, 2L, 7L, 8L), , o == 1L))
  exp_eq(and3s(jch %in% c(4L, -3L, 2L, 7L, 8L), , f == 9L),
         band3(jch %in% c(4L, -3L, 2L, 7L, 8L), , f == 9L))
  exp_eq(and3s(jci %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jci %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jcj %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jcj %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jck %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jck %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jcl %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), s == 0L),
         band3(jcl %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L), s == 0L))
  exp_eq(and3s(jcm %in% c(4L, -3L, 2L, 7L, 8L), h %in% c(4L, -3L, 2L, 7L, 8L), l == 1L),
         band3(jcm %in% c(4L, -3L, 2L, 7L, 8L), h %in% c(4L, -3L, 2L, 7L, 8L), l == 1L))
  exp_eq(and3s(jcn %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), r == 9L),
         band3(jcn %in% c(4L, -3L, 2L, 7L, 8L), f %in% c(4L, -3L, 2L, 7L, 8L), r == 9L))
  exp_eq(and3s(jco %in% 1:4, , ),
         band3(jco %in% 1:4, , ))
  exp_eq(and3s(jcp %in% 1:4, , ),
         band3(jcp %in% 1:4, , ))
  exp_eq(and3s(jcq %in% 1:4, , ),
         band3(jcq %in% 1:4, , ))
  exp_eq(and3s(jcr %in% 1:4, , n == 0L),
         band3(jcr %in% 1:4, , n == 0L))
  exp_eq(and3s(jcs %in% 1:4, , g == 1L),
         band3(jcs %in% 1:4, , g == 1L))
  exp_eq(and3s(jct %in% 1:4, , r == 9L),
         band3(jct %in% 1:4, , r == 9L))
  exp_eq(and3s(jcu %in% 1:4, m %in% 1:4, ),
         band3(jcu %in% 1:4, m %in% 1:4, ))
  exp_eq(and3s(jcv %in% 1:4, h %in% 1:4, ),
         band3(jcv %in% 1:4, h %in% 1:4, ))
  exp_eq(and3s(jcw %in% 1:4, f %in% 1:4, ),
         band3(jcw %in% 1:4, f %in% 1:4, ))
  exp_eq(and3s(jcx %in% 1:4, c %in% 1:4, l == 0L),
         band3(jcx %in% 1:4, c %in% 1:4, l == 0L))
  exp_eq(and3s(jcy %in% 1:4, s %in% 1:4, e == 1L),
         band3(jcy %in% 1:4, s %in% 1:4, e == 1L))
  exp_eq(and3s(jcz %in% 1:4, f %in% 1:4, p == 9L),
         band3(jcz %in% 1:4, f %in% 1:4, p == 9L))
  exp_eq(and3s(jda %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jda %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jdb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jdb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jdc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jdc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jdd %in% c(4L, -3L, 2L, 7L, 8L), , x > 0L),
         band3(jdd %in% c(4L, -3L, 2L, 7L, 8L), , x > 0L))
  exp_eq(and3s(jde %in% c(4L, -3L, 2L, 7L, 8L), , g > 1L),
         band3(jde %in% c(4L, -3L, 2L, 7L, 8L), , g > 1L))
  exp_eq(and3s(jdf %in% c(4L, -3L, 2L, 7L, 8L), , u > 9L),
         band3(jdf %in% c(4L, -3L, 2L, 7L, 8L), , u > 9L))
  exp_eq(and3s(jdg %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jdg %in% c(4L, -3L, 2L, 7L, 8L), v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jdh %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jdh %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jdi %in% c(4L, -3L, 2L, 7L, 8L), k %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jdi %in% c(4L, -3L, 2L, 7L, 8L), k %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jdj %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), x > 0L),
         band3(jdj %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), x > 0L))
  exp_eq(and3s(jdk %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), m > 1L),
         band3(jdk %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), m > 1L))
  exp_eq(and3s(jdl %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), o > 9L),
         band3(jdl %in% c(4L, -3L, 2L, 7L, 8L), z %in% c(4L, -3L, 2L, 7L, 8L), o > 9L))
  exp_eq(and3s(jdm %in% 1:4, , ),
         band3(jdm %in% 1:4, , ))
  exp_eq(and3s(jdn %in% 1:4, , ),
         band3(jdn %in% 1:4, , ))
  exp_eq(and3s(jdo %in% 1:4, , ),
         band3(jdo %in% 1:4, , ))
  exp_eq(and3s(jdp %in% 1:4, , n > 0L),
         band3(jdp %in% 1:4, , n > 0L))
  exp_eq(and3s(jdq %in% 1:4, , k > 1L),
         band3(jdq %in% 1:4, , k > 1L))
  exp_eq(and3s(jdr %in% 1:4, , c > 9L),
         band3(jdr %in% 1:4, , c > 9L))
  exp_eq(and3s(jds %in% 1:4, p %in% 1:4, ),
         band3(jds %in% 1:4, p %in% 1:4, ))
  exp_eq(and3s(jdt %in% 1:4, b %in% 1:4, ),
         band3(jdt %in% 1:4, b %in% 1:4, ))
  exp_eq(and3s(jdu %in% 1:4, n %in% 1:4, ),
         band3(jdu %in% 1:4, n %in% 1:4, ))
  exp_eq(and3s(jdv %in% 1:4, t %in% 1:4, d > 0L),
         band3(jdv %in% 1:4, t %in% 1:4, d > 0L))
  exp_eq(and3s(jdw %in% 1:4, h %in% 1:4, r > 1L),
         band3(jdw %in% 1:4, h %in% 1:4, r > 1L))
  exp_eq(and3s(jdx %in% 1:4, u %in% 1:4, t > 9L),
         band3(jdx %in% 1:4, u %in% 1:4, t > 9L))
  exp_eq(and3s(jdy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jdy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jdz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jdz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jea %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jea %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jeb %in% c(4L, -3L, 2L, 7L, 8L), , d >= 0L),
         band3(jeb %in% c(4L, -3L, 2L, 7L, 8L), , d >= 0L))
  exp_eq(and3s(jec %in% c(4L, -3L, 2L, 7L, 8L), , i >= 1L),
         band3(jec %in% c(4L, -3L, 2L, 7L, 8L), , i >= 1L))
  exp_eq(and3s(jed %in% c(4L, -3L, 2L, 7L, 8L), , x >= 9L),
         band3(jed %in% c(4L, -3L, 2L, 7L, 8L), , x >= 9L))
  exp_eq(and3s(jee %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jee %in% c(4L, -3L, 2L, 7L, 8L), w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jef %in% c(4L, -3L, 2L, 7L, 8L), d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jef %in% c(4L, -3L, 2L, 7L, 8L), d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jeg %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(jeg %in% c(4L, -3L, 2L, 7L, 8L), q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(jeh %in% c(4L, -3L, 2L, 7L, 8L), o %in% c(4L, -3L, 2L, 7L, 8L), p >= 0L),
         band3(jeh %in% c(4L, -3L, 2L, 7L, 8L), o %in% c(4L, -3L, 2L, 7L, 8L), p >= 0L))
  exp_eq(and3s(jei %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), b >= 1L),
         band3(jei %in% c(4L, -3L, 2L, 7L, 8L), i %in% c(4L, -3L, 2L, 7L, 8L), b >= 1L))
  exp_eq(and3s(jej %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L),
         band3(jej %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L))
  exp_eq(and3s(jek %in% 1:4, , ),
         band3(jek %in% 1:4, , ))
  exp_eq(and3s(jel %in% 1:4, , ),
         band3(jel %in% 1:4, , ))
  exp_eq(and3s(jem %in% 1:4, , ),
         band3(jem %in% 1:4, , ))
  exp_eq(and3s(jen %in% 1:4, , c >= 0L),
         band3(jen %in% 1:4, , c >= 0L))
  exp_eq(and3s(jeo %in% 1:4, , f >= 1L),
         band3(jeo %in% 1:4, , f >= 1L))
  exp_eq(and3s(jep %in% 1:4, , r >= 9L),
         band3(jep %in% 1:4, , r >= 9L))
  exp_eq(and3s(jeq %in% 1:4, l %in% 1:4, ),
         band3(jeq %in% 1:4, l %in% 1:4, ))
  exp_eq(and3s(jer %in% 1:4, l %in% 1:4, ),
         band3(jer %in% 1:4, l %in% 1:4, ))
  exp_eq(and3s(jes %in% 1:4, f %in% 1:4, ),
         band3(jes %in% 1:4, f %in% 1:4, ))
  exp_eq(and3s(jet %in% 1:4, x %in% 1:4, l >= 0L),
         band3(jet %in% 1:4, x %in% 1:4, l >= 0L))
  exp_eq(and3s(jeu %in% 1:4, r %in% 1:4, k >= 1L),
         band3(jeu %in% 1:4, r %in% 1:4, k >= 1L))
  exp_eq(and3s(jev %in% 1:4, i %in% 1:4, f >= 9L),
         band3(jev %in% 1:4, i %in% 1:4, f >= 9L))
  exp_eq(and3s(jew %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jew %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jex %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jex %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jey %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jey %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jez %in% c(4L, -3L, 2L, 7L, 8L), , logi_x),
         band3(jez %in% c(4L, -3L, 2L, 7L, 8L), , logi_x))
  exp_eq(and3s(jfa %in% c(4L, -3L, 2L, 7L, 8L), , logi_t),
         band3(jfa %in% c(4L, -3L, 2L, 7L, 8L), , logi_t))
  exp_eq(and3s(jfb %in% c(4L, -3L, 2L, 7L, 8L), , logi_j),
         band3(jfb %in% c(4L, -3L, 2L, 7L, 8L), , logi_j))
  exp_eq(and3s(jfc %in% c(4L, -3L, 2L, 7L, 8L), a < 0L, ),
         band3(jfc %in% c(4L, -3L, 2L, 7L, 8L), a < 0L, ))
  exp_eq(and3s(jfd %in% c(4L, -3L, 2L, 7L, 8L), g < 1L, ),
         band3(jfd %in% c(4L, -3L, 2L, 7L, 8L), g < 1L, ))
  exp_eq(and3s(jfe %in% c(4L, -3L, 2L, 7L, 8L), q < 9L, ),
         band3(jfe %in% c(4L, -3L, 2L, 7L, 8L), q < 9L, ))
  exp_eq(and3s(jff %in% c(4L, -3L, 2L, 7L, 8L), q < 0L, logi_b),
         band3(jff %in% c(4L, -3L, 2L, 7L, 8L), q < 0L, logi_b))
  exp_eq(and3s(jfg %in% c(4L, -3L, 2L, 7L, 8L), p < 1L, logi_z),
         band3(jfg %in% c(4L, -3L, 2L, 7L, 8L), p < 1L, logi_z))
  exp_eq(and3s(jfh %in% c(4L, -3L, 2L, 7L, 8L), o < 9L, logi_a),
         band3(jfh %in% c(4L, -3L, 2L, 7L, 8L), o < 9L, logi_a))
  exp_eq(and3s(jfi %in% 1:4, , ),
         band3(jfi %in% 1:4, , ))
  exp_eq(and3s(jfj %in% 1:4, , ),
         band3(jfj %in% 1:4, , ))
  exp_eq(and3s(jfk %in% 1:4, , ),
         band3(jfk %in% 1:4, , ))
  exp_eq(and3s(jfl %in% 1:4, , logi_p),
         band3(jfl %in% 1:4, , logi_p))
  exp_eq(and3s(jfm %in% 1:4, , logi_u),
         band3(jfm %in% 1:4, , logi_u))
  exp_eq(and3s(jfn %in% 1:4, , logi_n),
         band3(jfn %in% 1:4, , logi_n))
  exp_eq(and3s(jfo %in% 1:4, g < 0L, ),
         band3(jfo %in% 1:4, g < 0L, ))
  exp_eq(and3s(jfp %in% 1:4, s < 1L, ),
         band3(jfp %in% 1:4, s < 1L, ))
  exp_eq(and3s(jfq %in% 1:4, j < 9L, ),
         band3(jfq %in% 1:4, j < 9L, ))
  exp_eq(and3s(jfr %in% 1:4, a < 0L, logi_m),
         band3(jfr %in% 1:4, a < 0L, logi_m))
  exp_eq(and3s(jfs %in% 1:4, z < 1L, logi_j),
         band3(jfs %in% 1:4, z < 1L, logi_j))
  exp_eq(and3s(jft %in% 1:4, m < 9L, logi_n),
         band3(jft %in% 1:4, m < 9L, logi_n))
  exp_eq(and3s(jfu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jfu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jfv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jfv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jfw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jfw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jfx %in% c(4L, -3L, 2L, 7L, 8L), , !logi_z),
         band3(jfx %in% c(4L, -3L, 2L, 7L, 8L), , !logi_z))
  exp_eq(and3s(jfy %in% c(4L, -3L, 2L, 7L, 8L), , !logi_o),
         band3(jfy %in% c(4L, -3L, 2L, 7L, 8L), , !logi_o))
  exp_eq(and3s(jfz %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h),
         band3(jfz %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h))
  exp_eq(and3s(jga %in% c(4L, -3L, 2L, 7L, 8L), v < 0L, ),
         band3(jga %in% c(4L, -3L, 2L, 7L, 8L), v < 0L, ))
  exp_eq(and3s(jgb %in% c(4L, -3L, 2L, 7L, 8L), o < 1L, ),
         band3(jgb %in% c(4L, -3L, 2L, 7L, 8L), o < 1L, ))
  exp_eq(and3s(jgc %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, ),
         band3(jgc %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, ))
  exp_eq(and3s(jgd %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, !logi_v),
         band3(jgd %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, !logi_v))
  exp_eq(and3s(jge %in% c(4L, -3L, 2L, 7L, 8L), c < 1L, !logi_t),
         band3(jge %in% c(4L, -3L, 2L, 7L, 8L), c < 1L, !logi_t))
  exp_eq(and3s(jgf %in% c(4L, -3L, 2L, 7L, 8L), q < 9L, !logi_q),
         band3(jgf %in% c(4L, -3L, 2L, 7L, 8L), q < 9L, !logi_q))
  exp_eq(and3s(jgg %in% 1:4, , ),
         band3(jgg %in% 1:4, , ))
  exp_eq(and3s(jgh %in% 1:4, , ),
         band3(jgh %in% 1:4, , ))
  exp_eq(and3s(jgi %in% 1:4, , ),
         band3(jgi %in% 1:4, , ))
  exp_eq(and3s(jgj %in% 1:4, , !logi_y),
         band3(jgj %in% 1:4, , !logi_y))
  exp_eq(and3s(jgk %in% 1:4, , !logi_m),
         band3(jgk %in% 1:4, , !logi_m))
  exp_eq(and3s(jgl %in% 1:4, , !logi_c),
         band3(jgl %in% 1:4, , !logi_c))
  exp_eq(and3s(jgm %in% 1:4, s < 0L, ),
         band3(jgm %in% 1:4, s < 0L, ))
  exp_eq(and3s(jgn %in% 1:4, a < 1L, ),
         band3(jgn %in% 1:4, a < 1L, ))
  exp_eq(and3s(jgo %in% 1:4, k < 9L, ),
         band3(jgo %in% 1:4, k < 9L, ))
  exp_eq(and3s(jgp %in% 1:4, g < 0L, !logi_s),
         band3(jgp %in% 1:4, g < 0L, !logi_s))
  exp_eq(and3s(jgq %in% 1:4, z < 1L, !logi_t),
         band3(jgq %in% 1:4, z < 1L, !logi_t))
  exp_eq(and3s(jgr %in% 1:4, w < 9L, !logi_k),
         band3(jgr %in% 1:4, w < 9L, !logi_k))
  exp_eq(and3s(jgs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jgs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jgt %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jgt %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jgu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jgu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jgv %in% c(4L, -3L, 2L, 7L, 8L), , g != 0L),
         band3(jgv %in% c(4L, -3L, 2L, 7L, 8L), , g != 0L))
  exp_eq(and3s(jgw %in% c(4L, -3L, 2L, 7L, 8L), , u != 1L),
         band3(jgw %in% c(4L, -3L, 2L, 7L, 8L), , u != 1L))
  exp_eq(and3s(jgx %in% c(4L, -3L, 2L, 7L, 8L), , u != 9L),
         band3(jgx %in% c(4L, -3L, 2L, 7L, 8L), , u != 9L))
  exp_eq(and3s(jgy %in% c(4L, -3L, 2L, 7L, 8L), y < 0L, ),
         band3(jgy %in% c(4L, -3L, 2L, 7L, 8L), y < 0L, ))
  exp_eq(and3s(jgz %in% c(4L, -3L, 2L, 7L, 8L), b < 1L, ),
         band3(jgz %in% c(4L, -3L, 2L, 7L, 8L), b < 1L, ))
  exp_eq(and3s(jha %in% c(4L, -3L, 2L, 7L, 8L), f < 9L, ),
         band3(jha %in% c(4L, -3L, 2L, 7L, 8L), f < 9L, ))
  exp_eq(and3s(jhb %in% c(4L, -3L, 2L, 7L, 8L), y < 0L, o != 0L),
         band3(jhb %in% c(4L, -3L, 2L, 7L, 8L), y < 0L, o != 0L))
  exp_eq(and3s(jhc %in% c(4L, -3L, 2L, 7L, 8L), r < 1L, z != 1L),
         band3(jhc %in% c(4L, -3L, 2L, 7L, 8L), r < 1L, z != 1L))
  exp_eq(and3s(jhd %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, p != 9L),
         band3(jhd %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, p != 9L))
  exp_eq(and3s(jhe %in% 1:4, , ),
         band3(jhe %in% 1:4, , ))
  exp_eq(and3s(jhf %in% 1:4, , ),
         band3(jhf %in% 1:4, , ))
  exp_eq(and3s(jhg %in% 1:4, , ),
         band3(jhg %in% 1:4, , ))
  exp_eq(and3s(jhh %in% 1:4, , p != 0L),
         band3(jhh %in% 1:4, , p != 0L))
  exp_eq(and3s(jhi %in% 1:4, , o != 1L),
         band3(jhi %in% 1:4, , o != 1L))
  exp_eq(and3s(jhj %in% 1:4, , s != 9L),
         band3(jhj %in% 1:4, , s != 9L))
  exp_eq(and3s(jhk %in% 1:4, f < 0L, ),
         band3(jhk %in% 1:4, f < 0L, ))
  exp_eq(and3s(jhl %in% 1:4, h < 1L, ),
         band3(jhl %in% 1:4, h < 1L, ))
  exp_eq(and3s(jhm %in% 1:4, l < 9L, ),
         band3(jhm %in% 1:4, l < 9L, ))
  exp_eq(and3s(jhn %in% 1:4, o < 0L, i != 0L),
         band3(jhn %in% 1:4, o < 0L, i != 0L))
  exp_eq(and3s(jho %in% 1:4, p < 1L, x != 1L),
         band3(jho %in% 1:4, p < 1L, x != 1L))
  exp_eq(and3s(jhp %in% 1:4, p < 9L, e != 9L),
         band3(jhp %in% 1:4, p < 9L, e != 9L))
  exp_eq(and3s(jhq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jhq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jhr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jhr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jhs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jhs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jht %in% c(4L, -3L, 2L, 7L, 8L), , i %between% c(-1L, 1L)),
         band3(jht %in% c(4L, -3L, 2L, 7L, 8L), , i %between% c(-1L, 1L)))
  exp_eq(and3s(jhu %in% c(4L, -3L, 2L, 7L, 8L), , s %between% c(-1L, 1L)),
         band3(jhu %in% c(4L, -3L, 2L, 7L, 8L), , s %between% c(-1L, 1L)))
  exp_eq(and3s(jhv %in% c(4L, -3L, 2L, 7L, 8L), , m %between% c(-1L, 1L)),
         band3(jhv %in% c(4L, -3L, 2L, 7L, 8L), , m %between% c(-1L, 1L)))
  exp_eq(and3s(jhw %in% c(4L, -3L, 2L, 7L, 8L), f < 0L, ),
         band3(jhw %in% c(4L, -3L, 2L, 7L, 8L), f < 0L, ))
  exp_eq(and3s(jhx %in% c(4L, -3L, 2L, 7L, 8L), l < 1L, ),
         band3(jhx %in% c(4L, -3L, 2L, 7L, 8L), l < 1L, ))
  exp_eq(and3s(jhy %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, ),
         band3(jhy %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, ))
  exp_eq(and3s(jhz %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, n %between% c(-1L, 1L)),
         band3(jhz %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, n %between% c(-1L, 1L)))
  exp_eq(and3s(jia %in% c(4L, -3L, 2L, 7L, 8L), s < 1L, y %between% c(-1L, 1L)),
         band3(jia %in% c(4L, -3L, 2L, 7L, 8L), s < 1L, y %between% c(-1L, 1L)))
  exp_eq(and3s(jib %in% c(4L, -3L, 2L, 7L, 8L), k < 9L, y %between% c(-1L, 1L)),
         band3(jib %in% c(4L, -3L, 2L, 7L, 8L), k < 9L, y %between% c(-1L, 1L)))
  exp_eq(and3s(jic %in% 1:4, , ),
         band3(jic %in% 1:4, , ))
  exp_eq(and3s(jid %in% 1:4, , ),
         band3(jid %in% 1:4, , ))
  exp_eq(and3s(jie %in% 1:4, , ),
         band3(jie %in% 1:4, , ))
  exp_eq(and3s(jif %in% 1:4, , e %between% c(-1L, 1L)),
         band3(jif %in% 1:4, , e %between% c(-1L, 1L)))
  exp_eq(and3s(jig %in% 1:4, , l %between% c(-1L, 1L)),
         band3(jig %in% 1:4, , l %between% c(-1L, 1L)))
  exp_eq(and3s(jih %in% 1:4, , b %between% c(-1L, 1L)),
         band3(jih %in% 1:4, , b %between% c(-1L, 1L)))
  exp_eq(and3s(jii %in% 1:4, c < 0L, ),
         band3(jii %in% 1:4, c < 0L, ))
  exp_eq(and3s(jij %in% 1:4, y < 1L, ),
         band3(jij %in% 1:4, y < 1L, ))
  exp_eq(and3s(jik %in% 1:4, e < 9L, ),
         band3(jik %in% 1:4, e < 9L, ))
  exp_eq(and3s(jil %in% 1:4, a < 0L, x %between% c(-1L, 1L)),
         band3(jil %in% 1:4, a < 0L, x %between% c(-1L, 1L)))
  exp_eq(and3s(jim %in% 1:4, x < 1L, d %between% c(-1L, 1L)),
         band3(jim %in% 1:4, x < 1L, d %between% c(-1L, 1L)))
  exp_eq(and3s(jin %in% 1:4, x < 9L, h %between% c(-1L, 1L)),
         band3(jin %in% 1:4, x < 9L, h %between% c(-1L, 1L)))
  exp_eq(and3s(jio %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jio %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jip %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jip %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jiq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jiq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jir %in% c(4L, -3L, 2L, 7L, 8L), , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jir %in% c(4L, -3L, 2L, 7L, 8L), , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jis %in% c(4L, -3L, 2L, 7L, 8L), , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jis %in% c(4L, -3L, 2L, 7L, 8L), , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jit %in% c(4L, -3L, 2L, 7L, 8L), , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jit %in% c(4L, -3L, 2L, 7L, 8L), , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jiu %in% c(4L, -3L, 2L, 7L, 8L), k < 0L, ),
         band3(jiu %in% c(4L, -3L, 2L, 7L, 8L), k < 0L, ))
  exp_eq(and3s(jiv %in% c(4L, -3L, 2L, 7L, 8L), a < 1L, ),
         band3(jiv %in% c(4L, -3L, 2L, 7L, 8L), a < 1L, ))
  exp_eq(and3s(jiw %in% c(4L, -3L, 2L, 7L, 8L), c < 9L, ),
         band3(jiw %in% c(4L, -3L, 2L, 7L, 8L), c < 9L, ))
  exp_eq(and3s(jix %in% c(4L, -3L, 2L, 7L, 8L), d < 0L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jix %in% c(4L, -3L, 2L, 7L, 8L), d < 0L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jiy %in% c(4L, -3L, 2L, 7L, 8L), f < 1L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jiy %in% c(4L, -3L, 2L, 7L, 8L), f < 1L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jiz %in% c(4L, -3L, 2L, 7L, 8L), e < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jiz %in% c(4L, -3L, 2L, 7L, 8L), e < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jja %in% 1:4, , ),
         band3(jja %in% 1:4, , ))
  exp_eq(and3s(jjb %in% 1:4, , ),
         band3(jjb %in% 1:4, , ))
  exp_eq(and3s(jjc %in% 1:4, , ),
         band3(jjc %in% 1:4, , ))
  exp_eq(and3s(jjd %in% 1:4, , a %in% 1:4),
         band3(jjd %in% 1:4, , a %in% 1:4))
  exp_eq(and3s(jje %in% 1:4, , y %in% 1:4),
         band3(jje %in% 1:4, , y %in% 1:4))
  exp_eq(and3s(jjf %in% 1:4, , c %in% 1:4),
         band3(jjf %in% 1:4, , c %in% 1:4))
  exp_eq(and3s(jjg %in% 1:4, h < 0L, ),
         band3(jjg %in% 1:4, h < 0L, ))
  exp_eq(and3s(jjh %in% 1:4, y < 1L, ),
         band3(jjh %in% 1:4, y < 1L, ))
  exp_eq(and3s(jji %in% 1:4, e < 9L, ),
         band3(jji %in% 1:4, e < 9L, ))
  exp_eq(and3s(jjj %in% 1:4, u < 0L, e %in% 1:4),
         band3(jjj %in% 1:4, u < 0L, e %in% 1:4))
  exp_eq(and3s(jjk %in% 1:4, e < 1L, m %in% 1:4),
         band3(jjk %in% 1:4, e < 1L, m %in% 1:4))
  exp_eq(and3s(jjl %in% 1:4, b < 9L, p %in% 1:4),
         band3(jjl %in% 1:4, b < 9L, p %in% 1:4))
  exp_eq(and3s(jjm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jjm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jjn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jjn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jjo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jjo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jjp %in% c(4L, -3L, 2L, 7L, 8L), , q < 0L),
         band3(jjp %in% c(4L, -3L, 2L, 7L, 8L), , q < 0L))
  exp_eq(and3s(jjq %in% c(4L, -3L, 2L, 7L, 8L), , x < 1L),
         band3(jjq %in% c(4L, -3L, 2L, 7L, 8L), , x < 1L))
  exp_eq(and3s(jjr %in% c(4L, -3L, 2L, 7L, 8L), , n < 9L),
         band3(jjr %in% c(4L, -3L, 2L, 7L, 8L), , n < 9L))
  exp_eq(and3s(jjs %in% c(4L, -3L, 2L, 7L, 8L), j < 0L, ),
         band3(jjs %in% c(4L, -3L, 2L, 7L, 8L), j < 0L, ))
  exp_eq(and3s(jjt %in% c(4L, -3L, 2L, 7L, 8L), x < 1L, ),
         band3(jjt %in% c(4L, -3L, 2L, 7L, 8L), x < 1L, ))
  exp_eq(and3s(jju %in% c(4L, -3L, 2L, 7L, 8L), b < 9L, ),
         band3(jju %in% c(4L, -3L, 2L, 7L, 8L), b < 9L, ))
  exp_eq(and3s(jjv %in% c(4L, -3L, 2L, 7L, 8L), a < 0L, q < 0L),
         band3(jjv %in% c(4L, -3L, 2L, 7L, 8L), a < 0L, q < 0L))
  exp_eq(and3s(jjw %in% c(4L, -3L, 2L, 7L, 8L), f < 1L, s < 1L),
         band3(jjw %in% c(4L, -3L, 2L, 7L, 8L), f < 1L, s < 1L))
  exp_eq(and3s(jjx %in% c(4L, -3L, 2L, 7L, 8L), s < 9L, n < 9L),
         band3(jjx %in% c(4L, -3L, 2L, 7L, 8L), s < 9L, n < 9L))
  exp_eq(and3s(jjy %in% 1:4, , ),
         band3(jjy %in% 1:4, , ))
  exp_eq(and3s(jjz %in% 1:4, , ),
         band3(jjz %in% 1:4, , ))
  exp_eq(and3s(jka %in% 1:4, , ),
         band3(jka %in% 1:4, , ))
  exp_eq(and3s(jkb %in% 1:4, , y < 0L),
         band3(jkb %in% 1:4, , y < 0L))
  exp_eq(and3s(jkc %in% 1:4, , u < 1L),
         band3(jkc %in% 1:4, , u < 1L))
  exp_eq(and3s(jkd %in% 1:4, , l < 9L),
         band3(jkd %in% 1:4, , l < 9L))
  exp_eq(and3s(jke %in% 1:4, j < 0L, ),
         band3(jke %in% 1:4, j < 0L, ))
  exp_eq(and3s(jkf %in% 1:4, r < 1L, ),
         band3(jkf %in% 1:4, r < 1L, ))
  exp_eq(and3s(jkg %in% 1:4, n < 9L, ),
         band3(jkg %in% 1:4, n < 9L, ))
  exp_eq(and3s(jkh %in% 1:4, p < 0L, k < 0L),
         band3(jkh %in% 1:4, p < 0L, k < 0L))
  exp_eq(and3s(jki %in% 1:4, q < 1L, t < 1L),
         band3(jki %in% 1:4, q < 1L, t < 1L))
  exp_eq(and3s(jkj %in% 1:4, u < 9L, u < 9L),
         band3(jkj %in% 1:4, u < 9L, u < 9L))
  exp_eq(and3s(jkk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jkk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jkl %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jkl %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jkm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jkm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jkn %in% c(4L, -3L, 2L, 7L, 8L), , w <= 0L),
         band3(jkn %in% c(4L, -3L, 2L, 7L, 8L), , w <= 0L))
  exp_eq(and3s(jko %in% c(4L, -3L, 2L, 7L, 8L), , j <= 1L),
         band3(jko %in% c(4L, -3L, 2L, 7L, 8L), , j <= 1L))
  exp_eq(and3s(jkp %in% c(4L, -3L, 2L, 7L, 8L), , e <= 9L),
         band3(jkp %in% c(4L, -3L, 2L, 7L, 8L), , e <= 9L))
  exp_eq(and3s(jkq %in% c(4L, -3L, 2L, 7L, 8L), s < 0L, ),
         band3(jkq %in% c(4L, -3L, 2L, 7L, 8L), s < 0L, ))
  exp_eq(and3s(jkr %in% c(4L, -3L, 2L, 7L, 8L), k < 1L, ),
         band3(jkr %in% c(4L, -3L, 2L, 7L, 8L), k < 1L, ))
  exp_eq(and3s(jks %in% c(4L, -3L, 2L, 7L, 8L), v < 9L, ),
         band3(jks %in% c(4L, -3L, 2L, 7L, 8L), v < 9L, ))
  exp_eq(and3s(jkt %in% c(4L, -3L, 2L, 7L, 8L), x < 0L, t <= 0L),
         band3(jkt %in% c(4L, -3L, 2L, 7L, 8L), x < 0L, t <= 0L))
  exp_eq(and3s(jku %in% c(4L, -3L, 2L, 7L, 8L), y < 1L, z <= 1L),
         band3(jku %in% c(4L, -3L, 2L, 7L, 8L), y < 1L, z <= 1L))
  exp_eq(and3s(jkv %in% c(4L, -3L, 2L, 7L, 8L), r < 9L, h <= 9L),
         band3(jkv %in% c(4L, -3L, 2L, 7L, 8L), r < 9L, h <= 9L))
  exp_eq(and3s(jkw %in% 1:4, , ),
         band3(jkw %in% 1:4, , ))
  exp_eq(and3s(jkx %in% 1:4, , ),
         band3(jkx %in% 1:4, , ))
  exp_eq(and3s(jky %in% 1:4, , ),
         band3(jky %in% 1:4, , ))
  exp_eq(and3s(jkz %in% 1:4, , h <= 0L),
         band3(jkz %in% 1:4, , h <= 0L))
  exp_eq(and3s(jla %in% 1:4, , y <= 1L),
         band3(jla %in% 1:4, , y <= 1L))
  exp_eq(and3s(jlb %in% 1:4, , y <= 9L),
         band3(jlb %in% 1:4, , y <= 9L))
  exp_eq(and3s(jlc %in% 1:4, p < 0L, ),
         band3(jlc %in% 1:4, p < 0L, ))
  exp_eq(and3s(jld %in% 1:4, i < 1L, ),
         band3(jld %in% 1:4, i < 1L, ))
  exp_eq(and3s(jle %in% 1:4, v < 9L, ),
         band3(jle %in% 1:4, v < 9L, ))
  exp_eq(and3s(jlf %in% 1:4, l < 0L, s <= 0L),
         band3(jlf %in% 1:4, l < 0L, s <= 0L))
  exp_eq(and3s(jlg %in% 1:4, d < 1L, v <= 1L),
         band3(jlg %in% 1:4, d < 1L, v <= 1L))
  exp_eq(and3s(jlh %in% 1:4, n < 9L, z <= 9L),
         band3(jlh %in% 1:4, n < 9L, z <= 9L))
  exp_eq(and3s(jli %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jli %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jlj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jlj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jlk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jlk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jll %in% c(4L, -3L, 2L, 7L, 8L), , v == 0L),
         band3(jll %in% c(4L, -3L, 2L, 7L, 8L), , v == 0L))
  exp_eq(and3s(jlm %in% c(4L, -3L, 2L, 7L, 8L), , n == 1L),
         band3(jlm %in% c(4L, -3L, 2L, 7L, 8L), , n == 1L))
  exp_eq(and3s(jln %in% c(4L, -3L, 2L, 7L, 8L), , c == 9L),
         band3(jln %in% c(4L, -3L, 2L, 7L, 8L), , c == 9L))
  exp_eq(and3s(jlo %in% c(4L, -3L, 2L, 7L, 8L), o < 0L, ),
         band3(jlo %in% c(4L, -3L, 2L, 7L, 8L), o < 0L, ))
  exp_eq(and3s(jlp %in% c(4L, -3L, 2L, 7L, 8L), t < 1L, ),
         band3(jlp %in% c(4L, -3L, 2L, 7L, 8L), t < 1L, ))
  exp_eq(and3s(jlq %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, ),
         band3(jlq %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, ))
  exp_eq(and3s(jlr %in% c(4L, -3L, 2L, 7L, 8L), i < 0L, a == 0L),
         band3(jlr %in% c(4L, -3L, 2L, 7L, 8L), i < 0L, a == 0L))
  exp_eq(and3s(jls %in% c(4L, -3L, 2L, 7L, 8L), n < 1L, t == 1L),
         band3(jls %in% c(4L, -3L, 2L, 7L, 8L), n < 1L, t == 1L))
  exp_eq(and3s(jlt %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, n == 9L),
         band3(jlt %in% c(4L, -3L, 2L, 7L, 8L), w < 9L, n == 9L))
  exp_eq(and3s(jlu %in% 1:4, , ),
         band3(jlu %in% 1:4, , ))
  exp_eq(and3s(jlv %in% 1:4, , ),
         band3(jlv %in% 1:4, , ))
  exp_eq(and3s(jlw %in% 1:4, , ),
         band3(jlw %in% 1:4, , ))
  exp_eq(and3s(jlx %in% 1:4, , j == 0L),
         band3(jlx %in% 1:4, , j == 0L))
  exp_eq(and3s(jly %in% 1:4, , z == 1L),
         band3(jly %in% 1:4, , z == 1L))
  exp_eq(and3s(jlz %in% 1:4, , n == 9L),
         band3(jlz %in% 1:4, , n == 9L))
  exp_eq(and3s(jma %in% 1:4, l < 0L, ),
         band3(jma %in% 1:4, l < 0L, ))
  exp_eq(and3s(jmb %in% 1:4, r < 1L, ),
         band3(jmb %in% 1:4, r < 1L, ))
  exp_eq(and3s(jmc %in% 1:4, g < 9L, ),
         band3(jmc %in% 1:4, g < 9L, ))
  exp_eq(and3s(jmd %in% 1:4, z < 0L, c == 0L),
         band3(jmd %in% 1:4, z < 0L, c == 0L))
  exp_eq(and3s(jme %in% 1:4, n < 1L, s == 1L),
         band3(jme %in% 1:4, n < 1L, s == 1L))
  exp_eq(and3s(jmf %in% 1:4, a < 9L, g == 9L),
         band3(jmf %in% 1:4, a < 9L, g == 9L))
  exp_eq(and3s(jmg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jmg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jmh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jmh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jmi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jmi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jmj %in% c(4L, -3L, 2L, 7L, 8L), , o > 0L),
         band3(jmj %in% c(4L, -3L, 2L, 7L, 8L), , o > 0L))
  exp_eq(and3s(jmk %in% c(4L, -3L, 2L, 7L, 8L), , z > 1L),
         band3(jmk %in% c(4L, -3L, 2L, 7L, 8L), , z > 1L))
  exp_eq(and3s(jml %in% c(4L, -3L, 2L, 7L, 8L), , t > 9L),
         band3(jml %in% c(4L, -3L, 2L, 7L, 8L), , t > 9L))
  exp_eq(and3s(jmm %in% c(4L, -3L, 2L, 7L, 8L), w < 0L, ),
         band3(jmm %in% c(4L, -3L, 2L, 7L, 8L), w < 0L, ))
  exp_eq(and3s(jmn %in% c(4L, -3L, 2L, 7L, 8L), d < 1L, ),
         band3(jmn %in% c(4L, -3L, 2L, 7L, 8L), d < 1L, ))
  exp_eq(and3s(jmo %in% c(4L, -3L, 2L, 7L, 8L), e < 9L, ),
         band3(jmo %in% c(4L, -3L, 2L, 7L, 8L), e < 9L, ))
  exp_eq(and3s(jmp %in% c(4L, -3L, 2L, 7L, 8L), w < 0L, n > 0L),
         band3(jmp %in% c(4L, -3L, 2L, 7L, 8L), w < 0L, n > 0L))
  exp_eq(and3s(jmq %in% c(4L, -3L, 2L, 7L, 8L), a < 1L, o > 1L),
         band3(jmq %in% c(4L, -3L, 2L, 7L, 8L), a < 1L, o > 1L))
  exp_eq(and3s(jmr %in% c(4L, -3L, 2L, 7L, 8L), g < 9L, l > 9L),
         band3(jmr %in% c(4L, -3L, 2L, 7L, 8L), g < 9L, l > 9L))
  exp_eq(and3s(jms %in% 1:4, , ),
         band3(jms %in% 1:4, , ))
  exp_eq(and3s(jmt %in% 1:4, , ),
         band3(jmt %in% 1:4, , ))
  exp_eq(and3s(jmu %in% 1:4, , ),
         band3(jmu %in% 1:4, , ))
  exp_eq(and3s(jmv %in% 1:4, , e > 0L),
         band3(jmv %in% 1:4, , e > 0L))
  exp_eq(and3s(jmw %in% 1:4, , n > 1L),
         band3(jmw %in% 1:4, , n > 1L))
  exp_eq(and3s(jmx %in% 1:4, , l > 9L),
         band3(jmx %in% 1:4, , l > 9L))
  exp_eq(and3s(jmy %in% 1:4, q < 0L, ),
         band3(jmy %in% 1:4, q < 0L, ))
  exp_eq(and3s(jmz %in% 1:4, a < 1L, ),
         band3(jmz %in% 1:4, a < 1L, ))
  exp_eq(and3s(jna %in% 1:4, x < 9L, ),
         band3(jna %in% 1:4, x < 9L, ))
  exp_eq(and3s(jnb %in% 1:4, j < 0L, n > 0L),
         band3(jnb %in% 1:4, j < 0L, n > 0L))
  exp_eq(and3s(jnc %in% 1:4, x < 1L, b > 1L),
         band3(jnc %in% 1:4, x < 1L, b > 1L))
  exp_eq(and3s(jnd %in% 1:4, k < 9L, n > 9L),
         band3(jnd %in% 1:4, k < 9L, n > 9L))
  exp_eq(and3s(jne %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jne %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jnf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jnf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jng %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jng %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jnh %in% c(4L, -3L, 2L, 7L, 8L), , w >= 0L),
         band3(jnh %in% c(4L, -3L, 2L, 7L, 8L), , w >= 0L))
  exp_eq(and3s(jni %in% c(4L, -3L, 2L, 7L, 8L), , v >= 1L),
         band3(jni %in% c(4L, -3L, 2L, 7L, 8L), , v >= 1L))
  exp_eq(and3s(jnj %in% c(4L, -3L, 2L, 7L, 8L), , j >= 9L),
         band3(jnj %in% c(4L, -3L, 2L, 7L, 8L), , j >= 9L))
  exp_eq(and3s(jnk %in% c(4L, -3L, 2L, 7L, 8L), e < 0L, ),
         band3(jnk %in% c(4L, -3L, 2L, 7L, 8L), e < 0L, ))
  exp_eq(and3s(jnl %in% c(4L, -3L, 2L, 7L, 8L), j < 1L, ),
         band3(jnl %in% c(4L, -3L, 2L, 7L, 8L), j < 1L, ))
  exp_eq(and3s(jnm %in% c(4L, -3L, 2L, 7L, 8L), i < 9L, ),
         band3(jnm %in% c(4L, -3L, 2L, 7L, 8L), i < 9L, ))
  exp_eq(and3s(jnn %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, q >= 0L),
         band3(jnn %in% c(4L, -3L, 2L, 7L, 8L), p < 0L, q >= 0L))
  exp_eq(and3s(jno %in% c(4L, -3L, 2L, 7L, 8L), s < 1L, n >= 1L),
         band3(jno %in% c(4L, -3L, 2L, 7L, 8L), s < 1L, n >= 1L))
  exp_eq(and3s(jnp %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, n >= 9L),
         band3(jnp %in% c(4L, -3L, 2L, 7L, 8L), d < 9L, n >= 9L))
  exp_eq(and3s(jnq %in% 1:4, , ),
         band3(jnq %in% 1:4, , ))
  exp_eq(and3s(jnr %in% 1:4, , ),
         band3(jnr %in% 1:4, , ))
  exp_eq(and3s(jns %in% 1:4, , ),
         band3(jns %in% 1:4, , ))
  exp_eq(and3s(jnt %in% 1:4, , v >= 0L),
         band3(jnt %in% 1:4, , v >= 0L))
  exp_eq(and3s(jnu %in% 1:4, , i >= 1L),
         band3(jnu %in% 1:4, , i >= 1L))
  exp_eq(and3s(jnv %in% 1:4, , s >= 9L),
         band3(jnv %in% 1:4, , s >= 9L))
  exp_eq(and3s(jnw %in% 1:4, c < 0L, ),
         band3(jnw %in% 1:4, c < 0L, ))
  exp_eq(and3s(jnx %in% 1:4, s < 1L, ),
         band3(jnx %in% 1:4, s < 1L, ))
  exp_eq(and3s(jny %in% 1:4, x < 9L, ),
         band3(jny %in% 1:4, x < 9L, ))
  exp_eq(and3s(jnz %in% 1:4, w < 0L, o >= 0L),
         band3(jnz %in% 1:4, w < 0L, o >= 0L))
  exp_eq(and3s(joa %in% 1:4, g < 1L, r >= 1L),
         band3(joa %in% 1:4, g < 1L, r >= 1L))
  exp_eq(and3s(job %in% 1:4, o < 9L, y >= 9L),
         band3(job %in% 1:4, o < 9L, y >= 9L))
  exp_eq(and3s(joc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(joc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jod %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jod %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(joe %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(joe %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jof %in% c(4L, -3L, 2L, 7L, 8L), , logi_k),
         band3(jof %in% c(4L, -3L, 2L, 7L, 8L), , logi_k))
  exp_eq(and3s(jog %in% c(4L, -3L, 2L, 7L, 8L), , logi_s),
         band3(jog %in% c(4L, -3L, 2L, 7L, 8L), , logi_s))
  exp_eq(and3s(joh %in% c(4L, -3L, 2L, 7L, 8L), , logi_z),
         band3(joh %in% c(4L, -3L, 2L, 7L, 8L), , logi_z))
  exp_eq(and3s(joi %in% c(4L, -3L, 2L, 7L, 8L), a <= 0L, ),
         band3(joi %in% c(4L, -3L, 2L, 7L, 8L), a <= 0L, ))
  exp_eq(and3s(joj %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, ),
         band3(joj %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, ))
  exp_eq(and3s(jok %in% c(4L, -3L, 2L, 7L, 8L), y <= 9L, ),
         band3(jok %in% c(4L, -3L, 2L, 7L, 8L), y <= 9L, ))
  exp_eq(and3s(jol %in% c(4L, -3L, 2L, 7L, 8L), f <= 0L, logi_p),
         band3(jol %in% c(4L, -3L, 2L, 7L, 8L), f <= 0L, logi_p))
  exp_eq(and3s(jom %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L, logi_n),
         band3(jom %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L, logi_n))
  exp_eq(and3s(jon %in% c(4L, -3L, 2L, 7L, 8L), x <= 9L, logi_y),
         band3(jon %in% c(4L, -3L, 2L, 7L, 8L), x <= 9L, logi_y))
  exp_eq(and3s(joo %in% 1:4, , ),
         band3(joo %in% 1:4, , ))
  exp_eq(and3s(jop %in% 1:4, , ),
         band3(jop %in% 1:4, , ))
  exp_eq(and3s(joq %in% 1:4, , ),
         band3(joq %in% 1:4, , ))
  exp_eq(and3s(jor %in% 1:4, , logi_s),
         band3(jor %in% 1:4, , logi_s))
  exp_eq(and3s(jos %in% 1:4, , logi_e),
         band3(jos %in% 1:4, , logi_e))
  exp_eq(and3s(jot %in% 1:4, , logi_p),
         band3(jot %in% 1:4, , logi_p))
  exp_eq(and3s(jou %in% 1:4, s <= 0L, ),
         band3(jou %in% 1:4, s <= 0L, ))
  exp_eq(and3s(jov %in% 1:4, l <= 1L, ),
         band3(jov %in% 1:4, l <= 1L, ))
  exp_eq(and3s(jow %in% 1:4, h <= 9L, ),
         band3(jow %in% 1:4, h <= 9L, ))
  exp_eq(and3s(jox %in% 1:4, x <= 0L, logi_s),
         band3(jox %in% 1:4, x <= 0L, logi_s))
  exp_eq(and3s(joy %in% 1:4, h <= 1L, logi_u),
         band3(joy %in% 1:4, h <= 1L, logi_u))
  exp_eq(and3s(joz %in% 1:4, n <= 9L, logi_z),
         band3(joz %in% 1:4, n <= 9L, logi_z))
  exp_eq(and3s(jpa %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jpa %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jpb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jpb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jpc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jpc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jpd %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t),
         band3(jpd %in% c(4L, -3L, 2L, 7L, 8L), , !logi_t))
  exp_eq(and3s(jpe %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a),
         band3(jpe %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a))
  exp_eq(and3s(jpf %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h),
         band3(jpf %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h))
  exp_eq(and3s(jpg %in% c(4L, -3L, 2L, 7L, 8L), w <= 0L, ),
         band3(jpg %in% c(4L, -3L, 2L, 7L, 8L), w <= 0L, ))
  exp_eq(and3s(jph %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, ),
         band3(jph %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, ))
  exp_eq(and3s(jpi %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L, ),
         band3(jpi %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L, ))
  exp_eq(and3s(jpj %in% c(4L, -3L, 2L, 7L, 8L), j <= 0L, !logi_q),
         band3(jpj %in% c(4L, -3L, 2L, 7L, 8L), j <= 0L, !logi_q))
  exp_eq(and3s(jpk %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, !logi_x),
         band3(jpk %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, !logi_x))
  exp_eq(and3s(jpl %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L, !logi_h),
         band3(jpl %in% c(4L, -3L, 2L, 7L, 8L), a <= 9L, !logi_h))
  exp_eq(and3s(jpm %in% 1:4, , ),
         band3(jpm %in% 1:4, , ))
  exp_eq(and3s(jpn %in% 1:4, , ),
         band3(jpn %in% 1:4, , ))
  exp_eq(and3s(jpo %in% 1:4, , ),
         band3(jpo %in% 1:4, , ))
  exp_eq(and3s(jpp %in% 1:4, , !logi_s),
         band3(jpp %in% 1:4, , !logi_s))
  exp_eq(and3s(jpq %in% 1:4, , !logi_z),
         band3(jpq %in% 1:4, , !logi_z))
  exp_eq(and3s(jpr %in% 1:4, , !logi_f),
         band3(jpr %in% 1:4, , !logi_f))
  exp_eq(and3s(jps %in% 1:4, z <= 0L, ),
         band3(jps %in% 1:4, z <= 0L, ))
  exp_eq(and3s(jpt %in% 1:4, k <= 1L, ),
         band3(jpt %in% 1:4, k <= 1L, ))
  exp_eq(and3s(jpu %in% 1:4, d <= 9L, ),
         band3(jpu %in% 1:4, d <= 9L, ))
  exp_eq(and3s(jpv %in% 1:4, i <= 0L, !logi_a),
         band3(jpv %in% 1:4, i <= 0L, !logi_a))
  exp_eq(and3s(jpw %in% 1:4, d <= 1L, !logi_e),
         band3(jpw %in% 1:4, d <= 1L, !logi_e))
  exp_eq(and3s(jpx %in% 1:4, b <= 9L, !logi_u),
         band3(jpx %in% 1:4, b <= 9L, !logi_u))
  exp_eq(and3s(jpy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jpy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jpz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jpz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jqa %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jqa %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jqb %in% c(4L, -3L, 2L, 7L, 8L), , o != 0L),
         band3(jqb %in% c(4L, -3L, 2L, 7L, 8L), , o != 0L))
  exp_eq(and3s(jqc %in% c(4L, -3L, 2L, 7L, 8L), , o != 1L),
         band3(jqc %in% c(4L, -3L, 2L, 7L, 8L), , o != 1L))
  exp_eq(and3s(jqd %in% c(4L, -3L, 2L, 7L, 8L), , v != 9L),
         band3(jqd %in% c(4L, -3L, 2L, 7L, 8L), , v != 9L))
  exp_eq(and3s(jqe %in% c(4L, -3L, 2L, 7L, 8L), q <= 0L, ),
         band3(jqe %in% c(4L, -3L, 2L, 7L, 8L), q <= 0L, ))
  exp_eq(and3s(jqf %in% c(4L, -3L, 2L, 7L, 8L), j <= 1L, ),
         band3(jqf %in% c(4L, -3L, 2L, 7L, 8L), j <= 1L, ))
  exp_eq(and3s(jqg %in% c(4L, -3L, 2L, 7L, 8L), f <= 9L, ),
         band3(jqg %in% c(4L, -3L, 2L, 7L, 8L), f <= 9L, ))
  exp_eq(and3s(jqh %in% c(4L, -3L, 2L, 7L, 8L), m <= 0L, s != 0L),
         band3(jqh %in% c(4L, -3L, 2L, 7L, 8L), m <= 0L, s != 0L))
  exp_eq(and3s(jqi %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L, f != 1L),
         band3(jqi %in% c(4L, -3L, 2L, 7L, 8L), f <= 1L, f != 1L))
  exp_eq(and3s(jqj %in% c(4L, -3L, 2L, 7L, 8L), v <= 9L, u != 9L),
         band3(jqj %in% c(4L, -3L, 2L, 7L, 8L), v <= 9L, u != 9L))
  exp_eq(and3s(jqk %in% 1:4, , ),
         band3(jqk %in% 1:4, , ))
  exp_eq(and3s(jql %in% 1:4, , ),
         band3(jql %in% 1:4, , ))
  exp_eq(and3s(jqm %in% 1:4, , ),
         band3(jqm %in% 1:4, , ))
  exp_eq(and3s(jqn %in% 1:4, , n != 0L),
         band3(jqn %in% 1:4, , n != 0L))
  exp_eq(and3s(jqo %in% 1:4, , v != 1L),
         band3(jqo %in% 1:4, , v != 1L))
  exp_eq(and3s(jqp %in% 1:4, , y != 9L),
         band3(jqp %in% 1:4, , y != 9L))
  exp_eq(and3s(jqq %in% 1:4, b <= 0L, ),
         band3(jqq %in% 1:4, b <= 0L, ))
  exp_eq(and3s(jqr %in% 1:4, b <= 1L, ),
         band3(jqr %in% 1:4, b <= 1L, ))
  exp_eq(and3s(jqs %in% 1:4, d <= 9L, ),
         band3(jqs %in% 1:4, d <= 9L, ))
  exp_eq(and3s(jqt %in% 1:4, p <= 0L, u != 0L),
         band3(jqt %in% 1:4, p <= 0L, u != 0L))
  exp_eq(and3s(jqu %in% 1:4, y <= 1L, k != 1L),
         band3(jqu %in% 1:4, y <= 1L, k != 1L))
  exp_eq(and3s(jqv %in% 1:4, m <= 9L, k != 9L),
         band3(jqv %in% 1:4, m <= 9L, k != 9L))
  exp_eq(and3s(jqw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jqw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jqx %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jqx %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jqy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jqy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jqz %in% c(4L, -3L, 2L, 7L, 8L), , q %between% c(-1L, 1L)),
         band3(jqz %in% c(4L, -3L, 2L, 7L, 8L), , q %between% c(-1L, 1L)))
  exp_eq(and3s(jra %in% c(4L, -3L, 2L, 7L, 8L), , v %between% c(-1L, 1L)),
         band3(jra %in% c(4L, -3L, 2L, 7L, 8L), , v %between% c(-1L, 1L)))
  exp_eq(and3s(jrb %in% c(4L, -3L, 2L, 7L, 8L), , m %between% c(-1L, 1L)),
         band3(jrb %in% c(4L, -3L, 2L, 7L, 8L), , m %between% c(-1L, 1L)))
  exp_eq(and3s(jrc %in% c(4L, -3L, 2L, 7L, 8L), k <= 0L, ),
         band3(jrc %in% c(4L, -3L, 2L, 7L, 8L), k <= 0L, ))
  exp_eq(and3s(jrd %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, ),
         band3(jrd %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, ))
  exp_eq(and3s(jre %in% c(4L, -3L, 2L, 7L, 8L), v <= 9L, ),
         band3(jre %in% c(4L, -3L, 2L, 7L, 8L), v <= 9L, ))
  exp_eq(and3s(jrf %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L, q %between% c(-1L, 1L)),
         band3(jrf %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L, q %between% c(-1L, 1L)))
  exp_eq(and3s(jrg %in% c(4L, -3L, 2L, 7L, 8L), g <= 1L, y %between% c(-1L, 1L)),
         band3(jrg %in% c(4L, -3L, 2L, 7L, 8L), g <= 1L, y %between% c(-1L, 1L)))
  exp_eq(and3s(jrh %in% c(4L, -3L, 2L, 7L, 8L), s <= 9L, z %between% c(-1L, 1L)),
         band3(jrh %in% c(4L, -3L, 2L, 7L, 8L), s <= 9L, z %between% c(-1L, 1L)))
  exp_eq(and3s(jri %in% 1:4, , ),
         band3(jri %in% 1:4, , ))
  exp_eq(and3s(jrj %in% 1:4, , ),
         band3(jrj %in% 1:4, , ))
  exp_eq(and3s(jrk %in% 1:4, , ),
         band3(jrk %in% 1:4, , ))
  exp_eq(and3s(jrl %in% 1:4, , s %between% c(-1L, 1L)),
         band3(jrl %in% 1:4, , s %between% c(-1L, 1L)))
  exp_eq(and3s(jrm %in% 1:4, , e %between% c(-1L, 1L)),
         band3(jrm %in% 1:4, , e %between% c(-1L, 1L)))
  exp_eq(and3s(jrn %in% 1:4, , i %between% c(-1L, 1L)),
         band3(jrn %in% 1:4, , i %between% c(-1L, 1L)))
  exp_eq(and3s(jro %in% 1:4, h <= 0L, ),
         band3(jro %in% 1:4, h <= 0L, ))
  exp_eq(and3s(jrp %in% 1:4, s <= 1L, ),
         band3(jrp %in% 1:4, s <= 1L, ))
  exp_eq(and3s(jrq %in% 1:4, l <= 9L, ),
         band3(jrq %in% 1:4, l <= 9L, ))
  exp_eq(and3s(jrr %in% 1:4, h <= 0L, f %between% c(-1L, 1L)),
         band3(jrr %in% 1:4, h <= 0L, f %between% c(-1L, 1L)))
  exp_eq(and3s(jrs %in% 1:4, h <= 1L, l %between% c(-1L, 1L)),
         band3(jrs %in% 1:4, h <= 1L, l %between% c(-1L, 1L)))
  exp_eq(and3s(jrt %in% 1:4, r <= 9L, g %between% c(-1L, 1L)),
         band3(jrt %in% 1:4, r <= 9L, g %between% c(-1L, 1L)))
  exp_eq(and3s(jru %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jru %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jrv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jrv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jrw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jrw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jrx %in% c(4L, -3L, 2L, 7L, 8L), , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jrx %in% c(4L, -3L, 2L, 7L, 8L), , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jry %in% c(4L, -3L, 2L, 7L, 8L), , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jry %in% c(4L, -3L, 2L, 7L, 8L), , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jrz %in% c(4L, -3L, 2L, 7L, 8L), , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jrz %in% c(4L, -3L, 2L, 7L, 8L), , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jsa %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L, ),
         band3(jsa %in% c(4L, -3L, 2L, 7L, 8L), e <= 0L, ))
  exp_eq(and3s(jsb %in% c(4L, -3L, 2L, 7L, 8L), y <= 1L, ),
         band3(jsb %in% c(4L, -3L, 2L, 7L, 8L), y <= 1L, ))
  exp_eq(and3s(jsc %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, ),
         band3(jsc %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, ))
  exp_eq(and3s(jsd %in% c(4L, -3L, 2L, 7L, 8L), j <= 0L, j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jsd %in% c(4L, -3L, 2L, 7L, 8L), j <= 0L, j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jse %in% c(4L, -3L, 2L, 7L, 8L), b <= 1L, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jse %in% c(4L, -3L, 2L, 7L, 8L), b <= 1L, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jsf %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(jsf %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(jsg %in% 1:4, , ),
         band3(jsg %in% 1:4, , ))
  exp_eq(and3s(jsh %in% 1:4, , ),
         band3(jsh %in% 1:4, , ))
  exp_eq(and3s(jsi %in% 1:4, , ),
         band3(jsi %in% 1:4, , ))
  exp_eq(and3s(jsj %in% 1:4, , b %in% 1:4),
         band3(jsj %in% 1:4, , b %in% 1:4))
  exp_eq(and3s(jsk %in% 1:4, , x %in% 1:4),
         band3(jsk %in% 1:4, , x %in% 1:4))
  exp_eq(and3s(jsl %in% 1:4, , x %in% 1:4),
         band3(jsl %in% 1:4, , x %in% 1:4))
  exp_eq(and3s(jsm %in% 1:4, p <= 0L, ),
         band3(jsm %in% 1:4, p <= 0L, ))
  exp_eq(and3s(jsn %in% 1:4, b <= 1L, ),
         band3(jsn %in% 1:4, b <= 1L, ))
  exp_eq(and3s(jso %in% 1:4, g <= 9L, ),
         band3(jso %in% 1:4, g <= 9L, ))
  exp_eq(and3s(jsp %in% 1:4, w <= 0L, k %in% 1:4),
         band3(jsp %in% 1:4, w <= 0L, k %in% 1:4))
  exp_eq(and3s(jsq %in% 1:4, q <= 1L, k %in% 1:4),
         band3(jsq %in% 1:4, q <= 1L, k %in% 1:4))
  exp_eq(and3s(jsr %in% 1:4, f <= 9L, b %in% 1:4),
         band3(jsr %in% 1:4, f <= 9L, b %in% 1:4))
  exp_eq(and3s(jss %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jss %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jst %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jst %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jsu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jsu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jsv %in% c(4L, -3L, 2L, 7L, 8L), , g < 0L),
         band3(jsv %in% c(4L, -3L, 2L, 7L, 8L), , g < 0L))
  exp_eq(and3s(jsw %in% c(4L, -3L, 2L, 7L, 8L), , v < 1L),
         band3(jsw %in% c(4L, -3L, 2L, 7L, 8L), , v < 1L))
  exp_eq(and3s(jsx %in% c(4L, -3L, 2L, 7L, 8L), , h < 9L),
         band3(jsx %in% c(4L, -3L, 2L, 7L, 8L), , h < 9L))
  exp_eq(and3s(jsy %in% c(4L, -3L, 2L, 7L, 8L), p <= 0L, ),
         band3(jsy %in% c(4L, -3L, 2L, 7L, 8L), p <= 0L, ))
  exp_eq(and3s(jsz %in% c(4L, -3L, 2L, 7L, 8L), d <= 1L, ),
         band3(jsz %in% c(4L, -3L, 2L, 7L, 8L), d <= 1L, ))
  exp_eq(and3s(jta %in% c(4L, -3L, 2L, 7L, 8L), n <= 9L, ),
         band3(jta %in% c(4L, -3L, 2L, 7L, 8L), n <= 9L, ))
  exp_eq(and3s(jtb %in% c(4L, -3L, 2L, 7L, 8L), r <= 0L, u < 0L),
         band3(jtb %in% c(4L, -3L, 2L, 7L, 8L), r <= 0L, u < 0L))
  exp_eq(and3s(jtc %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L, w < 1L),
         band3(jtc %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L, w < 1L))
  exp_eq(and3s(jtd %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, m < 9L),
         band3(jtd %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, m < 9L))
  exp_eq(and3s(jte %in% 1:4, , ),
         band3(jte %in% 1:4, , ))
  exp_eq(and3s(jtf %in% 1:4, , ),
         band3(jtf %in% 1:4, , ))
  exp_eq(and3s(jtg %in% 1:4, , ),
         band3(jtg %in% 1:4, , ))
  exp_eq(and3s(jth %in% 1:4, , q < 0L),
         band3(jth %in% 1:4, , q < 0L))
  exp_eq(and3s(jti %in% 1:4, , t < 1L),
         band3(jti %in% 1:4, , t < 1L))
  exp_eq(and3s(jtj %in% 1:4, , m < 9L),
         band3(jtj %in% 1:4, , m < 9L))
  exp_eq(and3s(jtk %in% 1:4, s <= 0L, ),
         band3(jtk %in% 1:4, s <= 0L, ))
  exp_eq(and3s(jtl %in% 1:4, l <= 1L, ),
         band3(jtl %in% 1:4, l <= 1L, ))
  exp_eq(and3s(jtm %in% 1:4, v <= 9L, ),
         band3(jtm %in% 1:4, v <= 9L, ))
  exp_eq(and3s(jtn %in% 1:4, i <= 0L, e < 0L),
         band3(jtn %in% 1:4, i <= 0L, e < 0L))
  exp_eq(and3s(jto %in% 1:4, j <= 1L, y < 1L),
         band3(jto %in% 1:4, j <= 1L, y < 1L))
  exp_eq(and3s(jtp %in% 1:4, o <= 9L, x < 9L),
         band3(jtp %in% 1:4, o <= 9L, x < 9L))
  exp_eq(and3s(jtq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jtq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jtr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jtr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jts %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jts %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jtt %in% c(4L, -3L, 2L, 7L, 8L), , t <= 0L),
         band3(jtt %in% c(4L, -3L, 2L, 7L, 8L), , t <= 0L))
  exp_eq(and3s(jtu %in% c(4L, -3L, 2L, 7L, 8L), , y <= 1L),
         band3(jtu %in% c(4L, -3L, 2L, 7L, 8L), , y <= 1L))
  exp_eq(and3s(jtv %in% c(4L, -3L, 2L, 7L, 8L), , q <= 9L),
         band3(jtv %in% c(4L, -3L, 2L, 7L, 8L), , q <= 9L))
  exp_eq(and3s(jtw %in% c(4L, -3L, 2L, 7L, 8L), z <= 0L, ),
         band3(jtw %in% c(4L, -3L, 2L, 7L, 8L), z <= 0L, ))
  exp_eq(and3s(jtx %in% c(4L, -3L, 2L, 7L, 8L), p <= 1L, ),
         band3(jtx %in% c(4L, -3L, 2L, 7L, 8L), p <= 1L, ))
  exp_eq(and3s(jty %in% c(4L, -3L, 2L, 7L, 8L), l <= 9L, ),
         band3(jty %in% c(4L, -3L, 2L, 7L, 8L), l <= 9L, ))
  exp_eq(and3s(jtz %in% c(4L, -3L, 2L, 7L, 8L), d <= 0L, y <= 0L),
         band3(jtz %in% c(4L, -3L, 2L, 7L, 8L), d <= 0L, y <= 0L))
  exp_eq(and3s(jua %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, j <= 1L),
         band3(jua %in% c(4L, -3L, 2L, 7L, 8L), s <= 1L, j <= 1L))
  exp_eq(and3s(jub %in% c(4L, -3L, 2L, 7L, 8L), j <= 9L, x <= 9L),
         band3(jub %in% c(4L, -3L, 2L, 7L, 8L), j <= 9L, x <= 9L))
  exp_eq(and3s(juc %in% 1:4, , ),
         band3(juc %in% 1:4, , ))
  exp_eq(and3s(jud %in% 1:4, , ),
         band3(jud %in% 1:4, , ))
  exp_eq(and3s(jue %in% 1:4, , ),
         band3(jue %in% 1:4, , ))
  exp_eq(and3s(juf %in% 1:4, , x <= 0L),
         band3(juf %in% 1:4, , x <= 0L))
  exp_eq(and3s(jug %in% 1:4, , n <= 1L),
         band3(jug %in% 1:4, , n <= 1L))
  exp_eq(and3s(juh %in% 1:4, , v <= 9L),
         band3(juh %in% 1:4, , v <= 9L))
  exp_eq(and3s(jui %in% 1:4, v <= 0L, ),
         band3(jui %in% 1:4, v <= 0L, ))
  exp_eq(and3s(juj %in% 1:4, o <= 1L, ),
         band3(juj %in% 1:4, o <= 1L, ))
  exp_eq(and3s(juk %in% 1:4, b <= 9L, ),
         band3(juk %in% 1:4, b <= 9L, ))
  exp_eq(and3s(jul %in% 1:4, j <= 0L, h <= 0L),
         band3(jul %in% 1:4, j <= 0L, h <= 0L))
  exp_eq(and3s(jum %in% 1:4, a <= 1L, k <= 1L),
         band3(jum %in% 1:4, a <= 1L, k <= 1L))
  exp_eq(and3s(jun %in% 1:4, x <= 9L, u <= 9L),
         band3(jun %in% 1:4, x <= 9L, u <= 9L))
  exp_eq(and3s(juo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(juo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jup %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jup %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(juq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(juq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jur %in% c(4L, -3L, 2L, 7L, 8L), , u == 0L),
         band3(jur %in% c(4L, -3L, 2L, 7L, 8L), , u == 0L))
  exp_eq(and3s(jus %in% c(4L, -3L, 2L, 7L, 8L), , k == 1L),
         band3(jus %in% c(4L, -3L, 2L, 7L, 8L), , k == 1L))
  exp_eq(and3s(jut %in% c(4L, -3L, 2L, 7L, 8L), , r == 9L),
         band3(jut %in% c(4L, -3L, 2L, 7L, 8L), , r == 9L))
  exp_eq(and3s(juu %in% c(4L, -3L, 2L, 7L, 8L), b <= 0L, ),
         band3(juu %in% c(4L, -3L, 2L, 7L, 8L), b <= 0L, ))
  exp_eq(and3s(juv %in% c(4L, -3L, 2L, 7L, 8L), q <= 1L, ),
         band3(juv %in% c(4L, -3L, 2L, 7L, 8L), q <= 1L, ))
  exp_eq(and3s(juw %in% c(4L, -3L, 2L, 7L, 8L), s <= 9L, ),
         band3(juw %in% c(4L, -3L, 2L, 7L, 8L), s <= 9L, ))
  exp_eq(and3s(jux %in% c(4L, -3L, 2L, 7L, 8L), i <= 0L, t == 0L),
         band3(jux %in% c(4L, -3L, 2L, 7L, 8L), i <= 0L, t == 0L))
  exp_eq(and3s(juy %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, p == 1L),
         band3(juy %in% c(4L, -3L, 2L, 7L, 8L), v <= 1L, p == 1L))
  exp_eq(and3s(juz %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, u == 9L),
         band3(juz %in% c(4L, -3L, 2L, 7L, 8L), c <= 9L, u == 9L))
  exp_eq(and3s(jva %in% 1:4, , ),
         band3(jva %in% 1:4, , ))
  exp_eq(and3s(jvb %in% 1:4, , ),
         band3(jvb %in% 1:4, , ))
  exp_eq(and3s(jvc %in% 1:4, , ),
         band3(jvc %in% 1:4, , ))
  exp_eq(and3s(jvd %in% 1:4, , i == 0L),
         band3(jvd %in% 1:4, , i == 0L))
  exp_eq(and3s(jve %in% 1:4, , j == 1L),
         band3(jve %in% 1:4, , j == 1L))
  exp_eq(and3s(jvf %in% 1:4, , e == 9L),
         band3(jvf %in% 1:4, , e == 9L))
  exp_eq(and3s(jvg %in% 1:4, c <= 0L, ),
         band3(jvg %in% 1:4, c <= 0L, ))
  exp_eq(and3s(jvh %in% 1:4, x <= 1L, ),
         band3(jvh %in% 1:4, x <= 1L, ))
  exp_eq(and3s(jvi %in% 1:4, d <= 9L, ),
         band3(jvi %in% 1:4, d <= 9L, ))
  exp_eq(and3s(jvj %in% 1:4, i <= 0L, v == 0L),
         band3(jvj %in% 1:4, i <= 0L, v == 0L))
  exp_eq(and3s(jvk %in% 1:4, j <= 1L, j == 1L),
         band3(jvk %in% 1:4, j <= 1L, j == 1L))
  exp_eq(and3s(jvl %in% 1:4, f <= 9L, q == 9L),
         band3(jvl %in% 1:4, f <= 9L, q == 9L))
  exp_eq(and3s(jvm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jvm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jvn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jvn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jvo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jvo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jvp %in% c(4L, -3L, 2L, 7L, 8L), , p > 0L),
         band3(jvp %in% c(4L, -3L, 2L, 7L, 8L), , p > 0L))
  exp_eq(and3s(jvq %in% c(4L, -3L, 2L, 7L, 8L), , u > 1L),
         band3(jvq %in% c(4L, -3L, 2L, 7L, 8L), , u > 1L))
  exp_eq(and3s(jvr %in% c(4L, -3L, 2L, 7L, 8L), , x > 9L),
         band3(jvr %in% c(4L, -3L, 2L, 7L, 8L), , x > 9L))
  exp_eq(and3s(jvs %in% c(4L, -3L, 2L, 7L, 8L), k <= 0L, ),
         band3(jvs %in% c(4L, -3L, 2L, 7L, 8L), k <= 0L, ))
  exp_eq(and3s(jvt %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L, ),
         band3(jvt %in% c(4L, -3L, 2L, 7L, 8L), x <= 1L, ))
  exp_eq(and3s(jvu %in% c(4L, -3L, 2L, 7L, 8L), z <= 9L, ),
         band3(jvu %in% c(4L, -3L, 2L, 7L, 8L), z <= 9L, ))
  exp_eq(and3s(jvv %in% c(4L, -3L, 2L, 7L, 8L), s <= 0L, j > 0L),
         band3(jvv %in% c(4L, -3L, 2L, 7L, 8L), s <= 0L, j > 0L))
  exp_eq(and3s(jvw %in% c(4L, -3L, 2L, 7L, 8L), u <= 1L, i > 1L),
         band3(jvw %in% c(4L, -3L, 2L, 7L, 8L), u <= 1L, i > 1L))
  exp_eq(and3s(jvx %in% c(4L, -3L, 2L, 7L, 8L), m <= 9L, p > 9L),
         band3(jvx %in% c(4L, -3L, 2L, 7L, 8L), m <= 9L, p > 9L))
  exp_eq(and3s(jvy %in% 1:4, , ),
         band3(jvy %in% 1:4, , ))
  exp_eq(and3s(jvz %in% 1:4, , ),
         band3(jvz %in% 1:4, , ))
  exp_eq(and3s(jwa %in% 1:4, , ),
         band3(jwa %in% 1:4, , ))
  exp_eq(and3s(jwb %in% 1:4, , y > 0L),
         band3(jwb %in% 1:4, , y > 0L))
  exp_eq(and3s(jwc %in% 1:4, , d > 1L),
         band3(jwc %in% 1:4, , d > 1L))
  exp_eq(and3s(jwd %in% 1:4, , d > 9L),
         band3(jwd %in% 1:4, , d > 9L))
  exp_eq(and3s(jwe %in% 1:4, h <= 0L, ),
         band3(jwe %in% 1:4, h <= 0L, ))
  exp_eq(and3s(jwf %in% 1:4, n <= 1L, ),
         band3(jwf %in% 1:4, n <= 1L, ))
  exp_eq(and3s(jwg %in% 1:4, r <= 9L, ),
         band3(jwg %in% 1:4, r <= 9L, ))
  exp_eq(and3s(jwh %in% 1:4, l <= 0L, r > 0L),
         band3(jwh %in% 1:4, l <= 0L, r > 0L))
  exp_eq(and3s(jwi %in% 1:4, i <= 1L, c > 1L),
         band3(jwi %in% 1:4, i <= 1L, c > 1L))
  exp_eq(and3s(jwj %in% 1:4, u <= 9L, k > 9L),
         band3(jwj %in% 1:4, u <= 9L, k > 9L))
  exp_eq(and3s(jwk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jwk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jwl %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jwl %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jwm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jwm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jwn %in% c(4L, -3L, 2L, 7L, 8L), , x >= 0L),
         band3(jwn %in% c(4L, -3L, 2L, 7L, 8L), , x >= 0L))
  exp_eq(and3s(jwo %in% c(4L, -3L, 2L, 7L, 8L), , y >= 1L),
         band3(jwo %in% c(4L, -3L, 2L, 7L, 8L), , y >= 1L))
  exp_eq(and3s(jwp %in% c(4L, -3L, 2L, 7L, 8L), , l >= 9L),
         band3(jwp %in% c(4L, -3L, 2L, 7L, 8L), , l >= 9L))
  exp_eq(and3s(jwq %in% c(4L, -3L, 2L, 7L, 8L), a <= 0L, ),
         band3(jwq %in% c(4L, -3L, 2L, 7L, 8L), a <= 0L, ))
  exp_eq(and3s(jwr %in% c(4L, -3L, 2L, 7L, 8L), n <= 1L, ),
         band3(jwr %in% c(4L, -3L, 2L, 7L, 8L), n <= 1L, ))
  exp_eq(and3s(jws %in% c(4L, -3L, 2L, 7L, 8L), t <= 9L, ),
         band3(jws %in% c(4L, -3L, 2L, 7L, 8L), t <= 9L, ))
  exp_eq(and3s(jwt %in% c(4L, -3L, 2L, 7L, 8L), r <= 0L, z >= 0L),
         band3(jwt %in% c(4L, -3L, 2L, 7L, 8L), r <= 0L, z >= 0L))
  exp_eq(and3s(jwu %in% c(4L, -3L, 2L, 7L, 8L), r <= 1L, d >= 1L),
         band3(jwu %in% c(4L, -3L, 2L, 7L, 8L), r <= 1L, d >= 1L))
  exp_eq(and3s(jwv %in% c(4L, -3L, 2L, 7L, 8L), t <= 9L, a >= 9L),
         band3(jwv %in% c(4L, -3L, 2L, 7L, 8L), t <= 9L, a >= 9L))
  exp_eq(and3s(jww %in% 1:4, , ),
         band3(jww %in% 1:4, , ))
  exp_eq(and3s(jwx %in% 1:4, , ),
         band3(jwx %in% 1:4, , ))
  exp_eq(and3s(jwy %in% 1:4, , ),
         band3(jwy %in% 1:4, , ))
  exp_eq(and3s(jwz %in% 1:4, , v >= 0L),
         band3(jwz %in% 1:4, , v >= 0L))
  exp_eq(and3s(jxa %in% 1:4, , u >= 1L),
         band3(jxa %in% 1:4, , u >= 1L))
  exp_eq(and3s(jxb %in% 1:4, , f >= 9L),
         band3(jxb %in% 1:4, , f >= 9L))
  exp_eq(and3s(jxc %in% 1:4, q <= 0L, ),
         band3(jxc %in% 1:4, q <= 0L, ))
  exp_eq(and3s(jxd %in% 1:4, w <= 1L, ),
         band3(jxd %in% 1:4, w <= 1L, ))
  exp_eq(and3s(jxe %in% 1:4, l <= 9L, ),
         band3(jxe %in% 1:4, l <= 9L, ))
  exp_eq(and3s(jxf %in% 1:4, u <= 0L, v >= 0L),
         band3(jxf %in% 1:4, u <= 0L, v >= 0L))
  exp_eq(and3s(jxg %in% 1:4, k <= 1L, o >= 1L),
         band3(jxg %in% 1:4, k <= 1L, o >= 1L))
  exp_eq(and3s(jxh %in% 1:4, z <= 9L, l >= 9L),
         band3(jxh %in% 1:4, z <= 9L, l >= 9L))
  exp_eq(and3s(jxi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jxi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jxj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jxj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jxk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jxk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jxl %in% c(4L, -3L, 2L, 7L, 8L), , logi_b),
         band3(jxl %in% c(4L, -3L, 2L, 7L, 8L), , logi_b))
  exp_eq(and3s(jxm %in% c(4L, -3L, 2L, 7L, 8L), , logi_q),
         band3(jxm %in% c(4L, -3L, 2L, 7L, 8L), , logi_q))
  exp_eq(and3s(jxn %in% c(4L, -3L, 2L, 7L, 8L), , logi_j),
         band3(jxn %in% c(4L, -3L, 2L, 7L, 8L), , logi_j))
  exp_eq(and3s(jxo %in% c(4L, -3L, 2L, 7L, 8L), v == 0L, ),
         band3(jxo %in% c(4L, -3L, 2L, 7L, 8L), v == 0L, ))
  exp_eq(and3s(jxp %in% c(4L, -3L, 2L, 7L, 8L), a == 1L, ),
         band3(jxp %in% c(4L, -3L, 2L, 7L, 8L), a == 1L, ))
  exp_eq(and3s(jxq %in% c(4L, -3L, 2L, 7L, 8L), g == 9L, ),
         band3(jxq %in% c(4L, -3L, 2L, 7L, 8L), g == 9L, ))
  exp_eq(and3s(jxr %in% c(4L, -3L, 2L, 7L, 8L), j == 0L, logi_q),
         band3(jxr %in% c(4L, -3L, 2L, 7L, 8L), j == 0L, logi_q))
  exp_eq(and3s(jxs %in% c(4L, -3L, 2L, 7L, 8L), u == 1L, logi_b),
         band3(jxs %in% c(4L, -3L, 2L, 7L, 8L), u == 1L, logi_b))
  exp_eq(and3s(jxt %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, logi_p),
         band3(jxt %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, logi_p))
  exp_eq(and3s(jxu %in% 1:4, , ),
         band3(jxu %in% 1:4, , ))
  exp_eq(and3s(jxv %in% 1:4, , ),
         band3(jxv %in% 1:4, , ))
  exp_eq(and3s(jxw %in% 1:4, , ),
         band3(jxw %in% 1:4, , ))
  exp_eq(and3s(jxx %in% 1:4, , logi_a),
         band3(jxx %in% 1:4, , logi_a))
  exp_eq(and3s(jxy %in% 1:4, , logi_v),
         band3(jxy %in% 1:4, , logi_v))
  exp_eq(and3s(jxz %in% 1:4, , logi_m),
         band3(jxz %in% 1:4, , logi_m))
  exp_eq(and3s(jya %in% 1:4, q == 0L, ),
         band3(jya %in% 1:4, q == 0L, ))
  exp_eq(and3s(jyb %in% 1:4, c == 1L, ),
         band3(jyb %in% 1:4, c == 1L, ))
  exp_eq(and3s(jyc %in% 1:4, c == 9L, ),
         band3(jyc %in% 1:4, c == 9L, ))
  exp_eq(and3s(jyd %in% 1:4, b == 0L, logi_p),
         band3(jyd %in% 1:4, b == 0L, logi_p))
  exp_eq(and3s(jye %in% 1:4, q == 1L, logi_k),
         band3(jye %in% 1:4, q == 1L, logi_k))
  exp_eq(and3s(jyf %in% 1:4, e == 9L, logi_u),
         band3(jyf %in% 1:4, e == 9L, logi_u))
  exp_eq(and3s(jyg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jyg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jyh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jyh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jyi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(jyi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(jyj %in% c(4L, -3L, 2L, 7L, 8L), , !logi_b),
         band3(jyj %in% c(4L, -3L, 2L, 7L, 8L), , !logi_b))
  exp_eq(and3s(jyk %in% c(4L, -3L, 2L, 7L, 8L), , !logi_c),
         band3(jyk %in% c(4L, -3L, 2L, 7L, 8L), , !logi_c))
  exp_eq(and3s(jyl %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a),
         band3(jyl %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a))
  exp_eq(and3s(jym %in% c(4L, -3L, 2L, 7L, 8L), e == 0L, ),
         band3(jym %in% c(4L, -3L, 2L, 7L, 8L), e == 0L, ))
  exp_eq(and3s(jyn %in% c(4L, -3L, 2L, 7L, 8L), x == 1L, ),
         band3(jyn %in% c(4L, -3L, 2L, 7L, 8L), x == 1L, ))
  exp_eq(and3s(jyo %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, ),
         band3(jyo %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, ))
  exp_eq(and3s(jyp %in% c(4L, -3L, 2L, 7L, 8L), e == 0L, !logi_c),
         band3(jyp %in% c(4L, -3L, 2L, 7L, 8L), e == 0L, !logi_c))
  exp_eq(and3s(jyq %in% c(4L, -3L, 2L, 7L, 8L), k == 1L, !logi_x),
         band3(jyq %in% c(4L, -3L, 2L, 7L, 8L), k == 1L, !logi_x))
  exp_eq(and3s(jyr %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, !logi_v),
         band3(jyr %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, !logi_v))
  exp_eq(and3s(jys %in% 1:4, , ),
         band3(jys %in% 1:4, , ))
  exp_eq(and3s(jyt %in% 1:4, , ),
         band3(jyt %in% 1:4, , ))
  exp_eq(and3s(jyu %in% 1:4, , ),
         band3(jyu %in% 1:4, , ))
  exp_eq(and3s(jyv %in% 1:4, , !logi_t),
         band3(jyv %in% 1:4, , !logi_t))
  exp_eq(and3s(jyw %in% 1:4, , !logi_b),
         band3(jyw %in% 1:4, , !logi_b))
  exp_eq(and3s(jyx %in% 1:4, , !logi_p),
         band3(jyx %in% 1:4, , !logi_p))
  exp_eq(and3s(jyy %in% 1:4, m == 0L, ),
         band3(jyy %in% 1:4, m == 0L, ))
  exp_eq(and3s(jyz %in% 1:4, f == 1L, ),
         band3(jyz %in% 1:4, f == 1L, ))
  exp_eq(and3s(ka %in% 1:4, o == 9L, ),
         band3(ka %in% 1:4, o == 9L, ))
  exp_eq(and3s(kb %in% 1:4, v == 0L, !logi_m),
         band3(kb %in% 1:4, v == 0L, !logi_m))
  exp_eq(and3s(kc %in% 1:4, a == 1L, !logi_d),
         band3(kc %in% 1:4, a == 1L, !logi_d))
  exp_eq(and3s(kd %in% 1:4, b == 9L, !logi_x),
         band3(kd %in% 1:4, b == 9L, !logi_x))
  exp_eq(and3s(ke %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ke %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kh %in% c(4L, -3L, 2L, 7L, 8L), , c != 0L),
         band3(kh %in% c(4L, -3L, 2L, 7L, 8L), , c != 0L))
  exp_eq(and3s(ki %in% c(4L, -3L, 2L, 7L, 8L), , k != 1L),
         band3(ki %in% c(4L, -3L, 2L, 7L, 8L), , k != 1L))
  exp_eq(and3s(kj %in% c(4L, -3L, 2L, 7L, 8L), , b != 9L),
         band3(kj %in% c(4L, -3L, 2L, 7L, 8L), , b != 9L))
  exp_eq(and3s(kk %in% c(4L, -3L, 2L, 7L, 8L), j == 0L, ),
         band3(kk %in% c(4L, -3L, 2L, 7L, 8L), j == 0L, ))
  exp_eq(and3s(kl %in% c(4L, -3L, 2L, 7L, 8L), z == 1L, ),
         band3(kl %in% c(4L, -3L, 2L, 7L, 8L), z == 1L, ))
  exp_eq(and3s(km %in% c(4L, -3L, 2L, 7L, 8L), q == 9L, ),
         band3(km %in% c(4L, -3L, 2L, 7L, 8L), q == 9L, ))
  exp_eq(and3s(kn %in% c(4L, -3L, 2L, 7L, 8L), y == 0L, m != 0L),
         band3(kn %in% c(4L, -3L, 2L, 7L, 8L), y == 0L, m != 0L))
  exp_eq(and3s(ko %in% c(4L, -3L, 2L, 7L, 8L), m == 1L, s != 1L),
         band3(ko %in% c(4L, -3L, 2L, 7L, 8L), m == 1L, s != 1L))
  exp_eq(and3s(kp %in% c(4L, -3L, 2L, 7L, 8L), b == 9L, o != 9L),
         band3(kp %in% c(4L, -3L, 2L, 7L, 8L), b == 9L, o != 9L))
  exp_eq(and3s(kq %in% 1:4, , ),
         band3(kq %in% 1:4, , ))
  exp_eq(and3s(kr %in% 1:4, , ),
         band3(kr %in% 1:4, , ))
  exp_eq(and3s(ks %in% 1:4, , ),
         band3(ks %in% 1:4, , ))
  exp_eq(and3s(kt %in% 1:4, , g != 0L),
         band3(kt %in% 1:4, , g != 0L))
  exp_eq(and3s(ku %in% 1:4, , c != 1L),
         band3(ku %in% 1:4, , c != 1L))
  exp_eq(and3s(kv %in% 1:4, , v != 9L),
         band3(kv %in% 1:4, , v != 9L))
  exp_eq(and3s(kw %in% 1:4, b == 0L, ),
         band3(kw %in% 1:4, b == 0L, ))
  exp_eq(and3s(kx %in% 1:4, f == 1L, ),
         band3(kx %in% 1:4, f == 1L, ))
  exp_eq(and3s(ky %in% 1:4, a == 9L, ),
         band3(ky %in% 1:4, a == 9L, ))
  exp_eq(and3s(kz %in% 1:4, n == 0L, y != 0L),
         band3(kz %in% 1:4, n == 0L, y != 0L))
  exp_eq(and3s(kaa %in% 1:4, c == 1L, h != 1L),
         band3(kaa %in% 1:4, c == 1L, h != 1L))
  exp_eq(and3s(kab %in% 1:4, z == 9L, y != 9L),
         band3(kab %in% 1:4, z == 9L, y != 9L))
  exp_eq(and3s(kac %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kac %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kad %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kad %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kae %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kae %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kaf %in% c(4L, -3L, 2L, 7L, 8L), , v %between% c(-1L, 1L)),
         band3(kaf %in% c(4L, -3L, 2L, 7L, 8L), , v %between% c(-1L, 1L)))
  exp_eq(and3s(kag %in% c(4L, -3L, 2L, 7L, 8L), , d %between% c(-1L, 1L)),
         band3(kag %in% c(4L, -3L, 2L, 7L, 8L), , d %between% c(-1L, 1L)))
  exp_eq(and3s(kah %in% c(4L, -3L, 2L, 7L, 8L), , r %between% c(-1L, 1L)),
         band3(kah %in% c(4L, -3L, 2L, 7L, 8L), , r %between% c(-1L, 1L)))
  exp_eq(and3s(kai %in% c(4L, -3L, 2L, 7L, 8L), n == 0L, ),
         band3(kai %in% c(4L, -3L, 2L, 7L, 8L), n == 0L, ))
  exp_eq(and3s(kaj %in% c(4L, -3L, 2L, 7L, 8L), e == 1L, ),
         band3(kaj %in% c(4L, -3L, 2L, 7L, 8L), e == 1L, ))
  exp_eq(and3s(kak %in% c(4L, -3L, 2L, 7L, 8L), j == 9L, ),
         band3(kak %in% c(4L, -3L, 2L, 7L, 8L), j == 9L, ))
  exp_eq(and3s(kal %in% c(4L, -3L, 2L, 7L, 8L), y == 0L, z %between% c(-1L, 1L)),
         band3(kal %in% c(4L, -3L, 2L, 7L, 8L), y == 0L, z %between% c(-1L, 1L)))
  exp_eq(and3s(kam %in% c(4L, -3L, 2L, 7L, 8L), b == 1L, n %between% c(-1L, 1L)),
         band3(kam %in% c(4L, -3L, 2L, 7L, 8L), b == 1L, n %between% c(-1L, 1L)))
  exp_eq(and3s(kan %in% c(4L, -3L, 2L, 7L, 8L), s == 9L, g %between% c(-1L, 1L)),
         band3(kan %in% c(4L, -3L, 2L, 7L, 8L), s == 9L, g %between% c(-1L, 1L)))
  exp_eq(and3s(kao %in% 1:4, , ),
         band3(kao %in% 1:4, , ))
  exp_eq(and3s(kap %in% 1:4, , ),
         band3(kap %in% 1:4, , ))
  exp_eq(and3s(kaq %in% 1:4, , ),
         band3(kaq %in% 1:4, , ))
  exp_eq(and3s(kar %in% 1:4, , n %between% c(-1L, 1L)),
         band3(kar %in% 1:4, , n %between% c(-1L, 1L)))
  exp_eq(and3s(kas %in% 1:4, , s %between% c(-1L, 1L)),
         band3(kas %in% 1:4, , s %between% c(-1L, 1L)))
  exp_eq(and3s(kat %in% 1:4, , s %between% c(-1L, 1L)),
         band3(kat %in% 1:4, , s %between% c(-1L, 1L)))
  exp_eq(and3s(kau %in% 1:4, m == 0L, ),
         band3(kau %in% 1:4, m == 0L, ))
  exp_eq(and3s(kav %in% 1:4, z == 1L, ),
         band3(kav %in% 1:4, z == 1L, ))
  exp_eq(and3s(kaw %in% 1:4, w == 9L, ),
         band3(kaw %in% 1:4, w == 9L, ))
  exp_eq(and3s(kax %in% 1:4, v == 0L, o %between% c(-1L, 1L)),
         band3(kax %in% 1:4, v == 0L, o %between% c(-1L, 1L)))
  exp_eq(and3s(kay %in% 1:4, r == 1L, u %between% c(-1L, 1L)),
         band3(kay %in% 1:4, r == 1L, u %between% c(-1L, 1L)))
  exp_eq(and3s(kaz %in% 1:4, z == 9L, r %between% c(-1L, 1L)),
         band3(kaz %in% 1:4, z == 9L, r %between% c(-1L, 1L)))
  exp_eq(and3s(kba %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kba %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kbb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kbb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kbc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kbc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kbd %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbd %in% c(4L, -3L, 2L, 7L, 8L), , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbe %in% c(4L, -3L, 2L, 7L, 8L), , q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbe %in% c(4L, -3L, 2L, 7L, 8L), , q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbf %in% c(4L, -3L, 2L, 7L, 8L), , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbf %in% c(4L, -3L, 2L, 7L, 8L), , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbg %in% c(4L, -3L, 2L, 7L, 8L), o == 0L, ),
         band3(kbg %in% c(4L, -3L, 2L, 7L, 8L), o == 0L, ))
  exp_eq(and3s(kbh %in% c(4L, -3L, 2L, 7L, 8L), o == 1L, ),
         band3(kbh %in% c(4L, -3L, 2L, 7L, 8L), o == 1L, ))
  exp_eq(and3s(kbi %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ),
         band3(kbi %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ))
  exp_eq(and3s(kbj %in% c(4L, -3L, 2L, 7L, 8L), p == 0L, b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbj %in% c(4L, -3L, 2L, 7L, 8L), p == 0L, b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbk %in% c(4L, -3L, 2L, 7L, 8L), e == 1L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbk %in% c(4L, -3L, 2L, 7L, 8L), e == 1L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbl %in% c(4L, -3L, 2L, 7L, 8L), o == 9L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kbl %in% c(4L, -3L, 2L, 7L, 8L), o == 9L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kbm %in% 1:4, , ),
         band3(kbm %in% 1:4, , ))
  exp_eq(and3s(kbn %in% 1:4, , ),
         band3(kbn %in% 1:4, , ))
  exp_eq(and3s(kbo %in% 1:4, , ),
         band3(kbo %in% 1:4, , ))
  exp_eq(and3s(kbp %in% 1:4, , k %in% 1:4),
         band3(kbp %in% 1:4, , k %in% 1:4))
  exp_eq(and3s(kbq %in% 1:4, , q %in% 1:4),
         band3(kbq %in% 1:4, , q %in% 1:4))
  exp_eq(and3s(kbr %in% 1:4, , h %in% 1:4),
         band3(kbr %in% 1:4, , h %in% 1:4))
  exp_eq(and3s(kbs %in% 1:4, z == 0L, ),
         band3(kbs %in% 1:4, z == 0L, ))
  exp_eq(and3s(kbt %in% 1:4, p == 1L, ),
         band3(kbt %in% 1:4, p == 1L, ))
  exp_eq(and3s(kbu %in% 1:4, z == 9L, ),
         band3(kbu %in% 1:4, z == 9L, ))
  exp_eq(and3s(kbv %in% 1:4, f == 0L, q %in% 1:4),
         band3(kbv %in% 1:4, f == 0L, q %in% 1:4))
  exp_eq(and3s(kbw %in% 1:4, z == 1L, k %in% 1:4),
         band3(kbw %in% 1:4, z == 1L, k %in% 1:4))
  exp_eq(and3s(kbx %in% 1:4, p == 9L, u %in% 1:4),
         band3(kbx %in% 1:4, p == 9L, u %in% 1:4))
  exp_eq(and3s(kby %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kby %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kbz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kbz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kca %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kca %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kcb %in% c(4L, -3L, 2L, 7L, 8L), , w < 0L),
         band3(kcb %in% c(4L, -3L, 2L, 7L, 8L), , w < 0L))
  exp_eq(and3s(kcc %in% c(4L, -3L, 2L, 7L, 8L), , m < 1L),
         band3(kcc %in% c(4L, -3L, 2L, 7L, 8L), , m < 1L))
  exp_eq(and3s(kcd %in% c(4L, -3L, 2L, 7L, 8L), , p < 9L),
         band3(kcd %in% c(4L, -3L, 2L, 7L, 8L), , p < 9L))
  exp_eq(and3s(kce %in% c(4L, -3L, 2L, 7L, 8L), d == 0L, ),
         band3(kce %in% c(4L, -3L, 2L, 7L, 8L), d == 0L, ))
  exp_eq(and3s(kcf %in% c(4L, -3L, 2L, 7L, 8L), m == 1L, ),
         band3(kcf %in% c(4L, -3L, 2L, 7L, 8L), m == 1L, ))
  exp_eq(and3s(kcg %in% c(4L, -3L, 2L, 7L, 8L), b == 9L, ),
         band3(kcg %in% c(4L, -3L, 2L, 7L, 8L), b == 9L, ))
  exp_eq(and3s(kch %in% c(4L, -3L, 2L, 7L, 8L), h == 0L, h < 0L),
         band3(kch %in% c(4L, -3L, 2L, 7L, 8L), h == 0L, h < 0L))
  exp_eq(and3s(kci %in% c(4L, -3L, 2L, 7L, 8L), k == 1L, o < 1L),
         band3(kci %in% c(4L, -3L, 2L, 7L, 8L), k == 1L, o < 1L))
  exp_eq(and3s(kcj %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, y < 9L),
         band3(kcj %in% c(4L, -3L, 2L, 7L, 8L), n == 9L, y < 9L))
  exp_eq(and3s(kck %in% 1:4, , ),
         band3(kck %in% 1:4, , ))
  exp_eq(and3s(kcl %in% 1:4, , ),
         band3(kcl %in% 1:4, , ))
  exp_eq(and3s(kcm %in% 1:4, , ),
         band3(kcm %in% 1:4, , ))
  exp_eq(and3s(kcn %in% 1:4, , n < 0L),
         band3(kcn %in% 1:4, , n < 0L))
  exp_eq(and3s(kco %in% 1:4, , f < 1L),
         band3(kco %in% 1:4, , f < 1L))
  exp_eq(and3s(kcp %in% 1:4, , b < 9L),
         band3(kcp %in% 1:4, , b < 9L))
  exp_eq(and3s(kcq %in% 1:4, r == 0L, ),
         band3(kcq %in% 1:4, r == 0L, ))
  exp_eq(and3s(kcr %in% 1:4, v == 1L, ),
         band3(kcr %in% 1:4, v == 1L, ))
  exp_eq(and3s(kcs %in% 1:4, m == 9L, ),
         band3(kcs %in% 1:4, m == 9L, ))
  exp_eq(and3s(kct %in% 1:4, u == 0L, a < 0L),
         band3(kct %in% 1:4, u == 0L, a < 0L))
  exp_eq(and3s(kcu %in% 1:4, d == 1L, s < 1L),
         band3(kcu %in% 1:4, d == 1L, s < 1L))
  exp_eq(and3s(kcv %in% 1:4, w == 9L, s < 9L),
         band3(kcv %in% 1:4, w == 9L, s < 9L))
  exp_eq(and3s(kcw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kcw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kcx %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kcx %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kcy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kcy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kcz %in% c(4L, -3L, 2L, 7L, 8L), , w <= 0L),
         band3(kcz %in% c(4L, -3L, 2L, 7L, 8L), , w <= 0L))
  exp_eq(and3s(kda %in% c(4L, -3L, 2L, 7L, 8L), , d <= 1L),
         band3(kda %in% c(4L, -3L, 2L, 7L, 8L), , d <= 1L))
  exp_eq(and3s(kdb %in% c(4L, -3L, 2L, 7L, 8L), , b <= 9L),
         band3(kdb %in% c(4L, -3L, 2L, 7L, 8L), , b <= 9L))
  exp_eq(and3s(kdc %in% c(4L, -3L, 2L, 7L, 8L), x == 0L, ),
         band3(kdc %in% c(4L, -3L, 2L, 7L, 8L), x == 0L, ))
  exp_eq(and3s(kdd %in% c(4L, -3L, 2L, 7L, 8L), g == 1L, ),
         band3(kdd %in% c(4L, -3L, 2L, 7L, 8L), g == 1L, ))
  exp_eq(and3s(kde %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ),
         band3(kde %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ))
  exp_eq(and3s(kdf %in% c(4L, -3L, 2L, 7L, 8L), s == 0L, r <= 0L),
         band3(kdf %in% c(4L, -3L, 2L, 7L, 8L), s == 0L, r <= 0L))
  exp_eq(and3s(kdg %in% c(4L, -3L, 2L, 7L, 8L), h == 1L, i <= 1L),
         band3(kdg %in% c(4L, -3L, 2L, 7L, 8L), h == 1L, i <= 1L))
  exp_eq(and3s(kdh %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, e <= 9L),
         band3(kdh %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, e <= 9L))
  exp_eq(and3s(kdi %in% 1:4, , ),
         band3(kdi %in% 1:4, , ))
  exp_eq(and3s(kdj %in% 1:4, , ),
         band3(kdj %in% 1:4, , ))
  exp_eq(and3s(kdk %in% 1:4, , ),
         band3(kdk %in% 1:4, , ))
  exp_eq(and3s(kdl %in% 1:4, , r <= 0L),
         band3(kdl %in% 1:4, , r <= 0L))
  exp_eq(and3s(kdm %in% 1:4, , l <= 1L),
         band3(kdm %in% 1:4, , l <= 1L))
  exp_eq(and3s(kdn %in% 1:4, , m <= 9L),
         band3(kdn %in% 1:4, , m <= 9L))
  exp_eq(and3s(kdo %in% 1:4, z == 0L, ),
         band3(kdo %in% 1:4, z == 0L, ))
  exp_eq(and3s(kdp %in% 1:4, s == 1L, ),
         band3(kdp %in% 1:4, s == 1L, ))
  exp_eq(and3s(kdq %in% 1:4, r == 9L, ),
         band3(kdq %in% 1:4, r == 9L, ))
  exp_eq(and3s(kdr %in% 1:4, m == 0L, s <= 0L),
         band3(kdr %in% 1:4, m == 0L, s <= 0L))
  exp_eq(and3s(kds %in% 1:4, d == 1L, w <= 1L),
         band3(kds %in% 1:4, d == 1L, w <= 1L))
  exp_eq(and3s(kdt %in% 1:4, k == 9L, q <= 9L),
         band3(kdt %in% 1:4, k == 9L, q <= 9L))
  exp_eq(and3s(kdu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kdu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kdv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kdv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kdw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kdw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kdx %in% c(4L, -3L, 2L, 7L, 8L), , k == 0L),
         band3(kdx %in% c(4L, -3L, 2L, 7L, 8L), , k == 0L))
  exp_eq(and3s(kdy %in% c(4L, -3L, 2L, 7L, 8L), , q == 1L),
         band3(kdy %in% c(4L, -3L, 2L, 7L, 8L), , q == 1L))
  exp_eq(and3s(kdz %in% c(4L, -3L, 2L, 7L, 8L), , o == 9L),
         band3(kdz %in% c(4L, -3L, 2L, 7L, 8L), , o == 9L))
  exp_eq(and3s(kea %in% c(4L, -3L, 2L, 7L, 8L), c == 0L, ),
         band3(kea %in% c(4L, -3L, 2L, 7L, 8L), c == 0L, ))
  exp_eq(and3s(keb %in% c(4L, -3L, 2L, 7L, 8L), g == 1L, ),
         band3(keb %in% c(4L, -3L, 2L, 7L, 8L), g == 1L, ))
  exp_eq(and3s(kec %in% c(4L, -3L, 2L, 7L, 8L), q == 9L, ),
         band3(kec %in% c(4L, -3L, 2L, 7L, 8L), q == 9L, ))
  exp_eq(and3s(ked %in% c(4L, -3L, 2L, 7L, 8L), q == 0L, x == 0L),
         band3(ked %in% c(4L, -3L, 2L, 7L, 8L), q == 0L, x == 0L))
  exp_eq(and3s(kee %in% c(4L, -3L, 2L, 7L, 8L), j == 1L, j == 1L),
         band3(kee %in% c(4L, -3L, 2L, 7L, 8L), j == 1L, j == 1L))
  exp_eq(and3s(kef %in% c(4L, -3L, 2L, 7L, 8L), f == 9L, p == 9L),
         band3(kef %in% c(4L, -3L, 2L, 7L, 8L), f == 9L, p == 9L))
  exp_eq(and3s(keg %in% 1:4, , ),
         band3(keg %in% 1:4, , ))
  exp_eq(and3s(keh %in% 1:4, , ),
         band3(keh %in% 1:4, , ))
  exp_eq(and3s(kei %in% 1:4, , ),
         band3(kei %in% 1:4, , ))
  exp_eq(and3s(kej %in% 1:4, , w == 0L),
         band3(kej %in% 1:4, , w == 0L))
  exp_eq(and3s(kek %in% 1:4, , l == 1L),
         band3(kek %in% 1:4, , l == 1L))
  exp_eq(and3s(kel %in% 1:4, , l == 9L),
         band3(kel %in% 1:4, , l == 9L))
  exp_eq(and3s(kem %in% 1:4, o == 0L, ),
         band3(kem %in% 1:4, o == 0L, ))
  exp_eq(and3s(ken %in% 1:4, o == 1L, ),
         band3(ken %in% 1:4, o == 1L, ))
  exp_eq(and3s(keo %in% 1:4, y == 9L, ),
         band3(keo %in% 1:4, y == 9L, ))
  exp_eq(and3s(kep %in% 1:4, d == 0L, o == 0L),
         band3(kep %in% 1:4, d == 0L, o == 0L))
  exp_eq(and3s(keq %in% 1:4, x == 1L, i == 1L),
         band3(keq %in% 1:4, x == 1L, i == 1L))
  exp_eq(and3s(ker %in% 1:4, m == 9L, r == 9L),
         band3(ker %in% 1:4, m == 9L, r == 9L))
  exp_eq(and3s(kes %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kes %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ket %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ket %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(keu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(keu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kev %in% c(4L, -3L, 2L, 7L, 8L), , p > 0L),
         band3(kev %in% c(4L, -3L, 2L, 7L, 8L), , p > 0L))
  exp_eq(and3s(kew %in% c(4L, -3L, 2L, 7L, 8L), , y > 1L),
         band3(kew %in% c(4L, -3L, 2L, 7L, 8L), , y > 1L))
  exp_eq(and3s(kex %in% c(4L, -3L, 2L, 7L, 8L), , e > 9L),
         band3(kex %in% c(4L, -3L, 2L, 7L, 8L), , e > 9L))
  exp_eq(and3s(key %in% c(4L, -3L, 2L, 7L, 8L), l == 0L, ),
         band3(key %in% c(4L, -3L, 2L, 7L, 8L), l == 0L, ))
  exp_eq(and3s(kez %in% c(4L, -3L, 2L, 7L, 8L), a == 1L, ),
         band3(kez %in% c(4L, -3L, 2L, 7L, 8L), a == 1L, ))
  exp_eq(and3s(kfa %in% c(4L, -3L, 2L, 7L, 8L), s == 9L, ),
         band3(kfa %in% c(4L, -3L, 2L, 7L, 8L), s == 9L, ))
  exp_eq(and3s(kfb %in% c(4L, -3L, 2L, 7L, 8L), s == 0L, n > 0L),
         band3(kfb %in% c(4L, -3L, 2L, 7L, 8L), s == 0L, n > 0L))
  exp_eq(and3s(kfc %in% c(4L, -3L, 2L, 7L, 8L), r == 1L, v > 1L),
         band3(kfc %in% c(4L, -3L, 2L, 7L, 8L), r == 1L, v > 1L))
  exp_eq(and3s(kfd %in% c(4L, -3L, 2L, 7L, 8L), p == 9L, c > 9L),
         band3(kfd %in% c(4L, -3L, 2L, 7L, 8L), p == 9L, c > 9L))
  exp_eq(and3s(kfe %in% 1:4, , ),
         band3(kfe %in% 1:4, , ))
  exp_eq(and3s(kff %in% 1:4, , ),
         band3(kff %in% 1:4, , ))
  exp_eq(and3s(kfg %in% 1:4, , ),
         band3(kfg %in% 1:4, , ))
  exp_eq(and3s(kfh %in% 1:4, , z > 0L),
         band3(kfh %in% 1:4, , z > 0L))
  exp_eq(and3s(kfi %in% 1:4, , w > 1L),
         band3(kfi %in% 1:4, , w > 1L))
  exp_eq(and3s(kfj %in% 1:4, , c > 9L),
         band3(kfj %in% 1:4, , c > 9L))
  exp_eq(and3s(kfk %in% 1:4, t == 0L, ),
         band3(kfk %in% 1:4, t == 0L, ))
  exp_eq(and3s(kfl %in% 1:4, h == 1L, ),
         band3(kfl %in% 1:4, h == 1L, ))
  exp_eq(and3s(kfm %in% 1:4, a == 9L, ),
         band3(kfm %in% 1:4, a == 9L, ))
  exp_eq(and3s(kfn %in% 1:4, o == 0L, g > 0L),
         band3(kfn %in% 1:4, o == 0L, g > 0L))
  exp_eq(and3s(kfo %in% 1:4, q == 1L, p > 1L),
         band3(kfo %in% 1:4, q == 1L, p > 1L))
  exp_eq(and3s(kfp %in% 1:4, e == 9L, d > 9L),
         band3(kfp %in% 1:4, e == 9L, d > 9L))
  exp_eq(and3s(kfq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kfq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kfr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kfr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kfs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kfs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kft %in% c(4L, -3L, 2L, 7L, 8L), , d >= 0L),
         band3(kft %in% c(4L, -3L, 2L, 7L, 8L), , d >= 0L))
  exp_eq(and3s(kfu %in% c(4L, -3L, 2L, 7L, 8L), , p >= 1L),
         band3(kfu %in% c(4L, -3L, 2L, 7L, 8L), , p >= 1L))
  exp_eq(and3s(kfv %in% c(4L, -3L, 2L, 7L, 8L), , v >= 9L),
         band3(kfv %in% c(4L, -3L, 2L, 7L, 8L), , v >= 9L))
  exp_eq(and3s(kfw %in% c(4L, -3L, 2L, 7L, 8L), w == 0L, ),
         band3(kfw %in% c(4L, -3L, 2L, 7L, 8L), w == 0L, ))
  exp_eq(and3s(kfx %in% c(4L, -3L, 2L, 7L, 8L), r == 1L, ),
         band3(kfx %in% c(4L, -3L, 2L, 7L, 8L), r == 1L, ))
  exp_eq(and3s(kfy %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ),
         band3(kfy %in% c(4L, -3L, 2L, 7L, 8L), h == 9L, ))
  exp_eq(and3s(kfz %in% c(4L, -3L, 2L, 7L, 8L), n == 0L, a >= 0L),
         band3(kfz %in% c(4L, -3L, 2L, 7L, 8L), n == 0L, a >= 0L))
  exp_eq(and3s(kga %in% c(4L, -3L, 2L, 7L, 8L), u == 1L, a >= 1L),
         band3(kga %in% c(4L, -3L, 2L, 7L, 8L), u == 1L, a >= 1L))
  exp_eq(and3s(kgb %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, j >= 9L),
         band3(kgb %in% c(4L, -3L, 2L, 7L, 8L), z == 9L, j >= 9L))
  exp_eq(and3s(kgc %in% 1:4, , ),
         band3(kgc %in% 1:4, , ))
  exp_eq(and3s(kgd %in% 1:4, , ),
         band3(kgd %in% 1:4, , ))
  exp_eq(and3s(kge %in% 1:4, , ),
         band3(kge %in% 1:4, , ))
  exp_eq(and3s(kgf %in% 1:4, , a >= 0L),
         band3(kgf %in% 1:4, , a >= 0L))
  exp_eq(and3s(kgg %in% 1:4, , d >= 1L),
         band3(kgg %in% 1:4, , d >= 1L))
  exp_eq(and3s(kgh %in% 1:4, , l >= 9L),
         band3(kgh %in% 1:4, , l >= 9L))
  exp_eq(and3s(kgi %in% 1:4, a == 0L, ),
         band3(kgi %in% 1:4, a == 0L, ))
  exp_eq(and3s(kgj %in% 1:4, t == 1L, ),
         band3(kgj %in% 1:4, t == 1L, ))
  exp_eq(and3s(kgk %in% 1:4, p == 9L, ),
         band3(kgk %in% 1:4, p == 9L, ))
  exp_eq(and3s(kgl %in% 1:4, c == 0L, l >= 0L),
         band3(kgl %in% 1:4, c == 0L, l >= 0L))
  exp_eq(and3s(kgm %in% 1:4, v == 1L, r >= 1L),
         band3(kgm %in% 1:4, v == 1L, r >= 1L))
  exp_eq(and3s(kgn %in% 1:4, y == 9L, b >= 9L),
         band3(kgn %in% 1:4, y == 9L, b >= 9L))
  exp_eq(and3s(kgo %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kgo %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kgp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kgp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kgq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kgq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kgr %in% c(4L, -3L, 2L, 7L, 8L), , logi_e),
         band3(kgr %in% c(4L, -3L, 2L, 7L, 8L), , logi_e))
  exp_eq(and3s(kgs %in% c(4L, -3L, 2L, 7L, 8L), , logi_p),
         band3(kgs %in% c(4L, -3L, 2L, 7L, 8L), , logi_p))
  exp_eq(and3s(kgt %in% c(4L, -3L, 2L, 7L, 8L), , logi_n),
         band3(kgt %in% c(4L, -3L, 2L, 7L, 8L), , logi_n))
  exp_eq(and3s(kgu %in% c(4L, -3L, 2L, 7L, 8L), v > 0L, ),
         band3(kgu %in% c(4L, -3L, 2L, 7L, 8L), v > 0L, ))
  exp_eq(and3s(kgv %in% c(4L, -3L, 2L, 7L, 8L), u > 1L, ),
         band3(kgv %in% c(4L, -3L, 2L, 7L, 8L), u > 1L, ))
  exp_eq(and3s(kgw %in% c(4L, -3L, 2L, 7L, 8L), i > 9L, ),
         band3(kgw %in% c(4L, -3L, 2L, 7L, 8L), i > 9L, ))
  exp_eq(and3s(kgx %in% c(4L, -3L, 2L, 7L, 8L), u > 0L, logi_y),
         band3(kgx %in% c(4L, -3L, 2L, 7L, 8L), u > 0L, logi_y))
  exp_eq(and3s(kgy %in% c(4L, -3L, 2L, 7L, 8L), s > 1L, logi_w),
         band3(kgy %in% c(4L, -3L, 2L, 7L, 8L), s > 1L, logi_w))
  exp_eq(and3s(kgz %in% c(4L, -3L, 2L, 7L, 8L), w > 9L, logi_c),
         band3(kgz %in% c(4L, -3L, 2L, 7L, 8L), w > 9L, logi_c))
  exp_eq(and3s(kha %in% 1:4, , ),
         band3(kha %in% 1:4, , ))
  exp_eq(and3s(khb %in% 1:4, , ),
         band3(khb %in% 1:4, , ))
  exp_eq(and3s(khc %in% 1:4, , ),
         band3(khc %in% 1:4, , ))
  exp_eq(and3s(khd %in% 1:4, , logi_k),
         band3(khd %in% 1:4, , logi_k))
  exp_eq(and3s(khe %in% 1:4, , logi_q),
         band3(khe %in% 1:4, , logi_q))
  exp_eq(and3s(khf %in% 1:4, , logi_o),
         band3(khf %in% 1:4, , logi_o))
  exp_eq(and3s(khg %in% 1:4, v > 0L, ),
         band3(khg %in% 1:4, v > 0L, ))
  exp_eq(and3s(khh %in% 1:4, t > 1L, ),
         band3(khh %in% 1:4, t > 1L, ))
  exp_eq(and3s(khi %in% 1:4, r > 9L, ),
         band3(khi %in% 1:4, r > 9L, ))
  exp_eq(and3s(khj %in% 1:4, h > 0L, logi_w),
         band3(khj %in% 1:4, h > 0L, logi_w))
  exp_eq(and3s(khk %in% 1:4, t > 1L, logi_k),
         band3(khk %in% 1:4, t > 1L, logi_k))
  exp_eq(and3s(khl %in% 1:4, x > 9L, logi_i),
         band3(khl %in% 1:4, x > 9L, logi_i))
  exp_eq(and3s(khm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(khm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(khn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(khn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kho %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kho %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(khp %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a),
         band3(khp %in% c(4L, -3L, 2L, 7L, 8L), , !logi_a))
  exp_eq(and3s(khq %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h),
         band3(khq %in% c(4L, -3L, 2L, 7L, 8L), , !logi_h))
  exp_eq(and3s(khr %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f),
         band3(khr %in% c(4L, -3L, 2L, 7L, 8L), , !logi_f))
  exp_eq(and3s(khs %in% c(4L, -3L, 2L, 7L, 8L), c > 0L, ),
         band3(khs %in% c(4L, -3L, 2L, 7L, 8L), c > 0L, ))
  exp_eq(and3s(kht %in% c(4L, -3L, 2L, 7L, 8L), m > 1L, ),
         band3(kht %in% c(4L, -3L, 2L, 7L, 8L), m > 1L, ))
  exp_eq(and3s(khu %in% c(4L, -3L, 2L, 7L, 8L), o > 9L, ),
         band3(khu %in% c(4L, -3L, 2L, 7L, 8L), o > 9L, ))
  exp_eq(and3s(khv %in% c(4L, -3L, 2L, 7L, 8L), t > 0L, !logi_b),
         band3(khv %in% c(4L, -3L, 2L, 7L, 8L), t > 0L, !logi_b))
  exp_eq(and3s(khw %in% c(4L, -3L, 2L, 7L, 8L), v > 1L, !logi_j),
         band3(khw %in% c(4L, -3L, 2L, 7L, 8L), v > 1L, !logi_j))
  exp_eq(and3s(khx %in% c(4L, -3L, 2L, 7L, 8L), w > 9L, !logi_j),
         band3(khx %in% c(4L, -3L, 2L, 7L, 8L), w > 9L, !logi_j))
  exp_eq(and3s(khy %in% 1:4, , ),
         band3(khy %in% 1:4, , ))
  exp_eq(and3s(khz %in% 1:4, , ),
         band3(khz %in% 1:4, , ))
  exp_eq(and3s(kia %in% 1:4, , ),
         band3(kia %in% 1:4, , ))
  exp_eq(and3s(kib %in% 1:4, , !logi_i),
         band3(kib %in% 1:4, , !logi_i))
  exp_eq(and3s(kic %in% 1:4, , !logi_p),
         band3(kic %in% 1:4, , !logi_p))
  exp_eq(and3s(kid %in% 1:4, , !logi_v),
         band3(kid %in% 1:4, , !logi_v))
  exp_eq(and3s(kie %in% 1:4, o > 0L, ),
         band3(kie %in% 1:4, o > 0L, ))
  exp_eq(and3s(kif %in% 1:4, c > 1L, ),
         band3(kif %in% 1:4, c > 1L, ))
  exp_eq(and3s(kig %in% 1:4, q > 9L, ),
         band3(kig %in% 1:4, q > 9L, ))
  exp_eq(and3s(kih %in% 1:4, v > 0L, !logi_t),
         band3(kih %in% 1:4, v > 0L, !logi_t))
  exp_eq(and3s(kii %in% 1:4, p > 1L, !logi_g),
         band3(kii %in% 1:4, p > 1L, !logi_g))
  exp_eq(and3s(kij %in% 1:4, r > 9L, !logi_k),
         band3(kij %in% 1:4, r > 9L, !logi_k))
  exp_eq(and3s(kik %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kik %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kil %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kil %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kim %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kim %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kin %in% c(4L, -3L, 2L, 7L, 8L), , g != 0L),
         band3(kin %in% c(4L, -3L, 2L, 7L, 8L), , g != 0L))
  exp_eq(and3s(kio %in% c(4L, -3L, 2L, 7L, 8L), , h != 1L),
         band3(kio %in% c(4L, -3L, 2L, 7L, 8L), , h != 1L))
  exp_eq(and3s(kip %in% c(4L, -3L, 2L, 7L, 8L), , q != 9L),
         band3(kip %in% c(4L, -3L, 2L, 7L, 8L), , q != 9L))
  exp_eq(and3s(kiq %in% c(4L, -3L, 2L, 7L, 8L), m > 0L, ),
         band3(kiq %in% c(4L, -3L, 2L, 7L, 8L), m > 0L, ))
  exp_eq(and3s(kir %in% c(4L, -3L, 2L, 7L, 8L), y > 1L, ),
         band3(kir %in% c(4L, -3L, 2L, 7L, 8L), y > 1L, ))
  exp_eq(and3s(kis %in% c(4L, -3L, 2L, 7L, 8L), k > 9L, ),
         band3(kis %in% c(4L, -3L, 2L, 7L, 8L), k > 9L, ))
  exp_eq(and3s(kit %in% c(4L, -3L, 2L, 7L, 8L), p > 0L, d != 0L),
         band3(kit %in% c(4L, -3L, 2L, 7L, 8L), p > 0L, d != 0L))
  exp_eq(and3s(kiu %in% c(4L, -3L, 2L, 7L, 8L), l > 1L, x != 1L),
         band3(kiu %in% c(4L, -3L, 2L, 7L, 8L), l > 1L, x != 1L))
  exp_eq(and3s(kiv %in% c(4L, -3L, 2L, 7L, 8L), s > 9L, d != 9L),
         band3(kiv %in% c(4L, -3L, 2L, 7L, 8L), s > 9L, d != 9L))
  exp_eq(and3s(kiw %in% 1:4, , ),
         band3(kiw %in% 1:4, , ))
  exp_eq(and3s(kix %in% 1:4, , ),
         band3(kix %in% 1:4, , ))
  exp_eq(and3s(kiy %in% 1:4, , ),
         band3(kiy %in% 1:4, , ))
  exp_eq(and3s(kiz %in% 1:4, , z != 0L),
         band3(kiz %in% 1:4, , z != 0L))
  exp_eq(and3s(kja %in% 1:4, , n != 1L),
         band3(kja %in% 1:4, , n != 1L))
  exp_eq(and3s(kjb %in% 1:4, , b != 9L),
         band3(kjb %in% 1:4, , b != 9L))
  exp_eq(and3s(kjc %in% 1:4, b > 0L, ),
         band3(kjc %in% 1:4, b > 0L, ))
  exp_eq(and3s(kjd %in% 1:4, j > 1L, ),
         band3(kjd %in% 1:4, j > 1L, ))
  exp_eq(and3s(kje %in% 1:4, j > 9L, ),
         band3(kje %in% 1:4, j > 9L, ))
  exp_eq(and3s(kjf %in% 1:4, y > 0L, k != 0L),
         band3(kjf %in% 1:4, y > 0L, k != 0L))
  exp_eq(and3s(kjg %in% 1:4, n > 1L, m != 1L),
         band3(kjg %in% 1:4, n > 1L, m != 1L))
  exp_eq(and3s(kjh %in% 1:4, u > 9L, q != 9L),
         band3(kjh %in% 1:4, u > 9L, q != 9L))
  exp_eq(and3s(kji %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kji %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kjj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kjj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kjk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kjk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kjl %in% c(4L, -3L, 2L, 7L, 8L), , y %between% c(-1L, 1L)),
         band3(kjl %in% c(4L, -3L, 2L, 7L, 8L), , y %between% c(-1L, 1L)))
  exp_eq(and3s(kjm %in% c(4L, -3L, 2L, 7L, 8L), , a %between% c(-1L, 1L)),
         band3(kjm %in% c(4L, -3L, 2L, 7L, 8L), , a %between% c(-1L, 1L)))
  exp_eq(and3s(kjn %in% c(4L, -3L, 2L, 7L, 8L), , c %between% c(-1L, 1L)),
         band3(kjn %in% c(4L, -3L, 2L, 7L, 8L), , c %between% c(-1L, 1L)))
  exp_eq(and3s(kjo %in% c(4L, -3L, 2L, 7L, 8L), v > 0L, ),
         band3(kjo %in% c(4L, -3L, 2L, 7L, 8L), v > 0L, ))
  exp_eq(and3s(kjp %in% c(4L, -3L, 2L, 7L, 8L), z > 1L, ),
         band3(kjp %in% c(4L, -3L, 2L, 7L, 8L), z > 1L, ))
  exp_eq(and3s(kjq %in% c(4L, -3L, 2L, 7L, 8L), k > 9L, ),
         band3(kjq %in% c(4L, -3L, 2L, 7L, 8L), k > 9L, ))
  exp_eq(and3s(kjr %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, u %between% c(-1L, 1L)),
         band3(kjr %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, u %between% c(-1L, 1L)))
  exp_eq(and3s(kjs %in% c(4L, -3L, 2L, 7L, 8L), w > 1L, s %between% c(-1L, 1L)),
         band3(kjs %in% c(4L, -3L, 2L, 7L, 8L), w > 1L, s %between% c(-1L, 1L)))
  exp_eq(and3s(kjt %in% c(4L, -3L, 2L, 7L, 8L), x > 9L, w %between% c(-1L, 1L)),
         band3(kjt %in% c(4L, -3L, 2L, 7L, 8L), x > 9L, w %between% c(-1L, 1L)))
  exp_eq(and3s(kju %in% 1:4, , ),
         band3(kju %in% 1:4, , ))
  exp_eq(and3s(kjv %in% 1:4, , ),
         band3(kjv %in% 1:4, , ))
  exp_eq(and3s(kjw %in% 1:4, , ),
         band3(kjw %in% 1:4, , ))
  exp_eq(and3s(kjx %in% 1:4, , g %between% c(-1L, 1L)),
         band3(kjx %in% 1:4, , g %between% c(-1L, 1L)))
  exp_eq(and3s(kjy %in% 1:4, , e %between% c(-1L, 1L)),
         band3(kjy %in% 1:4, , e %between% c(-1L, 1L)))
  exp_eq(and3s(kjz %in% 1:4, , l %between% c(-1L, 1L)),
         band3(kjz %in% 1:4, , l %between% c(-1L, 1L)))
  exp_eq(and3s(kka %in% 1:4, k > 0L, ),
         band3(kka %in% 1:4, k > 0L, ))
  exp_eq(and3s(kkb %in% 1:4, u > 1L, ),
         band3(kkb %in% 1:4, u > 1L, ))
  exp_eq(and3s(kkc %in% 1:4, p > 9L, ),
         band3(kkc %in% 1:4, p > 9L, ))
  exp_eq(and3s(kkd %in% 1:4, v > 0L, g %between% c(-1L, 1L)),
         band3(kkd %in% 1:4, v > 0L, g %between% c(-1L, 1L)))
  exp_eq(and3s(kke %in% 1:4, d > 1L, i %between% c(-1L, 1L)),
         band3(kke %in% 1:4, d > 1L, i %between% c(-1L, 1L)))
  exp_eq(and3s(kkf %in% 1:4, i > 9L, u %between% c(-1L, 1L)),
         band3(kkf %in% 1:4, i > 9L, u %between% c(-1L, 1L)))
  exp_eq(and3s(kkg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kkg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kkh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kkh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kki %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kki %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kkj %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkj %in% c(4L, -3L, 2L, 7L, 8L), , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kkk %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkk %in% c(4L, -3L, 2L, 7L, 8L), , r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kkl %in% c(4L, -3L, 2L, 7L, 8L), , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkl %in% c(4L, -3L, 2L, 7L, 8L), , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kkm %in% c(4L, -3L, 2L, 7L, 8L), b > 0L, ),
         band3(kkm %in% c(4L, -3L, 2L, 7L, 8L), b > 0L, ))
  exp_eq(and3s(kkn %in% c(4L, -3L, 2L, 7L, 8L), r > 1L, ),
         band3(kkn %in% c(4L, -3L, 2L, 7L, 8L), r > 1L, ))
  exp_eq(and3s(kko %in% c(4L, -3L, 2L, 7L, 8L), l > 9L, ),
         band3(kko %in% c(4L, -3L, 2L, 7L, 8L), l > 9L, ))
  exp_eq(and3s(kkp %in% c(4L, -3L, 2L, 7L, 8L), o > 0L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkp %in% c(4L, -3L, 2L, 7L, 8L), o > 0L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kkq %in% c(4L, -3L, 2L, 7L, 8L), v > 1L, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkq %in% c(4L, -3L, 2L, 7L, 8L), v > 1L, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kkr %in% c(4L, -3L, 2L, 7L, 8L), o > 9L, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(kkr %in% c(4L, -3L, 2L, 7L, 8L), o > 9L, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kks %in% 1:4, , ),
         band3(kks %in% 1:4, , ))
  exp_eq(and3s(kkt %in% 1:4, , ),
         band3(kkt %in% 1:4, , ))
  exp_eq(and3s(kku %in% 1:4, , ),
         band3(kku %in% 1:4, , ))
  exp_eq(and3s(kkv %in% 1:4, , l %in% 1:4),
         band3(kkv %in% 1:4, , l %in% 1:4))
  exp_eq(and3s(kkw %in% 1:4, , k %in% 1:4),
         band3(kkw %in% 1:4, , k %in% 1:4))
  exp_eq(and3s(kkx %in% 1:4, , s %in% 1:4),
         band3(kkx %in% 1:4, , s %in% 1:4))
  exp_eq(and3s(kky %in% 1:4, i > 0L, ),
         band3(kky %in% 1:4, i > 0L, ))
  exp_eq(and3s(kkz %in% 1:4, y > 1L, ),
         band3(kkz %in% 1:4, y > 1L, ))
  exp_eq(and3s(kla %in% 1:4, c > 9L, ),
         band3(kla %in% 1:4, c > 9L, ))
  exp_eq(and3s(klb %in% 1:4, v > 0L, s %in% 1:4),
         band3(klb %in% 1:4, v > 0L, s %in% 1:4))
  exp_eq(and3s(klc %in% 1:4, v > 1L, r %in% 1:4),
         band3(klc %in% 1:4, v > 1L, r %in% 1:4))
  exp_eq(and3s(kld %in% 1:4, u > 9L, b %in% 1:4),
         band3(kld %in% 1:4, u > 9L, b %in% 1:4))
  exp_eq(and3s(kle %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kle %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(klf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(klf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(klg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(klg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(klh %in% c(4L, -3L, 2L, 7L, 8L), , f < 0L),
         band3(klh %in% c(4L, -3L, 2L, 7L, 8L), , f < 0L))
  exp_eq(and3s(kli %in% c(4L, -3L, 2L, 7L, 8L), , x < 1L),
         band3(kli %in% c(4L, -3L, 2L, 7L, 8L), , x < 1L))
  exp_eq(and3s(klj %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L),
         band3(klj %in% c(4L, -3L, 2L, 7L, 8L), , g < 9L))
  exp_eq(and3s(klk %in% c(4L, -3L, 2L, 7L, 8L), z > 0L, ),
         band3(klk %in% c(4L, -3L, 2L, 7L, 8L), z > 0L, ))
  exp_eq(and3s(kll %in% c(4L, -3L, 2L, 7L, 8L), a > 1L, ),
         band3(kll %in% c(4L, -3L, 2L, 7L, 8L), a > 1L, ))
  exp_eq(and3s(klm %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, ),
         band3(klm %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, ))
  exp_eq(and3s(kln %in% c(4L, -3L, 2L, 7L, 8L), d > 0L, t < 0L),
         band3(kln %in% c(4L, -3L, 2L, 7L, 8L), d > 0L, t < 0L))
  exp_eq(and3s(klo %in% c(4L, -3L, 2L, 7L, 8L), g > 1L, i < 1L),
         band3(klo %in% c(4L, -3L, 2L, 7L, 8L), g > 1L, i < 1L))
  exp_eq(and3s(klp %in% c(4L, -3L, 2L, 7L, 8L), p > 9L, s < 9L),
         band3(klp %in% c(4L, -3L, 2L, 7L, 8L), p > 9L, s < 9L))
  exp_eq(and3s(klq %in% 1:4, , ),
         band3(klq %in% 1:4, , ))
  exp_eq(and3s(klr %in% 1:4, , ),
         band3(klr %in% 1:4, , ))
  exp_eq(and3s(kls %in% 1:4, , ),
         band3(kls %in% 1:4, , ))
  exp_eq(and3s(klt %in% 1:4, , k < 0L),
         band3(klt %in% 1:4, , k < 0L))
  exp_eq(and3s(klu %in% 1:4, , c < 1L),
         band3(klu %in% 1:4, , c < 1L))
  exp_eq(and3s(klv %in% 1:4, , d < 9L),
         band3(klv %in% 1:4, , d < 9L))
  exp_eq(and3s(klw %in% 1:4, x > 0L, ),
         band3(klw %in% 1:4, x > 0L, ))
  exp_eq(and3s(klx %in% 1:4, f > 1L, ),
         band3(klx %in% 1:4, f > 1L, ))
  exp_eq(and3s(kly %in% 1:4, n > 9L, ),
         band3(kly %in% 1:4, n > 9L, ))
  exp_eq(and3s(klz %in% 1:4, u > 0L, i < 0L),
         band3(klz %in% 1:4, u > 0L, i < 0L))
  exp_eq(and3s(kma %in% 1:4, t > 1L, u < 1L),
         band3(kma %in% 1:4, t > 1L, u < 1L))
  exp_eq(and3s(kmb %in% 1:4, p > 9L, w < 9L),
         band3(kmb %in% 1:4, p > 9L, w < 9L))
  exp_eq(and3s(kmc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kmc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kmd %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kmd %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kme %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kme %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kmf %in% c(4L, -3L, 2L, 7L, 8L), , e <= 0L),
         band3(kmf %in% c(4L, -3L, 2L, 7L, 8L), , e <= 0L))
  exp_eq(and3s(kmg %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L),
         band3(kmg %in% c(4L, -3L, 2L, 7L, 8L), , i <= 1L))
  exp_eq(and3s(kmh %in% c(4L, -3L, 2L, 7L, 8L), , c <= 9L),
         band3(kmh %in% c(4L, -3L, 2L, 7L, 8L), , c <= 9L))
  exp_eq(and3s(kmi %in% c(4L, -3L, 2L, 7L, 8L), o > 0L, ),
         band3(kmi %in% c(4L, -3L, 2L, 7L, 8L), o > 0L, ))
  exp_eq(and3s(kmj %in% c(4L, -3L, 2L, 7L, 8L), u > 1L, ),
         band3(kmj %in% c(4L, -3L, 2L, 7L, 8L), u > 1L, ))
  exp_eq(and3s(kmk %in% c(4L, -3L, 2L, 7L, 8L), z > 9L, ),
         band3(kmk %in% c(4L, -3L, 2L, 7L, 8L), z > 9L, ))
  exp_eq(and3s(kml %in% c(4L, -3L, 2L, 7L, 8L), j > 0L, o <= 0L),
         band3(kml %in% c(4L, -3L, 2L, 7L, 8L), j > 0L, o <= 0L))
  exp_eq(and3s(kmm %in% c(4L, -3L, 2L, 7L, 8L), p > 1L, b <= 1L),
         band3(kmm %in% c(4L, -3L, 2L, 7L, 8L), p > 1L, b <= 1L))
  exp_eq(and3s(kmn %in% c(4L, -3L, 2L, 7L, 8L), n > 9L, v <= 9L),
         band3(kmn %in% c(4L, -3L, 2L, 7L, 8L), n > 9L, v <= 9L))
  exp_eq(and3s(kmo %in% 1:4, , ),
         band3(kmo %in% 1:4, , ))
  exp_eq(and3s(kmp %in% 1:4, , ),
         band3(kmp %in% 1:4, , ))
  exp_eq(and3s(kmq %in% 1:4, , ),
         band3(kmq %in% 1:4, , ))
  exp_eq(and3s(kmr %in% 1:4, , b <= 0L),
         band3(kmr %in% 1:4, , b <= 0L))
  exp_eq(and3s(kms %in% 1:4, , l <= 1L),
         band3(kms %in% 1:4, , l <= 1L))
  exp_eq(and3s(kmt %in% 1:4, , q <= 9L),
         band3(kmt %in% 1:4, , q <= 9L))
  exp_eq(and3s(kmu %in% 1:4, s > 0L, ),
         band3(kmu %in% 1:4, s > 0L, ))
  exp_eq(and3s(kmv %in% 1:4, k > 1L, ),
         band3(kmv %in% 1:4, k > 1L, ))
  exp_eq(and3s(kmw %in% 1:4, r > 9L, ),
         band3(kmw %in% 1:4, r > 9L, ))
  exp_eq(and3s(kmx %in% 1:4, v > 0L, y <= 0L),
         band3(kmx %in% 1:4, v > 0L, y <= 0L))
  exp_eq(and3s(kmy %in% 1:4, v > 1L, v <= 1L),
         band3(kmy %in% 1:4, v > 1L, v <= 1L))
  exp_eq(and3s(kmz %in% 1:4, k > 9L, l <= 9L),
         band3(kmz %in% 1:4, k > 9L, l <= 9L))
  exp_eq(and3s(kna %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kna %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(knb %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(knb %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(knc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(knc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(knd %in% c(4L, -3L, 2L, 7L, 8L), , i == 0L),
         band3(knd %in% c(4L, -3L, 2L, 7L, 8L), , i == 0L))
  exp_eq(and3s(kne %in% c(4L, -3L, 2L, 7L, 8L), , w == 1L),
         band3(kne %in% c(4L, -3L, 2L, 7L, 8L), , w == 1L))
  exp_eq(and3s(knf %in% c(4L, -3L, 2L, 7L, 8L), , l == 9L),
         band3(knf %in% c(4L, -3L, 2L, 7L, 8L), , l == 9L))
  exp_eq(and3s(kng %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, ),
         band3(kng %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, ))
  exp_eq(and3s(knh %in% c(4L, -3L, 2L, 7L, 8L), h > 1L, ),
         band3(knh %in% c(4L, -3L, 2L, 7L, 8L), h > 1L, ))
  exp_eq(and3s(kni %in% c(4L, -3L, 2L, 7L, 8L), b > 9L, ),
         band3(kni %in% c(4L, -3L, 2L, 7L, 8L), b > 9L, ))
  exp_eq(and3s(knj %in% c(4L, -3L, 2L, 7L, 8L), c > 0L, t == 0L),
         band3(knj %in% c(4L, -3L, 2L, 7L, 8L), c > 0L, t == 0L))
  exp_eq(and3s(knk %in% c(4L, -3L, 2L, 7L, 8L), h > 1L, v == 1L),
         band3(knk %in% c(4L, -3L, 2L, 7L, 8L), h > 1L, v == 1L))
  exp_eq(and3s(knl %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, b == 9L),
         band3(knl %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, b == 9L))
  exp_eq(and3s(knm %in% 1:4, , ),
         band3(knm %in% 1:4, , ))
  exp_eq(and3s(knn %in% 1:4, , ),
         band3(knn %in% 1:4, , ))
  exp_eq(and3s(kno %in% 1:4, , ),
         band3(kno %in% 1:4, , ))
  exp_eq(and3s(knp %in% 1:4, , w == 0L),
         band3(knp %in% 1:4, , w == 0L))
  exp_eq(and3s(knq %in% 1:4, , h == 1L),
         band3(knq %in% 1:4, , h == 1L))
  exp_eq(and3s(knr %in% 1:4, , h == 9L),
         band3(knr %in% 1:4, , h == 9L))
  exp_eq(and3s(kns %in% 1:4, u > 0L, ),
         band3(kns %in% 1:4, u > 0L, ))
  exp_eq(and3s(knt %in% 1:4, y > 1L, ),
         band3(knt %in% 1:4, y > 1L, ))
  exp_eq(and3s(knu %in% 1:4, c > 9L, ),
         band3(knu %in% 1:4, c > 9L, ))
  exp_eq(and3s(knv %in% 1:4, f > 0L, k == 0L),
         band3(knv %in% 1:4, f > 0L, k == 0L))
  exp_eq(and3s(knw %in% 1:4, f > 1L, m == 1L),
         band3(knw %in% 1:4, f > 1L, m == 1L))
  exp_eq(and3s(knx %in% 1:4, m > 9L, e == 9L),
         band3(knx %in% 1:4, m > 9L, e == 9L))
  exp_eq(and3s(kny %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kny %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(knz %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(knz %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(koa %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(koa %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kob %in% c(4L, -3L, 2L, 7L, 8L), , n > 0L),
         band3(kob %in% c(4L, -3L, 2L, 7L, 8L), , n > 0L))
  exp_eq(and3s(koc %in% c(4L, -3L, 2L, 7L, 8L), , o > 1L),
         band3(koc %in% c(4L, -3L, 2L, 7L, 8L), , o > 1L))
  exp_eq(and3s(kod %in% c(4L, -3L, 2L, 7L, 8L), , h > 9L),
         band3(kod %in% c(4L, -3L, 2L, 7L, 8L), , h > 9L))
  exp_eq(and3s(koe %in% c(4L, -3L, 2L, 7L, 8L), r > 0L, ),
         band3(koe %in% c(4L, -3L, 2L, 7L, 8L), r > 0L, ))
  exp_eq(and3s(kof %in% c(4L, -3L, 2L, 7L, 8L), d > 1L, ),
         band3(kof %in% c(4L, -3L, 2L, 7L, 8L), d > 1L, ))
  exp_eq(and3s(kog %in% c(4L, -3L, 2L, 7L, 8L), a > 9L, ),
         band3(kog %in% c(4L, -3L, 2L, 7L, 8L), a > 9L, ))
  exp_eq(and3s(koh %in% c(4L, -3L, 2L, 7L, 8L), i > 0L, u > 0L),
         band3(koh %in% c(4L, -3L, 2L, 7L, 8L), i > 0L, u > 0L))
  exp_eq(and3s(koi %in% c(4L, -3L, 2L, 7L, 8L), y > 1L, a > 1L),
         band3(koi %in% c(4L, -3L, 2L, 7L, 8L), y > 1L, a > 1L))
  exp_eq(and3s(koj %in% c(4L, -3L, 2L, 7L, 8L), g > 9L, r > 9L),
         band3(koj %in% c(4L, -3L, 2L, 7L, 8L), g > 9L, r > 9L))
  exp_eq(and3s(kok %in% 1:4, , ),
         band3(kok %in% 1:4, , ))
  exp_eq(and3s(kol %in% 1:4, , ),
         band3(kol %in% 1:4, , ))
  exp_eq(and3s(kom %in% 1:4, , ),
         band3(kom %in% 1:4, , ))
  exp_eq(and3s(kon %in% 1:4, , v > 0L),
         band3(kon %in% 1:4, , v > 0L))
  exp_eq(and3s(koo %in% 1:4, , g > 1L),
         band3(koo %in% 1:4, , g > 1L))
  exp_eq(and3s(kop %in% 1:4, , q > 9L),
         band3(kop %in% 1:4, , q > 9L))
  exp_eq(and3s(koq %in% 1:4, j > 0L, ),
         band3(koq %in% 1:4, j > 0L, ))
  exp_eq(and3s(kor %in% 1:4, m > 1L, ),
         band3(kor %in% 1:4, m > 1L, ))
  exp_eq(and3s(kos %in% 1:4, e > 9L, ),
         band3(kos %in% 1:4, e > 9L, ))
  exp_eq(and3s(kot %in% 1:4, l > 0L, r > 0L),
         band3(kot %in% 1:4, l > 0L, r > 0L))
  exp_eq(and3s(kou %in% 1:4, h > 1L, c > 1L),
         band3(kou %in% 1:4, h > 1L, c > 1L))
  exp_eq(and3s(kov %in% 1:4, e > 9L, a > 9L),
         band3(kov %in% 1:4, e > 9L, a > 9L))
  exp_eq(and3s(kow %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kow %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kox %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kox %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(koy %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(koy %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(koz %in% c(4L, -3L, 2L, 7L, 8L), , y >= 0L),
         band3(koz %in% c(4L, -3L, 2L, 7L, 8L), , y >= 0L))
  exp_eq(and3s(kpa %in% c(4L, -3L, 2L, 7L, 8L), , c >= 1L),
         band3(kpa %in% c(4L, -3L, 2L, 7L, 8L), , c >= 1L))
  exp_eq(and3s(kpb %in% c(4L, -3L, 2L, 7L, 8L), , a >= 9L),
         band3(kpb %in% c(4L, -3L, 2L, 7L, 8L), , a >= 9L))
  exp_eq(and3s(kpc %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, ),
         band3(kpc %in% c(4L, -3L, 2L, 7L, 8L), g > 0L, ))
  exp_eq(and3s(kpd %in% c(4L, -3L, 2L, 7L, 8L), l > 1L, ),
         band3(kpd %in% c(4L, -3L, 2L, 7L, 8L), l > 1L, ))
  exp_eq(and3s(kpe %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, ),
         band3(kpe %in% c(4L, -3L, 2L, 7L, 8L), t > 9L, ))
  exp_eq(and3s(kpf %in% c(4L, -3L, 2L, 7L, 8L), z > 0L, y >= 0L),
         band3(kpf %in% c(4L, -3L, 2L, 7L, 8L), z > 0L, y >= 0L))
  exp_eq(and3s(kpg %in% c(4L, -3L, 2L, 7L, 8L), r > 1L, b >= 1L),
         band3(kpg %in% c(4L, -3L, 2L, 7L, 8L), r > 1L, b >= 1L))
  exp_eq(and3s(kph %in% c(4L, -3L, 2L, 7L, 8L), e > 9L, p >= 9L),
         band3(kph %in% c(4L, -3L, 2L, 7L, 8L), e > 9L, p >= 9L))
  exp_eq(and3s(kpi %in% 1:4, , ),
         band3(kpi %in% 1:4, , ))
  exp_eq(and3s(kpj %in% 1:4, , ),
         band3(kpj %in% 1:4, , ))
  exp_eq(and3s(kpk %in% 1:4, , ),
         band3(kpk %in% 1:4, , ))
  exp_eq(and3s(kpl %in% 1:4, , u >= 0L),
         band3(kpl %in% 1:4, , u >= 0L))
  exp_eq(and3s(kpm %in% 1:4, , r >= 1L),
         band3(kpm %in% 1:4, , r >= 1L))
  exp_eq(and3s(kpn %in% 1:4, , y >= 9L),
         band3(kpn %in% 1:4, , y >= 9L))
  exp_eq(and3s(kpo %in% 1:4, v > 0L, ),
         band3(kpo %in% 1:4, v > 0L, ))
  exp_eq(and3s(kpp %in% 1:4, z > 1L, ),
         band3(kpp %in% 1:4, z > 1L, ))
  exp_eq(and3s(kpq %in% 1:4, h > 9L, ),
         band3(kpq %in% 1:4, h > 9L, ))
  exp_eq(and3s(kpr %in% 1:4, a > 0L, b >= 0L),
         band3(kpr %in% 1:4, a > 0L, b >= 0L))
  exp_eq(and3s(kps %in% 1:4, e > 1L, q >= 1L),
         band3(kps %in% 1:4, e > 1L, q >= 1L))
  exp_eq(and3s(kpt %in% 1:4, w > 9L, r >= 9L),
         band3(kpt %in% 1:4, w > 9L, r >= 9L))
  exp_eq(and3s(kpu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kpu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kpv %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kpv %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kpw %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kpw %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kpx %in% c(4L, -3L, 2L, 7L, 8L), , logi_v),
         band3(kpx %in% c(4L, -3L, 2L, 7L, 8L), , logi_v))
  exp_eq(and3s(kpy %in% c(4L, -3L, 2L, 7L, 8L), , logi_h),
         band3(kpy %in% c(4L, -3L, 2L, 7L, 8L), , logi_h))
  exp_eq(and3s(kpz %in% c(4L, -3L, 2L, 7L, 8L), , logi_k),
         band3(kpz %in% c(4L, -3L, 2L, 7L, 8L), , logi_k))
  exp_eq(and3s(kqa %in% c(4L, -3L, 2L, 7L, 8L), b >= 0L, ),
         band3(kqa %in% c(4L, -3L, 2L, 7L, 8L), b >= 0L, ))
  exp_eq(and3s(kqb %in% c(4L, -3L, 2L, 7L, 8L), x >= 1L, ),
         band3(kqb %in% c(4L, -3L, 2L, 7L, 8L), x >= 1L, ))
  exp_eq(and3s(kqc %in% c(4L, -3L, 2L, 7L, 8L), i >= 9L, ),
         band3(kqc %in% c(4L, -3L, 2L, 7L, 8L), i >= 9L, ))
  exp_eq(and3s(kqd %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, logi_c),
         band3(kqd %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, logi_c))
  exp_eq(and3s(kqe %in% c(4L, -3L, 2L, 7L, 8L), y >= 1L, logi_i),
         band3(kqe %in% c(4L, -3L, 2L, 7L, 8L), y >= 1L, logi_i))
  exp_eq(and3s(kqf %in% c(4L, -3L, 2L, 7L, 8L), w >= 9L, logi_y),
         band3(kqf %in% c(4L, -3L, 2L, 7L, 8L), w >= 9L, logi_y))
  exp_eq(and3s(kqg %in% 1:4, , ),
         band3(kqg %in% 1:4, , ))
  exp_eq(and3s(kqh %in% 1:4, , ),
         band3(kqh %in% 1:4, , ))
  exp_eq(and3s(kqi %in% 1:4, , ),
         band3(kqi %in% 1:4, , ))
  exp_eq(and3s(kqj %in% 1:4, , logi_b),
         band3(kqj %in% 1:4, , logi_b))
  exp_eq(and3s(kqk %in% 1:4, , logi_o),
         band3(kqk %in% 1:4, , logi_o))
  exp_eq(and3s(kql %in% 1:4, , logi_m),
         band3(kql %in% 1:4, , logi_m))
  exp_eq(and3s(kqm %in% 1:4, e >= 0L, ),
         band3(kqm %in% 1:4, e >= 0L, ))
  exp_eq(and3s(kqn %in% 1:4, s >= 1L, ),
         band3(kqn %in% 1:4, s >= 1L, ))
  exp_eq(and3s(kqo %in% 1:4, d >= 9L, ),
         band3(kqo %in% 1:4, d >= 9L, ))
  exp_eq(and3s(kqp %in% 1:4, u >= 0L, logi_n),
         band3(kqp %in% 1:4, u >= 0L, logi_n))
  exp_eq(and3s(kqq %in% 1:4, s >= 1L, logi_k),
         band3(kqq %in% 1:4, s >= 1L, logi_k))
  exp_eq(and3s(kqr %in% 1:4, h >= 9L, logi_n),
         band3(kqr %in% 1:4, h >= 9L, logi_n))
  exp_eq(and3s(kqs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kqs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kqt %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kqt %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kqu %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kqu %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kqv %in% c(4L, -3L, 2L, 7L, 8L), , !logi_b),
         band3(kqv %in% c(4L, -3L, 2L, 7L, 8L), , !logi_b))
  exp_eq(and3s(kqw %in% c(4L, -3L, 2L, 7L, 8L), , !logi_m),
         band3(kqw %in% c(4L, -3L, 2L, 7L, 8L), , !logi_m))
  exp_eq(and3s(kqx %in% c(4L, -3L, 2L, 7L, 8L), , !logi_x),
         band3(kqx %in% c(4L, -3L, 2L, 7L, 8L), , !logi_x))
  exp_eq(and3s(kqy %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L, ),
         band3(kqy %in% c(4L, -3L, 2L, 7L, 8L), r >= 0L, ))
  exp_eq(and3s(kqz %in% c(4L, -3L, 2L, 7L, 8L), f >= 1L, ),
         band3(kqz %in% c(4L, -3L, 2L, 7L, 8L), f >= 1L, ))
  exp_eq(and3s(kra %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L, ),
         band3(kra %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L, ))
  exp_eq(and3s(krb %in% c(4L, -3L, 2L, 7L, 8L), q >= 0L, !logi_f),
         band3(krb %in% c(4L, -3L, 2L, 7L, 8L), q >= 0L, !logi_f))
  exp_eq(and3s(krc %in% c(4L, -3L, 2L, 7L, 8L), e >= 1L, !logi_l),
         band3(krc %in% c(4L, -3L, 2L, 7L, 8L), e >= 1L, !logi_l))
  exp_eq(and3s(krd %in% c(4L, -3L, 2L, 7L, 8L), t >= 9L, !logi_t),
         band3(krd %in% c(4L, -3L, 2L, 7L, 8L), t >= 9L, !logi_t))
  exp_eq(and3s(kre %in% 1:4, , ),
         band3(kre %in% 1:4, , ))
  exp_eq(and3s(krf %in% 1:4, , ),
         band3(krf %in% 1:4, , ))
  exp_eq(and3s(krg %in% 1:4, , ),
         band3(krg %in% 1:4, , ))
  exp_eq(and3s(krh %in% 1:4, , !logi_d),
         band3(krh %in% 1:4, , !logi_d))
  exp_eq(and3s(kri %in% 1:4, , !logi_r),
         band3(kri %in% 1:4, , !logi_r))
  exp_eq(and3s(krj %in% 1:4, , !logi_n),
         band3(krj %in% 1:4, , !logi_n))
  exp_eq(and3s(krk %in% 1:4, q >= 0L, ),
         band3(krk %in% 1:4, q >= 0L, ))
  exp_eq(and3s(krl %in% 1:4, z >= 1L, ),
         band3(krl %in% 1:4, z >= 1L, ))
  exp_eq(and3s(krm %in% 1:4, j >= 9L, ),
         band3(krm %in% 1:4, j >= 9L, ))
  exp_eq(and3s(krn %in% 1:4, b >= 0L, !logi_q),
         band3(krn %in% 1:4, b >= 0L, !logi_q))
  exp_eq(and3s(kro %in% 1:4, q >= 1L, !logi_y),
         band3(kro %in% 1:4, q >= 1L, !logi_y))
  exp_eq(and3s(krp %in% 1:4, f >= 9L, !logi_z),
         band3(krp %in% 1:4, f >= 9L, !logi_z))
  exp_eq(and3s(krq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(krq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(krr %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(krr %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(krs %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(krs %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(krt %in% c(4L, -3L, 2L, 7L, 8L), , o != 0L),
         band3(krt %in% c(4L, -3L, 2L, 7L, 8L), , o != 0L))
  exp_eq(and3s(kru %in% c(4L, -3L, 2L, 7L, 8L), , e != 1L),
         band3(kru %in% c(4L, -3L, 2L, 7L, 8L), , e != 1L))
  exp_eq(and3s(krv %in% c(4L, -3L, 2L, 7L, 8L), , z != 9L),
         band3(krv %in% c(4L, -3L, 2L, 7L, 8L), , z != 9L))
  exp_eq(and3s(krw %in% c(4L, -3L, 2L, 7L, 8L), k >= 0L, ),
         band3(krw %in% c(4L, -3L, 2L, 7L, 8L), k >= 0L, ))
  exp_eq(and3s(krx %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L, ),
         band3(krx %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L, ))
  exp_eq(and3s(kry %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L, ),
         band3(kry %in% c(4L, -3L, 2L, 7L, 8L), l >= 9L, ))
  exp_eq(and3s(krz %in% c(4L, -3L, 2L, 7L, 8L), q >= 0L, c != 0L),
         band3(krz %in% c(4L, -3L, 2L, 7L, 8L), q >= 0L, c != 0L))
  exp_eq(and3s(ksa %in% c(4L, -3L, 2L, 7L, 8L), m >= 1L, y != 1L),
         band3(ksa %in% c(4L, -3L, 2L, 7L, 8L), m >= 1L, y != 1L))
  exp_eq(and3s(ksb %in% c(4L, -3L, 2L, 7L, 8L), p >= 9L, f != 9L),
         band3(ksb %in% c(4L, -3L, 2L, 7L, 8L), p >= 9L, f != 9L))
  exp_eq(and3s(ksc %in% 1:4, , ),
         band3(ksc %in% 1:4, , ))
  exp_eq(and3s(ksd %in% 1:4, , ),
         band3(ksd %in% 1:4, , ))
  exp_eq(and3s(kse %in% 1:4, , ),
         band3(kse %in% 1:4, , ))
  exp_eq(and3s(ksf %in% 1:4, , g != 0L),
         band3(ksf %in% 1:4, , g != 0L))
  exp_eq(and3s(ksg %in% 1:4, , q != 1L),
         band3(ksg %in% 1:4, , q != 1L))
  exp_eq(and3s(ksh %in% 1:4, , s != 9L),
         band3(ksh %in% 1:4, , s != 9L))
  exp_eq(and3s(ksi %in% 1:4, y >= 0L, ),
         band3(ksi %in% 1:4, y >= 0L, ))
  exp_eq(and3s(ksj %in% 1:4, f >= 1L, ),
         band3(ksj %in% 1:4, f >= 1L, ))
  exp_eq(and3s(ksk %in% 1:4, b >= 9L, ),
         band3(ksk %in% 1:4, b >= 9L, ))
  exp_eq(and3s(ksl %in% 1:4, v >= 0L, r != 0L),
         band3(ksl %in% 1:4, v >= 0L, r != 0L))
  exp_eq(and3s(ksm %in% 1:4, d >= 1L, n != 1L),
         band3(ksm %in% 1:4, d >= 1L, n != 1L))
  exp_eq(and3s(ksn %in% 1:4, b >= 9L, u != 9L),
         band3(ksn %in% 1:4, b >= 9L, u != 9L))
  exp_eq(and3s(kso %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kso %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ksp %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ksp %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ksq %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ksq %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ksr %in% c(4L, -3L, 2L, 7L, 8L), , b %between% c(-1L, 1L)),
         band3(ksr %in% c(4L, -3L, 2L, 7L, 8L), , b %between% c(-1L, 1L)))
  exp_eq(and3s(kss %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)),
         band3(kss %in% c(4L, -3L, 2L, 7L, 8L), , p %between% c(-1L, 1L)))
  exp_eq(and3s(kst %in% c(4L, -3L, 2L, 7L, 8L), , y %between% c(-1L, 1L)),
         band3(kst %in% c(4L, -3L, 2L, 7L, 8L), , y %between% c(-1L, 1L)))
  exp_eq(and3s(ksu %in% c(4L, -3L, 2L, 7L, 8L), v >= 0L, ),
         band3(ksu %in% c(4L, -3L, 2L, 7L, 8L), v >= 0L, ))
  exp_eq(and3s(ksv %in% c(4L, -3L, 2L, 7L, 8L), o >= 1L, ),
         band3(ksv %in% c(4L, -3L, 2L, 7L, 8L), o >= 1L, ))
  exp_eq(and3s(ksw %in% c(4L, -3L, 2L, 7L, 8L), m >= 9L, ),
         band3(ksw %in% c(4L, -3L, 2L, 7L, 8L), m >= 9L, ))
  exp_eq(and3s(ksx %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, e %between% c(-1L, 1L)),
         band3(ksx %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, e %between% c(-1L, 1L)))
  exp_eq(and3s(ksy %in% c(4L, -3L, 2L, 7L, 8L), e >= 1L, t %between% c(-1L, 1L)),
         band3(ksy %in% c(4L, -3L, 2L, 7L, 8L), e >= 1L, t %between% c(-1L, 1L)))
  exp_eq(and3s(ksz %in% c(4L, -3L, 2L, 7L, 8L), w >= 9L, a %between% c(-1L, 1L)),
         band3(ksz %in% c(4L, -3L, 2L, 7L, 8L), w >= 9L, a %between% c(-1L, 1L)))
  exp_eq(and3s(kta %in% 1:4, , ),
         band3(kta %in% 1:4, , ))
  exp_eq(and3s(ktb %in% 1:4, , ),
         band3(ktb %in% 1:4, , ))
  exp_eq(and3s(ktc %in% 1:4, , ),
         band3(ktc %in% 1:4, , ))
  exp_eq(and3s(ktd %in% 1:4, , a %between% c(-1L, 1L)),
         band3(ktd %in% 1:4, , a %between% c(-1L, 1L)))
  exp_eq(and3s(kte %in% 1:4, , u %between% c(-1L, 1L)),
         band3(kte %in% 1:4, , u %between% c(-1L, 1L)))
  exp_eq(and3s(ktf %in% 1:4, , n %between% c(-1L, 1L)),
         band3(ktf %in% 1:4, , n %between% c(-1L, 1L)))
  exp_eq(and3s(ktg %in% 1:4, f >= 0L, ),
         band3(ktg %in% 1:4, f >= 0L, ))
  exp_eq(and3s(kth %in% 1:4, l >= 1L, ),
         band3(kth %in% 1:4, l >= 1L, ))
  exp_eq(and3s(kti %in% 1:4, l >= 9L, ),
         band3(kti %in% 1:4, l >= 9L, ))
  exp_eq(and3s(ktj %in% 1:4, l >= 0L, f %between% c(-1L, 1L)),
         band3(ktj %in% 1:4, l >= 0L, f %between% c(-1L, 1L)))
  exp_eq(and3s(ktk %in% 1:4, g >= 1L, a %between% c(-1L, 1L)),
         band3(ktk %in% 1:4, g >= 1L, a %between% c(-1L, 1L)))
  exp_eq(and3s(ktl %in% 1:4, m >= 9L, r %between% c(-1L, 1L)),
         band3(ktl %in% 1:4, m >= 9L, r %between% c(-1L, 1L)))
  exp_eq(and3s(ktm %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ktm %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ktn %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(ktn %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kto %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kto %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(ktp %in% c(4L, -3L, 2L, 7L, 8L), , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktp %in% c(4L, -3L, 2L, 7L, 8L), , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ktq %in% c(4L, -3L, 2L, 7L, 8L), , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktq %in% c(4L, -3L, 2L, 7L, 8L), , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ktr %in% c(4L, -3L, 2L, 7L, 8L), , y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktr %in% c(4L, -3L, 2L, 7L, 8L), , y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kts %in% c(4L, -3L, 2L, 7L, 8L), c >= 0L, ),
         band3(kts %in% c(4L, -3L, 2L, 7L, 8L), c >= 0L, ))
  exp_eq(and3s(ktt %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, ),
         band3(ktt %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, ))
  exp_eq(and3s(ktu %in% c(4L, -3L, 2L, 7L, 8L), p >= 9L, ),
         band3(ktu %in% c(4L, -3L, 2L, 7L, 8L), p >= 9L, ))
  exp_eq(and3s(ktv %in% c(4L, -3L, 2L, 7L, 8L), g >= 0L, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktv %in% c(4L, -3L, 2L, 7L, 8L), g >= 0L, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ktw %in% c(4L, -3L, 2L, 7L, 8L), k >= 1L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktw %in% c(4L, -3L, 2L, 7L, 8L), k >= 1L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ktx %in% c(4L, -3L, 2L, 7L, 8L), j >= 9L, t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ktx %in% c(4L, -3L, 2L, 7L, 8L), j >= 9L, t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(kty %in% 1:4, , ),
         band3(kty %in% 1:4, , ))
  exp_eq(and3s(ktz %in% 1:4, , ),
         band3(ktz %in% 1:4, , ))
  exp_eq(and3s(kua %in% 1:4, , ),
         band3(kua %in% 1:4, , ))
  exp_eq(and3s(kub %in% 1:4, , t %in% 1:4),
         band3(kub %in% 1:4, , t %in% 1:4))
  exp_eq(and3s(kuc %in% 1:4, , q %in% 1:4),
         band3(kuc %in% 1:4, , q %in% 1:4))
  exp_eq(and3s(kud %in% 1:4, , g %in% 1:4),
         band3(kud %in% 1:4, , g %in% 1:4))
  exp_eq(and3s(kue %in% 1:4, b >= 0L, ),
         band3(kue %in% 1:4, b >= 0L, ))
  exp_eq(and3s(kuf %in% 1:4, v >= 1L, ),
         band3(kuf %in% 1:4, v >= 1L, ))
  exp_eq(and3s(kug %in% 1:4, n >= 9L, ),
         band3(kug %in% 1:4, n >= 9L, ))
  exp_eq(and3s(kuh %in% 1:4, g >= 0L, g %in% 1:4),
         band3(kuh %in% 1:4, g >= 0L, g %in% 1:4))
  exp_eq(and3s(kui %in% 1:4, h >= 1L, y %in% 1:4),
         band3(kui %in% 1:4, h >= 1L, y %in% 1:4))
  exp_eq(and3s(kuj %in% 1:4, n >= 9L, x %in% 1:4),
         band3(kuj %in% 1:4, n >= 9L, x %in% 1:4))
  exp_eq(and3s(kuk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kuk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kul %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kul %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kum %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kum %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kun %in% c(4L, -3L, 2L, 7L, 8L), , q < 0L),
         band3(kun %in% c(4L, -3L, 2L, 7L, 8L), , q < 0L))
  exp_eq(and3s(kuo %in% c(4L, -3L, 2L, 7L, 8L), , r < 1L),
         band3(kuo %in% c(4L, -3L, 2L, 7L, 8L), , r < 1L))
  exp_eq(and3s(kup %in% c(4L, -3L, 2L, 7L, 8L), , f < 9L),
         band3(kup %in% c(4L, -3L, 2L, 7L, 8L), , f < 9L))
  exp_eq(and3s(kuq %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, ),
         band3(kuq %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, ))
  exp_eq(and3s(kur %in% c(4L, -3L, 2L, 7L, 8L), y >= 1L, ),
         band3(kur %in% c(4L, -3L, 2L, 7L, 8L), y >= 1L, ))
  exp_eq(and3s(kus %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L, ),
         band3(kus %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L, ))
  exp_eq(and3s(kut %in% c(4L, -3L, 2L, 7L, 8L), t >= 0L, c < 0L),
         band3(kut %in% c(4L, -3L, 2L, 7L, 8L), t >= 0L, c < 0L))
  exp_eq(and3s(kuu %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L, r < 1L),
         band3(kuu %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L, r < 1L))
  exp_eq(and3s(kuv %in% c(4L, -3L, 2L, 7L, 8L), q >= 9L, e < 9L),
         band3(kuv %in% c(4L, -3L, 2L, 7L, 8L), q >= 9L, e < 9L))
  exp_eq(and3s(kuw %in% 1:4, , ),
         band3(kuw %in% 1:4, , ))
  exp_eq(and3s(kux %in% 1:4, , ),
         band3(kux %in% 1:4, , ))
  exp_eq(and3s(kuy %in% 1:4, , ),
         band3(kuy %in% 1:4, , ))
  exp_eq(and3s(kuz %in% 1:4, , x < 0L),
         band3(kuz %in% 1:4, , x < 0L))
  exp_eq(and3s(kva %in% 1:4, , i < 1L),
         band3(kva %in% 1:4, , i < 1L))
  exp_eq(and3s(kvb %in% 1:4, , z < 9L),
         band3(kvb %in% 1:4, , z < 9L))
  exp_eq(and3s(kvc %in% 1:4, x >= 0L, ),
         band3(kvc %in% 1:4, x >= 0L, ))
  exp_eq(and3s(kvd %in% 1:4, p >= 1L, ),
         band3(kvd %in% 1:4, p >= 1L, ))
  exp_eq(and3s(kve %in% 1:4, h >= 9L, ),
         band3(kve %in% 1:4, h >= 9L, ))
  exp_eq(and3s(kvf %in% 1:4, a >= 0L, b < 0L),
         band3(kvf %in% 1:4, a >= 0L, b < 0L))
  exp_eq(and3s(kvg %in% 1:4, r >= 1L, c < 1L),
         band3(kvg %in% 1:4, r >= 1L, c < 1L))
  exp_eq(and3s(kvh %in% 1:4, b >= 9L, d < 9L),
         band3(kvh %in% 1:4, b >= 9L, d < 9L))
  exp_eq(and3s(kvi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kvi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kvj %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kvj %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kvk %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kvk %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kvl %in% c(4L, -3L, 2L, 7L, 8L), , l <= 0L),
         band3(kvl %in% c(4L, -3L, 2L, 7L, 8L), , l <= 0L))
  exp_eq(and3s(kvm %in% c(4L, -3L, 2L, 7L, 8L), , r <= 1L),
         band3(kvm %in% c(4L, -3L, 2L, 7L, 8L), , r <= 1L))
  exp_eq(and3s(kvn %in% c(4L, -3L, 2L, 7L, 8L), , x <= 9L),
         band3(kvn %in% c(4L, -3L, 2L, 7L, 8L), , x <= 9L))
  exp_eq(and3s(kvo %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, ),
         band3(kvo %in% c(4L, -3L, 2L, 7L, 8L), e >= 0L, ))
  exp_eq(and3s(kvp %in% c(4L, -3L, 2L, 7L, 8L), b >= 1L, ),
         band3(kvp %in% c(4L, -3L, 2L, 7L, 8L), b >= 1L, ))
  exp_eq(and3s(kvq %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L, ),
         band3(kvq %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L, ))
  exp_eq(and3s(kvr %in% c(4L, -3L, 2L, 7L, 8L), z >= 0L, d <= 0L),
         band3(kvr %in% c(4L, -3L, 2L, 7L, 8L), z >= 0L, d <= 0L))
  exp_eq(and3s(kvs %in% c(4L, -3L, 2L, 7L, 8L), c >= 1L, j <= 1L),
         band3(kvs %in% c(4L, -3L, 2L, 7L, 8L), c >= 1L, j <= 1L))
  exp_eq(and3s(kvt %in% c(4L, -3L, 2L, 7L, 8L), a >= 9L, u <= 9L),
         band3(kvt %in% c(4L, -3L, 2L, 7L, 8L), a >= 9L, u <= 9L))
  exp_eq(and3s(kvu %in% 1:4, , ),
         band3(kvu %in% 1:4, , ))
  exp_eq(and3s(kvv %in% 1:4, , ),
         band3(kvv %in% 1:4, , ))
  exp_eq(and3s(kvw %in% 1:4, , ),
         band3(kvw %in% 1:4, , ))
  exp_eq(and3s(kvx %in% 1:4, , m <= 0L),
         band3(kvx %in% 1:4, , m <= 0L))
  exp_eq(and3s(kvy %in% 1:4, , c <= 1L),
         band3(kvy %in% 1:4, , c <= 1L))
  exp_eq(and3s(kvz %in% 1:4, , q <= 9L),
         band3(kvz %in% 1:4, , q <= 9L))
  exp_eq(and3s(kwa %in% 1:4, x >= 0L, ),
         band3(kwa %in% 1:4, x >= 0L, ))
  exp_eq(and3s(kwb %in% 1:4, o >= 1L, ),
         band3(kwb %in% 1:4, o >= 1L, ))
  exp_eq(and3s(kwc %in% 1:4, w >= 9L, ),
         band3(kwc %in% 1:4, w >= 9L, ))
  exp_eq(and3s(kwd %in% 1:4, v >= 0L, o <= 0L),
         band3(kwd %in% 1:4, v >= 0L, o <= 0L))
  exp_eq(and3s(kwe %in% 1:4, k >= 1L, w <= 1L),
         band3(kwe %in% 1:4, k >= 1L, w <= 1L))
  exp_eq(and3s(kwf %in% 1:4, l >= 9L, y <= 9L),
         band3(kwf %in% 1:4, l >= 9L, y <= 9L))
  exp_eq(and3s(kwg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kwg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kwh %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kwh %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kwi %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kwi %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kwj %in% c(4L, -3L, 2L, 7L, 8L), , e == 0L),
         band3(kwj %in% c(4L, -3L, 2L, 7L, 8L), , e == 0L))
  exp_eq(and3s(kwk %in% c(4L, -3L, 2L, 7L, 8L), , r == 1L),
         band3(kwk %in% c(4L, -3L, 2L, 7L, 8L), , r == 1L))
  exp_eq(and3s(kwl %in% c(4L, -3L, 2L, 7L, 8L), , i == 9L),
         band3(kwl %in% c(4L, -3L, 2L, 7L, 8L), , i == 9L))
  exp_eq(and3s(kwm %in% c(4L, -3L, 2L, 7L, 8L), t >= 0L, ),
         band3(kwm %in% c(4L, -3L, 2L, 7L, 8L), t >= 0L, ))
  exp_eq(and3s(kwn %in% c(4L, -3L, 2L, 7L, 8L), s >= 1L, ),
         band3(kwn %in% c(4L, -3L, 2L, 7L, 8L), s >= 1L, ))
  exp_eq(and3s(kwo %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L, ),
         band3(kwo %in% c(4L, -3L, 2L, 7L, 8L), o >= 9L, ))
  exp_eq(and3s(kwp %in% c(4L, -3L, 2L, 7L, 8L), z >= 0L, x == 0L),
         band3(kwp %in% c(4L, -3L, 2L, 7L, 8L), z >= 0L, x == 0L))
  exp_eq(and3s(kwq %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L, t == 1L),
         band3(kwq %in% c(4L, -3L, 2L, 7L, 8L), r >= 1L, t == 1L))
  exp_eq(and3s(kwr %in% c(4L, -3L, 2L, 7L, 8L), j >= 9L, r == 9L),
         band3(kwr %in% c(4L, -3L, 2L, 7L, 8L), j >= 9L, r == 9L))
  exp_eq(and3s(kws %in% 1:4, , ),
         band3(kws %in% 1:4, , ))
  exp_eq(and3s(kwt %in% 1:4, , ),
         band3(kwt %in% 1:4, , ))
  exp_eq(and3s(kwu %in% 1:4, , ),
         band3(kwu %in% 1:4, , ))
  exp_eq(and3s(kwv %in% 1:4, , o == 0L),
         band3(kwv %in% 1:4, , o == 0L))
  exp_eq(and3s(kww %in% 1:4, , j == 1L),
         band3(kww %in% 1:4, , j == 1L))
  exp_eq(and3s(kwx %in% 1:4, , k == 9L),
         band3(kwx %in% 1:4, , k == 9L))
  exp_eq(and3s(kwy %in% 1:4, h >= 0L, ),
         band3(kwy %in% 1:4, h >= 0L, ))
  exp_eq(and3s(kwz %in% 1:4, f >= 1L, ),
         band3(kwz %in% 1:4, f >= 1L, ))
  exp_eq(and3s(kxa %in% 1:4, c >= 9L, ),
         band3(kxa %in% 1:4, c >= 9L, ))
  exp_eq(and3s(kxb %in% 1:4, c >= 0L, v == 0L),
         band3(kxb %in% 1:4, c >= 0L, v == 0L))
  exp_eq(and3s(kxc %in% 1:4, z >= 1L, e == 1L),
         band3(kxc %in% 1:4, z >= 1L, e == 1L))
  exp_eq(and3s(kxd %in% 1:4, v >= 9L, e == 9L),
         band3(kxd %in% 1:4, v >= 9L, e == 9L))
  exp_eq(and3s(kxe %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kxe %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kxf %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kxf %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kxg %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kxg %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kxh %in% c(4L, -3L, 2L, 7L, 8L), , h > 0L),
         band3(kxh %in% c(4L, -3L, 2L, 7L, 8L), , h > 0L))
  exp_eq(and3s(kxi %in% c(4L, -3L, 2L, 7L, 8L), , l > 1L),
         band3(kxi %in% c(4L, -3L, 2L, 7L, 8L), , l > 1L))
  exp_eq(and3s(kxj %in% c(4L, -3L, 2L, 7L, 8L), , f > 9L),
         band3(kxj %in% c(4L, -3L, 2L, 7L, 8L), , f > 9L))
  exp_eq(and3s(kxk %in% c(4L, -3L, 2L, 7L, 8L), j >= 0L, ),
         band3(kxk %in% c(4L, -3L, 2L, 7L, 8L), j >= 0L, ))
  exp_eq(and3s(kxl %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, ),
         band3(kxl %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, ))
  exp_eq(and3s(kxm %in% c(4L, -3L, 2L, 7L, 8L), h >= 9L, ),
         band3(kxm %in% c(4L, -3L, 2L, 7L, 8L), h >= 9L, ))
  exp_eq(and3s(kxn %in% c(4L, -3L, 2L, 7L, 8L), x >= 0L, e > 0L),
         band3(kxn %in% c(4L, -3L, 2L, 7L, 8L), x >= 0L, e > 0L))
  exp_eq(and3s(kxo %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, v > 1L),
         band3(kxo %in% c(4L, -3L, 2L, 7L, 8L), n >= 1L, v > 1L))
  exp_eq(and3s(kxp %in% c(4L, -3L, 2L, 7L, 8L), a >= 9L, f > 9L),
         band3(kxp %in% c(4L, -3L, 2L, 7L, 8L), a >= 9L, f > 9L))
  exp_eq(and3s(kxq %in% 1:4, , ),
         band3(kxq %in% 1:4, , ))
  exp_eq(and3s(kxr %in% 1:4, , ),
         band3(kxr %in% 1:4, , ))
  exp_eq(and3s(kxs %in% 1:4, , ),
         band3(kxs %in% 1:4, , ))
  exp_eq(and3s(kxt %in% 1:4, , p > 0L),
         band3(kxt %in% 1:4, , p > 0L))
  exp_eq(and3s(kxu %in% 1:4, , w > 1L),
         band3(kxu %in% 1:4, , w > 1L))
  exp_eq(and3s(kxv %in% 1:4, , a > 9L),
         band3(kxv %in% 1:4, , a > 9L))
  exp_eq(and3s(kxw %in% 1:4, j >= 0L, ),
         band3(kxw %in% 1:4, j >= 0L, ))
  exp_eq(and3s(kxx %in% 1:4, d >= 1L, ),
         band3(kxx %in% 1:4, d >= 1L, ))
  exp_eq(and3s(kxy %in% 1:4, t >= 9L, ),
         band3(kxy %in% 1:4, t >= 9L, ))
  exp_eq(and3s(kxz %in% 1:4, l >= 0L, z > 0L),
         band3(kxz %in% 1:4, l >= 0L, z > 0L))
  exp_eq(and3s(kya %in% 1:4, r >= 1L, m > 1L),
         band3(kya %in% 1:4, r >= 1L, m > 1L))
  exp_eq(and3s(kyb %in% 1:4, z >= 9L, a > 9L),
         band3(kyb %in% 1:4, z >= 9L, a > 9L))
  exp_eq(and3s(kyc %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kyc %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kyd %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kyd %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kye %in% c(4L, -3L, 2L, 7L, 8L), , ),
         band3(kye %in% c(4L, -3L, 2L, 7L, 8L), , ))
  exp_eq(and3s(kyf %in% c(4L, -3L, 2L, 7L, 8L), , i >= 0L),
         band3(kyf %in% c(4L, -3L, 2L, 7L, 8L), , i >= 0L))
  exp_eq(and3s(kyg %in% c(4L, -3L, 2L, 7L, 8L), , y >= 1L),
         band3(kyg %in% c(4L, -3L, 2L, 7L, 8L), , y >= 1L))
  exp_eq(and3s(kyh %in% c(4L, -3L, 2L, 7L, 8L), , k >= 9L),
         band3(kyh %in% c(4L, -3L, 2L, 7L, 8L), , k >= 9L))
  exp_eq(and3s(kyi %in% c(4L, -3L, 2L, 7L, 8L), y >= 0L, ),
         band3(kyi %in% c(4L, -3L, 2L, 7L, 8L), y >= 0L, ))
  exp_eq(and3s(kyj %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L, ),
         band3(kyj %in% c(4L, -3L, 2L, 7L, 8L), l >= 1L, ))
  exp_eq(and3s(kyk %in% c(4L, -3L, 2L, 7L, 8L), y >= 9L, ),
         band3(kyk %in% c(4L, -3L, 2L, 7L, 8L), y >= 9L, ))
  exp_eq(and3s(kyl %in% c(4L, -3L, 2L, 7L, 8L), l >= 0L, p >= 0L),
         band3(kyl %in% c(4L, -3L, 2L, 7L, 8L), l >= 0L, p >= 0L))
  exp_eq(and3s(kym %in% c(4L, -3L, 2L, 7L, 8L), d >= 1L, c >= 1L),
         band3(kym %in% c(4L, -3L, 2L, 7L, 8L), d >= 1L, c >= 1L))
  exp_eq(and3s(kyn %in% c(4L, -3L, 2L, 7L, 8L), r >= 9L, p >= 9L),
         band3(kyn %in% c(4L, -3L, 2L, 7L, 8L), r >= 9L, p >= 9L))
  exp_eq(and3s(kyo %in% 1:4, , ),
         band3(kyo %in% 1:4, , ))
  exp_eq(and3s(kyp %in% 1:4, , ),
         band3(kyp %in% 1:4, , ))
  exp_eq(and3s(kyq %in% 1:4, , ),
         band3(kyq %in% 1:4, , ))
  exp_eq(and3s(kyr %in% 1:4, , x >= 0L),
         band3(kyr %in% 1:4, , x >= 0L))
  exp_eq(and3s(kys %in% 1:4, , k >= 1L),
         band3(kys %in% 1:4, , k >= 1L))
  exp_eq(and3s(kyt %in% 1:4, , k >= 9L),
         band3(kyt %in% 1:4, , k >= 9L))
  exp_eq(and3s(kyu %in% 1:4, c >= 0L, ),
         band3(kyu %in% 1:4, c >= 0L, ))
  exp_eq(and3s(kyv %in% 1:4, h >= 1L, ),
         band3(kyv %in% 1:4, h >= 1L, ))
  exp_eq(and3s(kyw %in% 1:4, g >= 9L, ),
         band3(kyw %in% 1:4, g >= 9L, ))
  exp_eq(and3s(kyx %in% 1:4, b >= 0L, t >= 0L),
         band3(kyx %in% 1:4, b >= 0L, t >= 0L))
  exp_eq(and3s(kyy %in% 1:4, t >= 1L, t >= 1L),
         band3(kyy %in% 1:4, t >= 1L, t >= 1L))
  exp_eq(and3s(kyz %in% 1:4, s >= 9L, f >= 9L),
         band3(kyz %in% 1:4, s >= 9L, f >= 9L))
  exp_eq(and3s(la < 0L, , ),
         band3(la < 0L, , ))
  exp_eq(and3s(lb < 1L, , ),
         band3(lb < 1L, , ))
  exp_eq(and3s(lc < 9L, , ),
         band3(lc < 9L, , ))
  exp_eq(and3s(ld < 0L, , logi_z),
         band3(ld < 0L, , logi_z))
  exp_eq(and3s(le < 1L, , logi_v),
         band3(le < 1L, , logi_v))
  exp_eq(and3s(lf < 9L, , logi_o),
         band3(lf < 9L, , logi_o))
  exp_eq(and3s(lg < 0L, logi_j, ),
         band3(lg < 0L, logi_j, ))
  exp_eq(and3s(lh < 1L, logi_z, ),
         band3(lh < 1L, logi_z, ))
  exp_eq(and3s(li < 9L, logi_x, ),
         band3(li < 9L, logi_x, ))
  exp_eq(and3s(lj < 0L, logi_v, logi_j),
         band3(lj < 0L, logi_v, logi_j))
  exp_eq(and3s(lk < 1L, logi_k, logi_l),
         band3(lk < 1L, logi_k, logi_l))
  exp_eq(and3s(ll < 9L, logi_m, logi_c),
         band3(ll < 9L, logi_m, logi_c))
  exp_eq(and3s(lm < 0L, , ),
         band3(lm < 0L, , ))
  exp_eq(and3s(ln < 1L, , ),
         band3(ln < 1L, , ))
  exp_eq(and3s(lo < 9L, , ),
         band3(lo < 9L, , ))
  exp_eq(and3s(lp < 0L, , !logi_j),
         band3(lp < 0L, , !logi_j))
  exp_eq(and3s(lq < 1L, , !logi_z),
         band3(lq < 1L, , !logi_z))
  exp_eq(and3s(lr < 9L, , !logi_j),
         band3(lr < 9L, , !logi_j))
  exp_eq(and3s(ls < 0L, logi_h, ),
         band3(ls < 0L, logi_h, ))
  exp_eq(and3s(lt < 1L, logi_u, ),
         band3(lt < 1L, logi_u, ))
  exp_eq(and3s(lu < 9L, logi_w, ),
         band3(lu < 9L, logi_w, ))
  exp_eq(and3s(lv < 0L, logi_v, !logi_p),
         band3(lv < 0L, logi_v, !logi_p))
  exp_eq(and3s(lw < 1L, logi_q, !logi_g),
         band3(lw < 1L, logi_q, !logi_g))
  exp_eq(and3s(lx < 9L, logi_t, !logi_u),
         band3(lx < 9L, logi_t, !logi_u))
  exp_eq(and3s(ly < 0L, , ),
         band3(ly < 0L, , ))
  exp_eq(and3s(lz < 1L, , ),
         band3(lz < 1L, , ))
  exp_eq(and3s(laa < 9L, , ),
         band3(laa < 9L, , ))
  exp_eq(and3s(lab < 0L, , h != 0L),
         band3(lab < 0L, , h != 0L))
  exp_eq(and3s(lac < 1L, , n != 1L),
         band3(lac < 1L, , n != 1L))
  exp_eq(and3s(lad < 9L, , r != 9L),
         band3(lad < 9L, , r != 9L))
  exp_eq(and3s(lae < 0L, logi_g, ),
         band3(lae < 0L, logi_g, ))
  exp_eq(and3s(laf < 1L, logi_v, ),
         band3(laf < 1L, logi_v, ))
  exp_eq(and3s(lag < 9L, logi_z, ),
         band3(lag < 9L, logi_z, ))
  exp_eq(and3s(lah < 0L, logi_e, h != 0L),
         band3(lah < 0L, logi_e, h != 0L))
  exp_eq(and3s(lai < 1L, logi_z, l != 1L),
         band3(lai < 1L, logi_z, l != 1L))
  exp_eq(and3s(laj < 9L, logi_t, y != 9L),
         band3(laj < 9L, logi_t, y != 9L))
  exp_eq(and3s(lak < 0L, , ),
         band3(lak < 0L, , ))
  exp_eq(and3s(lal < 1L, , ),
         band3(lal < 1L, , ))
  exp_eq(and3s(lam < 9L, , ),
         band3(lam < 9L, , ))
  exp_eq(and3s(lan < 0L, , o %between% c(-1L, 1L)),
         band3(lan < 0L, , o %between% c(-1L, 1L)))
  exp_eq(and3s(lao < 1L, , y %between% c(-1L, 1L)),
         band3(lao < 1L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(lap < 9L, , c %between% c(-1L, 1L)),
         band3(lap < 9L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(laq < 0L, logi_u, ),
         band3(laq < 0L, logi_u, ))
  exp_eq(and3s(lar < 1L, logi_u, ),
         band3(lar < 1L, logi_u, ))
  exp_eq(and3s(las < 9L, logi_r, ),
         band3(las < 9L, logi_r, ))
  exp_eq(and3s(lat < 0L, logi_x, v %between% c(-1L, 1L)),
         band3(lat < 0L, logi_x, v %between% c(-1L, 1L)))
  exp_eq(and3s(lau < 1L, logi_k, v %between% c(-1L, 1L)),
         band3(lau < 1L, logi_k, v %between% c(-1L, 1L)))
  exp_eq(and3s(lav < 9L, logi_d, c %between% c(-1L, 1L)),
         band3(lav < 9L, logi_d, c %between% c(-1L, 1L)))
  exp_eq(and3s(law < 0L, , ),
         band3(law < 0L, , ))
  exp_eq(and3s(lax < 1L, , ),
         band3(lax < 1L, , ))
  exp_eq(and3s(lay < 9L, , ),
         band3(lay < 9L, , ))
  exp_eq(and3s(laz < 0L, , y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(laz < 0L, , y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lba < 1L, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lba < 1L, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lbb < 9L, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lbb < 9L, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lbc < 0L, logi_i, ),
         band3(lbc < 0L, logi_i, ))
  exp_eq(and3s(lbd < 1L, logi_n, ),
         band3(lbd < 1L, logi_n, ))
  exp_eq(and3s(lbe < 9L, logi_a, ),
         band3(lbe < 9L, logi_a, ))
  exp_eq(and3s(lbf < 0L, logi_p, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lbf < 0L, logi_p, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lbg < 1L, logi_h, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lbg < 1L, logi_h, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lbh < 9L, logi_b, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lbh < 9L, logi_b, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lbi < 0L, , ),
         band3(lbi < 0L, , ))
  exp_eq(and3s(lbj < 1L, , ),
         band3(lbj < 1L, , ))
  exp_eq(and3s(lbk < 9L, , ),
         band3(lbk < 9L, , ))
  exp_eq(and3s(lbl < 0L, , y %in% 1:4),
         band3(lbl < 0L, , y %in% 1:4))
  exp_eq(and3s(lbm < 1L, , h %in% 1:4),
         band3(lbm < 1L, , h %in% 1:4))
  exp_eq(and3s(lbn < 9L, , y %in% 1:4),
         band3(lbn < 9L, , y %in% 1:4))
  exp_eq(and3s(lbo < 0L, logi_o, ),
         band3(lbo < 0L, logi_o, ))
  exp_eq(and3s(lbp < 1L, logi_n, ),
         band3(lbp < 1L, logi_n, ))
  exp_eq(and3s(lbq < 9L, logi_j, ),
         band3(lbq < 9L, logi_j, ))
  exp_eq(and3s(lbr < 0L, logi_m, e %in% 1:4),
         band3(lbr < 0L, logi_m, e %in% 1:4))
  exp_eq(and3s(lbs < 1L, logi_d, k %in% 1:4),
         band3(lbs < 1L, logi_d, k %in% 1:4))
  exp_eq(and3s(lbt < 9L, logi_y, i %in% 1:4),
         band3(lbt < 9L, logi_y, i %in% 1:4))
  exp_eq(and3s(lbu < 0L, , ),
         band3(lbu < 0L, , ))
  exp_eq(and3s(lbv < 1L, , ),
         band3(lbv < 1L, , ))
  exp_eq(and3s(lbw < 9L, , ),
         band3(lbw < 9L, , ))
  exp_eq(and3s(lbx < 0L, , g < 0L),
         band3(lbx < 0L, , g < 0L))
  exp_eq(and3s(lby < 1L, , t < 1L),
         band3(lby < 1L, , t < 1L))
  exp_eq(and3s(lbz < 9L, , h < 9L),
         band3(lbz < 9L, , h < 9L))
  exp_eq(and3s(lca < 0L, logi_q, ),
         band3(lca < 0L, logi_q, ))
  exp_eq(and3s(lcb < 1L, logi_z, ),
         band3(lcb < 1L, logi_z, ))
  exp_eq(and3s(lcc < 9L, logi_v, ),
         band3(lcc < 9L, logi_v, ))
  exp_eq(and3s(lcd < 0L, logi_x, m < 0L),
         band3(lcd < 0L, logi_x, m < 0L))
  exp_eq(and3s(lce < 1L, logi_t, m < 1L),
         band3(lce < 1L, logi_t, m < 1L))
  exp_eq(and3s(lcf < 9L, logi_s, n < 9L),
         band3(lcf < 9L, logi_s, n < 9L))
  exp_eq(and3s(lcg < 0L, , ),
         band3(lcg < 0L, , ))
  exp_eq(and3s(lch < 1L, , ),
         band3(lch < 1L, , ))
  exp_eq(and3s(lci < 9L, , ),
         band3(lci < 9L, , ))
  exp_eq(and3s(lcj < 0L, , d <= 0L),
         band3(lcj < 0L, , d <= 0L))
  exp_eq(and3s(lck < 1L, , h <= 1L),
         band3(lck < 1L, , h <= 1L))
  exp_eq(and3s(lcl < 9L, , d <= 9L),
         band3(lcl < 9L, , d <= 9L))
  exp_eq(and3s(lcm < 0L, logi_k, ),
         band3(lcm < 0L, logi_k, ))
  exp_eq(and3s(lcn < 1L, logi_j, ),
         band3(lcn < 1L, logi_j, ))
  exp_eq(and3s(lco < 9L, logi_k, ),
         band3(lco < 9L, logi_k, ))
  exp_eq(and3s(lcp < 0L, logi_k, i <= 0L),
         band3(lcp < 0L, logi_k, i <= 0L))
  exp_eq(and3s(lcq < 1L, logi_b, s <= 1L),
         band3(lcq < 1L, logi_b, s <= 1L))
  exp_eq(and3s(lcr < 9L, logi_i, s <= 9L),
         band3(lcr < 9L, logi_i, s <= 9L))
  exp_eq(and3s(lcs < 0L, , ),
         band3(lcs < 0L, , ))
  exp_eq(and3s(lct < 1L, , ),
         band3(lct < 1L, , ))
  exp_eq(and3s(lcu < 9L, , ),
         band3(lcu < 9L, , ))
  exp_eq(and3s(lcv < 0L, , n == 0L),
         band3(lcv < 0L, , n == 0L))
  exp_eq(and3s(lcw < 1L, , n == 1L),
         band3(lcw < 1L, , n == 1L))
  exp_eq(and3s(lcx < 9L, , d == 9L),
         band3(lcx < 9L, , d == 9L))
  exp_eq(and3s(lcy < 0L, logi_m, ),
         band3(lcy < 0L, logi_m, ))
  exp_eq(and3s(lcz < 1L, logi_x, ),
         band3(lcz < 1L, logi_x, ))
  exp_eq(and3s(lda < 9L, logi_q, ),
         band3(lda < 9L, logi_q, ))
  exp_eq(and3s(ldb < 0L, logi_m, b == 0L),
         band3(ldb < 0L, logi_m, b == 0L))
  exp_eq(and3s(ldc < 1L, logi_j, o == 1L),
         band3(ldc < 1L, logi_j, o == 1L))
  exp_eq(and3s(ldd < 9L, logi_a, h == 9L),
         band3(ldd < 9L, logi_a, h == 9L))
  exp_eq(and3s(lde < 0L, , ),
         band3(lde < 0L, , ))
  exp_eq(and3s(ldf < 1L, , ),
         band3(ldf < 1L, , ))
  exp_eq(and3s(ldg < 9L, , ),
         band3(ldg < 9L, , ))
  exp_eq(and3s(ldh < 0L, , c > 0L),
         band3(ldh < 0L, , c > 0L))
  exp_eq(and3s(ldi < 1L, , v > 1L),
         band3(ldi < 1L, , v > 1L))
  exp_eq(and3s(ldj < 9L, , u > 9L),
         band3(ldj < 9L, , u > 9L))
  exp_eq(and3s(ldk < 0L, logi_t, ),
         band3(ldk < 0L, logi_t, ))
  exp_eq(and3s(ldl < 1L, logi_a, ),
         band3(ldl < 1L, logi_a, ))
  exp_eq(and3s(ldm < 9L, logi_m, ),
         band3(ldm < 9L, logi_m, ))
  exp_eq(and3s(ldn < 0L, logi_b, p > 0L),
         band3(ldn < 0L, logi_b, p > 0L))
  exp_eq(and3s(ldo < 1L, logi_d, j > 1L),
         band3(ldo < 1L, logi_d, j > 1L))
  exp_eq(and3s(ldp < 9L, logi_e, s > 9L),
         band3(ldp < 9L, logi_e, s > 9L))
  exp_eq(and3s(ldq < 0L, , ),
         band3(ldq < 0L, , ))
  exp_eq(and3s(ldr < 1L, , ),
         band3(ldr < 1L, , ))
  exp_eq(and3s(lds < 9L, , ),
         band3(lds < 9L, , ))
  exp_eq(and3s(ldt < 0L, , s >= 0L),
         band3(ldt < 0L, , s >= 0L))
  exp_eq(and3s(ldu < 1L, , z >= 1L),
         band3(ldu < 1L, , z >= 1L))
  exp_eq(and3s(ldv < 9L, , j >= 9L),
         band3(ldv < 9L, , j >= 9L))
  exp_eq(and3s(ldw < 0L, logi_f, ),
         band3(ldw < 0L, logi_f, ))
  exp_eq(and3s(ldx < 1L, logi_h, ),
         band3(ldx < 1L, logi_h, ))
  exp_eq(and3s(ldy < 9L, logi_w, ),
         band3(ldy < 9L, logi_w, ))
  exp_eq(and3s(ldz < 0L, logi_x, c >= 0L),
         band3(ldz < 0L, logi_x, c >= 0L))
  exp_eq(and3s(lea < 1L, logi_j, d >= 1L),
         band3(lea < 1L, logi_j, d >= 1L))
  exp_eq(and3s(leb < 9L, logi_v, s >= 9L),
         band3(leb < 9L, logi_v, s >= 9L))
  exp_eq(and3s(lec < 0L, , ),
         band3(lec < 0L, , ))
  exp_eq(and3s(led < 1L, , ),
         band3(led < 1L, , ))
  exp_eq(and3s(lee < 9L, , ),
         band3(lee < 9L, , ))
  exp_eq(and3s(lef < 0L, , logi_e),
         band3(lef < 0L, , logi_e))
  exp_eq(and3s(leg < 1L, , logi_i),
         band3(leg < 1L, , logi_i))
  exp_eq(and3s(leh < 9L, , logi_f),
         band3(leh < 9L, , logi_f))
  exp_eq(and3s(lei < 0L, !logi_a, ),
         band3(lei < 0L, !logi_a, ))
  exp_eq(and3s(lej < 1L, !logi_s, ),
         band3(lej < 1L, !logi_s, ))
  exp_eq(and3s(lek < 9L, !logi_t, ),
         band3(lek < 9L, !logi_t, ))
  exp_eq(and3s(lel < 0L, !logi_r, logi_i),
         band3(lel < 0L, !logi_r, logi_i))
  exp_eq(and3s(lem < 1L, !logi_d, logi_j),
         band3(lem < 1L, !logi_d, logi_j))
  exp_eq(and3s(len < 9L, !logi_f, logi_g),
         band3(len < 9L, !logi_f, logi_g))
  exp_eq(and3s(leo < 0L, , ),
         band3(leo < 0L, , ))
  exp_eq(and3s(lep < 1L, , ),
         band3(lep < 1L, , ))
  exp_eq(and3s(leq < 9L, , ),
         band3(leq < 9L, , ))
  exp_eq(and3s(ler < 0L, , !logi_r),
         band3(ler < 0L, , !logi_r))
  exp_eq(and3s(les < 1L, , !logi_q),
         band3(les < 1L, , !logi_q))
  exp_eq(and3s(let < 9L, , !logi_d),
         band3(let < 9L, , !logi_d))
  exp_eq(and3s(leu < 0L, !logi_k, ),
         band3(leu < 0L, !logi_k, ))
  exp_eq(and3s(lev < 1L, !logi_z, ),
         band3(lev < 1L, !logi_z, ))
  exp_eq(and3s(lew < 9L, !logi_i, ),
         band3(lew < 9L, !logi_i, ))
  exp_eq(and3s(lex < 0L, !logi_l, !logi_f),
         band3(lex < 0L, !logi_l, !logi_f))
  exp_eq(and3s(ley < 1L, !logi_d, !logi_p),
         band3(ley < 1L, !logi_d, !logi_p))
  exp_eq(and3s(lez < 9L, !logi_b, !logi_u),
         band3(lez < 9L, !logi_b, !logi_u))
  exp_eq(and3s(lfa < 0L, , ),
         band3(lfa < 0L, , ))
  exp_eq(and3s(lfb < 1L, , ),
         band3(lfb < 1L, , ))
  exp_eq(and3s(lfc < 9L, , ),
         band3(lfc < 9L, , ))
  exp_eq(and3s(lfd < 0L, , n != 0L),
         band3(lfd < 0L, , n != 0L))
  exp_eq(and3s(lfe < 1L, , t != 1L),
         band3(lfe < 1L, , t != 1L))
  exp_eq(and3s(lff < 9L, , r != 9L),
         band3(lff < 9L, , r != 9L))
  exp_eq(and3s(lfg < 0L, !logi_m, ),
         band3(lfg < 0L, !logi_m, ))
  exp_eq(and3s(lfh < 1L, !logi_q, ),
         band3(lfh < 1L, !logi_q, ))
  exp_eq(and3s(lfi < 9L, !logi_m, ),
         band3(lfi < 9L, !logi_m, ))
  exp_eq(and3s(lfj < 0L, !logi_m, a != 0L),
         band3(lfj < 0L, !logi_m, a != 0L))
  exp_eq(and3s(lfk < 1L, !logi_w, k != 1L),
         band3(lfk < 1L, !logi_w, k != 1L))
  exp_eq(and3s(lfl < 9L, !logi_o, v != 9L),
         band3(lfl < 9L, !logi_o, v != 9L))
  exp_eq(and3s(lfm < 0L, , ),
         band3(lfm < 0L, , ))
  exp_eq(and3s(lfn < 1L, , ),
         band3(lfn < 1L, , ))
  exp_eq(and3s(lfo < 9L, , ),
         band3(lfo < 9L, , ))
  exp_eq(and3s(lfp < 0L, , w %between% c(-1L, 1L)),
         band3(lfp < 0L, , w %between% c(-1L, 1L)))
  exp_eq(and3s(lfq < 1L, , l %between% c(-1L, 1L)),
         band3(lfq < 1L, , l %between% c(-1L, 1L)))
  exp_eq(and3s(lfr < 9L, , q %between% c(-1L, 1L)),
         band3(lfr < 9L, , q %between% c(-1L, 1L)))
  exp_eq(and3s(lfs < 0L, !logi_d, ),
         band3(lfs < 0L, !logi_d, ))
  exp_eq(and3s(lft < 1L, !logi_w, ),
         band3(lft < 1L, !logi_w, ))
  exp_eq(and3s(lfu < 9L, !logi_p, ),
         band3(lfu < 9L, !logi_p, ))
  exp_eq(and3s(lfv < 0L, !logi_c, f %between% c(-1L, 1L)),
         band3(lfv < 0L, !logi_c, f %between% c(-1L, 1L)))
  exp_eq(and3s(lfw < 1L, !logi_i, h %between% c(-1L, 1L)),
         band3(lfw < 1L, !logi_i, h %between% c(-1L, 1L)))
  exp_eq(and3s(lfx < 9L, !logi_n, f %between% c(-1L, 1L)),
         band3(lfx < 9L, !logi_n, f %between% c(-1L, 1L)))
  exp_eq(and3s(lfy < 0L, , ),
         band3(lfy < 0L, , ))
  exp_eq(and3s(lfz < 1L, , ),
         band3(lfz < 1L, , ))
  exp_eq(and3s(lga < 9L, , ),
         band3(lga < 9L, , ))
  exp_eq(and3s(lgb < 0L, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgb < 0L, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lgc < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgc < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lgd < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgd < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lge < 0L, !logi_k, ),
         band3(lge < 0L, !logi_k, ))
  exp_eq(and3s(lgf < 1L, !logi_d, ),
         band3(lgf < 1L, !logi_d, ))
  exp_eq(and3s(lgg < 9L, !logi_b, ),
         band3(lgg < 9L, !logi_b, ))
  exp_eq(and3s(lgh < 0L, !logi_w, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgh < 0L, !logi_w, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lgi < 1L, !logi_p, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgi < 1L, !logi_p, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lgj < 9L, !logi_j, t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lgj < 9L, !logi_j, t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lgk < 0L, , ),
         band3(lgk < 0L, , ))
  exp_eq(and3s(lgl < 1L, , ),
         band3(lgl < 1L, , ))
  exp_eq(and3s(lgm < 9L, , ),
         band3(lgm < 9L, , ))
  exp_eq(and3s(lgn < 0L, , n %in% 1:4),
         band3(lgn < 0L, , n %in% 1:4))
  exp_eq(and3s(lgo < 1L, , w %in% 1:4),
         band3(lgo < 1L, , w %in% 1:4))
  exp_eq(and3s(lgp < 9L, , k %in% 1:4),
         band3(lgp < 9L, , k %in% 1:4))
  exp_eq(and3s(lgq < 0L, !logi_n, ),
         band3(lgq < 0L, !logi_n, ))
  exp_eq(and3s(lgr < 1L, !logi_t, ),
         band3(lgr < 1L, !logi_t, ))
  exp_eq(and3s(lgs < 9L, !logi_t, ),
         band3(lgs < 9L, !logi_t, ))
  exp_eq(and3s(lgt < 0L, !logi_k, q %in% 1:4),
         band3(lgt < 0L, !logi_k, q %in% 1:4))
  exp_eq(and3s(lgu < 1L, !logi_i, c %in% 1:4),
         band3(lgu < 1L, !logi_i, c %in% 1:4))
  exp_eq(and3s(lgv < 9L, !logi_z, z %in% 1:4),
         band3(lgv < 9L, !logi_z, z %in% 1:4))
  exp_eq(and3s(lgw < 0L, , ),
         band3(lgw < 0L, , ))
  exp_eq(and3s(lgx < 1L, , ),
         band3(lgx < 1L, , ))
  exp_eq(and3s(lgy < 9L, , ),
         band3(lgy < 9L, , ))
  exp_eq(and3s(lgz < 0L, , d < 0L),
         band3(lgz < 0L, , d < 0L))
  exp_eq(and3s(lha < 1L, , j < 1L),
         band3(lha < 1L, , j < 1L))
  exp_eq(and3s(lhb < 9L, , d < 9L),
         band3(lhb < 9L, , d < 9L))
  exp_eq(and3s(lhc < 0L, !logi_h, ),
         band3(lhc < 0L, !logi_h, ))
  exp_eq(and3s(lhd < 1L, !logi_x, ),
         band3(lhd < 1L, !logi_x, ))
  exp_eq(and3s(lhe < 9L, !logi_v, ),
         band3(lhe < 9L, !logi_v, ))
  exp_eq(and3s(lhf < 0L, !logi_t, u < 0L),
         band3(lhf < 0L, !logi_t, u < 0L))
  exp_eq(and3s(lhg < 1L, !logi_h, o < 1L),
         band3(lhg < 1L, !logi_h, o < 1L))
  exp_eq(and3s(lhh < 9L, !logi_i, p < 9L),
         band3(lhh < 9L, !logi_i, p < 9L))
  exp_eq(and3s(lhi < 0L, , ),
         band3(lhi < 0L, , ))
  exp_eq(and3s(lhj < 1L, , ),
         band3(lhj < 1L, , ))
  exp_eq(and3s(lhk < 9L, , ),
         band3(lhk < 9L, , ))
  exp_eq(and3s(lhl < 0L, , y <= 0L),
         band3(lhl < 0L, , y <= 0L))
  exp_eq(and3s(lhm < 1L, , j <= 1L),
         band3(lhm < 1L, , j <= 1L))
  exp_eq(and3s(lhn < 9L, , v <= 9L),
         band3(lhn < 9L, , v <= 9L))
  exp_eq(and3s(lho < 0L, !logi_a, ),
         band3(lho < 0L, !logi_a, ))
  exp_eq(and3s(lhp < 1L, !logi_v, ),
         band3(lhp < 1L, !logi_v, ))
  exp_eq(and3s(lhq < 9L, !logi_r, ),
         band3(lhq < 9L, !logi_r, ))
  exp_eq(and3s(lhr < 0L, !logi_k, x <= 0L),
         band3(lhr < 0L, !logi_k, x <= 0L))
  exp_eq(and3s(lhs < 1L, !logi_n, x <= 1L),
         band3(lhs < 1L, !logi_n, x <= 1L))
  exp_eq(and3s(lht < 9L, !logi_x, b <= 9L),
         band3(lht < 9L, !logi_x, b <= 9L))
  exp_eq(and3s(lhu < 0L, , ),
         band3(lhu < 0L, , ))
  exp_eq(and3s(lhv < 1L, , ),
         band3(lhv < 1L, , ))
  exp_eq(and3s(lhw < 9L, , ),
         band3(lhw < 9L, , ))
  exp_eq(and3s(lhx < 0L, , c == 0L),
         band3(lhx < 0L, , c == 0L))
  exp_eq(and3s(lhy < 1L, , g == 1L),
         band3(lhy < 1L, , g == 1L))
  exp_eq(and3s(lhz < 9L, , e == 9L),
         band3(lhz < 9L, , e == 9L))
  exp_eq(and3s(lia < 0L, !logi_t, ),
         band3(lia < 0L, !logi_t, ))
  exp_eq(and3s(lib < 1L, !logi_c, ),
         band3(lib < 1L, !logi_c, ))
  exp_eq(and3s(lic < 9L, !logi_p, ),
         band3(lic < 9L, !logi_p, ))
  exp_eq(and3s(lid < 0L, !logi_i, m == 0L),
         band3(lid < 0L, !logi_i, m == 0L))
  exp_eq(and3s(lie < 1L, !logi_a, b == 1L),
         band3(lie < 1L, !logi_a, b == 1L))
  exp_eq(and3s(lif < 9L, !logi_u, o == 9L),
         band3(lif < 9L, !logi_u, o == 9L))
  exp_eq(and3s(lig < 0L, , ),
         band3(lig < 0L, , ))
  exp_eq(and3s(lih < 1L, , ),
         band3(lih < 1L, , ))
  exp_eq(and3s(lii < 9L, , ),
         band3(lii < 9L, , ))
  exp_eq(and3s(lij < 0L, , q > 0L),
         band3(lij < 0L, , q > 0L))
  exp_eq(and3s(lik < 1L, , u > 1L),
         band3(lik < 1L, , u > 1L))
  exp_eq(and3s(lil < 9L, , u > 9L),
         band3(lil < 9L, , u > 9L))
  exp_eq(and3s(lim < 0L, !logi_j, ),
         band3(lim < 0L, !logi_j, ))
  exp_eq(and3s(lin < 1L, !logi_s, ),
         band3(lin < 1L, !logi_s, ))
  exp_eq(and3s(lio < 9L, !logi_k, ),
         band3(lio < 9L, !logi_k, ))
  exp_eq(and3s(lip < 0L, !logi_w, s > 0L),
         band3(lip < 0L, !logi_w, s > 0L))
  exp_eq(and3s(liq < 1L, !logi_v, o > 1L),
         band3(liq < 1L, !logi_v, o > 1L))
  exp_eq(and3s(lir < 9L, !logi_g, a > 9L),
         band3(lir < 9L, !logi_g, a > 9L))
  exp_eq(and3s(lis < 0L, , ),
         band3(lis < 0L, , ))
  exp_eq(and3s(lit < 1L, , ),
         band3(lit < 1L, , ))
  exp_eq(and3s(liu < 9L, , ),
         band3(liu < 9L, , ))
  exp_eq(and3s(liv < 0L, , v >= 0L),
         band3(liv < 0L, , v >= 0L))
  exp_eq(and3s(liw < 1L, , a >= 1L),
         band3(liw < 1L, , a >= 1L))
  exp_eq(and3s(lix < 9L, , o >= 9L),
         band3(lix < 9L, , o >= 9L))
  exp_eq(and3s(liy < 0L, !logi_h, ),
         band3(liy < 0L, !logi_h, ))
  exp_eq(and3s(liz < 1L, !logi_x, ),
         band3(liz < 1L, !logi_x, ))
  exp_eq(and3s(lja < 9L, !logi_h, ),
         band3(lja < 9L, !logi_h, ))
  exp_eq(and3s(ljb < 0L, !logi_n, p >= 0L),
         band3(ljb < 0L, !logi_n, p >= 0L))
  exp_eq(and3s(ljc < 1L, !logi_u, i >= 1L),
         band3(ljc < 1L, !logi_u, i >= 1L))
  exp_eq(and3s(ljd < 9L, !logi_x, k >= 9L),
         band3(ljd < 9L, !logi_x, k >= 9L))
  exp_eq(and3s(lje < 0L, , ),
         band3(lje < 0L, , ))
  exp_eq(and3s(ljf < 1L, , ),
         band3(ljf < 1L, , ))
  exp_eq(and3s(ljg < 9L, , ),
         band3(ljg < 9L, , ))
  exp_eq(and3s(ljh < 0L, , logi_l),
         band3(ljh < 0L, , logi_l))
  exp_eq(and3s(lji < 1L, , logi_v),
         band3(lji < 1L, , logi_v))
  exp_eq(and3s(ljj < 9L, , logi_b),
         band3(ljj < 9L, , logi_b))
  exp_eq(and3s(ljk < 0L, c != 0L, ),
         band3(ljk < 0L, c != 0L, ))
  exp_eq(and3s(ljl < 1L, s != 1L, ),
         band3(ljl < 1L, s != 1L, ))
  exp_eq(and3s(ljm < 9L, d != 9L, ),
         band3(ljm < 9L, d != 9L, ))
  exp_eq(and3s(ljn < 0L, z != 0L, logi_u),
         band3(ljn < 0L, z != 0L, logi_u))
  exp_eq(and3s(ljo < 1L, k != 1L, logi_x),
         band3(ljo < 1L, k != 1L, logi_x))
  exp_eq(and3s(ljp < 9L, x != 9L, logi_v),
         band3(ljp < 9L, x != 9L, logi_v))
  exp_eq(and3s(ljq < 0L, , ),
         band3(ljq < 0L, , ))
  exp_eq(and3s(ljr < 1L, , ),
         band3(ljr < 1L, , ))
  exp_eq(and3s(ljs < 9L, , ),
         band3(ljs < 9L, , ))
  exp_eq(and3s(ljt < 0L, , !logi_b),
         band3(ljt < 0L, , !logi_b))
  exp_eq(and3s(lju < 1L, , !logi_p),
         band3(lju < 1L, , !logi_p))
  exp_eq(and3s(ljv < 9L, , !logi_w),
         band3(ljv < 9L, , !logi_w))
  exp_eq(and3s(ljw < 0L, q != 0L, ),
         band3(ljw < 0L, q != 0L, ))
  exp_eq(and3s(ljx < 1L, x != 1L, ),
         band3(ljx < 1L, x != 1L, ))
  exp_eq(and3s(ljy < 9L, q != 9L, ),
         band3(ljy < 9L, q != 9L, ))
  exp_eq(and3s(ljz < 0L, a != 0L, !logi_t),
         band3(ljz < 0L, a != 0L, !logi_t))
  exp_eq(and3s(lka < 1L, f != 1L, !logi_d),
         band3(lka < 1L, f != 1L, !logi_d))
  exp_eq(and3s(lkb < 9L, o != 9L, !logi_o),
         band3(lkb < 9L, o != 9L, !logi_o))
  exp_eq(and3s(lkc < 0L, , ),
         band3(lkc < 0L, , ))
  exp_eq(and3s(lkd < 1L, , ),
         band3(lkd < 1L, , ))
  exp_eq(and3s(lke < 9L, , ),
         band3(lke < 9L, , ))
  exp_eq(and3s(lkf < 0L, , x != 0L),
         band3(lkf < 0L, , x != 0L))
  exp_eq(and3s(lkg < 1L, , z != 1L),
         band3(lkg < 1L, , z != 1L))
  exp_eq(and3s(lkh < 9L, , e != 9L),
         band3(lkh < 9L, , e != 9L))
  exp_eq(and3s(lki < 0L, k != 0L, ),
         band3(lki < 0L, k != 0L, ))
  exp_eq(and3s(lkj < 1L, s != 1L, ),
         band3(lkj < 1L, s != 1L, ))
  exp_eq(and3s(lkk < 9L, j != 9L, ),
         band3(lkk < 9L, j != 9L, ))
  exp_eq(and3s(lkl < 0L, e != 0L, e != 0L),
         band3(lkl < 0L, e != 0L, e != 0L))
  exp_eq(and3s(lkm < 1L, k != 1L, l != 1L),
         band3(lkm < 1L, k != 1L, l != 1L))
  exp_eq(and3s(lkn < 9L, e != 9L, e != 9L),
         band3(lkn < 9L, e != 9L, e != 9L))
  exp_eq(and3s(lko < 0L, , ),
         band3(lko < 0L, , ))
  exp_eq(and3s(lkp < 1L, , ),
         band3(lkp < 1L, , ))
  exp_eq(and3s(lkq < 9L, , ),
         band3(lkq < 9L, , ))
  exp_eq(and3s(lkr < 0L, , z %between% c(-1L, 1L)),
         band3(lkr < 0L, , z %between% c(-1L, 1L)))
  exp_eq(and3s(lks < 1L, , j %between% c(-1L, 1L)),
         band3(lks < 1L, , j %between% c(-1L, 1L)))
  exp_eq(and3s(lkt < 9L, , s %between% c(-1L, 1L)),
         band3(lkt < 9L, , s %between% c(-1L, 1L)))
  exp_eq(and3s(lku < 0L, s != 0L, ),
         band3(lku < 0L, s != 0L, ))
  exp_eq(and3s(lkv < 1L, c != 1L, ),
         band3(lkv < 1L, c != 1L, ))
  exp_eq(and3s(lkw < 9L, m != 9L, ),
         band3(lkw < 9L, m != 9L, ))
  exp_eq(and3s(lkx < 0L, q != 0L, p %between% c(-1L, 1L)),
         band3(lkx < 0L, q != 0L, p %between% c(-1L, 1L)))
  exp_eq(and3s(lky < 1L, v != 1L, d %between% c(-1L, 1L)),
         band3(lky < 1L, v != 1L, d %between% c(-1L, 1L)))
  exp_eq(and3s(lkz < 9L, b != 9L, q %between% c(-1L, 1L)),
         band3(lkz < 9L, b != 9L, q %between% c(-1L, 1L)))
  exp_eq(and3s(lla < 0L, , ),
         band3(lla < 0L, , ))
  exp_eq(and3s(llb < 1L, , ),
         band3(llb < 1L, , ))
  exp_eq(and3s(llc < 9L, , ),
         band3(llc < 9L, , ))
  exp_eq(and3s(lld < 0L, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lld < 0L, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lle < 1L, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lle < 1L, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(llf < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(llf < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(llg < 0L, b != 0L, ),
         band3(llg < 0L, b != 0L, ))
  exp_eq(and3s(llh < 1L, k != 1L, ),
         band3(llh < 1L, k != 1L, ))
  exp_eq(and3s(lli < 9L, u != 9L, ),
         band3(lli < 9L, u != 9L, ))
  exp_eq(and3s(llj < 0L, p != 0L, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(llj < 0L, p != 0L, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(llk < 1L, c != 1L, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(llk < 1L, c != 1L, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lll < 9L, q != 9L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lll < 9L, q != 9L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(llm < 0L, , ),
         band3(llm < 0L, , ))
  exp_eq(and3s(lln < 1L, , ),
         band3(lln < 1L, , ))
  exp_eq(and3s(llo < 9L, , ),
         band3(llo < 9L, , ))
  exp_eq(and3s(llp < 0L, , n %in% 1:4),
         band3(llp < 0L, , n %in% 1:4))
  exp_eq(and3s(llq < 1L, , x %in% 1:4),
         band3(llq < 1L, , x %in% 1:4))
  exp_eq(and3s(llr < 9L, , p %in% 1:4),
         band3(llr < 9L, , p %in% 1:4))
  exp_eq(and3s(lls < 0L, b != 0L, ),
         band3(lls < 0L, b != 0L, ))
  exp_eq(and3s(llt < 1L, q != 1L, ),
         band3(llt < 1L, q != 1L, ))
  exp_eq(and3s(llu < 9L, y != 9L, ),
         band3(llu < 9L, y != 9L, ))
  exp_eq(and3s(llv < 0L, t != 0L, y %in% 1:4),
         band3(llv < 0L, t != 0L, y %in% 1:4))
  exp_eq(and3s(llw < 1L, t != 1L, a %in% 1:4),
         band3(llw < 1L, t != 1L, a %in% 1:4))
  exp_eq(and3s(llx < 9L, a != 9L, h %in% 1:4),
         band3(llx < 9L, a != 9L, h %in% 1:4))
  exp_eq(and3s(lly < 0L, , ),
         band3(lly < 0L, , ))
  exp_eq(and3s(llz < 1L, , ),
         band3(llz < 1L, , ))
  exp_eq(and3s(lma < 9L, , ),
         band3(lma < 9L, , ))
  exp_eq(and3s(lmb < 0L, , s < 0L),
         band3(lmb < 0L, , s < 0L))
  exp_eq(and3s(lmc < 1L, , d < 1L),
         band3(lmc < 1L, , d < 1L))
  exp_eq(and3s(lmd < 9L, , k < 9L),
         band3(lmd < 9L, , k < 9L))
  exp_eq(and3s(lme < 0L, g != 0L, ),
         band3(lme < 0L, g != 0L, ))
  exp_eq(and3s(lmf < 1L, i != 1L, ),
         band3(lmf < 1L, i != 1L, ))
  exp_eq(and3s(lmg < 9L, q != 9L, ),
         band3(lmg < 9L, q != 9L, ))
  exp_eq(and3s(lmh < 0L, n != 0L, h < 0L),
         band3(lmh < 0L, n != 0L, h < 0L))
  exp_eq(and3s(lmi < 1L, w != 1L, h < 1L),
         band3(lmi < 1L, w != 1L, h < 1L))
  exp_eq(and3s(lmj < 9L, n != 9L, k < 9L),
         band3(lmj < 9L, n != 9L, k < 9L))
  exp_eq(and3s(lmk < 0L, , ),
         band3(lmk < 0L, , ))
  exp_eq(and3s(lml < 1L, , ),
         band3(lml < 1L, , ))
  exp_eq(and3s(lmm < 9L, , ),
         band3(lmm < 9L, , ))
  exp_eq(and3s(lmn < 0L, , u <= 0L),
         band3(lmn < 0L, , u <= 0L))
  exp_eq(and3s(lmo < 1L, , e <= 1L),
         band3(lmo < 1L, , e <= 1L))
  exp_eq(and3s(lmp < 9L, , e <= 9L),
         band3(lmp < 9L, , e <= 9L))
  exp_eq(and3s(lmq < 0L, l != 0L, ),
         band3(lmq < 0L, l != 0L, ))
  exp_eq(and3s(lmr < 1L, x != 1L, ),
         band3(lmr < 1L, x != 1L, ))
  exp_eq(and3s(lms < 9L, r != 9L, ),
         band3(lms < 9L, r != 9L, ))
  exp_eq(and3s(lmt < 0L, i != 0L, i <= 0L),
         band3(lmt < 0L, i != 0L, i <= 0L))
  exp_eq(and3s(lmu < 1L, r != 1L, m <= 1L),
         band3(lmu < 1L, r != 1L, m <= 1L))
  exp_eq(and3s(lmv < 9L, v != 9L, h <= 9L),
         band3(lmv < 9L, v != 9L, h <= 9L))
  exp_eq(and3s(lmw < 0L, , ),
         band3(lmw < 0L, , ))
  exp_eq(and3s(lmx < 1L, , ),
         band3(lmx < 1L, , ))
  exp_eq(and3s(lmy < 9L, , ),
         band3(lmy < 9L, , ))
  exp_eq(and3s(lmz < 0L, , c == 0L),
         band3(lmz < 0L, , c == 0L))
  exp_eq(and3s(lna < 1L, , e == 1L),
         band3(lna < 1L, , e == 1L))
  exp_eq(and3s(lnb < 9L, , q == 9L),
         band3(lnb < 9L, , q == 9L))
  exp_eq(and3s(lnc < 0L, z != 0L, ),
         band3(lnc < 0L, z != 0L, ))
  exp_eq(and3s(lnd < 1L, y != 1L, ),
         band3(lnd < 1L, y != 1L, ))
  exp_eq(and3s(lne < 9L, a != 9L, ),
         band3(lne < 9L, a != 9L, ))
  exp_eq(and3s(lnf < 0L, o != 0L, s == 0L),
         band3(lnf < 0L, o != 0L, s == 0L))
  exp_eq(and3s(lng < 1L, m != 1L, l == 1L),
         band3(lng < 1L, m != 1L, l == 1L))
  exp_eq(and3s(lnh < 9L, n != 9L, u == 9L),
         band3(lnh < 9L, n != 9L, u == 9L))
  exp_eq(and3s(lni < 0L, , ),
         band3(lni < 0L, , ))
  exp_eq(and3s(lnj < 1L, , ),
         band3(lnj < 1L, , ))
  exp_eq(and3s(lnk < 9L, , ),
         band3(lnk < 9L, , ))
  exp_eq(and3s(lnl < 0L, , t > 0L),
         band3(lnl < 0L, , t > 0L))
  exp_eq(and3s(lnm < 1L, , g > 1L),
         band3(lnm < 1L, , g > 1L))
  exp_eq(and3s(lnn < 9L, , o > 9L),
         band3(lnn < 9L, , o > 9L))
  exp_eq(and3s(lno < 0L, z != 0L, ),
         band3(lno < 0L, z != 0L, ))
  exp_eq(and3s(lnp < 1L, p != 1L, ),
         band3(lnp < 1L, p != 1L, ))
  exp_eq(and3s(lnq < 9L, q != 9L, ),
         band3(lnq < 9L, q != 9L, ))
  exp_eq(and3s(lnr < 0L, s != 0L, g > 0L),
         band3(lnr < 0L, s != 0L, g > 0L))
  exp_eq(and3s(lns < 1L, p != 1L, v > 1L),
         band3(lns < 1L, p != 1L, v > 1L))
  exp_eq(and3s(lnt < 9L, l != 9L, t > 9L),
         band3(lnt < 9L, l != 9L, t > 9L))
  exp_eq(and3s(lnu < 0L, , ),
         band3(lnu < 0L, , ))
  exp_eq(and3s(lnv < 1L, , ),
         band3(lnv < 1L, , ))
  exp_eq(and3s(lnw < 9L, , ),
         band3(lnw < 9L, , ))
  exp_eq(and3s(lnx < 0L, , c >= 0L),
         band3(lnx < 0L, , c >= 0L))
  exp_eq(and3s(lny < 1L, , l >= 1L),
         band3(lny < 1L, , l >= 1L))
  exp_eq(and3s(lnz < 9L, , m >= 9L),
         band3(lnz < 9L, , m >= 9L))
  exp_eq(and3s(loa < 0L, b != 0L, ),
         band3(loa < 0L, b != 0L, ))
  exp_eq(and3s(lob < 1L, u != 1L, ),
         band3(lob < 1L, u != 1L, ))
  exp_eq(and3s(loc < 9L, x != 9L, ),
         band3(loc < 9L, x != 9L, ))
  exp_eq(and3s(lod < 0L, m != 0L, c >= 0L),
         band3(lod < 0L, m != 0L, c >= 0L))
  exp_eq(and3s(loe < 1L, o != 1L, m >= 1L),
         band3(loe < 1L, o != 1L, m >= 1L))
  exp_eq(and3s(lof < 9L, p != 9L, i >= 9L),
         band3(lof < 9L, p != 9L, i >= 9L))
  exp_eq(and3s(log < 0L, , ),
         band3(log < 0L, , ))
  exp_eq(and3s(loh < 1L, , ),
         band3(loh < 1L, , ))
  exp_eq(and3s(loi < 9L, , ),
         band3(loi < 9L, , ))
  exp_eq(and3s(loj < 0L, , logi_l),
         band3(loj < 0L, , logi_l))
  exp_eq(and3s(lok < 1L, , logi_h),
         band3(lok < 1L, , logi_h))
  exp_eq(and3s(lol < 9L, , logi_n),
         band3(lol < 9L, , logi_n))
  exp_eq(and3s(lom < 0L, o %between% c(-1L, 1L), ),
         band3(lom < 0L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(lon < 1L, p %between% c(-1L, 1L), ),
         band3(lon < 1L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(loo < 9L, j %between% c(-1L, 1L), ),
         band3(loo < 9L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(lop < 0L, f %between% c(-1L, 1L), logi_g),
         band3(lop < 0L, f %between% c(-1L, 1L), logi_g))
  exp_eq(and3s(loq < 1L, i %between% c(-1L, 1L), logi_x),
         band3(loq < 1L, i %between% c(-1L, 1L), logi_x))
  exp_eq(and3s(lor < 9L, z %between% c(-1L, 1L), logi_u),
         band3(lor < 9L, z %between% c(-1L, 1L), logi_u))
  exp_eq(and3s(los < 0L, , ),
         band3(los < 0L, , ))
  exp_eq(and3s(lot < 1L, , ),
         band3(lot < 1L, , ))
  exp_eq(and3s(lou < 9L, , ),
         band3(lou < 9L, , ))
  exp_eq(and3s(lov < 0L, , !logi_u),
         band3(lov < 0L, , !logi_u))
  exp_eq(and3s(low < 1L, , !logi_c),
         band3(low < 1L, , !logi_c))
  exp_eq(and3s(lox < 9L, , !logi_i),
         band3(lox < 9L, , !logi_i))
  exp_eq(and3s(loy < 0L, d %between% c(-1L, 1L), ),
         band3(loy < 0L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(loz < 1L, n %between% c(-1L, 1L), ),
         band3(loz < 1L, n %between% c(-1L, 1L), ))
  exp_eq(and3s(lpa < 9L, z %between% c(-1L, 1L), ),
         band3(lpa < 9L, z %between% c(-1L, 1L), ))
  exp_eq(and3s(lpb < 0L, j %between% c(-1L, 1L), !logi_f),
         band3(lpb < 0L, j %between% c(-1L, 1L), !logi_f))
  exp_eq(and3s(lpc < 1L, z %between% c(-1L, 1L), !logi_d),
         band3(lpc < 1L, z %between% c(-1L, 1L), !logi_d))
  exp_eq(and3s(lpd < 9L, t %between% c(-1L, 1L), !logi_h),
         band3(lpd < 9L, t %between% c(-1L, 1L), !logi_h))
  exp_eq(and3s(lpe < 0L, , ),
         band3(lpe < 0L, , ))
  exp_eq(and3s(lpf < 1L, , ),
         band3(lpf < 1L, , ))
  exp_eq(and3s(lpg < 9L, , ),
         band3(lpg < 9L, , ))
  exp_eq(and3s(lph < 0L, , a != 0L),
         band3(lph < 0L, , a != 0L))
  exp_eq(and3s(lpi < 1L, , m != 1L),
         band3(lpi < 1L, , m != 1L))
  exp_eq(and3s(lpj < 9L, , o != 9L),
         band3(lpj < 9L, , o != 9L))
  exp_eq(and3s(lpk < 0L, g %between% c(-1L, 1L), ),
         band3(lpk < 0L, g %between% c(-1L, 1L), ))
  exp_eq(and3s(lpl < 1L, o %between% c(-1L, 1L), ),
         band3(lpl < 1L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(lpm < 9L, q %between% c(-1L, 1L), ),
         band3(lpm < 9L, q %between% c(-1L, 1L), ))
  exp_eq(and3s(lpn < 0L, u %between% c(-1L, 1L), c != 0L),
         band3(lpn < 0L, u %between% c(-1L, 1L), c != 0L))
  exp_eq(and3s(lpo < 1L, w %between% c(-1L, 1L), k != 1L),
         band3(lpo < 1L, w %between% c(-1L, 1L), k != 1L))
  exp_eq(and3s(lpp < 9L, b %between% c(-1L, 1L), h != 9L),
         band3(lpp < 9L, b %between% c(-1L, 1L), h != 9L))
  exp_eq(and3s(lpq < 0L, , ),
         band3(lpq < 0L, , ))
  exp_eq(and3s(lpr < 1L, , ),
         band3(lpr < 1L, , ))
  exp_eq(and3s(lps < 9L, , ),
         band3(lps < 9L, , ))
  exp_eq(and3s(lpt < 0L, , j %between% c(-1L, 1L)),
         band3(lpt < 0L, , j %between% c(-1L, 1L)))
  exp_eq(and3s(lpu < 1L, , e %between% c(-1L, 1L)),
         band3(lpu < 1L, , e %between% c(-1L, 1L)))
  exp_eq(and3s(lpv < 9L, , q %between% c(-1L, 1L)),
         band3(lpv < 9L, , q %between% c(-1L, 1L)))
  exp_eq(and3s(lpw < 0L, q %between% c(-1L, 1L), ),
         band3(lpw < 0L, q %between% c(-1L, 1L), ))
  exp_eq(and3s(lpx < 1L, e %between% c(-1L, 1L), ),
         band3(lpx < 1L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(lpy < 9L, l %between% c(-1L, 1L), ),
         band3(lpy < 9L, l %between% c(-1L, 1L), ))
  exp_eq(and3s(lpz < 0L, l %between% c(-1L, 1L), j %between% c(-1L, 1L)),
         band3(lpz < 0L, l %between% c(-1L, 1L), j %between% c(-1L, 1L)))
  exp_eq(and3s(lqa < 1L, w %between% c(-1L, 1L), s %between% c(-1L, 1L)),
         band3(lqa < 1L, w %between% c(-1L, 1L), s %between% c(-1L, 1L)))
  exp_eq(and3s(lqb < 9L, t %between% c(-1L, 1L), z %between% c(-1L, 1L)),
         band3(lqb < 9L, t %between% c(-1L, 1L), z %between% c(-1L, 1L)))
  exp_eq(and3s(lqc < 0L, , ),
         band3(lqc < 0L, , ))
  exp_eq(and3s(lqd < 1L, , ),
         band3(lqd < 1L, , ))
  exp_eq(and3s(lqe < 9L, , ),
         band3(lqe < 9L, , ))
  exp_eq(and3s(lqf < 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lqf < 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqg < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lqg < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqh < 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lqh < 9L, , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqi < 0L, q %between% c(-1L, 1L), ),
         band3(lqi < 0L, q %between% c(-1L, 1L), ))
  exp_eq(and3s(lqj < 1L, f %between% c(-1L, 1L), ),
         band3(lqj < 1L, f %between% c(-1L, 1L), ))
  exp_eq(and3s(lqk < 9L, u %between% c(-1L, 1L), ),
         band3(lqk < 9L, u %between% c(-1L, 1L), ))
  exp_eq(and3s(lql < 0L, a %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lql < 0L, a %between% c(-1L, 1L), t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqm < 1L, v %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lqm < 1L, v %between% c(-1L, 1L), b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqn < 9L, n %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lqn < 9L, n %between% c(-1L, 1L), p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lqo < 0L, , ),
         band3(lqo < 0L, , ))
  exp_eq(and3s(lqp < 1L, , ),
         band3(lqp < 1L, , ))
  exp_eq(and3s(lqq < 9L, , ),
         band3(lqq < 9L, , ))
  exp_eq(and3s(lqr < 0L, , h %in% 1:4),
         band3(lqr < 0L, , h %in% 1:4))
  exp_eq(and3s(lqs < 1L, , d %in% 1:4),
         band3(lqs < 1L, , d %in% 1:4))
  exp_eq(and3s(lqt < 9L, , j %in% 1:4),
         band3(lqt < 9L, , j %in% 1:4))
  exp_eq(and3s(lqu < 0L, d %between% c(-1L, 1L), ),
         band3(lqu < 0L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(lqv < 1L, v %between% c(-1L, 1L), ),
         band3(lqv < 1L, v %between% c(-1L, 1L), ))
  exp_eq(and3s(lqw < 9L, b %between% c(-1L, 1L), ),
         band3(lqw < 9L, b %between% c(-1L, 1L), ))
  exp_eq(and3s(lqx < 0L, y %between% c(-1L, 1L), b %in% 1:4),
         band3(lqx < 0L, y %between% c(-1L, 1L), b %in% 1:4))
  exp_eq(and3s(lqy < 1L, j %between% c(-1L, 1L), a %in% 1:4),
         band3(lqy < 1L, j %between% c(-1L, 1L), a %in% 1:4))
  exp_eq(and3s(lqz < 9L, j %between% c(-1L, 1L), l %in% 1:4),
         band3(lqz < 9L, j %between% c(-1L, 1L), l %in% 1:4))
  exp_eq(and3s(lra < 0L, , ),
         band3(lra < 0L, , ))
  exp_eq(and3s(lrb < 1L, , ),
         band3(lrb < 1L, , ))
  exp_eq(and3s(lrc < 9L, , ),
         band3(lrc < 9L, , ))
  exp_eq(and3s(lrd < 0L, , e < 0L),
         band3(lrd < 0L, , e < 0L))
  exp_eq(and3s(lre < 1L, , y < 1L),
         band3(lre < 1L, , y < 1L))
  exp_eq(and3s(lrf < 9L, , m < 9L),
         band3(lrf < 9L, , m < 9L))
  exp_eq(and3s(lrg < 0L, c %between% c(-1L, 1L), ),
         band3(lrg < 0L, c %between% c(-1L, 1L), ))
  exp_eq(and3s(lrh < 1L, r %between% c(-1L, 1L), ),
         band3(lrh < 1L, r %between% c(-1L, 1L), ))
  exp_eq(and3s(lri < 9L, j %between% c(-1L, 1L), ),
         band3(lri < 9L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(lrj < 0L, z %between% c(-1L, 1L), j < 0L),
         band3(lrj < 0L, z %between% c(-1L, 1L), j < 0L))
  exp_eq(and3s(lrk < 1L, x %between% c(-1L, 1L), h < 1L),
         band3(lrk < 1L, x %between% c(-1L, 1L), h < 1L))
  exp_eq(and3s(lrl < 9L, s %between% c(-1L, 1L), i < 9L),
         band3(lrl < 9L, s %between% c(-1L, 1L), i < 9L))
  exp_eq(and3s(lrm < 0L, , ),
         band3(lrm < 0L, , ))
  exp_eq(and3s(lrn < 1L, , ),
         band3(lrn < 1L, , ))
  exp_eq(and3s(lro < 9L, , ),
         band3(lro < 9L, , ))
  exp_eq(and3s(lrp < 0L, , r <= 0L),
         band3(lrp < 0L, , r <= 0L))
  exp_eq(and3s(lrq < 1L, , d <= 1L),
         band3(lrq < 1L, , d <= 1L))
  exp_eq(and3s(lrr < 9L, , v <= 9L),
         band3(lrr < 9L, , v <= 9L))
  exp_eq(and3s(lrs < 0L, h %between% c(-1L, 1L), ),
         band3(lrs < 0L, h %between% c(-1L, 1L), ))
  exp_eq(and3s(lrt < 1L, y %between% c(-1L, 1L), ),
         band3(lrt < 1L, y %between% c(-1L, 1L), ))
  exp_eq(and3s(lru < 9L, b %between% c(-1L, 1L), ),
         band3(lru < 9L, b %between% c(-1L, 1L), ))
  exp_eq(and3s(lrv < 0L, o %between% c(-1L, 1L), l <= 0L),
         band3(lrv < 0L, o %between% c(-1L, 1L), l <= 0L))
  exp_eq(and3s(lrw < 1L, q %between% c(-1L, 1L), o <= 1L),
         band3(lrw < 1L, q %between% c(-1L, 1L), o <= 1L))
  exp_eq(and3s(lrx < 9L, y %between% c(-1L, 1L), h <= 9L),
         band3(lrx < 9L, y %between% c(-1L, 1L), h <= 9L))
  exp_eq(and3s(lry < 0L, , ),
         band3(lry < 0L, , ))
  exp_eq(and3s(lrz < 1L, , ),
         band3(lrz < 1L, , ))
  exp_eq(and3s(lsa < 9L, , ),
         band3(lsa < 9L, , ))
  exp_eq(and3s(lsb < 0L, , u == 0L),
         band3(lsb < 0L, , u == 0L))
  exp_eq(and3s(lsc < 1L, , k == 1L),
         band3(lsc < 1L, , k == 1L))
  exp_eq(and3s(lsd < 9L, , i == 9L),
         band3(lsd < 9L, , i == 9L))
  exp_eq(and3s(lse < 0L, j %between% c(-1L, 1L), ),
         band3(lse < 0L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(lsf < 1L, g %between% c(-1L, 1L), ),
         band3(lsf < 1L, g %between% c(-1L, 1L), ))
  exp_eq(and3s(lsg < 9L, w %between% c(-1L, 1L), ),
         band3(lsg < 9L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(lsh < 0L, s %between% c(-1L, 1L), c == 0L),
         band3(lsh < 0L, s %between% c(-1L, 1L), c == 0L))
  exp_eq(and3s(lsi < 1L, q %between% c(-1L, 1L), q == 1L),
         band3(lsi < 1L, q %between% c(-1L, 1L), q == 1L))
  exp_eq(and3s(lsj < 9L, y %between% c(-1L, 1L), w == 9L),
         band3(lsj < 9L, y %between% c(-1L, 1L), w == 9L))
  exp_eq(and3s(lsk < 0L, , ),
         band3(lsk < 0L, , ))
  exp_eq(and3s(lsl < 1L, , ),
         band3(lsl < 1L, , ))
  exp_eq(and3s(lsm < 9L, , ),
         band3(lsm < 9L, , ))
  exp_eq(and3s(lsn < 0L, , n > 0L),
         band3(lsn < 0L, , n > 0L))
  exp_eq(and3s(lso < 1L, , c > 1L),
         band3(lso < 1L, , c > 1L))
  exp_eq(and3s(lsp < 9L, , e > 9L),
         band3(lsp < 9L, , e > 9L))
  exp_eq(and3s(lsq < 0L, r %between% c(-1L, 1L), ),
         band3(lsq < 0L, r %between% c(-1L, 1L), ))
  exp_eq(and3s(lsr < 1L, e %between% c(-1L, 1L), ),
         band3(lsr < 1L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(lss < 9L, e %between% c(-1L, 1L), ),
         band3(lss < 9L, e %between% c(-1L, 1L), ))
  exp_eq(and3s(lst < 0L, r %between% c(-1L, 1L), q > 0L),
         band3(lst < 0L, r %between% c(-1L, 1L), q > 0L))
  exp_eq(and3s(lsu < 1L, p %between% c(-1L, 1L), o > 1L),
         band3(lsu < 1L, p %between% c(-1L, 1L), o > 1L))
  exp_eq(and3s(lsv < 9L, w %between% c(-1L, 1L), m > 9L),
         band3(lsv < 9L, w %between% c(-1L, 1L), m > 9L))
  exp_eq(and3s(lsw < 0L, , ),
         band3(lsw < 0L, , ))
  exp_eq(and3s(lsx < 1L, , ),
         band3(lsx < 1L, , ))
  exp_eq(and3s(lsy < 9L, , ),
         band3(lsy < 9L, , ))
  exp_eq(and3s(lsz < 0L, , k >= 0L),
         band3(lsz < 0L, , k >= 0L))
  exp_eq(and3s(lta < 1L, , f >= 1L),
         band3(lta < 1L, , f >= 1L))
  exp_eq(and3s(ltb < 9L, , g >= 9L),
         band3(ltb < 9L, , g >= 9L))
  exp_eq(and3s(ltc < 0L, j %between% c(-1L, 1L), ),
         band3(ltc < 0L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(ltd < 1L, l %between% c(-1L, 1L), ),
         band3(ltd < 1L, l %between% c(-1L, 1L), ))
  exp_eq(and3s(lte < 9L, z %between% c(-1L, 1L), ),
         band3(lte < 9L, z %between% c(-1L, 1L), ))
  exp_eq(and3s(ltf < 0L, t %between% c(-1L, 1L), f >= 0L),
         band3(ltf < 0L, t %between% c(-1L, 1L), f >= 0L))
  exp_eq(and3s(ltg < 1L, o %between% c(-1L, 1L), j >= 1L),
         band3(ltg < 1L, o %between% c(-1L, 1L), j >= 1L))
  exp_eq(and3s(lth < 9L, h %between% c(-1L, 1L), o >= 9L),
         band3(lth < 9L, h %between% c(-1L, 1L), o >= 9L))
  exp_eq(and3s(lti < 0L, , ),
         band3(lti < 0L, , ))
  exp_eq(and3s(ltj < 1L, , ),
         band3(ltj < 1L, , ))
  exp_eq(and3s(ltk < 9L, , ),
         band3(ltk < 9L, , ))
  exp_eq(and3s(ltl < 0L, , logi_n),
         band3(ltl < 0L, , logi_n))
  exp_eq(and3s(ltm < 1L, , logi_g),
         band3(ltm < 1L, , logi_g))
  exp_eq(and3s(ltn < 9L, , logi_w),
         band3(ltn < 9L, , logi_w))
  exp_eq(and3s(lto < 0L, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lto < 0L, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ltp < 1L, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ltp < 1L, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ltq < 9L, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ltq < 9L, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ltr < 0L, k %in% c(4L, -3L, 2L, 7L, 8L), logi_e),
         band3(ltr < 0L, k %in% c(4L, -3L, 2L, 7L, 8L), logi_e))
  exp_eq(and3s(lts < 1L, k %in% c(4L, -3L, 2L, 7L, 8L), logi_v),
         band3(lts < 1L, k %in% c(4L, -3L, 2L, 7L, 8L), logi_v))
  exp_eq(and3s(ltt < 9L, x %in% c(4L, -3L, 2L, 7L, 8L), logi_x),
         band3(ltt < 9L, x %in% c(4L, -3L, 2L, 7L, 8L), logi_x))
  exp_eq(and3s(ltu < 0L, , ),
         band3(ltu < 0L, , ))
  exp_eq(and3s(ltv < 1L, , ),
         band3(ltv < 1L, , ))
  exp_eq(and3s(ltw < 9L, , ),
         band3(ltw < 9L, , ))
  exp_eq(and3s(ltx < 0L, , logi_r),
         band3(ltx < 0L, , logi_r))
  exp_eq(and3s(lty < 1L, , logi_i),
         band3(lty < 1L, , logi_i))
  exp_eq(and3s(ltz < 9L, , logi_d),
         band3(ltz < 9L, , logi_d))
  exp_eq(and3s(lua < 0L, n %in% 1:4, ),
         band3(lua < 0L, n %in% 1:4, ))
  exp_eq(and3s(lub < 1L, g %in% 1:4, ),
         band3(lub < 1L, g %in% 1:4, ))
  exp_eq(and3s(luc < 9L, m %in% 1:4, ),
         band3(luc < 9L, m %in% 1:4, ))
  exp_eq(and3s(lud < 0L, u %in% 1:4, logi_g),
         band3(lud < 0L, u %in% 1:4, logi_g))
  exp_eq(and3s(lue < 1L, z %in% 1:4, logi_b),
         band3(lue < 1L, z %in% 1:4, logi_b))
  exp_eq(and3s(luf < 9L, w %in% 1:4, logi_p),
         band3(luf < 9L, w %in% 1:4, logi_p))
  exp_eq(and3s(lug < 0L, , ),
         band3(lug < 0L, , ))
  exp_eq(and3s(luh < 1L, , ),
         band3(luh < 1L, , ))
  exp_eq(and3s(lui < 9L, , ),
         band3(lui < 9L, , ))
  exp_eq(and3s(luj < 0L, , !logi_c),
         band3(luj < 0L, , !logi_c))
  exp_eq(and3s(luk < 1L, , !logi_i),
         band3(luk < 1L, , !logi_i))
  exp_eq(and3s(lul < 9L, , !logi_n),
         band3(lul < 9L, , !logi_n))
  exp_eq(and3s(lum < 0L, x %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lum < 0L, x %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lun < 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lun < 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(luo < 9L, x %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(luo < 9L, x %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lup < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), !logi_w),
         band3(lup < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), !logi_w))
  exp_eq(and3s(luq < 1L, c %in% c(4L, -3L, 2L, 7L, 8L), !logi_y),
         band3(luq < 1L, c %in% c(4L, -3L, 2L, 7L, 8L), !logi_y))
  exp_eq(and3s(lur < 9L, d %in% c(4L, -3L, 2L, 7L, 8L), !logi_n),
         band3(lur < 9L, d %in% c(4L, -3L, 2L, 7L, 8L), !logi_n))
  exp_eq(and3s(lus < 0L, , ),
         band3(lus < 0L, , ))
  exp_eq(and3s(lut < 1L, , ),
         band3(lut < 1L, , ))
  exp_eq(and3s(luu < 9L, , ),
         band3(luu < 9L, , ))
  exp_eq(and3s(luv < 0L, , !logi_p),
         band3(luv < 0L, , !logi_p))
  exp_eq(and3s(luw < 1L, , !logi_l),
         band3(luw < 1L, , !logi_l))
  exp_eq(and3s(lux < 9L, , !logi_n),
         band3(lux < 9L, , !logi_n))
  exp_eq(and3s(luy < 0L, y %in% 1:4, ),
         band3(luy < 0L, y %in% 1:4, ))
  exp_eq(and3s(luz < 1L, j %in% 1:4, ),
         band3(luz < 1L, j %in% 1:4, ))
  exp_eq(and3s(lva < 9L, z %in% 1:4, ),
         band3(lva < 9L, z %in% 1:4, ))
  exp_eq(and3s(lvb < 0L, f %in% 1:4, !logi_u),
         band3(lvb < 0L, f %in% 1:4, !logi_u))
  exp_eq(and3s(lvc < 1L, p %in% 1:4, !logi_u),
         band3(lvc < 1L, p %in% 1:4, !logi_u))
  exp_eq(and3s(lvd < 9L, b %in% 1:4, !logi_e),
         band3(lvd < 9L, b %in% 1:4, !logi_e))
  exp_eq(and3s(lve < 0L, , ),
         band3(lve < 0L, , ))
  exp_eq(and3s(lvf < 1L, , ),
         band3(lvf < 1L, , ))
  exp_eq(and3s(lvg < 9L, , ),
         band3(lvg < 9L, , ))
  exp_eq(and3s(lvh < 0L, , e != 0L),
         band3(lvh < 0L, , e != 0L))
  exp_eq(and3s(lvi < 1L, , c != 1L),
         band3(lvi < 1L, , c != 1L))
  exp_eq(and3s(lvj < 9L, , d != 9L),
         band3(lvj < 9L, , d != 9L))
  exp_eq(and3s(lvk < 0L, c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lvk < 0L, c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lvl < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lvl < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lvm < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lvm < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lvn < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), z != 0L),
         band3(lvn < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), z != 0L))
  exp_eq(and3s(lvo < 1L, f %in% c(4L, -3L, 2L, 7L, 8L), q != 1L),
         band3(lvo < 1L, f %in% c(4L, -3L, 2L, 7L, 8L), q != 1L))
  exp_eq(and3s(lvp < 9L, y %in% c(4L, -3L, 2L, 7L, 8L), o != 9L),
         band3(lvp < 9L, y %in% c(4L, -3L, 2L, 7L, 8L), o != 9L))
  exp_eq(and3s(lvq < 0L, , ),
         band3(lvq < 0L, , ))
  exp_eq(and3s(lvr < 1L, , ),
         band3(lvr < 1L, , ))
  exp_eq(and3s(lvs < 9L, , ),
         band3(lvs < 9L, , ))
  exp_eq(and3s(lvt < 0L, , t != 0L),
         band3(lvt < 0L, , t != 0L))
  exp_eq(and3s(lvu < 1L, , w != 1L),
         band3(lvu < 1L, , w != 1L))
  exp_eq(and3s(lvv < 9L, , t != 9L),
         band3(lvv < 9L, , t != 9L))
  exp_eq(and3s(lvw < 0L, f %in% 1:4, ),
         band3(lvw < 0L, f %in% 1:4, ))
  exp_eq(and3s(lvx < 1L, k %in% 1:4, ),
         band3(lvx < 1L, k %in% 1:4, ))
  exp_eq(and3s(lvy < 9L, u %in% 1:4, ),
         band3(lvy < 9L, u %in% 1:4, ))
  exp_eq(and3s(lvz < 0L, t %in% 1:4, e != 0L),
         band3(lvz < 0L, t %in% 1:4, e != 0L))
  exp_eq(and3s(lwa < 1L, m %in% 1:4, c != 1L),
         band3(lwa < 1L, m %in% 1:4, c != 1L))
  exp_eq(and3s(lwb < 9L, d %in% 1:4, k != 9L),
         band3(lwb < 9L, d %in% 1:4, k != 9L))
  exp_eq(and3s(lwc < 0L, , ),
         band3(lwc < 0L, , ))
  exp_eq(and3s(lwd < 1L, , ),
         band3(lwd < 1L, , ))
  exp_eq(and3s(lwe < 9L, , ),
         band3(lwe < 9L, , ))
  exp_eq(and3s(lwf < 0L, , j %between% c(-1L, 1L)),
         band3(lwf < 0L, , j %between% c(-1L, 1L)))
  exp_eq(and3s(lwg < 1L, , m %between% c(-1L, 1L)),
         band3(lwg < 1L, , m %between% c(-1L, 1L)))
  exp_eq(and3s(lwh < 9L, , e %between% c(-1L, 1L)),
         band3(lwh < 9L, , e %between% c(-1L, 1L)))
  exp_eq(and3s(lwi < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lwi < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lwj < 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lwj < 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lwk < 9L, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lwk < 9L, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lwl < 0L, r %in% c(4L, -3L, 2L, 7L, 8L), a %between% c(-1L, 1L)),
         band3(lwl < 0L, r %in% c(4L, -3L, 2L, 7L, 8L), a %between% c(-1L, 1L)))
  exp_eq(and3s(lwm < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)),
         band3(lwm < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), r %between% c(-1L, 1L)))
  exp_eq(and3s(lwn < 9L, t %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L)),
         band3(lwn < 9L, t %in% c(4L, -3L, 2L, 7L, 8L), v %between% c(-1L, 1L)))
  exp_eq(and3s(lwo < 0L, , ),
         band3(lwo < 0L, , ))
  exp_eq(and3s(lwp < 1L, , ),
         band3(lwp < 1L, , ))
  exp_eq(and3s(lwq < 9L, , ),
         band3(lwq < 9L, , ))
  exp_eq(and3s(lwr < 0L, , g %between% c(-1L, 1L)),
         band3(lwr < 0L, , g %between% c(-1L, 1L)))
  exp_eq(and3s(lws < 1L, , l %between% c(-1L, 1L)),
         band3(lws < 1L, , l %between% c(-1L, 1L)))
  exp_eq(and3s(lwt < 9L, , a %between% c(-1L, 1L)),
         band3(lwt < 9L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(lwu < 0L, i %in% 1:4, ),
         band3(lwu < 0L, i %in% 1:4, ))
  exp_eq(and3s(lwv < 1L, l %in% 1:4, ),
         band3(lwv < 1L, l %in% 1:4, ))
  exp_eq(and3s(lww < 9L, c %in% 1:4, ),
         band3(lww < 9L, c %in% 1:4, ))
  exp_eq(and3s(lwx < 0L, d %in% 1:4, g %between% c(-1L, 1L)),
         band3(lwx < 0L, d %in% 1:4, g %between% c(-1L, 1L)))
  exp_eq(and3s(lwy < 1L, r %in% 1:4, l %between% c(-1L, 1L)),
         band3(lwy < 1L, r %in% 1:4, l %between% c(-1L, 1L)))
  exp_eq(and3s(lwz < 9L, j %in% 1:4, s %between% c(-1L, 1L)),
         band3(lwz < 9L, j %in% 1:4, s %between% c(-1L, 1L)))
  exp_eq(and3s(lxa < 0L, , ),
         band3(lxa < 0L, , ))
  exp_eq(and3s(lxb < 1L, , ),
         band3(lxb < 1L, , ))
  exp_eq(and3s(lxc < 9L, , ),
         band3(lxc < 9L, , ))
  exp_eq(and3s(lxd < 0L, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxd < 0L, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxe < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxe < 1L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxf < 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxf < 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxg < 0L, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lxg < 0L, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lxh < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lxh < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lxi < 9L, p %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lxi < 9L, p %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lxj < 0L, s %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxj < 0L, s %in% c(4L, -3L, 2L, 7L, 8L), g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxk < 1L, s %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxk < 1L, s %in% c(4L, -3L, 2L, 7L, 8L), m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxl < 9L, r %in% c(4L, -3L, 2L, 7L, 8L), n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(lxl < 9L, r %in% c(4L, -3L, 2L, 7L, 8L), n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(lxm < 0L, , ),
         band3(lxm < 0L, , ))
  exp_eq(and3s(lxn < 1L, , ),
         band3(lxn < 1L, , ))
  exp_eq(and3s(lxo < 9L, , ),
         band3(lxo < 9L, , ))
  exp_eq(and3s(lxp < 0L, , w %in% 1:4),
         band3(lxp < 0L, , w %in% 1:4))
  exp_eq(and3s(lxq < 1L, , w %in% 1:4),
         band3(lxq < 1L, , w %in% 1:4))
  exp_eq(and3s(lxr < 9L, , a %in% 1:4),
         band3(lxr < 9L, , a %in% 1:4))
  exp_eq(and3s(lxs < 0L, p %in% 1:4, ),
         band3(lxs < 0L, p %in% 1:4, ))
  exp_eq(and3s(lxt < 1L, o %in% 1:4, ),
         band3(lxt < 1L, o %in% 1:4, ))
  exp_eq(and3s(lxu < 9L, q %in% 1:4, ),
         band3(lxu < 9L, q %in% 1:4, ))
  exp_eq(and3s(lxv < 0L, e %in% 1:4, s %in% 1:4),
         band3(lxv < 0L, e %in% 1:4, s %in% 1:4))
  exp_eq(and3s(lxw < 1L, s %in% 1:4, d %in% 1:4),
         band3(lxw < 1L, s %in% 1:4, d %in% 1:4))
  exp_eq(and3s(lxx < 9L, a %in% 1:4, m %in% 1:4),
         band3(lxx < 9L, a %in% 1:4, m %in% 1:4))
  exp_eq(and3s(lxy < 0L, , ),
         band3(lxy < 0L, , ))
  exp_eq(and3s(lxz < 1L, , ),
         band3(lxz < 1L, , ))
  exp_eq(and3s(lya < 9L, , ),
         band3(lya < 9L, , ))
  exp_eq(and3s(lyb < 0L, , h < 0L),
         band3(lyb < 0L, , h < 0L))
  exp_eq(and3s(lyc < 1L, , s < 1L),
         band3(lyc < 1L, , s < 1L))
  exp_eq(and3s(lyd < 9L, , k < 9L),
         band3(lyd < 9L, , k < 9L))
  exp_eq(and3s(lye < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lye < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lyf < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lyf < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lyg < 9L, z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(lyg < 9L, z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(lyh < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), i < 0L),
         band3(lyh < 0L, w %in% c(4L, -3L, 2L, 7L, 8L), i < 0L))
  exp_eq(and3s(lyi < 1L, o %in% c(4L, -3L, 2L, 7L, 8L), r < 1L),
         band3(lyi < 1L, o %in% c(4L, -3L, 2L, 7L, 8L), r < 1L))
  exp_eq(and3s(lyj < 9L, j %in% c(4L, -3L, 2L, 7L, 8L), d < 9L),
         band3(lyj < 9L, j %in% c(4L, -3L, 2L, 7L, 8L), d < 9L))
  exp_eq(and3s(lyk < 0L, , ),
         band3(lyk < 0L, , ))
  exp_eq(and3s(lyl < 1L, , ),
         band3(lyl < 1L, , ))
  exp_eq(and3s(lym < 9L, , ),
         band3(lym < 9L, , ))
  exp_eq(and3s(lyn < 0L, , i < 0L),
         band3(lyn < 0L, , i < 0L))
  exp_eq(and3s(lyo < 1L, , x < 1L),
         band3(lyo < 1L, , x < 1L))
  exp_eq(and3s(lyp < 9L, , d < 9L),
         band3(lyp < 9L, , d < 9L))
  exp_eq(and3s(lyq < 0L, h %in% 1:4, ),
         band3(lyq < 0L, h %in% 1:4, ))
  exp_eq(and3s(lyr < 1L, y %in% 1:4, ),
         band3(lyr < 1L, y %in% 1:4, ))
  exp_eq(and3s(lys < 9L, t %in% 1:4, ),
         band3(lys < 9L, t %in% 1:4, ))
  exp_eq(and3s(lyt < 0L, y %in% 1:4, g < 0L),
         band3(lyt < 0L, y %in% 1:4, g < 0L))
  exp_eq(and3s(lyu < 1L, h %in% 1:4, e < 1L),
         band3(lyu < 1L, h %in% 1:4, e < 1L))
  exp_eq(and3s(lyv < 9L, z %in% 1:4, p < 9L),
         band3(lyv < 9L, z %in% 1:4, p < 9L))
  exp_eq(and3s(lyw < 0L, , ),
         band3(lyw < 0L, , ))
  exp_eq(and3s(lyx < 1L, , ),
         band3(lyx < 1L, , ))
  exp_eq(and3s(lyy < 9L, , ),
         band3(lyy < 9L, , ))
  exp_eq(and3s(lyz < 0L, , u <= 0L),
         band3(lyz < 0L, , u <= 0L))
  exp_eq(and3s(ma < 1L, , h <= 1L),
         band3(ma < 1L, , h <= 1L))
  exp_eq(and3s(mb < 9L, , y <= 9L),
         band3(mb < 9L, , y <= 9L))
  exp_eq(and3s(mc < 0L, v %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mc < 0L, v %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(md < 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(md < 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(me < 9L, f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(me < 9L, f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mf < 0L, c %in% c(4L, -3L, 2L, 7L, 8L), u <= 0L),
         band3(mf < 0L, c %in% c(4L, -3L, 2L, 7L, 8L), u <= 0L))
  exp_eq(and3s(mg < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), r <= 1L),
         band3(mg < 1L, r %in% c(4L, -3L, 2L, 7L, 8L), r <= 1L))
  exp_eq(and3s(mh < 9L, i %in% c(4L, -3L, 2L, 7L, 8L), m <= 9L),
         band3(mh < 9L, i %in% c(4L, -3L, 2L, 7L, 8L), m <= 9L))
  exp_eq(and3s(mi < 0L, , ),
         band3(mi < 0L, , ))
  exp_eq(and3s(mj < 1L, , ),
         band3(mj < 1L, , ))
  exp_eq(and3s(mk < 9L, , ),
         band3(mk < 9L, , ))
  exp_eq(and3s(ml < 0L, , r <= 0L),
         band3(ml < 0L, , r <= 0L))
  exp_eq(and3s(mm < 1L, , u <= 1L),
         band3(mm < 1L, , u <= 1L))
  exp_eq(and3s(mn < 9L, , q <= 9L),
         band3(mn < 9L, , q <= 9L))
  exp_eq(and3s(mo < 0L, d %in% 1:4, ),
         band3(mo < 0L, d %in% 1:4, ))
  exp_eq(and3s(mp < 1L, d %in% 1:4, ),
         band3(mp < 1L, d %in% 1:4, ))
  exp_eq(and3s(mq < 9L, p %in% 1:4, ),
         band3(mq < 9L, p %in% 1:4, ))
  exp_eq(and3s(mr < 0L, u %in% 1:4, j <= 0L),
         band3(mr < 0L, u %in% 1:4, j <= 0L))
  exp_eq(and3s(ms < 1L, k %in% 1:4, y <= 1L),
         band3(ms < 1L, k %in% 1:4, y <= 1L))
  exp_eq(and3s(mt < 9L, a %in% 1:4, n <= 9L),
         band3(mt < 9L, a %in% 1:4, n <= 9L))
  exp_eq(and3s(mu < 0L, , ),
         band3(mu < 0L, , ))
  exp_eq(and3s(mv < 1L, , ),
         band3(mv < 1L, , ))
  exp_eq(and3s(mw < 9L, , ),
         band3(mw < 9L, , ))
  exp_eq(and3s(mx < 0L, , j == 0L),
         band3(mx < 0L, , j == 0L))
  exp_eq(and3s(my < 1L, , r == 1L),
         band3(my < 1L, , r == 1L))
  exp_eq(and3s(mz < 9L, , g == 9L),
         band3(mz < 9L, , g == 9L))
  exp_eq(and3s(maa < 0L, z %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(maa < 0L, z %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mab < 1L, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mab < 1L, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mac < 9L, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mac < 9L, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mad < 0L, a %in% c(4L, -3L, 2L, 7L, 8L), g == 0L),
         band3(mad < 0L, a %in% c(4L, -3L, 2L, 7L, 8L), g == 0L))
  exp_eq(and3s(mae < 1L, t %in% c(4L, -3L, 2L, 7L, 8L), x == 1L),
         band3(mae < 1L, t %in% c(4L, -3L, 2L, 7L, 8L), x == 1L))
  exp_eq(and3s(maf < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), i == 9L),
         band3(maf < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), i == 9L))
  exp_eq(and3s(mag < 0L, , ),
         band3(mag < 0L, , ))
  exp_eq(and3s(mah < 1L, , ),
         band3(mah < 1L, , ))
  exp_eq(and3s(mai < 9L, , ),
         band3(mai < 9L, , ))
  exp_eq(and3s(maj < 0L, , t == 0L),
         band3(maj < 0L, , t == 0L))
  exp_eq(and3s(mak < 1L, , w == 1L),
         band3(mak < 1L, , w == 1L))
  exp_eq(and3s(mal < 9L, , q == 9L),
         band3(mal < 9L, , q == 9L))
  exp_eq(and3s(mam < 0L, b %in% 1:4, ),
         band3(mam < 0L, b %in% 1:4, ))
  exp_eq(and3s(man < 1L, b %in% 1:4, ),
         band3(man < 1L, b %in% 1:4, ))
  exp_eq(and3s(mao < 9L, r %in% 1:4, ),
         band3(mao < 9L, r %in% 1:4, ))
  exp_eq(and3s(map < 0L, s %in% 1:4, b == 0L),
         band3(map < 0L, s %in% 1:4, b == 0L))
  exp_eq(and3s(maq < 1L, b %in% 1:4, k == 1L),
         band3(maq < 1L, b %in% 1:4, k == 1L))
  exp_eq(and3s(mar < 9L, z %in% 1:4, a == 9L),
         band3(mar < 9L, z %in% 1:4, a == 9L))
  exp_eq(and3s(mas < 0L, , ),
         band3(mas < 0L, , ))
  exp_eq(and3s(mat < 1L, , ),
         band3(mat < 1L, , ))
  exp_eq(and3s(mau < 9L, , ),
         band3(mau < 9L, , ))
  exp_eq(and3s(mav < 0L, , y > 0L),
         band3(mav < 0L, , y > 0L))
  exp_eq(and3s(maw < 1L, , l > 1L),
         band3(maw < 1L, , l > 1L))
  exp_eq(and3s(max < 9L, , b > 9L),
         band3(max < 9L, , b > 9L))
  exp_eq(and3s(may < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(may < 0L, u %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(maz < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(maz < 1L, a %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mba < 9L, c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mba < 9L, c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mbb < 0L, x %in% c(4L, -3L, 2L, 7L, 8L), u > 0L),
         band3(mbb < 0L, x %in% c(4L, -3L, 2L, 7L, 8L), u > 0L))
  exp_eq(and3s(mbc < 1L, x %in% c(4L, -3L, 2L, 7L, 8L), f > 1L),
         band3(mbc < 1L, x %in% c(4L, -3L, 2L, 7L, 8L), f > 1L))
  exp_eq(and3s(mbd < 9L, o %in% c(4L, -3L, 2L, 7L, 8L), e > 9L),
         band3(mbd < 9L, o %in% c(4L, -3L, 2L, 7L, 8L), e > 9L))
  exp_eq(and3s(mbe < 0L, , ),
         band3(mbe < 0L, , ))
  exp_eq(and3s(mbf < 1L, , ),
         band3(mbf < 1L, , ))
  exp_eq(and3s(mbg < 9L, , ),
         band3(mbg < 9L, , ))
  exp_eq(and3s(mbh < 0L, , j > 0L),
         band3(mbh < 0L, , j > 0L))
  exp_eq(and3s(mbi < 1L, , y > 1L),
         band3(mbi < 1L, , y > 1L))
  exp_eq(and3s(mbj < 9L, , o > 9L),
         band3(mbj < 9L, , o > 9L))
  exp_eq(and3s(mbk < 0L, z %in% 1:4, ),
         band3(mbk < 0L, z %in% 1:4, ))
  exp_eq(and3s(mbl < 1L, j %in% 1:4, ),
         band3(mbl < 1L, j %in% 1:4, ))
  exp_eq(and3s(mbm < 9L, x %in% 1:4, ),
         band3(mbm < 9L, x %in% 1:4, ))
  exp_eq(and3s(mbn < 0L, e %in% 1:4, c > 0L),
         band3(mbn < 0L, e %in% 1:4, c > 0L))
  exp_eq(and3s(mbo < 1L, y %in% 1:4, p > 1L),
         band3(mbo < 1L, y %in% 1:4, p > 1L))
  exp_eq(and3s(mbp < 9L, p %in% 1:4, r > 9L),
         band3(mbp < 9L, p %in% 1:4, r > 9L))
  exp_eq(and3s(mbq < 0L, , ),
         band3(mbq < 0L, , ))
  exp_eq(and3s(mbr < 1L, , ),
         band3(mbr < 1L, , ))
  exp_eq(and3s(mbs < 9L, , ),
         band3(mbs < 9L, , ))
  exp_eq(and3s(mbt < 0L, , n >= 0L),
         band3(mbt < 0L, , n >= 0L))
  exp_eq(and3s(mbu < 1L, , w >= 1L),
         band3(mbu < 1L, , w >= 1L))
  exp_eq(and3s(mbv < 9L, , q >= 9L),
         band3(mbv < 9L, , q >= 9L))
  exp_eq(and3s(mbw < 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mbw < 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mbx < 1L, h %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mbx < 1L, h %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mby < 9L, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(mby < 9L, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(mbz < 0L, n %in% c(4L, -3L, 2L, 7L, 8L), y >= 0L),
         band3(mbz < 0L, n %in% c(4L, -3L, 2L, 7L, 8L), y >= 0L))
  exp_eq(and3s(mca < 1L, x %in% c(4L, -3L, 2L, 7L, 8L), w >= 1L),
         band3(mca < 1L, x %in% c(4L, -3L, 2L, 7L, 8L), w >= 1L))
  exp_eq(and3s(mcb < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L),
         band3(mcb < 9L, g %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L))
  exp_eq(and3s(mcc < 0L, , ),
         band3(mcc < 0L, , ))
  exp_eq(and3s(mcd < 1L, , ),
         band3(mcd < 1L, , ))
  exp_eq(and3s(mce < 9L, , ),
         band3(mce < 9L, , ))
  exp_eq(and3s(mcf < 0L, , z >= 0L),
         band3(mcf < 0L, , z >= 0L))
  exp_eq(and3s(mcg < 1L, , m >= 1L),
         band3(mcg < 1L, , m >= 1L))
  exp_eq(and3s(mch < 9L, , h >= 9L),
         band3(mch < 9L, , h >= 9L))
  exp_eq(and3s(mci < 0L, d %in% 1:4, ),
         band3(mci < 0L, d %in% 1:4, ))
  exp_eq(and3s(mcj < 1L, u %in% 1:4, ),
         band3(mcj < 1L, u %in% 1:4, ))
  exp_eq(and3s(mck < 9L, j %in% 1:4, ),
         band3(mck < 9L, j %in% 1:4, ))
  exp_eq(and3s(mcl < 0L, b %in% 1:4, k >= 0L),
         band3(mcl < 0L, b %in% 1:4, k >= 0L))
  exp_eq(and3s(mcm < 1L, y %in% 1:4, u >= 1L),
         band3(mcm < 1L, y %in% 1:4, u >= 1L))
  exp_eq(and3s(mcn < 9L, t %in% 1:4, f >= 9L),
         band3(mcn < 9L, t %in% 1:4, f >= 9L))
  exp_eq(and3s(mco < 0L, , ),
         band3(mco < 0L, , ))
  exp_eq(and3s(mcp < 1L, , ),
         band3(mcp < 1L, , ))
  exp_eq(and3s(mcq < 9L, , ),
         band3(mcq < 9L, , ))
  exp_eq(and3s(mcr < 0L, , logi_d),
         band3(mcr < 0L, , logi_d))
  exp_eq(and3s(mcs < 1L, , logi_m),
         band3(mcs < 1L, , logi_m))
  exp_eq(and3s(mct < 9L, , logi_v),
         band3(mct < 9L, , logi_v))
  exp_eq(and3s(mcu < 0L, r < 0L, ),
         band3(mcu < 0L, r < 0L, ))
  exp_eq(and3s(mcv < 1L, b < 1L, ),
         band3(mcv < 1L, b < 1L, ))
  exp_eq(and3s(mcw < 9L, b < 9L, ),
         band3(mcw < 9L, b < 9L, ))
  exp_eq(and3s(mcx < 0L, r < 0L, logi_s),
         band3(mcx < 0L, r < 0L, logi_s))
  exp_eq(and3s(mcy < 1L, d < 1L, logi_t),
         band3(mcy < 1L, d < 1L, logi_t))
  exp_eq(and3s(mcz < 9L, i < 9L, logi_l),
         band3(mcz < 9L, i < 9L, logi_l))
  exp_eq(and3s(mda < 0L, , ),
         band3(mda < 0L, , ))
  exp_eq(and3s(mdb < 1L, , ),
         band3(mdb < 1L, , ))
  exp_eq(and3s(mdc < 9L, , ),
         band3(mdc < 9L, , ))
  exp_eq(and3s(mdd < 0L, , !logi_u),
         band3(mdd < 0L, , !logi_u))
  exp_eq(and3s(mde < 1L, , !logi_z),
         band3(mde < 1L, , !logi_z))
  exp_eq(and3s(mdf < 9L, , !logi_l),
         band3(mdf < 9L, , !logi_l))
  exp_eq(and3s(mdg < 0L, a < 0L, ),
         band3(mdg < 0L, a < 0L, ))
  exp_eq(and3s(mdh < 1L, j < 1L, ),
         band3(mdh < 1L, j < 1L, ))
  exp_eq(and3s(mdi < 9L, y < 9L, ),
         band3(mdi < 9L, y < 9L, ))
  exp_eq(and3s(mdj < 0L, w < 0L, !logi_d),
         band3(mdj < 0L, w < 0L, !logi_d))
  exp_eq(and3s(mdk < 1L, m < 1L, !logi_s),
         band3(mdk < 1L, m < 1L, !logi_s))
  exp_eq(and3s(mdl < 9L, w < 9L, !logi_v),
         band3(mdl < 9L, w < 9L, !logi_v))
  exp_eq(and3s(mdm < 0L, , ),
         band3(mdm < 0L, , ))
  exp_eq(and3s(mdn < 1L, , ),
         band3(mdn < 1L, , ))
  exp_eq(and3s(mdo < 9L, , ),
         band3(mdo < 9L, , ))
  exp_eq(and3s(mdp < 0L, , y != 0L),
         band3(mdp < 0L, , y != 0L))
  exp_eq(and3s(mdq < 1L, , i != 1L),
         band3(mdq < 1L, , i != 1L))
  exp_eq(and3s(mdr < 9L, , x != 9L),
         band3(mdr < 9L, , x != 9L))
  exp_eq(and3s(mds < 0L, u < 0L, ),
         band3(mds < 0L, u < 0L, ))
  exp_eq(and3s(mdt < 1L, j < 1L, ),
         band3(mdt < 1L, j < 1L, ))
  exp_eq(and3s(mdu < 9L, v < 9L, ),
         band3(mdu < 9L, v < 9L, ))
  exp_eq(and3s(mdv < 0L, z < 0L, t != 0L),
         band3(mdv < 0L, z < 0L, t != 0L))
  exp_eq(and3s(mdw < 1L, g < 1L, c != 1L),
         band3(mdw < 1L, g < 1L, c != 1L))
  exp_eq(and3s(mdx < 9L, u < 9L, f != 9L),
         band3(mdx < 9L, u < 9L, f != 9L))
  exp_eq(and3s(mdy < 0L, , ),
         band3(mdy < 0L, , ))
  exp_eq(and3s(mdz < 1L, , ),
         band3(mdz < 1L, , ))
  exp_eq(and3s(mea < 9L, , ),
         band3(mea < 9L, , ))
  exp_eq(and3s(meb < 0L, , j %between% c(-1L, 1L)),
         band3(meb < 0L, , j %between% c(-1L, 1L)))
  exp_eq(and3s(mec < 1L, , o %between% c(-1L, 1L)),
         band3(mec < 1L, , o %between% c(-1L, 1L)))
  exp_eq(and3s(med < 9L, , i %between% c(-1L, 1L)),
         band3(med < 9L, , i %between% c(-1L, 1L)))
  exp_eq(and3s(mee < 0L, f < 0L, ),
         band3(mee < 0L, f < 0L, ))
  exp_eq(and3s(mef < 1L, o < 1L, ),
         band3(mef < 1L, o < 1L, ))
  exp_eq(and3s(meg < 9L, b < 9L, ),
         band3(meg < 9L, b < 9L, ))
  exp_eq(and3s(meh < 0L, q < 0L, w %between% c(-1L, 1L)),
         band3(meh < 0L, q < 0L, w %between% c(-1L, 1L)))
  exp_eq(and3s(mei < 1L, v < 1L, k %between% c(-1L, 1L)),
         band3(mei < 1L, v < 1L, k %between% c(-1L, 1L)))
  exp_eq(and3s(mej < 9L, e < 9L, h %between% c(-1L, 1L)),
         band3(mej < 9L, e < 9L, h %between% c(-1L, 1L)))
  exp_eq(and3s(mek < 0L, , ),
         band3(mek < 0L, , ))
  exp_eq(and3s(mel < 1L, , ),
         band3(mel < 1L, , ))
  exp_eq(and3s(mem < 9L, , ),
         band3(mem < 9L, , ))
  exp_eq(and3s(men < 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(men < 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(meo < 1L, , q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(meo < 1L, , q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mep < 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mep < 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(meq < 0L, f < 0L, ),
         band3(meq < 0L, f < 0L, ))
  exp_eq(and3s(mer < 1L, p < 1L, ),
         band3(mer < 1L, p < 1L, ))
  exp_eq(and3s(mes < 9L, w < 9L, ),
         band3(mes < 9L, w < 9L, ))
  exp_eq(and3s(met < 0L, n < 0L, b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(met < 0L, n < 0L, b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(meu < 1L, u < 1L, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(meu < 1L, u < 1L, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mev < 9L, q < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mev < 9L, q < 9L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mew < 0L, , ),
         band3(mew < 0L, , ))
  exp_eq(and3s(mex < 1L, , ),
         band3(mex < 1L, , ))
  exp_eq(and3s(mey < 9L, , ),
         band3(mey < 9L, , ))
  exp_eq(and3s(mez < 0L, , h %in% 1:4),
         band3(mez < 0L, , h %in% 1:4))
  exp_eq(and3s(mfa < 1L, , d %in% 1:4),
         band3(mfa < 1L, , d %in% 1:4))
  exp_eq(and3s(mfb < 9L, , c %in% 1:4),
         band3(mfb < 9L, , c %in% 1:4))
  exp_eq(and3s(mfc < 0L, e < 0L, ),
         band3(mfc < 0L, e < 0L, ))
  exp_eq(and3s(mfd < 1L, f < 1L, ),
         band3(mfd < 1L, f < 1L, ))
  exp_eq(and3s(mfe < 9L, b < 9L, ),
         band3(mfe < 9L, b < 9L, ))
  exp_eq(and3s(mff < 0L, y < 0L, r %in% 1:4),
         band3(mff < 0L, y < 0L, r %in% 1:4))
  exp_eq(and3s(mfg < 1L, b < 1L, p %in% 1:4),
         band3(mfg < 1L, b < 1L, p %in% 1:4))
  exp_eq(and3s(mfh < 9L, k < 9L, r %in% 1:4),
         band3(mfh < 9L, k < 9L, r %in% 1:4))
  exp_eq(and3s(mfi < 0L, , ),
         band3(mfi < 0L, , ))
  exp_eq(and3s(mfj < 1L, , ),
         band3(mfj < 1L, , ))
  exp_eq(and3s(mfk < 9L, , ),
         band3(mfk < 9L, , ))
  exp_eq(and3s(mfl < 0L, , b < 0L),
         band3(mfl < 0L, , b < 0L))
  exp_eq(and3s(mfm < 1L, , h < 1L),
         band3(mfm < 1L, , h < 1L))
  exp_eq(and3s(mfn < 9L, , k < 9L),
         band3(mfn < 9L, , k < 9L))
  exp_eq(and3s(mfo < 0L, f < 0L, ),
         band3(mfo < 0L, f < 0L, ))
  exp_eq(and3s(mfp < 1L, i < 1L, ),
         band3(mfp < 1L, i < 1L, ))
  exp_eq(and3s(mfq < 9L, b < 9L, ),
         band3(mfq < 9L, b < 9L, ))
  exp_eq(and3s(mfr < 0L, j < 0L, k < 0L),
         band3(mfr < 0L, j < 0L, k < 0L))
  exp_eq(and3s(mfs < 1L, m < 1L, y < 1L),
         band3(mfs < 1L, m < 1L, y < 1L))
  exp_eq(and3s(mft < 9L, x < 9L, i < 9L),
         band3(mft < 9L, x < 9L, i < 9L))
  exp_eq(and3s(mfu < 0L, , ),
         band3(mfu < 0L, , ))
  exp_eq(and3s(mfv < 1L, , ),
         band3(mfv < 1L, , ))
  exp_eq(and3s(mfw < 9L, , ),
         band3(mfw < 9L, , ))
  exp_eq(and3s(mfx < 0L, , x <= 0L),
         band3(mfx < 0L, , x <= 0L))
  exp_eq(and3s(mfy < 1L, , o <= 1L),
         band3(mfy < 1L, , o <= 1L))
  exp_eq(and3s(mfz < 9L, , w <= 9L),
         band3(mfz < 9L, , w <= 9L))
  exp_eq(and3s(mga < 0L, d < 0L, ),
         band3(mga < 0L, d < 0L, ))
  exp_eq(and3s(mgb < 1L, p < 1L, ),
         band3(mgb < 1L, p < 1L, ))
  exp_eq(and3s(mgc < 9L, w < 9L, ),
         band3(mgc < 9L, w < 9L, ))
  exp_eq(and3s(mgd < 0L, p < 0L, i <= 0L),
         band3(mgd < 0L, p < 0L, i <= 0L))
  exp_eq(and3s(mge < 1L, v < 1L, j <= 1L),
         band3(mge < 1L, v < 1L, j <= 1L))
  exp_eq(and3s(mgf < 9L, e < 9L, m <= 9L),
         band3(mgf < 9L, e < 9L, m <= 9L))
  exp_eq(and3s(mgg < 0L, , ),
         band3(mgg < 0L, , ))
  exp_eq(and3s(mgh < 1L, , ),
         band3(mgh < 1L, , ))
  exp_eq(and3s(mgi < 9L, , ),
         band3(mgi < 9L, , ))
  exp_eq(and3s(mgj < 0L, , x == 0L),
         band3(mgj < 0L, , x == 0L))
  exp_eq(and3s(mgk < 1L, , k == 1L),
         band3(mgk < 1L, , k == 1L))
  exp_eq(and3s(mgl < 9L, , f == 9L),
         band3(mgl < 9L, , f == 9L))
  exp_eq(and3s(mgm < 0L, c < 0L, ),
         band3(mgm < 0L, c < 0L, ))
  exp_eq(and3s(mgn < 1L, v < 1L, ),
         band3(mgn < 1L, v < 1L, ))
  exp_eq(and3s(mgo < 9L, c < 9L, ),
         band3(mgo < 9L, c < 9L, ))
  exp_eq(and3s(mgp < 0L, g < 0L, z == 0L),
         band3(mgp < 0L, g < 0L, z == 0L))
  exp_eq(and3s(mgq < 1L, h < 1L, g == 1L),
         band3(mgq < 1L, h < 1L, g == 1L))
  exp_eq(and3s(mgr < 9L, u < 9L, u == 9L),
         band3(mgr < 9L, u < 9L, u == 9L))
  exp_eq(and3s(mgs < 0L, , ),
         band3(mgs < 0L, , ))
  exp_eq(and3s(mgt < 1L, , ),
         band3(mgt < 1L, , ))
  exp_eq(and3s(mgu < 9L, , ),
         band3(mgu < 9L, , ))
  exp_eq(and3s(mgv < 0L, , z > 0L),
         band3(mgv < 0L, , z > 0L))
  exp_eq(and3s(mgw < 1L, , e > 1L),
         band3(mgw < 1L, , e > 1L))
  exp_eq(and3s(mgx < 9L, , a > 9L),
         band3(mgx < 9L, , a > 9L))
  exp_eq(and3s(mgy < 0L, e < 0L, ),
         band3(mgy < 0L, e < 0L, ))
  exp_eq(and3s(mgz < 1L, f < 1L, ),
         band3(mgz < 1L, f < 1L, ))
  exp_eq(and3s(mha < 9L, r < 9L, ),
         band3(mha < 9L, r < 9L, ))
  exp_eq(and3s(mhb < 0L, b < 0L, j > 0L),
         band3(mhb < 0L, b < 0L, j > 0L))
  exp_eq(and3s(mhc < 1L, h < 1L, o > 1L),
         band3(mhc < 1L, h < 1L, o > 1L))
  exp_eq(and3s(mhd < 9L, k < 9L, x > 9L),
         band3(mhd < 9L, k < 9L, x > 9L))
  exp_eq(and3s(mhe < 0L, , ),
         band3(mhe < 0L, , ))
  exp_eq(and3s(mhf < 1L, , ),
         band3(mhf < 1L, , ))
  exp_eq(and3s(mhg < 9L, , ),
         band3(mhg < 9L, , ))
  exp_eq(and3s(mhh < 0L, , s >= 0L),
         band3(mhh < 0L, , s >= 0L))
  exp_eq(and3s(mhi < 1L, , s >= 1L),
         band3(mhi < 1L, , s >= 1L))
  exp_eq(and3s(mhj < 9L, , z >= 9L),
         band3(mhj < 9L, , z >= 9L))
  exp_eq(and3s(mhk < 0L, o < 0L, ),
         band3(mhk < 0L, o < 0L, ))
  exp_eq(and3s(mhl < 1L, q < 1L, ),
         band3(mhl < 1L, q < 1L, ))
  exp_eq(and3s(mhm < 9L, h < 9L, ),
         band3(mhm < 9L, h < 9L, ))
  exp_eq(and3s(mhn < 0L, z < 0L, j >= 0L),
         band3(mhn < 0L, z < 0L, j >= 0L))
  exp_eq(and3s(mho < 1L, b < 1L, b >= 1L),
         band3(mho < 1L, b < 1L, b >= 1L))
  exp_eq(and3s(mhp < 9L, e < 9L, o >= 9L),
         band3(mhp < 9L, e < 9L, o >= 9L))
  exp_eq(and3s(mhq < 0L, , ),
         band3(mhq < 0L, , ))
  exp_eq(and3s(mhr < 1L, , ),
         band3(mhr < 1L, , ))
  exp_eq(and3s(mhs < 9L, , ),
         band3(mhs < 9L, , ))
  exp_eq(and3s(mht < 0L, , logi_i),
         band3(mht < 0L, , logi_i))
  exp_eq(and3s(mhu < 1L, , logi_r),
         band3(mhu < 1L, , logi_r))
  exp_eq(and3s(mhv < 9L, , logi_v),
         band3(mhv < 9L, , logi_v))
  exp_eq(and3s(mhw < 0L, f <= 0L, ),
         band3(mhw < 0L, f <= 0L, ))
  exp_eq(and3s(mhx < 1L, x <= 1L, ),
         band3(mhx < 1L, x <= 1L, ))
  exp_eq(and3s(mhy < 9L, t <= 9L, ),
         band3(mhy < 9L, t <= 9L, ))
  exp_eq(and3s(mhz < 0L, p <= 0L, logi_j),
         band3(mhz < 0L, p <= 0L, logi_j))
  exp_eq(and3s(mia < 1L, m <= 1L, logi_y),
         band3(mia < 1L, m <= 1L, logi_y))
  exp_eq(and3s(mib < 9L, f <= 9L, logi_q),
         band3(mib < 9L, f <= 9L, logi_q))
  exp_eq(and3s(mic < 0L, , ),
         band3(mic < 0L, , ))
  exp_eq(and3s(mid < 1L, , ),
         band3(mid < 1L, , ))
  exp_eq(and3s(mie < 9L, , ),
         band3(mie < 9L, , ))
  exp_eq(and3s(mif < 0L, , !logi_a),
         band3(mif < 0L, , !logi_a))
  exp_eq(and3s(mig < 1L, , !logi_d),
         band3(mig < 1L, , !logi_d))
  exp_eq(and3s(mih < 9L, , !logi_h),
         band3(mih < 9L, , !logi_h))
  exp_eq(and3s(mii < 0L, l <= 0L, ),
         band3(mii < 0L, l <= 0L, ))
  exp_eq(and3s(mij < 1L, y <= 1L, ),
         band3(mij < 1L, y <= 1L, ))
  exp_eq(and3s(mik < 9L, w <= 9L, ),
         band3(mik < 9L, w <= 9L, ))
  exp_eq(and3s(mil < 0L, a <= 0L, !logi_g),
         band3(mil < 0L, a <= 0L, !logi_g))
  exp_eq(and3s(mim < 1L, o <= 1L, !logi_k),
         band3(mim < 1L, o <= 1L, !logi_k))
  exp_eq(and3s(min < 9L, w <= 9L, !logi_w),
         band3(min < 9L, w <= 9L, !logi_w))
  exp_eq(and3s(mio < 0L, , ),
         band3(mio < 0L, , ))
  exp_eq(and3s(mip < 1L, , ),
         band3(mip < 1L, , ))
  exp_eq(and3s(miq < 9L, , ),
         band3(miq < 9L, , ))
  exp_eq(and3s(mir < 0L, , e != 0L),
         band3(mir < 0L, , e != 0L))
  exp_eq(and3s(mis < 1L, , v != 1L),
         band3(mis < 1L, , v != 1L))
  exp_eq(and3s(mit < 9L, , x != 9L),
         band3(mit < 9L, , x != 9L))
  exp_eq(and3s(miu < 0L, g <= 0L, ),
         band3(miu < 0L, g <= 0L, ))
  exp_eq(and3s(miv < 1L, j <= 1L, ),
         band3(miv < 1L, j <= 1L, ))
  exp_eq(and3s(miw < 9L, o <= 9L, ),
         band3(miw < 9L, o <= 9L, ))
  exp_eq(and3s(mix < 0L, s <= 0L, x != 0L),
         band3(mix < 0L, s <= 0L, x != 0L))
  exp_eq(and3s(miy < 1L, q <= 1L, l != 1L),
         band3(miy < 1L, q <= 1L, l != 1L))
  exp_eq(and3s(miz < 9L, i <= 9L, p != 9L),
         band3(miz < 9L, i <= 9L, p != 9L))
  exp_eq(and3s(mja < 0L, , ),
         band3(mja < 0L, , ))
  exp_eq(and3s(mjb < 1L, , ),
         band3(mjb < 1L, , ))
  exp_eq(and3s(mjc < 9L, , ),
         band3(mjc < 9L, , ))
  exp_eq(and3s(mjd < 0L, , k %between% c(-1L, 1L)),
         band3(mjd < 0L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(mje < 1L, , a %between% c(-1L, 1L)),
         band3(mje < 1L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(mjf < 9L, , q %between% c(-1L, 1L)),
         band3(mjf < 9L, , q %between% c(-1L, 1L)))
  exp_eq(and3s(mjg < 0L, u <= 0L, ),
         band3(mjg < 0L, u <= 0L, ))
  exp_eq(and3s(mjh < 1L, g <= 1L, ),
         band3(mjh < 1L, g <= 1L, ))
  exp_eq(and3s(mji < 9L, u <= 9L, ),
         band3(mji < 9L, u <= 9L, ))
  exp_eq(and3s(mjj < 0L, q <= 0L, f %between% c(-1L, 1L)),
         band3(mjj < 0L, q <= 0L, f %between% c(-1L, 1L)))
  exp_eq(and3s(mjk < 1L, u <= 1L, t %between% c(-1L, 1L)),
         band3(mjk < 1L, u <= 1L, t %between% c(-1L, 1L)))
  exp_eq(and3s(mjl < 9L, h <= 9L, v %between% c(-1L, 1L)),
         band3(mjl < 9L, h <= 9L, v %between% c(-1L, 1L)))
  exp_eq(and3s(mjm < 0L, , ),
         band3(mjm < 0L, , ))
  exp_eq(and3s(mjn < 1L, , ),
         band3(mjn < 1L, , ))
  exp_eq(and3s(mjo < 9L, , ),
         band3(mjo < 9L, , ))
  exp_eq(and3s(mjp < 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjp < 0L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjq < 1L, , j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjq < 1L, , j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjr < 9L, , a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjr < 9L, , a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjs < 0L, a <= 0L, ),
         band3(mjs < 0L, a <= 0L, ))
  exp_eq(and3s(mjt < 1L, w <= 1L, ),
         band3(mjt < 1L, w <= 1L, ))
  exp_eq(and3s(mju < 9L, v <= 9L, ),
         band3(mju < 9L, v <= 9L, ))
  exp_eq(and3s(mjv < 0L, y <= 0L, g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjv < 0L, y <= 0L, g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjw < 1L, o <= 1L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjw < 1L, o <= 1L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjx < 9L, r <= 9L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mjx < 9L, r <= 9L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mjy < 0L, , ),
         band3(mjy < 0L, , ))
  exp_eq(and3s(mjz < 1L, , ),
         band3(mjz < 1L, , ))
  exp_eq(and3s(mka < 9L, , ),
         band3(mka < 9L, , ))
  exp_eq(and3s(mkb < 0L, , e %in% 1:4),
         band3(mkb < 0L, , e %in% 1:4))
  exp_eq(and3s(mkc < 1L, , p %in% 1:4),
         band3(mkc < 1L, , p %in% 1:4))
  exp_eq(and3s(mkd < 9L, , v %in% 1:4),
         band3(mkd < 9L, , v %in% 1:4))
  exp_eq(and3s(mke < 0L, g <= 0L, ),
         band3(mke < 0L, g <= 0L, ))
  exp_eq(and3s(mkf < 1L, i <= 1L, ),
         band3(mkf < 1L, i <= 1L, ))
  exp_eq(and3s(mkg < 9L, g <= 9L, ),
         band3(mkg < 9L, g <= 9L, ))
  exp_eq(and3s(mkh < 0L, h <= 0L, m %in% 1:4),
         band3(mkh < 0L, h <= 0L, m %in% 1:4))
  exp_eq(and3s(mki < 1L, y <= 1L, i %in% 1:4),
         band3(mki < 1L, y <= 1L, i %in% 1:4))
  exp_eq(and3s(mkj < 9L, r <= 9L, q %in% 1:4),
         band3(mkj < 9L, r <= 9L, q %in% 1:4))
  exp_eq(and3s(mkk < 0L, , ),
         band3(mkk < 0L, , ))
  exp_eq(and3s(mkl < 1L, , ),
         band3(mkl < 1L, , ))
  exp_eq(and3s(mkm < 9L, , ),
         band3(mkm < 9L, , ))
  exp_eq(and3s(mkn < 0L, , n < 0L),
         band3(mkn < 0L, , n < 0L))
  exp_eq(and3s(mko < 1L, , r < 1L),
         band3(mko < 1L, , r < 1L))
  exp_eq(and3s(mkp < 9L, , q < 9L),
         band3(mkp < 9L, , q < 9L))
  exp_eq(and3s(mkq < 0L, q <= 0L, ),
         band3(mkq < 0L, q <= 0L, ))
  exp_eq(and3s(mkr < 1L, y <= 1L, ),
         band3(mkr < 1L, y <= 1L, ))
  exp_eq(and3s(mks < 9L, k <= 9L, ),
         band3(mks < 9L, k <= 9L, ))
  exp_eq(and3s(mkt < 0L, b <= 0L, c < 0L),
         band3(mkt < 0L, b <= 0L, c < 0L))
  exp_eq(and3s(mku < 1L, s <= 1L, t < 1L),
         band3(mku < 1L, s <= 1L, t < 1L))
  exp_eq(and3s(mkv < 9L, g <= 9L, v < 9L),
         band3(mkv < 9L, g <= 9L, v < 9L))
  exp_eq(and3s(mkw < 0L, , ),
         band3(mkw < 0L, , ))
  exp_eq(and3s(mkx < 1L, , ),
         band3(mkx < 1L, , ))
  exp_eq(and3s(mky < 9L, , ),
         band3(mky < 9L, , ))
  exp_eq(and3s(mkz < 0L, , j <= 0L),
         band3(mkz < 0L, , j <= 0L))
  exp_eq(and3s(mla < 1L, , w <= 1L),
         band3(mla < 1L, , w <= 1L))
  exp_eq(and3s(mlb < 9L, , l <= 9L),
         band3(mlb < 9L, , l <= 9L))
  exp_eq(and3s(mlc < 0L, w <= 0L, ),
         band3(mlc < 0L, w <= 0L, ))
  exp_eq(and3s(mld < 1L, j <= 1L, ),
         band3(mld < 1L, j <= 1L, ))
  exp_eq(and3s(mle < 9L, m <= 9L, ),
         band3(mle < 9L, m <= 9L, ))
  exp_eq(and3s(mlf < 0L, t <= 0L, w <= 0L),
         band3(mlf < 0L, t <= 0L, w <= 0L))
  exp_eq(and3s(mlg < 1L, l <= 1L, z <= 1L),
         band3(mlg < 1L, l <= 1L, z <= 1L))
  exp_eq(and3s(mlh < 9L, k <= 9L, x <= 9L),
         band3(mlh < 9L, k <= 9L, x <= 9L))
  exp_eq(and3s(mli < 0L, , ),
         band3(mli < 0L, , ))
  exp_eq(and3s(mlj < 1L, , ),
         band3(mlj < 1L, , ))
  exp_eq(and3s(mlk < 9L, , ),
         band3(mlk < 9L, , ))
  exp_eq(and3s(mll < 0L, , c == 0L),
         band3(mll < 0L, , c == 0L))
  exp_eq(and3s(mlm < 1L, , v == 1L),
         band3(mlm < 1L, , v == 1L))
  exp_eq(and3s(mln < 9L, , a == 9L),
         band3(mln < 9L, , a == 9L))
  exp_eq(and3s(mlo < 0L, a <= 0L, ),
         band3(mlo < 0L, a <= 0L, ))
  exp_eq(and3s(mlp < 1L, e <= 1L, ),
         band3(mlp < 1L, e <= 1L, ))
  exp_eq(and3s(mlq < 9L, b <= 9L, ),
         band3(mlq < 9L, b <= 9L, ))
  exp_eq(and3s(mlr < 0L, s <= 0L, k == 0L),
         band3(mlr < 0L, s <= 0L, k == 0L))
  exp_eq(and3s(mls < 1L, g <= 1L, s == 1L),
         band3(mls < 1L, g <= 1L, s == 1L))
  exp_eq(and3s(mlt < 9L, t <= 9L, t == 9L),
         band3(mlt < 9L, t <= 9L, t == 9L))
  exp_eq(and3s(mlu < 0L, , ),
         band3(mlu < 0L, , ))
  exp_eq(and3s(mlv < 1L, , ),
         band3(mlv < 1L, , ))
  exp_eq(and3s(mlw < 9L, , ),
         band3(mlw < 9L, , ))
  exp_eq(and3s(mlx < 0L, , n > 0L),
         band3(mlx < 0L, , n > 0L))
  exp_eq(and3s(mly < 1L, , d > 1L),
         band3(mly < 1L, , d > 1L))
  exp_eq(and3s(mlz < 9L, , u > 9L),
         band3(mlz < 9L, , u > 9L))
  exp_eq(and3s(mma < 0L, w <= 0L, ),
         band3(mma < 0L, w <= 0L, ))
  exp_eq(and3s(mmb < 1L, k <= 1L, ),
         band3(mmb < 1L, k <= 1L, ))
  exp_eq(and3s(mmc < 9L, v <= 9L, ),
         band3(mmc < 9L, v <= 9L, ))
  exp_eq(and3s(mmd < 0L, v <= 0L, f > 0L),
         band3(mmd < 0L, v <= 0L, f > 0L))
  exp_eq(and3s(mme < 1L, p <= 1L, b > 1L),
         band3(mme < 1L, p <= 1L, b > 1L))
  exp_eq(and3s(mmf < 9L, u <= 9L, h > 9L),
         band3(mmf < 9L, u <= 9L, h > 9L))
  exp_eq(and3s(mmg < 0L, , ),
         band3(mmg < 0L, , ))
  exp_eq(and3s(mmh < 1L, , ),
         band3(mmh < 1L, , ))
  exp_eq(and3s(mmi < 9L, , ),
         band3(mmi < 9L, , ))
  exp_eq(and3s(mmj < 0L, , f >= 0L),
         band3(mmj < 0L, , f >= 0L))
  exp_eq(and3s(mmk < 1L, , w >= 1L),
         band3(mmk < 1L, , w >= 1L))
  exp_eq(and3s(mml < 9L, , y >= 9L),
         band3(mml < 9L, , y >= 9L))
  exp_eq(and3s(mmm < 0L, b <= 0L, ),
         band3(mmm < 0L, b <= 0L, ))
  exp_eq(and3s(mmn < 1L, d <= 1L, ),
         band3(mmn < 1L, d <= 1L, ))
  exp_eq(and3s(mmo < 9L, u <= 9L, ),
         band3(mmo < 9L, u <= 9L, ))
  exp_eq(and3s(mmp < 0L, j <= 0L, f >= 0L),
         band3(mmp < 0L, j <= 0L, f >= 0L))
  exp_eq(and3s(mmq < 1L, p <= 1L, j >= 1L),
         band3(mmq < 1L, p <= 1L, j >= 1L))
  exp_eq(and3s(mmr < 9L, g <= 9L, t >= 9L),
         band3(mmr < 9L, g <= 9L, t >= 9L))
  exp_eq(and3s(mms < 0L, , ),
         band3(mms < 0L, , ))
  exp_eq(and3s(mmt < 1L, , ),
         band3(mmt < 1L, , ))
  exp_eq(and3s(mmu < 9L, , ),
         band3(mmu < 9L, , ))
  exp_eq(and3s(mmv < 0L, , logi_n),
         band3(mmv < 0L, , logi_n))
  exp_eq(and3s(mmw < 1L, , logi_b),
         band3(mmw < 1L, , logi_b))
  exp_eq(and3s(mmx < 9L, , logi_x),
         band3(mmx < 9L, , logi_x))
  exp_eq(and3s(mmy < 0L, q == 0L, ),
         band3(mmy < 0L, q == 0L, ))
  exp_eq(and3s(mmz < 1L, n == 1L, ),
         band3(mmz < 1L, n == 1L, ))
  exp_eq(and3s(mna < 9L, l == 9L, ),
         band3(mna < 9L, l == 9L, ))
  exp_eq(and3s(mnb < 0L, j == 0L, logi_n),
         band3(mnb < 0L, j == 0L, logi_n))
  exp_eq(and3s(mnc < 1L, q == 1L, logi_c),
         band3(mnc < 1L, q == 1L, logi_c))
  exp_eq(and3s(mnd < 9L, q == 9L, logi_d),
         band3(mnd < 9L, q == 9L, logi_d))
  exp_eq(and3s(mne < 0L, , ),
         band3(mne < 0L, , ))
  exp_eq(and3s(mnf < 1L, , ),
         band3(mnf < 1L, , ))
  exp_eq(and3s(mng < 9L, , ),
         band3(mng < 9L, , ))
  exp_eq(and3s(mnh < 0L, , !logi_u),
         band3(mnh < 0L, , !logi_u))
  exp_eq(and3s(mni < 1L, , !logi_j),
         band3(mni < 1L, , !logi_j))
  exp_eq(and3s(mnj < 9L, , !logi_t),
         band3(mnj < 9L, , !logi_t))
  exp_eq(and3s(mnk < 0L, z == 0L, ),
         band3(mnk < 0L, z == 0L, ))
  exp_eq(and3s(mnl < 1L, v == 1L, ),
         band3(mnl < 1L, v == 1L, ))
  exp_eq(and3s(mnm < 9L, x == 9L, ),
         band3(mnm < 9L, x == 9L, ))
  exp_eq(and3s(mnn < 0L, p == 0L, !logi_p),
         band3(mnn < 0L, p == 0L, !logi_p))
  exp_eq(and3s(mno < 1L, k == 1L, !logi_w),
         band3(mno < 1L, k == 1L, !logi_w))
  exp_eq(and3s(mnp < 9L, n == 9L, !logi_t),
         band3(mnp < 9L, n == 9L, !logi_t))
  exp_eq(and3s(mnq < 0L, , ),
         band3(mnq < 0L, , ))
  exp_eq(and3s(mnr < 1L, , ),
         band3(mnr < 1L, , ))
  exp_eq(and3s(mns < 9L, , ),
         band3(mns < 9L, , ))
  exp_eq(and3s(mnt < 0L, , t != 0L),
         band3(mnt < 0L, , t != 0L))
  exp_eq(and3s(mnu < 1L, , o != 1L),
         band3(mnu < 1L, , o != 1L))
  exp_eq(and3s(mnv < 9L, , r != 9L),
         band3(mnv < 9L, , r != 9L))
  exp_eq(and3s(mnw < 0L, t == 0L, ),
         band3(mnw < 0L, t == 0L, ))
  exp_eq(and3s(mnx < 1L, c == 1L, ),
         band3(mnx < 1L, c == 1L, ))
  exp_eq(and3s(mny < 9L, i == 9L, ),
         band3(mny < 9L, i == 9L, ))
  exp_eq(and3s(mnz < 0L, m == 0L, m != 0L),
         band3(mnz < 0L, m == 0L, m != 0L))
  exp_eq(and3s(moa < 1L, s == 1L, h != 1L),
         band3(moa < 1L, s == 1L, h != 1L))
  exp_eq(and3s(mob < 9L, o == 9L, r != 9L),
         band3(mob < 9L, o == 9L, r != 9L))
  exp_eq(and3s(moc < 0L, , ),
         band3(moc < 0L, , ))
  exp_eq(and3s(mod < 1L, , ),
         band3(mod < 1L, , ))
  exp_eq(and3s(moe < 9L, , ),
         band3(moe < 9L, , ))
  exp_eq(and3s(mof < 0L, , d %between% c(-1L, 1L)),
         band3(mof < 0L, , d %between% c(-1L, 1L)))
  exp_eq(and3s(mog < 1L, , y %between% c(-1L, 1L)),
         band3(mog < 1L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(moh < 9L, , e %between% c(-1L, 1L)),
         band3(moh < 9L, , e %between% c(-1L, 1L)))
  exp_eq(and3s(moi < 0L, i == 0L, ),
         band3(moi < 0L, i == 0L, ))
  exp_eq(and3s(moj < 1L, h == 1L, ),
         band3(moj < 1L, h == 1L, ))
  exp_eq(and3s(mok < 9L, q == 9L, ),
         band3(mok < 9L, q == 9L, ))
  exp_eq(and3s(mol < 0L, f == 0L, r %between% c(-1L, 1L)),
         band3(mol < 0L, f == 0L, r %between% c(-1L, 1L)))
  exp_eq(and3s(mom < 1L, l == 1L, k %between% c(-1L, 1L)),
         band3(mom < 1L, l == 1L, k %between% c(-1L, 1L)))
  exp_eq(and3s(mon < 9L, l == 9L, x %between% c(-1L, 1L)),
         band3(mon < 9L, l == 9L, x %between% c(-1L, 1L)))
  exp_eq(and3s(moo < 0L, , ),
         band3(moo < 0L, , ))
  exp_eq(and3s(mop < 1L, , ),
         band3(mop < 1L, , ))
  exp_eq(and3s(moq < 9L, , ),
         band3(moq < 9L, , ))
  exp_eq(and3s(mor < 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mor < 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mos < 1L, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mos < 1L, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mot < 9L, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mot < 9L, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mou < 0L, b == 0L, ),
         band3(mou < 0L, b == 0L, ))
  exp_eq(and3s(mov < 1L, c == 1L, ),
         band3(mov < 1L, c == 1L, ))
  exp_eq(and3s(mow < 9L, c == 9L, ),
         band3(mow < 9L, c == 9L, ))
  exp_eq(and3s(mox < 0L, u == 0L, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mox < 0L, u == 0L, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(moy < 1L, o == 1L, a %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(moy < 1L, o == 1L, a %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(moz < 9L, x == 9L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(moz < 9L, x == 9L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mpa < 0L, , ),
         band3(mpa < 0L, , ))
  exp_eq(and3s(mpb < 1L, , ),
         band3(mpb < 1L, , ))
  exp_eq(and3s(mpc < 9L, , ),
         band3(mpc < 9L, , ))
  exp_eq(and3s(mpd < 0L, , y %in% 1:4),
         band3(mpd < 0L, , y %in% 1:4))
  exp_eq(and3s(mpe < 1L, , n %in% 1:4),
         band3(mpe < 1L, , n %in% 1:4))
  exp_eq(and3s(mpf < 9L, , f %in% 1:4),
         band3(mpf < 9L, , f %in% 1:4))
  exp_eq(and3s(mpg < 0L, o == 0L, ),
         band3(mpg < 0L, o == 0L, ))
  exp_eq(and3s(mph < 1L, d == 1L, ),
         band3(mph < 1L, d == 1L, ))
  exp_eq(and3s(mpi < 9L, x == 9L, ),
         band3(mpi < 9L, x == 9L, ))
  exp_eq(and3s(mpj < 0L, h == 0L, e %in% 1:4),
         band3(mpj < 0L, h == 0L, e %in% 1:4))
  exp_eq(and3s(mpk < 1L, d == 1L, y %in% 1:4),
         band3(mpk < 1L, d == 1L, y %in% 1:4))
  exp_eq(and3s(mpl < 9L, o == 9L, z %in% 1:4),
         band3(mpl < 9L, o == 9L, z %in% 1:4))
  exp_eq(and3s(mpm < 0L, , ),
         band3(mpm < 0L, , ))
  exp_eq(and3s(mpn < 1L, , ),
         band3(mpn < 1L, , ))
  exp_eq(and3s(mpo < 9L, , ),
         band3(mpo < 9L, , ))
  exp_eq(and3s(mpp < 0L, , i < 0L),
         band3(mpp < 0L, , i < 0L))
  exp_eq(and3s(mpq < 1L, , r < 1L),
         band3(mpq < 1L, , r < 1L))
  exp_eq(and3s(mpr < 9L, , w < 9L),
         band3(mpr < 9L, , w < 9L))
  exp_eq(and3s(mps < 0L, d == 0L, ),
         band3(mps < 0L, d == 0L, ))
  exp_eq(and3s(mpt < 1L, v == 1L, ),
         band3(mpt < 1L, v == 1L, ))
  exp_eq(and3s(mpu < 9L, q == 9L, ),
         band3(mpu < 9L, q == 9L, ))
  exp_eq(and3s(mpv < 0L, y == 0L, y < 0L),
         band3(mpv < 0L, y == 0L, y < 0L))
  exp_eq(and3s(mpw < 1L, h == 1L, m < 1L),
         band3(mpw < 1L, h == 1L, m < 1L))
  exp_eq(and3s(mpx < 9L, f == 9L, g < 9L),
         band3(mpx < 9L, f == 9L, g < 9L))
  exp_eq(and3s(mpy < 0L, , ),
         band3(mpy < 0L, , ))
  exp_eq(and3s(mpz < 1L, , ),
         band3(mpz < 1L, , ))
  exp_eq(and3s(mqa < 9L, , ),
         band3(mqa < 9L, , ))
  exp_eq(and3s(mqb < 0L, , d <= 0L),
         band3(mqb < 0L, , d <= 0L))
  exp_eq(and3s(mqc < 1L, , b <= 1L),
         band3(mqc < 1L, , b <= 1L))
  exp_eq(and3s(mqd < 9L, , w <= 9L),
         band3(mqd < 9L, , w <= 9L))
  exp_eq(and3s(mqe < 0L, d == 0L, ),
         band3(mqe < 0L, d == 0L, ))
  exp_eq(and3s(mqf < 1L, x == 1L, ),
         band3(mqf < 1L, x == 1L, ))
  exp_eq(and3s(mqg < 9L, d == 9L, ),
         band3(mqg < 9L, d == 9L, ))
  exp_eq(and3s(mqh < 0L, a == 0L, j <= 0L),
         band3(mqh < 0L, a == 0L, j <= 0L))
  exp_eq(and3s(mqi < 1L, c == 1L, n <= 1L),
         band3(mqi < 1L, c == 1L, n <= 1L))
  exp_eq(and3s(mqj < 9L, u == 9L, d <= 9L),
         band3(mqj < 9L, u == 9L, d <= 9L))
  exp_eq(and3s(mqk < 0L, , ),
         band3(mqk < 0L, , ))
  exp_eq(and3s(mql < 1L, , ),
         band3(mql < 1L, , ))
  exp_eq(and3s(mqm < 9L, , ),
         band3(mqm < 9L, , ))
  exp_eq(and3s(mqn < 0L, , x == 0L),
         band3(mqn < 0L, , x == 0L))
  exp_eq(and3s(mqo < 1L, , o == 1L),
         band3(mqo < 1L, , o == 1L))
  exp_eq(and3s(mqp < 9L, , u == 9L),
         band3(mqp < 9L, , u == 9L))
  exp_eq(and3s(mqq < 0L, r == 0L, ),
         band3(mqq < 0L, r == 0L, ))
  exp_eq(and3s(mqr < 1L, r == 1L, ),
         band3(mqr < 1L, r == 1L, ))
  exp_eq(and3s(mqs < 9L, d == 9L, ),
         band3(mqs < 9L, d == 9L, ))
  exp_eq(and3s(mqt < 0L, f == 0L, s == 0L),
         band3(mqt < 0L, f == 0L, s == 0L))
  exp_eq(and3s(mqu < 1L, e == 1L, t == 1L),
         band3(mqu < 1L, e == 1L, t == 1L))
  exp_eq(and3s(mqv < 9L, r == 9L, e == 9L),
         band3(mqv < 9L, r == 9L, e == 9L))
  exp_eq(and3s(mqw < 0L, , ),
         band3(mqw < 0L, , ))
  exp_eq(and3s(mqx < 1L, , ),
         band3(mqx < 1L, , ))
  exp_eq(and3s(mqy < 9L, , ),
         band3(mqy < 9L, , ))
  exp_eq(and3s(mqz < 0L, , y > 0L),
         band3(mqz < 0L, , y > 0L))
  exp_eq(and3s(mra < 1L, , q > 1L),
         band3(mra < 1L, , q > 1L))
  exp_eq(and3s(mrb < 9L, , j > 9L),
         band3(mrb < 9L, , j > 9L))
  exp_eq(and3s(mrc < 0L, l == 0L, ),
         band3(mrc < 0L, l == 0L, ))
  exp_eq(and3s(mrd < 1L, a == 1L, ),
         band3(mrd < 1L, a == 1L, ))
  exp_eq(and3s(mre < 9L, h == 9L, ),
         band3(mre < 9L, h == 9L, ))
  exp_eq(and3s(mrf < 0L, f == 0L, y > 0L),
         band3(mrf < 0L, f == 0L, y > 0L))
  exp_eq(and3s(mrg < 1L, u == 1L, w > 1L),
         band3(mrg < 1L, u == 1L, w > 1L))
  exp_eq(and3s(mrh < 9L, j == 9L, y > 9L),
         band3(mrh < 9L, j == 9L, y > 9L))
  exp_eq(and3s(mri < 0L, , ),
         band3(mri < 0L, , ))
  exp_eq(and3s(mrj < 1L, , ),
         band3(mrj < 1L, , ))
  exp_eq(and3s(mrk < 9L, , ),
         band3(mrk < 9L, , ))
  exp_eq(and3s(mrl < 0L, , i >= 0L),
         band3(mrl < 0L, , i >= 0L))
  exp_eq(and3s(mrm < 1L, , l >= 1L),
         band3(mrm < 1L, , l >= 1L))
  exp_eq(and3s(mrn < 9L, , y >= 9L),
         band3(mrn < 9L, , y >= 9L))
  exp_eq(and3s(mro < 0L, q == 0L, ),
         band3(mro < 0L, q == 0L, ))
  exp_eq(and3s(mrp < 1L, h == 1L, ),
         band3(mrp < 1L, h == 1L, ))
  exp_eq(and3s(mrq < 9L, l == 9L, ),
         band3(mrq < 9L, l == 9L, ))
  exp_eq(and3s(mrr < 0L, z == 0L, u >= 0L),
         band3(mrr < 0L, z == 0L, u >= 0L))
  exp_eq(and3s(mrs < 1L, m == 1L, p >= 1L),
         band3(mrs < 1L, m == 1L, p >= 1L))
  exp_eq(and3s(mrt < 9L, r == 9L, p >= 9L),
         band3(mrt < 9L, r == 9L, p >= 9L))
  exp_eq(and3s(mru < 0L, , ),
         band3(mru < 0L, , ))
  exp_eq(and3s(mrv < 1L, , ),
         band3(mrv < 1L, , ))
  exp_eq(and3s(mrw < 9L, , ),
         band3(mrw < 9L, , ))
  exp_eq(and3s(mrx < 0L, , logi_v),
         band3(mrx < 0L, , logi_v))
  exp_eq(and3s(mry < 1L, , logi_x),
         band3(mry < 1L, , logi_x))
  exp_eq(and3s(mrz < 9L, , logi_w),
         band3(mrz < 9L, , logi_w))
  exp_eq(and3s(msa < 0L, s > 0L, ),
         band3(msa < 0L, s > 0L, ))
  exp_eq(and3s(msb < 1L, j > 1L, ),
         band3(msb < 1L, j > 1L, ))
  exp_eq(and3s(msc < 9L, c > 9L, ),
         band3(msc < 9L, c > 9L, ))
  exp_eq(and3s(msd < 0L, z > 0L, logi_w),
         band3(msd < 0L, z > 0L, logi_w))
  exp_eq(and3s(mse < 1L, k > 1L, logi_r),
         band3(mse < 1L, k > 1L, logi_r))
  exp_eq(and3s(msf < 9L, i > 9L, logi_d),
         band3(msf < 9L, i > 9L, logi_d))
  exp_eq(and3s(msg < 0L, , ),
         band3(msg < 0L, , ))
  exp_eq(and3s(msh < 1L, , ),
         band3(msh < 1L, , ))
  exp_eq(and3s(msi < 9L, , ),
         band3(msi < 9L, , ))
  exp_eq(and3s(msj < 0L, , !logi_k),
         band3(msj < 0L, , !logi_k))
  exp_eq(and3s(msk < 1L, , !logi_v),
         band3(msk < 1L, , !logi_v))
  exp_eq(and3s(msl < 9L, , !logi_y),
         band3(msl < 9L, , !logi_y))
  exp_eq(and3s(msm < 0L, k > 0L, ),
         band3(msm < 0L, k > 0L, ))
  exp_eq(and3s(msn < 1L, h > 1L, ),
         band3(msn < 1L, h > 1L, ))
  exp_eq(and3s(mso < 9L, o > 9L, ),
         band3(mso < 9L, o > 9L, ))
  exp_eq(and3s(msp < 0L, l > 0L, !logi_e),
         band3(msp < 0L, l > 0L, !logi_e))
  exp_eq(and3s(msq < 1L, a > 1L, !logi_n),
         band3(msq < 1L, a > 1L, !logi_n))
  exp_eq(and3s(msr < 9L, p > 9L, !logi_t),
         band3(msr < 9L, p > 9L, !logi_t))
  exp_eq(and3s(mss < 0L, , ),
         band3(mss < 0L, , ))
  exp_eq(and3s(mst < 1L, , ),
         band3(mst < 1L, , ))
  exp_eq(and3s(msu < 9L, , ),
         band3(msu < 9L, , ))
  exp_eq(and3s(msv < 0L, , t != 0L),
         band3(msv < 0L, , t != 0L))
  exp_eq(and3s(msw < 1L, , c != 1L),
         band3(msw < 1L, , c != 1L))
  exp_eq(and3s(msx < 9L, , q != 9L),
         band3(msx < 9L, , q != 9L))
  exp_eq(and3s(msy < 0L, a > 0L, ),
         band3(msy < 0L, a > 0L, ))
  exp_eq(and3s(msz < 1L, p > 1L, ),
         band3(msz < 1L, p > 1L, ))
  exp_eq(and3s(mta < 9L, h > 9L, ),
         band3(mta < 9L, h > 9L, ))
  exp_eq(and3s(mtb < 0L, y > 0L, h != 0L),
         band3(mtb < 0L, y > 0L, h != 0L))
  exp_eq(and3s(mtc < 1L, c > 1L, s != 1L),
         band3(mtc < 1L, c > 1L, s != 1L))
  exp_eq(and3s(mtd < 9L, c > 9L, n != 9L),
         band3(mtd < 9L, c > 9L, n != 9L))
  exp_eq(and3s(mte < 0L, , ),
         band3(mte < 0L, , ))
  exp_eq(and3s(mtf < 1L, , ),
         band3(mtf < 1L, , ))
  exp_eq(and3s(mtg < 9L, , ),
         band3(mtg < 9L, , ))
  exp_eq(and3s(mth < 0L, , s %between% c(-1L, 1L)),
         band3(mth < 0L, , s %between% c(-1L, 1L)))
  exp_eq(and3s(mti < 1L, , p %between% c(-1L, 1L)),
         band3(mti < 1L, , p %between% c(-1L, 1L)))
  exp_eq(and3s(mtj < 9L, , y %between% c(-1L, 1L)),
         band3(mtj < 9L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(mtk < 0L, m > 0L, ),
         band3(mtk < 0L, m > 0L, ))
  exp_eq(and3s(mtl < 1L, z > 1L, ),
         band3(mtl < 1L, z > 1L, ))
  exp_eq(and3s(mtm < 9L, g > 9L, ),
         band3(mtm < 9L, g > 9L, ))
  exp_eq(and3s(mtn < 0L, l > 0L, b %between% c(-1L, 1L)),
         band3(mtn < 0L, l > 0L, b %between% c(-1L, 1L)))
  exp_eq(and3s(mto < 1L, y > 1L, i %between% c(-1L, 1L)),
         band3(mto < 1L, y > 1L, i %between% c(-1L, 1L)))
  exp_eq(and3s(mtp < 9L, v > 9L, l %between% c(-1L, 1L)),
         band3(mtp < 9L, v > 9L, l %between% c(-1L, 1L)))
  exp_eq(and3s(mtq < 0L, , ),
         band3(mtq < 0L, , ))
  exp_eq(and3s(mtr < 1L, , ),
         band3(mtr < 1L, , ))
  exp_eq(and3s(mts < 9L, , ),
         band3(mts < 9L, , ))
  exp_eq(and3s(mtt < 0L, , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mtt < 0L, , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mtu < 1L, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mtu < 1L, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mtv < 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mtv < 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mtw < 0L, f > 0L, ),
         band3(mtw < 0L, f > 0L, ))
  exp_eq(and3s(mtx < 1L, v > 1L, ),
         band3(mtx < 1L, v > 1L, ))
  exp_eq(and3s(mty < 9L, v > 9L, ),
         band3(mty < 9L, v > 9L, ))
  exp_eq(and3s(mtz < 0L, o > 0L, n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mtz < 0L, o > 0L, n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mua < 1L, s > 1L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mua < 1L, s > 1L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(mub < 9L, m > 9L, o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(mub < 9L, m > 9L, o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(muc < 0L, , ),
         band3(muc < 0L, , ))
  exp_eq(and3s(mud < 1L, , ),
         band3(mud < 1L, , ))
  exp_eq(and3s(mue < 9L, , ),
         band3(mue < 9L, , ))
  exp_eq(and3s(muf < 0L, , a %in% 1:4),
         band3(muf < 0L, , a %in% 1:4))
  exp_eq(and3s(mug < 1L, , o %in% 1:4),
         band3(mug < 1L, , o %in% 1:4))
  exp_eq(and3s(muh < 9L, , g %in% 1:4),
         band3(muh < 9L, , g %in% 1:4))
  exp_eq(and3s(mui < 0L, e > 0L, ),
         band3(mui < 0L, e > 0L, ))
  exp_eq(and3s(muj < 1L, d > 1L, ),
         band3(muj < 1L, d > 1L, ))
  exp_eq(and3s(muk < 9L, h > 9L, ),
         band3(muk < 9L, h > 9L, ))
  exp_eq(and3s(mul < 0L, t > 0L, i %in% 1:4),
         band3(mul < 0L, t > 0L, i %in% 1:4))
  exp_eq(and3s(mum < 1L, h > 1L, a %in% 1:4),
         band3(mum < 1L, h > 1L, a %in% 1:4))
  exp_eq(and3s(mun < 9L, v > 9L, k %in% 1:4),
         band3(mun < 9L, v > 9L, k %in% 1:4))
  exp_eq(and3s(muo < 0L, , ),
         band3(muo < 0L, , ))
  exp_eq(and3s(mup < 1L, , ),
         band3(mup < 1L, , ))
  exp_eq(and3s(muq < 9L, , ),
         band3(muq < 9L, , ))
  exp_eq(and3s(mur < 0L, , y < 0L),
         band3(mur < 0L, , y < 0L))
  exp_eq(and3s(mus < 1L, , k < 1L),
         band3(mus < 1L, , k < 1L))
  exp_eq(and3s(mut < 9L, , h < 9L),
         band3(mut < 9L, , h < 9L))
  exp_eq(and3s(muu < 0L, z > 0L, ),
         band3(muu < 0L, z > 0L, ))
  exp_eq(and3s(muv < 1L, x > 1L, ),
         band3(muv < 1L, x > 1L, ))
  exp_eq(and3s(muw < 9L, c > 9L, ),
         band3(muw < 9L, c > 9L, ))
  exp_eq(and3s(mux < 0L, d > 0L, e < 0L),
         band3(mux < 0L, d > 0L, e < 0L))
  exp_eq(and3s(muy < 1L, g > 1L, v < 1L),
         band3(muy < 1L, g > 1L, v < 1L))
  exp_eq(and3s(muz < 9L, w > 9L, q < 9L),
         band3(muz < 9L, w > 9L, q < 9L))
  exp_eq(and3s(mva < 0L, , ),
         band3(mva < 0L, , ))
  exp_eq(and3s(mvb < 1L, , ),
         band3(mvb < 1L, , ))
  exp_eq(and3s(mvc < 9L, , ),
         band3(mvc < 9L, , ))
  exp_eq(and3s(mvd < 0L, , m <= 0L),
         band3(mvd < 0L, , m <= 0L))
  exp_eq(and3s(mve < 1L, , n <= 1L),
         band3(mve < 1L, , n <= 1L))
  exp_eq(and3s(mvf < 9L, , t <= 9L),
         band3(mvf < 9L, , t <= 9L))
  exp_eq(and3s(mvg < 0L, t > 0L, ),
         band3(mvg < 0L, t > 0L, ))
  exp_eq(and3s(mvh < 1L, b > 1L, ),
         band3(mvh < 1L, b > 1L, ))
  exp_eq(and3s(mvi < 9L, t > 9L, ),
         band3(mvi < 9L, t > 9L, ))
  exp_eq(and3s(mvj < 0L, t > 0L, e <= 0L),
         band3(mvj < 0L, t > 0L, e <= 0L))
  exp_eq(and3s(mvk < 1L, s > 1L, d <= 1L),
         band3(mvk < 1L, s > 1L, d <= 1L))
  exp_eq(and3s(mvl < 9L, c > 9L, b <= 9L),
         band3(mvl < 9L, c > 9L, b <= 9L))
  exp_eq(and3s(mvm < 0L, , ),
         band3(mvm < 0L, , ))
  exp_eq(and3s(mvn < 1L, , ),
         band3(mvn < 1L, , ))
  exp_eq(and3s(mvo < 9L, , ),
         band3(mvo < 9L, , ))
  exp_eq(and3s(mvp < 0L, , s == 0L),
         band3(mvp < 0L, , s == 0L))
  exp_eq(and3s(mvq < 1L, , o == 1L),
         band3(mvq < 1L, , o == 1L))
  exp_eq(and3s(mvr < 9L, , m == 9L),
         band3(mvr < 9L, , m == 9L))
  exp_eq(and3s(mvs < 0L, t > 0L, ),
         band3(mvs < 0L, t > 0L, ))
  exp_eq(and3s(mvt < 1L, a > 1L, ),
         band3(mvt < 1L, a > 1L, ))
  exp_eq(and3s(mvu < 9L, j > 9L, ),
         band3(mvu < 9L, j > 9L, ))
  exp_eq(and3s(mvv < 0L, p > 0L, y == 0L),
         band3(mvv < 0L, p > 0L, y == 0L))
  exp_eq(and3s(mvw < 1L, b > 1L, f == 1L),
         band3(mvw < 1L, b > 1L, f == 1L))
  exp_eq(and3s(mvx < 9L, k > 9L, r == 9L),
         band3(mvx < 9L, k > 9L, r == 9L))
  exp_eq(and3s(mvy < 0L, , ),
         band3(mvy < 0L, , ))
  exp_eq(and3s(mvz < 1L, , ),
         band3(mvz < 1L, , ))
  exp_eq(and3s(mwa < 9L, , ),
         band3(mwa < 9L, , ))
  exp_eq(and3s(mwb < 0L, , k > 0L),
         band3(mwb < 0L, , k > 0L))
  exp_eq(and3s(mwc < 1L, , v > 1L),
         band3(mwc < 1L, , v > 1L))
  exp_eq(and3s(mwd < 9L, , v > 9L),
         band3(mwd < 9L, , v > 9L))
  exp_eq(and3s(mwe < 0L, r > 0L, ),
         band3(mwe < 0L, r > 0L, ))
  exp_eq(and3s(mwf < 1L, n > 1L, ),
         band3(mwf < 1L, n > 1L, ))
  exp_eq(and3s(mwg < 9L, l > 9L, ),
         band3(mwg < 9L, l > 9L, ))
  exp_eq(and3s(mwh < 0L, f > 0L, k > 0L),
         band3(mwh < 0L, f > 0L, k > 0L))
  exp_eq(and3s(mwi < 1L, w > 1L, g > 1L),
         band3(mwi < 1L, w > 1L, g > 1L))
  exp_eq(and3s(mwj < 9L, j > 9L, r > 9L),
         band3(mwj < 9L, j > 9L, r > 9L))
  exp_eq(and3s(mwk < 0L, , ),
         band3(mwk < 0L, , ))
  exp_eq(and3s(mwl < 1L, , ),
         band3(mwl < 1L, , ))
  exp_eq(and3s(mwm < 9L, , ),
         band3(mwm < 9L, , ))
  exp_eq(and3s(mwn < 0L, , p >= 0L),
         band3(mwn < 0L, , p >= 0L))
  exp_eq(and3s(mwo < 1L, , z >= 1L),
         band3(mwo < 1L, , z >= 1L))
  exp_eq(and3s(mwp < 9L, , u >= 9L),
         band3(mwp < 9L, , u >= 9L))
  exp_eq(and3s(mwq < 0L, u > 0L, ),
         band3(mwq < 0L, u > 0L, ))
  exp_eq(and3s(mwr < 1L, u > 1L, ),
         band3(mwr < 1L, u > 1L, ))
  exp_eq(and3s(mws < 9L, e > 9L, ),
         band3(mws < 9L, e > 9L, ))
  exp_eq(and3s(mwt < 0L, b > 0L, e >= 0L),
         band3(mwt < 0L, b > 0L, e >= 0L))
  exp_eq(and3s(mwu < 1L, x > 1L, s >= 1L),
         band3(mwu < 1L, x > 1L, s >= 1L))
  exp_eq(and3s(mwv < 9L, h > 9L, r >= 9L),
         band3(mwv < 9L, h > 9L, r >= 9L))
  exp_eq(and3s(mww < 0L, , ),
         band3(mww < 0L, , ))
  exp_eq(and3s(mwx < 1L, , ),
         band3(mwx < 1L, , ))
  exp_eq(and3s(mwy < 9L, , ),
         band3(mwy < 9L, , ))
  exp_eq(and3s(mwz < 0L, , logi_m),
         band3(mwz < 0L, , logi_m))
  exp_eq(and3s(mxa < 1L, , logi_r),
         band3(mxa < 1L, , logi_r))
  exp_eq(and3s(mxb < 9L, , logi_k),
         band3(mxb < 9L, , logi_k))
  exp_eq(and3s(mxc < 0L, b >= 0L, ),
         band3(mxc < 0L, b >= 0L, ))
  exp_eq(and3s(mxd < 1L, s >= 1L, ),
         band3(mxd < 1L, s >= 1L, ))
  exp_eq(and3s(mxe < 9L, s >= 9L, ),
         band3(mxe < 9L, s >= 9L, ))
  exp_eq(and3s(mxf < 0L, l >= 0L, logi_k),
         band3(mxf < 0L, l >= 0L, logi_k))
  exp_eq(and3s(mxg < 1L, d >= 1L, logi_c),
         band3(mxg < 1L, d >= 1L, logi_c))
  exp_eq(and3s(mxh < 9L, c >= 9L, logi_v),
         band3(mxh < 9L, c >= 9L, logi_v))
  exp_eq(and3s(mxi < 0L, , ),
         band3(mxi < 0L, , ))
  exp_eq(and3s(mxj < 1L, , ),
         band3(mxj < 1L, , ))
  exp_eq(and3s(mxk < 9L, , ),
         band3(mxk < 9L, , ))
  exp_eq(and3s(mxl < 0L, , !logi_v),
         band3(mxl < 0L, , !logi_v))
  exp_eq(and3s(mxm < 1L, , !logi_g),
         band3(mxm < 1L, , !logi_g))
  exp_eq(and3s(mxn < 9L, , !logi_u),
         band3(mxn < 9L, , !logi_u))
  exp_eq(and3s(mxo < 0L, l >= 0L, ),
         band3(mxo < 0L, l >= 0L, ))
  exp_eq(and3s(mxp < 1L, l >= 1L, ),
         band3(mxp < 1L, l >= 1L, ))
  exp_eq(and3s(mxq < 9L, v >= 9L, ),
         band3(mxq < 9L, v >= 9L, ))
  exp_eq(and3s(mxr < 0L, r >= 0L, !logi_m),
         band3(mxr < 0L, r >= 0L, !logi_m))
  exp_eq(and3s(mxs < 1L, z >= 1L, !logi_n),
         band3(mxs < 1L, z >= 1L, !logi_n))
  exp_eq(and3s(mxt < 9L, p >= 9L, !logi_a),
         band3(mxt < 9L, p >= 9L, !logi_a))
  exp_eq(and3s(mxu < 0L, , ),
         band3(mxu < 0L, , ))
  exp_eq(and3s(mxv < 1L, , ),
         band3(mxv < 1L, , ))
  exp_eq(and3s(mxw < 9L, , ),
         band3(mxw < 9L, , ))
  exp_eq(and3s(mxx < 0L, , r != 0L),
         band3(mxx < 0L, , r != 0L))
  exp_eq(and3s(mxy < 1L, , i != 1L),
         band3(mxy < 1L, , i != 1L))
  exp_eq(and3s(mxz < 9L, , r != 9L),
         band3(mxz < 9L, , r != 9L))
  exp_eq(and3s(mya < 0L, q >= 0L, ),
         band3(mya < 0L, q >= 0L, ))
  exp_eq(and3s(myb < 1L, x >= 1L, ),
         band3(myb < 1L, x >= 1L, ))
  exp_eq(and3s(myc < 9L, p >= 9L, ),
         band3(myc < 9L, p >= 9L, ))
  exp_eq(and3s(myd < 0L, p >= 0L, l != 0L),
         band3(myd < 0L, p >= 0L, l != 0L))
  exp_eq(and3s(mye < 1L, j >= 1L, c != 1L),
         band3(mye < 1L, j >= 1L, c != 1L))
  exp_eq(and3s(myf < 9L, f >= 9L, h != 9L),
         band3(myf < 9L, f >= 9L, h != 9L))
  exp_eq(and3s(myg < 0L, , ),
         band3(myg < 0L, , ))
  exp_eq(and3s(myh < 1L, , ),
         band3(myh < 1L, , ))
  exp_eq(and3s(myi < 9L, , ),
         band3(myi < 9L, , ))
  exp_eq(and3s(myj < 0L, , a %between% c(-1L, 1L)),
         band3(myj < 0L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(myk < 1L, , y %between% c(-1L, 1L)),
         band3(myk < 1L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(myl < 9L, , r %between% c(-1L, 1L)),
         band3(myl < 9L, , r %between% c(-1L, 1L)))
  exp_eq(and3s(mym < 0L, f >= 0L, ),
         band3(mym < 0L, f >= 0L, ))
  exp_eq(and3s(myn < 1L, y >= 1L, ),
         band3(myn < 1L, y >= 1L, ))
  exp_eq(and3s(myo < 9L, i >= 9L, ),
         band3(myo < 9L, i >= 9L, ))
  exp_eq(and3s(myp < 0L, x >= 0L, m %between% c(-1L, 1L)),
         band3(myp < 0L, x >= 0L, m %between% c(-1L, 1L)))
  exp_eq(and3s(myq < 1L, h >= 1L, g %between% c(-1L, 1L)),
         band3(myq < 1L, h >= 1L, g %between% c(-1L, 1L)))
  exp_eq(and3s(myr < 9L, c >= 9L, q %between% c(-1L, 1L)),
         band3(myr < 9L, c >= 9L, q %between% c(-1L, 1L)))
  exp_eq(and3s(mys < 0L, , ),
         band3(mys < 0L, , ))
  exp_eq(and3s(myt < 1L, , ),
         band3(myt < 1L, , ))
  exp_eq(and3s(myu < 9L, , ),
         band3(myu < 9L, , ))
  exp_eq(and3s(myv < 0L, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(myv < 0L, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(myw < 1L, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(myw < 1L, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(myx < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(myx < 9L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(myy < 0L, j >= 0L, ),
         band3(myy < 0L, j >= 0L, ))
  exp_eq(and3s(myz < 1L, i >= 1L, ),
         band3(myz < 1L, i >= 1L, ))
  exp_eq(and3s(na < 9L, u >= 9L, ),
         band3(na < 9L, u >= 9L, ))
  exp_eq(and3s(nb < 0L, g >= 0L, d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nb < 0L, g >= 0L, d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nc < 1L, c >= 1L, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nc < 1L, c >= 1L, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nd < 9L, l >= 9L, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nd < 9L, l >= 9L, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ne < 0L, , ),
         band3(ne < 0L, , ))
  exp_eq(and3s(nf < 1L, , ),
         band3(nf < 1L, , ))
  exp_eq(and3s(ng < 9L, , ),
         band3(ng < 9L, , ))
  exp_eq(and3s(nh < 0L, , q %in% 1:4),
         band3(nh < 0L, , q %in% 1:4))
  exp_eq(and3s(ni < 1L, , g %in% 1:4),
         band3(ni < 1L, , g %in% 1:4))
  exp_eq(and3s(nj < 9L, , l %in% 1:4),
         band3(nj < 9L, , l %in% 1:4))
  exp_eq(and3s(nk < 0L, g >= 0L, ),
         band3(nk < 0L, g >= 0L, ))
  exp_eq(and3s(nl < 1L, u >= 1L, ),
         band3(nl < 1L, u >= 1L, ))
  exp_eq(and3s(nm < 9L, z >= 9L, ),
         band3(nm < 9L, z >= 9L, ))
  exp_eq(and3s(nn < 0L, z >= 0L, g %in% 1:4),
         band3(nn < 0L, z >= 0L, g %in% 1:4))
  exp_eq(and3s(no < 1L, y >= 1L, x %in% 1:4),
         band3(no < 1L, y >= 1L, x %in% 1:4))
  exp_eq(and3s(np < 9L, l >= 9L, a %in% 1:4),
         band3(np < 9L, l >= 9L, a %in% 1:4))
  exp_eq(and3s(nq < 0L, , ),
         band3(nq < 0L, , ))
  exp_eq(and3s(nr < 1L, , ),
         band3(nr < 1L, , ))
  exp_eq(and3s(ns < 9L, , ),
         band3(ns < 9L, , ))
  exp_eq(and3s(nt < 0L, , r < 0L),
         band3(nt < 0L, , r < 0L))
  exp_eq(and3s(nu < 1L, , g < 1L),
         band3(nu < 1L, , g < 1L))
  exp_eq(and3s(nv < 9L, , d < 9L),
         band3(nv < 9L, , d < 9L))
  exp_eq(and3s(nw < 0L, c >= 0L, ),
         band3(nw < 0L, c >= 0L, ))
  exp_eq(and3s(nx < 1L, f >= 1L, ),
         band3(nx < 1L, f >= 1L, ))
  exp_eq(and3s(ny < 9L, c >= 9L, ),
         band3(ny < 9L, c >= 9L, ))
  exp_eq(and3s(nz < 0L, g >= 0L, e < 0L),
         band3(nz < 0L, g >= 0L, e < 0L))
  exp_eq(and3s(naa < 1L, m >= 1L, t < 1L),
         band3(naa < 1L, m >= 1L, t < 1L))
  exp_eq(and3s(nab < 9L, d >= 9L, l < 9L),
         band3(nab < 9L, d >= 9L, l < 9L))
  exp_eq(and3s(nac < 0L, , ),
         band3(nac < 0L, , ))
  exp_eq(and3s(nad < 1L, , ),
         band3(nad < 1L, , ))
  exp_eq(and3s(nae < 9L, , ),
         band3(nae < 9L, , ))
  exp_eq(and3s(naf < 0L, , c <= 0L),
         band3(naf < 0L, , c <= 0L))
  exp_eq(and3s(nag < 1L, , x <= 1L),
         band3(nag < 1L, , x <= 1L))
  exp_eq(and3s(nah < 9L, , h <= 9L),
         band3(nah < 9L, , h <= 9L))
  exp_eq(and3s(nai < 0L, z >= 0L, ),
         band3(nai < 0L, z >= 0L, ))
  exp_eq(and3s(naj < 1L, c >= 1L, ),
         band3(naj < 1L, c >= 1L, ))
  exp_eq(and3s(nak < 9L, m >= 9L, ),
         band3(nak < 9L, m >= 9L, ))
  exp_eq(and3s(nal < 0L, a >= 0L, k <= 0L),
         band3(nal < 0L, a >= 0L, k <= 0L))
  exp_eq(and3s(nam < 1L, m >= 1L, b <= 1L),
         band3(nam < 1L, m >= 1L, b <= 1L))
  exp_eq(and3s(nan < 9L, u >= 9L, m <= 9L),
         band3(nan < 9L, u >= 9L, m <= 9L))
  exp_eq(and3s(nao < 0L, , ),
         band3(nao < 0L, , ))
  exp_eq(and3s(nap < 1L, , ),
         band3(nap < 1L, , ))
  exp_eq(and3s(naq < 9L, , ),
         band3(naq < 9L, , ))
  exp_eq(and3s(nar < 0L, , g == 0L),
         band3(nar < 0L, , g == 0L))
  exp_eq(and3s(nas < 1L, , n == 1L),
         band3(nas < 1L, , n == 1L))
  exp_eq(and3s(nat < 9L, , c == 9L),
         band3(nat < 9L, , c == 9L))
  exp_eq(and3s(nau < 0L, x >= 0L, ),
         band3(nau < 0L, x >= 0L, ))
  exp_eq(and3s(nav < 1L, r >= 1L, ),
         band3(nav < 1L, r >= 1L, ))
  exp_eq(and3s(naw < 9L, f >= 9L, ),
         band3(naw < 9L, f >= 9L, ))
  exp_eq(and3s(nax < 0L, j >= 0L, f == 0L),
         band3(nax < 0L, j >= 0L, f == 0L))
  exp_eq(and3s(nay < 1L, z >= 1L, v == 1L),
         band3(nay < 1L, z >= 1L, v == 1L))
  exp_eq(and3s(naz < 9L, v >= 9L, y == 9L),
         band3(naz < 9L, v >= 9L, y == 9L))
  exp_eq(and3s(nba < 0L, , ),
         band3(nba < 0L, , ))
  exp_eq(and3s(nbb < 1L, , ),
         band3(nbb < 1L, , ))
  exp_eq(and3s(nbc < 9L, , ),
         band3(nbc < 9L, , ))
  exp_eq(and3s(nbd < 0L, , i > 0L),
         band3(nbd < 0L, , i > 0L))
  exp_eq(and3s(nbe < 1L, , q > 1L),
         band3(nbe < 1L, , q > 1L))
  exp_eq(and3s(nbf < 9L, , j > 9L),
         band3(nbf < 9L, , j > 9L))
  exp_eq(and3s(nbg < 0L, g >= 0L, ),
         band3(nbg < 0L, g >= 0L, ))
  exp_eq(and3s(nbh < 1L, o >= 1L, ),
         band3(nbh < 1L, o >= 1L, ))
  exp_eq(and3s(nbi < 9L, t >= 9L, ),
         band3(nbi < 9L, t >= 9L, ))
  exp_eq(and3s(nbj < 0L, j >= 0L, a > 0L),
         band3(nbj < 0L, j >= 0L, a > 0L))
  exp_eq(and3s(nbk < 1L, y >= 1L, o > 1L),
         band3(nbk < 1L, y >= 1L, o > 1L))
  exp_eq(and3s(nbl < 9L, f >= 9L, w > 9L),
         band3(nbl < 9L, f >= 9L, w > 9L))
  exp_eq(and3s(nbm < 0L, , ),
         band3(nbm < 0L, , ))
  exp_eq(and3s(nbn < 1L, , ),
         band3(nbn < 1L, , ))
  exp_eq(and3s(nbo < 9L, , ),
         band3(nbo < 9L, , ))
  exp_eq(and3s(nbp < 0L, , u >= 0L),
         band3(nbp < 0L, , u >= 0L))
  exp_eq(and3s(nbq < 1L, , k >= 1L),
         band3(nbq < 1L, , k >= 1L))
  exp_eq(and3s(nbr < 9L, , y >= 9L),
         band3(nbr < 9L, , y >= 9L))
  exp_eq(and3s(nbs < 0L, u >= 0L, ),
         band3(nbs < 0L, u >= 0L, ))
  exp_eq(and3s(nbt < 1L, y >= 1L, ),
         band3(nbt < 1L, y >= 1L, ))
  exp_eq(and3s(nbu < 9L, l >= 9L, ),
         band3(nbu < 9L, l >= 9L, ))
  exp_eq(and3s(nbv < 0L, g >= 0L, k >= 0L),
         band3(nbv < 0L, g >= 0L, k >= 0L))
  exp_eq(and3s(nbw < 1L, r >= 1L, k >= 1L),
         band3(nbw < 1L, r >= 1L, k >= 1L))
  exp_eq(and3s(nbx < 9L, c >= 9L, y >= 9L),
         band3(nbx < 9L, c >= 9L, y >= 9L))
  exp_eq(and3s(nby <= 0L, , ),
         band3(nby <= 0L, , ))
  exp_eq(and3s(nbz <= 1L, , ),
         band3(nbz <= 1L, , ))
  exp_eq(and3s(nca <= 9L, , ),
         band3(nca <= 9L, , ))
  exp_eq(and3s(ncb <= 0L, , logi_e),
         band3(ncb <= 0L, , logi_e))
  exp_eq(and3s(ncc <= 1L, , logi_r),
         band3(ncc <= 1L, , logi_r))
  exp_eq(and3s(ncd <= 9L, , logi_e),
         band3(ncd <= 9L, , logi_e))
  exp_eq(and3s(nce <= 0L, logi_i, ),
         band3(nce <= 0L, logi_i, ))
  exp_eq(and3s(ncf <= 1L, logi_u, ),
         band3(ncf <= 1L, logi_u, ))
  exp_eq(and3s(ncg <= 9L, logi_p, ),
         band3(ncg <= 9L, logi_p, ))
  exp_eq(and3s(nch <= 0L, logi_x, logi_c),
         band3(nch <= 0L, logi_x, logi_c))
  exp_eq(and3s(nci <= 1L, logi_r, logi_w),
         band3(nci <= 1L, logi_r, logi_w))
  exp_eq(and3s(ncj <= 9L, logi_n, logi_z),
         band3(ncj <= 9L, logi_n, logi_z))
  exp_eq(and3s(nck <= 0L, , ),
         band3(nck <= 0L, , ))
  exp_eq(and3s(ncl <= 1L, , ),
         band3(ncl <= 1L, , ))
  exp_eq(and3s(ncm <= 9L, , ),
         band3(ncm <= 9L, , ))
  exp_eq(and3s(ncn <= 0L, , !logi_e),
         band3(ncn <= 0L, , !logi_e))
  exp_eq(and3s(nco <= 1L, , !logi_u),
         band3(nco <= 1L, , !logi_u))
  exp_eq(and3s(ncp <= 9L, , !logi_q),
         band3(ncp <= 9L, , !logi_q))
  exp_eq(and3s(ncq <= 0L, logi_w, ),
         band3(ncq <= 0L, logi_w, ))
  exp_eq(and3s(ncr <= 1L, logi_d, ),
         band3(ncr <= 1L, logi_d, ))
  exp_eq(and3s(ncs <= 9L, logi_v, ),
         band3(ncs <= 9L, logi_v, ))
  exp_eq(and3s(nct <= 0L, logi_k, !logi_j),
         band3(nct <= 0L, logi_k, !logi_j))
  exp_eq(and3s(ncu <= 1L, logi_j, !logi_k),
         band3(ncu <= 1L, logi_j, !logi_k))
  exp_eq(and3s(ncv <= 9L, logi_z, !logi_q),
         band3(ncv <= 9L, logi_z, !logi_q))
  exp_eq(and3s(ncw <= 0L, , ),
         band3(ncw <= 0L, , ))
  exp_eq(and3s(ncx <= 1L, , ),
         band3(ncx <= 1L, , ))
  exp_eq(and3s(ncy <= 9L, , ),
         band3(ncy <= 9L, , ))
  exp_eq(and3s(ncz <= 0L, , c != 0L),
         band3(ncz <= 0L, , c != 0L))
  exp_eq(and3s(nda <= 1L, , d != 1L),
         band3(nda <= 1L, , d != 1L))
  exp_eq(and3s(ndb <= 9L, , o != 9L),
         band3(ndb <= 9L, , o != 9L))
  exp_eq(and3s(ndc <= 0L, logi_a, ),
         band3(ndc <= 0L, logi_a, ))
  exp_eq(and3s(ndd <= 1L, logi_r, ),
         band3(ndd <= 1L, logi_r, ))
  exp_eq(and3s(nde <= 9L, logi_o, ),
         band3(nde <= 9L, logi_o, ))
  exp_eq(and3s(ndf <= 0L, logi_n, f != 0L),
         band3(ndf <= 0L, logi_n, f != 0L))
  exp_eq(and3s(ndg <= 1L, logi_e, e != 1L),
         band3(ndg <= 1L, logi_e, e != 1L))
  exp_eq(and3s(ndh <= 9L, logi_z, k != 9L),
         band3(ndh <= 9L, logi_z, k != 9L))
  exp_eq(and3s(ndi <= 0L, , ),
         band3(ndi <= 0L, , ))
  exp_eq(and3s(ndj <= 1L, , ),
         band3(ndj <= 1L, , ))
  exp_eq(and3s(ndk <= 9L, , ),
         band3(ndk <= 9L, , ))
  exp_eq(and3s(ndl <= 0L, , u %between% c(-1L, 1L)),
         band3(ndl <= 0L, , u %between% c(-1L, 1L)))
  exp_eq(and3s(ndm <= 1L, , t %between% c(-1L, 1L)),
         band3(ndm <= 1L, , t %between% c(-1L, 1L)))
  exp_eq(and3s(ndn <= 9L, , l %between% c(-1L, 1L)),
         band3(ndn <= 9L, , l %between% c(-1L, 1L)))
  exp_eq(and3s(ndo <= 0L, logi_s, ),
         band3(ndo <= 0L, logi_s, ))
  exp_eq(and3s(ndp <= 1L, logi_d, ),
         band3(ndp <= 1L, logi_d, ))
  exp_eq(and3s(ndq <= 9L, logi_e, ),
         band3(ndq <= 9L, logi_e, ))
  exp_eq(and3s(ndr <= 0L, logi_h, z %between% c(-1L, 1L)),
         band3(ndr <= 0L, logi_h, z %between% c(-1L, 1L)))
  exp_eq(and3s(nds <= 1L, logi_w, w %between% c(-1L, 1L)),
         band3(nds <= 1L, logi_w, w %between% c(-1L, 1L)))
  exp_eq(and3s(ndt <= 9L, logi_n, y %between% c(-1L, 1L)),
         band3(ndt <= 9L, logi_n, y %between% c(-1L, 1L)))
  exp_eq(and3s(ndu <= 0L, , ),
         band3(ndu <= 0L, , ))
  exp_eq(and3s(ndv <= 1L, , ),
         band3(ndv <= 1L, , ))
  exp_eq(and3s(ndw <= 9L, , ),
         band3(ndw <= 9L, , ))
  exp_eq(and3s(ndx <= 0L, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ndx <= 0L, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ndy <= 1L, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ndy <= 1L, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ndz <= 9L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ndz <= 9L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nea <= 0L, logi_t, ),
         band3(nea <= 0L, logi_t, ))
  exp_eq(and3s(neb <= 1L, logi_m, ),
         band3(neb <= 1L, logi_m, ))
  exp_eq(and3s(nec <= 9L, logi_r, ),
         band3(nec <= 9L, logi_r, ))
  exp_eq(and3s(ned <= 0L, logi_f, r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ned <= 0L, logi_f, r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nee <= 1L, logi_l, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nee <= 1L, logi_l, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nef <= 9L, logi_l, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nef <= 9L, logi_l, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(neg <= 0L, , ),
         band3(neg <= 0L, , ))
  exp_eq(and3s(neh <= 1L, , ),
         band3(neh <= 1L, , ))
  exp_eq(and3s(nei <= 9L, , ),
         band3(nei <= 9L, , ))
  exp_eq(and3s(nej <= 0L, , r %in% 1:4),
         band3(nej <= 0L, , r %in% 1:4))
  exp_eq(and3s(nek <= 1L, , o %in% 1:4),
         band3(nek <= 1L, , o %in% 1:4))
  exp_eq(and3s(nel <= 9L, , c %in% 1:4),
         band3(nel <= 9L, , c %in% 1:4))
  exp_eq(and3s(nem <= 0L, logi_t, ),
         band3(nem <= 0L, logi_t, ))
  exp_eq(and3s(nen <= 1L, logi_a, ),
         band3(nen <= 1L, logi_a, ))
  exp_eq(and3s(neo <= 9L, logi_q, ),
         band3(neo <= 9L, logi_q, ))
  exp_eq(and3s(nep <= 0L, logi_h, q %in% 1:4),
         band3(nep <= 0L, logi_h, q %in% 1:4))
  exp_eq(and3s(neq <= 1L, logi_b, e %in% 1:4),
         band3(neq <= 1L, logi_b, e %in% 1:4))
  exp_eq(and3s(ner <= 9L, logi_w, o %in% 1:4),
         band3(ner <= 9L, logi_w, o %in% 1:4))
  exp_eq(and3s(nes <= 0L, , ),
         band3(nes <= 0L, , ))
  exp_eq(and3s(net <= 1L, , ),
         band3(net <= 1L, , ))
  exp_eq(and3s(neu <= 9L, , ),
         band3(neu <= 9L, , ))
  exp_eq(and3s(nev <= 0L, , y < 0L),
         band3(nev <= 0L, , y < 0L))
  exp_eq(and3s(new <= 1L, , m < 1L),
         band3(new <= 1L, , m < 1L))
  exp_eq(and3s(nex <= 9L, , v < 9L),
         band3(nex <= 9L, , v < 9L))
  exp_eq(and3s(ney <= 0L, logi_c, ),
         band3(ney <= 0L, logi_c, ))
  exp_eq(and3s(nez <= 1L, logi_g, ),
         band3(nez <= 1L, logi_g, ))
  exp_eq(and3s(nfa <= 9L, logi_e, ),
         band3(nfa <= 9L, logi_e, ))
  exp_eq(and3s(nfb <= 0L, logi_y, k < 0L),
         band3(nfb <= 0L, logi_y, k < 0L))
  exp_eq(and3s(nfc <= 1L, logi_o, f < 1L),
         band3(nfc <= 1L, logi_o, f < 1L))
  exp_eq(and3s(nfd <= 9L, logi_b, j < 9L),
         band3(nfd <= 9L, logi_b, j < 9L))
  exp_eq(and3s(nfe <= 0L, , ),
         band3(nfe <= 0L, , ))
  exp_eq(and3s(nff <= 1L, , ),
         band3(nff <= 1L, , ))
  exp_eq(and3s(nfg <= 9L, , ),
         band3(nfg <= 9L, , ))
  exp_eq(and3s(nfh <= 0L, , d <= 0L),
         band3(nfh <= 0L, , d <= 0L))
  exp_eq(and3s(nfi <= 1L, , h <= 1L),
         band3(nfi <= 1L, , h <= 1L))
  exp_eq(and3s(nfj <= 9L, , c <= 9L),
         band3(nfj <= 9L, , c <= 9L))
  exp_eq(and3s(nfk <= 0L, logi_u, ),
         band3(nfk <= 0L, logi_u, ))
  exp_eq(and3s(nfl <= 1L, logi_c, ),
         band3(nfl <= 1L, logi_c, ))
  exp_eq(and3s(nfm <= 9L, logi_c, ),
         band3(nfm <= 9L, logi_c, ))
  exp_eq(and3s(nfn <= 0L, logi_e, c <= 0L),
         band3(nfn <= 0L, logi_e, c <= 0L))
  exp_eq(and3s(nfo <= 1L, logi_b, r <= 1L),
         band3(nfo <= 1L, logi_b, r <= 1L))
  exp_eq(and3s(nfp <= 9L, logi_l, x <= 9L),
         band3(nfp <= 9L, logi_l, x <= 9L))
  exp_eq(and3s(nfq <= 0L, , ),
         band3(nfq <= 0L, , ))
  exp_eq(and3s(nfr <= 1L, , ),
         band3(nfr <= 1L, , ))
  exp_eq(and3s(nfs <= 9L, , ),
         band3(nfs <= 9L, , ))
  exp_eq(and3s(nft <= 0L, , a == 0L),
         band3(nft <= 0L, , a == 0L))
  exp_eq(and3s(nfu <= 1L, , h == 1L),
         band3(nfu <= 1L, , h == 1L))
  exp_eq(and3s(nfv <= 9L, , c == 9L),
         band3(nfv <= 9L, , c == 9L))
  exp_eq(and3s(nfw <= 0L, logi_x, ),
         band3(nfw <= 0L, logi_x, ))
  exp_eq(and3s(nfx <= 1L, logi_t, ),
         band3(nfx <= 1L, logi_t, ))
  exp_eq(and3s(nfy <= 9L, logi_j, ),
         band3(nfy <= 9L, logi_j, ))
  exp_eq(and3s(nfz <= 0L, logi_o, n == 0L),
         band3(nfz <= 0L, logi_o, n == 0L))
  exp_eq(and3s(nga <= 1L, logi_t, s == 1L),
         band3(nga <= 1L, logi_t, s == 1L))
  exp_eq(and3s(ngb <= 9L, logi_c, h == 9L),
         band3(ngb <= 9L, logi_c, h == 9L))
  exp_eq(and3s(ngc <= 0L, , ),
         band3(ngc <= 0L, , ))
  exp_eq(and3s(ngd <= 1L, , ),
         band3(ngd <= 1L, , ))
  exp_eq(and3s(nge <= 9L, , ),
         band3(nge <= 9L, , ))
  exp_eq(and3s(ngf <= 0L, , n > 0L),
         band3(ngf <= 0L, , n > 0L))
  exp_eq(and3s(ngg <= 1L, , p > 1L),
         band3(ngg <= 1L, , p > 1L))
  exp_eq(and3s(ngh <= 9L, , a > 9L),
         band3(ngh <= 9L, , a > 9L))
  exp_eq(and3s(ngi <= 0L, logi_w, ),
         band3(ngi <= 0L, logi_w, ))
  exp_eq(and3s(ngj <= 1L, logi_n, ),
         band3(ngj <= 1L, logi_n, ))
  exp_eq(and3s(ngk <= 9L, logi_s, ),
         band3(ngk <= 9L, logi_s, ))
  exp_eq(and3s(ngl <= 0L, logi_f, p > 0L),
         band3(ngl <= 0L, logi_f, p > 0L))
  exp_eq(and3s(ngm <= 1L, logi_q, r > 1L),
         band3(ngm <= 1L, logi_q, r > 1L))
  exp_eq(and3s(ngn <= 9L, logi_p, e > 9L),
         band3(ngn <= 9L, logi_p, e > 9L))
  exp_eq(and3s(ngo <= 0L, , ),
         band3(ngo <= 0L, , ))
  exp_eq(and3s(ngp <= 1L, , ),
         band3(ngp <= 1L, , ))
  exp_eq(and3s(ngq <= 9L, , ),
         band3(ngq <= 9L, , ))
  exp_eq(and3s(ngr <= 0L, , z >= 0L),
         band3(ngr <= 0L, , z >= 0L))
  exp_eq(and3s(ngs <= 1L, , m >= 1L),
         band3(ngs <= 1L, , m >= 1L))
  exp_eq(and3s(ngt <= 9L, , e >= 9L),
         band3(ngt <= 9L, , e >= 9L))
  exp_eq(and3s(ngu <= 0L, logi_k, ),
         band3(ngu <= 0L, logi_k, ))
  exp_eq(and3s(ngv <= 1L, logi_l, ),
         band3(ngv <= 1L, logi_l, ))
  exp_eq(and3s(ngw <= 9L, logi_b, ),
         band3(ngw <= 9L, logi_b, ))
  exp_eq(and3s(ngx <= 0L, logi_v, n >= 0L),
         band3(ngx <= 0L, logi_v, n >= 0L))
  exp_eq(and3s(ngy <= 1L, logi_c, p >= 1L),
         band3(ngy <= 1L, logi_c, p >= 1L))
  exp_eq(and3s(ngz <= 9L, logi_i, i >= 9L),
         band3(ngz <= 9L, logi_i, i >= 9L))
  exp_eq(and3s(nha <= 0L, , ),
         band3(nha <= 0L, , ))
  exp_eq(and3s(nhb <= 1L, , ),
         band3(nhb <= 1L, , ))
  exp_eq(and3s(nhc <= 9L, , ),
         band3(nhc <= 9L, , ))
  exp_eq(and3s(nhd <= 0L, , logi_h),
         band3(nhd <= 0L, , logi_h))
  exp_eq(and3s(nhe <= 1L, , logi_b),
         band3(nhe <= 1L, , logi_b))
  exp_eq(and3s(nhf <= 9L, , logi_u),
         band3(nhf <= 9L, , logi_u))
  exp_eq(and3s(nhg <= 0L, !logi_u, ),
         band3(nhg <= 0L, !logi_u, ))
  exp_eq(and3s(nhh <= 1L, !logi_j, ),
         band3(nhh <= 1L, !logi_j, ))
  exp_eq(and3s(nhi <= 9L, !logi_b, ),
         band3(nhi <= 9L, !logi_b, ))
  exp_eq(and3s(nhj <= 0L, !logi_n, logi_p),
         band3(nhj <= 0L, !logi_n, logi_p))
  exp_eq(and3s(nhk <= 1L, !logi_o, logi_i),
         band3(nhk <= 1L, !logi_o, logi_i))
  exp_eq(and3s(nhl <= 9L, !logi_j, logi_e),
         band3(nhl <= 9L, !logi_j, logi_e))
  exp_eq(and3s(nhm <= 0L, , ),
         band3(nhm <= 0L, , ))
  exp_eq(and3s(nhn <= 1L, , ),
         band3(nhn <= 1L, , ))
  exp_eq(and3s(nho <= 9L, , ),
         band3(nho <= 9L, , ))
  exp_eq(and3s(nhp <= 0L, , !logi_s),
         band3(nhp <= 0L, , !logi_s))
  exp_eq(and3s(nhq <= 1L, , !logi_w),
         band3(nhq <= 1L, , !logi_w))
  exp_eq(and3s(nhr <= 9L, , !logi_w),
         band3(nhr <= 9L, , !logi_w))
  exp_eq(and3s(nhs <= 0L, !logi_w, ),
         band3(nhs <= 0L, !logi_w, ))
  exp_eq(and3s(nht <= 1L, !logi_b, ),
         band3(nht <= 1L, !logi_b, ))
  exp_eq(and3s(nhu <= 9L, !logi_j, ),
         band3(nhu <= 9L, !logi_j, ))
  exp_eq(and3s(nhv <= 0L, !logi_j, !logi_y),
         band3(nhv <= 0L, !logi_j, !logi_y))
  exp_eq(and3s(nhw <= 1L, !logi_e, !logi_k),
         band3(nhw <= 1L, !logi_e, !logi_k))
  exp_eq(and3s(nhx <= 9L, !logi_y, !logi_w),
         band3(nhx <= 9L, !logi_y, !logi_w))
  exp_eq(and3s(nhy <= 0L, , ),
         band3(nhy <= 0L, , ))
  exp_eq(and3s(nhz <= 1L, , ),
         band3(nhz <= 1L, , ))
  exp_eq(and3s(nia <= 9L, , ),
         band3(nia <= 9L, , ))
  exp_eq(and3s(nib <= 0L, , j != 0L),
         band3(nib <= 0L, , j != 0L))
  exp_eq(and3s(nic <= 1L, , d != 1L),
         band3(nic <= 1L, , d != 1L))
  exp_eq(and3s(nid <= 9L, , e != 9L),
         band3(nid <= 9L, , e != 9L))
  exp_eq(and3s(nie <= 0L, !logi_q, ),
         band3(nie <= 0L, !logi_q, ))
  exp_eq(and3s(nif <= 1L, !logi_u, ),
         band3(nif <= 1L, !logi_u, ))
  exp_eq(and3s(nig <= 9L, !logi_y, ),
         band3(nig <= 9L, !logi_y, ))
  exp_eq(and3s(nih <= 0L, !logi_h, e != 0L),
         band3(nih <= 0L, !logi_h, e != 0L))
  exp_eq(and3s(nii <= 1L, !logi_z, i != 1L),
         band3(nii <= 1L, !logi_z, i != 1L))
  exp_eq(and3s(nij <= 9L, !logi_o, s != 9L),
         band3(nij <= 9L, !logi_o, s != 9L))
  exp_eq(and3s(nik <= 0L, , ),
         band3(nik <= 0L, , ))
  exp_eq(and3s(nil <= 1L, , ),
         band3(nil <= 1L, , ))
  exp_eq(and3s(nim <= 9L, , ),
         band3(nim <= 9L, , ))
  exp_eq(and3s(nin <= 0L, , k %between% c(-1L, 1L)),
         band3(nin <= 0L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(nio <= 1L, , q %between% c(-1L, 1L)),
         band3(nio <= 1L, , q %between% c(-1L, 1L)))
  exp_eq(and3s(nip <= 9L, , c %between% c(-1L, 1L)),
         band3(nip <= 9L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(niq <= 0L, !logi_a, ),
         band3(niq <= 0L, !logi_a, ))
  exp_eq(and3s(nir <= 1L, !logi_h, ),
         band3(nir <= 1L, !logi_h, ))
  exp_eq(and3s(nis <= 9L, !logi_w, ),
         band3(nis <= 9L, !logi_w, ))
  exp_eq(and3s(nit <= 0L, !logi_x, w %between% c(-1L, 1L)),
         band3(nit <= 0L, !logi_x, w %between% c(-1L, 1L)))
  exp_eq(and3s(niu <= 1L, !logi_k, b %between% c(-1L, 1L)),
         band3(niu <= 1L, !logi_k, b %between% c(-1L, 1L)))
  exp_eq(and3s(niv <= 9L, !logi_k, w %between% c(-1L, 1L)),
         band3(niv <= 9L, !logi_k, w %between% c(-1L, 1L)))
  exp_eq(and3s(niw <= 0L, , ),
         band3(niw <= 0L, , ))
  exp_eq(and3s(nix <= 1L, , ),
         band3(nix <= 1L, , ))
  exp_eq(and3s(niy <= 9L, , ),
         band3(niy <= 9L, , ))
  exp_eq(and3s(niz <= 0L, , h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(niz <= 0L, , h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nja <= 1L, , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nja <= 1L, , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(njb <= 9L, , w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(njb <= 9L, , w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(njc <= 0L, !logi_t, ),
         band3(njc <= 0L, !logi_t, ))
  exp_eq(and3s(njd <= 1L, !logi_j, ),
         band3(njd <= 1L, !logi_j, ))
  exp_eq(and3s(nje <= 9L, !logi_z, ),
         band3(nje <= 9L, !logi_z, ))
  exp_eq(and3s(njf <= 0L, !logi_h, w %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(njf <= 0L, !logi_h, w %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(njg <= 1L, !logi_o, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(njg <= 1L, !logi_o, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(njh <= 9L, !logi_w, e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(njh <= 9L, !logi_w, e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nji <= 0L, , ),
         band3(nji <= 0L, , ))
  exp_eq(and3s(njj <= 1L, , ),
         band3(njj <= 1L, , ))
  exp_eq(and3s(njk <= 9L, , ),
         band3(njk <= 9L, , ))
  exp_eq(and3s(njl <= 0L, , o %in% 1:4),
         band3(njl <= 0L, , o %in% 1:4))
  exp_eq(and3s(njm <= 1L, , j %in% 1:4),
         band3(njm <= 1L, , j %in% 1:4))
  exp_eq(and3s(njn <= 9L, , i %in% 1:4),
         band3(njn <= 9L, , i %in% 1:4))
  exp_eq(and3s(njo <= 0L, !logi_b, ),
         band3(njo <= 0L, !logi_b, ))
  exp_eq(and3s(njp <= 1L, !logi_u, ),
         band3(njp <= 1L, !logi_u, ))
  exp_eq(and3s(njq <= 9L, !logi_k, ),
         band3(njq <= 9L, !logi_k, ))
  exp_eq(and3s(njr <= 0L, !logi_d, y %in% 1:4),
         band3(njr <= 0L, !logi_d, y %in% 1:4))
  exp_eq(and3s(njs <= 1L, !logi_z, z %in% 1:4),
         band3(njs <= 1L, !logi_z, z %in% 1:4))
  exp_eq(and3s(njt <= 9L, !logi_c, a %in% 1:4),
         band3(njt <= 9L, !logi_c, a %in% 1:4))
  exp_eq(and3s(nju <= 0L, , ),
         band3(nju <= 0L, , ))
  exp_eq(and3s(njv <= 1L, , ),
         band3(njv <= 1L, , ))
  exp_eq(and3s(njw <= 9L, , ),
         band3(njw <= 9L, , ))
  exp_eq(and3s(njx <= 0L, , k < 0L),
         band3(njx <= 0L, , k < 0L))
  exp_eq(and3s(njy <= 1L, , b < 1L),
         band3(njy <= 1L, , b < 1L))
  exp_eq(and3s(njz <= 9L, , a < 9L),
         band3(njz <= 9L, , a < 9L))
  exp_eq(and3s(nka <= 0L, !logi_i, ),
         band3(nka <= 0L, !logi_i, ))
  exp_eq(and3s(nkb <= 1L, !logi_j, ),
         band3(nkb <= 1L, !logi_j, ))
  exp_eq(and3s(nkc <= 9L, !logi_j, ),
         band3(nkc <= 9L, !logi_j, ))
  exp_eq(and3s(nkd <= 0L, !logi_d, t < 0L),
         band3(nkd <= 0L, !logi_d, t < 0L))
  exp_eq(and3s(nke <= 1L, !logi_j, l < 1L),
         band3(nke <= 1L, !logi_j, l < 1L))
  exp_eq(and3s(nkf <= 9L, !logi_n, b < 9L),
         band3(nkf <= 9L, !logi_n, b < 9L))
  exp_eq(and3s(nkg <= 0L, , ),
         band3(nkg <= 0L, , ))
  exp_eq(and3s(nkh <= 1L, , ),
         band3(nkh <= 1L, , ))
  exp_eq(and3s(nki <= 9L, , ),
         band3(nki <= 9L, , ))
  exp_eq(and3s(nkj <= 0L, , y <= 0L),
         band3(nkj <= 0L, , y <= 0L))
  exp_eq(and3s(nkk <= 1L, , p <= 1L),
         band3(nkk <= 1L, , p <= 1L))
  exp_eq(and3s(nkl <= 9L, , r <= 9L),
         band3(nkl <= 9L, , r <= 9L))
  exp_eq(and3s(nkm <= 0L, !logi_c, ),
         band3(nkm <= 0L, !logi_c, ))
  exp_eq(and3s(nkn <= 1L, !logi_c, ),
         band3(nkn <= 1L, !logi_c, ))
  exp_eq(and3s(nko <= 9L, !logi_w, ),
         band3(nko <= 9L, !logi_w, ))
  exp_eq(and3s(nkp <= 0L, !logi_c, n <= 0L),
         band3(nkp <= 0L, !logi_c, n <= 0L))
  exp_eq(and3s(nkq <= 1L, !logi_a, m <= 1L),
         band3(nkq <= 1L, !logi_a, m <= 1L))
  exp_eq(and3s(nkr <= 9L, !logi_e, o <= 9L),
         band3(nkr <= 9L, !logi_e, o <= 9L))
  exp_eq(and3s(nks <= 0L, , ),
         band3(nks <= 0L, , ))
  exp_eq(and3s(nkt <= 1L, , ),
         band3(nkt <= 1L, , ))
  exp_eq(and3s(nku <= 9L, , ),
         band3(nku <= 9L, , ))
  exp_eq(and3s(nkv <= 0L, , h == 0L),
         band3(nkv <= 0L, , h == 0L))
  exp_eq(and3s(nkw <= 1L, , u == 1L),
         band3(nkw <= 1L, , u == 1L))
  exp_eq(and3s(nkx <= 9L, , k == 9L),
         band3(nkx <= 9L, , k == 9L))
  exp_eq(and3s(nky <= 0L, !logi_e, ),
         band3(nky <= 0L, !logi_e, ))
  exp_eq(and3s(nkz <= 1L, !logi_z, ),
         band3(nkz <= 1L, !logi_z, ))
  exp_eq(and3s(nla <= 9L, !logi_p, ),
         band3(nla <= 9L, !logi_p, ))
  exp_eq(and3s(nlb <= 0L, !logi_h, n == 0L),
         band3(nlb <= 0L, !logi_h, n == 0L))
  exp_eq(and3s(nlc <= 1L, !logi_b, j == 1L),
         band3(nlc <= 1L, !logi_b, j == 1L))
  exp_eq(and3s(nld <= 9L, !logi_t, f == 9L),
         band3(nld <= 9L, !logi_t, f == 9L))
  exp_eq(and3s(nle <= 0L, , ),
         band3(nle <= 0L, , ))
  exp_eq(and3s(nlf <= 1L, , ),
         band3(nlf <= 1L, , ))
  exp_eq(and3s(nlg <= 9L, , ),
         band3(nlg <= 9L, , ))
  exp_eq(and3s(nlh <= 0L, , y > 0L),
         band3(nlh <= 0L, , y > 0L))
  exp_eq(and3s(nli <= 1L, , v > 1L),
         band3(nli <= 1L, , v > 1L))
  exp_eq(and3s(nlj <= 9L, , d > 9L),
         band3(nlj <= 9L, , d > 9L))
  exp_eq(and3s(nlk <= 0L, !logi_q, ),
         band3(nlk <= 0L, !logi_q, ))
  exp_eq(and3s(nll <= 1L, !logi_e, ),
         band3(nll <= 1L, !logi_e, ))
  exp_eq(and3s(nlm <= 9L, !logi_z, ),
         band3(nlm <= 9L, !logi_z, ))
  exp_eq(and3s(nln <= 0L, !logi_t, i > 0L),
         band3(nln <= 0L, !logi_t, i > 0L))
  exp_eq(and3s(nlo <= 1L, !logi_w, h > 1L),
         band3(nlo <= 1L, !logi_w, h > 1L))
  exp_eq(and3s(nlp <= 9L, !logi_p, o > 9L),
         band3(nlp <= 9L, !logi_p, o > 9L))
  exp_eq(and3s(nlq <= 0L, , ),
         band3(nlq <= 0L, , ))
  exp_eq(and3s(nlr <= 1L, , ),
         band3(nlr <= 1L, , ))
  exp_eq(and3s(nls <= 9L, , ),
         band3(nls <= 9L, , ))
  exp_eq(and3s(nlt <= 0L, , h >= 0L),
         band3(nlt <= 0L, , h >= 0L))
  exp_eq(and3s(nlu <= 1L, , z >= 1L),
         band3(nlu <= 1L, , z >= 1L))
  exp_eq(and3s(nlv <= 9L, , g >= 9L),
         band3(nlv <= 9L, , g >= 9L))
  exp_eq(and3s(nlw <= 0L, !logi_a, ),
         band3(nlw <= 0L, !logi_a, ))
  exp_eq(and3s(nlx <= 1L, !logi_h, ),
         band3(nlx <= 1L, !logi_h, ))
  exp_eq(and3s(nly <= 9L, !logi_n, ),
         band3(nly <= 9L, !logi_n, ))
  exp_eq(and3s(nlz <= 0L, !logi_u, f >= 0L),
         band3(nlz <= 0L, !logi_u, f >= 0L))
  exp_eq(and3s(nma <= 1L, !logi_r, g >= 1L),
         band3(nma <= 1L, !logi_r, g >= 1L))
  exp_eq(and3s(nmb <= 9L, !logi_c, b >= 9L),
         band3(nmb <= 9L, !logi_c, b >= 9L))
  exp_eq(and3s(nmc <= 0L, , ),
         band3(nmc <= 0L, , ))
  exp_eq(and3s(nmd <= 1L, , ),
         band3(nmd <= 1L, , ))
  exp_eq(and3s(nme <= 9L, , ),
         band3(nme <= 9L, , ))
  exp_eq(and3s(nmf <= 0L, , logi_n),
         band3(nmf <= 0L, , logi_n))
  exp_eq(and3s(nmg <= 1L, , logi_m),
         band3(nmg <= 1L, , logi_m))
  exp_eq(and3s(nmh <= 9L, , logi_z),
         band3(nmh <= 9L, , logi_z))
  exp_eq(and3s(nmi <= 0L, z != 0L, ),
         band3(nmi <= 0L, z != 0L, ))
  exp_eq(and3s(nmj <= 1L, d != 1L, ),
         band3(nmj <= 1L, d != 1L, ))
  exp_eq(and3s(nmk <= 9L, r != 9L, ),
         band3(nmk <= 9L, r != 9L, ))
  exp_eq(and3s(nml <= 0L, a != 0L, logi_m),
         band3(nml <= 0L, a != 0L, logi_m))
  exp_eq(and3s(nmm <= 1L, u != 1L, logi_c),
         band3(nmm <= 1L, u != 1L, logi_c))
  exp_eq(and3s(nmn <= 9L, s != 9L, logi_s),
         band3(nmn <= 9L, s != 9L, logi_s))
  exp_eq(and3s(nmo <= 0L, , ),
         band3(nmo <= 0L, , ))
  exp_eq(and3s(nmp <= 1L, , ),
         band3(nmp <= 1L, , ))
  exp_eq(and3s(nmq <= 9L, , ),
         band3(nmq <= 9L, , ))
  exp_eq(and3s(nmr <= 0L, , !logi_d),
         band3(nmr <= 0L, , !logi_d))
  exp_eq(and3s(nms <= 1L, , !logi_t),
         band3(nms <= 1L, , !logi_t))
  exp_eq(and3s(nmt <= 9L, , !logi_e),
         band3(nmt <= 9L, , !logi_e))
  exp_eq(and3s(nmu <= 0L, l != 0L, ),
         band3(nmu <= 0L, l != 0L, ))
  exp_eq(and3s(nmv <= 1L, n != 1L, ),
         band3(nmv <= 1L, n != 1L, ))
  exp_eq(and3s(nmw <= 9L, f != 9L, ),
         band3(nmw <= 9L, f != 9L, ))
  exp_eq(and3s(nmx <= 0L, s != 0L, !logi_o),
         band3(nmx <= 0L, s != 0L, !logi_o))
  exp_eq(and3s(nmy <= 1L, e != 1L, !logi_l),
         band3(nmy <= 1L, e != 1L, !logi_l))
  exp_eq(and3s(nmz <= 9L, d != 9L, !logi_r),
         band3(nmz <= 9L, d != 9L, !logi_r))
  exp_eq(and3s(nna <= 0L, , ),
         band3(nna <= 0L, , ))
  exp_eq(and3s(nnb <= 1L, , ),
         band3(nnb <= 1L, , ))
  exp_eq(and3s(nnc <= 9L, , ),
         band3(nnc <= 9L, , ))
  exp_eq(and3s(nnd <= 0L, , r != 0L),
         band3(nnd <= 0L, , r != 0L))
  exp_eq(and3s(nne <= 1L, , l != 1L),
         band3(nne <= 1L, , l != 1L))
  exp_eq(and3s(nnf <= 9L, , u != 9L),
         band3(nnf <= 9L, , u != 9L))
  exp_eq(and3s(nng <= 0L, h != 0L, ),
         band3(nng <= 0L, h != 0L, ))
  exp_eq(and3s(nnh <= 1L, r != 1L, ),
         band3(nnh <= 1L, r != 1L, ))
  exp_eq(and3s(nni <= 9L, j != 9L, ),
         band3(nni <= 9L, j != 9L, ))
  exp_eq(and3s(nnj <= 0L, r != 0L, s != 0L),
         band3(nnj <= 0L, r != 0L, s != 0L))
  exp_eq(and3s(nnk <= 1L, r != 1L, i != 1L),
         band3(nnk <= 1L, r != 1L, i != 1L))
  exp_eq(and3s(nnl <= 9L, m != 9L, p != 9L),
         band3(nnl <= 9L, m != 9L, p != 9L))
  exp_eq(and3s(nnm <= 0L, , ),
         band3(nnm <= 0L, , ))
  exp_eq(and3s(nnn <= 1L, , ),
         band3(nnn <= 1L, , ))
  exp_eq(and3s(nno <= 9L, , ),
         band3(nno <= 9L, , ))
  exp_eq(and3s(nnp <= 0L, , z %between% c(-1L, 1L)),
         band3(nnp <= 0L, , z %between% c(-1L, 1L)))
  exp_eq(and3s(nnq <= 1L, , m %between% c(-1L, 1L)),
         band3(nnq <= 1L, , m %between% c(-1L, 1L)))
  exp_eq(and3s(nnr <= 9L, , k %between% c(-1L, 1L)),
         band3(nnr <= 9L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(nns <= 0L, f != 0L, ),
         band3(nns <= 0L, f != 0L, ))
  exp_eq(and3s(nnt <= 1L, f != 1L, ),
         band3(nnt <= 1L, f != 1L, ))
  exp_eq(and3s(nnu <= 9L, e != 9L, ),
         band3(nnu <= 9L, e != 9L, ))
  exp_eq(and3s(nnv <= 0L, b != 0L, c %between% c(-1L, 1L)),
         band3(nnv <= 0L, b != 0L, c %between% c(-1L, 1L)))
  exp_eq(and3s(nnw <= 1L, q != 1L, g %between% c(-1L, 1L)),
         band3(nnw <= 1L, q != 1L, g %between% c(-1L, 1L)))
  exp_eq(and3s(nnx <= 9L, p != 9L, s %between% c(-1L, 1L)),
         band3(nnx <= 9L, p != 9L, s %between% c(-1L, 1L)))
  exp_eq(and3s(nny <= 0L, , ),
         band3(nny <= 0L, , ))
  exp_eq(and3s(nnz <= 1L, , ),
         band3(nnz <= 1L, , ))
  exp_eq(and3s(noa <= 9L, , ),
         band3(noa <= 9L, , ))
  exp_eq(and3s(nob <= 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nob <= 0L, , p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(noc <= 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(noc <= 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nod <= 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nod <= 9L, , v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(noe <= 0L, k != 0L, ),
         band3(noe <= 0L, k != 0L, ))
  exp_eq(and3s(nof <= 1L, l != 1L, ),
         band3(nof <= 1L, l != 1L, ))
  exp_eq(and3s(nog <= 9L, c != 9L, ),
         band3(nog <= 9L, c != 9L, ))
  exp_eq(and3s(noh <= 0L, z != 0L, x %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(noh <= 0L, z != 0L, x %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(noi <= 1L, t != 1L, g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(noi <= 1L, t != 1L, g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(noj <= 9L, e != 9L, h %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(noj <= 9L, e != 9L, h %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nok <= 0L, , ),
         band3(nok <= 0L, , ))
  exp_eq(and3s(nol <= 1L, , ),
         band3(nol <= 1L, , ))
  exp_eq(and3s(nom <= 9L, , ),
         band3(nom <= 9L, , ))
  exp_eq(and3s(non <= 0L, , s %in% 1:4),
         band3(non <= 0L, , s %in% 1:4))
  exp_eq(and3s(noo <= 1L, , j %in% 1:4),
         band3(noo <= 1L, , j %in% 1:4))
  exp_eq(and3s(nop <= 9L, , c %in% 1:4),
         band3(nop <= 9L, , c %in% 1:4))
  exp_eq(and3s(noq <= 0L, i != 0L, ),
         band3(noq <= 0L, i != 0L, ))
  exp_eq(and3s(nor <= 1L, h != 1L, ),
         band3(nor <= 1L, h != 1L, ))
  exp_eq(and3s(nos <= 9L, s != 9L, ),
         band3(nos <= 9L, s != 9L, ))
  exp_eq(and3s(not <= 0L, j != 0L, g %in% 1:4),
         band3(not <= 0L, j != 0L, g %in% 1:4))
  exp_eq(and3s(nou <= 1L, c != 1L, d %in% 1:4),
         band3(nou <= 1L, c != 1L, d %in% 1:4))
  exp_eq(and3s(nov <= 9L, h != 9L, z %in% 1:4),
         band3(nov <= 9L, h != 9L, z %in% 1:4))
  exp_eq(and3s(now <= 0L, , ),
         band3(now <= 0L, , ))
  exp_eq(and3s(nox <= 1L, , ),
         band3(nox <= 1L, , ))
  exp_eq(and3s(noy <= 9L, , ),
         band3(noy <= 9L, , ))
  exp_eq(and3s(noz <= 0L, , g < 0L),
         band3(noz <= 0L, , g < 0L))
  exp_eq(and3s(npa <= 1L, , h < 1L),
         band3(npa <= 1L, , h < 1L))
  exp_eq(and3s(npb <= 9L, , q < 9L),
         band3(npb <= 9L, , q < 9L))
  exp_eq(and3s(npc <= 0L, h != 0L, ),
         band3(npc <= 0L, h != 0L, ))
  exp_eq(and3s(npd <= 1L, m != 1L, ),
         band3(npd <= 1L, m != 1L, ))
  exp_eq(and3s(npe <= 9L, w != 9L, ),
         band3(npe <= 9L, w != 9L, ))
  exp_eq(and3s(npf <= 0L, q != 0L, v < 0L),
         band3(npf <= 0L, q != 0L, v < 0L))
  exp_eq(and3s(npg <= 1L, e != 1L, n < 1L),
         band3(npg <= 1L, e != 1L, n < 1L))
  exp_eq(and3s(nph <= 9L, u != 9L, t < 9L),
         band3(nph <= 9L, u != 9L, t < 9L))
  exp_eq(and3s(npi <= 0L, , ),
         band3(npi <= 0L, , ))
  exp_eq(and3s(npj <= 1L, , ),
         band3(npj <= 1L, , ))
  exp_eq(and3s(npk <= 9L, , ),
         band3(npk <= 9L, , ))
  exp_eq(and3s(npl <= 0L, , x <= 0L),
         band3(npl <= 0L, , x <= 0L))
  exp_eq(and3s(npm <= 1L, , l <= 1L),
         band3(npm <= 1L, , l <= 1L))
  exp_eq(and3s(npn <= 9L, , e <= 9L),
         band3(npn <= 9L, , e <= 9L))
  exp_eq(and3s(npo <= 0L, r != 0L, ),
         band3(npo <= 0L, r != 0L, ))
  exp_eq(and3s(npp <= 1L, d != 1L, ),
         band3(npp <= 1L, d != 1L, ))
  exp_eq(and3s(npq <= 9L, n != 9L, ),
         band3(npq <= 9L, n != 9L, ))
  exp_eq(and3s(npr <= 0L, s != 0L, z <= 0L),
         band3(npr <= 0L, s != 0L, z <= 0L))
  exp_eq(and3s(nps <= 1L, h != 1L, k <= 1L),
         band3(nps <= 1L, h != 1L, k <= 1L))
  exp_eq(and3s(npt <= 9L, l != 9L, b <= 9L),
         band3(npt <= 9L, l != 9L, b <= 9L))
  exp_eq(and3s(npu <= 0L, , ),
         band3(npu <= 0L, , ))
  exp_eq(and3s(npv <= 1L, , ),
         band3(npv <= 1L, , ))
  exp_eq(and3s(npw <= 9L, , ),
         band3(npw <= 9L, , ))
  exp_eq(and3s(npx <= 0L, , x == 0L),
         band3(npx <= 0L, , x == 0L))
  exp_eq(and3s(npy <= 1L, , s == 1L),
         band3(npy <= 1L, , s == 1L))
  exp_eq(and3s(npz <= 9L, , t == 9L),
         band3(npz <= 9L, , t == 9L))
  exp_eq(and3s(nqa <= 0L, s != 0L, ),
         band3(nqa <= 0L, s != 0L, ))
  exp_eq(and3s(nqb <= 1L, o != 1L, ),
         band3(nqb <= 1L, o != 1L, ))
  exp_eq(and3s(nqc <= 9L, z != 9L, ),
         band3(nqc <= 9L, z != 9L, ))
  exp_eq(and3s(nqd <= 0L, i != 0L, t == 0L),
         band3(nqd <= 0L, i != 0L, t == 0L))
  exp_eq(and3s(nqe <= 1L, a != 1L, l == 1L),
         band3(nqe <= 1L, a != 1L, l == 1L))
  exp_eq(and3s(nqf <= 9L, j != 9L, i == 9L),
         band3(nqf <= 9L, j != 9L, i == 9L))
  exp_eq(and3s(nqg <= 0L, , ),
         band3(nqg <= 0L, , ))
  exp_eq(and3s(nqh <= 1L, , ),
         band3(nqh <= 1L, , ))
  exp_eq(and3s(nqi <= 9L, , ),
         band3(nqi <= 9L, , ))
  exp_eq(and3s(nqj <= 0L, , n > 0L),
         band3(nqj <= 0L, , n > 0L))
  exp_eq(and3s(nqk <= 1L, , l > 1L),
         band3(nqk <= 1L, , l > 1L))
  exp_eq(and3s(nql <= 9L, , y > 9L),
         band3(nql <= 9L, , y > 9L))
  exp_eq(and3s(nqm <= 0L, n != 0L, ),
         band3(nqm <= 0L, n != 0L, ))
  exp_eq(and3s(nqn <= 1L, t != 1L, ),
         band3(nqn <= 1L, t != 1L, ))
  exp_eq(and3s(nqo <= 9L, o != 9L, ),
         band3(nqo <= 9L, o != 9L, ))
  exp_eq(and3s(nqp <= 0L, y != 0L, v > 0L),
         band3(nqp <= 0L, y != 0L, v > 0L))
  exp_eq(and3s(nqq <= 1L, z != 1L, n > 1L),
         band3(nqq <= 1L, z != 1L, n > 1L))
  exp_eq(and3s(nqr <= 9L, n != 9L, g > 9L),
         band3(nqr <= 9L, n != 9L, g > 9L))
  exp_eq(and3s(nqs <= 0L, , ),
         band3(nqs <= 0L, , ))
  exp_eq(and3s(nqt <= 1L, , ),
         band3(nqt <= 1L, , ))
  exp_eq(and3s(nqu <= 9L, , ),
         band3(nqu <= 9L, , ))
  exp_eq(and3s(nqv <= 0L, , f >= 0L),
         band3(nqv <= 0L, , f >= 0L))
  exp_eq(and3s(nqw <= 1L, , s >= 1L),
         band3(nqw <= 1L, , s >= 1L))
  exp_eq(and3s(nqx <= 9L, , i >= 9L),
         band3(nqx <= 9L, , i >= 9L))
  exp_eq(and3s(nqy <= 0L, p != 0L, ),
         band3(nqy <= 0L, p != 0L, ))
  exp_eq(and3s(nqz <= 1L, v != 1L, ),
         band3(nqz <= 1L, v != 1L, ))
  exp_eq(and3s(nra <= 9L, f != 9L, ),
         band3(nra <= 9L, f != 9L, ))
  exp_eq(and3s(nrb <= 0L, u != 0L, s >= 0L),
         band3(nrb <= 0L, u != 0L, s >= 0L))
  exp_eq(and3s(nrc <= 1L, y != 1L, n >= 1L),
         band3(nrc <= 1L, y != 1L, n >= 1L))
  exp_eq(and3s(nrd <= 9L, a != 9L, h >= 9L),
         band3(nrd <= 9L, a != 9L, h >= 9L))
  exp_eq(and3s(nre <= 0L, , ),
         band3(nre <= 0L, , ))
  exp_eq(and3s(nrf <= 1L, , ),
         band3(nrf <= 1L, , ))
  exp_eq(and3s(nrg <= 9L, , ),
         band3(nrg <= 9L, , ))
  exp_eq(and3s(nrh <= 0L, , logi_w),
         band3(nrh <= 0L, , logi_w))
  exp_eq(and3s(nri <= 1L, , logi_u),
         band3(nri <= 1L, , logi_u))
  exp_eq(and3s(nrj <= 9L, , logi_a),
         band3(nrj <= 9L, , logi_a))
  exp_eq(and3s(nrk <= 0L, m %between% c(-1L, 1L), ),
         band3(nrk <= 0L, m %between% c(-1L, 1L), ))
  exp_eq(and3s(nrl <= 1L, f %between% c(-1L, 1L), ),
         band3(nrl <= 1L, f %between% c(-1L, 1L), ))
  exp_eq(and3s(nrm <= 9L, i %between% c(-1L, 1L), ),
         band3(nrm <= 9L, i %between% c(-1L, 1L), ))
  exp_eq(and3s(nrn <= 0L, q %between% c(-1L, 1L), logi_v),
         band3(nrn <= 0L, q %between% c(-1L, 1L), logi_v))
  exp_eq(and3s(nro <= 1L, j %between% c(-1L, 1L), logi_w),
         band3(nro <= 1L, j %between% c(-1L, 1L), logi_w))
  exp_eq(and3s(nrp <= 9L, d %between% c(-1L, 1L), logi_b),
         band3(nrp <= 9L, d %between% c(-1L, 1L), logi_b))
  exp_eq(and3s(nrq <= 0L, , ),
         band3(nrq <= 0L, , ))
  exp_eq(and3s(nrr <= 1L, , ),
         band3(nrr <= 1L, , ))
  exp_eq(and3s(nrs <= 9L, , ),
         band3(nrs <= 9L, , ))
  exp_eq(and3s(nrt <= 0L, , !logi_d),
         band3(nrt <= 0L, , !logi_d))
  exp_eq(and3s(nru <= 1L, , !logi_g),
         band3(nru <= 1L, , !logi_g))
  exp_eq(and3s(nrv <= 9L, , !logi_a),
         band3(nrv <= 9L, , !logi_a))
  exp_eq(and3s(nrw <= 0L, o %between% c(-1L, 1L), ),
         band3(nrw <= 0L, o %between% c(-1L, 1L), ))
  exp_eq(and3s(nrx <= 1L, k %between% c(-1L, 1L), ),
         band3(nrx <= 1L, k %between% c(-1L, 1L), ))
  exp_eq(and3s(nry <= 9L, g %between% c(-1L, 1L), ),
         band3(nry <= 9L, g %between% c(-1L, 1L), ))
  exp_eq(and3s(nrz <= 0L, l %between% c(-1L, 1L), !logi_u),
         band3(nrz <= 0L, l %between% c(-1L, 1L), !logi_u))
  exp_eq(and3s(nsa <= 1L, v %between% c(-1L, 1L), !logi_i),
         band3(nsa <= 1L, v %between% c(-1L, 1L), !logi_i))
  exp_eq(and3s(nsb <= 9L, g %between% c(-1L, 1L), !logi_w),
         band3(nsb <= 9L, g %between% c(-1L, 1L), !logi_w))
  exp_eq(and3s(nsc <= 0L, , ),
         band3(nsc <= 0L, , ))
  exp_eq(and3s(nsd <= 1L, , ),
         band3(nsd <= 1L, , ))
  exp_eq(and3s(nse <= 9L, , ),
         band3(nse <= 9L, , ))
  exp_eq(and3s(nsf <= 0L, , n != 0L),
         band3(nsf <= 0L, , n != 0L))
  exp_eq(and3s(nsg <= 1L, , a != 1L),
         band3(nsg <= 1L, , a != 1L))
  exp_eq(and3s(nsh <= 9L, , v != 9L),
         band3(nsh <= 9L, , v != 9L))
  exp_eq(and3s(nsi <= 0L, i %between% c(-1L, 1L), ),
         band3(nsi <= 0L, i %between% c(-1L, 1L), ))
  exp_eq(and3s(nsj <= 1L, p %between% c(-1L, 1L), ),
         band3(nsj <= 1L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(nsk <= 9L, l %between% c(-1L, 1L), ),
         band3(nsk <= 9L, l %between% c(-1L, 1L), ))
  exp_eq(and3s(nsl <= 0L, f %between% c(-1L, 1L), d != 0L),
         band3(nsl <= 0L, f %between% c(-1L, 1L), d != 0L))
  exp_eq(and3s(nsm <= 1L, f %between% c(-1L, 1L), y != 1L),
         band3(nsm <= 1L, f %between% c(-1L, 1L), y != 1L))
  exp_eq(and3s(nsn <= 9L, b %between% c(-1L, 1L), w != 9L),
         band3(nsn <= 9L, b %between% c(-1L, 1L), w != 9L))
  exp_eq(and3s(nso <= 0L, , ),
         band3(nso <= 0L, , ))
  exp_eq(and3s(nsp <= 1L, , ),
         band3(nsp <= 1L, , ))
  exp_eq(and3s(nsq <= 9L, , ),
         band3(nsq <= 9L, , ))
  exp_eq(and3s(nsr <= 0L, , g %between% c(-1L, 1L)),
         band3(nsr <= 0L, , g %between% c(-1L, 1L)))
  exp_eq(and3s(nss <= 1L, , e %between% c(-1L, 1L)),
         band3(nss <= 1L, , e %between% c(-1L, 1L)))
  exp_eq(and3s(nst <= 9L, , a %between% c(-1L, 1L)),
         band3(nst <= 9L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(nsu <= 0L, b %between% c(-1L, 1L), ),
         band3(nsu <= 0L, b %between% c(-1L, 1L), ))
  exp_eq(and3s(nsv <= 1L, l %between% c(-1L, 1L), ),
         band3(nsv <= 1L, l %between% c(-1L, 1L), ))
  exp_eq(and3s(nsw <= 9L, c %between% c(-1L, 1L), ),
         band3(nsw <= 9L, c %between% c(-1L, 1L), ))
  exp_eq(and3s(nsx <= 0L, c %between% c(-1L, 1L), f %between% c(-1L, 1L)),
         band3(nsx <= 0L, c %between% c(-1L, 1L), f %between% c(-1L, 1L)))
  exp_eq(and3s(nsy <= 1L, o %between% c(-1L, 1L), y %between% c(-1L, 1L)),
         band3(nsy <= 1L, o %between% c(-1L, 1L), y %between% c(-1L, 1L)))
  exp_eq(and3s(nsz <= 9L, k %between% c(-1L, 1L), g %between% c(-1L, 1L)),
         band3(nsz <= 9L, k %between% c(-1L, 1L), g %between% c(-1L, 1L)))
  exp_eq(and3s(nta <= 0L, , ),
         band3(nta <= 0L, , ))
  exp_eq(and3s(ntb <= 1L, , ),
         band3(ntb <= 1L, , ))
  exp_eq(and3s(ntc <= 9L, , ),
         band3(ntc <= 9L, , ))
  exp_eq(and3s(ntd <= 0L, , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ntd <= 0L, , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(nte <= 1L, , o %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(nte <= 1L, , o %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ntf <= 9L, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ntf <= 9L, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ntg <= 0L, w %between% c(-1L, 1L), ),
         band3(ntg <= 0L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(nth <= 1L, z %between% c(-1L, 1L), ),
         band3(nth <= 1L, z %between% c(-1L, 1L), ))
  exp_eq(and3s(nti <= 9L, v %between% c(-1L, 1L), ),
         band3(nti <= 9L, v %between% c(-1L, 1L), ))
  exp_eq(and3s(ntj <= 0L, i %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ntj <= 0L, i %between% c(-1L, 1L), n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ntk <= 1L, t %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ntk <= 1L, t %between% c(-1L, 1L), g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ntl <= 9L, t %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ntl <= 9L, t %between% c(-1L, 1L), d %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ntm <= 0L, , ),
         band3(ntm <= 0L, , ))
  exp_eq(and3s(ntn <= 1L, , ),
         band3(ntn <= 1L, , ))
  exp_eq(and3s(nto <= 9L, , ),
         band3(nto <= 9L, , ))
  exp_eq(and3s(ntp <= 0L, , q %in% 1:4),
         band3(ntp <= 0L, , q %in% 1:4))
  exp_eq(and3s(ntq <= 1L, , f %in% 1:4),
         band3(ntq <= 1L, , f %in% 1:4))
  exp_eq(and3s(ntr <= 9L, , m %in% 1:4),
         band3(ntr <= 9L, , m %in% 1:4))
  exp_eq(and3s(nts <= 0L, p %between% c(-1L, 1L), ),
         band3(nts <= 0L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(ntt <= 1L, p %between% c(-1L, 1L), ),
         band3(ntt <= 1L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(ntu <= 9L, c %between% c(-1L, 1L), ),
         band3(ntu <= 9L, c %between% c(-1L, 1L), ))
  exp_eq(and3s(ntv <= 0L, y %between% c(-1L, 1L), z %in% 1:4),
         band3(ntv <= 0L, y %between% c(-1L, 1L), z %in% 1:4))
  exp_eq(and3s(ntw <= 1L, s %between% c(-1L, 1L), e %in% 1:4),
         band3(ntw <= 1L, s %between% c(-1L, 1L), e %in% 1:4))
  exp_eq(and3s(ntx <= 9L, w %between% c(-1L, 1L), g %in% 1:4),
         band3(ntx <= 9L, w %between% c(-1L, 1L), g %in% 1:4))
  exp_eq(and3s(nty <= 0L, , ),
         band3(nty <= 0L, , ))
  exp_eq(and3s(ntz <= 1L, , ),
         band3(ntz <= 1L, , ))
  exp_eq(and3s(nua <= 9L, , ),
         band3(nua <= 9L, , ))
  exp_eq(and3s(nub <= 0L, , w < 0L),
         band3(nub <= 0L, , w < 0L))
  exp_eq(and3s(nuc <= 1L, , s < 1L),
         band3(nuc <= 1L, , s < 1L))
  exp_eq(and3s(nud <= 9L, , i < 9L),
         band3(nud <= 9L, , i < 9L))
  exp_eq(and3s(nue <= 0L, p %between% c(-1L, 1L), ),
         band3(nue <= 0L, p %between% c(-1L, 1L), ))
  exp_eq(and3s(nuf <= 1L, w %between% c(-1L, 1L), ),
         band3(nuf <= 1L, w %between% c(-1L, 1L), ))
  exp_eq(and3s(nug <= 9L, l %between% c(-1L, 1L), ),
         band3(nug <= 9L, l %between% c(-1L, 1L), ))
  exp_eq(and3s(nuh <= 0L, r %between% c(-1L, 1L), l < 0L),
         band3(nuh <= 0L, r %between% c(-1L, 1L), l < 0L))
  exp_eq(and3s(nui <= 1L, b %between% c(-1L, 1L), o < 1L),
         band3(nui <= 1L, b %between% c(-1L, 1L), o < 1L))
  exp_eq(and3s(nuj <= 9L, c %between% c(-1L, 1L), n < 9L),
         band3(nuj <= 9L, c %between% c(-1L, 1L), n < 9L))
  exp_eq(and3s(nuk <= 0L, , ),
         band3(nuk <= 0L, , ))
  exp_eq(and3s(nul <= 1L, , ),
         band3(nul <= 1L, , ))
  exp_eq(and3s(num <= 9L, , ),
         band3(num <= 9L, , ))
  exp_eq(and3s(nun <= 0L, , m <= 0L),
         band3(nun <= 0L, , m <= 0L))
  exp_eq(and3s(nuo <= 1L, , n <= 1L),
         band3(nuo <= 1L, , n <= 1L))
  exp_eq(and3s(nup <= 9L, , a <= 9L),
         band3(nup <= 9L, , a <= 9L))
  exp_eq(and3s(nuq <= 0L, i %between% c(-1L, 1L), ),
         band3(nuq <= 0L, i %between% c(-1L, 1L), ))
  exp_eq(and3s(nur <= 1L, t %between% c(-1L, 1L), ),
         band3(nur <= 1L, t %between% c(-1L, 1L), ))
  exp_eq(and3s(nus <= 9L, j %between% c(-1L, 1L), ),
         band3(nus <= 9L, j %between% c(-1L, 1L), ))
  exp_eq(and3s(nut <= 0L, o %between% c(-1L, 1L), v <= 0L),
         band3(nut <= 0L, o %between% c(-1L, 1L), v <= 0L))
  exp_eq(and3s(nuu <= 1L, a %between% c(-1L, 1L), m <= 1L),
         band3(nuu <= 1L, a %between% c(-1L, 1L), m <= 1L))
  exp_eq(and3s(nuv <= 9L, e %between% c(-1L, 1L), f <= 9L),
         band3(nuv <= 9L, e %between% c(-1L, 1L), f <= 9L))
  exp_eq(and3s(nuw <= 0L, , ),
         band3(nuw <= 0L, , ))
  exp_eq(and3s(nux <= 1L, , ),
         band3(nux <= 1L, , ))
  exp_eq(and3s(nuy <= 9L, , ),
         band3(nuy <= 9L, , ))
  exp_eq(and3s(nuz <= 0L, , z == 0L),
         band3(nuz <= 0L, , z == 0L))
  exp_eq(and3s(nva <= 1L, , u == 1L),
         band3(nva <= 1L, , u == 1L))
  exp_eq(and3s(nvb <= 9L, , o == 9L),
         band3(nvb <= 9L, , o == 9L))
  exp_eq(and3s(nvc <= 0L, v %between% c(-1L, 1L), ),
         band3(nvc <= 0L, v %between% c(-1L, 1L), ))
  exp_eq(and3s(nvd <= 1L, z %between% c(-1L, 1L), ),
         band3(nvd <= 1L, z %between% c(-1L, 1L), ))
  exp_eq(and3s(nve <= 9L, v %between% c(-1L, 1L), ),
         band3(nve <= 9L, v %between% c(-1L, 1L), ))
  exp_eq(and3s(nvf <= 0L, b %between% c(-1L, 1L), m == 0L),
         band3(nvf <= 0L, b %between% c(-1L, 1L), m == 0L))
  exp_eq(and3s(nvg <= 1L, x %between% c(-1L, 1L), x == 1L),
         band3(nvg <= 1L, x %between% c(-1L, 1L), x == 1L))
  exp_eq(and3s(nvh <= 9L, u %between% c(-1L, 1L), r == 9L),
         band3(nvh <= 9L, u %between% c(-1L, 1L), r == 9L))
  exp_eq(and3s(nvi <= 0L, , ),
         band3(nvi <= 0L, , ))
  exp_eq(and3s(nvj <= 1L, , ),
         band3(nvj <= 1L, , ))
  exp_eq(and3s(nvk <= 9L, , ),
         band3(nvk <= 9L, , ))
  exp_eq(and3s(nvl <= 0L, , w > 0L),
         band3(nvl <= 0L, , w > 0L))
  exp_eq(and3s(nvm <= 1L, , l > 1L),
         band3(nvm <= 1L, , l > 1L))
  exp_eq(and3s(nvn <= 9L, , j > 9L),
         band3(nvn <= 9L, , j > 9L))
  exp_eq(and3s(nvo <= 0L, r %between% c(-1L, 1L), ),
         band3(nvo <= 0L, r %between% c(-1L, 1L), ))
  exp_eq(and3s(nvp <= 1L, h %between% c(-1L, 1L), ),
         band3(nvp <= 1L, h %between% c(-1L, 1L), ))
  exp_eq(and3s(nvq <= 9L, f %between% c(-1L, 1L), ),
         band3(nvq <= 9L, f %between% c(-1L, 1L), ))
  exp_eq(and3s(nvr <= 0L, q %between% c(-1L, 1L), n > 0L),
         band3(nvr <= 0L, q %between% c(-1L, 1L), n > 0L))
  exp_eq(and3s(nvs <= 1L, l %between% c(-1L, 1L), g > 1L),
         band3(nvs <= 1L, l %between% c(-1L, 1L), g > 1L))
  exp_eq(and3s(nvt <= 9L, v %between% c(-1L, 1L), w > 9L),
         band3(nvt <= 9L, v %between% c(-1L, 1L), w > 9L))
  exp_eq(and3s(nvu <= 0L, , ),
         band3(nvu <= 0L, , ))
  exp_eq(and3s(nvv <= 1L, , ),
         band3(nvv <= 1L, , ))
  exp_eq(and3s(nvw <= 9L, , ),
         band3(nvw <= 9L, , ))
  exp_eq(and3s(nvx <= 0L, , w >= 0L),
         band3(nvx <= 0L, , w >= 0L))
  exp_eq(and3s(nvy <= 1L, , u >= 1L),
         band3(nvy <= 1L, , u >= 1L))
  exp_eq(and3s(nvz <= 9L, , g >= 9L),
         band3(nvz <= 9L, , g >= 9L))
  exp_eq(and3s(nwa <= 0L, d %between% c(-1L, 1L), ),
         band3(nwa <= 0L, d %between% c(-1L, 1L), ))
  exp_eq(and3s(nwb <= 1L, b %between% c(-1L, 1L), ),
         band3(nwb <= 1L, b %between% c(-1L, 1L), ))
  exp_eq(and3s(nwc <= 9L, f %between% c(-1L, 1L), ),
         band3(nwc <= 9L, f %between% c(-1L, 1L), ))
  exp_eq(and3s(nwd <= 0L, g %between% c(-1L, 1L), i >= 0L),
         band3(nwd <= 0L, g %between% c(-1L, 1L), i >= 0L))
  exp_eq(and3s(nwe <= 1L, x %between% c(-1L, 1L), p >= 1L),
         band3(nwe <= 1L, x %between% c(-1L, 1L), p >= 1L))
  exp_eq(and3s(nwf <= 9L, u %between% c(-1L, 1L), s >= 9L),
         band3(nwf <= 9L, u %between% c(-1L, 1L), s >= 9L))
  exp_eq(and3s(nwg <= 0L, , ),
         band3(nwg <= 0L, , ))
  exp_eq(and3s(nwh <= 1L, , ),
         band3(nwh <= 1L, , ))
  exp_eq(and3s(nwi <= 9L, , ),
         band3(nwi <= 9L, , ))
  exp_eq(and3s(nwj <= 0L, , logi_n),
         band3(nwj <= 0L, , logi_n))
  exp_eq(and3s(nwk <= 1L, , logi_u),
         band3(nwk <= 1L, , logi_u))
  exp_eq(and3s(nwl <= 9L, , logi_t),
         band3(nwl <= 9L, , logi_t))
  exp_eq(and3s(nwm <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nwm <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nwn <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nwn <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nwo <= 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nwo <= 9L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nwp <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L), logi_z),
         band3(nwp <= 0L, e %in% c(4L, -3L, 2L, 7L, 8L), logi_z))
  exp_eq(and3s(nwq <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), logi_k),
         band3(nwq <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), logi_k))
  exp_eq(and3s(nwr <= 9L, n %in% c(4L, -3L, 2L, 7L, 8L), logi_r),
         band3(nwr <= 9L, n %in% c(4L, -3L, 2L, 7L, 8L), logi_r))
  exp_eq(and3s(nws <= 0L, , ),
         band3(nws <= 0L, , ))
  exp_eq(and3s(nwt <= 1L, , ),
         band3(nwt <= 1L, , ))
  exp_eq(and3s(nwu <= 9L, , ),
         band3(nwu <= 9L, , ))
  exp_eq(and3s(nwv <= 0L, , logi_j),
         band3(nwv <= 0L, , logi_j))
  exp_eq(and3s(nww <= 1L, , logi_j),
         band3(nww <= 1L, , logi_j))
  exp_eq(and3s(nwx <= 9L, , logi_i),
         band3(nwx <= 9L, , logi_i))
  exp_eq(and3s(nwy <= 0L, b %in% 1:4, ),
         band3(nwy <= 0L, b %in% 1:4, ))
  exp_eq(and3s(nwz <= 1L, x %in% 1:4, ),
         band3(nwz <= 1L, x %in% 1:4, ))
  exp_eq(and3s(nxa <= 9L, l %in% 1:4, ),
         band3(nxa <= 9L, l %in% 1:4, ))
  exp_eq(and3s(nxb <= 0L, w %in% 1:4, logi_i),
         band3(nxb <= 0L, w %in% 1:4, logi_i))
  exp_eq(and3s(nxc <= 1L, x %in% 1:4, logi_b),
         band3(nxc <= 1L, x %in% 1:4, logi_b))
  exp_eq(and3s(nxd <= 9L, h %in% 1:4, logi_e),
         band3(nxd <= 9L, h %in% 1:4, logi_e))
  exp_eq(and3s(nxe <= 0L, , ),
         band3(nxe <= 0L, , ))
  exp_eq(and3s(nxf <= 1L, , ),
         band3(nxf <= 1L, , ))
  exp_eq(and3s(nxg <= 9L, , ),
         band3(nxg <= 9L, , ))
  exp_eq(and3s(nxh <= 0L, , !logi_l),
         band3(nxh <= 0L, , !logi_l))
  exp_eq(and3s(nxi <= 1L, , !logi_k),
         band3(nxi <= 1L, , !logi_k))
  exp_eq(and3s(nxj <= 9L, , !logi_y),
         band3(nxj <= 9L, , !logi_y))
  exp_eq(and3s(nxk <= 0L, i %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nxk <= 0L, i %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nxl <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nxl <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nxm <= 9L, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nxm <= 9L, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nxn <= 0L, d %in% c(4L, -3L, 2L, 7L, 8L), !logi_h),
         band3(nxn <= 0L, d %in% c(4L, -3L, 2L, 7L, 8L), !logi_h))
  exp_eq(and3s(nxo <= 1L, y %in% c(4L, -3L, 2L, 7L, 8L), !logi_f),
         band3(nxo <= 1L, y %in% c(4L, -3L, 2L, 7L, 8L), !logi_f))
  exp_eq(and3s(nxp <= 9L, p %in% c(4L, -3L, 2L, 7L, 8L), !logi_n),
         band3(nxp <= 9L, p %in% c(4L, -3L, 2L, 7L, 8L), !logi_n))
  exp_eq(and3s(nxq <= 0L, , ),
         band3(nxq <= 0L, , ))
  exp_eq(and3s(nxr <= 1L, , ),
         band3(nxr <= 1L, , ))
  exp_eq(and3s(nxs <= 9L, , ),
         band3(nxs <= 9L, , ))
  exp_eq(and3s(nxt <= 0L, , !logi_x),
         band3(nxt <= 0L, , !logi_x))
  exp_eq(and3s(nxu <= 1L, , !logi_d),
         band3(nxu <= 1L, , !logi_d))
  exp_eq(and3s(nxv <= 9L, , !logi_s),
         band3(nxv <= 9L, , !logi_s))
  exp_eq(and3s(nxw <= 0L, t %in% 1:4, ),
         band3(nxw <= 0L, t %in% 1:4, ))
  exp_eq(and3s(nxx <= 1L, e %in% 1:4, ),
         band3(nxx <= 1L, e %in% 1:4, ))
  exp_eq(and3s(nxy <= 9L, s %in% 1:4, ),
         band3(nxy <= 9L, s %in% 1:4, ))
  exp_eq(and3s(nxz <= 0L, i %in% 1:4, !logi_e),
         band3(nxz <= 0L, i %in% 1:4, !logi_e))
  exp_eq(and3s(nya <= 1L, e %in% 1:4, !logi_n),
         band3(nya <= 1L, e %in% 1:4, !logi_n))
  exp_eq(and3s(nyb <= 9L, z %in% 1:4, !logi_q),
         band3(nyb <= 9L, z %in% 1:4, !logi_q))
  exp_eq(and3s(nyc <= 0L, , ),
         band3(nyc <= 0L, , ))
  exp_eq(and3s(nyd <= 1L, , ),
         band3(nyd <= 1L, , ))
  exp_eq(and3s(nye <= 9L, , ),
         band3(nye <= 9L, , ))
  exp_eq(and3s(nyf <= 0L, , y != 0L),
         band3(nyf <= 0L, , y != 0L))
  exp_eq(and3s(nyg <= 1L, , m != 1L),
         band3(nyg <= 1L, , m != 1L))
  exp_eq(and3s(nyh <= 9L, , v != 9L),
         band3(nyh <= 9L, , v != 9L))
  exp_eq(and3s(nyi <= 0L, f %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nyi <= 0L, f %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nyj <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nyj <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nyk <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(nyk <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(nyl <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), n != 0L),
         band3(nyl <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), n != 0L))
  exp_eq(and3s(nym <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), u != 1L),
         band3(nym <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), u != 1L))
  exp_eq(and3s(nyn <= 9L, x %in% c(4L, -3L, 2L, 7L, 8L), o != 9L),
         band3(nyn <= 9L, x %in% c(4L, -3L, 2L, 7L, 8L), o != 9L))
  exp_eq(and3s(nyo <= 0L, , ),
         band3(nyo <= 0L, , ))
  exp_eq(and3s(nyp <= 1L, , ),
         band3(nyp <= 1L, , ))
  exp_eq(and3s(nyq <= 9L, , ),
         band3(nyq <= 9L, , ))
  exp_eq(and3s(nyr <= 0L, , w != 0L),
         band3(nyr <= 0L, , w != 0L))
  exp_eq(and3s(nys <= 1L, , b != 1L),
         band3(nys <= 1L, , b != 1L))
  exp_eq(and3s(nyt <= 9L, , g != 9L),
         band3(nyt <= 9L, , g != 9L))
  exp_eq(and3s(nyu <= 0L, f %in% 1:4, ),
         band3(nyu <= 0L, f %in% 1:4, ))
  exp_eq(and3s(nyv <= 1L, r %in% 1:4, ),
         band3(nyv <= 1L, r %in% 1:4, ))
  exp_eq(and3s(nyw <= 9L, e %in% 1:4, ),
         band3(nyw <= 9L, e %in% 1:4, ))
  exp_eq(and3s(nyx <= 0L, b %in% 1:4, i != 0L),
         band3(nyx <= 0L, b %in% 1:4, i != 0L))
  exp_eq(and3s(nyy <= 1L, a %in% 1:4, y != 1L),
         band3(nyy <= 1L, a %in% 1:4, y != 1L))
  exp_eq(and3s(nyz <= 9L, f %in% 1:4, q != 9L),
         band3(nyz <= 9L, f %in% 1:4, q != 9L))
  exp_eq(and3s(oa <= 0L, , ),
         band3(oa <= 0L, , ))
  exp_eq(and3s(ob <= 1L, , ),
         band3(ob <= 1L, , ))
  exp_eq(and3s(oc <= 9L, , ),
         band3(oc <= 9L, , ))
  exp_eq(and3s(od <= 0L, , f %between% c(-1L, 1L)),
         band3(od <= 0L, , f %between% c(-1L, 1L)))
  exp_eq(and3s(oe <= 1L, , l %between% c(-1L, 1L)),
         band3(oe <= 1L, , l %between% c(-1L, 1L)))
  exp_eq(and3s(of <= 9L, , x %between% c(-1L, 1L)),
         band3(of <= 9L, , x %between% c(-1L, 1L)))
  exp_eq(and3s(og <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(og <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oh <= 1L, s %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oh <= 1L, s %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oi <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oi <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oj <= 0L, d %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L)),
         band3(oj <= 0L, d %in% c(4L, -3L, 2L, 7L, 8L), t %between% c(-1L, 1L)))
  exp_eq(and3s(ok <= 1L, o %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L)),
         band3(ok <= 1L, o %in% c(4L, -3L, 2L, 7L, 8L), y %between% c(-1L, 1L)))
  exp_eq(and3s(ol <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L)),
         band3(ol <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), l %between% c(-1L, 1L)))
  exp_eq(and3s(om <= 0L, , ),
         band3(om <= 0L, , ))
  exp_eq(and3s(on <= 1L, , ),
         band3(on <= 1L, , ))
  exp_eq(and3s(oo <= 9L, , ),
         band3(oo <= 9L, , ))
  exp_eq(and3s(op <= 0L, , u %between% c(-1L, 1L)),
         band3(op <= 0L, , u %between% c(-1L, 1L)))
  exp_eq(and3s(oq <= 1L, , c %between% c(-1L, 1L)),
         band3(oq <= 1L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(or <= 9L, , f %between% c(-1L, 1L)),
         band3(or <= 9L, , f %between% c(-1L, 1L)))
  exp_eq(and3s(os <= 0L, i %in% 1:4, ),
         band3(os <= 0L, i %in% 1:4, ))
  exp_eq(and3s(ot <= 1L, e %in% 1:4, ),
         band3(ot <= 1L, e %in% 1:4, ))
  exp_eq(and3s(ou <= 9L, u %in% 1:4, ),
         band3(ou <= 9L, u %in% 1:4, ))
  exp_eq(and3s(ov <= 0L, k %in% 1:4, p %between% c(-1L, 1L)),
         band3(ov <= 0L, k %in% 1:4, p %between% c(-1L, 1L)))
  exp_eq(and3s(ow <= 1L, x %in% 1:4, s %between% c(-1L, 1L)),
         band3(ow <= 1L, x %in% 1:4, s %between% c(-1L, 1L)))
  exp_eq(and3s(ox <= 9L, k %in% 1:4, m %between% c(-1L, 1L)),
         band3(ox <= 9L, k %in% 1:4, m %between% c(-1L, 1L)))
  exp_eq(and3s(oy <= 0L, , ),
         band3(oy <= 0L, , ))
  exp_eq(and3s(oz <= 1L, , ),
         band3(oz <= 1L, , ))
  exp_eq(and3s(oaa <= 9L, , ),
         band3(oaa <= 9L, , ))
  exp_eq(and3s(oab <= 0L, , n %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oab <= 0L, , n %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oac <= 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oac <= 1L, , c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oad <= 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oad <= 9L, , b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oae <= 0L, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oae <= 0L, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oaf <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oaf <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oag <= 9L, k %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oag <= 9L, k %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oah <= 0L, s %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oah <= 0L, s %in% c(4L, -3L, 2L, 7L, 8L), r %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oai <= 1L, c %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oai <= 1L, c %in% c(4L, -3L, 2L, 7L, 8L), u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oaj <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oaj <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oak <= 0L, , ),
         band3(oak <= 0L, , ))
  exp_eq(and3s(oal <= 1L, , ),
         band3(oal <= 1L, , ))
  exp_eq(and3s(oam <= 9L, , ),
         band3(oam <= 9L, , ))
  exp_eq(and3s(oan <= 0L, , z %in% 1:4),
         band3(oan <= 0L, , z %in% 1:4))
  exp_eq(and3s(oao <= 1L, , b %in% 1:4),
         band3(oao <= 1L, , b %in% 1:4))
  exp_eq(and3s(oap <= 9L, , a %in% 1:4),
         band3(oap <= 9L, , a %in% 1:4))
  exp_eq(and3s(oaq <= 0L, f %in% 1:4, ),
         band3(oaq <= 0L, f %in% 1:4, ))
  exp_eq(and3s(oar <= 1L, b %in% 1:4, ),
         band3(oar <= 1L, b %in% 1:4, ))
  exp_eq(and3s(oas <= 9L, c %in% 1:4, ),
         band3(oas <= 9L, c %in% 1:4, ))
  exp_eq(and3s(oat <= 0L, e %in% 1:4, t %in% 1:4),
         band3(oat <= 0L, e %in% 1:4, t %in% 1:4))
  exp_eq(and3s(oau <= 1L, g %in% 1:4, x %in% 1:4),
         band3(oau <= 1L, g %in% 1:4, x %in% 1:4))
  exp_eq(and3s(oav <= 9L, t %in% 1:4, h %in% 1:4),
         band3(oav <= 9L, t %in% 1:4, h %in% 1:4))
  exp_eq(and3s(oaw <= 0L, , ),
         band3(oaw <= 0L, , ))
  exp_eq(and3s(oax <= 1L, , ),
         band3(oax <= 1L, , ))
  exp_eq(and3s(oay <= 9L, , ),
         band3(oay <= 9L, , ))
  exp_eq(and3s(oaz <= 0L, , d < 0L),
         band3(oaz <= 0L, , d < 0L))
  exp_eq(and3s(oba <= 1L, , k < 1L),
         band3(oba <= 1L, , k < 1L))
  exp_eq(and3s(obb <= 9L, , q < 9L),
         band3(obb <= 9L, , q < 9L))
  exp_eq(and3s(obc <= 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(obc <= 0L, l %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(obd <= 1L, b %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(obd <= 1L, b %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(obe <= 9L, c %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(obe <= 9L, c %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(obf <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), n < 0L),
         band3(obf <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), n < 0L))
  exp_eq(and3s(obg <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), c < 1L),
         band3(obg <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), c < 1L))
  exp_eq(and3s(obh <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), e < 9L),
         band3(obh <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), e < 9L))
  exp_eq(and3s(obi <= 0L, , ),
         band3(obi <= 0L, , ))
  exp_eq(and3s(obj <= 1L, , ),
         band3(obj <= 1L, , ))
  exp_eq(and3s(obk <= 9L, , ),
         band3(obk <= 9L, , ))
  exp_eq(and3s(obl <= 0L, , f < 0L),
         band3(obl <= 0L, , f < 0L))
  exp_eq(and3s(obm <= 1L, , x < 1L),
         band3(obm <= 1L, , x < 1L))
  exp_eq(and3s(obn <= 9L, , y < 9L),
         band3(obn <= 9L, , y < 9L))
  exp_eq(and3s(obo <= 0L, l %in% 1:4, ),
         band3(obo <= 0L, l %in% 1:4, ))
  exp_eq(and3s(obp <= 1L, n %in% 1:4, ),
         band3(obp <= 1L, n %in% 1:4, ))
  exp_eq(and3s(obq <= 9L, j %in% 1:4, ),
         band3(obq <= 9L, j %in% 1:4, ))
  exp_eq(and3s(obr <= 0L, e %in% 1:4, c < 0L),
         band3(obr <= 0L, e %in% 1:4, c < 0L))
  exp_eq(and3s(obs <= 1L, f %in% 1:4, o < 1L),
         band3(obs <= 1L, f %in% 1:4, o < 1L))
  exp_eq(and3s(obt <= 9L, u %in% 1:4, o < 9L),
         band3(obt <= 9L, u %in% 1:4, o < 9L))
  exp_eq(and3s(obu <= 0L, , ),
         band3(obu <= 0L, , ))
  exp_eq(and3s(obv <= 1L, , ),
         band3(obv <= 1L, , ))
  exp_eq(and3s(obw <= 9L, , ),
         band3(obw <= 9L, , ))
  exp_eq(and3s(obx <= 0L, , b <= 0L),
         band3(obx <= 0L, , b <= 0L))
  exp_eq(and3s(oby <= 1L, , f <= 1L),
         band3(oby <= 1L, , f <= 1L))
  exp_eq(and3s(obz <= 9L, , f <= 9L),
         band3(obz <= 9L, , f <= 9L))
  exp_eq(and3s(oca <= 0L, y %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oca <= 0L, y %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ocb <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ocb <= 1L, d %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(occ <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(occ <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ocd <= 0L, u %in% c(4L, -3L, 2L, 7L, 8L), p <= 0L),
         band3(ocd <= 0L, u %in% c(4L, -3L, 2L, 7L, 8L), p <= 0L))
  exp_eq(and3s(oce <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), y <= 1L),
         band3(oce <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), y <= 1L))
  exp_eq(and3s(ocf <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L),
         band3(ocf <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), w <= 9L))
  exp_eq(and3s(ocg <= 0L, , ),
         band3(ocg <= 0L, , ))
  exp_eq(and3s(och <= 1L, , ),
         band3(och <= 1L, , ))
  exp_eq(and3s(oci <= 9L, , ),
         band3(oci <= 9L, , ))
  exp_eq(and3s(ocj <= 0L, , y <= 0L),
         band3(ocj <= 0L, , y <= 0L))
  exp_eq(and3s(ock <= 1L, , d <= 1L),
         band3(ock <= 1L, , d <= 1L))
  exp_eq(and3s(ocl <= 9L, , d <= 9L),
         band3(ocl <= 9L, , d <= 9L))
  exp_eq(and3s(ocm <= 0L, c %in% 1:4, ),
         band3(ocm <= 0L, c %in% 1:4, ))
  exp_eq(and3s(ocn <= 1L, a %in% 1:4, ),
         band3(ocn <= 1L, a %in% 1:4, ))
  exp_eq(and3s(oco <= 9L, r %in% 1:4, ),
         band3(oco <= 9L, r %in% 1:4, ))
  exp_eq(and3s(ocp <= 0L, p %in% 1:4, i <= 0L),
         band3(ocp <= 0L, p %in% 1:4, i <= 0L))
  exp_eq(and3s(ocq <= 1L, t %in% 1:4, u <= 1L),
         band3(ocq <= 1L, t %in% 1:4, u <= 1L))
  exp_eq(and3s(ocr <= 9L, k %in% 1:4, t <= 9L),
         band3(ocr <= 9L, k %in% 1:4, t <= 9L))
  exp_eq(and3s(ocs <= 0L, , ),
         band3(ocs <= 0L, , ))
  exp_eq(and3s(oct <= 1L, , ),
         band3(oct <= 1L, , ))
  exp_eq(and3s(ocu <= 9L, , ),
         band3(ocu <= 9L, , ))
  exp_eq(and3s(ocv <= 0L, , u == 0L),
         band3(ocv <= 0L, , u == 0L))
  exp_eq(and3s(ocw <= 1L, , d == 1L),
         band3(ocw <= 1L, , d == 1L))
  exp_eq(and3s(ocx <= 9L, , l == 9L),
         band3(ocx <= 9L, , l == 9L))
  exp_eq(and3s(ocy <= 0L, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ocy <= 0L, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ocz <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ocz <= 1L, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oda <= 9L, q %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oda <= 9L, q %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(odb <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), q == 0L),
         band3(odb <= 0L, c %in% c(4L, -3L, 2L, 7L, 8L), q == 0L))
  exp_eq(and3s(odc <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), p == 1L),
         band3(odc <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), p == 1L))
  exp_eq(and3s(odd <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), t == 9L),
         band3(odd <= 9L, e %in% c(4L, -3L, 2L, 7L, 8L), t == 9L))
  exp_eq(and3s(ode <= 0L, , ),
         band3(ode <= 0L, , ))
  exp_eq(and3s(odf <= 1L, , ),
         band3(odf <= 1L, , ))
  exp_eq(and3s(odg <= 9L, , ),
         band3(odg <= 9L, , ))
  exp_eq(and3s(odh <= 0L, , c == 0L),
         band3(odh <= 0L, , c == 0L))
  exp_eq(and3s(odi <= 1L, , o == 1L),
         band3(odi <= 1L, , o == 1L))
  exp_eq(and3s(odj <= 9L, , z == 9L),
         band3(odj <= 9L, , z == 9L))
  exp_eq(and3s(odk <= 0L, n %in% 1:4, ),
         band3(odk <= 0L, n %in% 1:4, ))
  exp_eq(and3s(odl <= 1L, j %in% 1:4, ),
         band3(odl <= 1L, j %in% 1:4, ))
  exp_eq(and3s(odm <= 9L, j %in% 1:4, ),
         band3(odm <= 9L, j %in% 1:4, ))
  exp_eq(and3s(odn <= 0L, e %in% 1:4, c == 0L),
         band3(odn <= 0L, e %in% 1:4, c == 0L))
  exp_eq(and3s(odo <= 1L, b %in% 1:4, h == 1L),
         band3(odo <= 1L, b %in% 1:4, h == 1L))
  exp_eq(and3s(odp <= 9L, i %in% 1:4, s == 9L),
         band3(odp <= 9L, i %in% 1:4, s == 9L))
  exp_eq(and3s(odq <= 0L, , ),
         band3(odq <= 0L, , ))
  exp_eq(and3s(odr <= 1L, , ),
         band3(odr <= 1L, , ))
  exp_eq(and3s(ods <= 9L, , ),
         band3(ods <= 9L, , ))
  exp_eq(and3s(odt <= 0L, , w > 0L),
         band3(odt <= 0L, , w > 0L))
  exp_eq(and3s(odu <= 1L, , p > 1L),
         band3(odu <= 1L, , p > 1L))
  exp_eq(and3s(odv <= 9L, , c > 9L),
         band3(odv <= 9L, , c > 9L))
  exp_eq(and3s(odw <= 0L, w %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(odw <= 0L, w %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(odx <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(odx <= 1L, t %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(ody <= 9L, j %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(ody <= 9L, j %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(odz <= 0L, t %in% c(4L, -3L, 2L, 7L, 8L), v > 0L),
         band3(odz <= 0L, t %in% c(4L, -3L, 2L, 7L, 8L), v > 0L))
  exp_eq(and3s(oea <= 1L, r %in% c(4L, -3L, 2L, 7L, 8L), c > 1L),
         band3(oea <= 1L, r %in% c(4L, -3L, 2L, 7L, 8L), c > 1L))
  exp_eq(and3s(oeb <= 9L, u %in% c(4L, -3L, 2L, 7L, 8L), y > 9L),
         band3(oeb <= 9L, u %in% c(4L, -3L, 2L, 7L, 8L), y > 9L))
  exp_eq(and3s(oec <= 0L, , ),
         band3(oec <= 0L, , ))
  exp_eq(and3s(oed <= 1L, , ),
         band3(oed <= 1L, , ))
  exp_eq(and3s(oee <= 9L, , ),
         band3(oee <= 9L, , ))
  exp_eq(and3s(oef <= 0L, , o > 0L),
         band3(oef <= 0L, , o > 0L))
  exp_eq(and3s(oeg <= 1L, , t > 1L),
         band3(oeg <= 1L, , t > 1L))
  exp_eq(and3s(oeh <= 9L, , r > 9L),
         band3(oeh <= 9L, , r > 9L))
  exp_eq(and3s(oei <= 0L, q %in% 1:4, ),
         band3(oei <= 0L, q %in% 1:4, ))
  exp_eq(and3s(oej <= 1L, s %in% 1:4, ),
         band3(oej <= 1L, s %in% 1:4, ))
  exp_eq(and3s(oek <= 9L, v %in% 1:4, ),
         band3(oek <= 9L, v %in% 1:4, ))
  exp_eq(and3s(oel <= 0L, w %in% 1:4, m > 0L),
         band3(oel <= 0L, w %in% 1:4, m > 0L))
  exp_eq(and3s(oem <= 1L, f %in% 1:4, p > 1L),
         band3(oem <= 1L, f %in% 1:4, p > 1L))
  exp_eq(and3s(oen <= 9L, g %in% 1:4, x > 9L),
         band3(oen <= 9L, g %in% 1:4, x > 9L))
  exp_eq(and3s(oeo <= 0L, , ),
         band3(oeo <= 0L, , ))
  exp_eq(and3s(oep <= 1L, , ),
         band3(oep <= 1L, , ))
  exp_eq(and3s(oeq <= 9L, , ),
         band3(oeq <= 9L, , ))
  exp_eq(and3s(oer <= 0L, , s >= 0L),
         band3(oer <= 0L, , s >= 0L))
  exp_eq(and3s(oes <= 1L, , u >= 1L),
         band3(oes <= 1L, , u >= 1L))
  exp_eq(and3s(oet <= 9L, , c >= 9L),
         band3(oet <= 9L, , c >= 9L))
  exp_eq(and3s(oeu <= 0L, n %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oeu <= 0L, n %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oev <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oev <= 1L, g %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oew <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ),
         band3(oew <= 9L, o %in% c(4L, -3L, 2L, 7L, 8L), ))
  exp_eq(and3s(oex <= 0L, z %in% c(4L, -3L, 2L, 7L, 8L), o >= 0L),
         band3(oex <= 0L, z %in% c(4L, -3L, 2L, 7L, 8L), o >= 0L))
  exp_eq(and3s(oey <= 1L, x %in% c(4L, -3L, 2L, 7L, 8L), z >= 1L),
         band3(oey <= 1L, x %in% c(4L, -3L, 2L, 7L, 8L), z >= 1L))
  exp_eq(and3s(oez <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L),
         band3(oez <= 9L, a %in% c(4L, -3L, 2L, 7L, 8L), x >= 9L))
  exp_eq(and3s(ofa <= 0L, , ),
         band3(ofa <= 0L, , ))
  exp_eq(and3s(ofb <= 1L, , ),
         band3(ofb <= 1L, , ))
  exp_eq(and3s(ofc <= 9L, , ),
         band3(ofc <= 9L, , ))
  exp_eq(and3s(ofd <= 0L, , n >= 0L),
         band3(ofd <= 0L, , n >= 0L))
  exp_eq(and3s(ofe <= 1L, , h >= 1L),
         band3(ofe <= 1L, , h >= 1L))
  exp_eq(and3s(off <= 9L, , m >= 9L),
         band3(off <= 9L, , m >= 9L))
  exp_eq(and3s(ofg <= 0L, f %in% 1:4, ),
         band3(ofg <= 0L, f %in% 1:4, ))
  exp_eq(and3s(ofh <= 1L, b %in% 1:4, ),
         band3(ofh <= 1L, b %in% 1:4, ))
  exp_eq(and3s(ofi <= 9L, a %in% 1:4, ),
         band3(ofi <= 9L, a %in% 1:4, ))
  exp_eq(and3s(ofj <= 0L, p %in% 1:4, z >= 0L),
         band3(ofj <= 0L, p %in% 1:4, z >= 0L))
  exp_eq(and3s(ofk <= 1L, g %in% 1:4, x >= 1L),
         band3(ofk <= 1L, g %in% 1:4, x >= 1L))
  exp_eq(and3s(ofl <= 9L, x %in% 1:4, n >= 9L),
         band3(ofl <= 9L, x %in% 1:4, n >= 9L))
  exp_eq(and3s(ofm <= 0L, , ),
         band3(ofm <= 0L, , ))
  exp_eq(and3s(ofn <= 1L, , ),
         band3(ofn <= 1L, , ))
  exp_eq(and3s(ofo <= 9L, , ),
         band3(ofo <= 9L, , ))
  exp_eq(and3s(ofp <= 0L, , logi_x),
         band3(ofp <= 0L, , logi_x))
  exp_eq(and3s(ofq <= 1L, , logi_b),
         band3(ofq <= 1L, , logi_b))
  exp_eq(and3s(ofr <= 9L, , logi_f),
         band3(ofr <= 9L, , logi_f))
  exp_eq(and3s(ofs <= 0L, d < 0L, ),
         band3(ofs <= 0L, d < 0L, ))
  exp_eq(and3s(oft <= 1L, g < 1L, ),
         band3(oft <= 1L, g < 1L, ))
  exp_eq(and3s(ofu <= 9L, w < 9L, ),
         band3(ofu <= 9L, w < 9L, ))
  exp_eq(and3s(ofv <= 0L, a < 0L, logi_v),
         band3(ofv <= 0L, a < 0L, logi_v))
  exp_eq(and3s(ofw <= 1L, a < 1L, logi_j),
         band3(ofw <= 1L, a < 1L, logi_j))
  exp_eq(and3s(ofx <= 9L, j < 9L, logi_c),
         band3(ofx <= 9L, j < 9L, logi_c))
  exp_eq(and3s(ofy <= 0L, , ),
         band3(ofy <= 0L, , ))
  exp_eq(and3s(ofz <= 1L, , ),
         band3(ofz <= 1L, , ))
  exp_eq(and3s(oga <= 9L, , ),
         band3(oga <= 9L, , ))
  exp_eq(and3s(ogb <= 0L, , !logi_n),
         band3(ogb <= 0L, , !logi_n))
  exp_eq(and3s(ogc <= 1L, , !logi_i),
         band3(ogc <= 1L, , !logi_i))
  exp_eq(and3s(ogd <= 9L, , !logi_v),
         band3(ogd <= 9L, , !logi_v))
  exp_eq(and3s(oge <= 0L, t < 0L, ),
         band3(oge <= 0L, t < 0L, ))
  exp_eq(and3s(ogf <= 1L, j < 1L, ),
         band3(ogf <= 1L, j < 1L, ))
  exp_eq(and3s(ogg <= 9L, z < 9L, ),
         band3(ogg <= 9L, z < 9L, ))
  exp_eq(and3s(ogh <= 0L, b < 0L, !logi_r),
         band3(ogh <= 0L, b < 0L, !logi_r))
  exp_eq(and3s(ogi <= 1L, m < 1L, !logi_l),
         band3(ogi <= 1L, m < 1L, !logi_l))
  exp_eq(and3s(ogj <= 9L, n < 9L, !logi_s),
         band3(ogj <= 9L, n < 9L, !logi_s))
  exp_eq(and3s(ogk <= 0L, , ),
         band3(ogk <= 0L, , ))
  exp_eq(and3s(ogl <= 1L, , ),
         band3(ogl <= 1L, , ))
  exp_eq(and3s(ogm <= 9L, , ),
         band3(ogm <= 9L, , ))
  exp_eq(and3s(ogn <= 0L, , w != 0L),
         band3(ogn <= 0L, , w != 0L))
  exp_eq(and3s(ogo <= 1L, , c != 1L),
         band3(ogo <= 1L, , c != 1L))
  exp_eq(and3s(ogp <= 9L, , c != 9L),
         band3(ogp <= 9L, , c != 9L))
  exp_eq(and3s(ogq <= 0L, k < 0L, ),
         band3(ogq <= 0L, k < 0L, ))
  exp_eq(and3s(ogr <= 1L, m < 1L, ),
         band3(ogr <= 1L, m < 1L, ))
  exp_eq(and3s(ogs <= 9L, a < 9L, ),
         band3(ogs <= 9L, a < 9L, ))
  exp_eq(and3s(ogt <= 0L, o < 0L, y != 0L),
         band3(ogt <= 0L, o < 0L, y != 0L))
  exp_eq(and3s(ogu <= 1L, a < 1L, u != 1L),
         band3(ogu <= 1L, a < 1L, u != 1L))
  exp_eq(and3s(ogv <= 9L, j < 9L, d != 9L),
         band3(ogv <= 9L, j < 9L, d != 9L))
  exp_eq(and3s(ogw <= 0L, , ),
         band3(ogw <= 0L, , ))
  exp_eq(and3s(ogx <= 1L, , ),
         band3(ogx <= 1L, , ))
  exp_eq(and3s(ogy <= 9L, , ),
         band3(ogy <= 9L, , ))
  exp_eq(and3s(ogz <= 0L, , d %between% c(-1L, 1L)),
         band3(ogz <= 0L, , d %between% c(-1L, 1L)))
  exp_eq(and3s(oha <= 1L, , h %between% c(-1L, 1L)),
         band3(oha <= 1L, , h %between% c(-1L, 1L)))
  exp_eq(and3s(ohb <= 9L, , o %between% c(-1L, 1L)),
         band3(ohb <= 9L, , o %between% c(-1L, 1L)))
  exp_eq(and3s(ohc <= 0L, w < 0L, ),
         band3(ohc <= 0L, w < 0L, ))
  exp_eq(and3s(ohd <= 1L, a < 1L, ),
         band3(ohd <= 1L, a < 1L, ))
  exp_eq(and3s(ohe <= 9L, l < 9L, ),
         band3(ohe <= 9L, l < 9L, ))
  exp_eq(and3s(ohf <= 0L, z < 0L, k %between% c(-1L, 1L)),
         band3(ohf <= 0L, z < 0L, k %between% c(-1L, 1L)))
  exp_eq(and3s(ohg <= 1L, l < 1L, a %between% c(-1L, 1L)),
         band3(ohg <= 1L, l < 1L, a %between% c(-1L, 1L)))
  exp_eq(and3s(ohh <= 9L, f < 9L, m %between% c(-1L, 1L)),
         band3(ohh <= 9L, f < 9L, m %between% c(-1L, 1L)))
  exp_eq(and3s(ohi <= 0L, , ),
         band3(ohi <= 0L, , ))
  exp_eq(and3s(ohj <= 1L, , ),
         band3(ohj <= 1L, , ))
  exp_eq(and3s(ohk <= 9L, , ),
         band3(ohk <= 9L, , ))
  exp_eq(and3s(ohl <= 0L, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ohl <= 0L, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ohm <= 1L, , q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ohm <= 1L, , q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ohn <= 9L, , e %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ohn <= 9L, , e %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oho <= 0L, a < 0L, ),
         band3(oho <= 0L, a < 0L, ))
  exp_eq(and3s(ohp <= 1L, g < 1L, ),
         band3(ohp <= 1L, g < 1L, ))
  exp_eq(and3s(ohq <= 9L, d < 9L, ),
         band3(ohq <= 9L, d < 9L, ))
  exp_eq(and3s(ohr <= 0L, k < 0L, v %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ohr <= 0L, k < 0L, v %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ohs <= 1L, s < 1L, s %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ohs <= 1L, s < 1L, s %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oht <= 9L, c < 9L, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(oht <= 9L, c < 9L, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ohu <= 0L, , ),
         band3(ohu <= 0L, , ))
  exp_eq(and3s(ohv <= 1L, , ),
         band3(ohv <= 1L, , ))
  exp_eq(and3s(ohw <= 9L, , ),
         band3(ohw <= 9L, , ))
  exp_eq(and3s(ohx <= 0L, , d %in% 1:4),
         band3(ohx <= 0L, , d %in% 1:4))
  exp_eq(and3s(ohy <= 1L, , c %in% 1:4),
         band3(ohy <= 1L, , c %in% 1:4))
  exp_eq(and3s(ohz <= 9L, , q %in% 1:4),
         band3(ohz <= 9L, , q %in% 1:4))
  exp_eq(and3s(oia <= 0L, y < 0L, ),
         band3(oia <= 0L, y < 0L, ))
  exp_eq(and3s(oib <= 1L, s < 1L, ),
         band3(oib <= 1L, s < 1L, ))
  exp_eq(and3s(oic <= 9L, p < 9L, ),
         band3(oic <= 9L, p < 9L, ))
  exp_eq(and3s(oid <= 0L, t < 0L, o %in% 1:4),
         band3(oid <= 0L, t < 0L, o %in% 1:4))
  exp_eq(and3s(oie <= 1L, m < 1L, f %in% 1:4),
         band3(oie <= 1L, m < 1L, f %in% 1:4))
  exp_eq(and3s(oif <= 9L, a < 9L, r %in% 1:4),
         band3(oif <= 9L, a < 9L, r %in% 1:4))
  exp_eq(and3s(oig <= 0L, , ),
         band3(oig <= 0L, , ))
  exp_eq(and3s(oih <= 1L, , ),
         band3(oih <= 1L, , ))
  exp_eq(and3s(oii <= 9L, , ),
         band3(oii <= 9L, , ))
  exp_eq(and3s(oij <= 0L, , c < 0L),
         band3(oij <= 0L, , c < 0L))
  exp_eq(and3s(oik <= 1L, , i < 1L),
         band3(oik <= 1L, , i < 1L))
  exp_eq(and3s(oil <= 9L, , f < 9L),
         band3(oil <= 9L, , f < 9L))
  exp_eq(and3s(oim <= 0L, h < 0L, ),
         band3(oim <= 0L, h < 0L, ))
  exp_eq(and3s(oin <= 1L, p < 1L, ),
         band3(oin <= 1L, p < 1L, ))
  exp_eq(and3s(oio <= 9L, z < 9L, ),
         band3(oio <= 9L, z < 9L, ))
  exp_eq(and3s(oip <= 0L, s < 0L, v < 0L),
         band3(oip <= 0L, s < 0L, v < 0L))
  exp_eq(and3s(oiq <= 1L, i < 1L, b < 1L),
         band3(oiq <= 1L, i < 1L, b < 1L))
  exp_eq(and3s(oir <= 9L, g < 9L, d < 9L),
         band3(oir <= 9L, g < 9L, d < 9L))
  exp_eq(and3s(ois <= 0L, , ),
         band3(ois <= 0L, , ))
  exp_eq(and3s(oit <= 1L, , ),
         band3(oit <= 1L, , ))
  exp_eq(and3s(oiu <= 9L, , ),
         band3(oiu <= 9L, , ))
  exp_eq(and3s(oiv <= 0L, , g <= 0L),
         band3(oiv <= 0L, , g <= 0L))
  exp_eq(and3s(oiw <= 1L, , n <= 1L),
         band3(oiw <= 1L, , n <= 1L))
  exp_eq(and3s(oix <= 9L, , r <= 9L),
         band3(oix <= 9L, , r <= 9L))
  exp_eq(and3s(oiy <= 0L, l < 0L, ),
         band3(oiy <= 0L, l < 0L, ))
  exp_eq(and3s(oiz <= 1L, h < 1L, ),
         band3(oiz <= 1L, h < 1L, ))
  exp_eq(and3s(oja <= 9L, c < 9L, ),
         band3(oja <= 9L, c < 9L, ))
  exp_eq(and3s(ojb <= 0L, i < 0L, s <= 0L),
         band3(ojb <= 0L, i < 0L, s <= 0L))
  exp_eq(and3s(ojc <= 1L, o < 1L, t <= 1L),
         band3(ojc <= 1L, o < 1L, t <= 1L))
  exp_eq(and3s(ojd <= 9L, m < 9L, d <= 9L),
         band3(ojd <= 9L, m < 9L, d <= 9L))
  exp_eq(and3s(oje <= 0L, , ),
         band3(oje <= 0L, , ))
  exp_eq(and3s(ojf <= 1L, , ),
         band3(ojf <= 1L, , ))
  exp_eq(and3s(ojg <= 9L, , ),
         band3(ojg <= 9L, , ))
  exp_eq(and3s(ojh <= 0L, , r == 0L),
         band3(ojh <= 0L, , r == 0L))
  exp_eq(and3s(oji <= 1L, , z == 1L),
         band3(oji <= 1L, , z == 1L))
  exp_eq(and3s(ojj <= 9L, , m == 9L),
         band3(ojj <= 9L, , m == 9L))
  exp_eq(and3s(ojk <= 0L, u < 0L, ),
         band3(ojk <= 0L, u < 0L, ))
  exp_eq(and3s(ojl <= 1L, y < 1L, ),
         band3(ojl <= 1L, y < 1L, ))
  exp_eq(and3s(ojm <= 9L, c < 9L, ),
         band3(ojm <= 9L, c < 9L, ))
  exp_eq(and3s(ojn <= 0L, d < 0L, w == 0L),
         band3(ojn <= 0L, d < 0L, w == 0L))
  exp_eq(and3s(ojo <= 1L, h < 1L, l == 1L),
         band3(ojo <= 1L, h < 1L, l == 1L))
  exp_eq(and3s(ojp <= 9L, y < 9L, w == 9L),
         band3(ojp <= 9L, y < 9L, w == 9L))
  exp_eq(and3s(ojq <= 0L, , ),
         band3(ojq <= 0L, , ))
  exp_eq(and3s(ojr <= 1L, , ),
         band3(ojr <= 1L, , ))
  exp_eq(and3s(ojs <= 9L, , ),
         band3(ojs <= 9L, , ))
  exp_eq(and3s(ojt <= 0L, , q > 0L),
         band3(ojt <= 0L, , q > 0L))
  exp_eq(and3s(oju <= 1L, , f > 1L),
         band3(oju <= 1L, , f > 1L))
  exp_eq(and3s(ojv <= 9L, , b > 9L),
         band3(ojv <= 9L, , b > 9L))
  exp_eq(and3s(ojw <= 0L, a < 0L, ),
         band3(ojw <= 0L, a < 0L, ))
  exp_eq(and3s(ojx <= 1L, s < 1L, ),
         band3(ojx <= 1L, s < 1L, ))
  exp_eq(and3s(ojy <= 9L, a < 9L, ),
         band3(ojy <= 9L, a < 9L, ))
  exp_eq(and3s(ojz <= 0L, d < 0L, g > 0L),
         band3(ojz <= 0L, d < 0L, g > 0L))
  exp_eq(and3s(oka <= 1L, n < 1L, n > 1L),
         band3(oka <= 1L, n < 1L, n > 1L))
  exp_eq(and3s(okb <= 9L, m < 9L, o > 9L),
         band3(okb <= 9L, m < 9L, o > 9L))
  exp_eq(and3s(okc <= 0L, , ),
         band3(okc <= 0L, , ))
  exp_eq(and3s(okd <= 1L, , ),
         band3(okd <= 1L, , ))
  exp_eq(and3s(oke <= 9L, , ),
         band3(oke <= 9L, , ))
  exp_eq(and3s(okf <= 0L, , d >= 0L),
         band3(okf <= 0L, , d >= 0L))
  exp_eq(and3s(okg <= 1L, , a >= 1L),
         band3(okg <= 1L, , a >= 1L))
  exp_eq(and3s(okh <= 9L, , u >= 9L),
         band3(okh <= 9L, , u >= 9L))
  exp_eq(and3s(oki <= 0L, k < 0L, ),
         band3(oki <= 0L, k < 0L, ))
  exp_eq(and3s(okj <= 1L, t < 1L, ),
         band3(okj <= 1L, t < 1L, ))
  exp_eq(and3s(okk <= 9L, l < 9L, ),
         band3(okk <= 9L, l < 9L, ))
  exp_eq(and3s(okl <= 0L, a < 0L, a >= 0L),
         band3(okl <= 0L, a < 0L, a >= 0L))
  exp_eq(and3s(okm <= 1L, k < 1L, j >= 1L),
         band3(okm <= 1L, k < 1L, j >= 1L))
  exp_eq(and3s(okn <= 9L, l < 9L, v >= 9L),
         band3(okn <= 9L, l < 9L, v >= 9L))
  exp_eq(and3s(oko <= 0L, , ),
         band3(oko <= 0L, , ))
  exp_eq(and3s(okp <= 1L, , ),
         band3(okp <= 1L, , ))
  exp_eq(and3s(okq <= 9L, , ),
         band3(okq <= 9L, , ))
  exp_eq(and3s(okr <= 0L, , logi_p),
         band3(okr <= 0L, , logi_p))
  exp_eq(and3s(oks <= 1L, , logi_o),
         band3(oks <= 1L, , logi_o))
  exp_eq(and3s(okt <= 9L, , logi_f),
         band3(okt <= 9L, , logi_f))
  exp_eq(and3s(oku <= 0L, u <= 0L, ),
         band3(oku <= 0L, u <= 0L, ))
  exp_eq(and3s(okv <= 1L, v <= 1L, ),
         band3(okv <= 1L, v <= 1L, ))
  exp_eq(and3s(okw <= 9L, t <= 9L, ),
         band3(okw <= 9L, t <= 9L, ))
  exp_eq(and3s(okx <= 0L, s <= 0L, logi_g),
         band3(okx <= 0L, s <= 0L, logi_g))
  exp_eq(and3s(oky <= 1L, p <= 1L, logi_d),
         band3(oky <= 1L, p <= 1L, logi_d))
  exp_eq(and3s(okz <= 9L, s <= 9L, logi_g),
         band3(okz <= 9L, s <= 9L, logi_g))
  exp_eq(and3s(ola <= 0L, , ),
         band3(ola <= 0L, , ))
  exp_eq(and3s(olb <= 1L, , ),
         band3(olb <= 1L, , ))
  exp_eq(and3s(olc <= 9L, , ),
         band3(olc <= 9L, , ))
  exp_eq(and3s(old <= 0L, , !logi_d),
         band3(old <= 0L, , !logi_d))
  exp_eq(and3s(ole <= 1L, , !logi_a),
         band3(ole <= 1L, , !logi_a))
  exp_eq(and3s(olf <= 9L, , !logi_q),
         band3(olf <= 9L, , !logi_q))
  exp_eq(and3s(olg <= 0L, v <= 0L, ),
         band3(olg <= 0L, v <= 0L, ))
  exp_eq(and3s(olh <= 1L, f <= 1L, ),
         band3(olh <= 1L, f <= 1L, ))
  exp_eq(and3s(oli <= 9L, z <= 9L, ),
         band3(oli <= 9L, z <= 9L, ))
  exp_eq(and3s(olj <= 0L, u <= 0L, !logi_q),
         band3(olj <= 0L, u <= 0L, !logi_q))
  exp_eq(and3s(olk <= 1L, l <= 1L, !logi_h),
         band3(olk <= 1L, l <= 1L, !logi_h))
  exp_eq(and3s(oll <= 9L, c <= 9L, !logi_l),
         band3(oll <= 9L, c <= 9L, !logi_l))
  exp_eq(and3s(olm <= 0L, , ),
         band3(olm <= 0L, , ))
  exp_eq(and3s(oln <= 1L, , ),
         band3(oln <= 1L, , ))
  exp_eq(and3s(olo <= 9L, , ),
         band3(olo <= 9L, , ))
  exp_eq(and3s(olp <= 0L, , i != 0L),
         band3(olp <= 0L, , i != 0L))
  exp_eq(and3s(olq <= 1L, , n != 1L),
         band3(olq <= 1L, , n != 1L))
  exp_eq(and3s(olr <= 9L, , z != 9L),
         band3(olr <= 9L, , z != 9L))
  exp_eq(and3s(ols <= 0L, g <= 0L, ),
         band3(ols <= 0L, g <= 0L, ))
  exp_eq(and3s(olt <= 1L, v <= 1L, ),
         band3(olt <= 1L, v <= 1L, ))
  exp_eq(and3s(olu <= 9L, v <= 9L, ),
         band3(olu <= 9L, v <= 9L, ))
  exp_eq(and3s(olv <= 0L, m <= 0L, z != 0L),
         band3(olv <= 0L, m <= 0L, z != 0L))
  exp_eq(and3s(olw <= 1L, j <= 1L, y != 1L),
         band3(olw <= 1L, j <= 1L, y != 1L))
  exp_eq(and3s(olx <= 9L, s <= 9L, g != 9L),
         band3(olx <= 9L, s <= 9L, g != 9L))
  exp_eq(and3s(oly <= 0L, , ),
         band3(oly <= 0L, , ))
  exp_eq(and3s(olz <= 1L, , ),
         band3(olz <= 1L, , ))
  exp_eq(and3s(oma <= 9L, , ),
         band3(oma <= 9L, , ))
  exp_eq(and3s(omb <= 0L, , k %between% c(-1L, 1L)),
         band3(omb <= 0L, , k %between% c(-1L, 1L)))
  exp_eq(and3s(omc <= 1L, , a %between% c(-1L, 1L)),
         band3(omc <= 1L, , a %between% c(-1L, 1L)))
  exp_eq(and3s(omd <= 9L, , q %between% c(-1L, 1L)),
         band3(omd <= 9L, , q %between% c(-1L, 1L)))
  exp_eq(and3s(ome <= 0L, j <= 0L, ),
         band3(ome <= 0L, j <= 0L, ))
  exp_eq(and3s(omf <= 1L, s <= 1L, ),
         band3(omf <= 1L, s <= 1L, ))
  exp_eq(and3s(omg <= 9L, i <= 9L, ),
         band3(omg <= 9L, i <= 9L, ))
  exp_eq(and3s(omh <= 0L, f <= 0L, w %between% c(-1L, 1L)),
         band3(omh <= 0L, f <= 0L, w %between% c(-1L, 1L)))
  exp_eq(and3s(omi <= 1L, s <= 1L, h %between% c(-1L, 1L)),
         band3(omi <= 1L, s <= 1L, h %between% c(-1L, 1L)))
  exp_eq(and3s(omj <= 9L, o <= 9L, q %between% c(-1L, 1L)),
         band3(omj <= 9L, o <= 9L, q %between% c(-1L, 1L)))
  exp_eq(and3s(omk <= 0L, , ),
         band3(omk <= 0L, , ))
  exp_eq(and3s(oml <= 1L, , ),
         band3(oml <= 1L, , ))
  exp_eq(and3s(omm <= 9L, , ),
         band3(omm <= 9L, , ))
  exp_eq(and3s(omn <= 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omn <= 0L, , g %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omo <= 1L, , m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omo <= 1L, , m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omp <= 9L, , l %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omp <= 9L, , l %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omq <= 0L, p <= 0L, ),
         band3(omq <= 0L, p <= 0L, ))
  exp_eq(and3s(omr <= 1L, c <= 1L, ),
         band3(omr <= 1L, c <= 1L, ))
  exp_eq(and3s(oms <= 9L, n <= 9L, ),
         band3(oms <= 9L, n <= 9L, ))
  exp_eq(and3s(omt <= 0L, e <= 0L, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omt <= 0L, e <= 0L, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omu <= 1L, a <= 1L, b %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omu <= 1L, a <= 1L, b %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omv <= 9L, c <= 9L, y %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(omv <= 9L, c <= 9L, y %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(omw <= 0L, , ),
         band3(omw <= 0L, , ))
  exp_eq(and3s(omx <= 1L, , ),
         band3(omx <= 1L, , ))
  exp_eq(and3s(omy <= 9L, , ),
         band3(omy <= 9L, , ))
  exp_eq(and3s(omz <= 0L, , x %in% 1:4),
         band3(omz <= 0L, , x %in% 1:4))
  exp_eq(and3s(ona <= 1L, , e %in% 1:4),
         band3(ona <= 1L, , e %in% 1:4))
  exp_eq(and3s(onb <= 9L, , f %in% 1:4),
         band3(onb <= 9L, , f %in% 1:4))
  exp_eq(and3s(onc <= 0L, w <= 0L, ),
         band3(onc <= 0L, w <= 0L, ))
  exp_eq(and3s(ond <= 1L, i <= 1L, ),
         band3(ond <= 1L, i <= 1L, ))
  exp_eq(and3s(one <= 9L, d <= 9L, ),
         band3(one <= 9L, d <= 9L, ))
  exp_eq(and3s(onf <= 0L, k <= 0L, y %in% 1:4),
         band3(onf <= 0L, k <= 0L, y %in% 1:4))
  exp_eq(and3s(ong <= 1L, l <= 1L, p %in% 1:4),
         band3(ong <= 1L, l <= 1L, p %in% 1:4))
  exp_eq(and3s(onh <= 9L, u <= 9L, w %in% 1:4),
         band3(onh <= 9L, u <= 9L, w %in% 1:4))
  exp_eq(and3s(oni <= 0L, , ),
         band3(oni <= 0L, , ))
  exp_eq(and3s(onj <= 1L, , ),
         band3(onj <= 1L, , ))
  exp_eq(and3s(onk <= 9L, , ),
         band3(onk <= 9L, , ))
  exp_eq(and3s(onl <= 0L, , r < 0L),
         band3(onl <= 0L, , r < 0L))
  exp_eq(and3s(onm <= 1L, , m < 1L),
         band3(onm <= 1L, , m < 1L))
  exp_eq(and3s(onn <= 9L, , o < 9L),
         band3(onn <= 9L, , o < 9L))
  exp_eq(and3s(ono <= 0L, d <= 0L, ),
         band3(ono <= 0L, d <= 0L, ))
  exp_eq(and3s(onp <= 1L, x <= 1L, ),
         band3(onp <= 1L, x <= 1L, ))
  exp_eq(and3s(onq <= 9L, l <= 9L, ),
         band3(onq <= 9L, l <= 9L, ))
  exp_eq(and3s(onr <= 0L, l <= 0L, u < 0L),
         band3(onr <= 0L, l <= 0L, u < 0L))
  exp_eq(and3s(ons <= 1L, v <= 1L, s < 1L),
         band3(ons <= 1L, v <= 1L, s < 1L))
  exp_eq(and3s(ont <= 9L, v <= 9L, i < 9L),
         band3(ont <= 9L, v <= 9L, i < 9L))
  exp_eq(and3s(onu <= 0L, , ),
         band3(onu <= 0L, , ))
  exp_eq(and3s(onv <= 1L, , ),
         band3(onv <= 1L, , ))
  exp_eq(and3s(onw <= 9L, , ),
         band3(onw <= 9L, , ))
  exp_eq(and3s(onx <= 0L, , p <= 0L),
         band3(onx <= 0L, , p <= 0L))
  exp_eq(and3s(ony <= 1L, , e <= 1L),
         band3(ony <= 1L, , e <= 1L))
  exp_eq(and3s(onz <= 9L, , v <= 9L),
         band3(onz <= 9L, , v <= 9L))
  exp_eq(and3s(ooa <= 0L, u <= 0L, ),
         band3(ooa <= 0L, u <= 0L, ))
  exp_eq(and3s(oob <= 1L, f <= 1L, ),
         band3(oob <= 1L, f <= 1L, ))
  exp_eq(and3s(ooc <= 9L, l <= 9L, ),
         band3(ooc <= 9L, l <= 9L, ))
  exp_eq(and3s(ood <= 0L, t <= 0L, y <= 0L),
         band3(ood <= 0L, t <= 0L, y <= 0L))
  exp_eq(and3s(ooe <= 1L, y <= 1L, f <= 1L),
         band3(ooe <= 1L, y <= 1L, f <= 1L))
  exp_eq(and3s(oof <= 9L, n <= 9L, f <= 9L),
         band3(oof <= 9L, n <= 9L, f <= 9L))
  exp_eq(and3s(oog <= 0L, , ),
         band3(oog <= 0L, , ))
  exp_eq(and3s(ooh <= 1L, , ),
         band3(ooh <= 1L, , ))
  exp_eq(and3s(ooi <= 9L, , ),
         band3(ooi <= 9L, , ))
  exp_eq(and3s(ooj <= 0L, , o == 0L),
         band3(ooj <= 0L, , o == 0L))
  exp_eq(and3s(ook <= 1L, , s == 1L),
         band3(ook <= 1L, , s == 1L))
  exp_eq(and3s(ool <= 9L, , n == 9L),
         band3(ool <= 9L, , n == 9L))
  exp_eq(and3s(oom <= 0L, u <= 0L, ),
         band3(oom <= 0L, u <= 0L, ))
  exp_eq(and3s(oon <= 1L, l <= 1L, ),
         band3(oon <= 1L, l <= 1L, ))
  exp_eq(and3s(ooo <= 9L, u <= 9L, ),
         band3(ooo <= 9L, u <= 9L, ))
  exp_eq(and3s(oop <= 0L, g <= 0L, o == 0L),
         band3(oop <= 0L, g <= 0L, o == 0L))
  exp_eq(and3s(ooq <= 1L, v <= 1L, z == 1L),
         band3(ooq <= 1L, v <= 1L, z == 1L))
  exp_eq(and3s(oor <= 9L, v <= 9L, s == 9L),
         band3(oor <= 9L, v <= 9L, s == 9L))
  exp_eq(and3s(oos <= 0L, , ),
         band3(oos <= 0L, , ))
  exp_eq(and3s(oot <= 1L, , ),
         band3(oot <= 1L, , ))
  exp_eq(and3s(oou <= 9L, , ),
         band3(oou <= 9L, , ))
  exp_eq(and3s(oov <= 0L, , k > 0L),
         band3(oov <= 0L, , k > 0L))
  exp_eq(and3s(oow <= 1L, , u > 1L),
         band3(oow <= 1L, , u > 1L))
  exp_eq(and3s(oox <= 9L, , f > 9L),
         band3(oox <= 9L, , f > 9L))
  exp_eq(and3s(ooy <= 0L, l <= 0L, ),
         band3(ooy <= 0L, l <= 0L, ))
  exp_eq(and3s(ooz <= 1L, f <= 1L, ),
         band3(ooz <= 1L, f <= 1L, ))
  exp_eq(and3s(opa <= 9L, t <= 9L, ),
         band3(opa <= 9L, t <= 9L, ))
  exp_eq(and3s(opb <= 0L, u <= 0L, d > 0L),
         band3(opb <= 0L, u <= 0L, d > 0L))
  exp_eq(and3s(opc <= 1L, m <= 1L, b > 1L),
         band3(opc <= 1L, m <= 1L, b > 1L))
  exp_eq(and3s(opd <= 9L, o <= 9L, m > 9L),
         band3(opd <= 9L, o <= 9L, m > 9L))
  exp_eq(and3s(ope <= 0L, , ),
         band3(ope <= 0L, , ))
  exp_eq(and3s(opf <= 1L, , ),
         band3(opf <= 1L, , ))
  exp_eq(and3s(opg <= 9L, , ),
         band3(opg <= 9L, , ))
  exp_eq(and3s(oph <= 0L, , f >= 0L),
         band3(oph <= 0L, , f >= 0L))
  exp_eq(and3s(opi <= 1L, , p >= 1L),
         band3(opi <= 1L, , p >= 1L))
  exp_eq(and3s(opj <= 9L, , z >= 9L),
         band3(opj <= 9L, , z >= 9L))
  exp_eq(and3s(opk <= 0L, z <= 0L, ),
         band3(opk <= 0L, z <= 0L, ))
  exp_eq(and3s(opl <= 1L, b <= 1L, ),
         band3(opl <= 1L, b <= 1L, ))
  exp_eq(and3s(opm <= 9L, a <= 9L, ),
         band3(opm <= 9L, a <= 9L, ))
  exp_eq(and3s(opn <= 0L, o <= 0L, m >= 0L),
         band3(opn <= 0L, o <= 0L, m >= 0L))
  exp_eq(and3s(opo <= 1L, j <= 1L, z >= 1L),
         band3(opo <= 1L, j <= 1L, z >= 1L))
  exp_eq(and3s(opp <= 9L, g <= 9L, a >= 9L),
         band3(opp <= 9L, g <= 9L, a >= 9L))
  exp_eq(and3s(opq <= 0L, , ),
         band3(opq <= 0L, , ))
  exp_eq(and3s(opr <= 1L, , ),
         band3(opr <= 1L, , ))
  exp_eq(and3s(ops <= 9L, , ),
         band3(ops <= 9L, , ))
  exp_eq(and3s(opt <= 0L, , logi_b),
         band3(opt <= 0L, , logi_b))
  exp_eq(and3s(opu <= 1L, , logi_d),
         band3(opu <= 1L, , logi_d))
  exp_eq(and3s(opv <= 9L, , logi_g),
         band3(opv <= 9L, , logi_g))
  exp_eq(and3s(opw <= 0L, u == 0L, ),
         band3(opw <= 0L, u == 0L, ))
  exp_eq(and3s(opx <= 1L, b == 1L, ),
         band3(opx <= 1L, b == 1L, ))
  exp_eq(and3s(opy <= 9L, p == 9L, ),
         band3(opy <= 9L, p == 9L, ))
  exp_eq(and3s(opz <= 0L, n == 0L, logi_y),
         band3(opz <= 0L, n == 0L, logi_y))
  exp_eq(and3s(oqa <= 1L, z == 1L, logi_z),
         band3(oqa <= 1L, z == 1L, logi_z))
  exp_eq(and3s(oqb <= 9L, l == 9L, logi_h),
         band3(oqb <= 9L, l == 9L, logi_h))
  exp_eq(and3s(oqc <= 0L, , ),
         band3(oqc <= 0L, , ))
  exp_eq(and3s(oqd <= 1L, , ),
         band3(oqd <= 1L, , ))
  exp_eq(and3s(oqe <= 9L, , ),
         band3(oqe <= 9L, , ))
  exp_eq(and3s(oqf <= 0L, , !logi_m),
         band3(oqf <= 0L, , !logi_m))
  exp_eq(and3s(oqg <= 1L, , !logi_b),
         band3(oqg <= 1L, , !logi_b))
  exp_eq(and3s(oqh <= 9L, , !logi_u),
         band3(oqh <= 9L, , !logi_u))
  exp_eq(and3s(oqi <= 0L, x == 0L, ),
         band3(oqi <= 0L, x == 0L, ))
  exp_eq(and3s(oqj <= 1L, x == 1L, ),
         band3(oqj <= 1L, x == 1L, ))
  exp_eq(and3s(oqk <= 9L, b == 9L, ),
         band3(oqk <= 9L, b == 9L, ))
  exp_eq(and3s(oql <= 0L, z == 0L, !logi_n),
         band3(oql <= 0L, z == 0L, !logi_n))
  exp_eq(and3s(oqm <= 1L, f == 1L, !logi_y),
         band3(oqm <= 1L, f == 1L, !logi_y))
  exp_eq(and3s(oqn <= 9L, o == 9L, !logi_c),
         band3(oqn <= 9L, o == 9L, !logi_c))
  exp_eq(and3s(oqo <= 0L, , ),
         band3(oqo <= 0L, , ))
  exp_eq(and3s(oqp <= 1L, , ),
         band3(oqp <= 1L, , ))
  exp_eq(and3s(oqq <= 9L, , ),
         band3(oqq <= 9L, , ))
  exp_eq(and3s(oqr <= 0L, , s != 0L),
         band3(oqr <= 0L, , s != 0L))
  exp_eq(and3s(oqs <= 1L, , y != 1L),
         band3(oqs <= 1L, , y != 1L))
  exp_eq(and3s(oqt <= 9L, , n != 9L),
         band3(oqt <= 9L, , n != 9L))
  exp_eq(and3s(oqu <= 0L, h == 0L, ),
         band3(oqu <= 0L, h == 0L, ))
  exp_eq(and3s(oqv <= 1L, t == 1L, ),
         band3(oqv <= 1L, t == 1L, ))
  exp_eq(and3s(oqw <= 9L, i == 9L, ),
         band3(oqw <= 9L, i == 9L, ))
  exp_eq(and3s(oqx <= 0L, h == 0L, h != 0L),
         band3(oqx <= 0L, h == 0L, h != 0L))
  exp_eq(and3s(oqy <= 1L, r == 1L, d != 1L),
         band3(oqy <= 1L, r == 1L, d != 1L))
  exp_eq(and3s(oqz <= 9L, q == 9L, s != 9L),
         band3(oqz <= 9L, q == 9L, s != 9L))
  exp_eq(and3s(ora <= 0L, , ),
         band3(ora <= 0L, , ))
  exp_eq(and3s(orb <= 1L, , ),
         band3(orb <= 1L, , ))
  exp_eq(and3s(orc <= 9L, , ),
         band3(orc <= 9L, , ))
  exp_eq(and3s(ord <= 0L, , g %between% c(-1L, 1L)),
         band3(ord <= 0L, , g %between% c(-1L, 1L)))
  exp_eq(and3s(ore <= 1L, , z %between% c(-1L, 1L)),
         band3(ore <= 1L, , z %between% c(-1L, 1L)))
  exp_eq(and3s(orf <= 9L, , r %between% c(-1L, 1L)),
         band3(orf <= 9L, , r %between% c(-1L, 1L)))
  exp_eq(and3s(org <= 0L, v == 0L, ),
         band3(org <= 0L, v == 0L, ))
  exp_eq(and3s(orh <= 1L, w == 1L, ),
         band3(orh <= 1L, w == 1L, ))
  exp_eq(and3s(ori <= 9L, b == 9L, ),
         band3(ori <= 9L, b == 9L, ))
  exp_eq(and3s(orj <= 0L, l == 0L, x %between% c(-1L, 1L)),
         band3(orj <= 0L, l == 0L, x %between% c(-1L, 1L)))
  exp_eq(and3s(ork <= 1L, g == 1L, t %between% c(-1L, 1L)),
         band3(ork <= 1L, g == 1L, t %between% c(-1L, 1L)))
  exp_eq(and3s(orl <= 9L, c == 9L, o %between% c(-1L, 1L)),
         band3(orl <= 9L, c == 9L, o %between% c(-1L, 1L)))
  exp_eq(and3s(orm <= 0L, , ),
         band3(orm <= 0L, , ))
  exp_eq(and3s(orn <= 1L, , ),
         band3(orn <= 1L, , ))
  exp_eq(and3s(oro <= 9L, , ),
         band3(oro <= 9L, , ))
  exp_eq(and3s(orp <= 0L, , f %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orp <= 0L, , f %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(orq <= 1L, , t %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orq <= 1L, , t %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(orr <= 9L, , k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orr <= 9L, , k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ors <= 0L, i == 0L, ),
         band3(ors <= 0L, i == 0L, ))
  exp_eq(and3s(ort <= 1L, c == 1L, ),
         band3(ort <= 1L, c == 1L, ))
  exp_eq(and3s(oru <= 9L, y == 9L, ),
         band3(oru <= 9L, y == 9L, ))
  exp_eq(and3s(orv <= 0L, y == 0L, i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orv <= 0L, y == 0L, i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(orw <= 1L, e == 1L, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orw <= 1L, e == 1L, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(orx <= 9L, p == 9L, m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(orx <= 9L, p == 9L, m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ory <= 0L, , ),
         band3(ory <= 0L, , ))
  exp_eq(and3s(orz <= 1L, , ),
         band3(orz <= 1L, , ))
  exp_eq(and3s(osa <= 9L, , ),
         band3(osa <= 9L, , ))
  exp_eq(and3s(osb <= 0L, , h %in% 1:4),
         band3(osb <= 0L, , h %in% 1:4))
  exp_eq(and3s(osc <= 1L, , q %in% 1:4),
         band3(osc <= 1L, , q %in% 1:4))
  exp_eq(and3s(osd <= 9L, , s %in% 1:4),
         band3(osd <= 9L, , s %in% 1:4))
  exp_eq(and3s(ose <= 0L, m == 0L, ),
         band3(ose <= 0L, m == 0L, ))
  exp_eq(and3s(osf <= 1L, w == 1L, ),
         band3(osf <= 1L, w == 1L, ))
  exp_eq(and3s(osg <= 9L, k == 9L, ),
         band3(osg <= 9L, k == 9L, ))
  exp_eq(and3s(osh <= 0L, y == 0L, p %in% 1:4),
         band3(osh <= 0L, y == 0L, p %in% 1:4))
  exp_eq(and3s(osi <= 1L, v == 1L, m %in% 1:4),
         band3(osi <= 1L, v == 1L, m %in% 1:4))
  exp_eq(and3s(osj <= 9L, y == 9L, o %in% 1:4),
         band3(osj <= 9L, y == 9L, o %in% 1:4))
  exp_eq(and3s(osk <= 0L, , ),
         band3(osk <= 0L, , ))
  exp_eq(and3s(osl <= 1L, , ),
         band3(osl <= 1L, , ))
  exp_eq(and3s(osm <= 9L, , ),
         band3(osm <= 9L, , ))
  exp_eq(and3s(osn <= 0L, , f < 0L),
         band3(osn <= 0L, , f < 0L))
  exp_eq(and3s(oso <= 1L, , q < 1L),
         band3(oso <= 1L, , q < 1L))
  exp_eq(and3s(osp <= 9L, , p < 9L),
         band3(osp <= 9L, , p < 9L))
  exp_eq(and3s(osq <= 0L, u == 0L, ),
         band3(osq <= 0L, u == 0L, ))
  exp_eq(and3s(osr <= 1L, a == 1L, ),
         band3(osr <= 1L, a == 1L, ))
  exp_eq(and3s(oss <= 9L, z == 9L, ),
         band3(oss <= 9L, z == 9L, ))
  exp_eq(and3s(ost <= 0L, e == 0L, o < 0L),
         band3(ost <= 0L, e == 0L, o < 0L))
  exp_eq(and3s(osu <= 1L, x == 1L, q < 1L),
         band3(osu <= 1L, x == 1L, q < 1L))
  exp_eq(and3s(osv <= 9L, r == 9L, x < 9L),
         band3(osv <= 9L, r == 9L, x < 9L))
  exp_eq(and3s(osw <= 0L, , ),
         band3(osw <= 0L, , ))
  exp_eq(and3s(osx <= 1L, , ),
         band3(osx <= 1L, , ))
  exp_eq(and3s(osy <= 9L, , ),
         band3(osy <= 9L, , ))
  exp_eq(and3s(osz <= 0L, , e <= 0L),
         band3(osz <= 0L, , e <= 0L))
  exp_eq(and3s(ota <= 1L, , z <= 1L),
         band3(ota <= 1L, , z <= 1L))
  exp_eq(and3s(otb <= 9L, , i <= 9L),
         band3(otb <= 9L, , i <= 9L))
  exp_eq(and3s(otc <= 0L, i == 0L, ),
         band3(otc <= 0L, i == 0L, ))
  exp_eq(and3s(otd <= 1L, u == 1L, ),
         band3(otd <= 1L, u == 1L, ))
  exp_eq(and3s(ote <= 9L, z == 9L, ),
         band3(ote <= 9L, z == 9L, ))
  exp_eq(and3s(otf <= 0L, u == 0L, f <= 0L),
         band3(otf <= 0L, u == 0L, f <= 0L))
  exp_eq(and3s(otg <= 1L, c == 1L, x <= 1L),
         band3(otg <= 1L, c == 1L, x <= 1L))
  exp_eq(and3s(oth <= 9L, y == 9L, h <= 9L),
         band3(oth <= 9L, y == 9L, h <= 9L))
  exp_eq(and3s(oti <= 0L, , ),
         band3(oti <= 0L, , ))
  exp_eq(and3s(otj <= 1L, , ),
         band3(otj <= 1L, , ))
  exp_eq(and3s(otk <= 9L, , ),
         band3(otk <= 9L, , ))
  exp_eq(and3s(otl <= 0L, , o == 0L),
         band3(otl <= 0L, , o == 0L))
  exp_eq(and3s(otm <= 1L, , k == 1L),
         band3(otm <= 1L, , k == 1L))
  exp_eq(and3s(otn <= 9L, , e == 9L),
         band3(otn <= 9L, , e == 9L))
  exp_eq(and3s(oto <= 0L, p == 0L, ),
         band3(oto <= 0L, p == 0L, ))
  exp_eq(and3s(otp <= 1L, w == 1L, ),
         band3(otp <= 1L, w == 1L, ))
  exp_eq(and3s(otq <= 9L, m == 9L, ),
         band3(otq <= 9L, m == 9L, ))
  exp_eq(and3s(otr <= 0L, n == 0L, u == 0L),
         band3(otr <= 0L, n == 0L, u == 0L))
  exp_eq(and3s(ots <= 1L, k == 1L, r == 1L),
         band3(ots <= 1L, k == 1L, r == 1L))
  exp_eq(and3s(ott <= 9L, d == 9L, e == 9L),
         band3(ott <= 9L, d == 9L, e == 9L))
  exp_eq(and3s(otu <= 0L, , ),
         band3(otu <= 0L, , ))
  exp_eq(and3s(otv <= 1L, , ),
         band3(otv <= 1L, , ))
  exp_eq(and3s(otw <= 9L, , ),
         band3(otw <= 9L, , ))
  exp_eq(and3s(otx <= 0L, , b > 0L),
         band3(otx <= 0L, , b > 0L))
  exp_eq(and3s(oty <= 1L, , p > 1L),
         band3(oty <= 1L, , p > 1L))
  exp_eq(and3s(otz <= 9L, , d > 9L),
         band3(otz <= 9L, , d > 9L))
  exp_eq(and3s(oua <= 0L, m == 0L, ),
         band3(oua <= 0L, m == 0L, ))
  exp_eq(and3s(oub <= 1L, h == 1L, ),
         band3(oub <= 1L, h == 1L, ))
  exp_eq(and3s(ouc <= 9L, e == 9L, ),
         band3(ouc <= 9L, e == 9L, ))
  exp_eq(and3s(oud <= 0L, p == 0L, p > 0L),
         band3(oud <= 0L, p == 0L, p > 0L))
  exp_eq(and3s(oue <= 1L, y == 1L, w > 1L),
         band3(oue <= 1L, y == 1L, w > 1L))
  exp_eq(and3s(ouf <= 9L, d == 9L, m > 9L),
         band3(ouf <= 9L, d == 9L, m > 9L))
  exp_eq(and3s(oug <= 0L, , ),
         band3(oug <= 0L, , ))
  exp_eq(and3s(ouh <= 1L, , ),
         band3(ouh <= 1L, , ))
  exp_eq(and3s(oui <= 9L, , ),
         band3(oui <= 9L, , ))
  exp_eq(and3s(ouj <= 0L, , s >= 0L),
         band3(ouj <= 0L, , s >= 0L))
  exp_eq(and3s(ouk <= 1L, , m >= 1L),
         band3(ouk <= 1L, , m >= 1L))
  exp_eq(and3s(oul <= 9L, , a >= 9L),
         band3(oul <= 9L, , a >= 9L))
  exp_eq(and3s(oum <= 0L, l == 0L, ),
         band3(oum <= 0L, l == 0L, ))
  exp_eq(and3s(oun <= 1L, s == 1L, ),
         band3(oun <= 1L, s == 1L, ))
  exp_eq(and3s(ouo <= 9L, v == 9L, ),
         band3(ouo <= 9L, v == 9L, ))
  exp_eq(and3s(oup <= 0L, n == 0L, w >= 0L),
         band3(oup <= 0L, n == 0L, w >= 0L))
  exp_eq(and3s(ouq <= 1L, f == 1L, f >= 1L),
         band3(ouq <= 1L, f == 1L, f >= 1L))
  exp_eq(and3s(our <= 9L, g == 9L, j >= 9L),
         band3(our <= 9L, g == 9L, j >= 9L))
  exp_eq(and3s(ous <= 0L, , ),
         band3(ous <= 0L, , ))
  exp_eq(and3s(out <= 1L, , ),
         band3(out <= 1L, , ))
  exp_eq(and3s(ouu <= 9L, , ),
         band3(ouu <= 9L, , ))
  exp_eq(and3s(ouv <= 0L, , logi_n),
         band3(ouv <= 0L, , logi_n))
  exp_eq(and3s(ouw <= 1L, , logi_l),
         band3(ouw <= 1L, , logi_l))
  exp_eq(and3s(oux <= 9L, , logi_d),
         band3(oux <= 9L, , logi_d))
  exp_eq(and3s(ouy <= 0L, g > 0L, ),
         band3(ouy <= 0L, g > 0L, ))
  exp_eq(and3s(ouz <= 1L, f > 1L, ),
         band3(ouz <= 1L, f > 1L, ))
  exp_eq(and3s(ova <= 9L, g > 9L, ),
         band3(ova <= 9L, g > 9L, ))
  exp_eq(and3s(ovb <= 0L, j > 0L, logi_p),
         band3(ovb <= 0L, j > 0L, logi_p))
  exp_eq(and3s(ovc <= 1L, p > 1L, logi_w),
         band3(ovc <= 1L, p > 1L, logi_w))
  exp_eq(and3s(ovd <= 9L, b > 9L, logi_x),
         band3(ovd <= 9L, b > 9L, logi_x))
  exp_eq(and3s(ove <= 0L, , ),
         band3(ove <= 0L, , ))
  exp_eq(and3s(ovf <= 1L, , ),
         band3(ovf <= 1L, , ))
  exp_eq(and3s(ovg <= 9L, , ),
         band3(ovg <= 9L, , ))
  exp_eq(and3s(ovh <= 0L, , !logi_n),
         band3(ovh <= 0L, , !logi_n))
  exp_eq(and3s(ovi <= 1L, , !logi_v),
         band3(ovi <= 1L, , !logi_v))
  exp_eq(and3s(ovj <= 9L, , !logi_q),
         band3(ovj <= 9L, , !logi_q))
  exp_eq(and3s(ovk <= 0L, c > 0L, ),
         band3(ovk <= 0L, c > 0L, ))
  exp_eq(and3s(ovl <= 1L, e > 1L, ),
         band3(ovl <= 1L, e > 1L, ))
  exp_eq(and3s(ovm <= 9L, g > 9L, ),
         band3(ovm <= 9L, g > 9L, ))
  exp_eq(and3s(ovn <= 0L, x > 0L, !logi_s),
         band3(ovn <= 0L, x > 0L, !logi_s))
  exp_eq(and3s(ovo <= 1L, w > 1L, !logi_u),
         band3(ovo <= 1L, w > 1L, !logi_u))
  exp_eq(and3s(ovp <= 9L, j > 9L, !logi_h),
         band3(ovp <= 9L, j > 9L, !logi_h))
  exp_eq(and3s(ovq <= 0L, , ),
         band3(ovq <= 0L, , ))
  exp_eq(and3s(ovr <= 1L, , ),
         band3(ovr <= 1L, , ))
  exp_eq(and3s(ovs <= 9L, , ),
         band3(ovs <= 9L, , ))
  exp_eq(and3s(ovt <= 0L, , u != 0L),
         band3(ovt <= 0L, , u != 0L))
  exp_eq(and3s(ovu <= 1L, , g != 1L),
         band3(ovu <= 1L, , g != 1L))
  exp_eq(and3s(ovv <= 9L, , e != 9L),
         band3(ovv <= 9L, , e != 9L))
  exp_eq(and3s(ovw <= 0L, r > 0L, ),
         band3(ovw <= 0L, r > 0L, ))
  exp_eq(and3s(ovx <= 1L, k > 1L, ),
         band3(ovx <= 1L, k > 1L, ))
  exp_eq(and3s(ovy <= 9L, s > 9L, ),
         band3(ovy <= 9L, s > 9L, ))
  exp_eq(and3s(ovz <= 0L, d > 0L, i != 0L),
         band3(ovz <= 0L, d > 0L, i != 0L))
  exp_eq(and3s(owa <= 1L, f > 1L, k != 1L),
         band3(owa <= 1L, f > 1L, k != 1L))
  exp_eq(and3s(owb <= 9L, g > 9L, w != 9L),
         band3(owb <= 9L, g > 9L, w != 9L))
  exp_eq(and3s(owc <= 0L, , ),
         band3(owc <= 0L, , ))
  exp_eq(and3s(owd <= 1L, , ),
         band3(owd <= 1L, , ))
  exp_eq(and3s(owe <= 9L, , ),
         band3(owe <= 9L, , ))
  exp_eq(and3s(owf <= 0L, , o %between% c(-1L, 1L)),
         band3(owf <= 0L, , o %between% c(-1L, 1L)))
  exp_eq(and3s(owg <= 1L, , n %between% c(-1L, 1L)),
         band3(owg <= 1L, , n %between% c(-1L, 1L)))
  exp_eq(and3s(owh <= 9L, , y %between% c(-1L, 1L)),
         band3(owh <= 9L, , y %between% c(-1L, 1L)))
  exp_eq(and3s(owi <= 0L, z > 0L, ),
         band3(owi <= 0L, z > 0L, ))
  exp_eq(and3s(owj <= 1L, f > 1L, ),
         band3(owj <= 1L, f > 1L, ))
  exp_eq(and3s(owk <= 9L, e > 9L, ),
         band3(owk <= 9L, e > 9L, ))
  exp_eq(and3s(owl <= 0L, n > 0L, v %between% c(-1L, 1L)),
         band3(owl <= 0L, n > 0L, v %between% c(-1L, 1L)))
  exp_eq(and3s(owm <= 1L, o > 1L, a %between% c(-1L, 1L)),
         band3(owm <= 1L, o > 1L, a %between% c(-1L, 1L)))
  exp_eq(and3s(own <= 9L, e > 9L, i %between% c(-1L, 1L)),
         band3(own <= 9L, e > 9L, i %between% c(-1L, 1L)))
  exp_eq(and3s(owo <= 0L, , ),
         band3(owo <= 0L, , ))
  exp_eq(and3s(owp <= 1L, , ),
         band3(owp <= 1L, , ))
  exp_eq(and3s(owq <= 9L, , ),
         band3(owq <= 9L, , ))
  exp_eq(and3s(owr <= 0L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(owr <= 0L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(ows <= 1L, , m %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(ows <= 1L, , m %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(owt <= 9L, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(owt <= 9L, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(owu <= 0L, d > 0L, ),
         band3(owu <= 0L, d > 0L, ))
  exp_eq(and3s(owv <= 1L, d > 1L, ),
         band3(owv <= 1L, d > 1L, ))
  exp_eq(and3s(oww <= 9L, e > 9L, ),
         band3(oww <= 9L, e > 9L, ))
  exp_eq(and3s(owx <= 0L, l > 0L, q %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(owx <= 0L, l > 0L, q %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(owy <= 1L, b > 1L, j %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(owy <= 1L, b > 1L, j %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(owz <= 9L, u > 9L, p %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(owz <= 9L, u > 9L, p %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(oxa <= 0L, , ),
         band3(oxa <= 0L, , ))
  exp_eq(and3s(oxb <= 1L, , ),
         band3(oxb <= 1L, , ))
  exp_eq(and3s(oxc <= 9L, , ),
         band3(oxc <= 9L, , ))
  exp_eq(and3s(oxd <= 0L, , h %in% 1:4),
         band3(oxd <= 0L, , h %in% 1:4))
  exp_eq(and3s(oxe <= 1L, , r %in% 1:4),
         band3(oxe <= 1L, , r %in% 1:4))
  exp_eq(and3s(oxf <= 9L, , s %in% 1:4),
         band3(oxf <= 9L, , s %in% 1:4))
  exp_eq(and3s(oxg <= 0L, m > 0L, ),
         band3(oxg <= 0L, m > 0L, ))
  exp_eq(and3s(oxh <= 1L, r > 1L, ),
         band3(oxh <= 1L, r > 1L, ))
  exp_eq(and3s(oxi <= 9L, t > 9L, ),
         band3(oxi <= 9L, t > 9L, ))
  exp_eq(and3s(oxj <= 0L, p > 0L, j %in% 1:4),
         band3(oxj <= 0L, p > 0L, j %in% 1:4))
  exp_eq(and3s(oxk <= 1L, i > 1L, l %in% 1:4),
         band3(oxk <= 1L, i > 1L, l %in% 1:4))
  exp_eq(and3s(oxl <= 9L, f > 9L, k %in% 1:4),
         band3(oxl <= 9L, f > 9L, k %in% 1:4))
  exp_eq(and3s(oxm <= 0L, , ),
         band3(oxm <= 0L, , ))
  exp_eq(and3s(oxn <= 1L, , ),
         band3(oxn <= 1L, , ))
  exp_eq(and3s(oxo <= 9L, , ),
         band3(oxo <= 9L, , ))
  exp_eq(and3s(oxp <= 0L, , y < 0L),
         band3(oxp <= 0L, , y < 0L))
  exp_eq(and3s(oxq <= 1L, , t < 1L),
         band3(oxq <= 1L, , t < 1L))
  exp_eq(and3s(oxr <= 9L, , o < 9L),
         band3(oxr <= 9L, , o < 9L))
  exp_eq(and3s(oxs <= 0L, k > 0L, ),
         band3(oxs <= 0L, k > 0L, ))
  exp_eq(and3s(oxt <= 1L, e > 1L, ),
         band3(oxt <= 1L, e > 1L, ))
  exp_eq(and3s(oxu <= 9L, c > 9L, ),
         band3(oxu <= 9L, c > 9L, ))
  exp_eq(and3s(oxv <= 0L, f > 0L, j < 0L),
         band3(oxv <= 0L, f > 0L, j < 0L))
  exp_eq(and3s(oxw <= 1L, z > 1L, a < 1L),
         band3(oxw <= 1L, z > 1L, a < 1L))
  exp_eq(and3s(oxx <= 9L, i > 9L, q < 9L),
         band3(oxx <= 9L, i > 9L, q < 9L))
  exp_eq(and3s(oxy <= 0L, , ),
         band3(oxy <= 0L, , ))
  exp_eq(and3s(oxz <= 1L, , ),
         band3(oxz <= 1L, , ))
  exp_eq(and3s(oya <= 9L, , ),
         band3(oya <= 9L, , ))
  exp_eq(and3s(oyb <= 0L, , n <= 0L),
         band3(oyb <= 0L, , n <= 0L))
  exp_eq(and3s(oyc <= 1L, , c <= 1L),
         band3(oyc <= 1L, , c <= 1L))
  exp_eq(and3s(oyd <= 9L, , n <= 9L),
         band3(oyd <= 9L, , n <= 9L))
  exp_eq(and3s(oye <= 0L, o > 0L, ),
         band3(oye <= 0L, o > 0L, ))
  exp_eq(and3s(oyf <= 1L, f > 1L, ),
         band3(oyf <= 1L, f > 1L, ))
  exp_eq(and3s(oyg <= 9L, m > 9L, ),
         band3(oyg <= 9L, m > 9L, ))
  exp_eq(and3s(oyh <= 0L, h > 0L, j <= 0L),
         band3(oyh <= 0L, h > 0L, j <= 0L))
  exp_eq(and3s(oyi <= 1L, i > 1L, o <= 1L),
         band3(oyi <= 1L, i > 1L, o <= 1L))
  exp_eq(and3s(oyj <= 9L, u > 9L, d <= 9L),
         band3(oyj <= 9L, u > 9L, d <= 9L))
  exp_eq(and3s(oyk <= 0L, , ),
         band3(oyk <= 0L, , ))
  exp_eq(and3s(oyl <= 1L, , ),
         band3(oyl <= 1L, , ))
  exp_eq(and3s(oym <= 9L, , ),
         band3(oym <= 9L, , ))
  exp_eq(and3s(oyn <= 0L, , m == 0L),
         band3(oyn <= 0L, , m == 0L))
  exp_eq(and3s(oyo <= 1L, , j == 1L),
         band3(oyo <= 1L, , j == 1L))
  exp_eq(and3s(oyp <= 9L, , q == 9L),
         band3(oyp <= 9L, , q == 9L))
  exp_eq(and3s(oyq <= 0L, k > 0L, ),
         band3(oyq <= 0L, k > 0L, ))
  exp_eq(and3s(oyr <= 1L, j > 1L, ),
         band3(oyr <= 1L, j > 1L, ))
  exp_eq(and3s(oys <= 9L, h > 9L, ),
         band3(oys <= 9L, h > 9L, ))
  exp_eq(and3s(oyt <= 0L, x > 0L, w == 0L),
         band3(oyt <= 0L, x > 0L, w == 0L))
  exp_eq(and3s(oyu <= 1L, v > 1L, u == 1L),
         band3(oyu <= 1L, v > 1L, u == 1L))
  exp_eq(and3s(oyv <= 9L, t > 9L, p == 9L),
         band3(oyv <= 9L, t > 9L, p == 9L))
  exp_eq(and3s(oyw <= 0L, , ),
         band3(oyw <= 0L, , ))
  exp_eq(and3s(oyx <= 1L, , ),
         band3(oyx <= 1L, , ))
  exp_eq(and3s(oyy <= 9L, , ),
         band3(oyy <= 9L, , ))
  exp_eq(and3s(oyz <= 0L, , m > 0L),
         band3(oyz <= 0L, , m > 0L))
  exp_eq(and3s(pa <= 1L, , h > 1L),
         band3(pa <= 1L, , h > 1L))
  exp_eq(and3s(pb <= 9L, , u > 9L),
         band3(pb <= 9L, , u > 9L))
  exp_eq(and3s(pc <= 0L, o > 0L, ),
         band3(pc <= 0L, o > 0L, ))
  exp_eq(and3s(pd <= 1L, c > 1L, ),
         band3(pd <= 1L, c > 1L, ))
  exp_eq(and3s(pe <= 9L, a > 9L, ),
         band3(pe <= 9L, a > 9L, ))
  exp_eq(and3s(pf <= 0L, c > 0L, q > 0L),
         band3(pf <= 0L, c > 0L, q > 0L))
  exp_eq(and3s(pg <= 1L, q > 1L, u > 1L),
         band3(pg <= 1L, q > 1L, u > 1L))
  exp_eq(and3s(ph <= 9L, o > 9L, m > 9L),
         band3(ph <= 9L, o > 9L, m > 9L))
  exp_eq(and3s(pi <= 0L, , ),
         band3(pi <= 0L, , ))
  exp_eq(and3s(pj <= 1L, , ),
         band3(pj <= 1L, , ))
  exp_eq(and3s(pk <= 9L, , ),
         band3(pk <= 9L, , ))
  exp_eq(and3s(pl <= 0L, , s >= 0L),
         band3(pl <= 0L, , s >= 0L))
  exp_eq(and3s(pm <= 1L, , s >= 1L),
         band3(pm <= 1L, , s >= 1L))
  exp_eq(and3s(pn <= 9L, , m >= 9L),
         band3(pn <= 9L, , m >= 9L))
  exp_eq(and3s(po <= 0L, w > 0L, ),
         band3(po <= 0L, w > 0L, ))
  exp_eq(and3s(pp <= 1L, l > 1L, ),
         band3(pp <= 1L, l > 1L, ))
  exp_eq(and3s(pq <= 9L, q > 9L, ),
         band3(pq <= 9L, q > 9L, ))
  exp_eq(and3s(pr <= 0L, w > 0L, u >= 0L),
         band3(pr <= 0L, w > 0L, u >= 0L))
  exp_eq(and3s(ps <= 1L, t > 1L, b >= 1L),
         band3(ps <= 1L, t > 1L, b >= 1L))
  exp_eq(and3s(pt <= 9L, z > 9L, o >= 9L),
         band3(pt <= 9L, z > 9L, o >= 9L))
  exp_eq(and3s(pu <= 0L, , ),
         band3(pu <= 0L, , ))
  exp_eq(and3s(pv <= 1L, , ),
         band3(pv <= 1L, , ))
  exp_eq(and3s(pw <= 9L, , ),
         band3(pw <= 9L, , ))
  exp_eq(and3s(px <= 0L, , logi_c),
         band3(px <= 0L, , logi_c))
  exp_eq(and3s(py <= 1L, , logi_v),
         band3(py <= 1L, , logi_v))
  exp_eq(and3s(pz <= 9L, , logi_m),
         band3(pz <= 9L, , logi_m))
  exp_eq(and3s(paa <= 0L, a >= 0L, ),
         band3(paa <= 0L, a >= 0L, ))
  exp_eq(and3s(pab <= 1L, y >= 1L, ),
         band3(pab <= 1L, y >= 1L, ))
  exp_eq(and3s(pac <= 9L, c >= 9L, ),
         band3(pac <= 9L, c >= 9L, ))
  exp_eq(and3s(pad <= 0L, y >= 0L, logi_w),
         band3(pad <= 0L, y >= 0L, logi_w))
  exp_eq(and3s(pae <= 1L, u >= 1L, logi_x),
         band3(pae <= 1L, u >= 1L, logi_x))
  exp_eq(and3s(paf <= 9L, t >= 9L, logi_u),
         band3(paf <= 9L, t >= 9L, logi_u))
  exp_eq(and3s(pag <= 0L, , ),
         band3(pag <= 0L, , ))
  exp_eq(and3s(pah <= 1L, , ),
         band3(pah <= 1L, , ))
  exp_eq(and3s(pai <= 9L, , ),
         band3(pai <= 9L, , ))
  exp_eq(and3s(paj <= 0L, , !logi_c),
         band3(paj <= 0L, , !logi_c))
  exp_eq(and3s(pak <= 1L, , !logi_t),
         band3(pak <= 1L, , !logi_t))
  exp_eq(and3s(pal <= 9L, , !logi_t),
         band3(pal <= 9L, , !logi_t))
  exp_eq(and3s(pam <= 0L, h >= 0L, ),
         band3(pam <= 0L, h >= 0L, ))
  exp_eq(and3s(pan <= 1L, h >= 1L, ),
         band3(pan <= 1L, h >= 1L, ))
  exp_eq(and3s(pao <= 9L, r >= 9L, ),
         band3(pao <= 9L, r >= 9L, ))
  exp_eq(and3s(pap <= 0L, t >= 0L, !logi_g),
         band3(pap <= 0L, t >= 0L, !logi_g))
  exp_eq(and3s(paq <= 1L, u >= 1L, !logi_v),
         band3(paq <= 1L, u >= 1L, !logi_v))
  exp_eq(and3s(par <= 9L, a >= 9L, !logi_n),
         band3(par <= 9L, a >= 9L, !logi_n))
  exp_eq(and3s(pas <= 0L, , ),
         band3(pas <= 0L, , ))
  exp_eq(and3s(pat <= 1L, , ),
         band3(pat <= 1L, , ))
  exp_eq(and3s(pau <= 9L, , ),
         band3(pau <= 9L, , ))
  exp_eq(and3s(pav <= 0L, , l != 0L),
         band3(pav <= 0L, , l != 0L))
  exp_eq(and3s(paw <= 1L, , z != 1L),
         band3(paw <= 1L, , z != 1L))
  exp_eq(and3s(pax <= 9L, , s != 9L),
         band3(pax <= 9L, , s != 9L))
  exp_eq(and3s(pay <= 0L, u >= 0L, ),
         band3(pay <= 0L, u >= 0L, ))
  exp_eq(and3s(paz <= 1L, c >= 1L, ),
         band3(paz <= 1L, c >= 1L, ))
  exp_eq(and3s(pba <= 9L, x >= 9L, ),
         band3(pba <= 9L, x >= 9L, ))
  exp_eq(and3s(pbb <= 0L, u >= 0L, c != 0L),
         band3(pbb <= 0L, u >= 0L, c != 0L))
  exp_eq(and3s(pbc <= 1L, t >= 1L, t != 1L),
         band3(pbc <= 1L, t >= 1L, t != 1L))
  exp_eq(and3s(pbd <= 9L, v >= 9L, e != 9L),
         band3(pbd <= 9L, v >= 9L, e != 9L))
  exp_eq(and3s(pbe <= 0L, , ),
         band3(pbe <= 0L, , ))
  exp_eq(and3s(pbf <= 1L, , ),
         band3(pbf <= 1L, , ))
  exp_eq(and3s(pbg <= 9L, , ),
         band3(pbg <= 9L, , ))
  exp_eq(and3s(pbh <= 0L, , z %between% c(-1L, 1L)),
         band3(pbh <= 0L, , z %between% c(-1L, 1L)))
  exp_eq(and3s(pbi <= 1L, , z %between% c(-1L, 1L)),
         band3(pbi <= 1L, , z %between% c(-1L, 1L)))
  exp_eq(and3s(pbj <= 9L, , c %between% c(-1L, 1L)),
         band3(pbj <= 9L, , c %between% c(-1L, 1L)))
  exp_eq(and3s(pbk <= 0L, e >= 0L, ),
         band3(pbk <= 0L, e >= 0L, ))
  exp_eq(and3s(pbl <= 1L, b >= 1L, ),
         band3(pbl <= 1L, b >= 1L, ))
  exp_eq(and3s(pbm <= 9L, m >= 9L, ),
         band3(pbm <= 9L, m >= 9L, ))
  exp_eq(and3s(pbn <= 0L, q >= 0L, m %between% c(-1L, 1L)),
         band3(pbn <= 0L, q >= 0L, m %between% c(-1L, 1L)))
  exp_eq(and3s(pbo <= 1L, b >= 1L, x %between% c(-1L, 1L)),
         band3(pbo <= 1L, b >= 1L, x %between% c(-1L, 1L)))
  exp_eq(and3s(pbp <= 9L, e >= 9L, y %between% c(-1L, 1L)),
         band3(pbp <= 9L, e >= 9L, y %between% c(-1L, 1L)))
  exp_eq(and3s(pbq <= 0L, , ),
         band3(pbq <= 0L, , ))
  exp_eq(and3s(pbr <= 1L, , ),
         band3(pbr <= 1L, , ))
  exp_eq(and3s(pbs <= 9L, , ),
         band3(pbs <= 9L, , ))
  exp_eq(and3s(pbt <= 0L, , u %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pbt <= 0L, , u %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pbu <= 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pbu <= 1L, , z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pbv <= 9L, , i %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pbv <= 9L, , i %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pbw <= 0L, g >= 0L, ),
         band3(pbw <= 0L, g >= 0L, ))
  exp_eq(and3s(pbx <= 1L, b >= 1L, ),
         band3(pbx <= 1L, b >= 1L, ))
  exp_eq(and3s(pby <= 9L, m >= 9L, ),
         band3(pby <= 9L, m >= 9L, ))
  exp_eq(and3s(pbz <= 0L, u >= 0L, c %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pbz <= 0L, u >= 0L, c %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pca <= 1L, i >= 1L, k %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pca <= 1L, i >= 1L, k %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pcb <= 9L, r >= 9L, z %in% c(4L, -3L, 2L, 7L, 8L)),
         band3(pcb <= 9L, r >= 9L, z %in% c(4L, -3L, 2L, 7L, 8L)))
  exp_eq(and3s(pcc <= 0L, , ),
         band3(pcc <= 0L, , ))
  exp_eq(and3s(pcd <= 1L, , ),
         band3(pcd <= 1L, , ))
  exp_eq(and3s(pce <= 9L, , ),
         band3(pce <= 9L, , ))
  exp_eq(and3s(pcf <= 0L, , x %in% 1:4),
         band3(pcf <= 0L, , x %in% 1:4))
  exp_eq(and3s(pcg <= 1L, , r %in% 1:4),
         band3(pcg <= 1L, , r %in% 1:4))
  exp_eq(and3s(pch <= 9L, , m %in% 1:4),
         band3(pch <= 9L, , m %in% 1:4))
  exp_eq(and3s(pci <= 0L, w >= 0L, ),
         band3(pci <= 0L, w >= 0L, ))
  exp_eq(and3s(pcj <= 1L, w >= 1L, ),
         band3(pcj <= 1L, w >= 1L, ))
  exp_eq(and3s(pck <= 9L, y >= 9L, ),
         band3(pck <= 9L, y >= 9L, ))
  exp_eq(and3s(pcl <= 0L, l >= 0L, k %in% 1:4),
         band3(pcl <= 0L, l >= 0L, k %in% 1:4))
  exp_eq(and3s(pcm <= 1L, c >= 1L, w %in% 1:4),
         band3(pcm <= 1L, c >= 1L, w %in% 1:4))
  exp_eq(and3s(pcn <= 9L, u >= 9L, h %in% 1:4),
         band3(pcn <= 9L, u >= 9L, h %in% 1:4))
  exp_eq(and3s(pco <= 0L, , ),
         band3(pco <= 0L, , ))
  exp_eq(and3s(pcp <= 1L, , ),
         band3(pcp <= 1L, , ))
  exp_eq(and3s(pcq <= 9L, , ),
         band3(pcq <= 9L, , ))
  exp_eq(and3s(pcr <= 0L, , o < 0L),
         band3(pcr <= 0L, , o < 0L))
  exp_eq(and3s(pcs <= 1L, , s < 1L),
         band3(pcs <= 1L, , s < 1L))
  exp_eq(and3s(pct <= 9L, , m < 9L),
         band3(pct <= 9L, , m < 9L))
  exp_eq(and3s(pcu <= 0L, r >= 0L, ),
         band3(pcu <= 0L, r >= 0L, ))
  exp_eq(and3s(pcv <= 1L, s >= 1L, ),
         band3(pcv <= 1L, s >= 1L, ))
  exp_eq(and3s(pcw <= 9L, q >= 9L, ),
         band3(pcw <= 9L, q >= 9L, ))
  exp_eq(and3s(pcx <= 0L, l >= 0L, h < 0L),
         band3(pcx <= 0L, l >= 0L, h < 0L))
  exp_eq(and3s(pcy <= 1L, k >= 1L, k < 1L),
         band3(pcy <= 1L, k >= 1L, k < 1L))
  exp_eq(and3s(pcz <= 9L, b >= 9L, n < 9L),
         band3(pcz <= 9L, b >= 9L, n < 9L))
  exp_eq(and3s(pda <= 0L, , ),
         band3(pda <= 0L, , ))
  exp_eq(and3s(pdb <= 1L, , ),
         band3(pdb <= 1L, , ))
  exp_eq(and3s(pdc <= 9L, , ),
         band3(pdc <= 9L, , ))
  exp_eq(and3s(pdd <= 0L, , l <= 0L),
         band3(pdd <= 0L, , l <= 0L))
  exp_eq(and3s(pde <= 1L, , b <= 1L),
         band3(pde <= 1L, , b <= 1L))
  exp_eq(and3s(pdf <= 9L, , c <= 9L),
         band3(pdf <= 9L, , c <= 9L))
  exp_eq(and3s(pdg <= 0L, z >= 0L, ),
         band3(pdg <= 0L, z >= 0L, ))
  exp_eq(and3s(pdh <= 1L, o >= 1L, ),
         band3(pdh <= 1L, o >= 1L, ))
  exp_eq(and3s(pdi <= 9L, t >= 9L, ),
         band3(pdi <= 9L, t >= 9L, ))
  exp_eq(and3s(pdj <= 0L, h >= 0L, r <= 0L),
         band3(pdj <= 0L, h >= 0L, r <= 0L))
  exp_eq(and3s(pdk <= 1L, y >= 1L, q <= 1L),
         band3(pdk <= 1L, y >= 1L, q <= 1L))
  exp_eq(and3s(pdl <= 9L, j >= 9L, a <= 9L),
         band3(pdl <= 9L, j >= 9L, a <= 9L))
  exp_eq(and3s(pdm <= 0L, , ),
         band3(pdm <= 0L, , ))
  exp_eq(and3s(pdn <= 1L, , ),
         band3(pdn <= 1L, , ))
  exp_eq(and3s(pdo <= 9L, , ),
         band3(pdo <= 9L, , ))
  exp_eq(and3s(pdp <= 0L, , a == 0L),
         band3(pdp <= 0L, , a == 0L))
  exp_eq(and3s(pdq <= 1L, , y == 1L),
         band3(pdq <= 1L, , y == 1L))
  exp_eq(and3s(pdr <= 9L, , p == 9L),
         band3(pdr <= 9L, , p == 9L))
  exp_eq(and3s(pds <= 0L, s >= 0L, ),
         band3(pds <= 0L, s >= 0L, ))
  exp_eq(and3s(pdt <= 1L, h >= 1L, ),
         band3(pdt <= 1L, h >= 1L, ))
  exp_eq(and3s(pdu <= 9L, c >= 9L, ),
         band3(pdu <= 9L, c >= 9L, ))
  exp_eq(and3s(pdv <= 0L, v >= 0L, p == 0L),
         band3(pdv <= 0L, v >= 0L, p == 0L))
  exp_eq(and3s(pdw <= 1L, g >= 1L, v == 1L),
         band3(pdw <= 1L, g >= 1L, v == 1L))
  exp_eq(and3s(pdx <= 9L, s >= 9L, u == 9L),
         band3(pdx <= 9L, s >= 9L, u == 9L))
  exp_eq(and3s(pdy <= 0L, , ),
         band3(pdy <= 0L, , ))
  exp_eq(and3s(pdz <= 1L, , ),
         band3(pdz <= 1L, , ))
  exp_eq(and3s(pea <= 9L, , ),
         band3(pea <= 9L, , ))
  exp_eq(and3s(peb <= 0L, , x > 0L),
         band3(peb <= 0L, , x > 0L))
  exp_eq(and3s(pec <= 1L, , n > 1L),
         band3(pec <= 1L, , n > 1L))
  exp_eq(and3s(ped <= 9L, , h > 9L),
         band3(ped <= 9L, , h > 9L))
  exp_eq(and3s(pee <= 0L, a >= 0L, ),
         band3(pee <= 0L, a >= 0L, ))
  exp_eq(and3s(pef <= 1L, j >= 1L, ),
         band3(pef <= 1L, j >= 1L, ))
  exp_eq(and3s(peg <= 9L, d >= 9L, ),
         band3(peg <= 9L, d >= 9L, ))
  exp_eq(and3s(peh <= 0L, z >= 0L, u > 0L),
         band3(peh <= 0L, z >= 0L, u > 0L))
  exp_eq(and3s(pei <= 1L, g >= 1L, e > 1L),
         band3(pei <= 1L, g >= 1L, e > 1L))
  exp_eq(and3s(pej <= 9L, v >= 9L, t > 9L),
         band3(pej <= 9L, v >= 9L, t > 9L))
  exp_eq(and3s(pek <= 0L, , ),
         band3(pek <= 0L, , ))
  exp_eq(and3s(pel <= 1L, , ),
         band3(pel <= 1L, , ))
  exp_eq(and3s(pem <= 9L, , ),
         band3(pem <= 9L, , ))
  exp_eq(and3s(pen <= 0L, , u >= 0L),
         band3(pen <= 0L, , u >= 0L))
  exp_eq(and3s(peo <= 1L, , i >= 1L),
         band3(peo <= 1L, , i >= 1L))
  exp_eq(and3s(pep <= 9L, , j >= 9L),
         band3(pep <= 9L, , j >= 9L))
  exp_eq(and3s(peq <= 0L, a >= 0L, ),
         band3(peq <= 0L, a >= 0L, ))
  exp_eq(and3s(per <= 1L, f >= 1L, ),
         band3(per <= 1L, f >= 1L, ))
  exp_eq(and3s(pes <= 9L, i >= 9L, ),
         band3(pes <= 9L, i >= 9L, ))
  exp_eq(and3s(pet <= 0L, y >= 0L, i >= 0L),
         band3(pet <= 0L, y >= 0L, i >= 0L))
  exp_eq(and3s(peu <= 1L, c >= 1L, h >= 1L),
         band3(peu <= 1L, c >= 1L, h >= 1L))
  exp_eq(and3s(pev <= 9L, k >= 9L, i >= 9L),
         band3(pev <= 9L, k >= 9L, i >= 9L))
  exp_eq(and3s(pew =