% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_3comp2.R
\name{parameterize_3comp2}
\alias{parameterize_3comp2}
\title{Parameters for a three-compartment toxicokinetic model (dynamic)}
\usage{
parameterize_3comp2(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  force.human.clint.fup = FALSE,
  clint.pvalue.threshold = 0.05,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  regression = TRUE,
  suppress.messages = FALSE,
  restrictive.clearance = TRUE,
  minimum.Funbound.plasma = 1e-04,
  Caco2.options = NULL,
  ...
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (https://comptox.epa.gov/dashboard)
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{force.human.clint.fup}{Forces use of human values for hepatic
intrinsic clearance and fraction of unbound plasma if true.}

\item{clint.pvalue.threshold}{Hepatic clearances with clearance assays
having p-values greater than the threshold are set to zero.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{restrictive.clearance}{In calculating hepatic.bioavailability, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.Pab.default = 1.6,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fbio}} for further details.}

\item{...}{Additional arguments are passed to \code{\link{parameterize_pbtk}}}
}
\value{
\item{BW}{Body Weight, kg.} 
\item{Clmetabolismc}{Hepatic Clearance, L/h/kg BW.} 
\item{Fabsgut}{Fraction of the oral dose absorbed, i.e. the 
fraction of the dose that enters the gutlumen.} 
\item{Funbound.plasma}{Fraction of plasma that is not bound.} 
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte 
assay using the method of Kilford et al. (2008)} 
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{Kgut2pu}{Ratio of concentration of chemical in gut tissue to unbound
concentration in plasma.} 
\item{Kliver2pu}{Ratio of concentration of
chemical in liver tissue to unbound concentration in plasma.}
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells to
unbound concentration in plasma.} 
\item{Krest2pu}{Ratio of concentration of
chemical in rest of body tissue to unbound concentration in plasma.}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{MW}{Molecular Weight, g/mol.} 
\item{Qcardiacc}{Cardiac Output, L/h/kg
BW^3/4.} \item{Qgfrc}{Glomerular Filtration Rate, L/h/kg BW^3/4, volume of
fluid filtered from kidney and excreted.} 
\item{Qgutf}{Fraction of cardiac output flowing to the gut.} 
\item{Qliverf}{Fraction of cardiac output flowing to the liver.} 
\item{Rblood2plasma}{The ratio of the concentration
of the chemical in the blood to the concentration in the plasma.}
\item{Vgutc}{Volume of the gut per kg body weight, L/kg BW.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
}
\description{
This function generates the chemical- and species-specific parameters needed 
for model '3compartment', for example \code{\link{solve_3comp}}. A call is 
masde to \code{\link{parameterize_pbtk}} to use Schmitt (2008)'s method
as modified by Pearce et al. (2017) to predict partition coefficients based
on descriptions in \code{\link{tissue.data}}. Organ volumes and flows are
retrieved from table \code{\link{physiology.data}}.
}
\examples{

 parameters <- parameterize_3comp2(chem.name='Bisphenol-A',species='Rat')
 parameters <- parameterize_3comp2(chem.cas='80-05-7',
                                  species='rabbit',default.to.human=TRUE)
 out <- solve_3comp2(parameters=parameters,plots=TRUE)

}
\references{
\insertRef{pearce2017httk}{httk}

\insertRef{schmitt2008general}{httk}

\insertRef{pearce2017evaluation}{httk}

\insertRef{kilford2008hepatocellular}{httk}
}
\seealso{
\code{\link{solve_3comp}}

\code{\link{calc_analytic_css_3comp}}

\code{\link{parameterize_pbtk}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{3compartment2}
\keyword{Parameter}
