% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_fup_clint.R
\name{draw_fup_clint}
\alias{draw_fup_clint}
\title{Draw Funbound.plasma and Clint from censored or non-censored distributions.}
\usage{
draw_fup_clint(this.chem = NULL, parameters = NULL, nsamp,
  fup.meas.cv = 0.4, clint.meas.cv = 0.3, fup.pop.cv = 0.3,
  clint.pop.cv = 0.3, poormetab = TRUE, fup.lod = 0.01,
  fup.censored.dist = FALSE, adjusted.Funbound.plasma = T,
  clint.pvalue.threshold = 0.05, minimum.Funbound.plasma = 1e-04)
}
\arguments{
\item{this.chem}{The CAS number of one of the HTTK chemicals (see
\code{\link[httk]{get_cheminfo}}).}

\item{parameters}{A list of chemical-specific model parameters containing at
least Funbound.plasma, Clint, and Fhep.assay.correction.}

\item{nsamp}{The number of samples to draw.}

\item{fup.meas.cv}{Coefficient of variation of distribution of measured
\code{Funbound.plasma} values.}

\item{clint.meas.cv}{Coefficient of variation of distribution of measured 
\code{Clint} values.}

\item{fup.pop.cv}{Coefficient of variation of distribution of population
\code{Funbound.plasma} values.}

\item{clint.pop.cv}{Coefficient of variation of distribution of population
\code{Clint} values.}

\item{poormetab}{Logical. Whether to include poor metabolizers in the Clint
distribution or not.}

\item{fup.lod}{The average limit of detection for \code{Funbound.plasma}, below
which distribution will be censored if fup.censored.dist is TRUE. Default 0.01.}

\item{fup.censored.dist}{Logical. Whether to draw \code{Funbound.plasma} from a
censored distribution or not.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
A data.table with three columns: \code{Funbound.plasma} and
\code{Clint}, containing the sampled values, and
\code{Fhep.assay.correction}, containing the value for fraction unbound in
hepatocyte assay.
}
\description{
Given a CAS in the HTTK data set, a virtual population from HTTK-Pop, some
user specifications on the assumed distributions of Funbound.plasma and
Clint, draw "individual" values of Funbound.plasma and Clint from those
distributions.
}
\author{
Caroline Ring and John Wambaugh
}
